/*
 * Decompiled with CFR 0.152.
 */
package com.tomclaw.mandarin.icq;

import com.tomclaw.mandarin.core.Handler;
import com.tomclaw.mandarin.dc.DirectConnection;
import com.tomclaw.mandarin.icq.IcqAccountRoot;
import com.tomclaw.mandarin.icq.Snac;
import com.tomclaw.mandarin.main.MidletMain;
import com.tomclaw.mandarin.net.NetConnection;
import com.tomclaw.utils.ArrayUtil;
import com.tomclaw.utils.DataUtil;
import com.tomclaw.utils.HexUtil;
import com.tomclaw.utils.LogUtil;
import com.tomclaw.utils.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class IcqDirectConnection
implements DirectConnection {
    public String proxyIp = null;
    public byte[] proxyIpBytes = null;
    public int proxyPort = -1;
    public byte[] fileName = null;
    public long fileByteSize = -1L;
    public String buddyId;
    public byte[] icbmCookie = new byte[8];
    public NetConnection localProxyConnection = null;
    public boolean isReceivingFile = false;
    public byte seqNumber = 1;
    public boolean remoteProxyConnectionSentFlag = false;
    public boolean isComplete = false;
    public boolean isError = false;
    public String statusString = "NO_STATUS";
    public int percentValue = 0;
    public int speed = 0;
    public int bufferSize = 512;
    public String fileLocation = null;
    public boolean isStop = false;
    public IcqAccountRoot icqAccountRoot = null;

    public IcqDirectConnection(IcqAccountRoot icqAccountRoot) {
        this.icqAccountRoot = icqAccountRoot;
    }

    public String getBuddyId() {
        return this.buddyId;
    }

    public byte[] getFileName() {
        return this.fileName;
    }

    public long getFileByteSize() {
        return this.fileByteSize;
    }

    public String getProxyIp() {
        return this.proxyIp;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getStatusString() {
        return this.statusString;
    }

    public int getPercentValue() {
        return this.percentValue;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void sendStop() throws IOException {
        this.sendMessageType((byte)1);
    }

    public boolean isErrorFlag() {
        return this.isError;
    }

    public boolean isReceivingFileFlag() {
        return this.isReceivingFile;
    }

    public boolean isCompleteFlag() {
        return this.isComplete;
    }

    public boolean isStopFlag() {
        return this.isStop;
    }

    public void setIsReceivingFile(boolean isReceivingFile) {
        this.isReceivingFile = isReceivingFile;
    }

    public boolean equals(DirectConnection directConnection) {
        return directConnection instanceof IcqDirectConnection && ArrayUtil.equals(((IcqDirectConnection)directConnection).icbmCookie, this.icbmCookie);
    }

    public byte[] getSessCookie() {
        return this.icbmCookie;
    }

    public void sendFile() throws IOException, InterruptedException {
        this.sendFileViaProxy();
        this.waitForProxyReady();
    }

    public void setTransactionInfo(byte[] fileName, String fileLocation, long fileByteSize, String buddyId) {
        this.fileName = fileName;
        this.fileLocation = fileLocation;
        this.fileByteSize = fileByteSize;
        this.buddyId = buddyId;
    }

    public void generateCookie() {
        DataUtil.nextBytes(this.icbmCookie);
    }

    public void sendMessageType(byte msgType) throws IOException {
        this.statusString = "SEND_FILE_ACCEPT";
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        LogUtil.outMessage("sendFileAccept");
        LogUtil.outMessage("buddyId=" + this.buddyId);
        LogUtil.outMessage("icbmCookie=" + HexUtil.bytesToString(this.icbmCookie));
        Snac p = new Snac(4, 6, 0, 0, 7L);
        p.addByteArray(this.icbmCookie);
        p.addWord(2);
        p.addByte(this.buddyId.length());
        p.addByteArray(this.buddyId.getBytes());
        p.addWord(5);
        ArrayUtil buffer = new ArrayUtil();
        buffer.append(new byte[]{0, msgType});
        buffer.append(this.icbmCookie);
        buffer.append(new byte[]{9, 70, 19, 67, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
        p.addWord(buffer.length());
        p.addByteArray(buffer.byteString);
        try {
            p.send(this.icqAccountRoot.session.getNetworkConnection().outputStream, this.icqAccountRoot.session.getNextSeq());
            if (msgType == 2) {
                this.statusString = "FILE_ACCEPT_SENT";
            } else if (msgType == 1) {
                this.statusString = "STOPPED";
                this.isStop = true;
            }
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        }
        catch (IOException ex1) {
            this.statusString = "IO_EXCEPTION";
            this.isError = true;
            Handler.updateTransactions(this.icqAccountRoot);
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        }
    }

    public void requestProxyIpPort() throws IOException, InterruptedException {
        this.statusString = "REQUEST_PROXY";
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        this.localProxyConnection = new NetConnection();
        this.localProxyConnection.connectAddress("ars.icq.com", 5190);
        LogUtil.outMessage("Connected to ars.icq.com");
        Snac snac = new Snac(0, 0, 0, 0);
        snac.addWord(1098);
        snac.addWord(2);
        snac.addWord(0);
        snac.addWord(0);
        snac.addWord(0);
        snac.addByte(this.icqAccountRoot.userId.length());
        snac.addByteArray(this.icqAccountRoot.userId.getBytes());
        snac.addByteArray(this.icbmCookie);
        snac.addWord(1);
        snac.addWord(16);
        snac.addByteArray(new byte[]{9, 70, 19, 67, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
        ArrayUtil proxyPacket = new ArrayUtil();
        byte[] packetSize = new byte[2];
        DataUtil.put16(packetSize, 0, snac.getByteArray().toByteArray().length - 10);
        proxyPacket.append(packetSize);
        proxyPacket.append(new ArrayUtil(snac.getByteArray().toByteArray()).subarray(10, snac.getByteArray().toByteArray().length));
        this.localProxyConnection.write(proxyPacket.byteString);
        this.localProxyConnection.flush();
        byte[] proxyServerPacket = this.localProxyConnection.read(2);
        int length = DataUtil.get16(proxyServerPacket, 0);
        proxyServerPacket = this.localProxyConnection.read(length);
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(proxyServerPacket, "proxyServerPacket ");
        }
        int offset = 0;
        int protVer = DataUtil.get16(proxyServerPacket, offset);
        int cmdType = DataUtil.get16(proxyServerPacket, offset += 2);
        int unk1 = DataUtil.get16(proxyServerPacket, offset += 2);
        int unk2 = DataUtil.get16(proxyServerPacket, offset += 2);
        int flags = DataUtil.get16(proxyServerPacket, offset += 2);
        if (cmdType == 3) {
            this.proxyPort = DataUtil.get16(proxyServerPacket, offset += 2);
            this.proxyIpBytes = DataUtil.getByteArray(proxyServerPacket, offset += 2, 4);
            this.proxyIp = DataUtil.get8int(this.proxyIpBytes, 0) + "." + DataUtil.get8int(this.proxyIpBytes, 1) + "." + DataUtil.get8int(this.proxyIpBytes, 2) + "." + DataUtil.get8int(this.proxyIpBytes, 3);
            this.statusString = "REQUEST_RETREIVED";
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        } else {
            this.statusString = "PROXY_ERROR";
            this.isError = true;
            Handler.updateTransactions(this.icqAccountRoot);
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        }
    }

    public void sendFileViaProxy() throws IOException, InterruptedException {
        this.statusString = "SENDING_REQUEST";
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        Snac p = new Snac(4, 6, 0, 0, 7L);
        this.requestProxyIpPort();
        p.addByteArray(this.icbmCookie);
        p.addWord(2);
        p.addByte(this.buddyId.length());
        p.addByteArray(this.buddyId.getBytes());
        p.addWord(5);
        ArrayUtil buffer = new ArrayUtil();
        buffer.append(new byte[]{0, 0});
        buffer.append(this.icbmCookie);
        buffer.append(new byte[]{9, 70, 19, 67, 76, 127, 17, -47, -126, 34, 68, 69, 83, 84, 0, 0});
        buffer.append(new byte[]{0, 10, 0, 2, 0, this.seqNumber});
        this.seqNumber = (byte)(this.seqNumber + 1);
        buffer.append(new byte[]{0, 15, 0, 0});
        buffer.append(new byte[]{0, 13, 0, 5});
        buffer.append("utf-8".getBytes());
        String invTextValue = "&lt;ICQ_COOL_FT&gt;&lt;FS&gt;" + new String(this.fileName) + "&lt;/FS&gt;&lt;S&gt;" + this.fileByteSize + "&lt;/S&gt;&lt;SID&gt;1&lt;/SID&gt;&lt;DESC&gt;&lt;/DESC&gt;&lt;/ICQ_COOL_FT&gt;";
        byte[] invTextSize = new byte[2];
        DataUtil.put16(invTextSize, 0, invTextValue.length());
        buffer.append(new byte[]{0, 12});
        buffer.append(invTextSize);
        buffer.append(invTextValue.getBytes());
        LogUtil.outMessage("socket.getAddress()=" + this.proxyIp);
        byte[] rendezvouzIp = new byte[4];
        DataUtil.put8(rendezvouzIp, 0, this.proxyIpBytes[0]);
        DataUtil.put8(rendezvouzIp, 1, this.proxyIpBytes[1]);
        DataUtil.put8(rendezvouzIp, 2, this.proxyIpBytes[2]);
        DataUtil.put8(rendezvouzIp, 3, this.proxyIpBytes[3]);
        buffer.append(new byte[]{0, 2, 0, 4});
        buffer.append(rendezvouzIp);
        byte[] port = new byte[2];
        DataUtil.put16(port, 0, this.proxyPort);
        buffer.append(new byte[]{0, 5, 0, 2});
        buffer.append(port);
        byte[] mime = new byte[]{0, 21, 0, 2};
        byte[] mimeData = new byte[2];
        DataUtil.put16(mimeData, 0, 63080);
        buffer.append(mime);
        buffer.append(mimeData);
        byte[] ext = new byte[]{0, 1, 0, 1};
        byte[] size = new byte[4];
        DataUtil.put32(size, 0, this.fileByteSize);
        buffer.append(new byte[]{39, 17});
        byte[] tlvSize = new byte[2];
        DataUtil.put16(tlvSize, 0, ext.length + size.length + this.fileName.length + 1);
        buffer.append(tlvSize);
        buffer.append(ext);
        buffer.append(size);
        buffer.append(this.fileName);
        buffer.append(new byte[]{0});
        buffer.append(new byte[]{39, 18, 0, 5});
        buffer.append("utf-8".getBytes());
        buffer.append(new byte[]{0, 16, 0, 0});
        buffer.append(new byte[]{39, 19, 0, 8, 0, 0, 0, 0});
        buffer.append(size);
        p.addWord(buffer.length());
        p.addByteArray(buffer.byteString);
        try {
            p.send(this.icqAccountRoot.session.getNetworkConnection().outputStream, this.icqAccountRoot.session.getNextSeq());
        }
        catch (IOException ex1) {
            this.statusString = "IO_EXCEPTION";
            this.isError = true;
            Handler.updateTransactions(this.icqAccountRoot);
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        }
    }

    public void sendToCreatedProxy() {
        try {
            LogUtil.outMessage("sendToCreatedProxy " + this.proxyIp + " and buddy " + this.buddyId);
            LogUtil.outMessage(this.proxyIp + ":" + this.proxyPort);
            LogUtil.outMessage("No errors");
            this.statusString = "PROCESSING_FILEXFER";
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
            this.processCoolFileXfer(this.localProxyConnection);
            return;
        }
        catch (IOException ex) {
            LogUtil.outMessage("IO Exception: " + ex.getMessage(), true);
        }
        catch (InterruptedException ex) {
            LogUtil.outMessage("InterruptedException: " + ex.getMessage(), true);
        }
        this.statusString = "IO_EXCEPTION";
        this.isError = true;
        Handler.updateTransactions(this.icqAccountRoot);
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
    }

    public void sendToRemoteProxy(int[] externalIp, int dcTcpPort) {
        DataUtil.put8(this.proxyIpBytes, 0, externalIp[0]);
        DataUtil.put8(this.proxyIpBytes, 1, externalIp[1]);
        DataUtil.put8(this.proxyIpBytes, 2, externalIp[2]);
        DataUtil.put8(this.proxyIpBytes, 3, externalIp[3]);
        this.proxyIp = externalIp[0] + "." + externalIp[1] + "." + externalIp[2] + "." + externalIp[3];
        this.proxyPort = dcTcpPort;
        this.sendToRemoteProxy(false);
    }

    /*
     * Exception decompiling
     */
    public void sendToRemoteProxy(boolean isUseLocalConnection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void processFileReceive(NetConnection dcConnection) throws IOException, InterruptedException {
        OutputStream outputStream;
        FileConnection fileConnection;
        this.statusString = "RECEIVING_FILE";
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        LogUtil.outMessage("Ready to receive");
        byte[] proxyServerPacket = dcConnection.read(256);
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(proxyServerPacket, "proxyServerPacket ");
        }
        DataUtil.put16(proxyServerPacket, 6, 514);
        dcConnection.write(proxyServerPacket);
        dcConnection.flush();
        LogUtil.outMessage("Acknowledge sent");
        LogUtil.outMessage("Receiving file: " + (int)this.fileByteSize);
        try {
            fileConnection = (FileConnection)Connector.open((String)("file://" + MidletMain.incomingFilesFolder + StringUtil.byteArrayToString(this.fileName, true)), (int)3);
            if (fileConnection.exists()) {
                fileConnection.delete();
            }
            fileConnection.create();
            outputStream = fileConnection.openOutputStream();
        }
        catch (Throwable ex1) {
            LogUtil.outMessage("Local file error: " + ex1.getMessage(), true);
            this.statusString = "LOCAL_ERROR";
            this.isError = true;
            Handler.updateTransactions(this.icqAccountRoot);
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
            return;
        }
        long dataBytesRead = this.fileByteSize > 8L ? 8L : this.fileByteSize;
        LogUtil.outMessage("dataBytesRead=" + dataBytesRead);
        byte[] dataStart = dcConnection.read((int)dataBytesRead);
        if (ArrayUtil.equals(dataStart, new byte[]{79, 70, 84, 50, 1, 0, 1, 1}, (int)dataBytesRead)) {
            dcConnection.read(256 - (int)dataBytesRead);
        } else {
            outputStream.write(dataStart);
            outputStream.flush();
        }
        byte[] buffer = new byte[this.bufferSize];
        long startTime = System.currentTimeMillis();
        while (dataBytesRead < this.fileByteSize) {
            int receivedBytes = dcConnection.inputStream.read(buffer);
            outputStream.write(buffer, 0, receivedBytes);
            outputStream.flush();
            MidletMain.incrementDataCount(receivedBytes);
            this.percentValue = (int)((dataBytesRead += (long)receivedBytes) * 100L / this.fileByteSize);
            if (System.currentTimeMillis() - startTime > 1000L) {
                this.speed = (int)(8000L * dataBytesRead / (System.currentTimeMillis() - startTime)) / 1024;
            }
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
            if (!this.isStop) continue;
            outputStream.close();
            fileConnection.close();
            dcConnection.disconnect();
            this.isError = true;
            Handler.updateTransactions(this.icqAccountRoot);
            return;
        }
        outputStream.close();
        fileConnection.close();
        DataUtil.put16(proxyServerPacket, 6, 516);
        try {
            dcConnection.write(proxyServerPacket);
            dcConnection.flush();
        }
        catch (IOException ex1) {
            // empty catch block
        }
        LogUtil.outMessage("Receiving complete");
        this.statusString = "RECEIVING_COMPLETE";
        this.isComplete = true;
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        Handler.updateTransactions(this.icqAccountRoot);
        dcConnection.disconnect();
    }

    public void waitForProxyReady() {
        this.statusString = "WAITING_FOR_PROXY_READY";
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        try {
            byte[] lengthData = this.localProxyConnection.read(2);
            int offset = 0;
            int length = DataUtil.get16(lengthData, offset);
            byte[] proxyData = this.localProxyConnection.read(length);
            int packVer = DataUtil.get16(proxyData, offset);
            int cmdType = DataUtil.get16(proxyData, offset += 2);
            int unk1 = DataUtil.get16(proxyData, offset += 2);
            int unk2 = DataUtil.get16(proxyData, offset += 2);
            int flags = DataUtil.get16(proxyData, offset += 2);
            if (MidletMain.logLevel == 1) {
                HexUtil.dump_(proxyData, "proxyData ");
                LogUtil.outMessage("packVer=" + packVer);
                LogUtil.outMessage("cmdType=" + cmdType);
                LogUtil.outMessage("unk1=" + unk1);
                LogUtil.outMessage("unk2=" + unk2);
                LogUtil.outMessage("flags=" + flags);
            }
            if (cmdType == 1) {
                int errCode = DataUtil.get16(proxyData, offset += 2);
                LogUtil.outMessage("errCode=" + cmdType);
                this.statusString = "PROXY_ERROR";
                this.isError = true;
                Handler.updateTransactions(this.icqAccountRoot);
                Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
            } else if (cmdType == 5) {
                this.sendToCreatedProxy();
            }
            return;
        }
        catch (IOException ex) {
            LogUtil.outMessage("IOException: " + ex.getMessage(), true);
        }
        catch (InterruptedException ex) {
            LogUtil.outMessage("InterruptedException: " + ex.getMessage(), true);
        }
        catch (IndexOutOfBoundsException ex) {
            LogUtil.outMessage("IndexOutOfBoundsException: " + ex.getMessage(), true);
        }
        this.statusString = "IO_EXCEPTION";
        this.isError = true;
        Handler.updateTransactions(this.icqAccountRoot);
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
    }

    public void processCoolFileXfer(NetConnection dcConnection) throws IOException, InterruptedException {
        InputStream inputStream;
        FileConnection fileConnection;
        this.statusString = "SENDING_HEADER";
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        Snac snac = new Snac(0, 0, 0, 0);
        snac.addDWord(1330009138L);
        snac.addWord(256);
        snac.addWord(257);
        snac.addByteArray(this.icbmCookie);
        snac.addWord(0);
        snac.addWord(0);
        snac.addWord(1);
        snac.addWord(1);
        snac.addWord(1);
        snac.addWord(1);
        snac.addDWord(this.fileByteSize);
        snac.addDWord(this.fileByteSize);
        snac.addDWord(1121531844L);
        snac.addDWord(-290521088L);
        snac.addDWord(-65536L);
        snac.addDWord(0L);
        snac.addDWord(0L);
        snac.addDWord(-65536L);
        snac.addDWord(0L);
        snac.addDWord(-65536L);
        snac.addByteArray("Cool FileXfer".getBytes());
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        snac.addDWord(0L);
        snac.addByte(32);
        snac.addByte(28);
        snac.addByte(17);
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0});
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        snac.addByteArray(new byte[]{0, 0});
        snac.addByteArray(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        snac.addWord(0);
        snac.addWord(0);
        snac.addByteArray(this.fileName);
        snac.addByteArray(new byte[64 - this.fileName.length]);
        dcConnection.write(new ArrayUtil(snac.getByteArray().toByteArray()).subarray(10, snac.getByteArray().toByteArray().length));
        dcConnection.flush();
        byte[] proxyServerPacket = dcConnection.read(256);
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(proxyServerPacket, "proxyServerPacket ");
        }
        this.statusString = "TRANSFERING_FILE";
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        try {
            LogUtil.outMessage("Full file path: ".concat("file://" + this.fileLocation + StringUtil.byteArrayToString(this.fileName, true)));
            fileConnection = (FileConnection)Connector.open((String)("file://" + this.fileLocation + StringUtil.byteArrayToString(this.fileName, true)), (int)1);
            if (!fileConnection.exists()) {
                LogUtil.outMessage("File not exist", true);
                this.statusString = "FILE_NOT_EXIST";
                this.isError = true;
                Handler.updateTransactions(this.icqAccountRoot);
                Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
                return;
            }
            inputStream = fileConnection.openInputStream();
        }
        catch (Throwable ex1) {
            LogUtil.outMessage("Local file error: " + ex1.getMessage(), true);
            this.statusString = "LOCAL_ERROR";
            this.isError = true;
            Handler.updateTransactions(this.icqAccountRoot);
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
            return;
        }
        long fileSentBytes = 0L;
        byte[] buffer = new byte[this.bufferSize];
        long startTime = System.currentTimeMillis();
        while (fileSentBytes < this.fileByteSize) {
            int bufferRead = inputStream.read(buffer);
            dcConnection.write(buffer, 0, bufferRead);
            dcConnection.flush();
            MidletMain.incrementDataCount(bufferRead);
            this.percentValue = (int)((fileSentBytes += (long)bufferRead) * 100L / this.fileByteSize);
            if (System.currentTimeMillis() - startTime > 1000L) {
                this.speed = (int)(8000L * fileSentBytes / (System.currentTimeMillis() - startTime)) / 1024;
            }
            Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
            if (!this.isStop) continue;
            inputStream.close();
            fileConnection.close();
            dcConnection.disconnect();
            this.isError = true;
            Handler.updateTransactions(this.icqAccountRoot);
            return;
        }
        LogUtil.outMessage("Transfering complete");
        this.statusString = "TRANSFERING_COMPLETE";
        this.isComplete = true;
        Handler.updateTransactionInfo(this.icqAccountRoot, this.icbmCookie);
        Handler.updateTransactions(this.icqAccountRoot);
        proxyServerPacket = dcConnection.read(256);
        if (MidletMain.logLevel == 1) {
            HexUtil.dump_(proxyServerPacket, "proxyServerPacket ");
        }
        dcConnection.disconnect();
    }
}

