/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.CRunApp;
import Banks.CImage;
import Events.CEventProgram;
import Frame.CLO;
import Frame.CLOList;
import Frame.CLayer;
import OI.COC;
import OI.COCBackground;
import OI.COI;
import OI.CObjectCommon;
import Objects.CObject;
import RunLoop.CBkd2;
import RunLoop.CRun;
import Services.CChunk;
import Services.CRect;
import Sprites.CColMask;
import Sprites.CMask;
import Sprites.CPSCM;
import Sprites.CSprite;
import Transitions.CTrans;
import Transitions.CTransitionData;

public class CRunFrame {
    CRunApp app;
    CRun rhPtr;
    public static final int LEF_DISPLAYNAME = 1;
    public static final int LEF_GRABDESKTOP = 2;
    public static final int LEF_KEEPDISPLAY = 4;
    public static final int LEF_TOTALCOLMASK = 32;
    public static final int LEF_RESIZEATSTART = 256;
    public static final int LEF_NOSURFACE = 2048;
    public static final int LEF_TIMEDMVTS = 32768;
    public int leWidth;
    public int leHeight;
    public int leBackground;
    public int leFlags;
    public CRect leVirtualRect;
    public int leEditWinWidth;
    public int leEditWinHeight;
    public String frameName = null;
    public int nLayers;
    public CLayer[] layers;
    public CLOList LOList;
    public CEventProgram evtProg;
    public short maxObjects;
    public int leX;
    public int leY;
    public int leLastScrlX;
    public int leLastScrlY;
    public int levelQuit;
    public boolean rhOK;
    public int startLeX;
    public int startLeY;
    public boolean fade = false;
    public long fadeTimerDelta;
    public int fadeVblDelta;
    public int dwColMaskBits;
    public CColMask colMask = null;
    public short m_wRandomSeed;
    public int frameAlpha = 0;
    public int keyTimeOut = 500;
    public int m_dwMvtTimerBase;
    public CTransitionData fadeIn = null;
    public CTransitionData fadeOut = null;
    public CTrans pTrans = null;

    public CRunFrame() {
    }

    public CRunFrame(CRunApp cRunApp) {
        this.app = cRunApp;
    }

    public boolean loadFullFrame(int n) {
        CLO cLO;
        int n2;
        this.app.file.seek(this.app.frameOffsets[n]);
        this.evtProg = new CEventProgram();
        this.LOList = new CLOList();
        this.leVirtualRect = new CRect();
        CChunk cChunk = new CChunk();
        int n3 = 0;
        int n4 = 0;
        this.m_wRandomSeed = (short)-1;
        while (cChunk.chID != 32639) {
            cChunk.readHeader(this.app.file);
            if (cChunk.chSize == 0) continue;
            long l = this.app.file.getFilePointer() + (long)cChunk.chSize;
            switch (cChunk.chID) {
                case 13108: {
                    this.loadHeader();
                    if ((this.leFlags & 0x100) != 0) {
                        n3 = this.leWidth;
                        n4 = this.leHeight;
                        this.leWidth = this.app.canvasWidth;
                        this.leHeight = this.app.canvasHeight;
                        this.leVirtualRect.top = 0;
                        this.leVirtualRect.left = 0;
                        this.leVirtualRect.right = this.leWidth;
                        this.leVirtualRect.bottom = this.leHeight;
                    }
                    if ((this.leFlags & 0x100) != 0) {
                        this.leEditWinWidth = this.app.canvas.getWidth();
                        this.leEditWinHeight = this.app.canvas.getHeight();
                        break;
                    }
                    this.leEditWinWidth = Math.min(this.app.gaCxWin, this.leWidth);
                    this.leEditWinHeight = Math.min(this.app.gaCyWin, this.leHeight);
                    break;
                }
                case 13122: {
                    this.leVirtualRect.load(this.app.file);
                    if ((this.leFlags & 0x100) == 0) break;
                    if (this.leVirtualRect.right - this.leVirtualRect.left == n3 || this.leVirtualRect.right - this.leVirtualRect.left < this.leWidth) {
                        this.leVirtualRect.right = this.leVirtualRect.left + this.leWidth;
                    }
                    if (this.leVirtualRect.bottom - this.leVirtualRect.top != n4 && this.leVirtualRect.bottom - this.leVirtualRect.top >= this.leHeight) break;
                    this.leVirtualRect.bottom = this.leVirtualRect.top + this.leHeight;
                    break;
                }
                case 13124: {
                    this.m_wRandomSeed = this.app.file.readAShort();
                    break;
                }
                case 13127: {
                    this.m_dwMvtTimerBase = this.app.file.readAInt();
                    break;
                }
                case 13109: {
                    this.frameName = this.app.file.readAString();
                    break;
                }
                case 13111: {
                    break;
                }
                case 13121: {
                    this.loadLayers();
                    break;
                }
                case 13112: {
                    this.LOList.load(this.app);
                    break;
                }
                case 13120: {
                    break;
                }
                case 13117: {
                    this.evtProg.load(this.app);
                    this.maxObjects = this.evtProg.maxObjects;
                    break;
                }
                case 13126: {
                    this.frameAlpha = this.app.file.readAInt();
                    this.keyTimeOut = this.app.file.readAInt();
                    break;
                }
                case 13115: {
                    this.fadeIn = new CTransitionData();
                    this.fadeIn.load(this.app.file);
                    break;
                }
                case 13116: {
                    this.fadeOut = new CTransitionData();
                    this.fadeOut.load(this.app.file);
                }
            }
            this.app.file.seek(l);
        }
        this.app.OIList.resetToLoad();
        for (n2 = 0; n2 < this.LOList.nIndex; ++n2) {
            cLO = this.LOList.getLOFromIndex((short)n2);
            this.app.OIList.setToLoad(cLO.loOiHandle);
        }
        this.app.imageBank.resetToLoad();
        this.app.fontBank.resetToLoad();
        this.app.OIList.load(this.app.file);
        this.app.OIList.enumElements(this.app.imageBank, this.app.fontBank);
        this.app.imageBank.load(this.app.file);
        this.app.fontBank.load(this.app.file);
        this.evtProg.enumSounds(this.app.soundBank, this.app.musicBank);
        this.app.soundBank.load(this.app.soundPlayer);
        this.app.musicBank.load(this.app.musicPlayer);
        this.app.OIList.resetOICurrent();
        for (n2 = 0; n2 < this.LOList.nIndex; ++n2) {
            cLO = this.LOList.list[n2];
            if (cLO.loType < 2) continue;
            this.app.OIList.setOICurrent(cLO.loOiHandle);
        }
        return true;
    }

    public void loadLayers() {
        this.nLayers = this.app.file.readAInt();
        this.layers = new CLayer[this.nLayers];
        for (int i = 0; i < this.nLayers; ++i) {
            this.layers[i] = new CLayer();
            this.layers[i].load(this.app.file);
        }
    }

    public void loadHeader() {
        this.leWidth = this.app.file.readAInt();
        this.leHeight = this.app.file.readAInt();
        this.leBackground = this.app.file.readAColor();
        this.leFlags = this.app.file.readAInt();
    }

    public int getMaskBits() {
        int n = 0;
        block8: for (int i = 0; i < this.LOList.nIndex; ++i) {
            COC cOC;
            CLO cLO = this.LOList.getLOFromIndex((short)i);
            if (cLO.loLayer > 0) break;
            COI cOI = this.app.OIList.getOIFromHandle(cLO.loOiHandle);
            if (cOI.oiType < 2) {
                cOC = cOI.oiOC;
                switch (cOC.ocObstacleType) {
                    case 1: {
                        n |= 1;
                        break;
                    }
                    case 2: {
                        n |= 2;
                    }
                }
                continue;
            }
            cOC = (CObjectCommon)cOI.oiOC;
            if ((((CObjectCommon)cOC).ocOEFlags & 2) == 0) continue;
            switch ((((CObjectCommon)cOC).ocFlags2 & 0x30) >> 4) {
                case 1: {
                    n |= 1;
                    continue block8;
                }
                case 2: {
                    n |= 2;
                }
            }
        }
        return n;
    }

    public boolean bkdLevObjCol_TestPoint(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        CRect cRect = new CRect();
        if (n3 == -1) {
            n6 = 1;
            n5 = this.nLayers - 1;
        } else {
            if (n3 >= this.nLayers) {
                return false;
            }
            n6 = n5 = n3;
        }
        int n7 = this.leWidth;
        int n8 = this.leHeight;
        for (int i = n6; i <= n5; ++i) {
            CImage cImage;
            CMask cMask;
            short s;
            int n9;
            Object object;
            int n10;
            CLayer cLayer = this.layers[i];
            boolean bl = (cLayer.dwOptions & 0x20) != 0;
            boolean bl2 = (cLayer.dwOptions & 0x40) != 0;
            boolean bl3 = bl | bl2;
            int n11 = this.leX;
            int n12 = this.leY;
            if ((cLayer.dwOptions & 3) != 0) {
                if ((cLayer.dwOptions & 1) != 0) {
                    n11 = (int)((float)n11 * cLayer.xCoef);
                }
                if ((cLayer.dwOptions & 2) != 0) {
                    n12 = (int)((float)n12 * cLayer.yCoef);
                }
            }
            n11 += cLayer.x;
            n12 += cLayer.y;
            if (bl) {
                n11 %= n7;
            }
            if (bl2) {
                n12 %= n8;
            }
            int n13 = 0;
            int n14 = 0;
            int n15 = cLayer.nBkdLOs;
            for (n10 = 0; n10 < n15; ++n10) {
                object = this.LOList.getLOFromIndex((short)(cLayer.nFirstLOIndex + n10));
                CObject cObject = null;
                COI cOI = this.app.OIList.getOIFromHandle(((CLO)object).loOiHandle);
                if (cOI == null || cOI.oiOC == null) continue;
                COC cOC = cOI.oiOC;
                short s2 = cOI.oiType;
                cRect.left = ((CLO)object).loX - n11;
                cRect.top = ((CLO)object).loY - n12;
                if (s2 < 2) {
                    n9 = cOC.ocObstacleType;
                    if (n9 == 0 || n9 == 3 || n9 == 4) continue;
                    s = cOC.ocColMode;
                    cRect.right = cRect.left + cOC.ocCx;
                    cRect.bottom = cRect.top + cOC.ocCy;
                } else {
                    CObjectCommon cObjectCommon = (CObjectCommon)cOC;
                    if ((cObjectCommon.ocOEFlags & 2) == 0 || (cObject = this.rhPtr.find_HeaderObject(((CLO)object).loHandle)) == null || (n9 = (cObjectCommon.ocFlags2 & 0x30) >> 4) == 0 || n9 == 3 || n9 == 4) continue;
                    s = (cObjectCommon.ocFlags2 & 4) != 0 ? (short)1 : 0;
                    cRect.left = cObject.hoX - this.leX - cObject.hoImgXSpot;
                    cRect.top = cObject.hoY - this.leY - cObject.hoImgYSpot;
                    cRect.right = cRect.left + cObject.hoImgWidth;
                    cRect.bottom = cRect.top + cObject.hoImgHeight;
                }
                if (bl3) {
                    switch (n14) {
                        case 0: {
                            if (bl && (cRect.left < 0 || cRect.right > n7)) {
                                if (bl2 && (cRect.top < 0 || cRect.bottom > n8)) {
                                    n14 = 3;
                                    n13 |= 7;
                                    break;
                                }
                                n14 = 1;
                                n13 |= 1;
                                break;
                            }
                            if (!bl2 || cRect.top >= 0 && cRect.bottom <= n8) break;
                            n14 = 2;
                            n13 |= 2;
                            break;
                        }
                        case 1: {
                            if (cRect.left < 0) {
                                int n16 = n7;
                                cRect.left += n16;
                                cRect.right += n16;
                            } else if (cRect.right > n7) {
                                int n17 = n7;
                                cRect.left -= n17;
                                cRect.right -= n17;
                            }
                            n14 = 0;
                            if (((n13 &= 0xFFFFFFFE) & 2) == 0) break;
                            n14 = 2;
                            break;
                        }
                        case 2: {
                            if (cRect.top < 0) {
                                int n18 = n8;
                                cRect.top += n18;
                                cRect.bottom += n18;
                            } else if (cRect.bottom > n8) {
                                int n19 = n8;
                                cRect.top -= n19;
                                cRect.bottom -= n19;
                            }
                            n14 = 0;
                            if (((n13 &= 0xFFFFFFFD) & 1) == 0) break;
                            n14 = 1;
                            break;
                        }
                        case 3: {
                            if (cRect.left < 0) {
                                int n20 = n7;
                                cRect.left += n20;
                                cRect.right += n20;
                            } else if (cRect.right > n7) {
                                int n21 = n7;
                                cRect.left -= n21;
                                cRect.right -= n21;
                            }
                            if (cRect.top < 0) {
                                int n22 = n8;
                                cRect.top += n22;
                                cRect.bottom += n22;
                            } else if (cRect.bottom > n8) {
                                int n23 = n8;
                                cRect.top -= n23;
                                cRect.bottom -= n23;
                            }
                            n13 &= 0xFFFFFFFB;
                            n14 = 2;
                        }
                    }
                }
                if (n >= cRect.left && n2 >= cRect.top && n < cRect.right && n2 < cRect.bottom && (n9 != 2 || n4 != 0)) {
                    if (s != 0) {
                        return true;
                    }
                    int n24 = CMask.GCMF_OBSTACLE;
                    if (n9 == 2) {
                        n24 = CMask.GCMF_PLATFORM;
                    }
                    cMask = null;
                    if (s2 < 2) {
                        cImage = this.app.imageBank.getImageFromHandle(((COCBackground)cOC).ocImage);
                        cMask = cImage.getMask(n24);
                    } else {
                        cMask = cObject.getCollisionMask(n24);
                    }
                    if (cMask == null) {
                        return true;
                    }
                    if (cMask.testPoint(n - cRect.left, n2 - cRect.top)) {
                        return true;
                    }
                }
                if (n13 == 0) continue;
                --n10;
            }
            if (cLayer.pBkd2 == null) continue;
            n13 = 0;
            n14 = 0;
            for (n10 = 0; n10 < cLayer.pBkd2.size(); ++n10) {
                int n25;
                object = (CBkd2)cLayer.pBkd2.get(n10);
                cRect.left = ((CBkd2)object).x - n11;
                cRect.top = ((CBkd2)object).y - n12;
                n9 = ((CBkd2)object).obstacleType;
                if (n9 == 0 || n9 == 3 || n9 == 4) continue;
                s = ((CBkd2)object).colMode == 0 ? (short)1 : 0;
                cImage = this.app.imageBank.getImageFromHandle(((CBkd2)object).img);
                if (cImage != null) {
                    cRect.right = cRect.left + cImage.width;
                    cRect.bottom = cRect.top + cImage.height;
                } else {
                    cRect.right = cRect.left + 1;
                    cRect.bottom = cRect.top + 1;
                }
                if (bl3) {
                    switch (n14) {
                        case 0: {
                            if (bl && (cRect.left < 0 || cRect.right > n7)) {
                                if (bl2 && (cRect.top < 0 || cRect.bottom > n8)) {
                                    n14 = 3;
                                    n13 |= 7;
                                    break;
                                }
                                n14 = 1;
                                n13 |= 1;
                                break;
                            }
                            if (!bl2 || cRect.top >= 0 && cRect.bottom <= n8) break;
                            n14 = 2;
                            n13 |= 2;
                            break;
                        }
                        case 1: {
                            if (cRect.left < 0) {
                                n25 = n7;
                                cRect.left += n25;
                                cRect.right += n25;
                            } else if (cRect.right > n7) {
                                n25 = n7;
                                cRect.left -= n25;
                                cRect.right -= n25;
                            }
                            n14 = 0;
                            if (((n13 &= 0xFFFFFFFE) & 2) == 0) break;
                            n14 = 2;
                            break;
                        }
                        case 2: {
                            if (cRect.top < 0) {
                                n25 = n8;
                                cRect.top += n25;
                                cRect.bottom += n25;
                            } else if (cRect.bottom > n8) {
                                n25 = n8;
                                cRect.top -= n25;
                                cRect.bottom -= n25;
                            }
                            n14 = 0;
                            if (((n13 &= 0xFFFFFFFD) & 1) == 0) break;
                            n14 = 1;
                            break;
                        }
                        case 3: {
                            if (cRect.left < 0) {
                                n25 = n7;
                                cRect.left += n25;
                                cRect.right += n25;
                            } else if (cRect.right > n7) {
                                n25 = n7;
                                cRect.left -= n25;
                                cRect.right -= n25;
                            }
                            if (cRect.top < 0) {
                                n25 = n8;
                                cRect.top += n25;
                                cRect.bottom += n25;
                            } else if (cRect.bottom > n8) {
                                n25 = n8;
                                cRect.top -= n25;
                                cRect.bottom -= n25;
                            }
                            n13 &= 0xFFFFFFFB;
                            n14 = 2;
                        }
                    }
                }
                if (n >= cRect.left && n2 >= cRect.top && n < cRect.right && n2 < cRect.bottom && (n9 != 2 || n4 != 0)) {
                    if (s != 0) {
                        return true;
                    }
                    n25 = CMask.GCMF_OBSTACLE;
                    if (n9 == 2) {
                        n25 = CMask.GCMF_PLATFORM;
                    }
                    if ((cMask = (cImage = this.app.imageBank.getImageFromHandle(((CBkd2)object).img)).getMask(n25)) != null && cMask.testPoint(n - cRect.left, n2 - cRect.top)) {
                        return true;
                    }
                }
                if (n13 == 0) continue;
                --n10;
            }
        }
        return false;
    }

    public boolean bkdLevObjCol_TestRect(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        CRect cRect = new CRect();
        CMask cMask = null;
        if (n5 == -1) {
            n8 = 1;
            n7 = this.nLayers - 1;
        } else {
            if (n5 >= this.nLayers) {
                return false;
            }
            n8 = n7 = n5;
        }
        int n9 = this.leWidth;
        int n10 = this.leHeight;
        for (int i = n8; i <= n7; ++i) {
            CImage cImage;
            short s;
            int n11;
            Object object;
            int n12;
            CLayer cLayer = this.layers[i];
            boolean bl = (cLayer.dwOptions & 0x20) != 0;
            boolean bl2 = (cLayer.dwOptions & 0x40) != 0;
            boolean bl3 = bl | bl2;
            int n13 = this.leX;
            int n14 = this.leY;
            if ((cLayer.dwOptions & 3) != 0) {
                if ((cLayer.dwOptions & 1) != 0) {
                    n13 = (int)((float)n13 * cLayer.xCoef);
                }
                if ((cLayer.dwOptions & 2) != 0) {
                    n14 = (int)((float)n14 * cLayer.yCoef);
                }
            }
            n13 += cLayer.x;
            n14 += cLayer.y;
            if (bl) {
                n13 %= n9;
            }
            if (bl2) {
                n14 %= n10;
            }
            int n15 = 0;
            int n16 = 0;
            int n17 = cLayer.nBkdLOs;
            for (n12 = 0; n12 < n17; ++n12) {
                object = this.LOList.getLOFromIndex((short)(cLayer.nFirstLOIndex + n12));
                CObject cObject = null;
                COI cOI = this.app.OIList.getOIFromHandle(((CLO)object).loOiHandle);
                if (cOI == null || cOI.oiOC == null) continue;
                COC cOC = cOI.oiOC;
                short s2 = cOI.oiType;
                cRect.left = ((CLO)object).loX - n13;
                cRect.top = ((CLO)object).loY - n14;
                if (s2 < 2) {
                    n11 = cOC.ocObstacleType;
                    if (n11 == 0 || n11 == 3 || n11 == 4) continue;
                    s = cOC.ocColMode;
                    cRect.right = cRect.left + cOC.ocCx;
                    cRect.bottom = cRect.top + cOC.ocCy;
                } else {
                    CObjectCommon cObjectCommon = (CObjectCommon)cOC;
                    if ((cObjectCommon.ocOEFlags & 2) == 0 || (cObject = this.rhPtr.find_HeaderObject(((CLO)object).loHandle)) == null || (n11 = (cObjectCommon.ocFlags2 & 0x30) >> 4) == 0 || n11 == 3 || n11 == 4) continue;
                    s = (cObjectCommon.ocFlags2 & 4) != 0 ? (short)1 : 0;
                    cRect.left = cObject.hoX - this.leX - cObject.hoImgXSpot;
                    cRect.top = cObject.hoY - this.leY - cObject.hoImgYSpot;
                    cRect.right = cRect.left + cObject.hoImgWidth;
                    cRect.bottom = cRect.top + cObject.hoImgHeight;
                }
                if (bl3) {
                    switch (n16) {
                        case 0: {
                            if (bl && (cRect.left < 0 || cRect.right > n9)) {
                                if (bl2 && (cRect.top < 0 || cRect.bottom > n10)) {
                                    n16 = 3;
                                    n15 |= 7;
                                    break;
                                }
                                n16 = 1;
                                n15 |= 1;
                                break;
                            }
                            if (!bl2 || cRect.top >= 0 && cRect.bottom <= n10) break;
                            n16 = 2;
                            n15 |= 2;
                            break;
                        }
                        case 1: {
                            if (cRect.left < 0) {
                                int n18 = n9;
                                cRect.left += n18;
                                cRect.right += n18;
                            } else if (cRect.right > n9) {
                                int n19 = n9;
                                cRect.left -= n19;
                                cRect.right -= n19;
                            }
                            n16 = 0;
                            if (((n15 &= 0xFFFFFFFE) & 2) == 0) break;
                            n16 = 2;
                            break;
                        }
                        case 2: {
                            if (cRect.top < 0) {
                                int n20 = n10;
                                cRect.top += n20;
                                cRect.bottom += n20;
                            } else if (cRect.bottom > n10) {
                                int n21 = n10;
                                cRect.top -= n21;
                                cRect.bottom -= n21;
                            }
                            n16 = 0;
                            if (((n15 &= 0xFFFFFFFD) & 1) == 0) break;
                            n16 = 1;
                            break;
                        }
                        case 3: {
                            if (cRect.left < 0) {
                                int n22 = n9;
                                cRect.left += n22;
                                cRect.right += n22;
                            } else if (cRect.right > n9) {
                                int n23 = n9;
                                cRect.left -= n23;
                                cRect.right -= n23;
                            }
                            if (cRect.top < 0) {
                                int n24 = n10;
                                cRect.top += n24;
                                cRect.bottom += n24;
                            } else if (cRect.bottom > n10) {
                                int n25 = n10;
                                cRect.top -= n25;
                                cRect.bottom -= n25;
                            }
                            n15 &= 0xFFFFFFFB;
                            n16 = 2;
                        }
                    }
                }
                if (n + n3 > cRect.left && n2 + n4 > cRect.top && n < cRect.right && n2 < cRect.bottom && (n11 != 2 || n6 != 0)) {
                    if (s != 0) {
                        return true;
                    }
                    int n26 = CMask.GCMF_OBSTACLE;
                    if (n11 == 2) {
                        n26 = CMask.GCMF_PLATFORM;
                    }
                    if (s2 < 2) {
                        cImage = this.app.imageBank.getImageFromHandle(((COCBackground)cOC).ocImage);
                        cMask = cImage.getMask(n26);
                    } else {
                        cMask = cObject.getCollisionMask(n26);
                    }
                    if (cMask == null) {
                        return true;
                    }
                    if (cMask.testRect(0, n - cRect.left, n2 - cRect.top, n3, n4)) {
                        return true;
                    }
                }
                if (n15 == 0) continue;
                --n12;
            }
            if (cLayer.pBkd2 == null) continue;
            n15 = 0;
            n16 = 0;
            for (n12 = 0; n12 < cLayer.pBkd2.size(); ++n12) {
                int n27;
                object = (CBkd2)cLayer.pBkd2.get(n12);
                cRect.left = ((CBkd2)object).x - n13;
                cRect.top = ((CBkd2)object).y - n14;
                n11 = ((CBkd2)object).obstacleType;
                if (n11 == 0 || n11 == 3 || n11 == 4) continue;
                s = ((CBkd2)object).colMode == 0 ? (short)1 : 0;
                cImage = this.app.imageBank.getImageFromHandle(((CBkd2)object).img);
                if (cImage != null) {
                    cRect.right = cRect.left + cImage.width;
                    cRect.bottom = cRect.top + cImage.height;
                } else {
                    cRect.right = cRect.left + 1;
                    cRect.bottom = cRect.top + 1;
                }
                if (bl3) {
                    switch (n16) {
                        case 0: {
                            if (bl && (cRect.left < 0 || cRect.right > n9)) {
                                if (bl2 && (cRect.top < 0 || cRect.bottom > n10)) {
                                    n16 = 3;
                                    n15 |= 7;
                                    break;
                                }
                                n16 = 1;
                                n15 |= 1;
                                break;
                            }
                            if (!bl2 || cRect.top >= 0 && cRect.bottom <= n10) break;
                            n16 = 2;
                            n15 |= 2;
                            break;
                        }
                        case 1: {
                            if (cRect.left < 0) {
                                n27 = n9;
                                cRect.left += n27;
                                cRect.right += n27;
                            } else if (cRect.right > n9) {
                                n27 = n9;
                                cRect.left -= n27;
                                cRect.right -= n27;
                            }
                            n16 = 0;
                            if (((n15 &= 0xFFFFFFFE) & 2) == 0) break;
                            n16 = 2;
                            break;
                        }
                        case 2: {
                            if (cRect.top < 0) {
                                n27 = n10;
                                cRect.top += n27;
                                cRect.bottom += n27;
                            } else if (cRect.bottom > n10) {
                                n27 = n10;
                                cRect.top -= n27;
                                cRect.bottom -= n27;
                            }
                            n16 = 0;
                            if (((n15 &= 0xFFFFFFFD) & 1) == 0) break;
                            n16 = 1;
                            break;
                        }
                        case 3: {
                            if (cRect.left < 0) {
                                n27 = n9;
                                cRect.left += n27;
                                cRect.right += n27;
                            } else if (cRect.right > n9) {
                                n27 = n9;
                                cRect.left -= n27;
                                cRect.right -= n27;
                            }
                            if (cRect.top < 0) {
                                n27 = n10;
                                cRect.top += n27;
                                cRect.bottom += n27;
                            } else if (cRect.bottom > n10) {
                                n27 = n10;
                                cRect.top -= n27;
                                cRect.bottom -= n27;
                            }
                            n15 &= 0xFFFFFFFB;
                            n16 = 2;
                        }
                    }
                }
                if (n + n3 > cRect.left && n2 + n4 > cRect.top && n < cRect.right && n2 < cRect.bottom && (n11 != 2 || n6 != 0)) {
                    if (s != 0) {
                        return true;
                    }
                    n27 = CMask.GCMF_OBSTACLE;
                    if (n11 == 2) {
                        n27 = CMask.GCMF_PLATFORM;
                    }
                    if ((cMask = (cImage = this.app.imageBank.getImageFromHandle(((CBkd2)object).img)).getMask(n27)) != null && cMask.testRect(0, n - cRect.left, n2 - cRect.top, n3, n4)) {
                        return true;
                    }
                }
                if (n15 == 0) continue;
                --n12;
            }
        }
        return false;
    }

    public boolean bkdLevObjCol_TestSprite(CSprite cSprite, short s, int n, int n2, int n3, float f, float f2, int n4, int n5) {
        short s2;
        int n6;
        Object object;
        int n7;
        CImage cImage;
        int n8;
        int n9;
        int n10;
        CRect cRect = new CRect();
        int n11 = cSprite.sprLayer / 2;
        CLayer cLayer = this.layers[n11];
        boolean bl = (cLayer.dwOptions & 0x20) != 0;
        boolean bl2 = (cLayer.dwOptions & 0x40) != 0;
        boolean bl3 = bl | bl2;
        int n12 = this.leWidth;
        int n13 = this.leHeight;
        int n14 = this.leX;
        int n15 = this.leY;
        if ((cLayer.dwOptions & 3) != 0) {
            if ((cLayer.dwOptions & 1) != 0) {
                n14 = (int)((float)n14 * cLayer.xCoef);
            }
            if ((cLayer.dwOptions & 2) != 0) {
                n15 = (int)((float)n15 * cLayer.yCoef);
            }
        }
        n14 += cLayer.x;
        n15 += cLayer.y;
        if (bl) {
            n14 %= n12;
        }
        if (bl2) {
            n15 %= n13;
        }
        boolean bl4 = ((n10 = cSprite.sprFlags) & 0x100) != 0;
        CRect cRect2 = new CRect();
        short s3 = s;
        cRect2.left = n;
        cRect2.top = n2;
        if (s == 0) {
            s3 = cSprite.sprImg;
        }
        CMask cMask = null;
        CMask cMask2 = null;
        int n16 = 0;
        int n17 = 0;
        if (!bl4) {
            if ((n10 & 0x2000) != 0 || n3 == 0 && f == 1.0f && f2 == 1.0f) {
                cMask = this.rhPtr.spriteGen.getSpriteMask(cSprite, s3, CMask.GCMF_OBSTACLE);
                if (cMask == null) {
                    cRect2.left = cSprite.sprX1new;
                    cRect2.right = cSprite.sprX2new;
                    cRect2.top = cSprite.sprY1new;
                    cRect2.bottom = cSprite.sprY2new;
                    n9 = cRect2.right - cRect2.left;
                    n8 = cRect2.bottom - cRect2.top;
                    bl4 = true;
                } else {
                    if ((cSprite.sprFlags & 0x400000) == 0) {
                        cRect2.left -= cMask.xSpot;
                        cRect2.top -= cMask.ySpot;
                    }
                    n9 = cMask.width;
                    n8 = cMask.height;
                    cRect2.right = cRect2.left + n9;
                    cRect2.bottom = cRect2.top + n8;
                }
            } else {
                CPSCM cPSCM = this.rhPtr.spriteGen.prepareSpriteColMask(cSprite, s3, n, n2, (short)n3, f, f2, cRect2);
                n17 = 0;
                n16 = cPSCM.flags;
                cMask = cPSCM.mask;
                n9 = cRect2.right - cRect2.left;
                n8 = cRect2.bottom - cRect2.top;
            }
        } else if (s3 == 0 || s3 == cSprite.sprImg || (n10 & 0x2000) != 0) {
            cRect2.left = cSprite.sprX1new;
            cRect2.right = cSprite.sprX2new;
            cRect2.top = cSprite.sprY1new;
            cRect2.bottom = cSprite.sprY2new;
            n9 = cRect2.right - cRect2.left;
            n8 = cRect2.bottom - cRect2.top;
        } else {
            cImage = this.app.imageBank.getImageFromHandle(s3);
            if (cImage != null) {
                cRect2.left -= cImage.xSpot;
                cRect2.top -= cImage.ySpot;
                n9 = cImage.width;
                n8 = cImage.height;
                cRect2.right = cRect2.left + n9;
                cRect2.bottom = cRect2.top + n8;
            } else {
                cRect2.left = cSprite.sprX1new;
                cRect2.right = cSprite.sprX2new;
                cRect2.top = cSprite.sprY1new;
                cRect2.bottom = cSprite.sprY2new;
                n9 = cRect2.right - cRect2.left;
                n8 = cRect2.bottom - cRect2.top;
            }
        }
        if (n4 != 0) {
            if (n4 > n8) {
                n4 = n8;
            }
            cRect2.top += n8 - n4;
            if (cMask != null) {
                n17 = n8 - n4;
            }
            n8 = n4;
        }
        int n18 = 0;
        int n19 = 0;
        int n20 = cLayer.nBkdLOs;
        for (n7 = 0; n7 < n20; ++n7) {
            object = this.LOList.getLOFromIndex((short)(cLayer.nFirstLOIndex + n7));
            COI cOI = this.app.OIList.getOIFromHandle(((CLO)object).loOiHandle);
            if (cOI == null || cOI.oiOC == null) continue;
            COC cOC = cOI.oiOC;
            short s4 = cOI.oiType;
            cRect.left = ((CLO)object).loX - n14;
            cRect.top = ((CLO)object).loY - n15;
            CObject cObject = null;
            if (s4 < 2) {
                n6 = cOC.ocObstacleType;
                if (n6 == 0 || n6 == 3 || n6 == 4) continue;
                s2 = cOC.ocColMode;
                cRect.right = cRect.left + cOC.ocCx;
                cRect.bottom = cRect.top + cOC.ocCy;
            } else {
                CObjectCommon cObjectCommon = (CObjectCommon)cOC;
                if ((cObjectCommon.ocOEFlags & 2) == 0 || (cObject = this.rhPtr.find_HeaderObject(((CLO)object).loHandle)) == null || (n6 = (cObjectCommon.ocFlags2 & 0x30) >> 4) == 0 || n6 == 3 || n6 == 4) continue;
                s2 = (cObjectCommon.ocFlags2 & 4) != 0 ? (short)1 : 0;
                cRect.left = cObject.hoX - this.leX - cObject.hoImgXSpot;
                cRect.top = cObject.hoY - this.leY - cObject.hoImgYSpot;
                cRect.right = cRect.left + cObject.hoImgWidth;
                cRect.bottom = cRect.top + cObject.hoImgHeight;
            }
            if (bl3) {
                switch (n19) {
                    case 0: {
                        if (bl && (cRect.left < 0 || cRect.right > n12)) {
                            if (bl2 && (cRect.top < 0 || cRect.bottom > n13)) {
                                n19 = 3;
                                n18 |= 7;
                                break;
                            }
                            n19 = 1;
                            n18 |= 1;
                            break;
                        }
                        if (!bl2 || cRect.top >= 0 && cRect.bottom <= n13) break;
                        n19 = 2;
                        n18 |= 2;
                        break;
                    }
                    case 1: {
                        if (cRect.left < 0) {
                            int n21 = n12;
                            cRect.left += n21;
                            cRect.right += n21;
                        } else if (cRect.right > n12) {
                            int n22 = n12;
                            cRect.left -= n22;
                            cRect.right -= n22;
                        }
                        n19 = 0;
                        if (((n18 &= 0xFFFFFFFE) & 2) == 0) break;
                        n19 = 2;
                        break;
                    }
                    case 2: {
                        if (cRect.top < 0) {
                            int n23 = n13;
                            cRect.top += n23;
                            cRect.bottom += n23;
                        } else if (cRect.bottom > n13) {
                            int n24 = n13;
                            cRect.top -= n24;
                            cRect.bottom -= n24;
                        }
                        n19 = 0;
                        if (((n18 &= 0xFFFFFFFD) & 1) == 0) break;
                        n19 = 1;
                        break;
                    }
                    case 3: {
                        if (cRect.left < 0) {
                            int n25 = n12;
                            cRect.left += n25;
                            cRect.right += n25;
                        } else if (cRect.right > n12) {
                            int n26 = n12;
                            cRect.left -= n26;
                            cRect.right -= n26;
                        }
                        if (cRect.top < 0) {
                            int n27 = n13;
                            cRect.top += n27;
                            cRect.bottom += n27;
                        } else if (cRect.bottom > n13) {
                            int n28 = n13;
                            cRect.top -= n28;
                            cRect.bottom -= n28;
                        }
                        n18 &= 0xFFFFFFFB;
                        n19 = 2;
                    }
                }
            }
            if (cRect2.right > cRect.left && cRect2.bottom > cRect.top && cRect2.left < cRect.right && cRect2.top < cRect.bottom && (n6 != 2 || n5 != 0)) {
                if (s2 != 0) {
                    if (bl4) {
                        return true;
                    }
                    if (cMask == null) {
                        cMask = this.rhPtr.spriteGen.completeSpriteColMask(cSprite, n16, n9, n8);
                        if (cMask == null) {
                            return true;
                        }
                        n17 = 0;
                        if (n4 != 0) {
                            if (n4 > n8) {
                                n4 = n8;
                            }
                            n17 = n8 - n4;
                        }
                    }
                    if (cMask.testRect(n17, cRect.left - cRect2.left, cRect.top - cRect2.top, cRect.right - cRect.left, cRect.bottom - cRect.top)) {
                        return true;
                    }
                } else {
                    int n29 = CMask.GCMF_OBSTACLE;
                    if (n6 == 2) {
                        n29 = CMask.GCMF_PLATFORM;
                    }
                    cMask2 = null;
                    if (s4 < 2) {
                        cImage = this.app.imageBank.getImageFromHandle(((COCBackground)cOC).ocImage);
                        cMask2 = cImage.getMask(n29);
                    } else {
                        cMask2 = cObject.getCollisionMask(n29);
                    }
                    if (bl4) {
                        if (cMask2 == null) {
                            return true;
                        }
                        if (cMask2.testRect(0, cRect2.left - cRect.left, cRect2.top - cRect.top, n9, n8)) {
                            return true;
                        }
                    } else {
                        if (cMask == null && (cMask = this.rhPtr.spriteGen.completeSpriteColMask(cSprite, n16, n9, n8)) != null) {
                            n17 = 0;
                            if (n4 != 0) {
                                if (n4 > n8) {
                                    n4 = n8;
                                }
                                n17 = n8 - n4;
                            }
                        }
                        if (cMask2 == null) {
                            if (cMask == null) {
                                return true;
                            }
                            if (cMask.testRect(n17, cRect.left - cRect2.left, cRect.top - cRect2.top, cRect.right - cRect.left, cRect.bottom - cRect.top)) {
                                return true;
                            }
                        } else if (cMask == null ? cMask2.testRect(0, cRect2.left - cRect.left, cRect2.top - cRect.top, n9, n8) : cMask2.testMask(0, cRect.left, cRect.top, cMask, n17, cRect2.left, cRect2.top)) {
                            return true;
                        }
                    }
                }
            }
            if (n18 == 0) continue;
            --n7;
        }
        if (cLayer.pBkd2 != null) {
            n18 = 0;
            n19 = 0;
            for (n7 = 0; n7 < cLayer.pBkd2.size(); ++n7) {
                int n30;
                object = (CBkd2)cLayer.pBkd2.get(n7);
                cRect.left = ((CBkd2)object).x - n14;
                cRect.top = ((CBkd2)object).y - n15;
                n6 = ((CBkd2)object).obstacleType;
                if (n6 == 0 || n6 == 3 || n6 == 4) continue;
                s2 = ((CBkd2)object).colMode == 0 ? (short)1 : 0;
                cImage = this.app.imageBank.getImageFromHandle(((CBkd2)object).img);
                if (cImage != null) {
                    cRect.right = cRect.left + cImage.width;
                    cRect.bottom = cRect.top + cImage.height;
                } else {
                    cRect.right = cRect.left + 1;
                    cRect.bottom = cRect.top + 1;
                }
                if (bl3) {
                    switch (n19) {
                        case 0: {
                            if (bl && (cRect.left < 0 || cRect.right > n12)) {
                                if (bl2 && (cRect.top < 0 || cRect.bottom > n13)) {
                                    n19 = 3;
                                    n18 |= 7;
                                    break;
                                }
                                n19 = 1;
                                n18 |= 1;
                                break;
                            }
                            if (!bl2 || cRect.top >= 0 && cRect.bottom <= n13) break;
                            n19 = 2;
                            n18 |= 2;
                            break;
                        }
                        case 1: {
                            if (cRect.left < 0) {
                                n30 = n12;
                                cRect.left += n30;
                                cRect.right += n30;
                            } else if (cRect.right > n12) {
                                n30 = n12;
                                cRect.left -= n30;
                                cRect.right -= n30;
                            }
                            n19 = 0;
                            if (((n18 &= 0xFFFFFFFE) & 2) == 0) break;
                            n19 = 2;
                            break;
                        }
                        case 2: {
                            if (cRect.top < 0) {
                                n30 = n13;
                                cRect.top += n30;
                                cRect.bottom += n30;
                            } else if (cRect.bottom > n13) {
                                n30 = n13;
                                cRect.top -= n30;
                                cRect.bottom -= n30;
                            }
                            n19 = 0;
                            if (((n18 &= 0xFFFFFFFD) & 1) == 0) break;
                            n19 = 1;
                            break;
                        }
                        case 3: {
                            if (cRect.left < 0) {
                                n30 = n12;
                                cRect.left += n30;
                                cRect.right += n30;
                            } else if (cRect.right > n12) {
                                n30 = n12;
                                cRect.left -= n30;
                                cRect.right -= n30;
                            }
                            if (cRect.top < 0) {
                                n30 = n13;
                                cRect.top += n30;
                                cRect.bottom += n30;
                            } else if (cRect.bottom > n13) {
                                n30 = n13;
                                cRect.top -= n30;
                                cRect.bottom -= n30;
                            }
                            n18 &= 0xFFFFFFFB;
                            n19 = 2;
                        }
                    }
                }
                if (cRect2.right > cRect.left && cRect2.bottom > cRect.top && cRect2.left < cRect.right && cRect2.top < cRect.bottom && (n6 != 2 || n5 != 0)) {
                    if (s2 != 0) {
                        if (bl4) {
                            return true;
                        }
                        if (cMask == null) {
                            cMask = this.rhPtr.spriteGen.completeSpriteColMask(cSprite, n16, n9, n8);
                            if (cMask == null) {
                                return true;
                            }
                            n17 = 0;
                            if (n4 != 0) {
                                if (n4 > n8) {
                                    n4 = n8;
                                }
                                n17 = n8 - n4;
                            }
                        }
                        if (cMask.testRect(n17, cRect.left - cRect2.left, cRect.top - cRect2.top, cRect.right - cRect.left, cRect.bottom - cRect.top)) {
                            return true;
                        }
                    } else {
                        n30 = CMask.GCMF_OBSTACLE;
                        if (n6 == 2) {
                            n30 = CMask.GCMF_PLATFORM;
                        }
                        if ((cMask2 = (cImage = this.app.imageBank.getImageFromHandle(((CBkd2)object).img)).getMask(n30)) != null) {
                            if (bl4) {
                                if (cMask2.testRect(0, cRect2.left - cRect.left, cRect2.top - cRect.top, n9, n8)) {
                                    return true;
                                }
                            } else {
                                if (cMask == null) {
                                    cMask = this.rhPtr.spriteGen.completeSpriteColMask(cSprite, n16, n9, n8);
                                    if (cMask == null) {
                                        return true;
                                    }
                                    n17 = 0;
                                    if (n4 != 0) {
                                        if (n4 > n8) {
                                            n4 = n8;
                                        }
                                        n17 = n8 - n4;
                                    }
                                }
                                if (cMask2.testMask(0, cRect.left, cRect.top, cMask, n17, cRect2.left, cRect2.top)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                if (n18 == 0) continue;
                --n7;
            }
        }
        return false;
    }

    public boolean bkdCol_TestPoint(int n, int n2, int n3, int n4) {
        if (n3 == -1) {
            CLayer cLayer = this.layers[0];
            if ((this.leFlags & 0x20) != 0 && (cLayer.dwOptions & 0x60) != 0) {
                return this.bkdLevObjCol_TestPoint(n, n2, 0, n4);
            }
            if (this.colMask.testPoint(n, n2, n4)) {
                return true;
            }
            if (this.nLayers == 1) {
                return false;
            }
            if ((this.leFlags & 0x20) != 0) {
                return this.bkdLevObjCol_TestPoint(n, n2, n3, n4);
            }
            int n5 = 8;
            n5 = n4 == 1 ? (n5 |= 2) : (n5 |= 1);
            return this.rhPtr.spriteGen.spriteCol_TestPoint(null, (short)n3, n, n2, n5) != null;
        }
        if (n3 == 0) {
            CLayer cLayer = this.layers[0];
            if ((this.leFlags & 0x20) != 0 && (cLayer.dwOptions & 0x60) != 0) {
                return this.bkdLevObjCol_TestPoint(n, n2, 0, n4);
            }
            return this.colMask.testPoint(n, n2, n4);
        }
        if (this.nLayers == 1) {
            return false;
        }
        if ((this.leFlags & 0x20) != 0) {
            return this.bkdLevObjCol_TestPoint(n, n2, n3, n4);
        }
        int n6 = 8;
        n6 = n4 == 1 ? (n6 |= 2) : (n6 |= 1);
        return this.rhPtr.spriteGen.spriteCol_TestPoint(null, (short)-1, n, n2, n6) != null;
    }

    public boolean bkdCol_TestRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == -1) {
            CLayer cLayer = this.layers[0];
            if ((this.leFlags & 0x20) != 0 && (cLayer.dwOptions & 0x60) != 0) {
                return this.bkdLevObjCol_TestRect(n, n2, n3, n4, 0, n6);
            }
            if (this.colMask.testRect(n, n2, n3, n4, n6)) {
                return true;
            }
            if (this.nLayers == 1) {
                return false;
            }
            if ((this.leFlags & 0x20) != 0) {
                return this.bkdLevObjCol_TestRect(n, n2, n3, n4, n5, n6);
            }
            int n7 = 8;
            n7 = n6 == 1 ? (n7 |= 2) : (n7 |= 1);
            return this.rhPtr.spriteGen.spriteCol_TestRect(null, n5, n, n2, n3, n4, n7) != null;
        }
        if (n5 == 0) {
            CLayer cLayer = this.layers[0];
            if ((this.leFlags & 0x20) != 0 && (cLayer.dwOptions & 0x60) != 0) {
                return this.bkdLevObjCol_TestRect(n, n2, n3, n4, 0, n6);
            }
            return this.colMask.testRect(n, n2, n3, n4, n6);
        }
        if (this.nLayers == 1) {
            return false;
        }
        if ((this.leFlags & 0x20) != 0) {
            return this.bkdLevObjCol_TestRect(n, n2, n3, n4, n5, n6);
        }
        int n8 = 8;
        n8 = n6 == 1 ? (n8 |= 2) : (n8 |= 1);
        return this.rhPtr.spriteGen.spriteCol_TestRect(null, -1, n, n2, n3, n4, n8) != null;
    }

    public boolean bkdCol_TestSprite(CSprite cSprite, int n, int n2, int n3, int n4, float f, float f2, int n5, int n6) {
        int n7 = cSprite.sprLayer / 2;
        if (n7 == 0) {
            CLayer cLayer = this.layers[0];
            if ((this.leFlags & 0x20) != 0 && (cLayer.dwOptions & 0x60) != 0) {
                return this.bkdLevObjCol_TestSprite(cSprite, (short)n, n2, n3, n4, f, f2, n5, n6);
            }
            return this.colMask_TestSprite(cSprite, n, n2, n3, n4, f, f2, n5, n6);
        }
        if (this.nLayers == 1) {
            return false;
        }
        if ((this.leFlags & 0x20) != 0) {
            return this.bkdLevObjCol_TestSprite(cSprite, (short)n, n2, n3, n4, f, f2, n5, n6);
        }
        int n8 = 8;
        n8 = n6 == 1 ? (n8 |= 2) : (n8 |= 1);
        return this.rhPtr.spriteGen.spriteCol_TestSprite(cSprite, (short)n, n2, n3, n4, f, f2, n5, n8) != null;
    }

    boolean colMask_TestSprite(CSprite cSprite, int n, int n2, int n3, int n4, float f, float f2, int n5, int n6) {
        int n7;
        int n8;
        if (cSprite == null || this.colMask == null) {
            return false;
        }
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        short s = this.rhPtr.spriteGen.colMode;
        CRect cRect = new CRect();
        if (n == 0) {
            n9 = cSprite.sprImg;
        }
        if (s != 0 && (cSprite.sprFlags & 0x100) == 0) {
            int n12 = 0;
            CMask cMask = null;
            if ((cSprite.sprFlags & 0x2000) != 0 || n4 == 0 && f == 1.0f && f2 == 1.0f) {
                cMask = this.rhPtr.spriteGen.getSpriteMask(cSprite, (short)n9, CMask.GCMF_OBSTACLE);
                if (cMask == null) {
                    n10 -= cSprite.sprX - cSprite.sprX1;
                    n11 -= cSprite.sprY - cSprite.sprY1;
                    n8 = cSprite.sprX2 - cSprite.sprX1;
                    n7 = cSprite.sprY2 - cSprite.sprY1;
                } else {
                    if ((cSprite.sprFlags & 0x400000) == 0) {
                        n10 -= cMask.xSpot;
                        n11 -= cMask.ySpot;
                    }
                    n8 = cMask.width;
                    n7 = cMask.height;
                }
            } else {
                CPSCM cPSCM = this.rhPtr.spriteGen.prepareSpriteColMask(cSprite, (short)n9, n2, n3, (short)n4, f, f2, cRect);
                n12 = cPSCM.flags;
                cMask = cPSCM.mask;
                n10 = cRect.left;
                n11 = cRect.top;
                n8 = cRect.right - cRect.left;
                n7 = cRect.bottom - cRect.top;
                if (cMask == null) {
                    cMask = this.rhPtr.spriteGen.completeSpriteColMask(cSprite, n12, n8, n7);
                }
            }
            if (cMask != null) {
                int n13 = 0;
                if (n5 != 0) {
                    if (n5 > n7) {
                        n5 = n7;
                    }
                    n11 += n7 - n5;
                    n13 = n7 - n5;
                    n7 = n5;
                }
                return this.colMask.testMask(cMask, n13, n10, n11, n6);
            }
        } else if (n9 == 0 || n9 == cSprite.sprImg || (cSprite.sprFlags & 0x2000) != 0) {
            n10 -= cSprite.sprX - cSprite.sprX1;
            n11 -= cSprite.sprY - cSprite.sprY1;
            n8 = cSprite.sprX2 - cSprite.sprX1;
            n7 = cSprite.sprY2 - cSprite.sprY1;
        } else {
            CImage cImage = this.app.imageBank.getImageFromHandle((short)n9);
            if (cImage != null) {
                n10 -= cImage.xSpot;
                n11 -= cImage.ySpot;
                n8 = cImage.width;
                n7 = cImage.height;
            } else {
                n10 -= cSprite.sprX - cSprite.sprX1;
                n11 -= cSprite.sprY - cSprite.sprY1;
                n8 = cSprite.sprX2 - cSprite.sprX1;
                n7 = cSprite.sprY2 - cSprite.sprY1;
            }
        }
        if (n5 != 0) {
            if (n5 > n7) {
                n5 = n7;
            }
            n11 += n7 - n5;
            n7 = n5;
        }
        return this.colMask.testRect(n10, n11, n8, n7, n6);
    }
}

