/*
 * Decompiled with CFR 0.152.
 */
package Params;

import Application.CRunApp;
import Banks.CImage;
import Movements.CMove;
import Objects.CObject;
import Params.CParam;
import Params.CPositionInfo;
import RunLoop.CRun;

public abstract class CPosition
extends CParam {
    public short posOINUMParent;
    public short posFlags;
    public short posX;
    public short posY;
    public short posSlope;
    public short posAngle;
    public int posDir;
    public short posTypeParent;
    public short posOiList;
    public short posLayer;
    public static final short CPF_DIRECTION = 1;
    public static final short CPF_ACTION = 2;
    public static final short CPF_INITIALDIR = 4;
    public static final short CPF_DEFAULTDIR = 8;

    public boolean read_Position(CRun cRun, int n, CPositionInfo cPositionInfo) {
        cPositionInfo.layer = -1;
        if (this.posOINUMParent == -1) {
            if (n != 0) {
                cPositionInfo.dir = -1;
                if ((this.posFlags & 8) == 0) {
                    cPositionInfo.dir = cRun.get_Direction(this.posDir);
                }
            }
            cPositionInfo.x = this.posX;
            cPositionInfo.y = this.posY;
            int n2 = this.posLayer;
            if (n2 > cRun.rhFrame.nLayers - 1) {
                n2 = cRun.rhFrame.nLayers - 1;
            }
            cPositionInfo.layer = n2;
            cPositionInfo.bRepeat = false;
        } else {
            cRun.rhEvtProg.rh2EnablePick = false;
            CObject cObject = cRun.rhEvtProg.get_CurrentObjects(this.posOiList);
            cPositionInfo.bRepeat = cRun.rhEvtProg.repeatFlag;
            if (cObject == null) {
                return false;
            }
            cPositionInfo.x = cObject.hoX;
            cPositionInfo.y = cObject.hoY;
            cPositionInfo.layer = cObject.hoLayer;
            if ((this.posFlags & 2) != 0 && (cObject.hoOEFlags & 0x20) != 0 && cObject.roc.rcImage != 0) {
                CImage cImage = cRun.rhApp.imageBank.getImageInfoEx(cObject.roc.rcImage, cObject.roc.rcAngle, cObject.roc.rcScaleX, cObject.roc.rcScaleY);
                cPositionInfo.x += cImage.xAP - cImage.xSpot;
                cPositionInfo.y += cImage.yAP - cImage.ySpot;
            }
            if ((this.posFlags & 1) != 0) {
                int n3 = this.posAngle + cObject.roc.rcDir & 0x1F;
                int n4 = CMove.getDeltaX(this.posSlope, n3);
                int n5 = CMove.getDeltaY(this.posSlope, n3);
                cPositionInfo.x += n4;
                cPositionInfo.y += n5;
            } else {
                cPositionInfo.x += this.posX;
                cPositionInfo.y += this.posY;
            }
            if ((n & 1) != 0) {
                cPositionInfo.dir = (this.posFlags & 8) != 0 ? -1 : ((this.posFlags & 4) != 0 ? cObject.roc.rcDir : cRun.get_Direction(this.posDir));
            }
        }
        if ((n & 2) != 0) {
            if (cPositionInfo.x < cRun.rh3XMinimumKill || cPositionInfo.x > cRun.rh3XMaximumKill) {
                return false;
            }
            if (cPositionInfo.y < cRun.rh3YMinimumKill || cPositionInfo.y > cRun.rh3YMaximumKill) {
                return false;
            }
        }
        return true;
    }

    public abstract void load(CRunApp var1);
}

