/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.qq.wap;

import feeLibs.common.CallBack;
import feeLibs.common.FeeListener;
import feeLibs.common.Utils;
import feeLibs.qq.wap.CommInfo;
import feeLibs.qq.wap.Communicator;
import javax.microedition.midlet.MIDlet;

public class QQWapFeeManager
implements CallBack {
    private static String HOMEURL = "http://waprelay.qq.com/r/reverse_3004?pb=3004&ps=minigame&cuk=minigame&";
    private static final int REQUEST_SEND_PAGE = 0;
    private static final int STATUS_IDLE = 1;
    private Communicator m_comm;
    private CommInfo m_commInfo;
    private FeeListener m_listener;
    private int m_status;
    private String m_url;

    public static void openWAPFee(MIDlet main, FeeListener listener) {
        String gameId = Utils.getJarPropertyValue(main, "GameID");
        String channelId = Utils.getJarPropertyValue(main, "ChannelID");
        QQWapFeeManager wap = new QQWapFeeManager(main, gameId, channelId, listener);
        wap.openComm();
    }

    private QQWapFeeManager(MIDlet main, String gameid, String channelId, FeeListener listener) {
        this.m_listener = listener;
        StringBuffer url = new StringBuffer();
        url.append(HOMEURL);
        url.append("cp=");
        url.append("50");
        url.append("&game=");
        url.append(gameid);
        url.append("&channel=");
        url.append(channelId);
        this.m_url = url.toString();
    }

    private void openComm() {
        this.m_status = 0;
        this.m_comm = new Communicator();
        this.m_commInfo = new CommInfo(this.m_url, "", this, 1);
        this.m_comm.addRequest(this.m_commInfo, false);
    }

    private void closeComm() {
        this.m_comm.abort();
        this.m_comm = null;
    }

    public void callBack(Object obj) {
        try {
            if (obj instanceof byte[]) {
                this.m_listener.receivedContent(this.m_status, new String((byte[])obj));
                this.handleData((byte[])obj);
            } else {
                this.m_listener.receivedContent(this.m_status, obj.toString());
                this.handleException(obj);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleData(byte[] data) {
        String ret = new String(data);
        if (ret.equals("success")) {
            this.success(0, ret);
        } else {
            this.failed("\u8054\u7f51\u8fd4\u56de\u53c2\u6570\u4e0d\u6b63\u786e");
        }
    }

    private void handleException(Object object) {
        this.failed("\u8054\u7f51\u5931\u8d25\uff0c\u7f51\u7edc\u51fa\u73b0\u5f02\u5e38!");
    }

    private void success(int id, String info) {
        this.closeComm();
        if (this.m_listener != null) {
            StringBuffer result = new StringBuffer(" \u72b6\u6001:");
            result.append(info);
            this.m_listener.feeSuccessed(id, result.toString());
            this.m_listener = null;
        }
        this.m_status = 1;
    }

    private void failed(String info) {
        this.closeComm();
        if (this.m_listener != null) {
            StringBuffer result = new StringBuffer(" \u72b6\u6001:");
            result.append(info);
            this.m_listener.feeFailed(-1, result.toString());
            this.m_listener = null;
        }
    }
}

