/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.util;

import com.sinaflying.util.EngineSound;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

class SoundStandard
extends EngineSound {
    SoundStandard(int n) {
        this._soundFileNum = n;
        this._curPlayingSoundId = -1;
        this._sounds = new Player[n];
    }

    protected boolean openSoundsFromResDirMidiFile(String[] stringArray) {
        this._isOpenBinFile = false;
        this._soundFileName = stringArray;
        try {
            int n = 0;
            while (n < this._soundFileNum) {
                InputStream inputStream = this.openSoundFile(n);
                this._sounds[n] = Manager.createPlayer((InputStream)inputStream, (String)(this._soundFileName[n].indexOf(".mid") >= 0 ? "audio/midi" : (this._soundFileName[n].indexOf(".wav") >= 0 ? "audio/x-wav" : (this._soundFileName[n].indexOf(".amr") >= 0 ? "audio/amr" : (this._soundFileName[n].indexOf(".mp3") >= 0 ? "audio/mpeg" : "audio/unknow")))));
                this._sounds[n].realize();
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean openSoundsFromResDirBinFile(String string) {
        this._isOpenBinFile = true;
        this._binFileName = string;
        System.out.println("\u5a09\u3126\u5270\u951b\u6c2c\ue64b\u6d93\ue044\uff10\u95ca\u866b\u58a6\u9356\u546e\u579abin\u93c2\u56e6\u6b22\u9428\u52ec\u67df\u5bee\u5fe5\u7d1d\u7487\u8bf2\u5f47\u93c3\u8dfa\u5f67\u93c0\ue21b\u5bd4bin\u93c2\u56e6\u6b22\u6d93\ue162\u5158\u93c4\u75ecid\u9428\u52ec\u6783\u6d60\u8235\u7278\u5bee\ufffd");
        try {
            int n = 0;
            while (n < this._soundFileNum) {
                InputStream inputStream = this.openSoundFile(n);
                this._sounds[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                this._sounds[n].realize();
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void playSound(int n, int n2) {
        try {
            VolumeControl volumeControl;
            if (this._soundVolume <= 0) {
                return;
            }
            if (this._curPlayingSoundId >= 0) {
                this.stopSound();
            }
            if ((volumeControl = (VolumeControl)this._sounds[n].getControl("VolumeControl")) != null) {
                volumeControl.setLevel(this._soundVolume);
            }
            this._sounds[n].setLoopCount(n2);
            this._sounds[n].start();
            this._curPlayingSoundId = n;
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void stopSound() {
        try {
            if (this.isPlaySound()) {
                this._sounds[this._curPlayingSoundId].stop();
                while (this._sounds[this._curPlayingSoundId].getState() == 400) {
                    System.out.println("wait..");
                }
            }
            this._curPlayingSoundId = -1;
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }
}

