/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.util;

import com.sinaflying.util.SoundMoto;
import com.sinaflying.util.SoundMotoE2;
import com.sinaflying.util.SoundNokia;
import com.sinaflying.util.SoundNokiaS40ii;
import com.sinaflying.util.SoundNokiaS60iii;
import com.sinaflying.util.SoundSamsung;
import com.sinaflying.util.SoundSonyEricsson;
import com.sinaflying.util.SoundStandard;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public abstract class EngineSound {
    public static final int MODEL_SOUND_STANDARD = 0;
    public static final int MODEL_SOUND_NOKIA = 1;
    public static final int MODEL_SOUND_MOTO = 2;
    public static final int MODEL_SOUND_SAMSUNG = 3;
    public static final int MODEL_SOUND_SONYERICSSON = 4;
    public static final int MODEL_SOUND_MOTOE2 = 5;
    public static final int MODEL_SOUND_NOKIA_S40II = 6;
    public static final int MODEL_SOUND_NOKIA_S60III = 7;
    protected static final int C_DEFAULT_SOUND_VOLUME = 80;
    protected boolean _isOpenBinFile;
    protected int _soundFileNum;
    protected String _binFileName;
    protected String[] _soundFileName;
    protected int _soundVolume = 80;
    protected int _curPlayingSoundId;
    protected Player[] _sounds;

    public static final EngineSound createEngineSound(int n, String[] stringArray) {
        EngineSound engineSound = null;
        switch (n) {
            case 0: {
                engineSound = new SoundStandard(stringArray.length);
                break;
            }
            case 1: {
                engineSound = new SoundNokia(stringArray.length);
                break;
            }
            case 2: {
                engineSound = new SoundMoto(stringArray.length);
                break;
            }
            case 3: {
                engineSound = new SoundSamsung(stringArray.length);
                break;
            }
            case 4: {
                engineSound = new SoundSonyEricsson(stringArray.length);
                break;
            }
            case 5: {
                engineSound = new SoundMotoE2(stringArray.length);
                break;
            }
            case 6: {
                engineSound = new SoundNokiaS40ii(stringArray.length);
                break;
            }
            case 7: {
                engineSound = new SoundNokiaS60iii(stringArray.length);
            }
        }
        engineSound.openSoundsFromResDirMidiFile(stringArray);
        return engineSound;
    }

    public static final EngineSound createEngineSound(int n, String string, int n2) {
        EngineSound engineSound = null;
        switch (n) {
            case 0: {
                engineSound = new SoundStandard(n2);
                break;
            }
            case 1: {
                engineSound = new SoundNokia(n2);
                break;
            }
            case 2: {
                engineSound = new SoundMoto(n2);
                break;
            }
            case 3: {
                engineSound = new SoundSamsung(n2);
                break;
            }
            case 4: {
                engineSound = new SoundSonyEricsson(n2);
                break;
            }
            case 5: {
                engineSound = new SoundMotoE2(n2);
                break;
            }
            case 6: {
                engineSound = new SoundNokiaS40ii(n2);
                break;
            }
            case 7: {
                engineSound = new SoundNokiaS60iii(n2);
            }
        }
        engineSound.openSoundsFromResDirBinFile(string);
        return engineSound;
    }

    protected final int getInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= 0) {
            n3 <<= 8;
            n3 = n4 == n2 - 1 ? (n3 |= byArray[n4 + n]) : (n3 |= byArray[n4 + n] & 0xFF);
            --n4;
        }
        return n3;
    }

    protected final InputStream openSoundFile(int n) {
        InputStream inputStream = null;
        try {
            if (this._isOpenBinFile) {
                InputStream inputStream2 = this.getClass().getResourceAsStream(this._binFileName);
                byte[] byArray = new byte[4];
                int n2 = 0;
                int n3 = 0;
                inputStream2.read(byArray);
                int n4 = this.getInt(byArray, 0, 4);
                int n5 = 0;
                while (n5 < n4) {
                    inputStream2.read(byArray);
                    if (n5 == n) {
                        n2 = this.getInt(byArray, 0, 4);
                    } else if (n5 == n + 1) {
                        n3 = this.getInt(byArray, 0, 4) - n2;
                    }
                    ++n5;
                }
                inputStream2.skip(n2);
                byte[] byArray2 = new byte[n3];
                inputStream2.read(byArray2);
                inputStream2.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                byArray2 = null;
                inputStream = byteArrayInputStream;
            } else {
                StringBuffer stringBuffer = new StringBuffer(this._soundFileName[n]);
                inputStream = this.getClass().getResourceAsStream(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return inputStream;
    }

    public final void changeSoundVolume(int n) {
        VolumeControl volumeControl;
        this._soundVolume = n;
        if (this.isPlaySound() && (volumeControl = (VolumeControl)this._sounds[this._curPlayingSoundId].getControl("VolumeControl")) != null) {
            volumeControl.setLevel(this._soundVolume);
        }
    }

    public final void avoidSoundVolumeIsZeroCast() {
        if (this.isPlaySound() && this._soundVolume <= 0) {
            this.stopSound();
        }
    }

    public final boolean isPlaySound() {
        return this._curPlayingSoundId >= 0 && this._sounds[this._curPlayingSoundId] != null && this._sounds[this._curPlayingSoundId].getState() == 400;
    }

    public final int getCurPlaySoundId() {
        return this._curPlayingSoundId;
    }

    public final void enablePlaySound(boolean bl) {
        if (bl) {
            this.changeSoundVolume(80);
        } else {
            this.changeSoundVolume(0);
            this.avoidSoundVolumeIsZeroCast();
        }
    }

    public final int getSoundVolume() {
        return this._soundVolume;
    }

    protected abstract boolean openSoundsFromResDirMidiFile(String[] var1);

    protected abstract boolean openSoundsFromResDirBinFile(String var1);

    public abstract void playSound(int var1, int var2);

    public abstract void stopSound();
}

