/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.script;

import com.sinaflying.game.Actor;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.script.Executor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class SceneExecutor
extends Executor {
    private Scene _scene;
    private int[] _enemyIndex = new int[3];

    public SceneExecutor(Graphics graphics, Scene scene) {
        super(graphics);
        this._scene = scene;
    }

    public Actor getActiveActor(int n) {
        Actor actor = this._scene.getActiveActor(n);
        return actor;
    }

    public Actor fetchActorFromPool(int n) {
        Actor actor = this._scene.fetchActorFromPool(n, -1);
        return actor;
    }

    public void actorInit(int n, int n2, int n3, int n4) {
        Actor actor = this._scene.getActiveActor(n);
        actor.init(n2 << 10 * this._scene.getBackground()._bktw, n3 << 10 * this._scene.getBackground()._bkth, n4);
    }

    public void actorActive(int n) {
        Actor actor = this._scene.getActiveActor(n);
        actor.activate(this._scene, n);
    }

    public void actorDisActive(int n, int n2) {
        Actor actor = this._scene.getActiveActor(n);
        switch (n2) {
            case 0: {
                actor.disActive();
                if (!Actor.isNeedRecord(actor.getAniInx())) break;
                actor.recordEasyInfo();
                break;
            }
            default: {
                actor.disLife();
            }
        }
    }

    public void actorChangeAction(int n, int n2, int n3) {
        int n4 = n3 == 0 ? 0 : Integer.MIN_VALUE;
        Actor actor = this._scene.getActiveActor(n);
        actor.changeAction(n2 | n4);
    }

    public void actorSetSpeed(int n, int n2, int n3) {
        Actor actor = this._scene.getActiveActor(n);
        actor._vx = n2 << 10;
        actor._vy = n3 << 10;
    }

    public void actorAi(int n) {
        Actor actor = this._scene.getActiveActor(n);
        actor.ai();
    }

    public void actorStep(int n) {
        Actor actor = this._scene.getActiveActor(n);
        actor.step();
    }

    public boolean isSpecialHandleFinish() {
        return true;
    }

    public void actorNextFrame(int n) {
        Actor actor = this._scene.getActiveActor(n);
        actor.nextFrame();
    }

    public void actorWalk(int n, int n2, int n3) {
        Actor actor = this._scene.getActiveActor(n);
        actor.walkTo(n2, n3);
    }

    public void actorStop(int n) {
        Actor actor = this._scene.getActiveActor(n);
        actor.stop();
    }

    public void actorSpeaker(int n, String string, int n2, int n3) {
        if (n == -1) {
            this._scene.setPoemsInfo(n2);
        } else {
            this._scene.speak(n, string, n2, n3);
        }
    }

    public boolean isFinishWord() {
        return true;
    }

    public void actorTransfer(int n, int n2, int n3, int n4) {
        Actor actor = this._scene.getActiveActor(n);
        actor._x = n3 << 10;
        actor._y = n4 << 10;
    }

    public boolean actorIsActionEnd(int n) {
        Actor actor = this._scene.getActiveActor(n);
        return actor.isActionEnd();
    }

    public int actorGetPositionX(int n) {
        Actor actor = this._scene.getActiveActor(n);
        int n2 = actor._x >> 10;
        return n2;
    }

    public int actorGetPositionY(int n) {
        Actor actor = this._scene.getActiveActor(n);
        int n2 = actor._y >> 10;
        return n2;
    }

    public int actorGetCurAction(int n) {
        Actor actor = this._scene.getActiveActor(n);
        return actor._curAction;
    }

    public void actorSetFocus(int n) {
        Actor actor = this._scene.getActiveActor(n);
        this._scene.setFocusActor(actor);
    }

    public void actorEnableAi(int n) {
        if (n == 100) {
            Hashtable hashtable = this._scene.getActiveContainer();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Actor actor = (Actor)enumeration.nextElement();
                switch (actor.getAniInx()) {
                    case 0: 
                    case 1: {
                        actor.enableAI(true);
                    }
                }
            }
        } else {
            Actor actor = this._scene.getActiveActor(n);
            actor.enableAI(true);
        }
    }

    public void actorUnableAi(int n) {
        if (n == 100) {
            Hashtable hashtable = this._scene.getActiveContainer();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Actor actor = (Actor)enumeration.nextElement();
                switch (actor.getAniInx()) {
                    case 0: 
                    case 1: {
                        actor.enableAI(false);
                    }
                }
            }
        } else {
            Actor actor = this._scene.getActiveActor(n);
            actor.enableAI(false);
        }
    }

    public void actorSetPos(int n, int n2, int n3) {
        Actor actor = this._scene.getActiveActor(n);
        actor.setPosByTile(n2, n3);
    }

    public void actorValidFlag(int n, int n2) {
        Actor actor = this._scene.getActiveActor(n);
        actor.setValidFlag(n2 == 1);
    }

    public boolean actorCollide(int n, int n2) {
        Actor actor = this._scene.getActiveActor(n);
        Actor actor2 = this._scene.getActiveActor(n2);
        return actor.collide(actor2);
    }

    public void actorWalkTo(int n, int n2, int n3) {
        Actor actor = this._scene.getActiveActor(n);
        actor.walkTo(n2, n3);
    }

    public void actorShowExpression(int n, int n2) {
        Actor actor = this._scene.getActiveActor(n);
    }

    public void actorWalkToOffset(int n, int n2, int n3) {
        RoleActor roleActor = this._scene.getMainActor();
        Actor actor = this._scene.getActiveActor(n);
        actor.walkTo(roleActor.getCol() + n2, roleActor.getRow() + n3);
    }

    public void createDynamicActor(int n, int n2, int n3, int n4, int n5) {
        Actor actor = this._scene.fetchActorFromPool(n, -1);
        actor.init((n2 << 10) * this._scene.getBackground()._bktw, (n3 << 10) * this._scene.getBackground()._bkth, n4);
        if (n5 == 1) {
            actor.changeAction(n4 |= Integer.MIN_VALUE);
        }
    }

    public void createUndynamicActor(int n, int n2, int n3, int n4, int n5) {
        Actor actor = this._scene.fetchActorFromPool(n, -1);
        actor.init((n2 << 10) * this._scene.getBackground()._bktw, (n3 << 10) * this._scene.getBackground()._bkth, n4);
    }

    public void actorMove(int n, int n2, int n3, int n4) {
        Actor actor = this._scene.getActiveActor(n);
        actor.moveTo(n2, n3, n4);
    }

    public void actorBlinkMove(int n, int n2, int n3, int n4) {
        Actor actor = this._scene.getActiveActor(n);
        actor.BlinkToPosition(n2, n3, n4);
    }

    public void actorShake(int n, int n2, int n3, int n4) {
        Actor actor = this._scene.getActiveActor(n);
        actor.startToShake(n2, n3, n4);
    }

    public boolean actorIsFinishWalk(int n) {
        Actor actor = this._scene.getActiveActor(n);
        return actor.isFinishWalk();
    }

    public void actorSetPosOffset(int n, int n2) {
        Actor actor = this._scene.getActiveActor(n);
        Actor actor2 = this._scene.getActiveActor(n2);
        actor.setPosByCoordinate(actor2.getPosX(), actor2.getPosY());
    }

    public boolean actorIsFinishMove(int n) {
        Actor actor = this._scene.getActiveActor(n);
        return actor.getArriveDesFlagForMove();
    }

    public void specialHandle(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case -1: {
                this._scene.setSceneEffect(n2, n3);
                break;
            }
            case 0: {
                this._scene.setPoemsInfo(n2);
                break;
            }
            case 1: {
                if (RoleTeamData.getInstance().getMoney() >= n2) {
                    RoleTeamData.getInstance().decreaseMoney(n2);
                    this._scene.resetRole();
                    break;
                }
                this.jump(n4);
                break;
            }
            case 2: {
                if (n3 == 1) {
                    this._scene.startUpShake(n2);
                    break;
                }
                this._scene.clearShake();
                break;
            }
            case 4: {
                this._scene.getActiveActor(n2).initContortPara(2);
                break;
            }
            case 5: {
                this.actorChangeAction(n2, n3, n4);
                this._scene.getActiveActor(n2).initContortPara(1);
                break;
            }
            case 6: {
                Actor actor = this._scene.getActiveActor(n2);
                actor.showExpression(n3, n4);
                break;
            }
            case 7: {
                if (n2 == 0 && n3 == 0) {
                    this._scene.lockCamera(this._scene.getMainActor().getXDirLocation(this._scene._camw), this._scene.getMainActor().getYDirLocation(this._scene._camh));
                } else {
                    this._scene.lockCamera((n2 << 4) - 160 << 10, (n3 << 4) - 120 << 10);
                }
                this._scene.setCamera(this._scene._lockCx, this._scene._lockCy);
                break;
            }
            case 8: {
                this._scene.initSceneEffect(n2, n3, n4);
            }
        }
        if (n > 9) {
            if (n % 10 == 1) {
                this._scene.initCg(n / 10, n2, n3, n4, n5);
            } else {
                this._scene.closeCg();
            }
        }
    }

    public boolean isDied() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n = roleTeamData.getRoleData(0).getHP();
        int n2 = roleTeamData.getRoleData(1).getHP();
        if (n <= 1 || n2 <= 1) {
            int n3 = 0;
            while (n3 < 2) {
                roleTeamData.getRoleData(n3).resetHp();
                roleTeamData.getRoleData(n3).resetMp();
                ++n3;
            }
            return true;
        }
        return false;
    }

    public void GameScreenShadeStart(int n) {
        this._scene.startUpShake(n);
    }

    public void GameScreenShadeclear() {
        this._scene.clearShake();
    }

    public void GameSetScenario(int n, int n2) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.setScenario(n, n2);
        Scene scene = GameMainLogic.getScene();
        scene.updateScriptState();
        if (n2 == 91) {
            GameMainLogic.getInstance().changeToInterface(9);
        }
        if (n2 == 1000) {
            this._scene.changeToStartShow();
        }
    }

    public void messageBox(String string) {
        this._scene.setInfo(string);
    }

    public void gameRestHandle() {
        this._scene.startupRest();
    }

    public void playSound(int n) {
    }

    public void stopSound() {
    }

    public void showSpecialWord(int n, String string, int n2, int n3) {
    }

    public void IncreaseThing(int n, int n2, int n3) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        switch (n) {
            case 9: {
                roleTeamData.increaseMoney(n2 * 100);
                break;
            }
            case 2: {
                roleTeamData.increaseThing(n2, n3);
                break;
            }
            case 5: {
                roleTeamData.increaseEquip(n2, n3);
                break;
            }
            case 4: {
                GameRoleData gameRoleData = roleTeamData.getRoleData(n3);
                gameRoleData.addSpecialSkillIndex(n2);
                gameRoleData.updateSkillIndex();
                break;
            }
            case 7: {
                roleTeamData.increaseMissionThing(n2);
                break;
            }
            case 8: {
                roleTeamData.increaseComposeScroll(n2);
                break;
            }
            case 3: {
                roleTeamData.increaseMaterial(n2, n3);
            }
        }
    }

    public void DisposeThing(int n, int n2, int n3) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        switch (n) {
            case 9: {
                roleTeamData.decreaseMoney(n2 * 100);
                break;
            }
            case 2: {
                roleTeamData.decreaseThing(n2, n3);
                break;
            }
            case 5: {
                roleTeamData.decreaseEquip(n2, n3);
                break;
            }
            case 4: {
                GameRoleData gameRoleData = roleTeamData.getRoleData(n3);
                gameRoleData.disSpecialSkillIndex(n2);
                break;
            }
            case 7: {
                roleTeamData.decreaseMissionThing(n2);
                break;
            }
            case 8: {
                roleTeamData.decreaseComposeScroll(n2);
                break;
            }
            case 3: {
                roleTeamData.decreaseMaterial(n2, n3);
            }
        }
    }

    public void OpenWeather(int n, int n2) {
    }

    public void CloseWeather() {
    }

    public void OpenClock() {
    }

    public void CloseClock() {
    }

    public void SetTime(int n) {
    }

    public void gameOpenShop(int n) {
        this._scene.changeToShop(n);
    }

    public boolean gameIsAllRoleFinishWalk() {
        return this._scene.isAllRoleFinishWalk();
    }

    public void gameMouse(String string) {
    }

    public void gameCreatAllRole() {
        this._scene.creatAllRole();
    }

    public void ClockHandle(int n, int n2, int n3, int n4) {
    }

    public void disposeAllRole() {
        this._scene.disposeAllRole();
    }

    public void gameTeamIn() {
        this._scene.teamIn();
    }

    public boolean isFinishDialog() {
        return this._scene.isFinishShowInfo();
    }

    public int gameResult() {
        return this._scene.getResult();
    }

    public void gameQuestion(String string, String string2, String string3) {
        this._scene.question(string, string2, string3);
    }

    public void gamePassLevel(int n, int n2, int n3) {
        if (n == 1 && RoleTeamData.getInstance().getScenario()[0] <= 3) {
            int n4 = 0;
            while (n4 < 2) {
                RoleTeamData.getInstance().getRoleData(n4).setLevel(1);
                ++n4;
            }
        }
        this._scene.passLevel(n, n2, n3);
    }

    public int GameGetCameraX() {
        int n = this._scene._camx >> 10;
        return n;
    }

    public int GameGetCameraY() {
        int n = this._scene._camy >> 10;
        return n;
    }

    public int GameGetCameraW() {
        int n = this._scene._camw >> 10;
        return n;
    }

    public int GameGetCameraH() {
        int n = this._scene._camh >> 10;
        return n;
    }

    public void GameLockCamera(int n, int n2) {
        this._scene.lockCamera((n << 4) - 160 << 10, (n2 << 4) - 120 << 10);
    }

    public void GameUnLockCamera() {
        this._scene.unlockCamera();
    }

    public boolean GameIsStableCamera() {
        return this._scene.isFocusInCamera();
    }

    public void GameSpringBattle(int n, int n2, int n3, int n4, int n5) {
        this._enemyIndex[0] = n;
        this._enemyIndex[1] = n2;
        this._enemyIndex[2] = n3;
        this._scene.springBattle(this._enemyIndex, n4, n5, false);
        if (this._scene.battleScriptCondition()) {
            this._scene.getGameLogic();
            GameMainLogic.getBattleScene()._scriptUnit = this._scene.getCurUnitData().getScriptUnit();
            this._scene.getGameLogic();
            GameMainLogic.getBattleScene().initScriptParam(this._scene.getCurUnitData().getCurScriptDataIndex());
        }
    }
}

