/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.other;

import com.sinaflying.game.GameMainLogic;
import com.sinaflying.other.GameInfo;
import com.sinaflying.other.UIHandler;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

public class MenuInterface
implements UIHandler {
    private GameInfo _gameInfo;
    private int _menuState = 0;
    private int _menuFram = 0;
    private int _menuStartX;
    private int _menuStartY;
    private static final int STATE_OPENING_SCROLL = 0;
    private static final int STATE_OPENED_SCROLL = 1;
    private static final int MENU_ANI_W = 232;
    private static final int MENU_ANI_H = 74;
    private static final int[][] _sptId = new int[][]{{43, 44}, {45, 46}, {47, 48}, {49, 50}, {51, 52}, {53, 54}};
    private static final int ITEM_SPT_MAX_W = 22;
    private static final int ITEM_SPT_MAX_H = 17;
    private int _itemStartX;
    private int _itemSpaceX;
    private int _itemStartY;
    private int _itemSpaceY;
    private static final int INDEX_SPT_ID = 25;
    private int _indexStartX;
    private int _indexStartY;
    private int _curItemIndex;
    private int _itemNum;

    private final void format() {
        this._itemNum = _sptId.length;
        this._menuStartX = 160;
        this._menuStartY = 74;
        this._itemStartX = 73;
        this._itemSpaceX = (180 - 22 * this._itemNum) / (this._itemNum - 1) + 22;
        this._itemStartY = 18;
        this._itemSpaceY = 74 - this._itemStartY * 2 - 34 + 17 + 2;
        this._indexStartX = this._itemStartX - 10;
        this._indexStartY = this._itemStartY + 4;
    }

    private final void initPage() {
        this._menuState = 0;
        this._menuFram = 0;
        this._curItemIndex = 0;
    }

    public final void draw(Graphics graphics, int n, int n2) {
        switch (this._menuState) {
            case 0: {
                this.paintBKOpening(graphics);
                break;
            }
            case 1: {
                this.paintBKOpened(graphics);
                this.paintIndexSpt(graphics);
                this.paintMenuItem(graphics);
            }
        }
    }

    public final void update() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        if (gameMainLogic.isPressConfirmKey()) {
            this.confirmHandle();
            gameMainLogic.resetCurKey();
            return;
        }
        if (gameMainLogic.isPressCancelKey()) {
            this.exitHandle();
            gameMainLogic.resetCurKey();
            return;
        }
        int n = gameMainLogic.getCurKey();
        gameMainLogic.resetCurKey();
        switch (n) {
            case 3: {
                this.preItemHandle();
                break;
            }
            case 5: {
                this.nextItemHandle();
            }
        }
    }

    private final void exitHandle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        gameMainLogic.recoverPreState();
        gameMainLogic.changeToWorldScene();
    }

    private final void nextItemHandle() {
        if (++this._curItemIndex >= this._itemNum) {
            this._curItemIndex = 0;
        }
    }

    private final void preItemHandle() {
        if (--this._curItemIndex < 0) {
            this._curItemIndex = this._itemNum - 1;
        }
    }

    private final void confirmHandle() {
        this._gameInfo.changeInterface(this._curItemIndex);
    }

    public final void reset() {
        this.initPage();
    }

    public MenuInterface(GameInfo gameInfo) {
        this._gameInfo = gameInfo;
        this.format();
    }

    private void paintBKOpened(Graphics graphics) {
        Function._ani_111.draw(graphics, this._menuStartX, this._menuStartY, 1, 0, 0);
    }

    private void paintBKOpening(Graphics graphics) {
        short s = Function._ani_111.getActFrmNum(0);
        Function._ani_111.draw(graphics, this._menuStartX, this._menuStartY, 0, this._menuFram, 0);
        ++this._menuFram;
        if (this._menuFram >= s) {
            this._menuState = 1;
        }
    }

    private void paintMenuItem(Graphics graphics) {
        int n = 0;
        while (n < _sptId.length) {
            int n2 = 0;
            while (n2 < _sptId[n].length) {
                Function.NUMBER.draw(graphics, this._itemStartX + n * this._itemSpaceX, this._itemStartY + n2 * this._itemSpaceY, _sptId[n][n2], 0x10 | 4);
                ++n2;
            }
            ++n;
        }
    }

    private void paintIndexSpt(Graphics graphics) {
        Function.PANEL.draw(graphics, this._indexStartX + this._curItemIndex * this._itemSpaceX, this._indexStartY, 25, 0x10 | 4);
    }
}

