/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.other;

import com.sinaflying.other.BattleInterface;
import com.sinaflying.other.ComposeInterface;
import com.sinaflying.other.EquipInterface;
import com.sinaflying.other.MenuInterface;
import com.sinaflying.other.MissionInterface;
import com.sinaflying.other.OptionInterface;
import com.sinaflying.other.RoleInterface;
import com.sinaflying.other.ThingInterface;
import com.sinaflying.other.UIHandler;
import javax.microedition.lcdui.Graphics;

public class GameInfo {
    private int _state;
    private static final int C_STATE_STABLE = 0;
    private static final int C_STATE_RENOVATE_TO_LEFT = 1;
    private static final int C_STATE_RENOVATE_TO_RIGHT = 2;
    private static final int C_STATE_RENOVATE_TO_TOP = 3;
    private static final int C_STATE_RENOVATE_TO_BOTTOM = 4;
    private int _currentInterface;
    private UIHandler[] _interface = new UIHandler[8];
    public boolean _scenePreDraw;
    private static final int C_RENOVATE_SPEED = 50;
    private int _renovatePosX;
    private int _renovatePosY;
    private boolean _onceDrawBK;
    private static GameInfo _inst;

    private final void init() {
        this._state = 0;
        this._scenePreDraw = true;
        this._currentInterface = 0;
        this._interface[0].reset();
    }

    public final void changeInterface(int n) {
        this._currentInterface = n + 1;
        if (this._interface[this._currentInterface] == null) {
            switch (this._currentInterface) {
                case 1: {
                    this._interface[1] = new RoleInterface(this);
                    break;
                }
                case 2: {
                    this._interface[2] = new ThingInterface(this);
                    break;
                }
                case 3: {
                    this._interface[3] = new EquipInterface(this);
                    break;
                }
                case 4: {
                    this._interface[4] = new BattleInterface(this);
                    break;
                }
                case 5: {
                    this._interface[5] = new ComposeInterface(this);
                    break;
                }
                case 6: {
                    this._interface[6] = new OptionInterface(this);
                    break;
                }
                case 7: {
                    this._interface[7] = new MissionInterface(this);
                }
            }
        }
        this._interface[this._currentInterface].reset();
        this.changeRenovateToBottom();
    }

    public final void changeToMenu() {
        this._currentInterface = 0;
        this.changeRenovateToBottom();
    }

    public final void changeRenovateToLeft() {
        this._state = 1;
        this._renovatePosX = 320;
        this._renovatePosY = 0;
    }

    public final void changeRenovateToRight() {
        this._state = 2;
        this._renovatePosX = -320;
        this._renovatePosY = 0;
    }

    public final void changeRenovateToTop() {
        this._state = 3;
        this._renovatePosX = 0;
        this._renovatePosY = 240;
    }

    public final void changeRenovateToBottom() {
        this._state = 4;
        this._renovatePosX = 0;
        this._renovatePosY = -240;
    }

    private final void changeToStable() {
        this._state = 0;
        this._scenePreDraw = true;
        this._renovatePosX = 0;
        this._renovatePosY = 0;
    }

    public final boolean dontDrawScene() {
        return this._state == 0;
    }

    public final void draw(Graphics graphics) {
        switch (this._state) {
            case 1: {
                this.paintForRenovateToLeft(graphics);
                break;
            }
            case 2: {
                this.paintForRenovateToRight(graphics);
                break;
            }
            case 3: {
                this.paintForRenovateToTop(graphics);
                break;
            }
            case 4: {
                this.paintForRenovateToBottom(graphics);
                break;
            }
            case 0: {
                this.paintForStable(graphics);
            }
        }
    }

    private final void paintForRenovateToLeft(Graphics graphics) {
        this._renovatePosX -= 50;
        if (this._renovatePosX <= 0) {
            this.changeToStable();
        }
        this._interface[this._currentInterface].draw(graphics, this._renovatePosX, this._renovatePosY);
    }

    private final void paintForRenovateToRight(Graphics graphics) {
        this._renovatePosX += 50;
        if (this._renovatePosX >= 0) {
            this.changeToStable();
        }
        this._interface[this._currentInterface].draw(graphics, this._renovatePosX, this._renovatePosY);
    }

    private final void paintForRenovateToTop(Graphics graphics) {
        this._renovatePosY -= 50;
        if (this._renovatePosY <= 0) {
            this.changeToStable();
        }
        this._interface[this._currentInterface].draw(graphics, this._renovatePosX, this._renovatePosY);
    }

    private final void paintForRenovateToBottom(Graphics graphics) {
        this._renovatePosY += 50;
        if (this._renovatePosY >= 0) {
            this.changeToStable();
        }
        this._interface[this._currentInterface].draw(graphics, 0, 0);
    }

    private final void paintForStable(Graphics graphics) {
        this._interface[this._currentInterface].draw(graphics, this._renovatePosX, this._renovatePosY);
        this._interface[this._currentInterface].update();
    }

    public final boolean drawSceneInfo() {
        if (this._state == 0 && this._currentInterface != 0 && !this._onceDrawBK) {
            return false;
        }
        if (this._onceDrawBK) {
            this._onceDrawBK = false;
        }
        return true;
    }

    public void openOnceDrawBK() {
        this._onceDrawBK = true;
    }

    public static final GameInfo getInstance() {
        if (_inst == null) {
            _inst = new GameInfo();
        }
        _inst.init();
        return _inst;
    }

    private GameInfo() {
        this._interface[0] = new MenuInterface(this);
    }
}

