/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.gameUtil;

import com.sinaflying.effect.FireFly;
import com.sinaflying.engine.Animation;
import com.sinaflying.engine.SptSet;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.gameUtil.MessageBoxHandler;
import com.sinaflying.other.EquipInterface;
import com.sinaflying.util.Function;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MessageBox {
    private MessageBoxHandler _handler;
    private int _style;
    public static final int C_STYLE_DIALOG = 0;
    public static final int C_STYLE_MULTIROW = 1;
    public static final int C_STYLE_SINGLE_PAGE = 2;
    public static final int C_STYLE_QUESTION = 3;
    public static final int C_STYLE_SUCCEED = 4;
    public static final int C_STYLE_BUY = 5;
    public static final int C_STYLE_SINGLE_SCROLL = 6;
    public static final int C_STYLE_VICTORY = 7;
    public static final int C_STYLE_LEVEL_UP = 9;
    public static final int C_STYLE_NEW_MULTIROW = 10;
    private int _menuBKX;
    private int _menuBKY;
    private int _answerInx;
    private static final int C_MAX_QUESTION_NUM = 5;
    private String[] _question = new String[5];
    private int[] _questionLineNum = new int[5];
    private int _answerNum;
    private int _questionValidNum;
    private int _questionFrameX;
    private int _questionFrameY;
    private int _questionFrameW;
    private int _questionFrameH;
    private int _questionContentX;
    private int _questionContentY;
    private int _questionLineSpace;
    private int _questionWordNumInLine;
    public static final int C_QUESTION_POSITION_TOP = 0;
    public static final int C_QUESTION_POSITION_MIDDLE = 1;
    public static final int C_QUESTION_POSITION_BOTTOM = 2;
    private String _singlePageContext;
    private int _singlePageFrameX;
    private int _singlePageFrameY;
    private int _singlePageFrameW;
    private int _singlePageFrameH;
    private int _singlePageInfoX;
    private int _singlePageInfoY;
    private int _singleBKX;
    private int _singleBKY;
    private int _singlePageWordNumInLine;
    private int _singlePageLineNum;
    private int _stayTime = 0;
    private boolean _isPressKeyDis = false;
    private int _time1;
    private int _time2;
    private int _time3;
    private int _time4;
    private int _time5;
    private static final int TIME = 15;
    private static final int TIMESPACE = 3;
    private int[] _time;
    private int[] _timeSpace;
    private int _breakTime;
    private int _breakPoint;
    private int _nextPagePoint;
    private int _nextPageTime;
    private int _nextPageIndex;
    private int[] _action;
    private int _tempTime;
    private String _money;
    private String _exp;
    private String[] _thing;
    private String[] _levelUpInfo;
    private int _paintVictoryState;
    private int _index;
    private int _singleScrollAction;
    private static final int C_MAX_MULTI_ROW_NUM = 30;
    private String[] _multiRowContext = new String[30];
    private int _multiRowNum;
    private int _multiRowPage;
    private int _multiRowPageNum;
    private int _multiRowFrameX;
    private int _multiRowFrameY;
    private int _multiRowFrameW;
    private int _multiRowFrameH;
    private int _multiRowWordNumInLine;
    private int _multiRowNumInPage;
    private int _multiRowSpace;
    private int _multiRowStartY;
    private boolean _isHaveTitle;
    private String[] _roleLevelUpOldInfo = new String[4];
    private String[] _roleLevelUpNewInfo = new String[4];
    private String _roleLevelUpName;
    private String _roleLevelUpNewSkill;
    private static final int LEVEL_UP_ROLE_NAME = 0;
    private static final int LEVEL_UP_NEW_SKILL = 9;
    private int _levelUpRoleNameX;
    private int _levelUpRoleNameY;
    private int _levelUpItemNameStartX;
    private int _levelUpOldItemStartX;
    private int _levelUpNewItemStartX;
    private int _levelUpItemSeparatorStartX;
    private int _levelUpItemStartY;
    private int _levelUpItemSpace;
    private int[] _equipColor;
    private int _multiInfoStartX;
    private int _dialogHeadInx;
    private int _expression;
    private static final int C_MAX_DIALOG_PAGE_NUM = 20;
    private String[] _dialogContext = new String[20];
    private int _dialogPageNum;
    private int _dialogPage;
    private int _dialogWordOffset;
    private static final int C_DIALOG_SHOW_WORD_SPEED = 1;
    private static final int C_DIALOG_SHOW_WORD_ACC_SPEED = 5;
    private boolean _isCurrentPageFinish;
    private int _dialogFrameX;
    private int _dialogFrameY;
    private int _dialogFrameW;
    private int _dialogFrameH;
    private int _dialogWordNumInLine;
    private int _dialogX;
    private int _dialogY;
    private int _headX;
    private int _dialogLineNum;
    private int dialog_frame_index;
    private String _name;
    private int _dialogNameX;
    private int _dialogNameY;
    private int _dialogNameW;
    private int _dialogNameH;
    private int _keyFlag;
    private boolean _sheltKeyFlag;
    private static MessageBox _instance;
    public static final int C_STYLE_POEMS = 8;
    private String[] _poems;
    private int[][] _poemIds;
    private boolean _isPoemsFinish;
    private int _PoemsCount;
    private int _startX;
    private int _startY;
    private int _wordStyle;
    private FireFly _f;
    private int _newMultRowItemStartY;
    private int _newMultRowItemSpace;
    private int _newMultRowItemNameStartX;
    private int _newMultRowItem1StartX;
    private int _newMultRowItem2StartX;
    private String[] _newMultRowItemNameInfo;
    private int[] _newMultRowItem1Info;
    private int[] _newMultRowItem2Info;
    private int _newMultRowItemSeparatorStartX;
    private int[] _color;

    public final int getStyle() {
        return this._style;
    }

    public final void draw(Graphics graphics) {
        switch (this._style) {
            case 0: {
                this.paintForDialogStyle(graphics);
                this.keyRespondForDialogStyle();
                break;
            }
            case 1: {
                this.paintForMultiRowStyle(graphics);
                this.keyRespondForMultiRowStyle();
                break;
            }
            case 2: {
                this.paintForSinglePageStyle(graphics);
                this.keyRespondForSinglePageStyle();
                break;
            }
            case 3: {
                this.paintForQuestionStyle(graphics);
                this.keyRespondForQuestionStyle();
                break;
            }
            case 4: {
                this.paintForSucceedStyle(graphics);
                this.keyRespondForSinglePageStyle();
                break;
            }
            case 5: {
                this.paintForBuyStyle(graphics);
                this.keyRespondForBuyStyle();
                break;
            }
            case 6: {
                this.paintForSingleScrollStyle(graphics);
                this.keyRespondForSingleScrollStyle();
                break;
            }
            case 7: {
                this.paintForVictoryStyle1(graphics);
                break;
            }
            case 8: {
                this.paintForPoemsStyle(graphics);
                this.keyRespondForPoemsStyle();
                break;
            }
            case 9: {
                this.paintLevelUpInfoInfo(graphics);
                break;
            }
            case 10: {
                this.paintNewMultRowInfo(graphics);
                this.keyRespondForNewMultiRowStyle();
            }
        }
    }

    private final void finishShowHandler() {
        MessageBoxHandler messageBoxHandler = this._handler;
        this.dispose();
        messageBoxHandler.finishHandle(this._answerInx);
    }

    public final void dispose() {
        this._handler = null;
        this._singlePageContext = null;
        this._poemIds = null;
        this._poems = null;
        int n = 0;
        while (n < 20) {
            this._dialogContext[n] = null;
            ++n;
        }
        int n2 = 0;
        while (n2 < 30) {
            this._multiRowContext[n2] = null;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 5) {
            this._question[n3] = null;
            ++n3;
        }
    }

    private final void setEnvironment(Graphics graphics) {
        graphics.setColor(0xFDFDFD);
        graphics.setClip(0, 0, 320, 240);
    }

    private final void clearKey() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        gameMainLogic.resetCurKey();
    }

    public final void initQuestionStyle(String[] stringArray, int n) {
        this.initQusetion(stringArray, n);
    }

    public final void initQuestionStyle(String[] stringArray) {
        this.initQusetion(stringArray, 2);
    }

    private final void initQusetion(String[] stringArray, int n) {
        this._style = 3;
        this._answerInx = 0;
        this._questionValidNum = stringArray.length;
        this._answerNum = this._questionValidNum - 1;
        System.arraycopy(stringArray, 0, this._question, 0, stringArray.length);
        this.formatQuestion(n);
        Function.initAlphaArray(3550053, 64);
        this.clearKey();
    }

    private final void formatQuestion(int n) {
        int n2 = 12;
        this._questionWordNumInLine = (320 - (n2 << 1)) / Function.C_WORD_W;
        this._questionContentX = 25;
        this._questionLineSpace = Function.C_WORD_H;
        int n3 = 0;
        while (n3 < this._questionValidNum) {
            this._questionLineNum[n3] = this._question[n3].length() / this._questionWordNumInLine;
            if (this._question[n3].length() % this._questionWordNumInLine != 0) {
                int n4 = n3;
                this._questionLineNum[n4] = this._questionLineNum[n4] + 1;
            }
            ++n3;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < this._questionValidNum) {
            n5 += this._questionLineNum[n6];
            ++n6;
        }
        int n7 = n5 * this._questionLineSpace;
        this._questionFrameX = 0;
        this._questionFrameW = 320;
        this._questionFrameH = n7 + (Function.getFrameThickness() << 1);
        this._questionFrameY = this.getFrameY(n, this._questionFrameH);
        this._questionContentY = this._questionFrameY + Function.getFrameThickness();
    }

    private final int getFrameY(int n, int n2) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 240 - n2 >> 1;
            }
            case 2: {
                return 240 - n2;
            }
        }
        return 0;
    }

    private final void paintForQuestionStyle(Graphics graphics) {
        this.drawFrame(graphics);
        int n = this._questionContentY;
        int n2 = 0;
        while (n2 < this._questionValidNum) {
            Function.drawWordLines(graphics, this._questionContentX, n, Function.C_WORD_W, this._questionLineSpace, this._question[n2], 0, this._questionWordNumInLine, this._questionLineNum[n2], 0xFDFDFD);
            n += this._questionLineNum[n2] * this._questionLineSpace;
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this._answerInx + 1) {
            n3 += this._questionLineNum[n4];
            ++n4;
        }
        Function.paintCursor(graphics, this._questionContentX, this._questionContentY + n3 * this._questionLineSpace + (this._questionLineSpace >> 1));
    }

    private final void keyRespondForQuestionStyle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        int n = gameMainLogic.getCurKey();
        this.clearKey();
        switch (n) {
            case 4: {
                this.finishShowHandler();
                break;
            }
            case 1: {
                this._answerInx = Math.max(0, --this._answerInx);
                break;
            }
            case 7: {
                this._answerInx = Math.min(this._answerNum - 1, ++this._answerInx);
            }
        }
    }

    private final void keyRespondForBuyStyle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        if (gameMainLogic.isPressCancelKey()) {
            this._answerInx = this._answerNum - 1;
            this.finishShowHandler();
        } else if (gameMainLogic.isPressConfirmSoftKey()) {
            this.finishShowHandler();
        }
        int n = gameMainLogic.getCurKey();
        this.clearKey();
        switch (n) {
            case 4: {
                this.finishShowHandler();
                break;
            }
            case 1: {
                this._answerInx = Math.max(0, --this._answerInx);
                break;
            }
            case 7: {
                this._answerInx = Math.min(this._answerNum - 1, ++this._answerInx);
            }
        }
    }

    public final void initSinglePageStyle(String string) {
        this._style = 2;
        this.calculateSinglePage();
        this.formatSinglePage(string);
        this.clearKey();
    }

    public final void initSingleScrollStyle(String string) {
        this._stayTime = 0;
        this._isPressKeyDis = true;
        this._style = 6;
        this.formatSingleScroll(string);
        this.clearKey();
    }

    public final void initSingleScrollStyle(String string, int n) {
        this._stayTime = n;
        this._isPressKeyDis = false;
        this._style = 6;
        this.formatSingleScroll(string);
        this.clearKey();
    }

    public final void initVictoryStyle(String[] stringArray, String[] stringArray2) {
        this._style = 7;
        this._tempTime = 0;
        this._time2 = this._time1 = 15;
        this._time3 = this._time1;
        this._time4 = this._time1;
        this._time5 = this._time1;
        this._money = stringArray[1];
        this._exp = stringArray[0];
        this._thing = stringArray2;
        this._paintVictoryState = 0;
    }

    public final void initVictoryStyle(String[] stringArray, int n) {
        this._style = 7;
        this._tempTime = 0;
        this._time = new int[stringArray.length];
        this._timeSpace = new int[stringArray.length];
        this._action = new int[stringArray.length];
        int n2 = 0;
        while (n2 < this._time.length) {
            this._time[n2] = 15;
            this._timeSpace[n2] = 0;
            if (n > 0) {
                this._action[0] = 5;
                this._action[1] = 6;
                this._action[2] = 7;
                this._action[3] = 5;
                this._action[4] = 5;
                if (stringArray[n2] == null) {
                    if (n2 == 0) {
                        this._breakTime = 0;
                        break;
                    }
                    if (n2 < 4 && n2 > 0) {
                        this._breakTime = 15 + (n2 - 1) * 3;
                        break;
                    }
                    this._breakTime = 30 + (n2 - 1) * 3;
                    break;
                }
            } else {
                this._action[n2] = 6;
                if (stringArray[n2] == null) {
                    if (n2 == 0) {
                        this._breakTime = 0;
                        break;
                    }
                    this._breakTime = 15 + (n2 - 1) * 3;
                    break;
                }
                this._breakTime = n2 == 0 ? 20 : 15 + (n2 - 1) * 3;
            }
            ++n2;
        }
        this._nextPagePoint = 0;
        this._breakPoint = 0;
        this._nextPageTime = this._time[0] + n * 3;
        this._time2 = this._time1 = 15;
        this._time3 = this._time1;
        this._time4 = this._time1;
        this._time5 = this._time1;
        this._levelUpInfo = stringArray;
        this._paintVictoryState = 2;
        this._index = 0;
        this._nextPageIndex = n;
    }

    private void paintForVictoryStyle1(Graphics graphics) {
        int n = 0;
        int n2 = this._nextPageIndex;
        int n3 = 0;
        if (this._nextPageIndex > 0) {
            if (++this._nextPagePoint > this._nextPageTime) {
                n = this._nextPageIndex;
                n2 = this._time.length;
            }
        } else {
            n2 = this._time.length;
        }
        int n4 = n;
        while (n4 < n2) {
            if (this._levelUpInfo[n4] == null) {
                if (n4 != 0) break;
                this.finishShowHandler();
                break;
            }
            n3 = n > 0 ? n4 - n : n4;
            int n5 = n4;
            int n6 = this._timeSpace[n5];
            this._timeSpace[n5] = n6 + 1;
            if (n6 > n3 * 3) {
                int n7 = n4;
                this._time[n7] = this._time[n7] - 1;
                if (this._time[n7] > 0) {
                    Function._ani_111.draw(graphics, 160, 80 + n3 * 53, this._action[n4], 0, 0);
                    graphics.setClip(0, 0, 320, 240);
                    Function.drawString(graphics, this._levelUpInfo[n4], 160, 70 + n3 * 53, 0x10 | 1);
                }
            }
            ++n4;
        }
        if (++this._breakPoint > this._breakTime) {
            this.finishShowHandler();
        }
    }

    private final void paintForSinglePageStyle(Graphics graphics) {
        Function.drawWordLines(graphics, this._singlePageInfoX, this._singlePageInfoY, Function.C_WORD_W, Function.C_WORD_H, this._singlePageContext, 0, this._singlePageWordNumInLine, this._singlePageLineNum, 0xFDFDFD);
    }

    private final void keyRespondForSinglePageStyle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        int n = gameMainLogic.getCurKey();
        this.clearKey();
        if (n == 4) {
            this.finishShowHandler();
        }
    }

    private final void paintForSingleScrollStyle(Graphics graphics) {
        Function._ani_111.draw(graphics, this._singleBKX, this._singleBKY, this._singleScrollAction, 0, 0);
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        Function.drawString(graphics, this._singlePageContext, this._singlePageInfoX, this._singlePageInfoY, 1 | 0x10);
    }

    private final void keyRespondForSingleScrollStyle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        if (gameMainLogic.isPressCancelSoftKey()) {
            this.finishShowHandler();
        }
        int n = gameMainLogic.getCurKey();
        this.clearKey();
        if (this._isPressKeyDis) {
            if (n == 4) {
                this.finishShowHandler();
            }
        } else if (--this._stayTime < 0) {
            this._stayTime = 0;
            this.finishShowHandler();
        }
    }

    private final void formatSinglePage(String string) {
        this._singlePageContext = string;
        this._singleBKX = 160;
        this._singleBKY = 80;
        this._singlePageInfoX = 160;
        this._singlePageInfoY = this._singleBKY - 9;
    }

    private void formatSingleScroll(String string) {
        this._singlePageContext = string;
        this._singleScrollAction = string.length() > 5 && string.length() <= 8 ? 6 : (string.length() > 8 ? 7 : 5);
        this._singleBKX = 160;
        this._singleBKY = 80;
        this._singlePageInfoX = 160;
        this._singlePageInfoY = this._singleBKY - 9;
    }

    private final void calculateSinglePage() {
        this._singlePageWordNumInLine = 8;
        int n = Function.C_WORD_W / 2;
    }

    public final void initMultiRowStyle(String[] stringArray, int n, boolean bl) {
        this._style = 1;
        this._multiRowPage = 0;
        this.calculateMultiRowFormat();
        this._isHaveTitle = bl;
        this.formatMultiContext(stringArray, n);
        this.clearKey();
    }

    private void calculateLevelUpInfoStyle() {
        this._levelUpRoleNameX = 160;
        this._levelUpRoleNameY = 48;
        this._levelUpItemNameStartX = 100;
        this._levelUpOldItemStartX = this._levelUpItemNameStartX + 40;
        this._levelUpItemSeparatorStartX = this._levelUpItemNameStartX + 75;
        this._levelUpNewItemStartX = this._levelUpItemNameStartX + 105;
        this._levelUpItemStartY = this._levelUpRoleNameY + 50;
        this._levelUpItemSpace = Function.C_WORD_SPACE_Y;
    }

    public final void initLevelUpInfoStyle(String[] stringArray) {
        this._style = 9;
        this._roleLevelUpNewSkill = null;
        this._breakPoint = 0;
        this._breakTime = 18;
        this._roleLevelUpName = stringArray[0];
        int n = 0;
        while (n < this._roleLevelUpOldInfo.length) {
            this._roleLevelUpOldInfo[n] = stringArray[n + 1];
            ++n;
        }
        int n2 = 0;
        while (n2 < this._roleLevelUpNewInfo.length) {
            this._roleLevelUpNewInfo[n2] = stringArray[n2 + 1 + this._roleLevelUpOldInfo.length];
            ++n2;
        }
        if (stringArray.length > 9) {
            this._roleLevelUpNewSkill = stringArray[9];
        }
        this.clearKey();
    }

    private final void paintLevelUpInfoInfo(Graphics graphics) {
        this.setEnvironment(graphics);
        int n = this._levelUpItemStartY;
        Function._ani_111.draw(graphics, 160, this._levelUpRoleNameY + 8, 5, 0, 0);
        if (this._roleLevelUpNewSkill != null) {
            Function._ani_111.draw(graphics, 160, this._levelUpItemStartY + 38, 4, 0, 0);
        } else {
            Function._ani_111.draw(graphics, 160, this._levelUpItemStartY + 38, 25, 0, 0);
        }
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        Function.drawString(graphics, this._roleLevelUpName, this._levelUpRoleNameX, this._levelUpRoleNameY, 0x10 | 1);
        int n2 = 0;
        while (n2 < GameParameter.LEVLE_UP_ITEM_NAME.length) {
            Function.PANEL.draw(graphics, this._levelUpItemSeparatorStartX, n, 11, 0x10 | 4);
            Function.draw3DString(graphics, GameParameter.LEVLE_UP_ITEM_NAME[n2], this._levelUpItemNameStartX, n, 4 | 0x10, 0, 0xFFFFFF);
            graphics.setClip(0, 0, 320, 240);
            graphics.setColor(0);
            Function.drawString(graphics, this._roleLevelUpOldInfo[n2], this._levelUpOldItemStartX, n, 0x10 | 4);
            Function.drawString(graphics, this._roleLevelUpNewInfo[n2], this._levelUpNewItemStartX, n, 0x10 | 4);
            n += this._levelUpItemSpace;
            ++n2;
        }
        if (this._roleLevelUpNewSkill != null) {
            Function.drawString(graphics, this._roleLevelUpNewSkill, this._levelUpItemNameStartX, n, 0x10 | 4);
        }
        if (++this._breakPoint > this._breakTime) {
            this.finishShowHandler();
        }
    }

    public final void initMultiRowStyle(String[] stringArray, int[] nArray, int n, boolean bl) {
        this._style = 1;
        this._equipColor = new int[nArray.length];
        this._equipColor = nArray;
        this._multiRowPage = 0;
        this.calculateMultiRowFormat();
        this._isHaveTitle = bl;
        this.formatMultiContext(stringArray, n);
        this.clearKey();
    }

    private final void paintForMultiRowStyle(Graphics graphics) {
        this.paintMultiRowInfo(graphics);
    }

    private final void paintMultiRowInfo(Graphics graphics) {
        this.setEnvironment(graphics);
        String[] stringArray = this._multiRowContext;
        int n = this._multiRowFrameX + this._multiRowFrameW / 10;
        int n2 = this._multiRowStartY;
        int n3 = this._multiRowSpace;
        int n4 = this._multiRowNumInPage;
        if (this._multiRowPage == 0 && this._isHaveTitle) {
            n4 = (this._multiRowFrameH - 12) / this._multiRowSpace;
        }
        int n5 = this._multiRowPage * n4;
        int n6 = Math.min(n5 + n4, this._multiRowNum);
        if (this._multiRowPage == 0 && this._isHaveTitle) {
            int n7 = 160;
            n2 -= 5;
            n2 += Function.C_WORD_H / 2 + 5;
        }
        Function._ani_111.draw(graphics, 160, 160, 4, 0, 0);
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        while (n5 != n6) {
            Function.drawString(graphics, stringArray[n5], 160, n2, 0x10 | 1);
            n2 += n3;
            ++n5;
        }
    }

    private final void keyRespondForMultiRowStyle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        int n = gameMainLogic.getCurKey();
        this.clearKey();
        if (n != 4) {
            return;
        }
        if (++this._multiRowPage == this._multiRowPageNum) {
            this.finishShowHandler();
        }
    }

    private final void calculateMultiRowFormat() {
        this._multiRowFrameW = 213;
        this._multiRowFrameH = 144 - Function.C_WORD_H;
        this._multiRowFrameX = 320 - this._multiRowFrameW;
        this._multiRowFrameY = 240 - this._multiRowFrameH;
        this._multiRowFrameX /= 2;
        this._multiRowFrameY /= 2;
        this._multiInfoStartX = this._multiRowFrameX + this._multiRowFrameW / 10;
        int n = 12;
        this._multiRowSpace = Function.C_WORD_H;
        int n2 = this._multiRowFrameH - n;
        this._multiRowNumInPage = n2 / this._multiRowSpace;
        this._multiRowStartY = this._multiRowFrameY + (this._multiRowFrameH - this._multiRowNumInPage * this._multiRowSpace >> 1);
        this._multiRowWordNumInLine = this._multiRowFrameW - this._multiRowFrameW / 10 * 2 / Function.C_WORD_W;
    }

    private final void formatMultiContext(String[] stringArray, int n) {
        this._multiRowNum = 0;
        int n2 = 0;
        while (n2 < n) {
            this.addMultiRowContext(stringArray[n2]);
            ++n2;
        }
        this._multiRowPageNum = this._multiRowNum / this._multiRowNumInPage;
        if (this._multiRowNum % this._multiRowNumInPage != 0) {
            ++this._multiRowPageNum;
        }
    }

    private final void addMultiRowContext(String string) {
        int n = string.length();
        int n2 = n - this._multiRowWordNumInLine;
        int n3 = 0;
        n3 = 0;
        while (n3 <= n2) {
            int n4 = n3 + this._multiRowWordNumInLine;
            this._multiRowContext[this._multiRowNum++] = string.substring(n3, n4);
            n3 = n4;
        }
        if (n3 < n) {
            this._multiRowContext[this._multiRowNum++] = string.substring(n3, n);
        }
    }

    public final void initSucceedStyle(String string) {
        this._style = 4;
        this._singlePageFrameW = 160;
        this._singlePageFrameX = (320 - this._singlePageFrameW) / 2;
        int n = (this._singlePageFrameW - this._singlePageWordNumInLine * Function.C_WORD_W) / 2;
        this._singlePageInfoX = this._singlePageFrameX + n;
        this._singlePageFrameH = Function.C_WORD_H * 3;
        this._singlePageInfoY = 120 - Function.C_WORD_H / 2;
        this._singlePageFrameY = 240 - this._singlePageFrameH >> 1;
        this._singlePageContext = string;
        this.clearKey();
    }

    public final void initDialogStyle(int n, String string, String string2, int n2, int n3) {
        this._style = 0;
        this._dialogHeadInx = n;
        this._name = string.trim();
        this._expression = n2;
        switch (n3) {
            case 1: 
            case 2: {
                this.dialog_frame_index = 2;
                break;
            }
            case 3: 
            case 4: {
                this.dialog_frame_index = 4;
            }
        }
        Animation.load(this._dialogHeadInx, 2);
        this.deivideDialog(string2);
        this.startupDialog();
        this.clearKey();
        this.setsheltKeys(false);
    }

    private final void startupDialog() {
        this._dialogPage = -1;
        this.nextPage();
    }

    private final boolean isExistNextPage() {
        return this._dialogPage < this._dialogPageNum - 1;
    }

    private final void nextPage() {
        ++this._dialogPage;
        this._dialogWordOffset = 0;
        this._isCurrentPageFinish = false;
    }

    private final void deivideDialog(String string) {
        int n;
        string = Function.initWordOffset(string);
        this._dialogPageNum = 0;
        int n2 = string.length();
        int n3 = this._dialogWordNumInLine * this._dialogLineNum;
        int n4 = 0;
        do {
            n = Math.min(n4 + n3, n2);
            this._dialogContext[this._dialogPageNum++] = string.substring(n4, n);
        } while ((n4 = n) < n2);
    }

    private final void calculateFormatForDialog() {
        int n = 2;
        int n2 = Function.C_WORD_H * 3 + 6 + n * 2 + 5;
        int n3 = 0;
        this._dialogFrameH = n2;
        this._dialogFrameY = 240 - this._dialogFrameH;
        this._dialogFrameW = 320 - n3 * 2;
        this._dialogFrameX = n3;
        this._dialogNameH = 3 + Function.C_WORD_H;
        this._dialogNameX = this._dialogFrameX + Function.C_WORD_W;
        this._dialogNameY = this._dialogFrameY + n;
        this._dialogLineNum = (this._dialogFrameH - this._dialogNameH - 4) / Function.C_WORD_H;
        this._dialogY = this._dialogFrameY + this._dialogNameH + n;
        this._dialogX = this._dialogNameX + 5;
        this._dialogWordNumInLine = (320 - this._dialogX * 2) / Function.C_WORD_W;
    }

    private final void paintForDialogStyle(Graphics graphics) {
        this.drawFrame(graphics);
        this.drawSpeakerInfo(graphics);
        this.drawDialogContent(graphics);
    }

    private void paintForSucceedStyle(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        Function.drawString(graphics, this._singlePageContext, 160, this._singlePageInfoY, 0x10 | 1);
    }

    private void paintForBuyStyle(Graphics graphics) {
        Function._ani_111.draw(graphics, this._menuBKX, this._menuBKY, 15, 0, 0);
        graphics.setClip(0, 0, 320, 240);
        int n = this._questionContentY;
        int n2 = 0;
        while (n2 < this._questionValidNum) {
            if (this._answerInx == n2) {
                Function.draw3DString(graphics, this._question[n2], 160, n, 0x10 | 1, 16740864, 0xFFFFFF);
            } else {
                graphics.setColor(0);
                Function.drawString(graphics, this._question[n2], 160, n, 0x10 | 1);
            }
            n += this._questionLineSpace;
            ++n2;
        }
    }

    private final void drawFrame(Graphics graphics) {
        Function.drawAlpha(graphics, 0, this._dialogFrameY, 320, this._dialogFrameH);
        graphics.setClip(0, 0, 320, 240);
        int n = 12;
        int n2 = 6;
        graphics.setColor(1254966);
        graphics.drawLine(n, this._dialogFrameY - 1, 320 - n, this._dialogFrameY - 1);
        graphics.setColor(11067135);
        graphics.drawLine(n, this._dialogFrameY - 2, 320 - n, this._dialogFrameY - 2);
        graphics.setColor(1254966);
        graphics.drawLine(n, this._dialogFrameY - 3, 320 - n, this._dialogFrameY - 3);
        graphics.setColor(4356570);
        graphics.drawLine(n, this._dialogFrameY - 4, 320 - n, this._dialogFrameY - 4);
        graphics.setColor(11067135);
        graphics.drawLine(n, this._dialogFrameY - 5, 320 - n, this._dialogFrameY - 5);
        graphics.setColor(1254966);
        graphics.drawLine(n, this._dialogFrameY - 6, 320 - n, this._dialogFrameY - 6);
        graphics.setColor(11067135);
        graphics.drawLine(n, 239, 320 - n, 239);
        SptSet sptSet = SptSet.load(125, 2);
        sptSet.draw(graphics, sptSet.getSptWidth(4), this._dialogFrameY - n2, -2147483644);
        sptSet.draw(graphics, sptSet.getSptWidth(4), this._dialogFrameY + sptSet.getSptHeight(4) - n2, -2147483643);
        sptSet.draw(graphics, sptSet.getSptWidth(4), 244, -1073741820);
        sptSet.draw(graphics, 320 - sptSet.getSptWidth(4), this._dialogFrameY - n2, 4);
        sptSet.draw(graphics, 320 - sptSet.getSptWidth(4), this._dialogFrameY - n2 + sptSet.getSptHeight(4), 5);
        sptSet.draw(graphics, 320 - sptSet.getSptWidth(4), 244, 0x40000004);
    }

    private final void drawSpeakerInfo(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        if (this._dialogHeadInx != -1) {
            Animation animation = Animation.load(this._dialogHeadInx, 2);
            switch (this.dialog_frame_index) {
                case 4: {
                    animation.draw(graphics, 320, this._dialogFrameY - 5, this._expression | Integer.MIN_VALUE, 0, 0);
                    break;
                }
                case 2: {
                    animation.draw(graphics, 3, this._dialogFrameY - 5, this._expression, 0, 0);
                }
            }
        }
        switch (this.dialog_frame_index) {
            case 2: {
                graphics.setClip(0, 0, 320, 240);
                graphics.setColor(16550916);
                Function.drawString(graphics, this._name, this._dialogNameX, this._dialogNameY, 4 | 0x10);
                break;
            }
            case 4: {
                graphics.setClip(0, 0, 320, 240);
                graphics.setColor(16550916);
                Function.drawString(graphics, this._name, 320 - this._dialogNameX, this._dialogNameY, 8 | 0x10);
            }
        }
    }

    private final void drawDialogContent(Graphics graphics) {
        int n = this._dialogX;
        switch (this.dialog_frame_index) {
            case 1: {
                this._isCurrentPageFinish = Function.drawWordOffset(graphics, n, 80 - (240 - this._dialogY), Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
                break;
            }
            case 2: {
                this._isCurrentPageFinish = Function.drawWordOffset(graphics, n, this._dialogY, Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
                break;
            }
            case 3: {
                this._isCurrentPageFinish = Function.drawWordOffset(graphics, n, 80 - (240 - this._dialogY), Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
                break;
            }
            case 4: {
                this._isCurrentPageFinish = Function.drawWordOffset(graphics, n, this._dialogY, Function.C_WORD_W, Function.C_WORD_H, this._dialogContext[this._dialogPage], this._dialogWordOffset, this._dialogWordNumInLine, 0xFDFDFD, this._dialogPage);
            }
        }
    }

    private final void keyRespondForDialogStyle() {
        ++this._dialogWordOffset;
        if (this._sheltKeyFlag) {
            return;
        }
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        int n = gameMainLogic.getCurKey();
        switch (n) {
            case 4: {
                this._dialogWordOffset += 5;
                if (!this._isCurrentPageFinish) break;
                if (this.isExistNextPage()) {
                    this.nextPage();
                    break;
                }
                this.finishShowHandler();
            }
        }
    }

    public final void setsheltKeys(boolean bl) {
        this._sheltKeyFlag = bl;
    }

    public static final MessageBox getInstance(MessageBoxHandler messageBoxHandler) {
        if (_instance == null) {
            _instance = new MessageBox();
        }
        _instance.init(messageBoxHandler);
        return _instance;
    }

    private final void init(MessageBoxHandler messageBoxHandler) {
        this._handler = messageBoxHandler;
    }

    public final void initBuyStyle(String[] stringArray, int n) {
        this._style = 5;
        this._answerInx = 0;
        this._answerNum = this._questionValidNum = stringArray.length;
        System.arraycopy(stringArray, 0, this._question, 0, stringArray.length);
        int n2 = 12;
        this._questionContentX = 160;
        this._questionLineSpace = Function.C_WORD_SPACE_Y;
        this._questionContentY = 78;
        this._menuBKX = 160;
        this._menuBKY = 48;
        this.clearKey();
    }

    private MessageBox() {
        this.calculateFormatForDialog();
        this.calculateSinglePage();
        this.calculateLevelUpInfoStyle();
    }

    public String[] devidePoems(String string) {
        Vector<String> vector = new Vector<String>();
        while (string.indexOf(",") > 0) {
            String string2 = string.substring(0, string.indexOf(","));
            string = string.substring(string2.length() + 1, string.length());
            vector.addElement(string2);
        }
        vector.addElement(string);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final void initPoemsStyle(String string) {
        this._PoemsCount = 0;
        this._style = 8;
        this._isPoemsFinish = false;
        this._poems = this.devidePoems(string);
        this._startX = -this._poems.length * Function.C_WORD_W * 2;
        this._startY = 30;
        this._wordStyle = 0;
        this._f = FireFly.getFireFly(320, 240, 0, 0);
        Function.initAlphaArray(3550053, 85);
    }

    public final void initPoemsStyle(int[][] nArray) {
        this._PoemsCount = 0;
        this._style = 8;
        this._isPoemsFinish = false;
        this._wordStyle = 1;
        this._poemIds = nArray;
        this._startX = 240;
        this._startY = 21;
    }

    public final void paintForPoemsStyle(Graphics graphics) {
        if (this._f != null) {
            Function.drawAlpha(graphics, 0, 0, 320, 240);
            this._f.paint(graphics);
            this._f.update(0, 0);
        }
        if (this._poems != null && this._poems.length <= 6) {
            int n = 300;
            if (!this._isPoemsFinish && ++this._PoemsCount / 35 > this._poems.length - 1) {
                this._isPoemsFinish = true;
            }
            int n2 = 0;
            while (n2 < this._PoemsCount / 35) {
                Function.drawVertical(graphics, this._poems[n2].toCharArray(), n, this._startY, 35);
                n -= Function.C_WORD_W * 2;
                ++n2;
            }
            if (!this._isPoemsFinish) {
                Function.drawVertical(graphics, this._poems[this._PoemsCount / 35].toCharArray(), n, this._startY, this._PoemsCount % 35);
            }
        } else if (this._wordStyle == 1) {
            int n = this._startX;
            if (!this._isPoemsFinish && ++this._PoemsCount / 35 > this._poemIds.length - 1) {
                this._isPoemsFinish = true;
            }
            int n3 = 0;
            while (n3 < this._PoemsCount / 35) {
                Function.drawStepSpts(graphics, this._poemIds[n3], n, this._startY, 0x10 | 8, 35);
                n -= SptSet.getSpt(127).getSptWidth(0) * 2;
                ++n3;
            }
            if (!this._isPoemsFinish) {
                Function.drawStepSpts(graphics, this._poemIds[this._PoemsCount / 35], n, this._startY, 0x10 | 8, this._PoemsCount % 35);
            }
        } else {
            int n = this._startX;
            int n4 = Function.C_WORD_W;
            if (this._startX > 320) {
                this._isPoemsFinish = true;
                this._startX = -this._poems.length * Function.C_WORD_W * 2;
            } else {
                this._startX += 2;
            }
            int n5 = this._poems.length - 1;
            while (n5 >= 0) {
                Function.drawVertical(graphics, this._poems[n5].toCharArray(), n + n4, 30);
                n4 += Function.C_WORD_W * 2;
                --n5;
            }
        }
        graphics.setClip(0, 0, 320, 240);
        Function.draw3DString(graphics, GameParameter.PASS, 320, 240, 0x20 | 8, 0xFFFFFF, 255);
    }

    private final void keyRespondForPoemsStyle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        int n = gameMainLogic.getCurKey();
        switch (n) {
            case 131072: {
                this.finishShowHandler();
                this.clearKey();
            }
        }
        if (this._isPoemsFinish && this._wordStyle != 1) {
            this.finishShowHandler();
        }
    }

    public void initNewMultRow(String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3) {
        this._style = 10;
        this._newMultRowItemNameStartX = 90;
        this._newMultRowItem1StartX = this._newMultRowItemNameStartX + 40;
        this._newMultRowItem2StartX = this._newMultRowItemNameStartX + 120;
        this._newMultRowItemStartY = 50;
        this._newMultRowItemSpace = Function.C_WORD_SPACE_Y;
        this._newMultRowItemNameInfo = stringArray;
        this._newMultRowItem1Info = nArray;
        this._newMultRowItem2Info = nArray2;
        this._newMultRowItemSeparatorStartX = this._newMultRowItemNameStartX + 80;
        this._color = nArray3;
    }

    private final void paintNewMultRowInfo(Graphics graphics) {
        this.setEnvironment(graphics);
        int n = this._newMultRowItemStartY;
        Function._ani_111.draw(graphics, 160, this._newMultRowItemStartY + 90, 24, 0, 0);
        graphics.setClip(0, 0, 320, 240);
        int n2 = 0;
        while (n2 < this._newMultRowItemNameInfo.length) {
            Function.PANEL.draw(graphics, this._newMultRowItemSeparatorStartX, n, 11, 0x10 | 4);
            Function.draw3DString(graphics, this._newMultRowItemNameInfo[n2], this._newMultRowItemNameStartX, n, 4 | 0x10, 0, 0xFFFFFF);
            graphics.setColor(0);
            Function.drawString(graphics, "" + this._newMultRowItem1Info[n2], this._newMultRowItem1StartX, n, 0x10 | 4);
            graphics.setColor(this._color[n2]);
            Function.drawString(graphics, "" + this._newMultRowItem2Info[n2], this._newMultRowItem2StartX, n, 0x10 | 4);
            n += this._newMultRowItemSpace;
            ++n2;
        }
    }

    private final void keyRespondForNewMultiRowStyle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        int n = gameMainLogic.getCurKey();
        this.clearKey();
        if (n == 4) {
            this.finishShowHandler();
        }
        if (n == 131072) {
            EquipInterface.changeStateToBrowse();
        }
    }
}

