/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.engine.TiledBackground;
import com.sinaflying.game.Actor;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.game.ScriptDriver;
import com.sinaflying.game.SmsUi;
import com.sinaflying.game.UnitData;
import com.sinaflying.gameUtil.MessageBox;
import com.sinaflying.gameUtil.MessageBoxHandler;
import com.sinaflying.script.SceneExecutor;
import com.sinaflying.script.Script;
import com.sinaflying.util.Function;
import com.sinaflying.util.StreamReader;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class WorldScene
extends Scene
implements MessageBoxHandler {
    private int bufferNumber;
    public static WorldScene _worldScene = null;
    private int _result;
    private int _kind;
    private String _sceneName;
    private int _sceneInfoFrameX;
    private int _sceneInfoFrameY;
    private int _sceneInfoFrameW;
    private int _sceneInfoFrameH;
    private int _sceneNameX;
    private int _sceneNameY;
    private int _showFrameH;
    private int _showInfoX;
    private int _showInfoY;
    private int _showInfoLineNum;
    private int _showWordNumInLine;
    private static final int C_SHOW_FRAME_H = 120;
    private static final int C_SHOW_OPEN_SPEED = 15;
    private static final int C_SHOW_INFO_SPEED = 2;
    private static final String C_SHOW_INFO = "";
    private static final int C_REST_SHOW_SPEED = 10;
    private int _restShowProcess;
    private static final int C_REST_INFO_SHOW_TIME = 20;
    private int _timer;
    private static final int C_REST_SHOW_INFO_FILL_COLOR = 14543185;
    private static final int C_REST_SHOW_INFO_FRAME_COLOR = 0xFFFFFF;
    private static final int C_REST_SHOW_BK_COLOR = 0;
    private int[][] _sceneEffect = new int[300][9];
    public static final int SCENE_EFFECT_SIZE = 9;
    public static final int SCENE_EFFECT_ANIMATION = 0;
    public static final int SCENE_EFFECT_ACTION = 1;
    public static final int SCENE_EFFECT_X = 2;
    public static final int SCENE_EFFECT_Y = 3;
    public static final int SCENE_EFFECT_VX = 4;
    public static final int SCENE_EFFECT_VY = 5;
    public static final int SCENE_EFFECT_TIME = 6;
    public static final int SCENE_EFFECT_KIND = 7;
    public static final int SCENE_EFFECT_VALID = 8;
    public static final int SCENE_EFFECT_WANJIAN = 0;
    public int effectKind;
    public int effectNumber;
    public int effectNumberCount;
    public boolean effectOpen;
    private boolean openBlackScreen;
    private boolean openFlashScreen;
    private boolean openHalf;
    private boolean openAlphaScreen;
    private boolean _flash;
    private int effectProcess;
    private int effectDistance;
    private int effectFinishH;
    public UnitData _unit;
    private static final int C_SHUTTER_VERTICAL_DISTANCE = 32;
    private static final int C_SHUTTER_VERTICAL_FINISH_W = 16;
    private static final int C_SHUTTER_VERTICAL_SPEED = 1;
    private int _shutterVerticalProcess;
    private boolean _isFinishClose;

    public void passLevel(int n, int n2, int n3) {
        switch (n) {
            case 90: 
            case 91: 
            case 92: {
                GameMainLogic.getInterface().changtoCity(n - 90);
                break;
            }
            default: {
                RoleTeamData roleTeamData = RoleTeamData.getInstance();
                roleTeamData.setNextSceneInfo(n, n2 * this._bk._bktw + (this._bk._bktw >> 1), n3 * this._bk._bkth + (this._bk._bkth >> 1));
                roleTeamData.changeTeamLeader(this.getMainActor().getAniInx());
                this._state = 1;
                this.getMainActor().stop();
                roleTeamData.setRoleAction(this.getMainActor()._action);
                this._mainLogic.changeToInterface(7);
            }
        }
    }

    public void passCityMap(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void setFocusActor(Actor actor) {
        this._focus = actor;
    }

    public void setMainActor(RoleActor roleActor) {
        this._mainActor = roleActor;
        RoleTeamData.getInstance().setLeaderInx(roleActor.getAniInx());
    }

    public void updateCaptors() {
        if (this._mainLogic._state == 2) {
            return;
        }
        super.updateCaptors();
    }

    public final void update() {
        switch (this._state) {
            case 0: 
            case 1: {
                this.updateActors();
                this.updateCaptors();
                this.updateScript();
                this.updateZone();
                this.updateSceneEffect();
                break;
            }
            case 2: {
                this.updateActors();
                this.updateForInitShop();
                break;
            }
            case 3: {
                break;
            }
            case 18: {
                this.effectUpdate();
                break;
            }
            case 21: {
                this.updateActors();
                this.updateCaptors();
                this.updateZone();
                this.updateSceneEffect();
                break;
            }
            case 22: {
                this.updateActors();
                this.updateCaptors();
                this.updateZone();
                this.updateSceneEffect();
                break;
            }
            case 23: {
                this.updateActors();
                this.updateCaptors();
                this.updateZone();
                this.updateSceneEffect();
                break;
            }
        }
        this.keyRespond();
    }

    private void initStateBuffer() {
        this._state = 21;
    }

    public void initStatePlaying() {
        this._state = 0;
    }

    private void updateBuffer() {
    }

    public boolean canKeyRespond() {
        return this.isOperatable();
    }

    private final boolean isShowSoftKey() {
        return this.isOperatable();
    }

    public void updateActors() {
        if (this._isOpenPic) {
            return;
        }
        this.updateInsts();
        Actor[] actorArray = this._executeInsts;
        int n = this._executeNum;
        int n2 = 0;
        while (n2 < n) {
            if (this._state != 21 && this._state != 22 && this._state != 23) {
                actorArray[n2].step();
                actorArray[n2].ai();
            }
            ++n2;
        }
    }

    public boolean isOperatable() {
        if (!this.isFinishShowInfo()) {
            return false;
        }
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        return !scriptDriver.isExecuting();
    }

    public void keyRespond() {
        if (!this.canKeyRespond()) {
            return;
        }
        switch (this._state) {
            case 0: 
            case 1: {
                if (this._mainLogic.isPressCallAttributeKey()) {
                    this._mainLogic._state = 444;
                    this._mainLogic.resetCurKey();
                    break;
                }
                if (!this._mainLogic.isPressCallMenuKey()) break;
                this._mainLogic.changeToInfoPanel();
                this._mainLogic.resetCurKey();
                break;
            }
        }
    }

    public void updateScript() {
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        scriptDriver.exec();
        if (!this.getMainActor()._enableAI) {
            GameMainLogic.isFly = false;
            GameInterface._paraValue[0] = 0;
        }
        if (!GameMainLogic.getInstance().thisScenCanFly()) {
            GameMainLogic.isFly = false;
            GameInterface._paraValue[0] = 0;
        }
    }

    public final void paint(Graphics graphics) {
        switch (this._state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 15: {
                this.paintCommon(graphics);
                this.drawSceneEffect(graphics);
                break;
            }
            case 21: {
                this.paintCommon(graphics);
                break;
            }
            case 4: {
                this.paintCommon(graphics);
                this.paintMenu(graphics);
                break;
            }
            case 7: {
                this.paintCommon(graphics);
                break;
            }
            case 5: {
                this.gameHelp(graphics);
                break;
            }
            case 6: {
                this.gameAbout(graphics);
                break;
            }
            case 8: {
                this.paintStartShow(graphics);
                break;
            }
            case 9: {
                this.paintShowing(graphics);
                break;
            }
            case 10: {
                this.paintShowEnd(graphics);
                break;
            }
            case 11: {
                this.paintShowClose(graphics);
                break;
            }
            case 12: {
                this.paintForRestStart(graphics);
                break;
            }
            case 13: {
                this.paintForRestShowInfo(graphics);
                break;
            }
            case 14: {
                this.paintForRestShowEnd(graphics);
                break;
            }
            case 18: {
                this.effectPaint(graphics);
                break;
            }
            case 22: {
                this.paintForClose(graphics);
                if (!this._isFinishClose) break;
                this.changeToOpen();
                break;
            }
            case 23: {
                this.paintCommon(graphics);
                this.paintForOpen(graphics);
            }
        }
    }

    private final void paintCommon(Graphics graphics) {
        this.updateCameraOffset();
        this.paintMap(graphics);
        this.paintCoverMapEffect(graphics);
        this.paintActor(graphics);
        this.paintWeather(graphics);
        this.paintUI(graphics);
        this.paintSceneInfo(graphics);
        if (this._mainLogic._state != 3) {
            this.paintInfo(graphics);
        }
    }

    public final void paintWeather(Graphics graphics) {
        if (this.openBlackScreen) {
            Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        }
        if (this.openHalf) {
            Function.drawAlpha(graphics, 0, 0, 320, 240);
        }
        if (this.openFlashScreen) {
            if (this._flash) {
                Function.fillScreen(graphics, 0, 0, 320, 240, 0);
                this._flash = false;
            } else {
                Function.fillScreen(graphics, 0, 0, 320, 240, 0xFFFFFF);
                this._flash = true;
            }
        }
    }

    public final void paintCoverMapEffect(Graphics graphics) {
        if (this.openAlphaScreen) {
            Function.drawAlpha(graphics, 0, 0, 320, 240);
        }
    }

    private final void paintUI(Graphics graphics) {
        if (!this.getMainActor()._enableAI || !this._executor.isFinishDialog()) {
            return;
        }
        if (this._mainLogic._state != 1) {
            Function.drawSoftItem(graphics, 2);
            return;
        }
        Function.draw3DString(graphics, GameParameter.CAIDAN, 2, 238, 4 | 0x20, 273, 0xFCFCEC);
        Function.draw3DString(graphics, GameParameter.RENWU, 318, 238, 8 | 0x20, 273, 0xFCFCEC);
    }

    public boolean isFocusInCamera() {
        Actor actor = this.getFocusActor();
        return actor.isVisible();
    }

    public void startup() {
        Object object;
        int n;
        this.resetDynamicCounter();
        this._executor = null;
        GameMainLogic.getInstance();
        this._executor = new SceneExecutor(GameMainLogic.getGraphics(), this);
        int n2 = 0;
        while (n2 < this._actorPool.length) {
            n = 0;
            while (this._actorPool[n2] != null && n < this._actorPool[n2].length) {
                this._actorPool[n2][n]._active = false;
                ++n;
            }
            ++n2;
        }
        this.setInstsInvalid();
        n = this._unitData.length;
        n2 = 0;
        while (n2 < n) {
            this._unitData[n2].setValid();
            ++n2;
        }
        n2 = 0;
        while (n2 < Scene._globalActorNum) {
            this.fetchActorFromPool(-1, Scene._globalActorId[n2]);
            if (this.getGameLogic().checkInfoExist(this._id, Scene._globalActorId[n2])) {
                object = this.getActiveActor(Scene._globalActorId[n2]);
                if (Actor.isNeedRecord(((Actor)object).getAniInx())) {
                    ((Actor)object).disActive();
                } else if (((Actor)object)._curAction == 2 || ((Actor)object)._curAction == 3 || (((Actor)object)._curAction | Integer.MIN_VALUE) == 2 || (((Actor)object)._curAction | Integer.MIN_VALUE) == 3) {
                    ((Actor)object).changeAction(4);
                } else if (((Actor)object)._curAction == 5) {
                    ((Actor)object).disActive();
                } else if (((Actor)object)._isFlip) {
                    ((Actor)object).changeAction(-2147483647);
                } else {
                    ((Actor)object).changeAction(1);
                }
            }
            ++n2;
        }
        if (GameInterface._openPramInfo && !GameInterface._closePartInfo && GameInterface._paraValue[4] > 0) {
            object = RoleTeamData.getInstance();
            ((RoleTeamData)object).setScenario(0, GameInterface._paraValue[4]);
        }
        if (this._id == 6 && RoleTeamData.getInstance().getScenario()[0] == 8) {
            GameInterface._logoImages[4] = StreamReader.loadPng("/res/g3.png");
        }
        if (this._id == 68 && RoleTeamData.getInstance().getScenario()[0] == 41) {
            GameInterface._logoImages[5] = StreamReader.loadPng("/res/g4.png");
        }
        if (this._id == 96 && RoleTeamData.getInstance().getScenario()[0] == 90) {
            GameInterface._logoImages[6] = StreamReader.loadPng("/res/g5.png");
        }
        if (GameInterface._openPramInfo && !GameInterface._closePartInfo) {
            GameInterface._closePartInfo = true;
            int n3 = GameInterface._paraValue[3] % 7;
            RoleTeamData roleTeamData = RoleTeamData.getInstance();
            roleTeamData.increaseMoney(GameInterface._paraValue[7] * 100);
            roleTeamData.delMember(0);
            roleTeamData.delMember(1);
            switch (n3) {
                case 0: {
                    roleTeamData.addMember(0);
                    roleTeamData.getRoleData(0).setExperience(GameInterface._paraValue[6] * 10);
                    break;
                }
                case 1: {
                    roleTeamData.addMember(1);
                    roleTeamData.getRoleData(1).setExperience(GameInterface._paraValue[6] * 10);
                    break;
                }
                case 2: {
                    roleTeamData.addMember(0);
                    roleTeamData.addMember(1);
                }
            }
        }
        if (this._id == 0) {
            RoleTeamData.getInstance().addMember(0);
            RoleTeamData.getInstance().getRoleData(0).setLevel(60);
        }
        this.initStateBuffer();
        System.gc();
    }

    public final int getMutli(int n) {
        switch (n) {
            case 1: {
                return 10;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return 1000;
            }
            case 4: {
                return 10000;
            }
        }
        return 10;
    }

    public void startUpCamera() {
        this.initCamera(this._focus, this.getWidth(), this.getHeight());
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        this._bk.setPositionInMap(n, n2);
        int n3 = n2 / this._sectorHeight * (this._bk.getMapWidth() / this._sectorWidth) + n / this._sectorWidth;
        int n4 = 0;
        while (this._sectorActorId[n3] != null && n4 < this._sectorActorId[n3].length) {
            this.fetchActorFromPool(-1, this._sectorActorId[n3][n4]);
            if (this.getGameLogic().checkInfoExist(this._id, this._sectorActorId[n3][n4])) {
                Actor actor = this.getActiveActor(this._sectorActorId[n3][n4]);
                if (actor._curAction == 2 || actor._curAction == 3 || (actor._curAction | Integer.MIN_VALUE) == 2 || (actor._curAction | Integer.MIN_VALUE) == 3) {
                    actor.changeAction(4);
                } else if (actor._isFlip) {
                    actor.changeAction(-2147483647);
                } else {
                    actor.changeAction(1);
                }
            }
            ++n4;
        }
        this._curSector = n3;
    }

    public void triggerCaptor(UnitData unitData) {
        byte[] byArray = unitData.getParameter();
        byte by = byArray[0];
        switch (by) {
            case 1: {
                this.triggerScenario(unitData);
                break;
            }
            case 20: {
                GameMainLogic.getInstance();
                if (SmsUi._isBuy[5] >= 1 || RoleTeamData.getInstance()._scenario[0] != 15) break;
                GameMainLogic.getInstance()._smsui.smsBuy(5, 320, 240, C_SHOW_INFO, 1);
            }
        }
    }

    public void springBattle(int[] nArray, int n, int n2, boolean bl) {
        this._battleInfoBK = n;
        this._battleInfoFK = n2;
        GameRule gameRule = GameRule.getInstance();
        gameRule.setEnemyBattleTeam(nArray);
        this.changeToBattle(bl);
    }

    public void springBattle(int[] nArray, int n, int n2) {
        this._battleInfoBK = n;
        this._battleInfoFK = n2;
        GameRule gameRule = GameRule.getInstance();
        gameRule.setEnemyBattleTeam(nArray);
        this.changeToBattle(gameRule.canEscape(nArray));
    }

    public void changeToBattle(boolean bl) {
        this._mainLogic.changeToBattle(this._battleInfoBK, this._battleInfoFK, bl);
    }

    public void triggerScenario(UnitData unitData) {
        Script[] scriptArray = unitData.getScript();
        if (scriptArray != null) {
            ScriptDriver scriptDriver = ScriptDriver.getInstance();
            scriptDriver.addScript(scriptArray, this._executor);
            this._unit = unitData;
        }
    }

    public void setPoemsInfo(int n) {
        this._messageBox = MessageBox.getInstance(this);
        this._messageBox.initPoemsStyle(GameParameter.poems[n]);
    }

    public static boolean produceWorldScene(GameMainLogic gameMainLogic, int n) {
        if (n == 0 && GameInterface._openPramInfo && !GameInterface._closePartInfo && GameInterface._paraValue[1] > 0) {
            n = GameInterface._paraValue[1];
        }
        try {
            switch (Scene.produceProcess) {
                case 0: {
                    _worldScene = WorldScene.produceWorldInstance(gameMainLogic, n);
                    WorldScene._worldScene._id = n;
                    Scene.produceProcess = 1;
                    break;
                }
                case 1: {
                    _worldScene.produceMap();
                    Scene.produceProcess = 2;
                    break;
                }
                case 2: {
                    _worldScene.produceSector();
                    Scene.produceProcess = 3;
                    break;
                }
                case 3: {
                    _worldScene.produceUnit();
                    Scene.produceProcess = 4;
                    break;
                }
                case 4: {
                    _worldScene.produceActor();
                    _worldScene.produceNeedActor();
                    Scene.produceProcess = 5;
                    break;
                }
                case 5: {
                    _worldScene.produceInitParameter(n);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public static WorldScene produceWorldInstance(GameMainLogic gameMainLogic, int n) {
        WorldScene worldScene = new WorldScene();
        worldScene._bk = new TiledBackground(320, 240);
        worldScene._mainLogic = gameMainLogic;
        int n2 = n / 10;
        int n3 = n % 10;
        Scene._is = StreamReader.openDataFile("/res/scene" + n2 + ".bin", n3);
        return worldScene;
    }

    public boolean canBecameMain(int n, int n2) {
        if (GameInterface._openPramInfo && !GameInterface._closePartInfo) {
            int n3 = GameInterface._paraValue[2] % 3;
            if (n == n3 && Scene.isGloabalId(n2)) {
                this.preduceInitMainThing(n3);
                return true;
            }
            return false;
        }
        switch (this._id) {
            case 0: {
                if (!Scene.isGloabalId(n2)) break;
                this.preduceInitMainThing(0);
                return true;
            }
            default: {
                RoleTeamData roleTeamData = RoleTeamData.getInstance();
                if (this.getFocusActor() != null || !Scene.isGloabalId(n2) || n != roleTeamData.getRoleData(roleTeamData.getLeaderInx()).getAnimationIndex()) break;
                return true;
            }
        }
        return false;
    }

    private void preduceInitMainThing(int n) {
        switch (n) {
            case 0: {
                break;
            }
        }
    }

    public static int getLoadProcessNum() {
        return 305;
    }

    public void paintActor(Graphics graphics) {
        if (this._isOpenPic) {
            return;
        }
        Actor[] actorArray = this._executeInsts;
        int n = this._executeNum;
        this.sortActor(actorArray, n);
        int n2 = this._camx >> 10;
        int n3 = this._camy >> 10;
        int n4 = 0;
        while (n4 < n) {
            graphics.setClip(0, 0, 320, 240);
            if (actorArray[n4].isHaveShadow()) {
                Function.PANEL.draw(graphics, (actorArray[n4]._x >> 10) - n2, (actorArray[n4]._y >> 10) - n3 - 4, 44, 1 | 2);
            }
            actorArray[n4].paintInfo(graphics);
            actorArray[n4].draw(graphics, n2, n3, this._cameraOffset);
            ++n4;
        }
    }

    public final void sortActor(Actor[] actorArray, int n) {
        this.sort(actorArray, n);
    }

    private final void paintInfo(Graphics graphics) {
        if (this._messageBox != null) {
            this._messageBox.draw(graphics);
        }
    }

    public void setInfo(String string) {
        this._messageBox = MessageBox.getInstance(this);
        this._messageBox.initSingleScrollStyle(string, 10);
    }

    public final void setDialogInfo(int n, String string, String string2, int n2, int n3) {
        this._messageBox = MessageBox.getInstance(this);
        this._messageBox.initDialogStyle(n, string, string2, n2, n3);
    }

    public void speak(int n, String string, int n2, int n3) {
        int n4 = n / 10;
        int n5 = n % 10;
        int n6 = string.indexOf("\uff1a");
        String string2 = string.substring(0, n6);
        String string3 = string.substring(n6 + 1);
        GameRule gameRule = GameRule.getInstance();
        this.setDialogInfo(gameRule.getHeadSptInx(n4), string2, string3, n5, n2);
        Function.initAlphaArray(3550053, 64);
    }

    public boolean isFinishShowInfo() {
        return this._messageBox == null;
    }

    public final boolean idShowDialogInfo() {
        return this._messageBox.getStyle() == 0;
    }

    public void question(String string, String string2, String string3) {
        String[] stringArray = new String[]{string, string2, string3};
        this._messageBox = MessageBox.getInstance(this);
        this._messageBox.initQuestionStyle(stringArray);
    }

    public int getResult() {
        return this._result;
    }

    public final void setResult(int n) {
        this._result = n;
    }

    public void creatAllRole() {
        int n = this._mainActor.getPosX();
        int n2 = this._mainActor.getPosY();
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n3 = roleTeamData.getLeaderInx();
        boolean[] blArray = roleTeamData.getExistFlag();
        int n4 = blArray.length;
        int n5 = 0;
        while (n5 < n4) {
            if (blArray[n5] && n5 != n3) {
                int n6 = roleTeamData.getMemberAnimationInx(n5);
                Actor actor = this.fetchActorFromPool(n6, -1);
                actor.init(n, n2, 0);
            }
            ++n5;
        }
    }

    public void disposeAllRole() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n = roleTeamData.getLeaderInx();
        boolean[] blArray = roleTeamData.getExistFlag();
        int n2 = blArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            Actor actor;
            if (blArray[n3] && n3 != n && (actor = this.getActiveActor((n4 = roleTeamData.getMemberAnimationInx(n3)) + 1000)) != null) {
                actor.disActive();
            }
            ++n3;
        }
    }

    public void teamIn() {
        int n = this._mainActor.getCol();
        int n2 = this._mainActor.getRow();
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n3 = roleTeamData.getLeaderInx();
        boolean[] blArray = roleTeamData.getExistFlag();
        int n4 = blArray.length;
        int n5 = 0;
        while (n5 < n4) {
            if (blArray[n5] && n5 != n3) {
                int n6 = roleTeamData.getMemberAnimationInx(n5);
                Actor actor = this.getActiveActor(n6);
                actor.walkTo(n, n2);
            }
            ++n5;
        }
    }

    public boolean isAllRoleFinishWalk() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getExistFlag();
        int n = blArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            Actor actor;
            if (blArray[n2] && !(actor = this.getActiveActor(n3 = roleTeamData.getMemberAnimationInx(n2))).isFinishWalk()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void finishHandle(int n) {
        this._result = n;
        this._messageBox = null;
        switch (this._state) {
            case 3: {
                this.shopHandle();
                break;
            }
            case 7: {
                this._state = this._preState;
                break;
            }
            case 15: {
                this._mainLogic.changeToInterface(8);
            }
        }
    }

    public void changeToShop(int n) {
        this._kind = n;
        this._state = 2;
    }

    private final void updateForInitShop() {
        this._state = 3;
        this._messageBox = MessageBox.getInstance(this);
        String[] stringArray = new String[]{GameParameter.C_SCENE_INFO[1], GameParameter.C_SCENE_INFO[2], GameParameter.C_SCENE_INFO[3]};
        this._messageBox.initBuyStyle(stringArray, 1);
    }

    private final void shopHandle() {
        switch (this._result) {
            case 0: 
            case 1: {
                this._state = 2;
                GameMainLogic gameMainLogic = GameMainLogic.getInstance();
                gameMainLogic.changeToShop(this._kind, this._result);
                break;
            }
            default: {
                this._state = 0;
            }
        }
    }

    private final void formatSceneInfo(String string) {
        this._sceneName = string;
        this._sceneInfoFrameX = 0;
        this._sceneInfoFrameY = 0;
        int n = 12;
        this._sceneNameX = this._sceneInfoFrameX + n;
        this._sceneNameY = this._sceneInfoFrameY + Function.getFrameThickness() + 1;
        this._sceneInfoFrameH = Function.C_WORD_H + (Function.getFrameThickness() << 1);
        Font font = GameMainLogic.getGraphics().getFont();
        this._sceneInfoFrameW = font.stringWidth(string) + (n << 1) + 1;
    }

    private final void paintSceneInfo(Graphics graphics) {
        if (this._id >= 0) {
            Function.draw3DString(graphics, this._mainLogic.sceneName(this._id), 160, 0, 1 | 0x10, 0, 0xFFFFFF);
        }
    }

    public void changeToStartShow() {
        this._state = 8;
        this._showFrameH = 0;
    }

    public void paintShowFrame(Graphics graphics) {
        if (this._showFrameH == 0) {
            return;
        }
        int n = 240 - this._showFrameH >> 1;
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        graphics.fillRect(0, n, 320, this._showFrameH);
        int[] nArray = Function.C_COLOR_SCENE_MENU_FRAME;
        int n2 = 0;
        while (n2 < nArray.length) {
            graphics.setColor(nArray[n2]);
            graphics.drawLine(0, n - n2, 320, n - n2);
            graphics.drawLine(0, n + this._showFrameH + n2, 320, n + this._showFrameH + n2);
            ++n2;
        }
    }

    public void paintStartShow(Graphics graphics) {
        this.paintCommon(graphics);
        this._showFrameH += 15;
        if (this._showFrameH >= 120) {
            this._showFrameH = 120;
            this.changeToShowing();
        }
        this.paintShowFrame(graphics);
    }

    public void changeToShowing() {
        this._state = 9;
        this._showWordNumInLine = 320 / Function.C_WORD_W - 1;
        this._showInfoX = 320 - this._showWordNumInLine * Function.C_WORD_W >> 1;
        this._showInfoLineNum = C_SHOW_INFO.length() / this._showWordNumInLine;
        if (C_SHOW_INFO.length() % this._showWordNumInLine != 0) {
            ++this._showInfoLineNum;
        }
        this._showInfoY = 240 - (240 - this._showFrameH >> 1);
    }

    private final void paintShowing(Graphics graphics) {
        this.paintCommon(graphics);
        int n = 240 - this._showFrameH >> 1;
        int n2 = n - this._showInfoLineNum * Function.C_WORD_H;
        this._showInfoY -= 2;
        if (this._showInfoY <= n2) {
            this.changeToShowEnd();
        }
        this.paintShowFrame(graphics);
        graphics.setClip(0, n + 1, 320, this._showFrameH - 2);
        Function.drawWordLinesNoSetClip(graphics, this._showInfoX, this._showInfoY, Function.C_WORD_W, Function.C_WORD_H, C_SHOW_INFO, 0, this._showWordNumInLine, this._showInfoLineNum, 0xFDFDFD);
    }

    private final void changeToShowEnd() {
        this._state = 10;
        this._mainLogic.resetCurKey();
    }

    private final void paintShowEnd(Graphics graphics) {
        this.paintCommon(graphics);
        this.paintShowFrame(graphics);
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0xFDFDFD);
        Function.drawString(graphics, GameParameter.C_SCENE_INFO[5], 160, 240 - Function.C_WORD_H >> 1, 0x10 | 1);
        if (this._mainLogic.isPressFireKey()) {
            this._state = 11;
            this._mainLogic.resetCurKey();
        }
    }

    private final void paintShowClose(Graphics graphics) {
        this.paintCommon(graphics);
        this._showFrameH -= 15;
        if (this._showFrameH <= 0) {
            this._showFrameH = 0;
            this._mainLogic.changeToInterface(2);
        }
        this.paintShowFrame(graphics);
    }

    public void startupRest() {
        this._state = 12;
        this._restShowProcess = -320;
    }

    private final void paintRest(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        graphics.fillRect(this._restShowProcess, 0, 320, 240);
    }

    private final void paintForRestStart(Graphics graphics) {
        this.paintCommon(graphics);
        this._restShowProcess += 10;
        if (this._restShowProcess >= 0) {
            this._restShowProcess = 0;
            this.changeToShowInfo();
        }
        this.paintRest(graphics);
    }

    private final void changeToShowInfo() {
        this._state = 13;
        this._timer = 20;
        this.restHandle();
    }

    private final void paintForRestShowInfo(Graphics graphics) {
        this.paintCommon(graphics);
        this.paintRest(graphics);
        Function.draw3DString(graphics, GameParameter.C_SCENE_INFO[6], 160, 120, 0x10 | 1, 0xFFFFFF, 14543185);
        if (--this._timer <= 0) {
            this._state = 14;
        }
    }

    private final void paintForRestShowEnd(Graphics graphics) {
        this.paintCommon(graphics);
        this._restShowProcess += 10;
        if (this._restShowProcess >= 320) {
            this._restShowProcess = 320;
            this._state = 0;
        }
        this.paintRest(graphics);
    }

    private final void restHandle() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameRoleData[] gameRoleDataArray = roleTeamData.getRoleData();
        int n = gameRoleDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            gameRoleDataArray[n2].rest();
            ++n2;
        }
    }

    public void setSceneEffect(int n, int n2) {
        switch (n) {
            case 1: {
                if (n2 == 1) {
                    this.openBlackScreen = true;
                    break;
                }
                this.openBlackScreen = false;
                break;
            }
            case 2: {
                if (n2 == 1) {
                    this.openFlashScreen = true;
                    break;
                }
                if (n2 != 2) break;
                this.openFlashScreen = false;
                break;
            }
            case 3: {
                if (n2 == 1) {
                    this.openHalf = true;
                    Function.initAlphaArray(3550053, 70);
                    break;
                }
                if (n2 != 2) break;
                this.openHalf = false;
                break;
            }
            case 4: {
                this.lockCamera(this._camx >> 10, this._camy >> 10);
                break;
            }
            case 5: {
                this.unlockCamera();
                break;
            }
            case 6: {
                if (n2 == 1) {
                    this.openAlphaScreen = true;
                    Function.initAlphaArray(3550053, 70);
                    break;
                }
                if (n2 != 2) break;
                this.openAlphaScreen = false;
                break;
            }
            case 7: {
                this.changeToAutoShow(n2);
                break;
            }
            case 8: {
                if (n2 == 1) {
                    this._isOpenPic = true;
                    break;
                }
                if (n2 != 2) break;
                this._isOpenPic = false;
                break;
            }
            case 9: {
                Function.changeSoundState(n2, -1);
            }
        }
    }

    public void initSceneEffect(int n, int n2, int n3) {
        this.effectOpen = true;
        this.effectKind = n;
        switch (this.effectKind) {
            case 0: {
                this.initWanJianForScene(100, n2, n3);
            }
        }
    }

    public void updateSceneEffect() {
        if (RoleTeamData.getInstance()._stopGhost > 1) {
            --RoleTeamData.getInstance()._stopGhost;
        } else if (RoleTeamData.getInstance()._stopGhost == 1) {
            RoleTeamData.getInstance()._stopGhost = -1;
            this.setInfo(GameParameter.JIESHUQUMOXIANG);
        }
        switch (this.effectKind) {
            case 0: {
                this.updateWanJianForScene();
            }
        }
    }

    public void drawSceneEffect(Graphics graphics) {
        switch (this.effectKind) {
            case 0: {
                this.drawWanJianForScene(graphics);
            }
        }
    }

    private void initWanJianForScene(int n, int n2, int n3) {
        Function.initAlphaArray(0, 75);
        this.openAlphaScreen = true;
        this.effectNumber = n;
        int n4 = 0;
        while (n4 < this.effectNumber) {
            this._sceneEffect[n4][8] = 0;
            this._sceneEffect[n4][6] = 10;
            this._sceneEffect[n4][2] = (n2 << 4) + Function.Random(20, false) << 10;
            this._sceneEffect[n4][3] = (n3 << 4) + Function.Random(60, false) << 10;
            this._sceneEffect[n4][4] = ((n4 % 20 == 0 ? 50 : 120) << 10) * Function.cos(150) / 1024;
            this._sceneEffect[n4][5] = -((n4 % 20 == 0 ? 50 : 120) << 10) * Function.sin(150) / 1024;
            this._sceneEffect[n4][0] = 107;
            this._sceneEffect[n4][1] = n4 % 20 == 0 ? 3 : 11;
            ++n4;
        }
        this.effectNumberCount = 0;
    }

    private void updateWanJianForScene() {
        if (!this.effectOpen) {
            return;
        }
        this.effectNumberCount += 5;
        if (this.effectNumberCount > this.effectNumber) {
            this.effectNumberCount = this.effectNumber;
        }
        int n = 0;
        while (n < this.effectNumberCount) {
            if (this._sceneEffect[n][8] > 0) {
                int[] nArray = this._sceneEffect[n];
                int n2 = nArray[6];
                nArray[6] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._sceneEffect[n];
                    nArray2[2] = nArray2[2] + this._sceneEffect[n][4];
                    int[] nArray3 = this._sceneEffect[n];
                    nArray3[3] = nArray3[3] + this._sceneEffect[n][5];
                } else {
                    this._sceneEffect[n][8] = 0;
                }
            } else if (this._sceneEffect[n][6] > 0) {
                this._sceneEffect[n][8] = 1;
            }
            ++n;
        }
        n = 0;
        while (n < this.effectNumber) {
            if (this._sceneEffect[n][8] != 0) break;
            ++n;
        }
        if (n >= this.effectNumber) {
            this.effectOpen = false;
            this.openAlphaScreen = false;
        }
    }

    private void drawWanJianForScene(Graphics graphics) {
        if (!this.effectOpen) {
            return;
        }
        int n = 0;
        while (n < this.effectNumber) {
            if (this._sceneEffect[n][8] == 1) {
                Animation animation = Animation.getAnimation(this._sceneEffect[n][0]);
                int n2 = this._sceneEffect[n][2] >> 10;
                int n3 = this._sceneEffect[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._sceneEffect[n][1], 0, 0);
            }
            ++n;
        }
    }

    public void resetRole() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n = 0;
        while (n < roleTeamData.getRoleNumber()) {
            roleTeamData.getRoleData(n).resetHp();
            roleTeamData.getRoleData(n).resetMp();
            ++n;
        }
    }

    private void effectInit() {
        this._state = 18;
        this.effectProcess = 0;
        this.effectDistance = 20;
        this.effectFinishH = this.effectDistance >> 1;
    }

    private void effectUpdate() {
        if (++this.effectProcess >= this.effectFinishH) {
            this.effectProcess = this.effectFinishH;
            this._state = 0;
            this.openBlackScreen = true;
        }
    }

    private void effectPaint(Graphics graphics) {
        int n = this.effectFinishH;
        while (n <= 240 + this.effectFinishH) {
            graphics.setClip(0, 0, 320, 240);
            graphics.setColor(0);
            graphics.fillRect(0, n - this.effectProcess, 320, this.effectProcess << 1);
            n += this.effectDistance;
        }
    }

    public boolean battleScriptCondition() {
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        int n = scriptDriver.getScenarioExec().getCurExecInx();
        return n >= scriptDriver.getScenarioExec()._scriptParser.length - 1;
    }

    public UnitData getCurUnitData() {
        return this._unit;
    }

    public static WorldScene getWorldInstance() {
        return _worldScene;
    }

    private final void paintShutterVertical(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        int n = 16;
        while (n <= 336) {
            graphics.fillRect(n - this._shutterVerticalProcess, 0, this._shutterVerticalProcess << 1, 240);
            n += 32;
        }
    }

    private final void initForShutterVertical() {
        this._shutterVerticalProcess = 0;
    }

    private final void paintForCloseShutterVertical(Graphics graphics) {
        ++this._shutterVerticalProcess;
        if (this._shutterVerticalProcess > 16) {
            this._shutterVerticalProcess = 16;
            this._isFinishClose = true;
        }
        this.paintShutterVertical(graphics);
    }

    private final void paintForOpenShutterVertical(Graphics graphics) {
        --this._shutterVerticalProcess;
        if (this._shutterVerticalProcess < 0) {
            this._shutterVerticalProcess = 0;
            this._state = 0;
        }
        this.paintShutterVertical(graphics);
    }

    public final void changeToShowClose() {
        this._state = 22;
        this._isFinishClose = false;
        this.initForShutterVertical();
    }

    private final boolean isFinishClose() {
        return this._isFinishClose;
    }

    private final void paintForClose(Graphics graphics) {
        this.paintForCloseShutterVertical(graphics);
    }

    private final void paintForOpen(Graphics graphics) {
        this.paintCommon(graphics);
        this.paintForOpenShutterVertical(graphics);
    }

    private final void changeToOpen() {
        this._state = 23;
    }
}

