/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.DataThing;
import com.sinaflying.db.GameDB;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.Scene;
import com.sinaflying.game.SceneInfo;
import com.sinaflying.util.Function;
import com.sinaflying.util.RMSRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class RoleTeamData {
    private static RoleTeamData _instance;
    private GameRoleData[] _roleData;
    private byte[] _equipPackage;
    private byte[][] _equipInfo;
    private byte[] _materialPackage;
    private byte[][] _materialInfo;
    private boolean _isMaterialInfoValid;
    public static final int C_EQUIP_INFO_SIZE = 2;
    public static final int C_EQUIP_INFO_KIND = 0;
    public static final int C_EQUIP_INFO_NUM = 1;
    private boolean _isEquipInfoValid;
    private int _money;
    public boolean[] _missionThingPackage;
    private byte[] _missionThingInfo;
    private boolean _isMissionThingInfoValid;
    private static final int C_MAX_SCENARIO_NUM = 3;
    public int[] _scenario = new int[3];
    public boolean[] _composeScrollPackage;
    private byte[] _composeScrollInfo;
    private boolean _isComposeScrollInfoValid;
    private byte[] _thingPackage;
    private byte[][] _thingInfo;
    public static final int C_THING_INFO_SIZE = 2;
    public static final int C_THING_INFO_KIND = 0;
    public static final int C_THING_INFO_NUM = 1;
    private boolean _isThingInfoValid;
    private boolean[] _existFlag;
    private int _leaderInx;
    public int _nextSceneId;
    public int _stopGhost;
    private int _col;
    private int _row;
    private int _roleAction;
    private boolean[] _battleFlag;
    private Vector _chestInfo = new Vector();
    public static byte moneyNum;
    public static byte levelNum;
    public static byte equipNum;
    public static boolean yinLuFeng;
    private static RMSRecord _rms;

    public static RoleTeamData getInstance() {
        if (_instance == null) {
            _instance = new RoleTeamData();
            _instance.init();
        }
        return _instance;
    }

    private final void init() {
        GameDB gameDB = GameDB.getGameDataBase();
        Hashtable hashtable = gameDB.getRoleData();
        int n = hashtable.size();
        this._roleData = new GameRoleData[n];
        int n2 = 0;
        while (n2 < n) {
            this._roleData[n2] = GameRoleData.produceRoleData(n2);
            ++n2;
        }
        this._existFlag = new boolean[n];
        this._battleFlag = new boolean[n];
        int n3 = gameDB.getThingNum() + 1;
        this._thingPackage = new byte[n3];
        int n4 = gameDB.getEquipNum() + 1;
        this._equipPackage = new byte[n4];
        int n5 = gameDB.getDataMissionThingNum() + 1;
        this._missionThingPackage = new boolean[n5];
        int n6 = gameDB.getMeterialNum() + 1 + 49;
        this._materialPackage = new byte[n6];
        int n7 = gameDB.getDataComposeScrollNum() + 1 + 69;
        this._composeScrollPackage = new boolean[n7];
    }

    private RoleTeamData() {
    }

    public final GameRoleData getRoleData(int n) {
        if (n == 3) {
            return this._roleData[1];
        }
        return this._roleData[n];
    }

    public final int getRoleNumber() {
        return this._roleData.length;
    }

    public final GameRoleData[] getRoleData() {
        int n = 0;
        while (n < this._roleData.length) {
            this._roleData[n].updateInfo();
            ++n;
        }
        return this._roleData;
    }

    public final int getRoleHoldEquipNum(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._roleData.length) {
            int n4 = 0;
            while (n4 < this._roleData[n3].getEquipInx().length) {
                if (this._roleData[n3].getEquipInx()[n4] == n) {
                    ++n2;
                }
                ++n4;
            }
            ++n3;
        }
        return n2;
    }

    public final int getMoney() {
        return this._money;
    }

    public final boolean isEnoughMoney(int n) {
        return this._money >= n;
    }

    public final void increaseMoney(int n) {
        if (this._money + n > 999999) {
            return;
        }
        this._money += n < 0 ? 0 : n;
    }

    public final void decreaseMoney(int n) {
        this._money -= n;
    }

    private final int getHoldNum(byte[] byArray) {
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (byArray2[n3] > 0) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private final int getHoldNum(boolean[] blArray) {
        boolean[] blArray2 = blArray;
        int n = blArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (blArray2[n3]) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public final void increaseEquip(int n) {
        if (this._equipPackage[n] >= 99) {
            return;
        }
        int n2 = n;
        this._equipPackage[n2] = (byte)(this._equipPackage[n2] + 1);
        this._isEquipInfoValid = false;
    }

    public final void increaseEquip(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.increaseEquip(n);
            ++n3;
        }
    }

    public final void decreaseEquip(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.decreaseEquip(n);
            ++n3;
        }
    }

    public final void decreaseEquip(int n) {
        if (this._equipPackage[n] <= 0) {
            return;
        }
        int n2 = n;
        this._equipPackage[n2] = (byte)(this._equipPackage[n2] - 1);
        this._isEquipInfoValid = false;
    }

    public final int getRemainEquipSpace(int n) {
        return 99 - this.getHoldEquipNum(n);
    }

    public final int getHoldEquipNum(int n) {
        return this._equipPackage[n];
    }

    public final byte[][] getEquipInfo() {
        this.updateEquipInfo();
        return this._equipInfo;
    }

    public final int getEquipNum() {
        this.updateEquipInfo();
        return this._equipInfo.length;
    }

    private final void updateEquipInfo() {
        if (this._isEquipInfoValid) {
            return;
        }
        this._isEquipInfoValid = true;
        int n = this.getHoldNum(this._equipPackage);
        if (this._equipInfo == null || this._equipInfo.length != n) {
            this._equipInfo = null;
            this._equipInfo = new byte[n][2];
        }
        byte[] byArray = this._equipPackage;
        byte[][] byArray2 = this._equipInfo;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (byArray[n4] > 0) {
                byArray2[n3][0] = (byte)n4;
                byArray2[n3++][1] = byArray[n4];
            }
            ++n4;
        }
    }

    public final void increaseMaterial(int n) {
        if (this._materialPackage[n] >= 99) {
            return;
        }
        int n2 = n;
        this._materialPackage[n2] = (byte)(this._materialPackage[n2] + 1);
        this._isMaterialInfoValid = false;
        this.updateMaterialInfo();
    }

    public final void increaseMaterial(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.increaseMaterial(n);
            ++n3;
        }
    }

    public final void decreaseMaterial(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.decreaseMaterial(n);
            ++n3;
        }
    }

    public final void decreaseMaterial(int n) {
        if (this._materialPackage[n] <= 0) {
            return;
        }
        int n2 = n;
        this._materialPackage[n2] = (byte)(this._materialPackage[n2] - 1);
        this._isMaterialInfoValid = false;
        this.updateMaterialInfo();
    }

    public final int getRemainMaterialSpace(int n) {
        return 99 - this.getHoldMaterialNum(n);
    }

    public final int getHoldMaterialNum(int n) {
        return this._materialPackage[n];
    }

    public final byte[][] getMaterialInfo() {
        this.updateMaterialInfo();
        return this._materialInfo;
    }

    public final int getMaterialNum() {
        this.updateMaterialInfo();
        return this._materialInfo.length;
    }

    private final void updateMaterialInfo() {
        if (this._isMaterialInfoValid) {
            return;
        }
        this._isMaterialInfoValid = true;
        int n = this.getHoldNum(this._materialPackage);
        if (this._materialInfo == null || this._materialInfo.length != n) {
            this._materialInfo = null;
            this._materialInfo = new byte[n][2];
        }
        byte[] byArray = this._materialPackage;
        byte[][] byArray2 = this._materialInfo;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (byArray[n4] > 0) {
                byArray2[n3][0] = (byte)n4;
                byArray2[n3++][1] = byArray[n4];
            }
            ++n4;
        }
    }

    public final void increaseMissionThing(int n) {
        this._missionThingPackage[n] = true;
        this._isMissionThingInfoValid = false;
    }

    public final void decreaseMissionThing(int n) {
        this._missionThingPackage[n] = false;
        this._isMissionThingInfoValid = false;
    }

    public final byte[] getMissionThing() {
        this.updateMissionThing();
        return this._missionThingInfo;
    }

    public final void updateMissionThing() {
        if (this._isMissionThingInfoValid) {
            return;
        }
        this._isMissionThingInfoValid = true;
        int n = this.getHoldNum(this._missionThingPackage);
        if (this._missionThingInfo == null || this._missionThingInfo.length != n) {
            this._missionThingInfo = null;
            this._missionThingInfo = new byte[n];
        }
        int n2 = this._missionThingPackage.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (this._missionThingPackage[n4]) {
                this._missionThingInfo[n3++] = (byte)n4;
            }
            ++n4;
        }
    }

    public final boolean isHoldComposeScroll(int n) {
        return this._composeScrollPackage[n];
    }

    public final int getRemainComposeScrollSpace(int n) {
        return 1 - (this._composeScrollPackage[n] ? 1 : 0);
    }

    public final void increaseComposeScroll(int n) {
        this._composeScrollPackage[n] = true;
        this._isComposeScrollInfoValid = false;
    }

    public final void decreaseComposeScroll(int n) {
        this._composeScrollPackage[n] = false;
        this._isComposeScrollInfoValid = false;
    }

    public final byte[] getComposeScroll() {
        this.updateComposeScroll();
        return this._composeScrollInfo;
    }

    public final void updateComposeScroll() {
        if (this._isComposeScrollInfoValid) {
            return;
        }
        this._isComposeScrollInfoValid = true;
        int n = this.getHoldNum(this._composeScrollPackage);
        if (this._composeScrollInfo == null || this._composeScrollInfo.length != n) {
            this._composeScrollInfo = null;
            this._composeScrollInfo = new byte[n];
        }
        int n2 = this._composeScrollPackage.length;
        int n3 = 0;
        int n4 = 1;
        while (n4 < n2) {
            if (this._composeScrollPackage[n4]) {
                this._composeScrollInfo[n3++] = (byte)n4;
            }
            ++n4;
        }
    }

    public final void increaseThing(int n) {
        if (this._thingPackage[n] >= 99) {
            return;
        }
        int n2 = n;
        this._thingPackage[n2] = (byte)(this._thingPackage[n2] + 1);
        this._isThingInfoValid = false;
    }

    public final void increaseThing(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.increaseThing(n);
            ++n3;
        }
    }

    public final void decreaseThing(int n) {
        if (this._thingPackage[n] <= 0) {
            return;
        }
        int n2 = n;
        this._thingPackage[n2] = (byte)(this._thingPackage[n2] - 1);
        this._isThingInfoValid = false;
    }

    public final void decreaseThing(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.decreaseThing(n);
            ++n3;
        }
    }

    public final int getRemainThingSpace(int n) {
        return 99 - this.getHoldThingNum(n);
    }

    public final int getHoldThingNum(int n) {
        return this._thingPackage[n];
    }

    public final byte[][] getThingInfo() {
        this.updateThingInfo();
        return this._thingInfo;
    }

    public final int getThingNum() {
        this.updateThingInfo();
        return this._thingInfo.length;
    }

    public final int getEffectThingNum() {
        int n = 0;
        this.updateThingInfo();
        int n2 = 0;
        while (n2 < this._thingInfo.length) {
            DataThing dataThing = GameDB.getGameDataBase().getThingData(this._thingInfo[n2][0]);
            if (dataThing.getTarget() == 0) {
                ++n;
            }
            ++n2;
        }
        return this._thingInfo.length - n;
    }

    private final void updateThingInfo() {
        if (this._isThingInfoValid) {
            return;
        }
        this._isThingInfoValid = true;
        int n = this.getHoldNum(this._thingPackage);
        if (this._thingInfo == null || this._thingInfo.length != n) {
            this._thingInfo = null;
            this._thingInfo = new byte[n][2];
        }
        byte[] byArray = this._thingPackage;
        byte[][] byArray2 = this._thingInfo;
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (byArray[n4] > 0) {
                byArray2[n3][0] = (byte)n4;
                byArray2[n3++][1] = byArray[n4];
            }
            ++n4;
        }
    }

    public final boolean isValidPosInfo() {
        return this._col != -1 && this._row != -1;
    }

    public final void setNextSceneInfo(int n, int n2, int n3) {
        this._nextSceneId = n;
        this._col = n2;
        this._row = n3;
    }

    public final int getNextSceneId() {
        return this._nextSceneId;
    }

    public final void setRoleAction(int n) {
        this._roleAction = n;
    }

    public final void startUp() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        Scene scene = GameMainLogic.getScene();
        RoleActor roleActor = scene.getMainActor();
        if (this.isValidPosInfo()) {
            roleActor.setPosByTile(this._col, this._row);
            roleActor.changeAction(this._roleAction);
            roleActor._mainFlag = true;
        }
        if (roleActor != null) {
            int n = this._roleData[this._leaderInx].getAnimationIndex();
            roleActor.changeAnimation(n);
        }
    }

    public int getCol() {
        return this._col;
    }

    public int getRow() {
        return this._row;
    }

    public final void addMember(int n) {
        int n2 = this.getRoleDataInxByAni(n);
        this._existFlag[n2] = true;
        this._battleFlag[n2] = true;
    }

    private final int getRoleDataInxByAni(int n) {
        int n2 = this._roleData.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this._roleData[n3].getAnimationIndex() == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public final void delMember(int n) {
        int n2 = this.getRoleDataInxByAni(n);
        this._existFlag[n2] = false;
        this._battleFlag[n2] = false;
        this.checkBattleInfo();
    }

    private final void checkBattleInfo() {
        if (this.getBattleNum() == 0) {
            int n = this._existFlag.length;
            int n2 = 0;
            while (n2 < n) {
                if (this._existFlag[n2]) {
                    this._battleFlag[n2] = true;
                    return;
                }
                ++n2;
            }
        }
    }

    public final int getBattleNum() {
        int n = 0;
        int n2 = this._battleFlag.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this._battleFlag[n3]) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public final void changeTeamLeader(int n) {
        int n2;
        this._leaderInx = n2 = this.getRoleDataInxByAni(n);
    }

    public final boolean[] getExistFlag() {
        return this._existFlag;
    }

    public final int getExistRoleNum() {
        int n = 0;
        int n2 = this._existFlag.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this._existFlag[n3]) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public final int getLeaderInx() {
        return this._leaderInx;
    }

    public final void setLeaderInx(int n) {
        this._leaderInx = n;
    }

    public final int getMemberAnimationInx(int n) {
        return this._roleData[n].getAnimationIndex();
    }

    public final boolean[] getBattleInfo() {
        return this._battleFlag;
    }

    public final void changeBattleFlag(int n) {
        this._battleFlag[n] = !this._battleFlag[n];
    }

    public final void setScenario(int n, int n2) {
        this._scenario[n] = n2;
    }

    public final int[] getScenario() {
        return this._scenario;
    }

    public final void registInvalid(String string) {
        this._chestInfo.addElement(string);
    }

    public final boolean isValid(String string) {
        return !this._chestInfo.contains(string);
    }

    public final void save(DataOutputStream dataOutputStream) {
        try {
            GameMainLogic gameMainLogic = GameMainLogic.getInstance();
            Scene scene = GameMainLogic.getScene();
            SceneInfo sceneInfo = GameMainLogic._sceneInfo;
            dataOutputStream.writeByte(gameMainLogic.returnTimeArray()[0]);
            dataOutputStream.writeByte(gameMainLogic.returnTimeArray()[1]);
            int n = this._battleFlag.length;
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeBoolean(this._battleFlag[n2]);
                ++n2;
            }
            n = this._scenario.length;
            int n3 = 0;
            while (n3 < n) {
                dataOutputStream.writeInt(this._scenario[n3]);
                ++n3;
            }
            n = this._existFlag.length;
            int n4 = 0;
            while (n4 < n) {
                dataOutputStream.writeBoolean(this._existFlag[n4]);
                ++n4;
            }
            dataOutputStream.writeInt(this._leaderInx);
            dataOutputStream.writeInt(this._money);
            n = this._thingPackage.length;
            int n5 = 0;
            while (n5 < n) {
                dataOutputStream.writeByte(this._thingPackage[n5]);
                ++n5;
            }
            n = this._equipPackage.length;
            int n6 = 0;
            while (n6 < n) {
                dataOutputStream.writeByte(this._equipPackage[n6]);
                ++n6;
            }
            n = this._missionThingPackage.length;
            int n7 = 0;
            while (n7 < n) {
                dataOutputStream.writeBoolean(this._missionThingPackage[n7]);
                ++n7;
            }
            n = this._materialPackage.length;
            int n8 = 0;
            while (n8 < n) {
                dataOutputStream.writeByte(this._materialPackage[n8]);
                ++n8;
            }
            n = this._composeScrollPackage.length;
            int n9 = 0;
            while (n9 < n) {
                dataOutputStream.writeBoolean(this._composeScrollPackage[n9]);
                ++n9;
            }
            dataOutputStream.writeInt(scene.getID());
            RoleActor roleActor = scene.getMainActor();
            dataOutputStream.writeInt(roleActor.getPosXX());
            dataOutputStream.writeInt(roleActor.getPosYY());
            dataOutputStream.writeInt(roleActor._curAction);
            sceneInfo.save(dataOutputStream);
            n = this._roleData.length;
            int n10 = 0;
            while (n10 < n) {
                this._roleData[n10].save(dataOutputStream);
                ++n10;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void loadTime(DataInputStream dataInputStream) {
        try {
            Function._rmsGameTimeHour = dataInputStream.readByte();
            Function._rmsGameTimeMinut = dataInputStream.readByte();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void loadRmsBattleFlag(DataInputStream dataInputStream) {
        Function._rmsBattleFlag = new boolean[2];
        int n = Function._rmsBattleFlag.length;
        int n2 = 0;
        while (n2 < n) {
            try {
                Function._rmsBattleFlag[n2] = dataInputStream.readBoolean();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public final void loadCurScenario(DataInputStream dataInputStream) {
        try {
            Function._curScenario = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public final void load(DataInputStream dataInputStream) {
        try {
            GameMainLogic gameMainLogic = GameMainLogic.getInstance();
            SceneInfo sceneInfo = GameMainLogic._sceneInfo;
            int[] nArray = new int[]{dataInputStream.readByte(), dataInputStream.readByte()};
            gameMainLogic.setContinueGameTime(nArray);
            int n = this._battleFlag.length;
            int n2 = 0;
            while (n2 < n) {
                this._battleFlag[n2] = dataInputStream.readBoolean();
                ++n2;
            }
            n = this._scenario.length;
            int n3 = 0;
            while (n3 < n) {
                this._scenario[n3] = dataInputStream.readInt();
                ++n3;
            }
            n = this._existFlag.length;
            int n4 = 0;
            while (n4 < n) {
                this._existFlag[n4] = dataInputStream.readBoolean();
                ++n4;
            }
            this._leaderInx = dataInputStream.readInt();
            this._money = dataInputStream.readInt();
            n = this._thingPackage.length;
            int n5 = 0;
            while (n5 < n) {
                this._thingPackage[n5] = dataInputStream.readByte();
                ++n5;
            }
            n = this._equipPackage.length;
            int n6 = 0;
            while (n6 < n) {
                this._equipPackage[n6] = dataInputStream.readByte();
                ++n6;
            }
            n = this._missionThingPackage.length;
            int n7 = 0;
            while (n7 < n) {
                this._missionThingPackage[n7] = dataInputStream.readBoolean();
                if (n7 == 6 && yinLuFeng) {
                    this.increaseMissionThing(6);
                }
                ++n7;
            }
            n = this._materialPackage.length;
            int n8 = 0;
            while (n8 < n) {
                this._materialPackage[n8] = dataInputStream.readByte();
                ++n8;
            }
            n = this._composeScrollPackage.length;
            int n9 = 0;
            while (n9 < n) {
                this._composeScrollPackage[n9] = dataInputStream.readBoolean();
                ++n9;
            }
            this._nextSceneId = dataInputStream.readInt();
            this._col = dataInputStream.readInt();
            this._row = dataInputStream.readInt();
            this._roleAction = dataInputStream.readInt();
            sceneInfo.load(dataInputStream);
            this._isThingInfoValid = false;
            this._isEquipInfoValid = false;
            n = this._roleData.length;
            int n10 = 0;
            while (n10 < n) {
                this._roleData[n10].load(dataInputStream);
                ++n10;
            }
            this.loadGood1();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void reset() {
        int n = this._scenario.length;
        int n2 = 0;
        while (n2 < n) {
            this._scenario[n2] = 0;
            ++n2;
        }
        n = this._existFlag.length;
        int n3 = 0;
        while (n3 < n) {
            this._existFlag[n3] = false;
            ++n3;
        }
        n = this._battleFlag.length;
        int n4 = 0;
        while (n4 < n) {
            this._battleFlag[n4] = false;
            ++n4;
        }
        this._leaderInx = 0;
        this._money = 0;
        n = this._thingPackage.length;
        int n5 = 0;
        while (n5 < n) {
            this._thingPackage[n5] = 0;
            ++n5;
        }
        n = this._equipPackage.length;
        int n6 = 0;
        while (n6 < n) {
            this._equipPackage[n6] = 0;
            ++n6;
        }
        n = this._missionThingPackage.length;
        int n7 = 0;
        while (n7 < n) {
            this._missionThingPackage[n7] = false;
            ++n7;
        }
        n = this._materialPackage.length;
        int n8 = 0;
        while (n8 < n) {
            this._materialPackage[n8] = 0;
            ++n8;
        }
        n = this._composeScrollPackage.length;
        int n9 = 0;
        while (n9 < n) {
            this._composeScrollPackage[n9] = false;
            ++n9;
        }
        this._stopGhost = -1;
        this._nextSceneId = 0;
        this._col = -1;
        this._row = -1;
        n = this._roleData.length;
        int n10 = 0;
        while (n10 < n) {
            this._roleData[n10].reset();
            ++n10;
        }
    }

    public final void resetPos() {
        this._col = -1;
        this._row = -1;
    }

    public void saveGood() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(moneyNum);
            dataOutputStream.writeByte(equipNum);
            dataOutputStream.writeBoolean(yinLuFeng);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        _rms.saveData(byteArrayOutputStream.toByteArray(), 2);
    }

    public void loadGood() {
        if (_rms.loadData(2) == null) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_rms.loadData(2));
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            moneyNum = dataInputStream.readByte();
            equipNum = dataInputStream.readByte();
            yinLuFeng = dataInputStream.readBoolean();
            this._money = 5000 * moneyNum;
            this._thingPackage[4] = moneyNum;
            this._thingPackage[8] = moneyNum;
            this._thingPackage[46] = moneyNum;
            this._equipPackage[44] = equipNum;
            this._equipPackage[52] = equipNum;
            this._equipPackage[59] = equipNum;
            this._equipPackage[66] = equipNum;
            if (yinLuFeng) {
                this.increaseMissionThing(6);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadGood1() {
        if (_rms.loadData(2) == null) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(_rms.loadData(2));
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            moneyNum = dataInputStream.readByte();
            equipNum = dataInputStream.readByte();
            yinLuFeng = dataInputStream.readBoolean();
            this._equipPackage[44] = equipNum;
            this._equipPackage[52] = equipNum;
            this._equipPackage[59] = equipNum;
            this._equipPackage[66] = equipNum;
            if (yinLuFeng) {
                this.increaseMissionThing(6);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addYinLuFeng() {
        this.increaseMissionThing(6);
    }

    static {
        moneyNum = 0;
        levelNum = 0;
        equipNum = 0;
        yinLuFeng = false;
        _rms = new RMSRecord();
    }
}

