/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.DataSkill;
import com.sinaflying.db.DataThing;
import com.sinaflying.db.GameDB;
import com.sinaflying.engine.Animation;
import com.sinaflying.engine.SptSet;
import com.sinaflying.game.BattleScene;
import com.sinaflying.game.Fighter;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Stack;
import com.sinaflying.gameUtil.Menu;
import com.sinaflying.gameUtil.MenuHandler;
import com.sinaflying.util.Function;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;

public class RoleFighter
extends Fighter
implements MenuHandler {
    GameMainLogic _mainLogic;
    private boolean _isShowFlag;
    private int _stateCommand;
    private static final int STATE_COMMAND_NONE = -1;
    private static final int STATE_COMMAND_SELECT_ACTIN_KIND = 2;
    private static final int STATE_COMMAND_SELECT_SKILL_INDEX = 0;
    private static final int STATE_COMMAND_SELECT_THING_INDEX = 3;
    private static final int STATE_COMMAND_SELECT_TARGET_GROUP = 4;
    private static final int STATE_COMMAND_SELECT_DEFENCE_INDEX = 1;
    public static final int INDEX_PANEL_ATTACK = 0;
    public static final int INDEX_PANEL_SKILL = 1;
    public static final int INDEX_PANEL_OTHER = 2;
    public static final int INDEX_PANEL_THING = 3;
    private static int _chooseInxForPanel;
    static Menu _menu;
    private static final int MAX_COMMAND_NUM = 4;
    private Stack _commandStack = new Stack(4);
    private static final int C_SELECT_TARGET_INTERVAL = 3;
    public GameRoleData _roleData;
    private boolean _isEscape;
    private int _echoChooseInxForPanel = 0;
    private int _echoInxForOther = 0;
    private int _echoChooseSkillIndex = 0;
    private int _echoChooseThingIndex = 0;
    private int _echoTarget = 0;
    private static boolean _isEchoLastAction;

    public void resetLife() {
        this._isclear = false;
        this._state = 0;
        this._roleData.resetData();
        this._currentHp = this._maxHp;
        this._currentMp = this._maxMp;
        this.changeAction(this.getActionInx(0));
    }

    public final boolean isShowInfo() {
        return this._isShowFlag;
    }

    private final void setShowFlag() {
        this._isShowFlag = true;
    }

    private final void clearShowFlag() {
        this._isShowFlag = false;
    }

    protected boolean isDrawBK() {
        switch (this._stateCommand) {
            case 0: 
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    protected final void updateAllRival() {
        this._tempContainerMemberNum = this._scene.getEnemyFighterForEffectByRival(this._tempContainer);
    }

    protected final void updateAllFriend() {
        this._tempContainerMemberNum = this._scene.getRoleFighterForEffectByFriend(this._tempContainer);
    }

    protected final void finishEffectBoutHandle(int n) {
        int[] nArray = this._roleData.getCurrentInfo();
        switch (n) {
            case 4: {
                this._interForcse = nArray[3];
                break;
            }
            case 3: {
                this._defence = nArray[9];
                break;
            }
            case 5: {
                this._attackInjure = nArray[5];
                break;
            }
            case 0: {
                if (this.isDeath()) {
                    return;
                }
                this.changeToWait();
            }
        }
    }

    protected void command() {
        switch (this._stateCommand) {
            case 2: {
                this.updataAction();
            }
            case 0: 
            case 3: {
                break;
            }
            case 4: {
                this.updateSelectTarget();
                break;
            }
        }
    }

    private final void updataAction() {
        if (RoleFighter.getEchoLastAction()) {
            this.updateEchoChoose();
            return;
        }
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        if (gameMainLogic.isPressConfirmKey()) {
            if (_chooseInxForPanel != 2) {
                this.menuResultHandle(_chooseInxForPanel);
            } else {
                _menu = Menu.getInstance(this);
                _menu.initUserdefinedStyle(new String[]{GameParameter.FANGYU, GameParameter.TAOPAO, "\u836f\u5e97"}, 160, 40, new int[]{2, 4}, true);
            }
            this._echoChooseInxForPanel = _chooseInxForPanel;
            gameMainLogic.resetCurKey();
            return;
        }
        if (gameMainLogic.isPressCancelKey()) {
            this.changeToPreviousCommandState();
            this._scene.openOnceDrawBK();
            gameMainLogic.resetCurKey();
            return;
        }
        int n = gameMainLogic.getCurKey();
        gameMainLogic.resetCurKey();
        switch (n) {
            case 1: {
                this.setChooseInxForPanel(0);
                break;
            }
            case 3: {
                this.setChooseInxForPanel(1);
                break;
            }
            case 5: {
                this.setChooseInxForPanel(3);
                break;
            }
            case 7: {
                this.setChooseInxForPanel(2);
                break;
            }
            case 0: {
                this.updateEchoChoose();
                RoleFighter.setEchoLastAction(true);
            }
        }
    }

    public void setChooseInxForPanel(int n) {
        _chooseInxForPanel = n;
    }

    public int chooseInx() {
        return _chooseInxForPanel;
    }

    public static void resetChooseInx() {
        _chooseInxForPanel = 0;
    }

    private final void updateSelectTarget() {
        if (_isEchoLastAction) {
            this._curTargetGroup = this._echoTarget;
            this.updateSelectInfo();
            this.finishCommand();
            return;
        }
        if (this._mainLogic.isPressCancelKey()) {
            this.updateSelectInfo();
            this.changeToPreviousCommandState();
            this._mainLogic.resetCurKey();
            return;
        }
        int n = this._mainLogic.getCurKey();
        switch (n) {
            case 1: 
            case 3: {
                this.updateSelectInfo();
                this.previousTarget();
                break;
            }
            case 5: 
            case 7: {
                this.updateSelectInfo();
                this.nextTarget();
                break;
            }
            case 4: {
                this.updateSelectInfo();
                this.finishCommand();
                this._echoTarget = this._curTargetGroup;
            }
        }
        this._mainLogic.resetCurKey();
    }

    public void updateSelectInfo() {
        Fighter[] fighterArray = this._target[this._curTargetGroup];
        int n = 0;
        while (n < 3) {
            if (fighterArray[n] == null) {
                return;
            }
            fighterArray[n]._isSelected = false;
            ++n;
        }
    }

    private final void nextTarget() {
        ++this._curTargetGroup;
        if (this._curTargetGroup > this._targetGroupNum - 1) {
            this._curTargetGroup = 0;
        }
    }

    private final void previousTarget() {
        --this._curTargetGroup;
        if (this._curTargetGroup < 0) {
            this._curTargetGroup = this._targetGroupNum - 1;
        }
    }

    protected void startUpCommand() {
        this.setShowFlag();
        this.resetCommandStack();
        this.resetCommandState();
        this.changeToNextCommandState(2);
    }

    public final void resetCommandState() {
        this._stateCommand = -1;
        this.clearDefence();
    }

    private final void changeToNextCommandState(int n) {
        this.saveCurrentComamnd();
        switch (n) {
            case 2: {
                this.changeToSelectActionKindCommandState();
                break;
            }
            case 0: {
                this.changeToSelectSkillCommandState();
                break;
            }
            case 3: {
                this.changeToSelectThingCommandState();
                break;
            }
            case 4: {
                this.changeToSelectTargetCommandState();
                break;
            }
        }
    }

    private final void changeToPreviousCommandState() {
        int n = this.loadPreviousCommand();
        switch (n) {
            case -1: {
                if (this.isDefence()) {
                    this.clearDefence();
                }
                this.changeToNoneCommandState();
                break;
            }
            case 2: {
                this.changeToSelectActionKindCommandState();
                break;
            }
            case 0: {
                this.changeToSelectSkillCommandState();
                break;
            }
            case 3: {
                this.restoreThing();
                this.changeToSelectThingCommandState();
                break;
            }
            case 4: {
                this.changeToSelectTargetCommandState();
                break;
            }
        }
    }

    private final void restoreThing() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.increaseThing(this._actionInfo[16]);
    }

    private final void changeToNoneCommandState() {
        this.clearShowFlag();
        this._scene.cancelSettingCommandHandle();
    }

    private final void changeToSelectActionKindCommandState() {
        this._stateCommand = 2;
        if (this._scene._roleEscapeFail) {
            this.finishCommand();
        }
    }

    private final void changeToSelectThingCommandState() {
        this._stateCommand = 3;
        this.initThingSelectMenu();
    }

    private final void changeToSelectSkillCommandState() {
        this._stateCommand = 0;
        this.initSkillSelectMenu();
    }

    private final void changeToSelectTargetCommandState() {
        this._stateCommand = 4;
        this.resetCurrentTarget();
    }

    public void produceMissInfo() {
        super.produceMissInfo();
        this.changeAction(this.getActionInx(10));
        this._timer = 8;
        this._x += 10240;
        this._y += 10240;
        if (!this.isDefence() && Function.Random(100, true) < this._missAttackRate) {
            this.setMissAttackInfo();
        }
    }

    public void changeToActionReady() {
        this._actionInfo[2] = 1;
        if (this._actionInfo[17] == 1) {
            this._scene.openSkillEffect();
            this._timer = Animation.load(97, 2).getActFrmNum(0);
            this.changeAction(this.getActionInx(6));
            this._scene.addEffectActor(97, this.getForePosX() + 12800, this.getPosY() - 12800, this.getForePosX() + 12800, this.getPosY() - 12800, 0);
            this._timer = Animation.getAnimation(97).getActFrmNum(0);
        } else {
            this._timer = 1;
            this.changeAction(this.getActionInx(6));
        }
    }

    public void changeToHurt() {
        if (this.isDefence()) {
            this._timer = 4;
        } else {
            this.changeAction(this.getActionInx(1));
            this._timer = 4;
            this._vx = 2048;
        }
        this._state = 4;
    }

    public void resultHandle(int n) {
        RoleFighter.clearMenu();
        this.menuResultHandle(n);
    }

    public void cancelHandle() {
        RoleFighter.clearMenu();
        this.changeToPreviousCommandState();
        this._echoChooseInxForPanel = 0;
        this._scene.openOnceDrawBK();
    }

    public void shortcutKeyHandle(int n) {
        RoleFighter.clearMenu();
        this.respondForSelectShortcutKey(n);
    }

    private final void respondForSelectShortcutKey(int n) {
    }

    private final void autoSelectMaxInjureSkill() {
        Hashtable hashtable = GameDB.getGameDataBase().getSkillData();
        int n = 0;
        int n2 = -1;
        int[] nArray = this._roleData.getSkillIndex();
        if (this.canUseSkill()) {
            int n3 = 0;
            while (n3 < nArray.length) {
                DataSkill dataSkill = (DataSkill)hashtable.get(new Integer(nArray[n3]));
                if (dataSkill.getEffectKind() == 0 && dataSkill.getExpendMP() <= this._currentMp && dataSkill.getExpendSP() <= this._currentSp && dataSkill.getEffectValue() > n) {
                    n = dataSkill.getEffectValue();
                    n2 = nArray[n3];
                }
                ++n3;
            }
        }
        switch (n2) {
            case -1: {
                this.menuResultHandle(2);
                break;
            }
            default: {
                this.setUseSkillInfo(n2, this._roleData.getLevel());
                this.confirmNextCommandStateByCurrentState();
            }
        }
    }

    public static final void clearMenu() {
        _menu = null;
    }

    private final void menuResultHandle(int n) {
        switch (this._stateCommand) {
            case 2: {
                this.respondForSelectActionKind(n);
                break;
            }
            case 0: {
                this.respondForSelectSkillIndex(n);
                break;
            }
            case 3: {
                this.respondForSelectThingIndex(n);
            }
        }
    }

    private final void respondForSelectActionKind(int n) {
        switch (n) {
            case 0: {
                this.setAttackInfo();
                this.confirmNextCommandStateByCurrentState();
                break;
            }
            case 2: {
                this._echoInxForOther = 2;
                this.selectDefenceHandle();
                break;
            }
            case 1: {
                this.selectSkillHandle();
                break;
            }
            case 3: {
                this.selectThingHandle();
                break;
            }
            case 4: {
                this._echoInxForOther = 4;
                this.selectEscapeHandle();
            }
        }
    }

    public final void selectDefenceHandle() {
        this.setDefenceInfo();
        this.finishCommand();
    }

    private final void selectEscapeHandle() {
        this.setEscapeInfo();
        this._scene._state = 1;
        this.startUpAction();
    }

    protected void finishCommand() {
        this.clearShowFlag();
        super.finishCommand();
    }

    private final void selectThingHandle() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        if (roleTeamData.getEffectThingNum() > 0) {
            this.changeToNextCommandState(3);
        } else {
            this.changeToSelectActionKindCommandState();
        }
    }

    private final void selectSkillHandle() {
        if (this.canUseSkill()) {
            this.changeToNextCommandState(0);
        } else {
            this.changeToSelectActionKindCommandState();
        }
    }

    private final void respondForSelectSkillIndex(int n) {
        int n2;
        int[] nArray = this._roleData.getSkillIndex();
        this._echoChooseSkillIndex = n2 = n;
        this.setUseSkillInfo(n2, this._roleData.getLevel());
        this.confirmNextCommandStateByCurrentState();
    }

    private final void respondForSelectThingIndex(int n) {
        int n2;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        byte[][] byArray = roleTeamData.getThingInfo();
        this._echoChooseThingIndex = n2 = n;
        this.setUseThingInfo(n2);
        roleTeamData.decreaseThing(n2);
        this.confirmNextCommandStateByCurrentState();
    }

    private final void confirmNextCommandStateByCurrentState() {
        this.updateTargetInfo();
        this.updateTargetGroupInfo();
        this.changeToNextCommandState(4);
    }

    private final void updateTargetInfo() {
        switch (this._actionInfo[1]) {
            case 3: {
                this.updateAllRival();
                this.groupingByEveryOne();
                break;
            }
            case 4: {
                this.updateAllRival();
                this.groupingByPosition();
                break;
            }
            case 1: {
                this.updateAllFriend();
                this.groupingByEveryOne();
                break;
            }
            case 2: {
                this.updateAllFriend();
                this.groupingByPosition();
            }
        }
    }

    private final void initActionKindSelectMenu() {
        _menu = Menu.getInstance(this);
        _menu.initPanelStyle(this._isEscape, true, this._roleData.getRoleName());
    }

    private final void initSkillSelectMenu() {
        GameDB gameDB = GameDB.getGameDataBase();
        int[] nArray = this._roleData.getSkillIndex();
        int n = nArray.length;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            DataSkill dataSkill = gameDB.getSkillData(nArray[n2]);
            stringArray[n2] = dataSkill.getName();
            stringArray2[n2] = dataSkill.getDescription();
            nArray3[n2] = this.isVlidSkill(dataSkill);
            ++n2;
        }
        _menu = Menu.getInstance(this);
        _menu.calculateMenuNormalSize();
        _menu.initSkillStyle(nArray, nArray3);
    }

    public int isVlidSkill(DataSkill dataSkill) {
        if (this._currentMp >= dataSkill.getExpendMP() && this._currentSp >= dataSkill.getExpendSP() && RoleTeamData.getInstance().getMoney() >= dataSkill.getExpendMoney()) {
            return 1;
        }
        return -1;
    }

    private final void initThingSelectMenu() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        byte[][] byArray = roleTeamData.getThingInfo();
        int n = roleTeamData.getEffectThingNum();
        GameDB gameDB = GameDB.getGameDataBase();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 0;
        while (n2 < roleTeamData.getThingNum()) {
            DataThing dataThing = gameDB.getThingData(byArray[n2][0]);
            if (dataThing.getTarget() != 0) {
                nArray2[n2] = byArray[n2][0];
                stringArray[n2] = dataThing.getName().trim();
                stringArray2[n2] = dataThing.getDescription().trim();
                nArray3[n2] = roleTeamData.getHoldThingNum(byArray[n2][0]);
            }
            ++n2;
        }
        _menu = Menu.getInstance(this);
        _menu.initDefaultStyle(nArray2, nArray3);
    }

    private final void saveCurrentComamnd() {
        this._commandStack.push(this._stateCommand);
    }

    private final int loadPreviousCommand() {
        return this._commandStack.pop();
    }

    private final void resetCommandStack() {
        this._commandStack.clear();
    }

    public void changeAction(int n) {
        this.changeAnimation(n);
    }

    protected void drawCommandInfo(Graphics graphics) {
        switch (this._stateCommand) {
            case 2: {
                int n = this.getPosX() >> 10;
                if (this._roleData.getAnimationIndex() == 0) {
                    n += 4;
                }
                if (!_isEchoLastAction) {
                    Function.paintCursorV(graphics, n, (this.getPosY() >> 10) - 70);
                }
            }
            case 0: 
            case 3: {
                this.drawMenu(graphics);
                break;
            }
            case 4: {
                this.drawCurrentTargetGroup(graphics);
            }
        }
    }

    private final void drawMenu(Graphics graphics) {
        if (_menu == null) {
            return;
        }
        _menu.draw(graphics);
    }

    protected void drawForDeath(Graphics graphics, int n, int n2) {
        if (this._anim.getId() == 1 && Function.getCurScenario() > 50) {
            this._anim.draw(graphics, n, n2, this._curAction, this._curFrame, 1);
        } else {
            this._anim.draw(graphics, n, n2, this._curAction, this._curFrame, this._palNo);
        }
    }

    private final void drawCurrentTargetGroup(Graphics graphics) {
        Fighter[] fighterArray = this._target[this._curTargetGroup];
        int n = 0;
        while (n < 3) {
            if (fighterArray[n] == null) {
                return;
            }
            fighterArray[n]._isSelected = true;
            if (!_isEchoLastAction) {
                Function.paintCursorV(graphics, fighterArray[n].getPosX() >> 10, fighterArray[n].getSelPostionY() - 10);
            }
            ++n;
        }
    }

    protected void drawVictoryInfo(Graphics graphics) {
    }

    protected boolean canDraw() {
        return true;
    }

    protected void clearState() {
        this.restoreGoodsHandle();
    }

    public void clearDefence() {
        if (this.isDefence()) {
            this._validEffectBoutTime[0] = 0;
            this.changeToWait();
        }
    }

    protected int getExperience() {
        return 0;
    }

    protected boolean isEffectedHarmState() {
        return GameRule.getInstance().isEffectedHarmStateForDefault();
    }

    protected int[] getThing() {
        return null;
    }

    protected int getMoney() {
        return 0;
    }

    protected boolean canObtainExperience() {
        return !this.isDeath();
    }

    protected String[][] battleFinishHandler(int n) {
        this.restoreGoodsHandle();
        this.storeBattleResult();
        if (!this.isDeath()) {
            return this._roleData.obtainExperience(n);
        }
        return null;
    }

    private final void restoreGoodsHandle() {
        if (this._actionInfo[0] == 3) {
            this.restoreThing();
            this.isClear();
        }
    }

    private final void storeBattleResult() {
        this._roleData.setHP(this._currentHp);
        this._roleData.setMP(this._currentMp);
        this._roleData.setSP(this._currentSp);
    }

    protected void changeHP(int n) {
        super.changeHP(n);
        this._roleData.setHP(this._currentHp);
    }

    protected int getAttackedPosX() {
        return this._x - 6400;
    }

    protected int getAttackedPosY() {
        return this._y - 12800;
    }

    protected int getBackPosX() {
        return this._x;
    }

    protected int getBackPosY() {
        return this._y;
    }

    protected int getForePosX() {
        return this._x;
    }

    protected int getForePosY() {
        return this._y;
    }

    protected int getEscapePosX() {
        return this._x + 4096;
    }

    protected int getEscapePosY() {
        return this._y + 4096;
    }

    protected int getUseSkillPosX() {
        return this._x + (this._anim.getCollideRight(this.getActionInx(8)) << 10);
    }

    protected int getUseSkillPosY() {
        return this._y + (this._anim.getCollideTop(this.getActionInx(8)) << 10);
    }

    protected int getEffectBySkillPosX() {
        return this._x;
    }

    protected int getEffectBySkillPosY() {
        return this._y + (this._anim.getVisibleTop() >> 1 << 10);
    }

    protected int getDefencePosX() {
        return this._x + 25600;
    }

    protected int getDefencePosY() {
        return this._y + 25600;
    }

    protected void paintState(Graphics graphics, int n, int n2) {
        int n3 = SptSet.load(125, 1).getSptWidth(2) * 3 / 2;
        if (!this.canUseSkill()) {
            this.paintState(graphics, 3, n, n2);
            n += n3;
        }
        if (this.isRooted()) {
            this.paintState(graphics, 2, n, n2);
            n += n3;
        }
    }

    protected void paintSpecialInfo(Graphics graphics, int n, int n2) {
    }

    protected void escapeHandle() {
        this._scene.changeToEscapeSuccess();
    }

    public boolean isEscapeSucess() {
        if (this._isEscape) {
            return Function.Random(10, true) < 2;
        }
        return false;
    }

    public void changeToEscapeMove() {
        this.moveToActionPos();
    }

    protected boolean canEffectByFriend() {
        return true;
    }

    protected void deathHandle() {
        this._scene.setLoseRoleFlag();
    }

    protected String getFighterName() {
        return this._roleData.getRoleName();
    }

    protected int getPilferThing() {
        return -1;
    }

    public void init(int n, int n2, boolean bl) {
        int n3;
        this._isclear = false;
        this._roleData = RoleTeamData.getInstance().getRoleData(n);
        this._type = n3 = this._roleData.getAnimationIndex();
        this._anim = Animation.load(n3, 1);
        int[] nArray = this._roleData.getCurrentInfo();
        this._maxHp = nArray[4];
        this._maxMp = nArray[6];
        this._maxSp = 100;
        this._currentHp = this._roleData.getHP();
        this._currentMp = this._roleData.getMP();
        this._currentSp = this._roleData.getSP();
        this._attackInjure = nArray[5];
        this._skillInjure = nArray[7];
        this._defence = nArray[9];
        this._bangRate = nArray[10];
        this._parryRate = nArray[13];
        this._hitRate = nArray[15];
        this._missRate = nArray[11];
        this._missAttackRate = nArray[12];
        this._interForcse = nArray[3];
        GameRule gameRule = GameRule.getInstance();
        int[] nArray2 = gameRule.getRoleOrderInfo(n2, this._scene._Bbk);
        this._isEscape = bl;
        this.initData(nArray2);
        this.resetSpeed();
        this.clearShowFlag();
        this._drawWeapon = false;
    }

    public final void dispose() {
        this._roleData = null;
        this._anim = null;
    }

    public RoleFighter(BattleScene battleScene) {
        super(battleScene);
        this._mainLogic = battleScene.getMainLogic();
    }

    boolean canParry(int n) {
        GameRule gameRule = GameRule.getInstance();
        return gameRule.canParry(n, false);
    }

    protected boolean isExtremityDeath() {
        return this._currentHp < this._maxHp * 20 / 100;
    }

    boolean isBangAttacked() {
        return false;
    }

    protected int getFighterProperty() {
        return -5;
    }

    public void setEffect() {
    }

    public int getBangCout(int n) {
        return 1;
    }

    protected int getCurrentLevel() {
        return this._roleData.getLevel();
    }

    public void resetEchoChoose() {
        this._echoChooseInxForPanel = 0;
        this._echoInxForOther = 0;
        this._echoChooseSkillIndex = 0;
        this._echoChooseThingIndex = 0;
        _isEchoLastAction = false;
    }

    public static void setEchoLastAction(boolean bl) {
        _isEchoLastAction = bl;
    }

    public static boolean getEchoLastAction() {
        return _isEchoLastAction;
    }

    private int isHaveEnoughMp(int n) {
        GameDB gameDB = GameDB.getGameDataBase();
        DataSkill dataSkill = gameDB.getSkillData(n);
        return this.isVlidSkill(dataSkill);
    }

    private boolean isHaveEnoughThing(int n) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        return roleTeamData.getHoldThingNum(n) > 0;
    }

    private void updateEchoChoose() {
        block0 : switch (this._echoChooseInxForPanel) {
            case 0: {
                this.menuResultHandle(this._echoChooseInxForPanel);
                break;
            }
            case 1: {
                if (this.canUseSkill() && this.isHaveEnoughMp(this._echoChooseSkillIndex) == 1) {
                    this.respondForSelectSkillIndex(this._echoChooseSkillIndex);
                    break;
                }
                this.menuResultHandle(0);
                break;
            }
            case 3: {
                if (this.isHaveEnoughThing(this._echoChooseThingIndex)) {
                    this.respondForSelectThingIndex(this._echoChooseThingIndex);
                    break;
                }
                this.menuResultHandle(0);
                break;
            }
            case 2: {
                switch (this._echoInxForOther) {
                    case 2: {
                        this.selectDefenceHandle();
                        break block0;
                    }
                    case 4: {
                        this.selectEscapeHandle();
                    }
                }
            }
        }
    }

    protected boolean isClear() {
        this._isclear = true;
        return this._isclear;
    }

    static {
        _isEchoLastAction = false;
    }
}

