/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.game.Actor;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.Scene;
import com.sinaflying.game.ScriptDriver;
import com.sinaflying.game.UnitData;
import javax.microedition.lcdui.Graphics;

public class RoleActor
extends Actor {
    public static int MAN_ACTION_NULL = 6;
    public static int MAN_ACTION_WAIT = 0;
    public static int WOMEN_ACTION_NULL = 7;
    public static int WOMEN_ACTION_WAIT = 0;
    public boolean _mainFlag;
    int ticks;
    public static int isBuyFly = 0;
    private int currentAnimationInx;

    public RoleActor(int n, Animation animation) {
        super(n, animation);
    }

    public boolean init(UnitData unitData) {
        super.init(unitData);
        if (this._mainFlag) {
            switch (this._type) {
                case 0: {
                    this.changeAction(MAN_ACTION_WAIT);
                    break;
                }
                case 1: {
                    this.changeAction(WOMEN_ACTION_WAIT);
                }
            }
        }
        return true;
    }

    public Actor activate(Scene scene, int n) {
        super.activate(scene, n);
        if (this._scene.canBecameMain(this._type, n)) {
            scene.setFocusActor(this);
            scene.setMainActor(this);
            this._mainFlag = true;
        } else {
            this._mainFlag = false;
        }
        return this;
    }

    public void step() {
        if (this.isExecuteStep()) {
            this.nextFrame();
            this._vx += this._avx;
            this._vy += this._avy;
            this._dx = this._vx;
            this._dy = this._vy;
            this.initAngleSolidParam();
            this.checkIsAnglePhy();
            this.checkLeftWall();
            this.checkRightWall();
            this.checkUpWall();
            this.checkBottomWall();
            this._x += this._dx;
            this._y += this._dy;
            this.checkActorBlock();
        }
    }

    private final boolean isExecuteScript() {
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        return scriptDriver.isExecuting();
    }

    private final void checkActorBlock() {
        if (this.isExecuteScript()) {
            return;
        }
        if (GameMainLogic.isFly) {
            return;
        }
        int[] nArray = new int[]{0};
        Actor[] actorArray = this._scene.getActiveInsts(nArray);
        int n = 0;
        while (n < nArray[0]) {
            Actor actor = actorArray[n];
            if (actor._active && actor != this && actor.getAniInx() != 99 && actor.getAniInx() != 98 && actor.getAniInx() != 100 && this.collide(actor)) {
                if (!this.DontCollide(actor._type)) {
                    this.collideHandle(actor);
                }
                return;
            }
            ++n;
        }
    }

    private boolean DontCollide(int n) {
        switch (n) {
            case 100: {
                return true;
            }
        }
        return false;
    }

    public void ai() {
        if (this.isExecuteAI()) {
            this.actHandler();
            this.keyHandler();
        }
    }

    public void actHandler() {
    }

    public void keyHandler() {
        if (this._scene._messageBox != null) {
            if (this._vx != 0 || this._vy != 0) {
                this.changeToWait();
            }
            return;
        }
        this.keyRespond();
    }

    private final void keyRespond() {
        if (!this._mainFlag) {
            return;
        }
        int n = this._mainLogic.getCurKey();
        switch (n) {
            case 1: {
                this.changeToWalk(7);
                break;
            }
            case 7: {
                this.changeToWalk(5);
                break;
            }
            case 3: {
                this.changeToWalk(-2147483642);
                break;
            }
            case 5: {
                this.changeToWalk(6);
                break;
            }
            case 0: {
                this.changeToWalk(-2147483639);
                break;
            }
            case 6: {
                this.changeToWalk(-2147483640);
                break;
            }
            case 2: {
                this.changeToWalk(9);
                break;
            }
            case 8: {
                this.changeToWalk(8);
                break;
            }
            default: {
                this.changeToWait();
            }
        }
    }

    private boolean canPressKey() {
        return this._curFrame % this._actFrmNum == 0;
    }

    protected void collideLeftWall() {
        this.changeToWait();
    }

    protected void collideRightWall() {
        this.changeToWait();
    }

    public void paintInfo(Graphics graphics) {
        if (GameMainLogic.isFly && this._mainFlag && isBuyFly == 1) {
            graphics.setClip(0, 0, 320, 240);
            int n = this._x - GameMainLogic.getWorldScene()._camx >> 10;
            int n2 = (this._y - GameMainLogic.getWorldScene()._camy >> 10) - 5;
            ++this.ticks;
            if (Animation.getAnimation(149) == null) {
                Animation.load(149, 1);
            }
            Animation.getAnimation(149).draw(graphics, n - 2, n2 + 4, 0, this.ticks % 6, 0);
        }
    }

    public final void changeAnimation(int n) {
        if (this.currentAnimationInx != n) {
            this.currentAnimationInx = n;
            this._anim = Animation.getAnimation(n);
        }
    }
}

