/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.engine.MazeBk;
import com.sinaflying.engine.TiledBackground;
import com.sinaflying.game.Actor;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.Scene;
import com.sinaflying.game.UnitData;
import com.sinaflying.gameUtil.MessageBoxHandler;
import com.sinaflying.util.Function;
import com.sinaflying.util.StreamReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MazeScene
extends Scene
implements MessageBoxHandler {
    private static final int SCENE_STATE_PLAYING = 0;
    private static final int SCENE_STATE_PASSLEVEL = 1;
    private static final int SCENE_STATE_INIT_SHOP = 2;
    private static final int SCENE_STATE_CONFIRM_SHOP = 3;
    private static final int SCENE_STATE_MENU = 4;
    private static final int SCENE_STATE_HELP = 5;
    private static final int SCENE_STATE_ABOUT = 6;
    private static final int SCENE_STATE_SAVE_SUCCESS = 7;
    private static final int SCENE_STATE_FINISH_SHOW_START = 8;
    private static final int SCENE_STATE_FINISH_SHOWING = 9;
    private static final int SCENE_STATE_FINISH_SHOW_END = 10;
    private static final int SCENE_STATE_FINISH_SHOW_CLODE = 11;
    private static final int SCENE_STATE_REST_START = 12;
    private static final int SCENE_STATE_REST_SHOW_INFO = 13;
    private static final int SCENE_STATE_REST_SHOW_END = 14;
    private static final int SCENE_STATE_TIME_END = 15;
    public static final int SCENE_STATE_GAME_EFFECT = 18;
    public static final int SCENE_STATE_LEARN = 19;
    static Vector _instId = new Vector();
    public static MazeScene _ms;

    public RoleActor getMainActor() {
        MazeScene mazeScene = GameRule.getMazeScene(GameMainLogic._enterSceneId);
        return mazeScene._mainActor;
    }

    public void paint(Graphics graphics) {
        switch (this._state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 15: {
                this.paintCommon(graphics);
                break;
            }
            case 4: {
                this.paintCommon(graphics);
                this.paintMenu(graphics);
                break;
            }
            case 7: {
                this.paintCommon(graphics);
                break;
            }
            case 5: {
                this.gameHelp(graphics);
                break;
            }
            case 6: {
                this.gameAbout(graphics);
            }
        }
    }

    public final void update() {
        switch (this._state) {
            case 0: 
            case 1: {
                this.updateActors();
                this.updateCaptors();
                this.updateScript();
                this.updateZone();
                break;
            }
            case 3: {
                break;
            }
        }
        this.keyRespond();
    }

    public void paintCommon(Graphics graphics) {
        this.updateCameraOffset();
        this.paintMap(graphics);
        this.paintActor(graphics);
        this.paintUI(graphics);
        this.paintSceneInfo(graphics);
        if (this._mainLogic._state != 3) {
            this.paintInfo(graphics);
        }
    }

    private final void paintInfo(Graphics graphics) {
        if (this._messageBox != null) {
            this._messageBox.draw(graphics);
        }
    }

    private final void paintUI(Graphics graphics) {
        if (!this.getMainActor()._enableAI || !this._executor.isFinishDialog()) {
            return;
        }
        if (this._mainLogic._state != 1) {
            Function.drawSoftItem(graphics, 2);
            return;
        }
        Function.draw3DString(graphics, GameParameter.CAIDAN, 2, 238, 4 | 0x20, 273, 0xFCFCEC);
        Function.draw3DString(graphics, GameParameter.RENWU, 318, 238, 8 | 0x20, 273, 0xFCFCEC);
    }

    public MazeScene getCurScene(int n, int n2) {
        int n3 = 0;
        if (n / this._bk.getMapWidth() > MazeBk.BK_INDEX[0].length - 1 || n2 / this._bk.getMapHeight() > MazeBk.BK_INDEX.length - 1) {
            return null;
        }
        n3 = MazeBk.BK_INDEX[n2 / this._bk.getMapHeight()][n / this._bk.getMapWidth()];
        return GameRule.getMazeScene(n3);
    }

    public void produceMazeInstance(GameMainLogic gameMainLogic, int n) {
        this._bk = n < 52 && n > 38 ? new MazeBk(320, 240) : (n >= 75 && n <= 77 ? new MazeBk(320, 240) : new TiledBackground(320, 240));
        this._mainLogic = gameMainLogic;
    }

    public void produceSector() throws IOException {
        int n;
        int n2;
        this._types = Scene._is.read();
        int n3 = 0;
        while (n3 < this._types) {
            this._typesLoad[n3][0] = StreamReader.readByte(Scene._is);
            if (this._typesLoad[n3][0] < 0) {
                int[] nArray = this._typesLoad[n3];
                nArray[0] = nArray[0] + 256;
            }
            byte by = StreamReader.readByte(Scene._is);
            this._typesLoad[n3][1] = StreamReader.readByte(Scene._is) + by;
            if (this._typesLoad[n3][0] == 99) {
                this._typesLoad[n3][1] = 20;
            }
            ++n3;
        }
        this._sectorNum = this._bk.getMapHeight() / this._sectorHeight * (this._bk.getMapWidth() / this._sectorWidth);
        this._sectorCaptorId = new int[this._sectorNum][];
        n3 = 0;
        while (n3 < this._sectorNum) {
            n2 = StreamReader.readByte(Scene._is);
            if (n2 > 0) {
                this._sectorCaptorId[n3] = new int[n2];
                n = 0;
                while (n < n2) {
                    this._sectorCaptorId[n3][n] = StreamReader.readInt(Scene._is);
                    ++n;
                }
            }
            ++n3;
        }
        if (this._id == GameMainLogic.getEnterSceneId()) {
            Scene._globalActorNum = StreamReader.readByte(Scene._is);
            Scene._globalActorId = new int[Scene._globalActorNum];
            n3 = 0;
            while (n3 < Scene._globalActorNum) {
                Scene._globalActorId[n3] = StreamReader.readInt(Scene._is);
                ++n3;
            }
        } else {
            StreamReader.readByte(Scene._is);
        }
        this._sectorActorId = new int[this._sectorNum][];
        n3 = 0;
        while (n3 < this._sectorNum) {
            n2 = Scene._is.read();
            if (n2 > 0) {
                this._sectorActorId[n3] = new int[n2];
                n = 0;
                while (n < n2) {
                    this._sectorActorId[n3][n] = StreamReader.readInt(Scene._is);
                    ++n;
                }
            }
            ++n3;
        }
    }

    public void paintSceneInfo(Graphics graphics) {
        if (this._id != 0) {
            Function.draw3DString(graphics, this._mainLogic.sceneName(this._id), 160, 0, 1 | 0x10, 0xFFFFFF, 255);
        }
    }

    public void paintActor(Graphics graphics) {
        Actor[] actorArray = this._executeInsts;
        int n = this._executeNum;
        this.sort(actorArray, n);
        int n2 = this._camx >> 10;
        int n3 = this._camy >> 10;
        int n4 = 0;
        while (n4 < n) {
            graphics.setClip(0, 0, 320, 240);
            actorArray[n4].paintInfo(graphics);
            actorArray[n4].draw(graphics, n2, n3, this._cameraOffset);
            ++n4;
        }
    }

    public void updateZone() {
        Actor actor = this.getFocusActor();
        this.updateCamera(actor, this.getWidth(), this.getHeight());
        this.updateSector();
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        this._bk.setPositionInMap(n, n2);
    }

    public void updateCaptors() {
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        MazeScene mazeScene = this.getCurScene(n, n2);
        int[][] nArray = mazeScene._sectorCaptorId;
        if (nArray[0] == null) {
            return;
        }
        int[] nArray2 = nArray[0];
        int n3 = nArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            mazeScene.getUnitData(nArray2[n4]).setValid();
            mazeScene.checkCaptor(nArray2[n4]);
            ++n4;
        }
    }

    public void disActiveInst(int n) {
        MazeScene mazeScene = GameRule.getMazeScene(GameMainLogic.getEnterSceneId());
        mazeScene.setInstsInvalid();
        Actor actor = (Actor)Scene._activeContainer.remove(String.valueOf(n));
        _instId.removeElement(String.valueOf(n));
        if (actor != null) {
            actor._active = false;
        }
    }

    public Actor fetchActorFromPool(int n, int n2, int n3) {
        Actor actor = null;
        UnitData unitData = null;
        Actor[][] actorArray = this._actorPool;
        if (_instId.contains(String.valueOf(n2))) {
            return null;
        }
        if (n < 0) {
            unitData = this.getUnitData(n2 % 10);
            if (unitData == null) {
                return null;
            }
            n = unitData.getPicId();
        }
        int n4 = actorArray[n].length;
        int n5 = 0;
        while (n5 < n4) {
            actor = actorArray[n][n5];
            if (!actor._active) break;
            ++n5;
        }
        if (n2 >= 0) {
            unitData.setInvalid();
            _instId.addElement(String.valueOf(n2));
            actor.activate(GameRule.getMazeScene(GameMainLogic.getEnterSceneId()), n2);
            actor.init(unitData, n3 % MazeBk.BK_INDEX[0].length * this._sectorWidth, n3 / MazeBk.BK_INDEX[0].length * this._sectorHeight);
            this.addActorToActiveContainer(actor, n2);
            return actor;
        }
        if (n2 == -1) {
            n2 = this.getDynamicID();
            actor.activate(this, n2);
            actor.resetData();
            this.addActorToActiveContainer(actor, n2);
            return actor;
        }
        return null;
    }

    public void startUpCamera() {
        this.initCamera(this._focus, this.getWidth(), this.getHeight());
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        this._bk.setPositionInMap(n, n2);
        this._curSector = -1;
    }

    public void updateSector() {
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        MazeScene mazeScene = this.getCurScene(n, n2);
        this._bk.setPositionInMap(n, n2);
        mazeScene._bk.setPositionInMap(n, n2);
        int n3 = n / this._bk.getMapWidth();
        int n4 = n2 / this._bk.getMapHeight();
        int[] nArray = new int[4];
        nArray[0] = n4 * MazeBk.BK_INDEX[0].length + n3;
        if (nArray[0] == this._curSector) {
            return;
        }
        nArray[3] = (n4 + 1) * MazeBk.BK_INDEX[0].length + n3 + 1;
        nArray[2] = (n4 + 1) * MazeBk.BK_INDEX[0].length + n3;
        nArray[1] = n4 * MazeBk.BK_INDEX[0].length + n3 + 1;
        MazeScene[] mazeSceneArray = new MazeScene[4];
        if (this.getMainActor()._vx < 0 || this.getMainActor()._vy < 0 || mazeScene.getID() == GameMainLogic.getEnterSceneId() || mazeScene.getID() == GameMainLogic.getExitSceneId()) {
            mazeSceneArray[0] = mazeScene;
        }
        if (n3 < MazeBk.BK_INDEX[0].length - 1 && this.getMainActor()._vx >= 0) {
            mazeSceneArray[1] = this.getCurScene(n + this._bk.getMapWidth(), n2);
        }
        if (n4 < MazeBk.BK_INDEX.length - 1 && this.getMainActor()._vy >= 0) {
            mazeSceneArray[2] = this.getCurScene(n, n2 + this._bk.getMapHeight());
        }
        if (n3 < MazeBk.BK_INDEX[0].length - 1 && n4 < MazeBk.BK_INDEX.length - 1) {
            mazeSceneArray[3] = this.getCurScene(n + this._bk.getMapWidth(), n2 + this._bk.getMapHeight() - 1);
        }
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int[][] nArrayArray = new int[4][];
        int n8 = 0;
        while (n8 < mazeSceneArray.length) {
            if (mazeSceneArray[n8] != null) {
                nArrayArray[n8] = mazeSceneArray[n8]._sectorActorId[0];
                if (nArrayArray[n8] != null) {
                    ++n7;
                }
            }
            ++n8;
        }
        int n9 = 0;
        int n10 = 0;
        while (n10 < n7) {
            n5 = 0;
            n6 = 0;
            while (nArrayArray[n9] != null && n5 < nArrayArray[n9].length) {
                ++n10;
                this._newIds[n6++] = nArray[n9] * 10 + nArrayArray[n9][n5];
                ++n5;
            }
            int n11 = 0;
            while (n11 < n6) {
                mazeSceneArray[n9].fetchActorFromPool(-1, this._newIds[n11], nArray[n9]);
                ++n11;
            }
            ++n9;
        }
        this.setInstsInvalid();
        this._curSector = nArray[0];
        this.updateInsts();
    }

    public void updateInsts() {
        if (this._isValidInsts) {
            return;
        }
        this._isValidInsts = true;
        Actor[] actorArray = this._executeInsts;
        int n = 0;
        Enumeration enumeration = Scene._activeContainer.elements();
        while (enumeration.hasMoreElements()) {
            Actor actor = (Actor)enumeration.nextElement();
            if (this.isValidActor(actor._id)) {
                if (!actor.isValid()) continue;
                actorArray[n++] = actor;
                continue;
            }
            actor._scene.disActiveInst(actor._id);
        }
        this._executeNum = n;
    }

    public void createActorPool(int n, int n2) {
        if (n < 0) {
            n += 256;
        }
        if (this._actorPool[n] != null) {
            return;
        }
        this._actorPool[n] = new Actor[5];
        int n3 = 0;
        while (n3 < 5) {
            this._actorPool[n][n3] = Actor.createActor(n, Animation.getAnimation(n));
            ++n3;
        }
    }

    public boolean isValidActor(int n) {
        if (Scene.isGloabalId(n) || this._curSector == -1) {
            return true;
        }
        int n2 = MazeBk.BK_INDEX[0].length;
        int n3 = MazeBk.BK_INDEX.length;
        if ((n /= 10) / n2 > this._curSector / n2 + 1 || n / n2 < this._curSector / n2 - 1) {
            return false;
        }
        return n % n2 <= this._curSector % n2 + 1 && n % n2 >= this._curSector % n2 - 1;
    }

    public void validityCheckCamera(int n, int n2) {
        int n3 = this._camx >> 10;
        int n4 = this._camy >> 10;
        n3 = Math.min(n3, (n *= MazeBk.BK_INDEX[0].length) - 320);
        n3 = Math.max(n3, 0);
        n4 = Math.min(n4, (n2 *= MazeBk.BK_INDEX.length) - 240);
        n4 = Math.max(n4, 0);
        this._camx = n3 << 10;
        this._camy = n4 << 10;
    }

    public void produceMap(MazeScene mazeScene) throws IOException {
        this._sectorWidth = StreamReader.readShort(Scene._is);
        this._sectorHeight = StreamReader.readShort(Scene._is);
        int n = StreamReader.readByte(Scene._is);
        n = mazeScene.checkMapFlip(this._id, n);
        this._bk.load(n);
    }

    public void dispose() {
        Enumeration enumeration = GameRule.getMs().elements();
        GameMainLogic._enterSceneId = -1;
        GameMainLogic._exitSceneId = -1;
        _instId.removeAllElements();
        while (enumeration.hasMoreElements()) {
            MazeScene mazeScene = (MazeScene)enumeration.nextElement();
            mazeScene.disposeMaze();
            GameRule.removeMk(mazeScene.getID());
            GameRule.removeMs(mazeScene.getID());
        }
    }

    public void disposeMaze() {
        super.dispose();
    }

    public void springBattle(int[] nArray, int n, int n2) {
        MazeScene mazeScene = GameRule.getMazeScene(GameMainLogic.getEnterSceneId());
        mazeScene.springMazeBattle(nArray, n, n2);
    }

    public void springMazeBattle(int[] nArray, int n, int n2) {
        this._battleInfoBK = n;
        this._battleInfoFK = n2;
        GameRule gameRule = GameRule.getInstance();
        gameRule.setEnemyBattleTeam(nArray);
        this.changeToBattle(gameRule.canEscape(nArray));
    }

    public static boolean produceMazeScene(GameMainLogic gameMainLogic, int n) {
        if ((n == 1 || n == 0) && GameInterface._openPramInfo && !GameInterface._closePartInfo && GameInterface._paraValue[1] > 0) {
            n = GameInterface._paraValue[1];
        }
        try {
            switch (Scene.produceProcess) {
                case 0: {
                    if (GameRule.getMs().get(new Integer(n)) != null) {
                        return true;
                    }
                    _ms = new MazeScene();
                    _ms.produceMazeInstance(gameMainLogic, n);
                    int n2 = n / 10;
                    int n3 = n % 10;
                    MazeScene._ms._id = n;
                    Scene._is = StreamReader.openDataFile("/res/scene" + n2 + ".bin", n3);
                    _ms.produceMap();
                    Scene.produceProcess = 2;
                    break;
                }
                case 2: {
                    _ms.produceSector();
                    _ms.produceUnit();
                    Scene.produceProcess = 4;
                    _ms.produceActor();
                    _ms.produceNeedActor();
                    _ms.produceInitParameter(n);
                    GameRule.getMs().put(new Integer(n), _ms);
                    GameRule.getMk().put(new Integer(n), MazeScene._ms._bk);
                    Scene.produceProcess = 0;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public void finishHandle(int n) {
    }
}

