/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.game.NPCActor;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.ScriptDriver;
import com.sinaflying.game.UnitData;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

public class Human
extends NPCActor {
    private int _preAction;
    protected int _state;
    public static final int C_STATE_ALWAY_WAIT = 0;
    public static final int C_STATE_WAIT = 1;
    public static final int C_STATE_WALK = 2;
    public static final int C_STATE_SCRIPT = 3;
    private int _keepCounter;
    private static final int C_KEEP_TIME_MIN = 20;
    private static final int C_KEPP_TIME_CHANGE = 20;
    private static final int C_MOVE_DIR = 0;
    private static final int C_MOVE_LIMITE_MIN = 1;
    private static final int C_MOVE_LIMITE_MAX = 2;
    private static final int C_MOVE_DIR_X = 0;
    private static final int C_MOVE_DIR_Y = 1;
    private int _moveDestinationX;
    private int _moveDestinationY;
    private static final int[] C_RANDOM_WAIT_DIR = new int[]{1, -2147483647, 0, 2};

    public Human(int n, Animation animation) {
        super(n, animation);
    }

    public boolean init(UnitData unitData) {
        super.init(unitData);
        this.changeWait();
        return true;
    }

    public void init(int n, int n2, int n3) {
        super.init(n, n2, n3);
        this.changeWait();
    }

    private final void updateKeepTime() {
        this._keepCounter = Function.Random(20, true) + 20;
    }

    private final boolean isTimeOut() {
        return --this._keepCounter <= 0;
    }

    private final boolean isMovable() {
        return this._data != null && this._data.getParameter() != null;
    }

    private final void changeWait() {
        if (this.isMovable()) {
            this._state = 1;
            this.updateKeepTime();
        } else {
            this._state = 0;
        }
    }

    public void ai() {
        if (!this.isExecuteAI()) {
            return;
        }
        if (this.DontMove()) {
            if (this.scriptHandle()) {
                this.changeScript();
            }
            return;
        }
        switch (this._state) {
            case 0: {
                this.updateForAlwayWait();
                break;
            }
            case 1: {
                this.updateForWait();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.updataForScript();
            }
        }
    }

    public void updateForWait() {
        if (this.scriptHandle()) {
            this.changeScript();
            return;
        }
    }

    public final void updateForAlwayWait() {
        if (this.scriptHandle()) {
            this.changeScript();
            return;
        }
    }

    public final void changeRandomWait() {
        this.updateKeepTime();
        this.changeToWait(this.getRandomDirection());
    }

    public final int getRandomDirection() {
        int n = C_RANDOM_WAIT_DIR.length;
        return C_RANDOM_WAIT_DIR[Function.Random(n, true)];
    }

    public final void updataForScript() {
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        if (!scriptDriver.isExecuting()) {
            this.changeWait();
            this.changeToWait(this._preAction);
        }
    }

    public final void changeScript() {
        this._preAction = this._curAction;
        this.faceToMain();
        this._state = 3;
    }

    public final void faceToMain() {
        if (!this.isFaceToMain()) {
            return;
        }
        RoleActor roleActor = this._scene.getMainActor();
        switch (roleActor.getFaceDirection()) {
            case 0: {
                this.changeToWait(Integer.MIN_VALUE);
                break;
            }
            case 1: {
                this.changeToWait(0);
                break;
            }
            case 2: {
                this.changeToWait(0);
                break;
            }
            case 3: {
                this.changeToWait(2);
            }
        }
    }

    public void changeToWait(int n) {
        this._vx = 0;
        this._vy = 0;
    }

    public void step() {
        if (!this.isExecuteStep()) {
            return;
        }
        this.nextFrame();
        if (this.DontMove()) {
            return;
        }
        switch (this._state) {
            case 0: 
            case 1: 
            case 3: {
                return;
            }
            case 2: {
                this.walking();
            }
        }
    }

    public boolean DontMove() {
        switch (this._type) {
            case 100: {
                return true;
            }
        }
        return false;
    }

    public final void walking() {
        this._x += this._vx;
        this._y += this._vy;
        if (this.checkCollideMain() || this.isArriveDestination()) {
            this._state = 1;
            this.updateKeepTime();
            this.changeToWait();
        }
    }

    public final boolean checkCollideMain() {
        RoleActor roleActor = this._scene.getMainActor();
        if (this.collide(roleActor)) {
            this.collideHandle(roleActor);
            return true;
        }
        return false;
    }

    public final boolean isArriveDestination() {
        if (this._vx > 0 ? this._x < this._moveDestinationX : (this._vx < 0 ? this._x > this._moveDestinationX : (this._vy > 0 ? this._y < this._moveDestinationY : this._vy < 0 && this._y > this._moveDestinationY))) {
            return false;
        }
        this._x = this._moveDestinationX;
        this._y = this._moveDestinationY;
        return true;
    }

    public final boolean isFaceToMain() {
        return true;
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        super.draw(graphics, n, n2, n3);
        if (this.getParamScenario() == RoleTeamData.getInstance().getScenario()[0]) {
            Function._ani_100.draw(graphics, (this._x >> 10) - n, (this._y >> 10) - n2 - 16, 3, Function._ani_100_curFrame, 0);
            if (++Function._ani_100_curFrame > 3) {
                Function._ani_100_curFrame = 0;
            }
        }
    }
}

