/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.DataEquip;
import com.sinaflying.db.DataRole;
import com.sinaflying.db.DataSkill;
import com.sinaflying.db.DataThing;
import com.sinaflying.db.GameDB;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.util.Function;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class GameRoleData {
    private int _curRoleInx;
    private DataRole _dataRole;
    private boolean _infoValidFlag;
    private static final int C_INFO_SIZE = 17;
    public static final int C_INFO_STRENGTH = 1;
    public static final int C_INFO_INTELLIGENCE = 2;
    public static final int C_INFO_INTERNAL_FORCE = 3;
    public static final int C_INFO_MAX_HP = 4;
    public static final int C_INFO_INJURE = 5;
    public static final int C_INFO_MAX_MP = 6;
    public static final int C_INFO_SKILL_INJURE = 7;
    public static final int C_INFO_DEFENCE = 9;
    public static final int C_INFO_BANG_RATE = 10;
    public static final int C_INFO_MISS_RATE = 11;
    public static final int C_INFO_MISS_ATTACK = 12;
    public static final int C_INFO_PARRY_RATE = 13;
    public static final int C_INFO_SKILL_PROFICIENCY = 14;
    public static final int C_INFO_ATTACK_RATE = 15;
    public static final int C_INFO_SKILL_DEFENCE = 16;
    public int[] _info = new int[17];
    private int _hp;
    private int _mp;
    private int _sp;
    public int _level;
    private int _lostLevel;
    private int _experience;
    private int[] _skillInx;
    private Hashtable _specialSkill;
    private int[] _orificeInx;
    private int[] _equipInx;

    public final int getAnimationIndex() {
        return this._dataRole.getAnimationIndex();
    }

    public final int getHeadSptInx() {
        GameRule gameRule = GameRule.getInstance();
        return gameRule.getHeadSptInx(this.getAnimationIndex());
    }

    public final int getBodySptInx() {
        GameRule gameRule = GameRule.getInstance();
        return gameRule.getBodySptInx(this.getAnimationIndex());
    }

    public final String getRoleName() {
        return this._dataRole.getName();
    }

    public final int[] getSkillIndex() {
        return this._skillInx;
    }

    public void updateSkillIndex() {
        if (this._level == 0) {
            this.addSpecialSkillIndex(1);
        }
        GameDB gameDB = GameDB.getGameDataBase();
        Hashtable hashtable = gameDB.getSkillData();
        int[] nArray = new int[hashtable.size()];
        int n = 0;
        int n2 = hashtable.size();
        while (n2 >= 1) {
            DataSkill dataSkill = (DataSkill)hashtable.get(new Integer(n2));
            int n3 = this._curRoleInx;
            n3 = this._curRoleInx == 1 && RoleTeamData.getInstance().getScenario()[0] > 50 ? 3 : this._curRoleInx;
            if (n3 == dataSkill.getRoleInx() && (dataSkill.getLevelGet() <= this.getLevel() || this._specialSkill.get(new Integer(n2)) != null)) {
                nArray[n++] = n2;
            }
            --n2;
        }
        this._skillInx = new int[n];
        if (n != 0) {
            System.arraycopy(nArray, 0, this._skillInx, 0, n);
        }
        nArray = null;
    }

    public final void addSpecialSkillIndex(int n) {
        this._specialSkill.put(new Integer(n), new Integer(0));
    }

    public final void disSpecialSkillIndex(int n) {
        this._specialSkill.remove(new Integer(n));
        this.updateSkillIndex();
    }

    public final void resetSpecialSkillIndex() {
        this._specialSkill.clear();
        this.updateSkillIndex();
    }

    public final int getBangRate() {
        GameDB gameDB = GameDB.getGameDataBase();
        int n = 0;
        int n2 = this._equipInx.length;
        int n3 = 0;
        while (n3 < n2) {
            ++n3;
        }
        return n;
    }

    public final void resetData() {
        this.setInfoInvalidFlag();
        this.rest();
    }

    public final void rest() {
        int[] nArray = this.getCurrentInfo();
        this.updateSkillIndex();
        this._hp = nArray[4];
        this._mp = nArray[6];
    }

    public void resetPro() {
        int[] nArray = this.getSkillIndex();
        if (nArray == null || nArray.length == 0) {
            return;
        }
    }

    private final void setInfoInvalidFlag() {
        this._infoValidFlag = false;
    }

    public final void updateInfo() {
        if (this._infoValidFlag) {
            return;
        }
        this._infoValidFlag = true;
        int[] nArray = this._dataRole.getAttribute(this.getLevel());
        GameRule gameRule = GameRule.getInstance();
        this._info[1] = nArray[0];
        this._info[2] = nArray[1];
        this._info[3] = nArray[2];
        this.addOffsetAttribute(1, 3);
        this._info[4] = gameRule.getHPBaseStrength(this._curRoleInx, this._info[1]);
        this._info[6] = gameRule.getSPBaseIntelligence(this._curRoleInx, this._info[2]);
        this._info[5] = gameRule.getAttackInjureBaseStrength(this._curRoleInx, this._info[1]);
        this._info[7] = gameRule.getSPAttackBaseIntelligence(this._curRoleInx, this._info[2]);
        this._info[9] = gameRule.getDefenceBaseIntelforce(this._curRoleInx, nArray[2]);
        this._info[10] = gameRule.getBangRate(0);
        this._info[13] = gameRule.getParryRate(0);
        this._info[12] = gameRule.getMissAttackRate(0);
        this._info[15] = gameRule.getHitRate(0);
        this._info[11] = gameRule.getMissRate(0);
        this.addOffsetAttribute(4, 16);
    }

    public final int[] getCurrentInfo() {
        this.updateInfo();
        return this._info;
    }

    public final int getHP() {
        return this._hp;
    }

    public final void setHP(int n) {
        this._hp = Math.max(n, 1);
    }

    public final int getMP() {
        return this._mp;
    }

    public final void setMP(int n) {
        this._mp = Math.max(n, 0);
    }

    public final int getSP() {
        return this._sp;
    }

    public final void setSP(int n) {
        this._sp = Math.max(n, 0);
    }

    public final int getLevel() {
        return this._level;
    }

    public final void setExperience(int n) {
        this._experience = n;
    }

    public final void setLevel(int n) {
        this._level = n;
        this.resetData();
    }

    public final int getLevelForShow() {
        return this._level;
    }

    public final int getCurrentExperience() {
        return this._experience;
    }

    public final int getLevelUpExperience() {
        return this._dataRole.getExperence(this._level);
    }

    public final String[][] obtainExperience(int n) {
        this._lostLevel = this._level;
        int n2 = 60;
        if (this._level == n2) {
            return null;
        }
        this._experience += n;
        if (this._experience >= this._dataRole.getExperence(this._level)) {
            while (this._experience >= this._dataRole.getExperence(this._level) && this._level < 60) {
                ++this._level;
                this._experience -= this._dataRole.getExperence(this._lostLevel);
                this.resetData();
            }
            return this.produceVictoryInfo();
        }
        return null;
    }

    private final String[][] produceVictoryInfo() {
        String[][] stringArray = new String[this._level - this._lostLevel][40];
        String[][] stringArray2 = new String[stringArray.length][];
        StringBuffer stringBuffer = Function.getInfoBuffer();
        GameRule gameRule = GameRule.getInstance();
        int n = 0;
        while (n < this._level - this._lostLevel) {
            int n2 = this._lostLevel + n;
            int n3 = this._lostLevel + n + 1;
            int n4 = this._dataRole.getAttribute(n2)[0];
            int n5 = this._dataRole.getAttribute(n3)[0];
            int n6 = this._dataRole.getAttribute(n2)[1];
            int n7 = this._dataRole.getAttribute(n3)[1];
            int n8 = this._dataRole.getAttribute(n2)[2];
            int n9 = this._dataRole.getAttribute(n3)[2];
            int n10 = gameRule.getHPBaseStrength(this._curRoleInx, n4);
            int n11 = gameRule.getHPBaseStrength(this._curRoleInx, n5);
            int n12 = gameRule.getAttackInjureBaseStrength(this._curRoleInx, n4);
            int n13 = gameRule.getAttackInjureBaseStrength(this._curRoleInx, n5);
            int n14 = gameRule.getSPBaseIntelligence(this._curRoleInx, n6);
            int n15 = gameRule.getSPBaseIntelligence(this._curRoleInx, n7);
            int n16 = gameRule.getSPAttackBaseIntelligence(this._curRoleInx, n6);
            int n17 = gameRule.getSPAttackBaseIntelligence(this._curRoleInx, n7);
            int n18 = gameRule.getDefenceBaseIntelforce(this._curRoleInx, n8);
            int n19 = gameRule.getDefenceBaseIntelforce(this._curRoleInx, n9);
            stringBuffer.delete(0, stringBuffer.length());
            if (Function.getCurScenario() > 50 && this.getRoleName().equals(GameParameter.ROLENAME_JINGHUA)) {
                stringBuffer.append(GameParameter.ROLENAME_SHUIYUE);
            } else {
                stringBuffer.append(this.getRoleName());
            }
            stringBuffer.append(GameParameter.SHENGJI);
            int n20 = 0;
            stringArray[n][n20] = stringBuffer.toString();
            stringArray[n][++n20] = "" + n2;
            stringArray[n][++n20] = "" + n4;
            stringArray[n][++n20] = "" + n6;
            stringArray[n][++n20] = "" + n8;
            stringArray[n][++n20] = "" + n3;
            stringArray[n][++n20] = "" + n5;
            stringArray[n][++n20] = "" + n7;
            stringArray[n][++n20] = "" + n9;
            GameDB gameDB = GameDB.getGameDataBase();
            Hashtable hashtable = gameDB.getSkillData();
            int n21 = 1;
            while (n21 < hashtable.size() + 1) {
                DataSkill dataSkill = (DataSkill)hashtable.get(new Integer(n21));
                if (dataSkill != null && this._curRoleInx == dataSkill.getRoleInx() && dataSkill.getLevelGet() == n3) {
                    stringArray[n][++n20] = GameParameter.XUEHUI + dataSkill.getName();
                    this.updateSkillIndex();
                }
                ++n21;
            }
            stringArray2[n] = new String[n20 + 1];
            System.arraycopy(stringArray[n], 0, stringArray2[n], 0, n20 + 1);
            ++n;
        }
        return stringArray2;
    }

    public final int[] getOrificeInx() {
        return this._orificeInx;
    }

    public final int[] getEquipInx() {
        return this._equipInx;
    }

    private final void addOffsetAttribute(int n, int n2) {
        GameDB gameDB = GameDB.getGameDataBase();
        int n3 = 0;
        while (n3 < this._equipInx.length) {
            DataEquip dataEquip = gameDB.getEquipData(this._equipInx[n3]);
            if (dataEquip != null) {
                int[] nArray = dataEquip.getOffSetAttribute();
                this.addAttribute(nArray, n, n2);
            }
            ++n3;
        }
    }

    public final void addAttribute(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        int n3 = n;
        while (n3 <= n2) {
            int n4 = n3;
            this._info[n4] = this._info[n4] + nArray[n3];
            ++n3;
        }
    }

    public final void getOutEquip(int n) {
        int n2 = this._equipInx[n];
        this._equipInx[n] = 0;
        if (n2 != 0) {
            RoleTeamData roleTeamData = RoleTeamData.getInstance();
            roleTeamData.increaseEquip(n2);
        }
        this.setInfoInvalidFlag();
    }

    public final void getIntoEquip(int n, int n2) {
        int n3 = this._equipInx[n];
        this._equipInx[n] = n2;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.decreaseEquip(n2);
        if (n3 != 0) {
            roleTeamData.increaseEquip(n3);
        }
        this.setInfoInvalidFlag();
    }

    public final void setPosEquip(int n, int n2) {
        this._equipInx[n] = n2;
        this.setInfoInvalidFlag();
    }

    public final void getIntoOrifice(int n, int n2, int n3) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        this.setInfoInvalidFlag();
    }

    public final void useThing(int n) {
        GameDB gameDB = GameDB.getGameDataBase();
        DataThing dataThing = gameDB.getThingData(n);
        int[] nArray = this.getCurrentInfo();
        int n2 = dataThing.getEffectHP();
        int n3 = dataThing.getEffectMP();
        int n4 = dataThing.getEffectSP();
        n2 = n2 > 10 ? n2 : nArray[4] * n2 / 10;
        n3 = n3 > 10 ? n3 : nArray[6] * n3 / 10;
        this._hp = Math.min(nArray[4], this._hp + n2);
        this._mp = Math.min(nArray[6], this._mp + n3);
        this._sp = Math.min(100, this._sp + n4);
        RoleTeamData.getInstance().decreaseThing(n);
    }

    public final void adjustForAttribute() {
        int[] nArray = this.getCurrentInfo();
        this._hp = Math.min(nArray[4], this._hp);
        this._mp = Math.min(nArray[6], this._mp);
    }

    public final int getCurLevelEquip(int n, int n2) {
        GameDB gameDB = GameDB.getGameDataBase();
        DataEquip dataEquip = null;
        int n3 = gameDB.getEquipData().size();
        int n4 = 38;
        while (n4 > 0) {
            dataEquip = gameDB.getEquipData(n4);
            if (dataEquip != null && dataEquip.getKind() == n2 && dataEquip.getMinLevel() <= n) break;
            --n4;
        }
        if (dataEquip != null) {
            return n4;
        }
        return -1;
    }

    public static final GameRoleData produceRoleData(int n) {
        GameRoleData gameRoleData = new GameRoleData();
        gameRoleData.init(n);
        return gameRoleData;
    }

    public final void addThreeLevel(int n) {
        this.addLevee(n);
    }

    private final void addLevee(int n) {
        this._lostLevel = this._level;
        int n2 = 60;
        if (this._level == n2) {
            return;
        }
        if (this._level < 60) {
            this._level += n;
            if (this._level >= 60) {
                this._level = 60;
            }
            this.resetData();
        }
        this.produceVictoryInfo();
    }

    private final void init(int n) {
        this._curRoleInx = n;
        GameDB gameDB = GameDB.getGameDataBase();
        this._dataRole = gameDB.getRoleData(n);
        this._level = n == 0 ? 0 : 1;
        this._specialSkill = new Hashtable(10);
        this._equipInx = new int[6];
        this._orificeInx = new int[7];
        this.updateSkillIndex();
    }

    private GameRoleData() {
    }

    public final void save(DataOutputStream dataOutputStream) {
        try {
            GameDB gameDB = GameDB.getGameDataBase();
            RoleTeamData roleTeamData = RoleTeamData.getInstance();
            dataOutputStream.writeInt(this._level);
            dataOutputStream.writeInt(this._hp);
            dataOutputStream.writeInt(this._mp);
            dataOutputStream.writeInt(this._sp);
            dataOutputStream.writeInt(this._experience);
            int n = this._specialSkill.size();
            dataOutputStream.writeByte(n);
            Enumeration enumeration = this._specialSkill.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                dataOutputStream.writeByte(n2.byteValue());
            }
            n = this._equipInx.length;
            int n3 = 0;
            while (n3 < n) {
                dataOutputStream.writeInt(this._equipInx[n3]);
                ++n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void load(DataInputStream dataInputStream) {
        try {
            GameDB gameDB = GameDB.getGameDataBase();
            RoleTeamData roleTeamData = RoleTeamData.getInstance();
            this._level = dataInputStream.readInt();
            this._hp = dataInputStream.readInt();
            this._mp = dataInputStream.readInt();
            this._sp = dataInputStream.readInt();
            this._experience = dataInputStream.readInt();
            this.resetSpecialSkillIndex();
            int n = dataInputStream.readByte();
            int n2 = 0;
            while (n2 < n) {
                byte by = dataInputStream.readByte();
                this._specialSkill.put(new Integer(by), new Integer(0));
                ++n2;
            }
            this.updateSkillIndex();
            n = this._equipInx.length;
            int n3 = 0;
            while (n3 < n) {
                this._equipInx[n3] = dataInputStream.readInt();
                ++n3;
            }
            this.setInfoInvalidFlag();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void resetHp() {
        int[] nArray = this.getCurrentInfo();
        this._hp = nArray[4];
    }

    public void resetMp() {
        int[] nArray = this.getCurrentInfo();
        this._mp = nArray[6];
    }

    public final void reset() {
        this._level = 0;
        this._experience = 0;
        int n = this._equipInx.length;
        int n2 = 0;
        while (n2 < n) {
            this._equipInx[n2] = 0;
            ++n2;
        }
        this.resetSpecialSkillIndex();
        this.resetData();
    }
}

