/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.GameDB;
import com.sinaflying.engine.Animation;
import com.sinaflying.engine.GameMIDlet;
import com.sinaflying.engine.SptSet;
import com.sinaflying.game.Actor;
import com.sinaflying.game.BattleScene;
import com.sinaflying.game.DataInfo;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.game.SceneInfo;
import com.sinaflying.game.ScriptDriver;
import com.sinaflying.game.SmsUi;
import com.sinaflying.game.WorldScene;
import com.sinaflying.gameUtil.MessageBox;
import com.sinaflying.gameUtil.MessageBoxHandler;
import com.sinaflying.other.BuyClothGoods;
import com.sinaflying.other.BuyComposeGoods;
import com.sinaflying.other.BuyEquipGoods;
import com.sinaflying.other.BuyMaterialGoods;
import com.sinaflying.other.BuyThingGoods;
import com.sinaflying.other.GameInfo;
import com.sinaflying.other.Goods;
import com.sinaflying.other.SellEquipGoods;
import com.sinaflying.other.SellMaterialGoods;
import com.sinaflying.other.SellThingGoods;
import com.sinaflying.other.Shop;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class GameMainLogic
extends Canvas
implements MessageBoxHandler {
    public static final int STATE_INTERFACE = 0;
    public static final int STATE_WORLD_SCENE = 1;
    public static final int STATE_BATTLE_SCENE = 2;
    public static final int STATE_GAME_INFO_PANEL = 3;
    public static final int STATE_SHOP = 4;
    public static final int STATE_EXCEPTION = 5;
    public static final int STATE_STOP = 6;
    public int _state;
    public int _lastState;
    private static Scene _worldScene;
    private static GameInterface _interface;
    private static BattleScene _battleScene;
    private static GameInfo _infoPanel;
    private static Shop _shop;
    public static int timeHour;
    public static int timeMinute;
    public static int _enterSceneId;
    public static int _exitSceneId;
    public static SceneInfo _sceneInfo;
    private boolean _painting;
    public GameMIDlet _midlet;
    private static GameMainLogic _inst;
    private static Graphics _gh;
    private int _ticks;
    private Font _font;
    public int _hight;
    public int _weight;
    private String _Exstr;
    public int _preState;
    private int _level;
    public int _loadProcess;
    public int _loadWordProcess;
    public static final int LOAD_LEVEL_INIT = 0;
    public static final int LOAD_LEVEL_PRODUCE_SCENE = 1;
    public static final int LOAD_LEVEL_STARTUP = 2;
    public static final int LOAD_MAZE_SCENE = 3;
    private String[] _sceneTip;
    private String _sceneName;
    private int _pigMidPoint;
    private int _progressBarStartX;
    private int _progressBarStartEndX;
    private int _progressBarY;
    private int _progressBar;
    private int _barLength;
    private static final int PROGRESS_BAR_OFFSET_X = 0;
    private static final int[] LOAD_BAR_WORD_SPT_ID;
    private static int _wordColor;
    private int _loadBarWordStartX;
    private int _loadBarWordStartY;
    private int _loadBarWordSpace;
    private int _curWordIndex;
    public static int _curMazeId;
    public static int TEST;
    private boolean _continue;
    public boolean _isGameOver;
    public static final int KEY_RELEASED = Integer.MIN_VALUE;
    public static final int KEY_LEFT_UP = 0;
    public static final int KEY_UP = 1;
    public static final int KEY_RIGHT_UP = 2;
    public static final int KEY_LEFT = 3;
    public static final int KEY_A = 4;
    public static final int KEY_RIGHT = 5;
    public static final int KEY_LEFT_DOWN = 6;
    public static final int KEY_DOWN = 7;
    public static final int KEY_RIGHT_DOWN = 8;
    public static final int KEY_NONE = 16;
    public static final int KEY_CANCEL = 32;
    public static final int KEY_BEAT_MOUSE = 64;
    public static final int KEY_SOFT_LEFT = 65536;
    public static final int KEY_SOFT_RIGHT = 131072;
    private int _curKey;
    private static final int C_HANDSET_KIND_NOKIA = 0;
    private static final int C_HANDSET_KIND_MOTO = 1;
    private static final int C_HANDSET_KIND_SE = 2;
    private static final int C_HANDSET_KIND_SAMSUNG = 3;
    private static final int C_HANDSET_KIND_MOTO_E2 = 4;
    private static final int C_HANDSET_KIND_MOTO_K1 = 5;
    private static final int C_HANDSET_KIND_NOKIA_E62 = 6;
    public static final int C_SCREEN_W = 320;
    public static final int C_SCREEN_H = 240;
    private static final int C_CURRENT_HAND_SET_KIND = 6;
    public static final int C_JAR_SIZE_BIG = 0;
    public static final int C_JAR_SIZE_SMALL = 1;
    public static final int C_JAR_SIZE_MIN = 2;
    public static final int C_JAR_SIZE = 0;
    public static final int C_SOFT_POS_LEFT = 0;
    public static final int C_SOFT_POS_RIGHT = 1;
    private boolean _isShowTouch;
    private static int[] C_TOUCH_KEY;
    private static final int C_TOUCH_KEY_W = 20;
    private static final int C_TOUCH_KEY_H = 20;
    private static final int SOFT_KEY_W = 20;
    private long _gameStartTime;
    private long _gamePlayTime;
    private static int[][] _playSoundSceneId;
    public static final int GAME_FEE = 333;
    public static final int GAME_FEE_SHOP = 444;
    public SmsUi _smsui = new SmsUi(this);
    public static boolean isFly;
    public static int drawType;
    private int _curKeyBuffer;
    private static final String SpecialInfo1 = "0\u952e \u5546\u5e97";
    private static final int w;
    private static final int h;
    boolean _messForFly = false;
    private MessageBox _messageBox;
    int ticks;
    static boolean huoDeYinLuFeng;

    private GameMainLogic(GameMIDlet gameMIDlet) {
        this.setFullScreenMode(true);
        this._midlet = gameMIDlet;
        this._painting = false;
        this._continue = false;
        this._isShowTouch = false;
        this._font = Function.C_GAME_FONT;
        this._hight = this._font.getHeight();
        this._weight = this._font.substringWidth("\u725b", 0, 1) + 2;
        this.produceSceneInfo();
        System.out.println("This is a Nokia!");
    }

    public static final GameMainLogic produceGameMainLogic(GameMIDlet gameMIDlet) {
        _inst = new GameMainLogic(gameMIDlet);
        _interface = new GameInterface(_inst);
        _battleScene = BattleScene.getBattleInstance();
        GameMainLogic._inst._state = 0;
        return _inst;
    }

    public static GameMainLogic getInstance() {
        return _inst;
    }

    public static Graphics getGraphics() {
        return _gh;
    }

    public static GameInterface getInterface() {
        return _interface;
    }

    public static Scene getWorldScene() {
        return _worldScene;
    }

    public static int getEnterSceneId() {
        return _enterSceneId;
    }

    public static int getExitSceneId() {
        return _exitSceneId;
    }

    public final int getTicks() {
        return this._ticks;
    }

    public final Font getCurrentFont() {
        return this._font;
    }

    public final void setShowTouch() {
        this._isShowTouch = true;
    }

    public final void paint(Graphics graphics) {
        this._painting = true;
        ++this._ticks;
        graphics.setFont(this._font);
        _gh = graphics;
        switch (this._state) {
            case 333: {
                this._smsui.draw(graphics, drawType);
                break;
            }
            case 444: {
                this._smsui.drawShop(graphics);
                this._smsui.updateShop();
                break;
            }
            case 0: {
                _interface.paint(graphics);
                break;
            }
            case 1: {
                _worldScene.update();
                _worldScene.paint(graphics);
                this.isGameOverHandle();
                this.keyToShopAndFly(graphics);
                break;
            }
            case 2: {
                _battleScene.paint(graphics);
                break;
            }
            case 3: {
                this.infoPanelPreDraw();
                if (_infoPanel == null) {
                    return;
                }
                _infoPanel.draw(graphics);
                break;
            }
            case 4: {
                _shop.draw(graphics);
                break;
            }
            case 6: {
                this.drawStopFrame(graphics);
                break;
            }
            case 5: {
                this.drawException(graphics);
            }
        }
        if (this._messageBox != null) {
            this._messageBox.draw(graphics);
        }
        this._painting = false;
    }

    private void initException(Exception exception) {
        this._Exstr = exception.toString() + "_state:" + this._state;
        this._state = 5;
    }

    private void drawException(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0xFF0000);
        Function.drawString(graphics, this._Exstr, 10, 10, 0x10 | 4);
    }

    private void drawGameSound(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0xFF0000);
        Function.drawString(graphics, Function._sound == null ? "Null" : Function._sound.toString(), 10, 10, 0x10 | 4);
    }

    public void changeToStopFrame() {
        if (this._state != 6) {
            switch (drawType) {
                case 0: {
                    break;
                }
                default: {
                    this._lastState = this._state;
                    this._state = 6;
                }
            }
        }
    }

    private void drawStopFrame(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        Function.draw3DString(graphics, GameParameter.STOPGAME, 160, 120, 0x10 | 1, 11878689, 0xFFFFFF);
        Function.draw3DString(graphics, GameParameter.BACKGAME, 310, 232, 8 | 0x20, 0, 16771377);
        boolean bl = false;
        if (this.isPressCancelKey()) {
            bl = true;
        }
        if (bl) {
            this.resetCurKey();
            this.backGameState();
        }
    }

    public void backGameState() {
        this._state = this._lastState;
        switch (this._state) {
            case 3: {
                _infoPanel.openOnceDrawBK();
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                GameMainLogic.getBattleScene().openOnceDrawBK();
            }
        }
        Function.continuePlaySound();
    }

    public final void changeToBattle(int n, int n2, boolean bl) {
        _battleScene.startup(n, n2, bl);
        this.changeState(2);
    }

    public final void changeToWorldScene() {
        _worldScene.reset();
        this.changeState(1);
    }

    public final void changeToInfoPanel() {
        _infoPanel = GameInfo.getInstance();
        this.changeState(3);
    }

    public final void changeToMission() {
        _infoPanel = GameInfo.getInstance();
        _infoPanel.changeInterface(6);
    }

    public final void infoPanelPreDraw() {
        if (_infoPanel == null) {
            this.changeToWorldScene();
            return;
        }
        if (_infoPanel.drawSceneInfo()) {
            _worldScene.paint(_gh);
        }
    }

    public final void changeToShop(int n, int n2) {
        Goods goods = n2 == 0 ? (n == 0 ? new BuyThingGoods() : (n == 1 ? new BuyClothGoods() : (n == 2 ? new BuyEquipGoods() : (n == 3 ? new BuyMaterialGoods() : new BuyComposeGoods())))) : (n == 0 ? new SellThingGoods() : (n == 2 ? new SellEquipGoods() : (n == 1 ? new SellEquipGoods() : new SellMaterialGoods())));
        _shop = new Shop(goods);
        _shop.setShopTitle(n);
        this.changeState(4);
    }

    public final void changeToInterface(int n) {
        this._preState = this._state;
        _interface.changeState(n);
        if (n == 10) {
            _interface.initGameHelp();
        } else if (n == 11) {
            _interface.initGameAbout();
        } else if (n == 8) {
            Function.stopSound();
        } else if (n == 24) {
            _interface.initSound();
        } else if (n == 25) {
            if (this._preState == 0) {
                _interface.initGameLoad();
            } else {
                _interface.initGameSave();
            }
        }
        this.changeState(0);
    }

    private final void changeState(int n) {
        this._preState = this._state;
        this._state = n;
        this.resetCurKey();
    }

    public final void recoverPreState() {
        _infoPanel = null;
        _shop = null;
        switch (this._preState) {
            case 1: {
                this.changeToWorldScene();
                break;
            }
            case 2: {
                this.changeState(2);
                break;
            }
        }
    }

    public static Scene getScene() {
        return _worldScene;
    }

    public static BattleScene getBattleScene() {
        return _battleScene;
    }

    public void loadGlobalData() {
        GameParameter.loadPlaceName();
        GameDB.loadDataBase();
        this.loadGlobalAnimation();
        RoleTeamData.getInstance();
        this.startRecordGameTime();
        Function.loadSound(GameParameter.SOUND_PATH);
        Function.loadGameGlobalSpt();
    }

    public final void loadGlobalAnimation() {
        int n = 0;
        while (n < GameParameter.C_GOBAL_ANI.length) {
            Animation.load(GameParameter.C_GOBAL_ANI[n], 1);
            ++n;
        }
        int n2 = 0;
        while (n2 < GameParameter.C_GOBAL_SPT.length) {
            SptSet.load(GameParameter.C_GOBAL_SPT[n2], 1);
            ++n2;
        }
    }

    public final void exitGame() {
        Function.stopSound();
        this._midlet.destroyApp(false);
    }

    public final void drawLoadProcess(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(13345794);
        Function.drawString(graphics, this._sceneName, 160, this._hight * 2, 1 | 0x10);
        Function.drawString(graphics, "\u5c0f\u63d0\u793a\uff1a", this._weight, this._hight * 3, 4 | 0x10);
        int n = 0;
        while (n < this._sceneTip.length) {
            Function.drawString(graphics, this._sceneTip[n], this._weight * 5 - 8, this._hight * 3 + n * this._hight, 4 | 0x10);
            ++n;
        }
        this.upDateLoadPrecoss();
        this.drawLoadPrecoss(graphics);
    }

    private void upDateLoadPrecoss() {
        this._progressBar += 2;
        if (this._progressBar >= 100) {
            this._progressBar = 100;
        }
        this._loadProcess = this._progressBar;
        this._progressBarStartX = this._weight + this._barLength * this._progressBar / 100 + Function._spt_125.getSptWidth(7) - 0;
        this._curWordIndex = this._progressBar / 21;
        _wordColor = 100 - this._progressBar % 21 * 5;
        Function.initAlphaArray(0, _wordColor);
        this._pigMidPoint = this._progressBarStartX;
    }

    private void drawLoadPrecoss(Graphics graphics) {
        int n = 7;
        int n2 = this._weight + Function._spt_125.getSptWidth(0);
        int n3 = 320 - n2;
        Function._spt_125.draw(graphics, this._weight, this._progressBarY, 0);
        Function._spt_125.draw(graphics, 320 - this._weight + Function._spt_125.getSptWidth(0), this._progressBarY, Integer.MIN_VALUE, 8 | 0x10);
        if (this._pigMidPoint < this._barLength + this._weight + Function._spt_125.getSptWidth(7) - 0) {
            Function._spt_125.draw(graphics, 320 - this._weight + Function._spt_125.getSptWidth(n), this._progressBarY, n | Integer.MIN_VALUE, 8 | 0x10);
            Function._spt_125.draw(graphics, 320 - this._weight - Function._spt_125.getSptWidth(n) + Function._spt_125.getSptWidth(8), this._progressBarY, -2147483640, 8 | 0x10);
        }
        int n4 = 0;
        while (n4 <= this._curWordIndex) {
            Function._spt_125.draw(graphics, this._loadBarWordStartX + n4 * this._loadBarWordSpace, this._loadBarWordStartY, LOAD_BAR_WORD_SPT_ID[n4]);
            if (n4 == this._curWordIndex) {
                Function.drawAlpha(graphics, this._loadBarWordStartX + this._curWordIndex * this._loadBarWordSpace, this._loadBarWordStartY, this._loadBarWordSpace, this._loadBarWordSpace);
            }
            ++n4;
        }
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(2547966);
        graphics.drawLine(n2, this._progressBarY, n3, this._progressBarY);
        graphics.drawLine(n2, this._progressBarY + 11, n3, this._progressBarY + 11);
        graphics.setColor(935492);
        graphics.drawLine(n2, this._progressBarY + 1, n3, this._progressBarY + 1);
        graphics.drawLine(n2, this._progressBarY + 10, n3, this._progressBarY + 10);
        n2 = this._weight + Function._spt_125.getSptWidth(n) - 0;
        graphics.setColor(11697986);
        graphics.drawLine(n2, this._progressBarY + 2, this._pigMidPoint, this._progressBarY + 2);
        graphics.setColor(16771734);
        graphics.drawLine(n2, this._progressBarY + 3, this._pigMidPoint, this._progressBarY + 3);
        graphics.setColor(16771734);
        graphics.drawLine(n2, this._progressBarY + 4, this._pigMidPoint, this._progressBarY + 4);
        graphics.setColor(15649358);
        graphics.drawLine(n2, this._progressBarY + 5, this._pigMidPoint, this._progressBarY + 5);
        graphics.setColor(15649358);
        graphics.drawLine(n2, this._progressBarY + 6, this._pigMidPoint, this._progressBarY + 6);
        graphics.setColor(15649358);
        graphics.drawLine(n2, this._progressBarY + 7, this._pigMidPoint, this._progressBarY + 7);
        graphics.setColor(16771734);
        graphics.drawLine(n2, this._progressBarY + 8, this._pigMidPoint, this._progressBarY + 8);
        graphics.setColor(16752966);
        graphics.drawLine(n2, this._progressBarY + 9, this._pigMidPoint, this._progressBarY + 9);
    }

    public String sceneName(int n) {
        if (n >= 0 && n < GameParameter._sceneNames.length) {
            return GameParameter._sceneNames[n];
        }
        if (n >= 90 && n <= 97) {
            switch (n) {
                case 90: {
                    return GameParameter.YUHANG;
                }
                case 91: {
                    return GameParameter.YUZHOU;
                }
                case 92: {
                    return GameParameter.FENGDU;
                }
                case 95: {
                    return GameParameter.SHANGDAO;
                }
                case 96: {
                    return "";
                }
            }
        }
        return "\u672a\u77e5\u7684\u5f02\u754c";
    }

    public void initLoadLevelUi() {
        int n = RoleTeamData.getInstance().getNextSceneId();
        this._sceneName = this.sceneName(n);
        this._sceneTip = Function.subString(GameParameter._sceneTips[Function.Random(GameParameter._sceneTips.length, true)], (320 - Function.C_WORD_W * 4 - 2 * this._weight) / Function.C_WORD_W);
        this._progressBarStartX = this._weight + Function._spt_125.getSptWidth(7) - 0;
        this._progressBarStartEndX = 320 - this._weight - Function._spt_125.getSptWidth(7) + 0;
        this._progressBarY = 240 - this._hight * 2;
        this._barLength = this._progressBarStartEndX - this._progressBarStartX;
        this._loadBarWordSpace = 42;
        this._loadBarWordStartX = 320 - this._loadBarWordSpace * 5 >> 1;
        this._loadBarWordStartY = this._progressBarY - 50;
        this._curWordIndex = 0;
        _wordColor = 0;
        this._progressBar = 0;
    }

    public void setScenTip(Graphics graphics) {
    }

    public final boolean loadLevelData00(Graphics graphics) {
        switch (this._loadWordProcess) {
            case 0: {
                this._level = RoleTeamData.getInstance().getNextSceneId();
                Scene.produceProcess = 0;
                if (this._continue) {
                    ScriptDriver scriptDriver = ScriptDriver.getInstance();
                    scriptDriver.dispose();
                    _worldScene.dispose();
                    _battleScene.clear();
                    this._loadWordProcess = 1;
                    break;
                }
                this._loadWordProcess = 1;
                break;
            }
            case 1: {
                if (this._level == 50) {
                    _enterSceneId = 50;
                    _exitSceneId = 51;
                    return this.loadMaze(39, 51);
                }
                if (this._level == 75 || this._level == 77) {
                    _enterSceneId = 75;
                    _exitSceneId = 77;
                    return this.loadMaze(75, 77);
                }
                if (!WorldScene.produceWorldScene(this, this._level)) break;
                _worldScene = WorldScene.getWorldInstance();
                this.startUp();
                _worldScene.update();
                _worldScene.paint(graphics);
                GameInfo.getInstance();
                this._loadWordProcess = 2;
                break;
            }
            case 3: {
                if (this._level == _enterSceneId || this._level == _exitSceneId) {
                    _worldScene = (Scene)GameRule.getMScene(_enterSceneId);
                    this.startUp();
                    GameInfo.getInstance();
                }
                this._loadWordProcess = 2;
                break;
            }
            case 2: {
                if (this._loadProcess >= 100) {
                    this.changeToWorldScene();
                    _worldScene.initStatePlaying();
                    this._loadWordProcess = 0;
                    Function.changeSoundState(3, -1);
                    this.resetCurKey();
                } else {
                    _worldScene.update();
                    _worldScene.paint(graphics);
                }
                return true;
            }
        }
        return false;
    }

    public boolean loadMaze(int n, int n2) {
        if (_curMazeId < n) {
            _curMazeId = n;
        }
        if (_curMazeId <= n2 && GameRule.produceMazeScene(this, _curMazeId)) {
            ++_curMazeId;
        }
        if (_curMazeId > n2 && this._loadProcess >= 100) {
            _curMazeId = 0;
            this._loadWordProcess = 3;
            return true;
        }
        return false;
    }

    public void isGameOverHandle() {
        if (this._isGameOver) {
            this.changeToInterface(8);
        }
    }

    private final void startUp() {
        _worldScene.startup();
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.startUp();
        _worldScene.startUpCamera();
        this._continue = true;
    }

    public void notifyHide() {
        Function.stopSound();
    }

    public void notifyShow() {
    }

    public void hideNotify() {
        this.notifyHide();
        this.changeToStopFrame();
    }

    public void showNotify() {
        this.notifyShow();
    }

    public final boolean paintable() {
        return !this._painting;
    }

    protected final void keyPressed(int n) {
        this._curKey = this.getTranslateKeyCode(n);
        if (this._curKey == 64) {
            this._curKeyBuffer = 64;
        }
    }

    protected final void keyReleased(int n) {
        this._curKey = 16;
    }

    public final int getCurKey() {
        return this._curKey;
    }

    public final void resetCurKey() {
        this._curKey = 16;
    }

    private final int getTranslateKeyCode(int n) {
        switch (6) {
            case 0: 
            case 2: 
            case 3: {
                return this.translateKeyCodeForNokia(n);
            }
            case 1: 
            case 5: {
                return this.translateKeyCodeForMoto(n);
            }
            case 4: {
                return this.translateKeyCodeForE2(n);
            }
            case 6: {
                return this.translateKeyCodeForE62(n);
            }
        }
        return 0;
    }

    private final int translateKeyCodeForNokia(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 1;
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                n2 = 7;
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                n2 = 3;
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                n2 = 5;
                break;
            }
            case -5: 
            case 53: {
                n2 = 4;
                break;
            }
            case 49: {
                n2 = 0;
                break;
            }
            case 51: {
                n2 = 2;
                break;
            }
            case 55: {
                n2 = 6;
                break;
            }
            case 57: {
                n2 = 8;
                break;
            }
            case 35: {
                n2 = 32;
                break;
            }
            case 42: {
                n2 = 64;
                break;
            }
            case -6: {
                n2 = 65536;
                break;
            }
            case -7: {
                n2 = 131072;
                break;
            }
            case 48: {
                n2 = 48;
            }
        }
        return n2;
    }

    private final int translateKeyCodeForMoto(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 1;
                break;
            }
            case -6: 
            case 6: 
            case 56: {
                n2 = 7;
                break;
            }
            case -2: 
            case 2: 
            case 52: {
                n2 = 3;
                break;
            }
            case -5: 
            case 5: 
            case 54: {
                n2 = 5;
                break;
            }
            case -20: 
            case 20: 
            case 53: {
                n2 = 4;
                break;
            }
            case 49: {
                n2 = 0;
                break;
            }
            case 51: {
                n2 = 2;
                break;
            }
            case 55: {
                n2 = 6;
                break;
            }
            case 57: {
                n2 = 8;
                break;
            }
            case 35: {
                n2 = 32;
                break;
            }
            case 42: {
                n2 = 64;
                break;
            }
            case -21: 
            case 21: {
                n2 = 65536;
                break;
            }
            case -22: 
            case 22: {
                n2 = 131072;
                break;
            }
            case 48: {
                n2 = 48;
            }
        }
        return n2;
    }

    private final int translateKeyCodeForE2(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 1: 
            case 50: {
                n2 = 1;
                break;
            }
            case -2: 
            case 6: 
            case 56: {
                n2 = 7;
                break;
            }
            case -3: 
            case 2: 
            case 52: {
                n2 = 3;
                break;
            }
            case -4: 
            case 5: 
            case 54: {
                n2 = 5;
                break;
            }
            case -5: 
            case 20: 
            case 53: {
                n2 = 4;
                break;
            }
            case 49: {
                n2 = 0;
                break;
            }
            case 51: {
                n2 = 2;
                break;
            }
            case 55: {
                n2 = 6;
                break;
            }
            case 57: {
                n2 = 8;
                break;
            }
            case 35: {
                n2 = 32;
                break;
            }
            case 42: {
                n2 = 64;
                break;
            }
            case -21: 
            case -6: 
            case 21: {
                n2 = 65536;
                break;
            }
            case -22: 
            case -8: 
            case -7: 
            case 22: {
                n2 = 131072;
                break;
            }
            case 48: {
                n2 = 48;
            }
        }
        return n2;
    }

    private final int translateKeyCodeForE62(int n) {
        int n2 = 0;
        switch (n) {
            case -1: 
            case 116: {
                n2 = 1;
                break;
            }
            case -2: 
            case 98: {
                n2 = 7;
                break;
            }
            case -3: 
            case 102: {
                n2 = 3;
                break;
            }
            case -4: 
            case 104: {
                n2 = 5;
                break;
            }
            case -5: 
            case 103: {
                n2 = 4;
                break;
            }
            case 109: {
                n2 = 48;
                break;
            }
            case 114: {
                n2 = 0;
                break;
            }
            case 121: {
                n2 = 2;
                break;
            }
            case 118: {
                n2 = 6;
                break;
            }
            case 110: {
                n2 = 8;
                break;
            }
            case 106: {
                n2 = 32;
                break;
            }
            case 117: {
                n2 = 64;
                break;
            }
            case -6: {
                n2 = 65536;
                break;
            }
            case -7: {
                n2 = 131072;
                break;
            }
            default: {
                n2 = 16;
            }
        }
        return n2;
    }

    public final boolean isPressCallMenuKey() {
        switch (6) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return this._curKey == 65536;
            }
            case 2: 
            case 3: {
                return this._curKey == 131072;
            }
        }
        return false;
    }

    public final boolean isPressCallAttributeKey() {
        switch (6) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return this._curKey == 131072;
            }
            case 2: 
            case 3: {
                return this._curKey == 65536;
            }
        }
        return false;
    }

    public final boolean isPressConfirmKey() {
        return this.isPressFireKey() || this.isPressConfirmSoftKey();
    }

    public final boolean isPressCancelKey() {
        return this.isPressCancelSoftKey();
    }

    public boolean isPressCancelSoftKey() {
        switch (6) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this._curKey == 131072;
            }
            case 1: {
                return this._curKey == 65536;
            }
        }
        return false;
    }

    public final boolean isPressFireKey() {
        return this._curKey == 4;
    }

    public final boolean isPressConfirmSoftKey() {
        switch (6) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this._curKey == 65536;
            }
            case 1: {
                return this._curKey == 131072;
            }
        }
        return false;
    }

    public final boolean isPressGameStopKey() {
        switch (6) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this._curKey == 64;
            }
            case 1: {
                return this._curKey == 64;
            }
        }
        return false;
    }

    public final boolean isPressNextPageKey() {
        return this._curKey == 32;
    }

    public final boolean isPressPrePageKey() {
        return this._curKey == 64;
    }

    public final int getConfirmPos() {
        switch (6) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    public final int getCancelPos() {
        switch (6) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 0;
    }

    public final int getCallMenuPos() {
        switch (6) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public final int getCallAttributePos() {
        switch (6) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return 1;
            }
            case 2: 
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    private final void initTouchScreen() {
    }

    private final void paintTouchKey(Graphics graphics) {
    }

    protected void pointerPressed(int n, int n2) {
    }

    protected void pointerReleased(int n, int n2) {
    }

    public void startRecordGameTime() {
        this._gameStartTime = System.currentTimeMillis() / 1000L;
    }

    public void resetGamePlayingTime() {
        this._gameStartTime = 0L;
        this._gamePlayTime = 0L;
    }

    public void gameplayingTime() {
        ++this._gameStartTime;
    }

    public void countPlayGameTime() {
        this._gamePlayTime += System.currentTimeMillis() / 1000L - this._gameStartTime;
        this.startRecordGameTime();
    }

    public byte[] returnTimeArray() {
        byte[] byArray = new byte[]{0, 0};
        this.countPlayGameTime();
        byArray[0] = (byte)(this._gamePlayTime / 60L / 60L);
        byArray[1] = (byte)(this._gamePlayTime / 60L % 60L);
        return byArray;
    }

    public void setContinueGameTime(int[] nArray) {
        this._gamePlayTime = (nArray[0] * 60 + nArray[1]) * 60;
        this.startRecordGameTime();
    }

    protected void produceSceneInfo() {
        _sceneInfo = new SceneInfo();
    }

    protected void clearSceneInfo() {
        _sceneInfo = null;
    }

    protected void recordSceneDataInfo(int n, int n2) {
        DataInfo dataInfo = (DataInfo)_sceneInfo.getSceneInfo(GameMainLogic._worldScene._id);
        if (dataInfo == null) {
            dataInfo = new DataInfo();
        }
        dataInfo.addDataInfo(n, n2);
        _sceneInfo.addDataInfo(GameMainLogic._worldScene._id, dataInfo);
    }

    protected boolean checkInfoExist(int n, int n2) {
        DataInfo dataInfo = (DataInfo)_sceneInfo.getSceneInfo(n);
        if (dataInfo != null) {
            return dataInfo.getDataInfo(n2) != null;
        }
        return false;
    }

    public static int playSoundOfScene() {
        if (_worldScene == null) {
            return -1;
        }
        int n = 0;
        while (n < _playSoundSceneId.length) {
            int n2 = 0;
            while (n2 < _playSoundSceneId[n].length) {
                if (GameMainLogic._worldScene._id == _playSoundSceneId[n][n2]) {
                    return n + 1;
                }
                ++n2;
            }
            ++n;
        }
        return -1;
    }

    public boolean isBattleScene() {
        return this._state == 2;
    }

    public final int getCurKeyBuffer() {
        return this._curKeyBuffer;
    }

    public final void resetCurKeyBuffer() {
        this._curKeyBuffer = 16;
    }

    public void recoverToBattle() {
        this.changeState(2);
    }

    private void paintSpecialInfo(Graphics graphics) {
    }

    public boolean thisScenCanFly() {
        if (GameMainLogic._worldScene._id >= 5 && GameMainLogic._worldScene._id <= 14) {
            return true;
        }
        if (GameMainLogic._worldScene._id >= 17 && GameMainLogic._worldScene._id <= 23) {
            return true;
        }
        if (GameMainLogic._worldScene._id >= 26 && GameMainLogic._worldScene._id <= 53) {
            return true;
        }
        return GameMainLogic._worldScene._id >= 74 && GameMainLogic._worldScene._id <= 77;
    }

    public void keyToShopAndFly(Graphics graphics) {
        if (huoDeYinLuFeng) {
            ++this.ticks;
            Animation.getAnimation(111).draw(graphics, 160, 160, 5, 0, 0);
            graphics.setColor(0);
            graphics.setClip(0, 0, 240, 320);
            graphics.drawString("\u83b7\u5f97\u5f15\u8def\u8702", 160, 150, 17);
            if (this.ticks > 14) {
                huoDeYinLuFeng = false;
                this.ticks = 0;
            }
        }
        if (_worldScene.isCanDrawShop()) {
            this.paintSpecialInfo(graphics);
            if (this._messForFly) {
                ++this.ticks;
                Animation.getAnimation(111).draw(graphics, 160, 120, 5, 0, 0);
                graphics.setColor(0);
                graphics.setClip(0, 0, 240, 320);
                graphics.drawString("\u6b64\u5904\u4e0d\u80fd\u98de\u884c", 160, 114, 17);
                if (this.ticks > 10) {
                    this._messForFly = false;
                    this.ticks = 0;
                }
            }
            if ((64 == this.getCurKeyBuffer() || 57 == this.getCurKeyBuffer()) && SmsUi._isBuy[2] == 1) {
                if (this.thisScenCanFly()) {
                    if (isFly && GameMainLogic.getScene()._executeInsts != null) {
                        int n = 0;
                        while (n < GameMainLogic.getScene()._executeInsts.length) {
                            Actor actor = GameMainLogic._worldScene._executeInsts[n];
                            if (actor != null && (actor._type == 115 || actor._type == 116 || actor._type == 118) && actor.collide(GameMainLogic.getScene().getMainActor())) {
                                this._messageBox = MessageBox.getInstance(this);
                                this._messageBox.initSingleScrollStyle("\u6b64\u5904\u65e0\u6cd5\u964d\u843d", 10);
                                this.resetCurKeyBuffer();
                                return;
                            }
                            ++n;
                        }
                    }
                    isFly = !isFly;
                    GameInterface._paraValue[0] = isFly ? 2 : 0;
                    this.resetCurKeyBuffer();
                } else {
                    this._messForFly = true;
                    this.resetCurKeyBuffer();
                }
            }
        }
    }

    public void finishHandle(int n) {
        this._messageBox = null;
    }

    static {
        _enterSceneId = -1;
        _exitSceneId = -1;
        LOAD_BAR_WORD_SPT_ID = new int[]{17, 18, 19, 20, 21};
        _curMazeId = 0;
        TEST = 0;
        C_TOUCH_KEY = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        _playSoundSceneId = new int[][]{{96}, {1, 2, 3, 4, 15, 16, 24, 25, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73}, {5, 6, 7, 8, 9, 11, 12, 13, 14, 17, 18, 19, 21, 22, 23, 29, 30, 32, 33, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 95}, {26, 27, 28, 34, 35, 36, 37, 74, 75, 76, 77}, {0, 10, 20, 31, 38, 53}};
        drawType = 10;
        w = SpecialInfo1.length() * Function.C_WORD_W;
        h = Function.C_WORD_H + 2;
        huoDeYinLuFeng = false;
    }
}

