/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.engine;

import com.sinaflying.engine.SptSet;
import com.sinaflying.util.StreamReader;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Animation {
    public static final int C_FLIP_MASK = -268435456;
    public static final int C_FLIP_X = Integer.MIN_VALUE;
    public static final int C_FLIP_Y = 0x40000000;
    public static final int C_ACT_MASK = 65535;
    public static final int C_MAX_ANIM_NUM = 300;
    private static int[] _loaded;
    private static Animation[] _anims;
    private short _frmNum;
    private short[] _sptNum;
    private short[][] _tileId;
    private byte[][] _xoff;
    private byte[][] _yoff;
    private short _actNum;
    private short[] _actFrmNum;
    private short[][] _actFrmId;
    public static final int C_BOX_NUM = 4;
    public static final int C_BOX_LEFT = 0;
    public static final int C_BOX_RIGHT = 1;
    public static final int C_BOX_TOP = 2;
    public static final int C_BOX_BOTTOM = 3;
    public byte[][] _collisionBox;
    public short[] _visibleBox = new short[4];
    private short _sptSetIdx;
    private SptSet _sptSet;
    public static final int ZOOM = 23000;
    int _id;

    private Animation() {
    }

    public final short getActionNum() {
        return this._actNum;
    }

    public final int getId() {
        return this._id;
    }

    public final SptSet getSptset() {
        return this._sptSet;
    }

    public final short getActFrmNum(int n) {
        return this._actFrmNum[n];
    }

    public final int getSkinNum() {
        return this._sptSet.getPaletteNum();
    }

    public final void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 & Integer.MIN_VALUE;
        int n7 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n8 = this._sptNum[s];
        short[][] sArray = this._tileId;
        byte[][] byArray = this._xoff;
        byte[][] byArray2 = this._yoff;
        SptSet sptSet = this._sptSet;
        int n9 = 0;
        while (n9 < n8) {
            int n10 = sArray[s][n9] & 0xFFFFFF;
            byte by = byArray[s][n9];
            if (n6 != 0) {
                by = -by;
            }
            byte by2 = byArray2[s][n9];
            if (n7 != 0) {
                by2 = -by2;
            }
            sptSet.draw(graphics, n + by, n2 + by2, n10 | n6 | n7, n5, 0);
            ++n9;
        }
    }

    public final void drawClip(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = n3 & Integer.MIN_VALUE;
        int n11 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n12 = this._sptNum[s];
        short[][] sArray = this._tileId;
        byte[][] byArray = this._xoff;
        byte[][] byArray2 = this._yoff;
        SptSet sptSet = this._sptSet;
        int n13 = 0;
        while (n13 < n12) {
            int n14 = sArray[s][n13] & 0xFFFFFF;
            byte by = byArray[s][n13];
            if (n10 != 0) {
                by = -by;
            }
            byte by2 = byArray2[s][n13];
            if (n11 != 0) {
                by2 = -by2;
            }
            sptSet.drawClipPart(graphics, n + by, n2 + by2, n14 | n10 | n11, n5, 0, n6, n7, n8, n9);
            ++n13;
        }
    }

    public final void drawShadow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 & Integer.MIN_VALUE;
        int n7 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n8 = this._sptNum[s];
        short[][] sArray = this._tileId;
        byte[][] byArray = this._xoff;
        byte[][] byArray2 = this._yoff;
        SptSet sptSet = this._sptSet;
        int n9 = 0;
        while (n9 < n8) {
            int n10 = sArray[s][n9] & 0xFFFFFF;
            byte by = byArray[s][n9];
            if (n6 != 0) {
                by = -by;
            }
            byte by2 = byArray2[s][n9];
            if (n7 != 0) {
                by2 = -by2;
            }
            sptSet.drawShadow(graphics, n + by, n2 + by2, n10 | n6 | n7, n5);
            ++n9;
        }
    }

    public void drawZoomEasy(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 & Integer.MIN_VALUE;
        int n8 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n9 = this._sptNum[s];
        int n10 = 0;
        while (n10 < n9) {
            int n11 = this._tileId[s][n10] & 0xFFFFFF;
            int n12 = this._xoff[s][n10];
            int n13 = 0;
            int n14 = 0;
            n13 = this._xoff[s][n10] * n6 * 100 / 23000;
            n14 = this._yoff[s][n10] * n6 * 100 / 23000;
            if (n7 != 0) {
                n12 = -n12;
                n13 = -n13;
            }
            n12 += n13;
            int n15 = this._yoff[s][n10];
            if (n8 != 0) {
                n15 = -n15;
            }
            this._sptSet.drawZoomByzoomeasy(graphics, n + n12, n2 + (n15 += n14), n11 | n7 | n8, n5, n6);
            ++n10;
        }
    }

    public void drawReduceEasy(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 & Integer.MIN_VALUE;
        int n8 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n9 = this._sptNum[s];
        int n10 = 0;
        while (n10 < n9) {
            int n11 = this._tileId[s][n10] & 0xFFFFFF;
            byte by = this._xoff[s][n10];
            if (n7 != 0) {
                by = -by;
            }
            byte by2 = this._yoff[s][n10];
            if (n8 != 0) {
                by2 = -by2;
            }
            this._sptSet.drawReduceByReduceeasy(graphics, n, n2, by, by2, n11 | n7 | n8, n5, n6);
            ++n10;
        }
    }

    public void drawZoom(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 & Integer.MIN_VALUE;
        int n8 = n3 & 0x40000000;
        short s = this._actFrmId[n3 &= 0xFFFF][n4];
        int n9 = this._sptNum[s];
        int n10 = 0;
        while (n10 < n9) {
            int n11 = this._tileId[s][n10] & 0xFFFFFF;
            int n12 = this._xoff[s][n10];
            int n13 = 0;
            int n14 = 0;
            n13 = this._xoff[s][n10] * n6 * 100 / 1000;
            n14 = this._yoff[s][n10] * n6 * 100 / 1000;
            if (n7 != 0) {
                n12 = -n12;
                n13 = -n13;
            }
            n12 += n13;
            int n15 = this._yoff[s][n10];
            if (n8 != 0) {
                n15 = -n15;
            }
            this._sptSet.drawZoomByzoom(graphics, n + n12, n2 + (n15 += n14), n11 | n7 | n8, n5, n6);
            ++n10;
        }
    }

    public static void resetLoadState() {
        int n = 0;
        while (n < _loaded.length) {
            if (_loaded[n] != 1) {
                Animation._loaded[n] = 0;
            }
            ++n;
        }
        SptSet.resetLoadState();
    }

    public static void disposeLocal() {
        int n = 0;
        while (n < _loaded.length) {
            if (_loaded[n] == 0 && _anims[n] != null) {
                _anims[n].dispose();
                Animation._anims[n] = null;
            }
            ++n;
        }
        SptSet.disposeLocal();
    }

    public final void dispose() {
        this._visibleBox = null;
        int n = 0;
        while (n < this._collisionBox.length) {
            this._collisionBox[n] = null;
            ++n;
        }
        this._collisionBox = null;
        int n2 = 0;
        while (n2 < this._actFrmId.length) {
            this._actFrmId[n2] = null;
            ++n2;
        }
        this._actFrmId = null;
        int n3 = 0;
        while (n3 < this._tileId.length) {
            this._tileId[n3] = null;
            this._xoff[n3] = null;
            this._yoff[n3] = null;
            ++n3;
        }
        this._tileId = null;
        this._xoff = null;
        this._yoff = null;
        this._sptNum = null;
        this._actFrmNum = null;
        this._sptSet = null;
    }

    public static void setLoad(int n, int n2) {
        if (_loaded[n] != 1) {
            Animation._loaded[n] = n2;
        }
        SptSet.setLoad(Animation._anims[n]._sptSetIdx, n2);
    }

    public static Animation load(int n, int n2) {
        if (n < -1) {
            n += 256;
        } else if (n == -1) {
            return null;
        }
        if (_anims[n] != null) {
            Animation.setLoad(n, n2);
            return _anims[n];
        }
        Animation animation = new Animation();
        try {
            int n3;
            animation._id = n;
            int n4 = n / 10;
            int n5 = n % 10;
            InputStream inputStream = StreamReader.openDataFile("/res/singleani" + n4 + ".bin", n5);
            byte by = StreamReader.readByte(inputStream);
            animation._sptSetIdx = StreamReader.readByte(inputStream);
            if (animation._sptSetIdx < 0) {
                animation._sptSetIdx = (short)(animation._sptSetIdx + 256);
            }
            animation._frmNum = StreamReader.readShort(inputStream);
            animation._sptNum = new short[animation._frmNum];
            animation._tileId = new short[animation._frmNum][];
            animation._xoff = new byte[animation._frmNum][];
            animation._yoff = new byte[animation._frmNum][];
            int n6 = 0;
            while (n6 < animation._frmNum) {
                animation._sptNum[n6] = StreamReader.readShort(inputStream);
                animation._tileId[n6] = new short[animation._sptNum[n6]];
                animation._xoff[n6] = new byte[animation._sptNum[n6]];
                animation._yoff[n6] = new byte[animation._sptNum[n6]];
                n3 = 0;
                while (n3 < animation._sptNum[n6]) {
                    animation._tileId[n6][n3] = StreamReader.readShort(inputStream);
                    animation._xoff[n6][n3] = StreamReader.readByte(inputStream);
                    animation._yoff[n6][n3] = StreamReader.readByte(inputStream);
                    ++n3;
                }
                ++n6;
            }
            animation._actNum = StreamReader.readShort(inputStream);
            animation._collisionBox = new byte[animation._actNum][4];
            animation._actFrmNum = new short[animation._actNum];
            animation._actFrmId = new short[animation._actNum][];
            n3 = 0;
            while (n3 < animation._actNum) {
                animation._collisionBox[n3][0] = StreamReader.readByte(inputStream);
                animation._collisionBox[n3][1] = StreamReader.readByte(inputStream);
                animation._collisionBox[n3][2] = StreamReader.readByte(inputStream);
                animation._collisionBox[n3][3] = StreamReader.readByte(inputStream);
                animation._actFrmNum[n3] = StreamReader.readShort(inputStream);
                animation._actFrmId[n3] = new short[animation._actFrmNum[n3]];
                int n7 = 0;
                while (n7 < animation._actFrmNum[n3]) {
                    animation._actFrmId[n3][n7] = StreamReader.readByte(inputStream);
                    if (animation._actFrmId[n3][n7] < 0) {
                        short[] sArray = animation._actFrmId[n3];
                        int n8 = n7;
                        sArray[n8] = (short)(sArray[n8] + 256);
                    }
                    ++n7;
                }
                ++n3;
            }
            animation._visibleBox[0] = StreamReader.readShort(inputStream);
            animation._visibleBox[1] = StreamReader.readShort(inputStream);
            animation._visibleBox[2] = StreamReader.readShort(inputStream);
            animation._visibleBox[3] = StreamReader.readShort(inputStream);
            Animation._anims[n] = animation;
            inputStream.close();
            inputStream = null;
            animation._sptSet = SptSet.load(animation._sptSetIdx, n2);
            Animation._loaded[n] = n2;
        }
        catch (Exception exception) {
            return null;
        }
        return animation;
    }

    public static Animation getAnimation(int n) {
        if (_anims.length <= n || _anims[n] == null) {
            return Animation.load(n, 2);
        }
        return _anims[n];
    }

    public int getCollideLeft(int n) {
        return this._collisionBox[n][0];
    }

    public int getCollideRight(int n) {
        return this._collisionBox[n][1];
    }

    public int getVisibleLeft() {
        return this._visibleBox[0];
    }

    public int getVisibleRight() {
        return this._visibleBox[1];
    }

    public int getCollideTop(int n) {
        return this._collisionBox[n][2];
    }

    public int getCollideBottom(int n) {
        return this._collisionBox[n][3];
    }

    public int getVisibleTop() {
        return this._visibleBox[2];
    }

    public int getVisibleBottom() {
        return this._visibleBox[3];
    }

    static {
        _anims = new Animation[300];
        _loaded = new int[300];
    }
}

