/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.db;

import com.sinaflying.db.DataCompose;
import com.sinaflying.db.DataEnemy;
import com.sinaflying.db.DataEquip;
import com.sinaflying.db.DataMaterial;
import com.sinaflying.db.DataMissionThing;
import com.sinaflying.db.DataRole;
import com.sinaflying.db.DataSkill;
import com.sinaflying.db.DataThing;
import com.sinaflying.game.GameParameter;
import com.sinaflying.util.StreamReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class GameDB {
    private Hashtable _dataEnemy = new Hashtable();
    private Hashtable _dataEquip = new Hashtable();
    private Hashtable _dataRole = new Hashtable();
    private Hashtable _dataSkill = new Hashtable();
    private Hashtable _dataThing = new Hashtable();
    private Hashtable _dataMissionThing = new Hashtable();
    private Hashtable _dataMeterial = new Hashtable();
    private Hashtable _dataCompose = new Hashtable();
    private int _maxLevel;
    private static GameDB _dataBase;
    private Vector[] _sceneEnemyInx = new Vector[98];

    private GameDB() {
    }

    public static final void loadDataSecond() {
        if (_dataBase == null) {
            _dataBase = new GameDB();
        }
        _dataBase.loadEnemyData();
    }

    public static final GameDB getGameDataBase() {
        if (_dataBase == null) {
            GameDB.loadDataBase();
        }
        return _dataBase;
    }

    public final DataEnemy getEnemyData(int n) {
        return (DataEnemy)this._dataEnemy.get(new Integer(n));
    }

    public final Hashtable getEnemyData() {
        return this._dataEnemy;
    }

    public final int getEnemyNum() {
        return this._dataEnemy.size();
    }

    public final DataEquip getEquipData(int n) {
        return (DataEquip)this._dataEquip.get(new Integer(n));
    }

    public final Hashtable getEquipData() {
        return this._dataEquip;
    }

    public final int getEquipNum() {
        return this._dataEquip.size();
    }

    public final DataRole getRoleData(int n) {
        return (DataRole)this._dataRole.get(new Integer(n));
    }

    public final Hashtable getRoleData() {
        return this._dataRole;
    }

    public final int getRoleNum() {
        return this._dataRole.size();
    }

    public final DataSkill getSkillData(int n) {
        return (DataSkill)this._dataSkill.get(new Integer(n));
    }

    public final Hashtable getSkillData() {
        return this._dataSkill;
    }

    public final int getSkillNum() {
        return this._dataSkill.size();
    }

    public final DataThing getThingData(int n) {
        return (DataThing)this._dataThing.get(new Integer(n));
    }

    public final Hashtable getThingData() {
        return this._dataThing;
    }

    public final int getThingNum() {
        return this._dataThing.size();
    }

    public final DataMissionThing getDataMissionThing(int n) {
        return (DataMissionThing)this._dataMissionThing.get(new Integer(n));
    }

    public final Hashtable getDataMissionThing() {
        return this._dataMissionThing;
    }

    public final int getDataMissionThingNum() {
        return this._dataMissionThing.size();
    }

    public final DataCompose getDataComposeScroll(int n) {
        return (DataCompose)this._dataCompose.get(new Integer(n));
    }

    public final Hashtable getDataComposeScroll() {
        return this._dataCompose;
    }

    public final int getDataComposeScrollNum() {
        return this._dataCompose.size();
    }

    public final DataMaterial getMaterialData(int n) {
        return (DataMaterial)this._dataMeterial.get(new Integer(n));
    }

    public final Hashtable getMeterialData() {
        return this._dataMeterial;
    }

    public final int getMeterialNum() {
        return this._dataMeterial.size();
    }

    public static final void loadDataLevel() {
        _dataBase = new GameDB();
        _dataBase.loadRoleData();
    }

    public static final void loadDataBase() {
        if (_dataBase != null) {
            return;
        }
        _dataBase = new GameDB();
        try {
            _dataBase.loadRoleData();
            _dataBase.loadThingData();
            _dataBase.loadDataMaterail();
            _dataBase.loadSkillData();
            _dataBase.loadEquipData();
            _dataBase.loadEnemyData();
            _dataBase.loadDataMissionThing();
            _dataBase.loadDataPCompose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadRoleData() {
        try {
            InputStream inputStream = null;
            int n = 2;
            Hashtable<Integer, DataRole> hashtable = new Hashtable<Integer, DataRole>();
            int n2 = 0;
            while (n2 < n) {
                inputStream = StreamReader.openDataFile("/res/data.bin", GameParameter.DB_INDEX_ROLE[n2]);
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                hashtable.put(new Integer(n2), DataRole.produceRoleData(dataInputStream, n2));
                if (inputStream != null) {
                    inputStream.close();
                }
                ++n2;
            }
            this._dataRole = hashtable;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Vector getEnemyInxsByScene(int n) {
        return this._sceneEnemyInx[n];
    }

    private final void loadEnemyData() {
        try {
            InputStream inputStream = StreamReader.openDataFile("/res/data.bin", 6);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            Hashtable<Integer, DataEnemy> hashtable = new Hashtable<Integer, DataEnemy>();
            int n2 = 0;
            while (n2 < this._sceneEnemyInx.length) {
                this._sceneEnemyInx[n2] = new Vector(1, 3);
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                byte by = dataInputStream.readByte();
                DataEnemy dataEnemy = DataEnemy.produceEnemyData(dataInputStream);
                hashtable.put(new Integer(by), dataEnemy);
                int[] nArray = dataEnemy.getRegionalExistInx();
                try {
                    int n4 = 0;
                    while (n4 < nArray.length) {
                        this._sceneEnemyInx[nArray[n4]].addElement(new Integer(by));
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n3;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this._dataEnemy = hashtable;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadEquipData() {
        try {
            InputStream inputStream = StreamReader.openDataFile("/res/data.bin", 5);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            Hashtable<Integer, DataEquip> hashtable = new Hashtable<Integer, DataEquip>();
            int n2 = 0;
            while (n2 < n) {
                short s = dataInputStream.readShort();
                hashtable.put(new Integer(s), DataEquip.produceEquipData(dataInputStream));
                ++n2;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this._dataEquip = hashtable;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadSkillData() {
        try {
            InputStream inputStream = StreamReader.openDataFile("/res/data.bin", 4);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            Hashtable<Integer, DataSkill> hashtable = new Hashtable<Integer, DataSkill>();
            int n2 = 0;
            while (n2 < n) {
                byte by = dataInputStream.readByte();
                hashtable.put(new Integer(by), DataSkill.produceSkillData(dataInputStream));
                ++n2;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this._dataSkill = hashtable;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadThingData() {
        try {
            InputStream inputStream = StreamReader.openDataFile("/res/data.bin", 2);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            Hashtable<Integer, DataThing> hashtable = new Hashtable<Integer, DataThing>();
            int n2 = 0;
            while (n2 < n) {
                byte by = dataInputStream.readByte();
                hashtable.put(new Integer(by), DataThing.produceThingData(dataInputStream));
                ++n2;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this._dataThing = hashtable;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void loadDataMissionThing() {
        try {
            InputStream inputStream = StreamReader.openDataFile("/res/data.bin", 7);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            Hashtable<Integer, DataMissionThing> hashtable = new Hashtable<Integer, DataMissionThing>();
            int n2 = 0;
            while (n2 < n) {
                byte by = dataInputStream.readByte();
                hashtable.put(new Integer(by), DataMissionThing.produceMissionThingData(dataInputStream));
                ++n2;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this._dataMissionThing = hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void loadDataMaterail() {
        try {
            InputStream inputStream = StreamReader.openDataFile("/res/data.bin", 3);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            Hashtable<Integer, DataMaterial> hashtable = new Hashtable<Integer, DataMaterial>();
            int n2 = 0;
            while (n2 < n) {
                byte by = dataInputStream.readByte();
                hashtable.put(new Integer(by), DataMaterial.produceDataMaterial(dataInputStream));
                ++n2;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this._dataMeterial = hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void loadDataPCompose() {
        try {
            InputStream inputStream = StreamReader.openDataFile("/res/data.bin", 8);
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n = dataInputStream.readByte();
            Hashtable<Integer, DataCompose> hashtable = new Hashtable<Integer, DataCompose>();
            int n2 = 0;
            while (n2 < n) {
                try {
                    byte by = dataInputStream.readByte();
                    hashtable.put(new Integer(by), DataCompose.produceDataCompose(dataInputStream));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n2;
            }
            if (inputStream != null) {
                inputStream.close();
            }
            this._dataCompose = hashtable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

