/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.common.ui;

import feeLibs.common.ui.QQADUIListener;
import java.util.Vector;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class QQADUI {
    protected int _tipType = 0;
    protected int _tipStrPosY = 0;
    protected int _cx;
    protected int _cy;
    protected int _cw;
    protected int _ch;
    protected int _tx;
    protected int _ty;
    protected int _cur;
    protected int _lines;
    protected int _gfh;
    protected int _curPage;
    protected int _maxPage;
    protected int _buttonTextColor;
    protected int _displayTextColor;
    protected int _backgroundColor;
    protected int _scrollbarColor;
    protected MIDlet _midlet;
    protected Font _font;
    protected String[] _adStr;
    protected Image[] _adImg;
    protected QQADUIListener _listener;
    protected Vector _strs = new Vector(30, 1);
    protected static final String[] _strTip = new String[]{"\u4e0b\u8f7d", "\u9000\u51fa", "\u8fd4\u56de"};

    public QQADUI(MIDlet midlet, QQADUIListener listener, Font _font, int screen_w, int screen_h) {
        this._midlet = midlet;
        this._font = _font;
        this._listener = listener;
        this._gfh = this.getFontHeight();
        this.setDefaultRect();
        this._cw = screen_w;
        this._ch = screen_h;
        this.setDefaultPalette();
    }

    protected void setDefaultPalette() {
        this._gfh = Font.getDefaultFont().getHeight();
        this._buttonTextColor = 13546266;
        this._displayTextColor = 0xE5FFFF;
        this._backgroundColor = 25269;
        this._scrollbarColor = 0xFFFF00;
    }

    public void setPalette(int buttonTextColor, int displayTextColor, int backgroundColor, int scrollbarColor) {
        this._buttonTextColor = buttonTextColor;
        this._displayTextColor = displayTextColor;
        this._backgroundColor = backgroundColor;
        this._scrollbarColor = scrollbarColor;
    }

    public void initUi(String[] adStr, Image[] adImg, int tipTextType) {
        this._adImg = adImg;
        this._adStr = adStr;
        this._tipType = tipTextType;
        if (this._adImg.length != adStr.length) {
            System.out.println("\u8bf4\u660e\u6587\u5b57\u4e0e\u56fe\u7247\u6570\u91cf\u4e0d\u7b26\uff01");
        }
        this._maxPage = this._adImg.length;
        this._ty = this._ty + this._adImg[0].getHeight() + 20;
        this.setUIRect(this._cw, this._ch);
        this.calcuLayout(adStr[0]);
    }

    protected int getFontHeight() {
        return this._font.getHeight();
    }

    protected void drawTipStr(Graphics g) {
        g.drawString(_strTip[0], 0, this._ch - this._tipStrPosY, 36);
        if (this._tipType == 0) {
            g.drawString(_strTip[2], this._cw, this._ch - this._tipStrPosY, 40);
        } else {
            g.drawString(_strTip[1], this._cw, this._ch - this._tipStrPosY, 40);
        }
    }

    public void paint(Graphics g) {
        g.setColor(this._backgroundColor);
        g.setClip(0, 0, this._cw, this._ch);
        g.fillRect(0, 0, this._cw, this._ch);
        this._listener.drawBackGround(g);
        g.drawImage(this._adImg[this._curPage], this._cw >> 1, this._cy, 1 | 0x10);
        this.drawVectorString(g);
        this.drawTipStr(g);
        this.processKeyStatus(this.getCurKey());
    }

    protected void processKeyStatus(int key) {
        switch (key) {
            case 2: {
                this.pressedUpButton();
                break;
            }
            case 3: {
                this.pressedDownButton();
                break;
            }
            case 4: {
                this.pressedLeftButton();
                break;
            }
            case 5: {
                this.pressedRightButton();
                break;
            }
            case 0: {
                this.pressedSoftLeftButton();
                break;
            }
            case 1: {
                this._listener.pressedExitButton();
            }
        }
        this._listener.clearKeyStatus();
    }

    protected void setUIRect(int cw, int ch) {
        this._cw = cw;
        this._ch = ch;
    }

    protected int getCurKey() {
        return this._listener.getKeyStatus();
    }

    protected void resetCurKey() {
        this._listener.clearKeyStatus();
    }

    protected void setDefaultRect() {
        this._cx = 10;
        this._cy = 10;
        this._tx = 20;
        this._ty = this._ch >> 1;
    }

    public void setPicAndContPos(int picY, int textY, int tipTextY) {
        this._cy = picY;
        this._ty = textY;
        this._tipStrPosY = tipTextY;
        this.calcuLayout(this._adStr[this._curPage]);
    }

    protected void calcuLayout(String text) {
        int idx;
        this._strs.removeAllElements();
        this._cur = 0;
        this._lines = 0;
        this._gfh = this._font.getHeight();
        int width = this._cw - this._tx * 2;
        int height = this._ch - this._ty - this._gfh - 3;
        this._lines = height / this._gfh;
        int len = text.length();
        int last = 0;
        for (idx = 1; idx < len; ++idx) {
            int r = this._font.substringWidth(text, last, idx - last);
            if (r <= width) continue;
            this._strs.addElement(text.substring(last, idx - 1));
            last = idx - 1;
        }
        if (idx > last) {
            this._strs.addElement(text.substring(last));
        }
        if (this._lines > this._strs.size()) {
            this._lines = this._strs.size();
        }
    }

    protected void drawVectorString(Graphics g) {
        g.setClip(0, 0, this._cw, this._ch);
        g.setColor(this._displayTextColor);
        for (int j = 0; j < this._lines; ++j) {
            g.drawString((String)this._strs.elementAt(this._cur + j), this._tx, this._ty + j * this._gfh, 20);
        }
        g.drawString("" + (this._curPage + 1) + "/" + this._maxPage, this._cw >> 1, this._ch - this._tipStrPosY, 0x20 | 1);
        if (this._lines < this._strs.size()) {
            g.setColor(this._scrollbarColor);
            g.drawLine(this._cw - this._cx + 5, this._ty + 3, this._cw - this._cx + 5, this._ch - this._gfh - 3);
            g.fillRect(this._cw - this._cx + 3, this._ty + 3 + this._cur * (this._ch - this._ty - this._gfh - 8) / (this._strs.size() - this._lines), 5, 6);
        }
    }

    protected void pressedUpButton() {
        if (this._cur > 0) {
            --this._cur;
        }
        this._listener.clearKeyStatus();
    }

    protected void pressedDownButton() {
        if (this._cur < this._strs.size() - this._lines) {
            ++this._cur;
        }
        this._listener.clearKeyStatus();
    }

    protected void pressedRightButton() {
        if (this._curPage < this._maxPage - 1) {
            ++this._curPage;
            this.calcuLayout(this._adStr[this._curPage]);
        }
        this._listener.clearKeyStatus();
    }

    protected void pressedLeftButton() {
        if (this._curPage > 0) {
            --this._curPage;
            this.calcuLayout(this._adStr[this._curPage]);
        }
        this._listener.clearKeyStatus();
    }

    protected void pressedSoftLeftButton() {
        this.downLoadApp(this._curPage);
        if (this._listener.getPlatformType() == 0) {
            this._midlet.notifyDestroyed();
        }
    }

    protected void downLoadApp(int AppIndex) {
        try {
            String url = this.getAppUrl(AppIndex);
            System.out.println(url);
            if (this._midlet.platformRequest(url)) {
                this._midlet.notifyDestroyed();
            }
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            // empty catch block
        }
    }

    protected String getAppUrl(int index) {
        String property = "Tj" + (index + 1) + "Url";
        System.out.print(property);
        return this._midlet.getAppProperty(property);
    }
}

