/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.script;

import com.sinaflying.game.Actor;
import com.sinaflying.game.GameParameter;
import com.sinaflying.script.ExecStamp;
import com.sinaflying.script.Executor;
import com.sinaflying.script.Script;
import java.util.Stack;
import javax.microedition.lcdui.Image;

public class ScriptParser
implements Runnable {
    private static final int _VERSION = 1;
    private static final int WORD_BYTE = 1;
    private static final int WORD_SHORT = 2;
    private static final int WORD_INT = 4;
    private Script _script;
    private Executor _executor;
    private Stack _execStamp;
    private boolean _supportThread;
    private int[] _integer;
    private String[] _string;
    private Image[] _image;
    private Actor[] _actor;
    private boolean _debug;
    private boolean _curBlockWait;
    private boolean _curRestart;
    private boolean _curCallScript;
    private boolean _scriptEnd;

    public ScriptParser(Script script, Executor executor) {
        if (script.getVersion() != 1) {
            return;
        }
        this._script = script;
        this._executor = executor;
        this._execStamp = new Stack();
        this._execStamp.setSize(10);
    }

    public void setExecutor(Executor executor) {
        this._executor = executor;
    }

    public void dispose() {
        this._script = null;
        this._executor = null;
        this._integer = null;
        this._string = null;
        this._image = null;
        this._actor = null;
        this._execStamp = null;
    }

    public void startup(boolean bl) {
        this.init();
        this._supportThread = bl;
        if (this._supportThread) {
            new Thread(this).start();
        } else {
            this.initExecStack();
        }
    }

    public boolean isScriptEnd() {
        return this._scriptEnd || this._script.isEnd();
    }

    public boolean supportThread() {
        return this._supportThread;
    }

    private void initExecStack() {
        int n = this._script.getInt(4);
        ExecStamp execStamp = this.createStamp(0);
        execStamp.writeStamp(0, this._script.getPtr());
        execStamp.writeStamp(2, n);
        execStamp.writeStamp(3, 0);
        this.pushStamp(execStamp);
    }

    private void init() {
        this._script.reset();
        this._execStamp.removeAllElements();
        this._curBlockWait = false;
        this._scriptEnd = false;
        this._curCallScript = false;
        this._curRestart = false;
    }

    private void pauseAndRestart() {
        this._curRestart = true;
    }

    private void execSyntaxTree() {
        int n = this._script.getInt(4);
        int n2 = 0;
        while (n2 < n) {
            this.execSyntaxBlock();
            if (this._curBlockWait || this._scriptEnd) break;
            ++n2;
        }
    }

    private void execStampTree() {
        if (this.stackEmpty()) {
            return;
        }
        ExecStamp execStamp = this.popStamp();
        int n = execStamp.readStamp(0);
        int n2 = execStamp.readStamp(2);
        int n3 = execStamp.readStamp(3);
        this._script.setPtr(n);
        while (n3 < n2) {
            execStamp = this.createStamp(1);
            execStamp.writeStamp(0, this._script.getPtr());
            execStamp.writeStamp(2, n2);
            execStamp.writeStamp(3, n3);
            this.pushStamp(execStamp);
            this.execSyntaxBlock();
            if (this._curBlockWait) {
                this._curBlockWait = false;
                this._script.setPtr(n);
                break;
            }
            if (this._scriptEnd) break;
            if (this._curCallScript) {
                this._curCallScript = false;
                n3 = -1;
                n2 = this._script.getInt(4);
                this.popStamp();
            } else {
                if (this._curRestart) {
                    this._curRestart = false;
                    this.startup(false);
                    break;
                }
                this.popStamp();
            }
            ++n3;
        }
    }

    private void execSyntaxBlock() {
        int n = this._script.getInt(1);
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                this.syntaxMacro();
                break;
            }
            case 1: {
                this.syntaxExpression();
                break;
            }
            case 2: {
                this.syntaxBranch();
                break;
            }
            case 3: {
                this.syntaxLoop();
                break;
            }
            case 4: {
                this.syntaxFunction();
            }
        }
    }

    private void syntaxMacro() {
        int n = this._script.getInt(1);
        switch (n) {
            case 0: {
                this.macro_setuse();
                break;
            }
            case 1: {
                this.macro_setdefine();
                break;
            }
            case 2: {
                this.macro_setenvironment();
            }
        }
    }

    private void syntaxExpression() {
        this.expression_reader();
    }

    private void syntaxBranch() {
        int n = -1;
        int n2 = this._script.getInt(1);
        n = this._script.getPtr();
        boolean bl = this._curBlockWait;
        do {
            this._curBlockWait = false;
            this.execBranchStruct(n2);
            if (this._scriptEnd) break;
            if (!this._curBlockWait) continue;
            if (!this.supportThread()) break;
            this._script.setPtr(n);
        } while (this._curBlockWait);
        if (!this._curBlockWait) {
            this._curBlockWait = bl;
        }
    }

    private void execBranchStruct(int n) {
        boolean bl = false;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this._script.getInt(4);
            nArray2[n2] = this._script.getInt(4);
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = this._script.getInt(1);
            int n5 = this._script.getInt(1);
            int n6 = 0;
            switch (n4) {
                case -1: {
                    if (n2 != n - 1) break;
                    this.execSyntaxTree();
                    bl = true;
                    break;
                }
                case 0: {
                    n6 = this.expression_reader();
                    if (n6 <= 0) break;
                    this.execSyntaxTree();
                    bl = true;
                    break;
                }
                case 1: {
                    int n7 = 0;
                    while (n7 < n5) {
                        n6 += this.expression_reader();
                        ++n7;
                    }
                    if (n6 <= 0) break;
                    this.execSyntaxTree();
                    bl = true;
                    break;
                }
                case 2: {
                    int n7 = 0;
                    while (n7 < n5) {
                        n6 += this.expression_reader();
                        ++n7;
                    }
                    if (n6 != n5) break;
                    this.execSyntaxTree();
                }
            }
            if (this._curBlockWait || this._scriptEnd) break;
            if (bl) {
                n3 = nArray[n - 1] + nArray2[n - 1];
                this._script.setPtr(n3);
                break;
            }
            n3 = nArray[n2] + nArray2[n2];
            this._script.setPtr(n3);
            ++n2;
        }
    }

    private void syntaxLoop() {
        boolean bl = false;
        int n = this._script.getInt(4);
        int n2 = this._script.getInt(4);
        int n3 = this._script.getInt(1);
        int n4 = this._script.getInt(1);
        do {
            bl = false;
            int n5 = 0;
            this._script.setPtr(n);
            switch (n3) {
                case 0: {
                    n5 = this.expression_reader();
                    if (n5 <= 0) break;
                    this.execSyntaxTree();
                    bl = true;
                    break;
                }
                case 1: {
                    int n6 = 0;
                    while (n6 < n4) {
                        n5 += this.expression_reader();
                        ++n6;
                    }
                    if (n5 <= 0) break;
                    this.execSyntaxTree();
                    bl = true;
                    break;
                }
                case 2: {
                    int n6 = 0;
                    while (n6 < n4) {
                        n5 += this.expression_reader();
                        ++n6;
                    }
                    if (n5 != n4) break;
                    this.execSyntaxTree();
                    bl = true;
                }
            }
        } while (bl && !this._scriptEnd);
        int n7 = n + n2;
        this._script.setPtr(n7);
    }

    private void syntaxFunction() {
        this.function_reader();
    }

    private void macro_setuse() {
        int n = this._script.getInt(1);
        int n2 = this._script.getInt(2);
        switch (n) {
            case 0: {
                if (this._integer != null) break;
                this._integer = new int[n2];
                break;
            }
            case 1: {
                if (this._string != null) break;
                this._string = new String[n2];
                break;
            }
            case 2: {
                if (this._image != null) break;
                this._image = new Image[n2];
                break;
            }
            case 3: {
                if (this._actor != null) break;
                this._actor = new Actor[n2];
            }
        }
    }

    private void macro_setdefine() {
    }

    private void macro_setenvironment() {
        int n = this._script.getInt(1);
        switch (n) {
            case 0: {
                this._debug = true;
                break;
            }
            case 1: {
                this._debug = false;
            }
        }
    }

    private int expression_reader() {
        int n = this._script.getInt(1);
        switch (n) {
            case -1: {
                return 1;
            }
            case 0: {
                String string;
                int n2 = this.operand_reader_int();
                this._string[n2] = string = this.operand_reader_str();
                break;
            }
            case 1: {
                n = this._script.getInt(1);
                int[] nArray = new int[n];
                int[] nArray2 = new int[n - 1];
                int n3 = 0;
                while (n3 < n) {
                    nArray[n3] = this.operand_reader_int();
                    ++n3;
                }
                n3 = 0;
                while (n3 < n - 1) {
                    nArray2[n3] = this._script.getInt(1);
                    ++n3;
                }
                int n4 = this.operand_sum(nArray, nArray2);
                return n4;
            }
            case 2: {
                n = this._script.getInt(1);
                this.variable_assign(n);
                break;
            }
            case 3: {
                int n5 = this.operand_reader_int();
                n = this._script.getInt(1);
                int n6 = this.operand_reader_int();
                switch (n) {
                    case 0: {
                        return n5 > n6 ? 1 : 0;
                    }
                    case 1: {
                        return n5 < n6 ? 1 : 0;
                    }
                    case 2: {
                        return n5 >= n6 ? 1 : 0;
                    }
                    case 3: {
                        return n5 <= n6 ? 1 : 0;
                    }
                    case 4: {
                        return n5 == n6 ? 1 : 0;
                    }
                    case 5: {
                        return n5 != n6 ? 1 : 0;
                    }
                }
            }
        }
        return 0;
    }

    private int operand_reader_int() {
        int n = 0;
        int n2 = this._script.getInt(1);
        switch (n2) {
            case -1: 
            case 1: {
                break;
            }
            case 2: {
                n2 = this._script.getInt(1);
                switch (n2) {
                    case 0: {
                        int n3 = this._script.getInt(2);
                        n = this._integer[n3];
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n = this._script.getInt(2);
                    }
                }
                return n;
            }
            case 0: {
                n = this._script.getInt(4);
                return n;
            }
        }
        return -1;
    }

    private String operand_reader_str() {
        String string = null;
        int n = this._script.getInt(1);
        switch (n) {
            case -1: 
            case 0: 
            case 2: {
                break;
            }
            case 1: {
                string = this._script.getString();
            }
        }
        return string;
    }

    private int operand_sum(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        int n3 = nArray2.length;
        int n4 = nArray[n2++];
        n = 0;
        while (n < n3) {
            switch (nArray2[n]) {
                case 10: {
                    n4 += nArray[n2++];
                    break;
                }
                case 11: {
                    n4 -= nArray[n2++];
                    break;
                }
                case 12: {
                    n4 *= nArray[n2++];
                    break;
                }
                case 13: {
                    n4 /= nArray[n2++];
                    break;
                }
                case 14: {
                    n4 %= nArray[n2++];
                }
            }
            ++n;
        }
        return n4;
    }

    private void variable_assign(int n) {
        switch (n) {
            case -1: 
            case 0: {
                break;
            }
            case 1: {
                this.assign_str();
                break;
            }
            case 2: {
                this.assign_variable();
            }
        }
    }

    private void assign_str() {
        int n = this._script.getInt(2);
        int n2 = this._script.getInt(1);
        int n3 = this._script.getInt(1);
        block0 : switch (n3) {
            case -1: 
            case 1: {
                break;
            }
            case 0: {
                int n4 = this._script.getInt(4);
                if (n4 != 0) break;
                this._string[n] = null;
                break;
            }
            case 2: {
                n3 = this._script.getInt(1);
                switch (n3) {
                    case 0: 
                    case 2: 
                    case 3: {
                        break block0;
                    }
                    case 1: {
                        int n5 = this._script.getInt(2);
                        this._string[n] = this._string[n5];
                    }
                }
            }
        }
    }

    private void assign_variable() {
        int n = this._script.getInt(1);
        int n2 = this._script.getInt(2);
        int n3 = this._script.getInt(1);
        switch (n) {
            case 3: {
                n = this._script.getInt(1);
                switch (n) {
                    case -1: 
                    case 1: {
                        break;
                    }
                    case 0: {
                        int n4 = this._script.getInt(4);
                        this._actor[n2] = null;
                        break;
                    }
                    case 2: {
                        n = this._script.getInt(1);
                        int n5 = this._script.getInt(2);
                        this._actor[n2] = this._actor[n5];
                    }
                }
                break;
            }
            case 2: {
                n = this._script.getInt(1);
                switch (n) {
                    case -1: 
                    case 1: {
                        break;
                    }
                    case 0: {
                        int n6 = this._script.getInt(4);
                        this._image[n2] = null;
                        break;
                    }
                    case 2: {
                        n = this._script.getInt(1);
                        int n7 = this._script.getInt(2);
                        this._image[n2] = this._image[n7];
                    }
                }
                break;
            }
            case 1: {
                n = this._script.getInt(1);
                switch (n) {
                    case -1: 
                    case 1: {
                        break;
                    }
                    case 0: {
                        int n8 = this._script.getInt(4);
                        this._string[n2] = null;
                        break;
                    }
                    case 2: {
                        n = this._script.getInt(1);
                        int n9 = this._script.getInt(2);
                        this._string[n2] = this._string[n9];
                    }
                }
                break;
            }
            case 0: {
                int n10;
                int[] nArray = new int[n3];
                int[] nArray2 = new int[n3 - 1];
                int n11 = 0;
                while (n11 < n3) {
                    nArray[n11] = this.operand_reader_int();
                    ++n11;
                }
                n11 = 0;
                while (n11 < n3 - 1) {
                    nArray2[n11] = this._script.getInt(1);
                    ++n11;
                }
                this._integer[n2] = n10 = this.operand_sum(nArray, nArray2);
                nArray = null;
                nArray2 = null;
            }
        }
    }

    private void function_reader() {
        int n = this._script.getInt(2);
        int n2 = this._script.getInt(1);
        int[] nArray = new int[n2 * 2];
        String[] stringArray = new String[n2];
        int[] nArray2 = new int[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = this._script.getInt(1);
            nArray2[n5++] = n7;
            switch (n7) {
                case 0: {
                    int n8 = this._script.getInt(1);
                    nArray[n4++] = this._script.getInt(1);
                    nArray[n4++] = this._script.getInt(2);
                    break;
                }
                case 2: {
                    nArray[n4++] = this.operand_reader_int();
                    break;
                }
                case 1: {
                    stringArray[n3++] = this.operand_reader_str();
                    break;
                }
                case 3: {
                    nArray[n4++] = this.expression_reader();
                }
            }
            ++n6;
        }
        this.callExecFunction(n, nArray, stringArray, nArray2);
    }

    private void callExecFunction(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        int n2 = n / 100 * 100;
        n %= 100;
        switch (n2) {
            case 0: {
                this.loadPackager(n, nArray, stringArray, nArray2);
                break;
            }
            case 100: {
                this.actorPackager(n, nArray, stringArray, nArray2);
                break;
            }
            case 200: {
                this.gamePackager(n, nArray, stringArray, nArray2);
                break;
            }
            case 300: {
                this.scenarioPackager(n, nArray, stringArray, nArray2);
                break;
            }
            case 400: {
                this.inputPackager(n, nArray, stringArray, nArray2);
                break;
            }
            case 500: {
                this.systemPackager(n, nArray, stringArray, nArray2);
                break;
            }
            case 600: {
                this.graphicsPackager(n, nArray, stringArray, nArray2);
                break;
            }
            case 700: {
                this.scriptPackager(n, nArray, stringArray, nArray2);
            }
        }
    }

    private void loadPackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 0: {
                String string = this.getParamStr(0, nArray, stringArray, nArray2);
                n4 = this.getParamInt(1, nArray, nArray2);
                n2 = this.getParamIdx(2, nArray, nArray2);
                this._string[n2] = this._executor.loadString(string, n4);
                break;
            }
            case 1: {
                String string = this.getParamStr(0, nArray, stringArray, nArray2);
                n4 = this.getParamInt(1, nArray, nArray2);
                n2 = this.getParamIdx(2, nArray, nArray2);
                this._image[n2] = this._executor.loadImage(string, n4);
                break;
            }
            case 2: {
                n4 = this.getParamInt(0, nArray, nArray2);
                this._executor.loadAnim(n4);
                break;
            }
            case 3: {
                n4 = this.getParamInt(0, nArray, nArray2);
                this._executor.loadSpt(n4);
                break;
            }
            case 4: {
                n2 = this.getParamInt(0, nArray, nArray2);
                n3 = this.getParamInt(1, nArray, nArray2);
                this._executor.loadActorPool(n2, n3);
                break;
            }
            case 40: {
                n4 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n4] = this._executor.isSpecialHandleFinish() ? 1 : 0;
            }
        }
    }

    private void actorPackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        switch (n) {
            case 0: {
                int n2 = this.getParamInt(0, nArray, nArray2);
                int n3 = this.getParamIdx(1, nArray, nArray2);
                this._actor[n3] = this._executor.getActiveActor(n2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int n4;
                int n5 = n4 = this.getParamInt(0, nArray, nArray2);
                int n6 = this.getParamInt(1, nArray, nArray2);
                this._executor.actorDisActive(n5, n6);
                break;
            }
            case 4: {
                int n7 = this.getParamInt(0, nArray, nArray2);
                int n8 = this.getParamInt(1, nArray, nArray2);
                int n9 = this.getParamInt(2, nArray, nArray2);
                this._executor.actorChangeAction(n7, n8, n9);
                break;
            }
            case 7: {
                int n10 = this.getParamInt(0, nArray, nArray2);
                int n11 = this.getParamInt(1, nArray, nArray2);
                int n12 = this.getParamInt(2, nArray, nArray2);
                this._executor.actorWalk(n10, n11, n12);
                break;
            }
            case 8: {
                int n13 = this.getParamInt(0, nArray, nArray2);
                this._executor.actorStop(n13);
                break;
            }
            case 9: {
                int n14 = this.getParamInt(0, nArray, nArray2);
                String string = this.getParamStr(1, nArray, stringArray, nArray2);
                int n15 = this.getParamInt(2, nArray, nArray2);
                int n16 = this.getParamInt(3, nArray, nArray2);
                this._executor.actorSpeaker(n14, string, n15, n16);
                break;
            }
            case 12: {
                int n17 = this.getParamInt(0, nArray, nArray2);
                int n18 = this.getParamIdx(1, nArray, nArray2);
                this._integer[n18] = this._executor.actorGetPositionX(n17);
                break;
            }
            case 13: {
                int n19 = this.getParamInt(0, nArray, nArray2);
                int n20 = this.getParamIdx(1, nArray, nArray2);
                this._integer[n20] = this._executor.actorGetPositionY(n19);
                break;
            }
            case 15: {
                int n21 = this.getParamInt(0, nArray, nArray2);
                int n22 = this.getParamIdx(1, nArray, nArray2);
                this._integer[n22] = this._executor.actorGetCurAction(n21);
                break;
            }
            case 20: {
                int n23 = this.getParamInt(0, nArray, nArray2);
                this._executor.actorSetFocus(n23);
                break;
            }
            case 21: {
                int n24 = this.getParamInt(0, nArray, nArray2);
                this._executor.actorEnableAi(n24);
                break;
            }
            case 22: {
                int n25 = this.getParamInt(0, nArray, nArray2);
                this._executor.actorUnableAi(n25);
                break;
            }
            case 23: {
                int n26 = this.getParamInt(0, nArray, nArray2);
                int n27 = this.getParamInt(1, nArray, nArray2);
                int n28 = this.getParamIdx(2, nArray, nArray2);
                this._integer[n28] = this._executor.actorCollide(n26, n27) ? 1 : 0;
                break;
            }
            case 24: {
                int n29 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n29] = this._executor.isFinishDialog() ? 1 : 0;
                break;
            }
            case 25: {
                int n30 = this.getParamInt(0, nArray, nArray2);
                int n31 = this.getParamInt(1, nArray, nArray2);
                int n32 = this.getParamInt(2, nArray, nArray2);
                this._executor.actorSetPos(n30, n31, n32);
                break;
            }
            case 26: {
                int n33 = this.getParamInt(0, nArray, nArray2);
                int n34 = this.getParamInt(1, nArray, nArray2);
                this._executor.actorValidFlag(n33, n34);
                break;
            }
            case 27: {
                int n35 = this.getParamInt(0, nArray, nArray2);
                int n36 = this.getParamInt(1, nArray, nArray2);
                int n37 = this.getParamInt(2, nArray, nArray2);
                this._executor.actorWalkTo(n35, n36, n37);
                break;
            }
            case 28: {
                int n38 = this.getParamInt(0, nArray, nArray2);
                int n39 = this.getParamIdx(1, nArray, nArray2);
                this._integer[n39] = this._executor.actorIsFinishWalk(n38) ? 1 : 0;
                break;
            }
            case 29: {
                int n40 = this.getParamInt(0, nArray, nArray2);
                int n41 = this.getParamInt(1, nArray, nArray2);
                this._executor.actorSetPosOffset(n40, n41);
                break;
            }
            case 30: {
                int n42 = this.getParamInt(0, nArray, nArray2);
                int n43 = this.getParamInt(1, nArray, nArray2);
                int n44 = this.getParamInt(2, nArray, nArray2);
                this._executor.actorWalkToOffset(n42, n43, n44);
                break;
            }
            case 31: {
                int n45 = this.getParamInt(0, nArray, nArray2);
                int n46 = this.getParamInt(1, nArray, nArray2);
                this._executor.actorShowExpression(n45, n46);
                break;
            }
            case 32: {
                int n47 = this.getParamInt(0, nArray, nArray2);
                int n48 = this.getParamInt(1, nArray, nArray2);
                int n49 = this.getParamInt(2, nArray, nArray2);
                int n50 = this.getParamInt(3, nArray, nArray2);
                int n51 = this.getParamInt(4, nArray, nArray2);
                this._executor.createDynamicActor(n47, n48, n49, n50, n51);
                break;
            }
            case 33: {
                int n52 = this.getParamInt(0, nArray, nArray2);
                int n53 = this.getParamInt(1, nArray, nArray2);
                int n54 = this.getParamInt(2, nArray, nArray2);
                int n55 = this.getParamInt(3, nArray, nArray2);
                int n56 = this.getParamInt(4, nArray, nArray2);
                this._executor.createUndynamicActor(n52, n53, n54, n55, n56);
                break;
            }
            case 34: {
                int n57 = this.getParamInt(0, nArray, nArray2);
                int n58 = this.getParamInt(1, nArray, nArray2);
                int n59 = this.getParamInt(2, nArray, nArray2);
                int n60 = this.getParamInt(3, nArray, nArray2);
                this._executor.actorMove(n57, n58, n59, n60);
                break;
            }
            case 35: {
                int n61 = this.getParamInt(0, nArray, nArray2);
                int n62 = this.getParamInt(1, nArray, nArray2);
                int n63 = this.getParamInt(2, nArray, nArray2);
                int n64 = this.getParamInt(3, nArray, nArray2);
                this._executor.actorBlinkMove(n61, n62, n63, n64);
                break;
            }
            case 38: {
                int n65 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n65] = this._executor.isFinishWord() ? 1 : 0;
                break;
            }
            case 37: {
                int n66 = this.getParamInt(0, nArray, nArray2);
                int n67 = this.getParamIdx(1, nArray, nArray2);
                this._integer[n67] = this._executor.actorIsFinishMove(n66) ? 1 : 0;
                break;
            }
            case 39: {
                int n68 = this.getParamInt(0, nArray, nArray2);
                int n69 = this.getParamInt(1, nArray, nArray2);
                int n70 = this.getParamInt(2, nArray, nArray2);
                int n71 = this.getParamInt(3, nArray, nArray2);
                int n72 = this.getParamInt(4, nArray, nArray2);
                this._executor.specialHandle(n68, n69, n70, n71, n72);
                break;
            }
            case 41: {
                int n73 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n73] = this._executor.isDied() ? 1 : 0;
                break;
            }
            case 40: {
                int n74 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n74] = this._executor.isSpecialHandleFinish() ? 1 : 0;
            }
        }
    }

    private void gamePackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        switch (n) {
            case 4: {
                int n2 = this.getParamInt(0, nArray, nArray2);
                int n3 = this.getParamInt(1, nArray, nArray2);
                int n4 = this.getParamInt(2, nArray, nArray2);
                this._executor.gamePassLevel(n2, n3, n4);
                break;
            }
            case 8: {
                int n5 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n5] = this._executor.GameGetCameraX();
                break;
            }
            case 9: {
                int n6 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n6] = this._executor.GameGetCameraY();
                break;
            }
            case 10: {
                int n7 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n7] = this._executor.GameGetCameraW();
                break;
            }
            case 11: {
                int n8 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n8] = this._executor.GameGetCameraH();
                break;
            }
            case 12: {
                int n9 = this.getParamInt(0, nArray, nArray2);
                int n10 = this.getParamInt(1, nArray, nArray2);
                this._executor.GameLockCamera(n9, n10);
                break;
            }
            case 13: {
                this._executor.GameUnLockCamera();
                break;
            }
            case 14: {
                int n11 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n11] = this._executor.GameIsStableCamera() ? 1 : 0;
                break;
            }
            case 15: {
                this._executor.GameScreenFadeIn();
                break;
            }
            case 16: {
                this._executor.GameScreenFadeOut();
                break;
            }
            case 17: {
                int n12 = this.getParamInt(0, nArray, nArray2);
                this._executor.GameScreenVibrate(n12);
                break;
            }
            case 18: {
                int n13 = this.getParamInt(0, nArray, nArray2);
                int n14 = this.getParamInt(1, nArray, nArray2);
                this._executor.GameSetScenario(n13, n14);
                break;
            }
            case 19: {
                int n15 = this.getParamInt(0, nArray, nArray2);
                int n16 = this.getParamInt(1, nArray, nArray2);
                int n17 = this.getParamInt(2, nArray, nArray2);
                int n18 = this.getParamInt(3, nArray, nArray2);
                int n19 = this.getParamInt(4, nArray, nArray2);
                this._executor.GameSpringBattle(n15, n16, n17, n18, n19);
                break;
            }
            case 20: {
                String string = this.getParamStr(0, nArray, stringArray, nArray2);
                String string2 = this.getParamStr(1, nArray, stringArray, nArray2);
                String string3 = this.getParamStr(2, nArray, stringArray, nArray2);
                this._executor.gameQuestion(string, string2, string3);
                break;
            }
            case 21: {
                int n20 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n20] = this._executor.gameResult();
                break;
            }
            case 22: {
                int n21 = this.getParamInt(0, nArray, nArray2);
                this._executor.gameOpenShop(n21);
                break;
            }
            case 23: {
                int n22 = this.getParamInt(0, nArray, nArray2);
                int n23 = this.getParamInt(1, nArray, nArray2);
                this._executor.GameChangeMember(n22, n23);
                break;
            }
            case 24: {
                this._executor.gameCreatAllRole();
                break;
            }
            case 25: {
                int n24 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n24] = this._executor.gameIsAllRoleFinishWalk() ? 1 : 0;
                break;
            }
            case 26: {
                this._executor.gameTeamIn();
                break;
            }
            case 27: {
                this._executor.disposeAllRole();
                break;
            }
            case 28: {
                String string = this.getParamStr(0, nArray, stringArray, nArray2);
                this._executor.gameMouse(string);
                break;
            }
            case 31: {
                String string = this.getParamStr(0, nArray, stringArray, nArray2);
                this._executor.messageBox(string);
                break;
            }
            case 32: {
                this._executor.gameRestHandle();
                break;
            }
            case 33: {
                int n25 = this.getParamInt(0, nArray, nArray2);
                this._executor.playSound(n25);
                break;
            }
            case 34: {
                this._executor.stopSound();
                break;
            }
            case 35: {
                int n26 = this.getParamInt(0, nArray, nArray2);
                String string = this.getParamStr(1, nArray, stringArray, nArray2);
                int n27 = this.getParamInt(2, nArray, nArray2);
                int n28 = this.getParamInt(3, nArray, nArray2);
                this._executor.showSpecialWord(n26, string, n27, n28);
                break;
            }
            case 29: {
                int n29 = this.getParamInt(0, nArray, nArray2);
                int n30 = this.getParamInt(1, nArray, nArray2);
                int n31 = this.getParamInt(2, nArray, nArray2);
                this._executor.IncreaseThing(n29, n30, n31);
                break;
            }
            case 30: {
                int n32 = this.getParamInt(0, nArray, nArray2);
                int n33 = this.getParamInt(1, nArray, nArray2);
                int n34 = this.getParamInt(2, nArray, nArray2);
                this._executor.DisposeThing(n32, n33, n34);
                break;
            }
            case 37: {
                int n35 = this.getParamInt(0, nArray, nArray2);
                int n36 = this.getParamInt(1, nArray, nArray2);
                this._executor.DisposeThing(0, n35, n36);
                break;
            }
            case 38: {
                int n37 = this.getParamInt(0, nArray, nArray2);
                int n38 = this.getParamInt(1, nArray, nArray2);
                this._executor.OpenWeather(n37, n38);
                break;
            }
            case 39: {
                this._executor.CloseWeather();
                break;
            }
            case 40: {
                this._executor.OpenClock();
                break;
            }
            case 41: {
                this._executor.CloseClock();
                break;
            }
            case 42: {
                int n39 = this.getParamInt(1, nArray, nArray2);
                this._executor.SetTime(n39);
                break;
            }
            case 45: {
                int n40 = this.getParamInt(0, nArray, nArray2);
                int n41 = this.getParamInt(1, nArray, nArray2);
                int n42 = this.getParamInt(2, nArray, nArray2);
                int n43 = this.getParamInt(3, nArray, nArray2);
                this._executor.ClockHandle(n40, n41, n42, n43);
            }
        }
    }

    private void scenarioPackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
    }

    private void inputPackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        switch (n) {
            case 0: {
                int n2 = this.getParamIdx(0, nArray, nArray2);
                this._integer[n2] = this._executor.InputGetInputKey();
                break;
            }
            case 1: {
                int n3 = this.getParamInt(0, nArray, nArray2);
                this._executor.InputAddInputKey(n3);
                break;
            }
            case 2: {
                this._executor.InputClearInputKey();
                break;
            }
            case 3: {
                this._executor.InputEnablePressKey();
                break;
            }
            case 4: {
                this._executor.InputUnablePressKey();
            }
        }
    }

    private void systemPackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
    }

    private void graphicsPackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        switch (n) {
            case 0: {
                int n2 = this.getParamInt(0, nArray, nArray2);
                int n3 = this.getParamInt(1, nArray, nArray2);
                int n4 = this.getParamInt(2, nArray, nArray2);
                this._executor.graphicsSetColor(n2, n3, n4);
                break;
            }
            case 1: {
                int n5 = this.getParamInt(0, nArray, nArray2);
                int n6 = this.getParamInt(1, nArray, nArray2);
                int n7 = this.getParamInt(2, nArray, nArray2);
                int n8 = this.getParamInt(3, nArray, nArray2);
                this._executor.graphicsSetClip(n5, n6, n7, n8);
                break;
            }
            case 2: {
                int n9 = this.getParamInt(0, nArray, nArray2);
                int n10 = this.getParamInt(1, nArray, nArray2);
                int n11 = this.getParamInt(2, nArray, nArray2);
                int n12 = this.getParamInt(3, nArray, nArray2);
                this._executor.graphicsDrawLine(n9, n10, n11, n12);
                break;
            }
            case 3: {
                int n13 = this.getParamInt(0, nArray, nArray2);
                int n14 = this.getParamInt(1, nArray, nArray2);
                int n15 = this.getParamInt(2, nArray, nArray2);
                int n16 = this.getParamInt(3, nArray, nArray2);
                this._executor.graphicsDrawRect(n13, n14, n15, n16);
                break;
            }
            case 4: {
                int n17 = this.getParamInt(0, nArray, nArray2);
                int n18 = this.getParamInt(1, nArray, nArray2);
                int n19 = this.getParamInt(2, nArray, nArray2);
                int n20 = this.getParamInt(3, nArray, nArray2);
                this._executor.graphicsFillRect(n17, n18, n19, n20);
                break;
            }
            case 5: {
                int n21 = this.getParamInt(0, nArray, nArray2);
                int n22 = this.getParamInt(1, nArray, nArray2);
                int n23 = this.getParamInt(2, nArray, nArray2);
                int n24 = this.getParamInt(3, nArray, nArray2);
                int n25 = this.getParamInt(4, nArray, nArray2);
                int n26 = this.getParamInt(5, nArray, nArray2);
                this._executor.graphicsDrawRoundRect(n21, n22, n23, n24, n25, n26);
                break;
            }
            case 6: {
                int n27 = this.getParamIdx(0, nArray, nArray2);
                int n28 = this.getParamInt(1, nArray, nArray2);
                int n29 = this.getParamInt(2, nArray, nArray2);
                int n30 = this.getParamInt(3, nArray, nArray2);
                this._executor.graphicsDrawImage(this._image[n27], n28, n29, n30);
                break;
            }
            case 7: {
                String string = this.getParamStr(0, nArray, stringArray, nArray2);
                int n31 = this.getParamInt(1, nArray, nArray2);
                int n32 = this.getParamInt(2, nArray, nArray2);
                int n33 = this.getParamInt(3, nArray, nArray2);
                this._executor.graphicsDrawString(string, n31, n32, n33);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
        }
    }

    private void scriptPackager(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        switch (n) {
            case 2: {
                this.pauseAndRestart();
                break;
            }
            case 3: {
                this._scriptEnd = true;
                break;
            }
            case 4: {
                int n2 = this.getParamInt(0, nArray, nArray2);
                this._script = null;
                this._script = new Script();
                int n3 = n2 / 10;
                int n4 = n2 % 10;
                try {
                    if (!this._script.openFile(GameParameter.C_SCRIPT_DATE, n2)) break;
                    this._curCallScript = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 5: {
                this._curBlockWait = true;
                break;
            }
            case 6: {
                int n5 = this.getParamInt(0, nArray, nArray2);
                this._executor.jump(n5);
            }
        }
    }

    private int getParamInt(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n) {
            switch (nArray2[n4]) {
                case 0: {
                    int n5 = nArray[n2];
                    if (n5 == 0) {
                        n3 = this._integer[nArray[n2 + 1]];
                    }
                    n2 += 2;
                    break;
                }
                case 2: {
                    n3 = nArray[n2++];
                    break;
                }
                case 3: {
                    n3 = nArray[n2++];
                }
            }
            ++n4;
        }
        return n3;
    }

    private int getParamIdx(int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n) {
            switch (nArray2[n4]) {
                case 0: {
                    int n5 = nArray[n2];
                    n3 = nArray[n2 + 1];
                    n2 += 2;
                    break;
                }
                case 2: {
                    n3 = nArray[n2++];
                    break;
                }
                case 3: {
                    n3 = nArray[n2++];
                }
            }
            ++n4;
        }
        return n3;
    }

    private String getParamStr(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        int n2 = 0;
        int n3 = 0;
        String string = null;
        int n4 = 0;
        while (n4 <= n) {
            switch (nArray2[n4]) {
                case 0: {
                    int n5 = nArray[n2];
                    if (n5 == 1) {
                        string = this._string[nArray[n2 + 1]];
                    }
                    n2 += 2;
                    break;
                }
                case 2: 
                case 3: {
                    ++n2;
                    break;
                }
                case 1: {
                    string = stringArray[n3++];
                }
            }
            ++n4;
        }
        return string;
    }

    public void run() {
        this.execSyntaxTree();
    }

    public void exec() {
        this.execStampTree();
    }

    private void pushStamp(ExecStamp execStamp) {
        this._execStamp.push(execStamp);
    }

    private ExecStamp popStamp() {
        ExecStamp execStamp = (ExecStamp)this._execStamp.pop();
        return execStamp;
    }

    private boolean stackEmpty() {
        return this._execStamp.isEmpty();
    }

    private ExecStamp createStamp(int n) {
        ExecStamp execStamp = new ExecStamp(n);
        return execStamp;
    }
}

