/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.script;

import com.sinaflying.util.StreamReader;
import java.io.IOException;
import java.io.InputStream;

public final class Script {
    private int _offset;
    private int _version;
    private byte[] _bin2code;
    private static final int C_SCRIPT_INIT_PTR = 1;

    public boolean openFile(String string, int n) {
        this._bin2code = null;
        this._bin2code = StreamReader.readDataFile(string, n);
        this._version = this._bin2code[0];
        this.reset();
        return true;
    }

    public boolean openFile(byte[] byArray, int n) {
        this._bin2code = null;
        this._bin2code = StreamReader.readDateByArray(byArray, n);
        this._version = this._bin2code[0];
        this.reset();
        return true;
    }

    public boolean openFile(String string) {
        try {
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            int n = StreamReader.readInt(inputStream);
            this._bin2code = new byte[n];
            inputStream.read(this._bin2code);
            this._version = this._bin2code[0];
            this.reset();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public static Script readScript(InputStream inputStream) {
        Script script = new Script();
        try {
            int n = StreamReader.readInt(inputStream);
            script._bin2code = new byte[n];
            int n2 = inputStream.read(script._bin2code);
            if (n2 != n) {
                return null;
            }
            script._version = script._bin2code[0];
            script.reset();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return script;
    }

    public boolean readScript(byte[] byArray) {
        this._bin2code = new byte[byArray.length];
        System.arraycopy(this._bin2code, 0, byArray, 0, byArray.length);
        return true;
    }

    public void reset() {
        this._offset = 1;
    }

    public int skip(int n) {
        int n2 = this._bin2code.length;
        if (this._offset + n >= n2) {
            n = n2 - this._offset;
        }
        this._offset += n;
        return n;
    }

    public int getPtr() {
        return this._offset;
    }

    public void setPtr(int n) {
        this._offset = n;
    }

    public boolean isEnd() {
        int n = this._bin2code.length;
        return this._offset >= n;
    }

    public int getInt(int n) {
        int n2 = StreamReader.readInt(this._bin2code, this._offset, n);
        this.skip(n);
        return n2;
    }

    public boolean getBoolean() {
        boolean bl = this._bin2code[this._offset] > 0;
        this.skip(1);
        return bl;
    }

    public String getString() {
        int n = this._offset;
        int n2 = StreamReader.readInt(this._bin2code, n, 2);
        n += 2;
        char[] cArray = new char[n2 / 2];
        int n3 = 0;
        while (n3 < n2 / 2) {
            cArray[n3] = (char)StreamReader.readInt(this._bin2code, n, 2);
            n += 2;
            ++n3;
        }
        String string = new String(cArray);
        cArray = null;
        this.skip(n2 + 2);
        return string;
    }

    public int getVersion() {
        return this._version;
    }
}

