/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.engine.TiledBackground;
import com.sinaflying.game.Actor;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.ScriptDriver;
import com.sinaflying.game.UnitData;
import com.sinaflying.gameUtil.MessageBox;
import com.sinaflying.gameUtil.MessageBoxHandler;
import com.sinaflying.other.GameInfo;
import com.sinaflying.script.Executor;
import com.sinaflying.script.SceneExecutor;
import com.sinaflying.script.Script;
import com.sinaflying.util.Function;
import com.sinaflying.util.StreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Scene
implements MessageBoxHandler {
    public static final int PRODUCE_SCENE_INSTANCE = 0;
    public static final int PRODUCE_SCENE_MAP = 1;
    public static final int PRODUCE_SCENE_SECTOR = 2;
    public static final int PRODUCE_SCENE_UNIT = 3;
    public static final int PRODUCE_SCENE_ACTOR = 4;
    public static final int PRODUCE_SCENE_INIT_PARAMETER = 5;
    public static final int PRODUCE_SCENE_INIT_END = 6;
    public static final int SCENE_STATE_PLAYING = 0;
    public static final int SCENE_STATE_PASSLEVEL = 1;
    public static final int SCENE_STATE_INIT_SHOP = 2;
    public static final int SCENE_STATE_CONFIRM_SHOP = 3;
    public static final int SCENE_STATE_MENU = 4;
    public static final int SCENE_STATE_HELP = 5;
    public static final int SCENE_STATE_ABOUT = 6;
    public static final int SCENE_STATE_SAVE_SUCCESS = 7;
    public static final int SCENE_STATE_FINISH_SHOW_START = 8;
    public static final int SCENE_STATE_FINISH_SHOWING = 9;
    public static final int SCENE_STATE_FINISH_SHOW_END = 10;
    public static final int SCENE_STATE_FINISH_SHOW_CLODE = 11;
    public static final int SCENE_STATE_REST_START = 12;
    public static final int SCENE_STATE_REST_SHOW_INFO = 13;
    public static final int SCENE_STATE_REST_SHOW_END = 14;
    public static final int SCENE_STATE_TIME_END = 15;
    public static final int SCENE_STATE_GAME_EFFECT = 18;
    public static final int SCENE_STATE_LEARN = 19;
    public static final int SCENE_STATE_BUFFER = 21;
    public static final int SCENE_STATE_SHOW_CLOSE = 22;
    public static final int SCENE_STATE_SHOW_OPEN = 23;
    public static Scene _scene = null;
    public static InputStream _is = null;
    public static int produceProcess = 0;
    public static final int C_MAX_SECTOR_ACTOR_NUM = 40;
    public static final int C_MAX_ACTOR_NUM = 60;
    public static final int MAX_HASH_CAPACITY = 60;
    public static Hashtable _activeContainer = new Hashtable(60);
    public static final int DYNAMIC_ORIGIN_ID = 0xFFFFFFF;
    public int _dynamicIdCounter = 0xFFFFFFF;
    public Actor[][] _actorPool = new Actor[300][];
    public Actor[] _executeInsts;
    public int _executeNum;
    public int[] _newIds;
    public int[][] _typesLoad = new int[300][2];
    public int _sectorNum;
    public int _sectorWidth;
    public int _sectorHeight;
    public int _curSector;
    public int[][] _sectorCaptorId;
    public int[][] _sectorActorId;
    public int _types = 0;
    public int _id = -1;
    public int _state;
    public static int _globalActorNum;
    public static int[] _globalActorId;
    public GameMainLogic _mainLogic;
    public TiledBackground _bk;
    public Actor _focus;
    public RoleActor _mainActor;
    Executor _executor;
    public static final int C_CAMERA_VX = 10240;
    public static final int C_CAMERA_VY = 10240;
    public int _camx;
    public int _camy;
    public int _camw = 327680;
    public int _camh = 245760;
    public int _camvx;
    public int _camvy;
    public int _lockCx;
    public int _lockCy;
    public boolean _isLock;
    public int _shakeTime;
    public int _shakeRange;
    public int _cameraOffset;
    MessageBox _messageBox;
    public boolean _isOpenPic;
    public Image imgcg;
    int _cx;
    int _cy;
    int _cw;
    int _ch;
    public UnitData _unit;
    public static final int C_CAPTOR_KIND = 0;
    public static final int C_CAPTOR_KIND_SCENARIO = 1;
    public boolean _isValidInsts;
    public static final int C_COMPLEX_INDEX_START_ID = 1000;
    public UnitData[] _unitData;
    public int _battleInfoBK;
    public int _battleInfoFK;
    public int _preState;
    public int _menuInx;
    private static final int C_MENU_HEIGHT;
    private static final int C_MENU_RESUME = 0;
    private static final int C_MENU_SAVE = 1;
    private static final int C_MENU_SOUND = 2;
    private static final int C_MENU_HELP = 3;
    private static final int C_MENU_ABOUT = 4;
    private static final int C_MENU_EXIT = 5;

    public Scene() {
        this._newIds = new int[40];
        this._executeInsts = new Actor[60];
    }

    public boolean isCanDrawShop() {
        return this.getMainActor()._enableAI && this._executor.isFinishDialog();
    }

    public void startup() {
        int n;
        this.resetDynamicCounter();
        this._executor = null;
        GameMainLogic.getInstance();
        this._executor = new SceneExecutor(GameMainLogic.getGraphics(), this);
        int n2 = 0;
        while (n2 < this._actorPool.length) {
            n = 0;
            while (this._actorPool[n2] != null && n < this._actorPool[n2].length) {
                this._actorPool[n2][n]._active = false;
                ++n;
            }
            ++n2;
        }
        this.setInstsInvalid();
        n = this._unitData.length;
        n2 = 0;
        while (n2 < n) {
            this._unitData[n2].setValid();
            ++n2;
        }
        n2 = 0;
        while (n2 < _globalActorNum) {
            this.fetchActorFromPool(-1, _globalActorId[n2]);
            if (this.getGameLogic().checkInfoExist(this._id, _globalActorId[n2])) {
                Actor actor = this.getActiveActor(_globalActorId[n2]);
                if (Actor.isNeedRecord(actor.getAniInx())) {
                    actor.disActive();
                } else if (actor._curAction == 2 || actor._curAction == 3 || (actor._curAction | Integer.MIN_VALUE) == 2 || (actor._curAction | Integer.MIN_VALUE) == 3) {
                    actor.changeAction(4);
                } else if (actor._curAction == 5) {
                    actor.disActive();
                } else if (actor._isFlip) {
                    actor.changeAction(-2147483647);
                } else {
                    actor.changeAction(1);
                }
            }
            ++n2;
        }
    }

    public void startUpCamera() {
        this.initCamera(this._focus, this.getWidth(), this.getHeight());
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        this._bk.setPositionInMap(n, n2);
        int n3 = n2 / this._sectorHeight * (this._bk.getMapWidth() / this._sectorWidth) + n / this._sectorWidth;
        int n4 = 0;
        while (this._sectorActorId[n3] != null && n4 < this._sectorActorId[n3].length) {
            this.fetchActorFromPool(-1, this._sectorActorId[n3][n4]);
            if (this.getGameLogic().checkInfoExist(this._id, this._sectorActorId[n3][n4])) {
                Actor actor = this.getActiveActor(this._sectorActorId[n3][n4]);
                if (actor._curAction == 2 || actor._curAction == 3 || (actor._curAction | Integer.MIN_VALUE) == 2 || (actor._curAction | Integer.MIN_VALUE) == 3) {
                    actor.changeAction(4);
                } else if (actor._isFlip) {
                    actor.changeAction(-2147483647);
                } else {
                    actor.changeAction(1);
                }
            }
            ++n4;
        }
        this._curSector = n3;
    }

    public void update() {
    }

    public void paint(Graphics graphics) {
    }

    public void initCg(int n, int n2, int n3, int n4, int n5) {
        this.imgcg = GameInterface._logoImages[n + 1];
        this._cx = n2;
        this._cy = n3;
        this._cw = n4;
        this._ch = n5;
        this._isOpenPic = true;
    }

    public void closeCg() {
        this._isOpenPic = false;
        this.imgcg = null;
    }

    public void paintMap(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        if (this._isOpenPic) {
            if (this.imgcg == null) {
                this.imgcg = GameInterface._logoImages[4];
            }
            Function.fillScreen(graphics, 0, 0, 320, 240, 0);
            graphics.setClip(this._cx, this._cy, this._cw, this._ch);
            graphics.drawImage(this.imgcg, 320 - this.imgcg.getWidth() >> 1, 240 - this.imgcg.getHeight() >> 1, 0x10 | 4);
        } else {
            this._bk.drawToGraphics(graphics, this._cameraOffset);
        }
    }

    public void updateCaptors() {
        if (this._sectorCaptorId[this._curSector] == null) {
            return;
        }
        int[] nArray = this._sectorCaptorId[this._curSector];
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.checkCaptor(nArray[n2]);
            ++n2;
        }
    }

    public void updateZone() {
        Actor actor = this.getFocusActor();
        this.updateCamera(actor, this.getWidth(), this.getHeight());
        this.updateSector();
    }

    public void updateSector() {
        int n;
        int n2 = this._camx >> 10;
        int n3 = this._camy >> 10;
        this._bk.setPositionInMap(n2, n3);
        int n4 = n3 / this._sectorHeight * (this._bk.getMapWidth() / this._sectorWidth) + n2 / this._sectorWidth;
        if (n4 == this._curSector) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (this._sectorActorId[this._curSector] != null && this._sectorActorId[n4] != null && n5 < this._sectorActorId[this._curSector].length && n6 < this._sectorActorId[n4].length) {
            n = this._sectorActorId[this._curSector][n5];
            int n8 = this._sectorActorId[n4][n6];
            if (n < n8) {
                this.disposeActor(n);
                ++n5;
                continue;
            }
            if (n > n8) {
                this._newIds[n7++] = this._sectorActorId[n4][n6++];
                continue;
            }
            ++n5;
            ++n6;
        }
        while (this._sectorActorId[this._curSector] != null && n5 < this._sectorActorId[this._curSector].length) {
            this.disposeActor(this._sectorActorId[this._curSector][n5]);
            ++n5;
        }
        while (this._sectorActorId[n4] != null && n6 < this._sectorActorId[n4].length) {
            if (this._sectorActorId[n4][n6] != 0) {
                this._newIds[n7++] = this._sectorActorId[n4][n6];
            }
            ++n6;
        }
        n = 0;
        while (n < n7) {
            this.fetchActorFromPool(-1, this._newIds[n]);
            ++n;
        }
        this._curSector = n4;
    }

    public Actor fetchActorFromPool(int n, int n2) {
        Actor actor = null;
        UnitData unitData = null;
        Actor[][] actorArray = this._actorPool;
        if (n < 0) {
            unitData = this.getUnitData(n2);
            if (unitData == null) {
                return null;
            }
            n = unitData.getPicId();
        }
        int n3 = actorArray[n].length;
        int n4 = 0;
        while (n4 < n3) {
            actor = actorArray[n][n4];
            if (!actor._active) break;
            ++n4;
        }
        if (n4 < n3) {
            if (n2 >= 0) {
                if (unitData.isValid()) {
                    unitData.setInvalid();
                    actor.activate(this, n2);
                    actor.init(unitData);
                    this.addActorToActiveContainer(actor, n2);
                    return actor;
                }
            } else if (n2 == -1) {
                n2 = this.getDynamicID();
                actor.activate(this, n2);
                actor.resetData();
                this.addActorToActiveContainer(actor, n2);
                return actor;
            }
        }
        return null;
    }

    public boolean checkActorCondition(int n) {
        switch (n) {
            case 109: 
            case 119: 
            case 120: {
                return true;
            }
        }
        return false;
    }

    public void delCaptor(int n) {
    }

    public void checkCaptor(int n) {
        UnitData unitData = this.getUnitData(n);
        if (unitData.isValid() && this._focus.collide(unitData)) {
            this.triggerCaptor(unitData);
        }
    }

    public void triggerCaptor(UnitData unitData) {
        byte[] byArray = unitData.getParameter();
        byte by = byArray[0];
        switch (by) {
            case 1: {
                this.triggerScenario(unitData);
            }
        }
    }

    public void triggerScenario(UnitData unitData) {
        Script[] scriptArray = unitData.getScript();
        if (scriptArray != null) {
            ScriptDriver scriptDriver = ScriptDriver.getInstance();
            scriptDriver.addScript(scriptArray, this._executor);
            this._unit = unitData;
        }
    }

    public void lockCamera(int n, int n2) {
        this._lockCx = n;
        this._lockCy = n2;
        this._isLock = true;
    }

    public void unlockCamera() {
        this._isLock = false;
    }

    public void initCamera(Actor actor, int n, int n2) {
        this._isLock = false;
        this._camx = actor.getXDirLocation(this._camw);
        this._camy = actor.getYDirLocation(this._camh);
        this._camvy = 0;
        this._camvx = 0;
        this.validityCheckCamera(n, n2);
    }

    public void updateCamera(Actor actor, int n, int n2) {
        int n3;
        int n4;
        if (this._isLock) {
            n4 = this._lockCx;
            n3 = this._lockCy;
        } else {
            n4 = actor.getXDirLocation(this._camw);
            n3 = actor.getYDirLocation(this._camh);
        }
        this._camvy = 0;
        this._camvx = 0;
        if (this._camx < n4) {
            if (n4 - this._camx > 10240) {
                this._camvx = 10240;
            } else {
                this._camx = n4;
            }
        } else if (this._camx > n4) {
            if (this._camx - n4 > 10240) {
                this._camvx = -10240;
            } else {
                this._camx = n4;
            }
        }
        if (this._camy < n3) {
            if (n3 - this._camy > 10240) {
                this._camvy = 10240;
            } else {
                this._camy = n3;
            }
        } else if (this._camy > n3) {
            if (this._camy - n3 > 10240) {
                this._camvy = -10240;
            } else {
                this._camy = n3;
            }
        }
        this._camx += this._camvx;
        this._camy += this._camvy;
        this.validityCheckCamera(n, n2);
    }

    public void setCamera(int n, int n2) {
        this._camx = n;
        this._camy = n2;
    }

    public void validityCheckCamera(int n, int n2) {
        int n3 = this._camx >> 10;
        int n4 = this._camy >> 10;
        n3 = Math.min(n3, n - 320 - 1);
        n3 = Math.max(n3, 0);
        n4 = Math.min(n4, n2 - 240 - 1);
        n4 = Math.max(n4, 0);
        this._camx = n3 << 10;
        this._camy = n4 << 10;
    }

    public void startUpShake(int n, int n2) {
        this._shakeRange = n;
        this._shakeTime = n2;
    }

    public void startUpShake(int n) {
        this._shakeTime = 0;
        this._shakeRange = n;
    }

    public void clearShake() {
        this._shakeTime = -1;
        this._cameraOffset = 0;
    }

    public void updateCameraOffset() {
        if (this._shakeTime >= 0x3FFFFFFF) {
            this._shakeTime = -1;
        }
        if (this._shakeTime >= 0) {
            this._cameraOffset = (this._shakeTime & 1) == 0 ? this._shakeRange : -this._shakeRange;
            ++this._shakeTime;
        }
    }

    public int getCameraOffset() {
        return this._cameraOffset;
    }

    public void dispose() {
        int n;
        if (this._bk != null) {
            this._bk.dispose();
            this._bk = null;
            this.clearActiveContainer();
        }
        int n2 = 0;
        while (n2 < this._executeInsts.length) {
            this._executeInsts[n2] = null;
            ++n2;
        }
        this._executeInsts = null;
        int n3 = 0;
        while (n3 < this._actorPool.length) {
            if (this._actorPool[n3] != null) {
                n = 0;
                while (n < this._actorPool[n3].length) {
                    this._actorPool[n3][n] = null;
                    ++n;
                }
                this._actorPool[n3] = null;
            }
            ++n3;
        }
        n = 0;
        while (n < this._sectorCaptorId.length) {
            this._sectorCaptorId[n] = null;
            ++n;
        }
        this._sectorCaptorId = null;
        int n4 = 0;
        while (n4 < this._sectorActorId.length) {
            this._sectorActorId[n4] = null;
            ++n4;
        }
        int n5 = 4;
        while (n5 < 7) {
            GameInterface._logoImages[n5] = null;
            ++n5;
        }
        this._sectorActorId = null;
        _globalActorId = null;
        System.gc();
    }

    public int getID() {
        return this._id;
    }

    public Actor getFocusActor() {
        return this._focus;
    }

    public RoleActor getMainActor() {
        return this._mainActor;
    }

    public int getWidth() {
        return this._bk.getMapWidth();
    }

    public int getHeight() {
        return this._bk.getMapHeight();
    }

    public GameMainLogic getGameLogic() {
        return this._mainLogic;
    }

    public TiledBackground getBackground() {
        return this._bk;
    }

    public static Scene getInstance() {
        return _scene;
    }

    public void reset() {
        this._bk.init();
    }

    public void setFocusActor(Actor actor) {
        this._focus = actor;
    }

    public void setMainActor(RoleActor roleActor) {
        this._mainActor = roleActor;
        RoleTeamData.getInstance().setLeaderInx(roleActor.getAniInx());
    }

    public void resetDynamicCounter() {
        this._dynamicIdCounter = 0xFFFFFFF;
    }

    public int getDynamicID() {
        return ++this._dynamicIdCounter;
    }

    public boolean isDynamicID(int n) {
        return n >= 0xFFFFFFF;
    }

    public void addActorToActiveContainer(Actor actor, int n) {
        this.setInstsInvalid();
        _activeContainer.put(String.valueOf(n), actor);
    }

    public void setInstsInvalid() {
        this._isValidInsts = false;
    }

    public Hashtable getActiveContainer() {
        return _activeContainer;
    }

    public void updateScript() {
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        scriptDriver.exec();
    }

    public boolean isOperatable() {
        if (!this.isFinishShowInfo()) {
            return false;
        }
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        return !scriptDriver.isExecuting();
    }

    public boolean canKeyRespond() {
        return this.isOperatable();
    }

    public void keyRespond() {
        if (!this.canKeyRespond()) {
            return;
        }
        switch (this._state) {
            case 0: 
            case 1: {
                if (this._mainLogic.isPressCallAttributeKey()) {
                    this._mainLogic._state = 444;
                    this._mainLogic.resetCurKey();
                    break;
                }
                if (!this._mainLogic.isPressCallMenuKey()) break;
                this._mainLogic.changeToInfoPanel();
                this._mainLogic.resetCurKey();
                break;
            }
        }
    }

    public void updateActors() {
        if (this._isOpenPic) {
            return;
        }
        this.updateInsts();
        Actor[] actorArray = this._executeInsts;
        int n = this._executeNum;
        int n2 = 0;
        while (n2 < n) {
            actorArray[n2].step();
            actorArray[n2].ai();
            ++n2;
        }
    }

    public void updateInsts() {
        if (this._isValidInsts) {
            return;
        }
        this._isValidInsts = true;
        Actor[] actorArray = this._executeInsts;
        int n = 0;
        Enumeration enumeration = _activeContainer.elements();
        while (enumeration.hasMoreElements()) {
            Actor actor = (Actor)enumeration.nextElement();
            if (!actor.isValid()) continue;
            actorArray[n++] = actor;
        }
        this._executeNum = n;
    }

    public void disActiveInst(int n) {
        this.setInstsInvalid();
        Actor actor = (Actor)_activeContainer.remove(String.valueOf(n));
        if (actor != null) {
            actor._active = false;
        }
        if (!this.isDynamicID(n)) {
            UnitData unitData = this.getUnitData(n);
            unitData.setValid();
        }
    }

    public void disLifeInst(int n) {
        this.setInstsInvalid();
        Actor actor = (Actor)_activeContainer.remove(String.valueOf(n));
        if (actor != null) {
            actor._active = false;
        }
    }

    public Actor getActiveActor(int n) {
        Actor actor = n >= 1000 ? this.getActorByComplex(n) : (Actor)_activeContainer.get(String.valueOf(n));
        return actor;
    }

    public Actor getActorByComplex(int n) {
        n -= 1000;
        Enumeration enumeration = _activeContainer.elements();
        while (enumeration.hasMoreElements()) {
            Actor actor = (Actor)enumeration.nextElement();
            if (!actor.isValid() || actor.getAniInx() != n) continue;
            return actor;
        }
        return null;
    }

    public Actor[] getActiveInsts(int[] nArray) {
        nArray[0] = this._executeNum;
        return this._executeInsts;
    }

    public void disposeActor(int n) {
        Actor actor = (Actor)_activeContainer.get(String.valueOf(n));
        if (actor != null) {
            actor.disActive();
        }
    }

    public void clearActiveContainer() {
        _activeContainer.clear();
    }

    public int getRoleActor(RoleActor[] roleActorArray) {
        int n = 0;
        Enumeration enumeration = _activeContainer.elements();
        while (enumeration.hasMoreElements()) {
            Actor actor = (Actor)enumeration.nextElement();
            if (!(actor instanceof RoleActor)) continue;
            roleActorArray[n++] = (RoleActor)actor;
        }
        return n;
    }

    public boolean canBecameMain(int n, int n2) {
        if (GameInterface._openPramInfo && !GameInterface._closePartInfo) {
            int n3 = GameInterface._paraValue[2] % 3;
            return n == n3 && Scene.isGloabalId(n2);
        }
        switch (this._id) {
            case 0: {
                if (!Scene.isGloabalId(n2)) break;
                return true;
            }
            default: {
                RoleTeamData roleTeamData = RoleTeamData.getInstance();
                if (this.getFocusActor() != null || !Scene.isGloabalId(n2) || n != roleTeamData.getRoleData(roleTeamData.getLeaderInx()).getAnimationIndex()) break;
                return true;
            }
        }
        return false;
    }

    public static boolean produceScene(GameMainLogic gameMainLogic, int n) {
        try {
            switch (produceProcess) {
                case 0: {
                    _scene = Scene.produceInstance(gameMainLogic, n);
                    Scene._scene._id = n;
                    produceProcess = 1;
                    break;
                }
                case 1: {
                    _scene.produceMap();
                    produceProcess = 2;
                    break;
                }
                case 2: {
                    _scene.produceSector();
                    produceProcess = 3;
                    break;
                }
                case 3: {
                    _scene.produceUnit();
                    produceProcess = 4;
                    break;
                }
                case 4: {
                    _scene.produceActor();
                    _scene.produceNeedActor();
                    produceProcess = 5;
                    break;
                }
                case 5: {
                    _scene.produceInitParameter(n);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return false;
    }

    public void produceMazeInstance(GameMainLogic gameMainLogic, int n) {
    }

    public static Scene produceInstance(GameMainLogic gameMainLogic, int n) {
        Scene scene = new Scene();
        scene._bk = new TiledBackground(320, 240);
        scene._mainLogic = gameMainLogic;
        int n2 = n / 10;
        int n3 = n % 10;
        _is = StreamReader.openDataFile("/res/scene" + n2 + ".bin", n3);
        return scene;
    }

    public void produceMap() throws IOException {
        this._sectorWidth = StreamReader.readShort(_is);
        this._sectorHeight = StreamReader.readShort(_is);
        String string = StreamReader.readString(_is);
        int n = _is.read();
        byte by = StreamReader.readByte(_is);
        int n2 = StreamReader.readByte(_is);
        n2 = this.checkMapFlip(this._id, n2);
        this._bk.load(n2);
    }

    public void produceSector() throws IOException {
        int n;
        int n2;
        this._types = _is.read();
        int n3 = 0;
        while (n3 < this._types) {
            this._typesLoad[n3][0] = StreamReader.readByte(_is);
            if (this._typesLoad[n3][0] < 0) {
                int[] nArray = this._typesLoad[n3];
                nArray[0] = nArray[0] + 256;
            }
            byte by = StreamReader.readByte(_is);
            this._typesLoad[n3][1] = StreamReader.readByte(_is) + by;
            ++n3;
        }
        this._executeInsts = new Actor[60];
        this._sectorNum = this._bk.getMapHeight() / this._sectorHeight * (this._bk.getMapWidth() / this._sectorWidth);
        this._sectorCaptorId = new int[this._sectorNum][];
        n3 = 0;
        while (n3 < this._sectorNum) {
            n2 = StreamReader.readByte(_is);
            if (n2 > 0) {
                this._sectorCaptorId[n3] = new int[n2];
                n = 0;
                while (n < n2) {
                    this._sectorCaptorId[n3][n] = StreamReader.readInt(_is);
                    ++n;
                }
            }
            ++n3;
        }
        if (this._id == 81) {
            StreamReader.readByte(_is);
        } else {
            _globalActorNum = StreamReader.readByte(_is);
            _globalActorId = new int[_globalActorNum];
            n3 = 0;
            while (n3 < _globalActorNum) {
                Scene._globalActorId[n3] = StreamReader.readInt(_is);
                ++n3;
            }
        }
        this._sectorActorId = new int[this._sectorNum][];
        n3 = 0;
        while (n3 < this._sectorNum) {
            n2 = _is.read();
            if (n2 > 0) {
                this._sectorActorId[n3] = new int[n2];
                n = 0;
                while (n < n2) {
                    this._sectorActorId[n3][n] = StreamReader.readInt(_is);
                    ++n;
                }
            }
            ++n3;
        }
    }

    public void produceUnit() throws IOException {
        this.loadUnitData(_is);
        _is.close();
        _is = null;
    }

    public void produceActor() {
        int n = 0;
        while (n < this._types) {
            Animation.load(this._typesLoad[n][0], 2);
            this.createActorPool(this._typesLoad[n][0], this._typesLoad[n][1]);
            ++n;
        }
    }

    public void produceInitParameter(int n) {
    }

    public int checkMapFlip(int n, int n2) {
        if (n2 >= 50 && n2 <= 90) {
            return n2 -= 50;
        }
        this._bk.setFlipMapFlag(false);
        return n2;
    }

    public void createActorPool(int n, int n2) {
        if (n < 0) {
            n += 256;
        }
        if (this._actorPool[n] != null) {
            return;
        }
        this._actorPool[n] = new Actor[n2];
        int n3 = 0;
        while (n3 < n2) {
            this._actorPool[n][n3] = Actor.createActor(n, Animation.getAnimation(n));
            ++n3;
        }
    }

    public void produceNeedActor() {
    }

    public void loadUnitData(InputStream inputStream) {
        try {
            int n = StreamReader.readByte(inputStream);
            this._unitData = new UnitData[n];
            int n2 = 0;
            while (n2 < n) {
                this._unitData[n2] = UnitData.produceUnitData(inputStream);
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public UnitData getUnitData(int n) {
        UnitData[] unitDataArray = this._unitData;
        int n2 = 0;
        int n3 = unitDataArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = unitDataArray[n4].getId();
            if (n5 == n) {
                return unitDataArray[n4];
            }
            if (n5 < n) {
                n2 = ++n4;
                continue;
            }
            n3 = --n4;
        }
        return null;
    }

    public void updateScriptState() {
        UnitData[] unitDataArray = this._unitData;
        int n = unitDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            unitDataArray[n2].setUpdateFlag();
            ++n2;
        }
    }

    public void initSceneEffect(int n, int n2, int n3) {
    }

    public UnitData getCurUnitData() {
        return null;
    }

    public void setPoemsInfo(int n) {
    }

    public void speak(int n, String string, int n2, int n3) {
    }

    public void setSceneEffect(int n, int n2) {
    }

    public void resetRole() {
    }

    public void changeToStartShow() {
    }

    public void setInfo(String string) {
    }

    public void startupRest() {
    }

    public void changeToShop(int n) {
    }

    public boolean isAllRoleFinishWalk() {
        return false;
    }

    public void creatAllRole() {
    }

    public void disposeAllRole() {
    }

    public void teamIn() {
    }

    public boolean isFinishShowInfo() {
        return this._messageBox == null;
    }

    public int getResult() {
        return 0;
    }

    public void passLevel(int n, int n2, int n3) {
        switch (n) {
            case 90: 
            case 91: 
            case 92: {
                GameMainLogic.getInterface().changtoCity(n - 90);
                break;
            }
            default: {
                RoleTeamData roleTeamData = RoleTeamData.getInstance();
                roleTeamData.setNextSceneInfo(n, n2 * this._bk._bktw + (this._bk._bktw >> 1), n3 * this._bk._bkth + (this._bk._bkth >> 1));
                roleTeamData.changeTeamLeader(this.getMainActor().getAniInx());
                this._state = 1;
                this.getMainActor().stop();
                roleTeamData.setRoleAction(this.getMainActor()._action);
                this._mainLogic.changeToInterface(7);
            }
        }
    }

    public void question(String string, String string2, String string3) {
    }

    public void springBattle(int[] nArray, int n, int n2, boolean bl) {
        this._battleInfoBK = n;
        this._battleInfoFK = n2;
        GameRule gameRule = GameRule.getInstance();
        gameRule.setEnemyBattleTeam(nArray);
        this.changeToBattle(bl);
    }

    public void springBattle(int[] nArray, int n, int n2) {
        this._battleInfoBK = n;
        this._battleInfoFK = n2;
        GameRule gameRule = GameRule.getInstance();
        gameRule.setEnemyBattleTeam(nArray);
        this.changeToBattle(gameRule.canEscape(nArray));
    }

    public void changeToBattle(boolean bl) {
        this._mainLogic.changeToBattle(this._battleInfoBK, this._battleInfoFK, bl);
    }

    public boolean isFocusInCamera() {
        return false;
    }

    public boolean battleScriptCondition() {
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        int n = scriptDriver.getScenarioExec().getCurExecInx();
        return n >= scriptDriver.getScenarioExec()._scriptParser.length - 1;
    }

    public void sort(Actor[] actorArray, int n) {
        int n2 = 0;
        while (n2 < n - 1) {
            int n3 = n2;
            int n4 = n2 + 1;
            while (n4 < n) {
                if (this.compare(actorArray[n4], actorArray[n3])) {
                    n3 = n4;
                }
                ++n4;
            }
            if (n2 != n3) {
                Actor actor = actorArray[n2];
                actorArray[n2] = actorArray[n3];
                actorArray[n3] = actor;
            }
            ++n2;
        }
    }

    public boolean compare(Actor actor, Actor actor2) {
        if (actor == null || actor2 == null) {
            return false;
        }
        if (actor.getPriority() < actor2.getPriority()) {
            return true;
        }
        if (actor.getPriority() > actor2.getPriority()) {
            return false;
        }
        return actor._y < actor2._y;
    }

    public static boolean isGloabalId(int n) {
        int n2 = 0;
        while (n2 < _globalActorNum) {
            if (n == _globalActorId[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final void changeToMenu() {
        this._preState = this._state;
        this._state = 4;
        Function.initAlphaArray(0, 50);
        this._menuInx = 0;
    }

    public void changeToShowEuip() {
        this._mainLogic.changeToInfoPanel();
        this._mainLogic.resetCurKey();
        GameInfo.getInstance().changeInterface(3);
    }

    public void changeToAutoShow(int n) {
        this._mainLogic.changeToInfoPanel();
        this._mainLogic.resetCurKey();
        GameInfo.getInstance().changeInterface(n);
    }

    public void paintMenu(Graphics graphics) {
        int n = 240 - C_MENU_HEIGHT;
        int n2 = 5;
        int n3 = (n2 + 2) * Function.C_WORD_W;
        int n4 = 160 - n3 / 2;
        int n5 = n + C_MENU_HEIGHT / 2;
        Function.drawAlpha(graphics, 0, 0, 320, 240);
        Function.fillScreen(graphics, 0, n, 320, C_MENU_HEIGHT, 16711366);
        graphics.setClip(0, 0, 320, 240);
        graphics.setClip(0, n, 320, C_MENU_HEIGHT);
        int[] nArray = Function.C_COLOR_SCENE_MENU_FRAME;
        int n6 = n;
        int n7 = 0;
        while (n7 < nArray.length) {
            graphics.setColor(nArray[n7]);
            graphics.drawLine(0, n6, 320, n6);
            --n6;
            ++n7;
        }
        String string = GameParameter.C_MENU_ITEM[this._menuInx];
        if (this._menuInx == 2) {
            string = string + (Function.isSound() ? GameParameter.KAI : GameParameter.GUAN);
        }
        graphics.setColor(0xFDFDFD);
        Function.drawString(graphics, string, 160, 220, 0x10 | 1);
        if (this._mainLogic.isPressConfirmKey()) {
            this.menuConfirmHandle(this._menuInx);
            this._mainLogic.resetCurKey();
            return;
        }
        int n8 = GameParameter.C_MENU_ITEM.length;
        int n9 = this._mainLogic.getCurKey();
        this._mainLogic.resetCurKey();
        switch (n9) {
            case 1: 
            case 3: {
                --this._menuInx;
                if (this._menuInx >= 0) break;
                this._menuInx = 0;
                break;
            }
            case 5: 
            case 7: {
                ++this._menuInx;
                if (this._menuInx < n8) break;
                this._menuInx = n8 - 1;
            }
        }
    }

    public void changeToSaveSuccess() {
        this._state = 7;
        this._messageBox = MessageBox.getInstance(this);
        this._messageBox.initSingleScrollStyle(GameParameter.C_SCENE_INFO[4]);
    }

    public void menuConfirmHandle(int n) {
        switch (n) {
            case 0: {
                this._state = this._preState;
                break;
            }
            case 1: {
                this.changeToSaveSuccess();
                break;
            }
            case 2: {
                Function.changeSound();
                break;
            }
            case 3: {
                this._mainLogic.changeToInterface(10);
                break;
            }
            case 4: {
                this._mainLogic.changeToInterface(11);
                break;
            }
            case 5: {
                this._mainLogic.changeToInterface(2);
            }
        }
    }

    public void gameHelp(Graphics graphics) {
        if (this._mainLogic.isPressCancelKey()) {
            this._state = 4;
            this._mainLogic.resetCurKey();
        }
    }

    public void gameAbout(Graphics graphics) {
        if (this._mainLogic.isPressCancelKey()) {
            this._state = 4;
            this._mainLogic.resetCurKey();
        }
    }

    public void initStatePlaying() {
    }

    public void finishHandle(int n) {
    }

    static {
        C_MENU_HEIGHT = Function.C_WORD_H + 6;
    }
}

