/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.game.Actor;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.ScriptDriver;
import com.sinaflying.game.UnitData;
import com.sinaflying.script.SceneExecutor;
import com.sinaflying.script.Script;
import javax.microedition.lcdui.Graphics;

public abstract class NPCActor
extends Actor {
    protected UnitData _data;
    public Actor _box;
    public static final int C_TRIGGER_KIND_NONE = 0;
    public static final int C_TRIGGER_KIND_COLLIDE_AND_KEY = 1;
    public static final int C_TRIGGER_KIND_COLLIDE = 2;
    public static final int C_TRIGGER_KIND_AUTO = 3;

    public NPCActor(int n, Animation animation) {
        super(n, animation);
    }

    public boolean init(UnitData unitData) {
        this._data = unitData;
        return super.init(unitData);
    }

    public void disActive() {
        this._data = null;
        super.disActive();
    }

    public void disLife() {
        this._data = null;
        super.disLife();
    }

    public void disLifeInst() {
        this._scene.disLifeInst(this._id);
    }

    protected boolean scriptHandle() {
        if (this.isMatchTriggerCondition()) {
            return this.triggerScript();
        }
        return false;
    }

    public boolean collideTalk() {
        RoleActor roleActor = this._scene.getMainActor();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n3 = -24 + this._t;
        n4 = 24 + this._b;
        n = -32 + this._l;
        n2 = 32 + this._r;
        if (n == n2 || n3 == n4) {
            return false;
        }
        return roleActor.collide(n += this._x >> 10, n3 += this._y >> 10, n2 += this._x >> 10, n4 += this._y >> 10);
    }

    protected boolean isMatchTriggerCondition() {
        if (this._data == null) {
            return false;
        }
        int n = this._data.GetTriggerKind();
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isPressConfirmKey() && this.isCollideMain();
            }
            case 2: {
                return this.isCollideMain();
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        super.draw(graphics, n, n2, n3);
    }

    public final boolean isPressConfirmKey() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        return gameMainLogic.getCurKey() == 4;
    }

    public final boolean isCollideMain() {
        if (this._l == 0 && this._r == 0 && this._t == 0 && this._b == 0) {
            return false;
        }
        RoleActor roleActor = this._scene.getMainActor();
        int n = (roleActor._x >> 10) + roleActor._l;
        int n2 = (roleActor._x >> 10) + roleActor._r;
        int n3 = (roleActor._y >> 10) + roleActor._t;
        int n4 = (roleActor._y >> 10) + roleActor._b;
        if (n == n2 || n3 == n4) {
            return false;
        }
        int n5 = (this._x >> 10) + this._l;
        int n6 = (this._x >> 10) + this._r;
        int n7 = (this._y >> 10) + this._t;
        int n8 = (this._y >> 10) + this._b;
        return n6 >= n && n5 <= n2 && n8 >= n3 && n7 <= n4;
    }

    protected boolean triggerScript() {
        Script[] scriptArray = this._data.getScript();
        if (scriptArray != null) {
            ScriptDriver scriptDriver = ScriptDriver.getInstance();
            if (this._scene._executor == null) {
                GameMainLogic.getInstance();
                this._scene._executor = new SceneExecutor(GameMainLogic.getGraphics(), this._scene);
            }
            return scriptDriver.addScript(scriptArray, this._scene._executor);
        }
        return false;
    }
}

