/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.effect.FireFly;
import com.sinaflying.engine.Animation;
import com.sinaflying.engine.SptSet;
import com.sinaflying.game.Actor;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.gameUtil.Menu;
import com.sinaflying.gameUtil.MenuHandler;
import com.sinaflying.gameUtil.MessageBox;
import com.sinaflying.gameUtil.MessageBoxHandler;
import com.sinaflying.other.ThingInterface;
import com.sinaflying.util.Function;
import com.sinaflying.util.StreamReader;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameInterface
implements MessageBoxHandler,
MenuHandler {
    public static final int GAME_TITLE = 0;
    public static final int GAME_LOADGLOBAL = 1;
    public static final int GAME_LOGO = 15;
    public static final int GAME_MENU = 2;
    public static final int GAME_LOADLEVEL = 4;
    public static final int GAME_CONFIRM_CLEAR_RECORD = 5;
    public static final int GAME_LOAD_MENU_PNG = 6;
    public static final int GAME_PASSLEVEL = 7;
    public static final int GAME_OVER = 8;
    public static final int GAME_WIN = 9;
    public static final int GAME_HELP = 10;
    public static final int GAME_ABOUT = 11;
    public static final int GAME_SOUND_TIP = 14;
    public static final int GAME_SOUND_SEL = 16;
    public static final int GAME_EXIT_TIP = 17;
    public static final int GAME_PRESS_KEY = 18;
    public static final int GAME_MENU_WAIT = 19;
    public static final int GAME_SELECT_PARA = 20;
    public static final int GAME_CITY_INFO = 21;
    public static final int GAME_EFECT_DEMO = 22;
    public static final int GAME_WAVE = 23;
    public static final int GAME_SOUND = 24;
    public static final int GAME_LOAD = 25;
    public static final int GAME_EXIT_PART = 26;
    private int _menuItem;
    private int _keyFlag;
    private int _loadProcess;
    private int _state;
    public int _preState;
    private GameMainLogic _mainLogic;
    public static final int MENU_NEWGAME = 0;
    public static final int MENU_CONTINUE = 1;
    public static final int MENU_SOUND = 2;
    public static final int MENU_HELP = 4;
    public static final int MENU_ABOUT = 5;
    public static final int MENU_EXIT = 6;
    private static final int[] C_GAME_MENU_SPT_ID = new int[]{10, 11, 15, 24, 13, 14, 12};
    private long _ctime;
    private long _stime;
    private static Image[] _image = new Image[5];
    public static Image[] _logoImages = new Image[8];
    public static Image[] _bkImage = new Image[5];
    public static final int IMAGE_INDEX_CITY_SUN = 0;
    public static final int IMAGE_INDEX_CITY_MOON = 1;
    public static final int IMAGE_INDEX_LOGO = 2;
    public static final int IMAGE_INDEX_TITLE = 3;
    public static final int IMAGE_INDEX_CG1 = 4;
    public static final int IMAGE_INDEX_CG2 = 5;
    public static final int IMAGE_INDEX_CG3 = 6;
    private static boolean[] _isFirstTime = new boolean[GameParameter.city_name.length];
    public static final int GAME_RETURNMENU_TIP = 27;
    public static final int GAME_QQ = 202;
    private int _soundButtonX;
    private int _soundVolume;
    private int _soundButtonOffsetX;
    private int _soundBarLen;
    private static final int MAX_SOUND = 80;
    private int _descriptionX;
    private int _descriptionY;
    private int _descriptionH;
    private String[] title;
    public static final int SOUND_UNIT = 4;
    private static int[] _info = new int[5];
    private int _next;
    private String _text;
    private boolean _end;
    public int _executeProcess;
    private static final int C_LOAD_TOP_COLOR = 16776368;
    private static final int C_LOAD_BOTTOM_COLOR = 13452288;
    private static final int C_LOAD_PROCESS_W = 300;
    private static final int C_LOAD_PROCESS_Y = 205;
    private static final int C_LOAD_SPEED = 32;
    private static final int C_LOAD_GLOBAL_INFO_COLOR = 16776368;
    private int _ticks = -1;
    private int _logoProcess = 0;
    private int _curBk;
    private boolean _openAlpha;
    Actor[] actors = new Actor[7];
    private int _bkX;
    private int _bkY;
    protected Actor[] _effectActor = new Actor[20];
    protected int[] _effectActorCount = new int[20];
    public static final int BIRD_FRAME_NUM = 70;
    public static final int FLOW_FRAME_NUM = 25;
    private int _overStrLX;
    private int _overStrLY;
    private int _overStrRX;
    private int _overStrRY;
    private int _strIndex;
    private int _maxIndex;
    private static final int C_SOFT_KEY_SPACE_X = 10;
    private static final int C_SOFT_KEY_SPACE_Y = 8;
    public static final int GAME_INFO_BATTLE = 0;
    public static final int GAME_INFO_SCENE = 1;
    public static final int GAME_INFO_SCENE_ROLE = 2;
    public static final int GAME_INFO_BATTLE_ROLE = 3;
    public static final int GAME_INFO_BATTLE_SCENARIO = 4;
    public static final int GAME_INFO_MAIN_LEVEL = 5;
    public static final int GAME_INFO_MAIN_EXPERIENCE = 6;
    public static final int GAME_INFO_MAIN_MONEY = 7;
    private static String[] _paraInfo = new String[]{"\u602a\u7269\u89e6\u53d1\u6218\u6597", "\u573a\u666f\u5207\u6362", "\u573a\u666f\u4e2d\u7684\u4e3b\u89d2\u63a7\u5236", "\u6218\u6597\u4e2d\u4e3b\u89d2\u63a7\u5236", "\u5267\u60c5\u4e4b\u4fee\u6539", "\u4e3b\u89d2\u7b49\u7ea7", "\u4e3b\u89d2\u7ecf\u9a8c", "\u4eba\u6c11\u5e01"};
    public static int[] _paraValue;
    public static boolean _openPramInfo;
    public static boolean _closePartInfo;
    private int _infoItem;
    private int _valueIndex;
    private int _infoX;
    private int _infoY;
    public static final int CITY_MOVE_CAMERE = 0;
    public static final int CITY_DOWN_MENU = 1;
    public static final int CITY_COMMAND = 2;
    public int cityProcess;
    public Image _city;
    public int _cityX;
    public int _cityMenuYOffset;
    public int _cityIndex;
    public int _curCityMenuIndex;
    public int _curCityFrameIndex;
    public String _curCityPos;
    public String[] _curCityMenu;
    public int[][] _curCityData;
    public MessageBox _messageBox;
    public int _panelIndex;
    private int _rmsPageTimeX;
    private int _rmsPageTimeY;
    private int _drawStartX;
    private int _drawStartY;
    private int _roleStartX;
    private int _roleStartY;
    private int _roleSpace;
    private int _drawH;
    private boolean[][] _roles;
    private boolean[] _existRms;
    private Actor[][] _roleActors;
    private Animation[][] _rolesAni;
    RoleTeamData _teamData;
    private int _rmsPageState;
    private static final int PAGE_BROWSE = 0;
    private static final int PAGE_HANDLE = 1;
    private static final int LOAD_GAME = 0;
    private static final int SAVE_GAME = 1;
    private int _loadState = 0;
    Menu _menu;
    private String[] _title;
    private int _curRmsIndex = 0;
    private static final int MAX_RMS_NUM = 2;
    private int[] _rmsGameTimeHour = new int[2];
    private int[] _rmsGameTimeMinut = new int[2];
    private int _curFramBird = 0;
    private int _curFramBird2 = 3;
    private int _curFramBird3 = 0;
    private int _curFram1 = 0;
    private int _curFram2 = 0;
    private int _curFram3 = 0;
    private int _curFram5 = 0;
    private int _curFram7 = 0;
    private int _curFramBoat = 0;
    private int _time1 = 0;
    private int _time5 = 0;
    private int _timeBoat = 0;
    private int _timeBoat1 = 0;
    private int _v2 = -1;
    private int _v3 = -1;
    private int _v5 = 1;
    private int _flipX = 0;
    private int _flipX3 = Integer.MIN_VALUE;
    private int _flipX5 = 0;
    private int _tempDx2 = 0;
    private int _tempDx3 = 0;
    private int _tempDx5 = 0;
    private int _tempDxBoat = 0;
    private int _tempDyBoat = 0;
    private int _time3 = 0;
    private int _timeBird = 0;
    private int _timeBird1 = 0;
    private int _timeBird11 = 0;
    private int _zoomX1 = -1;
    private int _zoomX2 = 5;
    private int _zoomX3 = 0;
    private int _timeVx = 0;
    private int _birdX1 = 640;
    private int _birdY1 = 120;
    private int _birdX2 = 660;
    private int _birdY2 = 140;
    private int _birdX3 = 0;
    private int _birdY3 = 120;
    private int _boatVx = -1;
    private int _boatVy = -1;
    private int _boatStat = 0;
    private FireFly _ff;

    public GameInterface(GameMainLogic gameMainLogic) {
        this._mainLogic = gameMainLogic;
        this._loadProcess = 0;
        this._state = 0;
        this.formatRmsPage();
    }

    private void gameReturn(Graphics graphics) {
        String string;
        String string2;
        this.drawDefaultBackground(graphics);
        graphics.setColor(16442677);
        graphics.drawRect(4, 4, 312, 232);
        graphics.setColor(14219722);
        graphics.drawRect(5, 5, 310, 230);
        Function.draw3DString(graphics, "\u662f\u5426\u8fd4\u56de\u4e3b\u83dc\u5355", 160, 120, 0x10 | 1, 11878689, 0xFFFFFF);
        int n = 232;
        int n2 = 0;
        int n3 = 16771377;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = GameParameter.C_GAME_INFO[3];
            string = GameParameter.C_GAME_INFO[4];
        } else {
            string2 = GameParameter.C_GAME_INFO[4];
            string = GameParameter.C_GAME_INFO[3];
        }
        Function.draw3DString(graphics, string2, 10, n, 4 | 0x20, n2, n3);
        Function.draw3DString(graphics, string, 310, n, 8 | 0x20, n2, n3);
        boolean bl = false;
        if (this._mainLogic.isPressConfirmKey()) {
            Function.stopSound();
            this.changeToMenu();
            bl = true;
        } else if (this._mainLogic.isPressCancelKey()) {
            this._mainLogic._state = this._state == 26 ? 3 : 3;
            bl = true;
        }
        if (bl) {
            this._mainLogic.setShowTouch();
            this._mainLogic.resetCurKey();
        }
    }

    public final void paint(Graphics graphics) {
        switch (this._state) {
            case 202: {
                this.gameQQ(graphics);
                break;
            }
            case 0: {
                this.gameTitle(graphics);
                break;
            }
            case 1: {
                this.gameLoadGlobal(graphics);
                break;
            }
            case 15: {
                this.gameLogoProcess(graphics);
                break;
            }
            case 18: {
                this.gamePressKey(graphics);
                break;
            }
            case 5: {
                this.gameConfirmClearRecord(graphics);
                break;
            }
            case 4: {
                this.gameLoading(graphics);
                break;
            }
            case 14: {
                this.gamePlaySoundTip(graphics);
                break;
            }
            case 2: {
                this.gameMenu(graphics);
                break;
            }
            case 7: {
                this.gamePassLevel(graphics);
                break;
            }
            case 10: {
                this.gameHelp(graphics);
                break;
            }
            case 11: {
                this.gameAbout(graphics);
                break;
            }
            case 9: {
                this.gameWin(graphics);
                break;
            }
            case 8: {
                this.gameOver(graphics);
                break;
            }
            case 17: 
            case 26: {
                this.gameExit(graphics);
                break;
            }
            case 27: {
                this.gameReturn(graphics);
                break;
            }
            case 20: {
                this.gameItemSelect(graphics);
                break;
            }
            case 21: {
                this.cityInterface(graphics);
                break;
            }
            case 24: {
                this.gameSound(graphics);
                break;
            }
            case 25: {
                this.gameLoadUI(graphics);
                this.updateForLoadUI();
            }
        }
    }

    public void initSound() {
        this._soundButtonX = 160 - Function.PANEL.getSptWidth(41) / 2;
        this._soundVolume = Function.getSoundValue();
        this._soundBarLen = Function.PANEL.getSptWidth(41) - Function.PANEL.getSptWidth(3);
        this._soundButtonOffsetX = this._soundBarLen * this._soundVolume / 80;
        this._descriptionX = 32;
        this._descriptionY = 177;
        this._descriptionH = 240 - this._descriptionY - 5;
        this.title = new String[]{"\u58f0\u97f3"};
    }

    private void gameSound(Graphics graphics) {
        Function.drawBK(graphics, false, true, false, "", "");
        Function.drawTitle(graphics, 0, this.title);
        Function.PANEL.draw(graphics, 160, 96, 41, 1 | 0x10);
        Function.PANEL.draw(graphics, this._soundButtonX + this._soundButtonOffsetX, 103, 3, 4 | 0x10);
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        Function.drawString(graphics, "\u5f00", 160 + Function.PANEL.getSptWidth(41) / 2 + 10, 96, 0x10 | 4);
        Function.drawString(graphics, "\u5173", 160 - Function.PANEL.getSptWidth(41) / 2 - 10, 96, 0x10 | 8);
        Function.drawRollStrings(graphics, GameParameter.SOUND, this._descriptionX, this._descriptionY, Function.C_WORD_SPACE_Y, this._descriptionH, Function.C_WORD_W, 0);
        graphics.setClip(0, 0, 320, 240);
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        if (gameMainLogic.isPressConfirmKey()) {
            return;
        }
        if (gameMainLogic.isPressCancelKey()) {
            this._state = this._preState;
            this._mainLogic._state = this._mainLogic._preState;
            gameMainLogic.resetCurKey();
            if (this._state == 2) {
                // empty if block
            }
            return;
        }
        int n = gameMainLogic.getCurKey();
        gameMainLogic.resetCurKey();
        switch (n) {
            case 1: {
                break;
            }
            case 7: {
                break;
            }
            case 3: {
                this._soundVolume -= 20;
                if (this._soundVolume < 0) {
                    this._soundVolume = 0;
                } else {
                    this._soundButtonOffsetX -= this._soundBarLen / 4;
                }
                Function.setSoundValue(this._soundVolume);
                break;
            }
            case 5: {
                this._soundVolume += 20;
                if (this._soundVolume > 80) {
                    this._soundVolume = 80;
                } else {
                    this._soundButtonOffsetX += this._soundBarLen / 4;
                }
                Function.setSoundValue(this._soundVolume);
            }
        }
        Function.drawSoftItem(graphics, 61);
    }

    private final void changeToMenu() {
        this._state = 2;
    }

    public final void changtoCity(int n) {
        this._mainLogic.changeToInterface(21);
        Function.changeSoundState(2, -1);
        this.initCityParameter(n);
    }

    private void gameMenu(Graphics graphics) {
        int n = this._mainLogic.getCurKey();
        this.drawDefaultBackground(graphics);
        this.drawBK(graphics);
        int n2 = C_GAME_MENU_SPT_ID[this._menuItem];
        int n3 = 192 + (Function._spt_125.getSptHeight(10) - Function.C_WORD_H) / 2;
        Function._spt_125.draw(graphics, 160, n3, n2, 0x10 | 1);
        Function.drawArrowUpDown(graphics, 160, n3 + Function.C_WORD_H / 2, 30, true, true);
        if (this._keyFlag >= 10) {
            this._keyFlag = 0;
        }
        if (GameMainLogic.getInstance().isPressConfirmKey()) {
            this.menuConfirmHandle(this._menuItem);
        }
        this._mainLogic.resetCurKey();
        switch (n) {
            case 1: {
                --this._menuItem;
                if (this._menuItem >= 0) break;
                this._menuItem = C_GAME_MENU_SPT_ID.length - 1;
                break;
            }
            case 7: {
                ++this._menuItem;
                if (this._menuItem < C_GAME_MENU_SPT_ID.length) break;
                this._menuItem = 0;
            }
        }
    }

    private final void startNewGame() {
        Function.resetGame();
        this._mainLogic.resetGamePlayingTime();
        this._mainLogic.startRecordGameTime();
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.loadGood();
        GameInterface.resetIsFirstTime();
        this.startupLoadLevel();
        this._mainLogic.clearSceneInfo();
        this._mainLogic.produceSceneInfo();
    }

    private final void menuConfirmHandle(int n) {
        switch (n) {
            case 0: {
                if (Function.isExistRecord()) {
                    this._state = 5;
                    break;
                }
                this.startNewGame();
                break;
            }
            case 1: {
                this.changeState(25);
                this.initGameLoad();
                break;
            }
            case 2: {
                this._mainLogic.changeToInterface(24);
                this._preState = 2;
                break;
            }
            case 3: {
                this._state = 202;
                break;
            }
            case 6: {
                this._state = 17;
                break;
            }
            case 4: {
                this._mainLogic.changeToInterface(10);
                this._preState = 2;
                this.initGameHelp();
                break;
            }
            case 5: {
                this._mainLogic.changeToInterface(11);
                this._preState = 2;
            }
        }
    }

    public final void gameTitle(Graphics graphics) {
        if (this._loadProcess == 0) {
            this.loadGameLogo();
            GameParameter.loadPlaceName();
            GameParameter.loadGameSctipt();
            ++this._loadProcess;
            this._stime = System.currentTimeMillis();
        } else if (this._loadProcess == 1) {
            graphics.setColor(255, 148, 0);
            graphics.fillRect(0, 0, 320, 240);
            graphics.drawImage(_image[0], 160, (240 - _image[0].getHeight()) / 2, 1 | 0x10);
            this._ctime = System.currentTimeMillis();
            if (this._ctime - this._stime > 1700L) {
                ++this._loadProcess;
                this._stime = System.currentTimeMillis();
                GameInterface._image[0] = null;
            }
        } else if (this._loadProcess == 2) {
            Function.fillScreen(graphics, 0, 0, 320, 240, 0xFFFFFF);
            graphics.drawImage(_image[2], 160, (240 - _image[2].getHeight()) / 2, 1 | 0x10);
            this._ctime = System.currentTimeMillis();
            if (this._ctime - this._stime > 1700L) {
                ++this._loadProcess;
                this._stime = System.currentTimeMillis();
                GameInterface._image[1] = null;
                GameInterface._image[2] = null;
            }
        } else if (this._loadProcess == 3) {
            ++this._loadProcess;
        } else if (this._loadProcess == 4) {
            ++this._loadProcess;
        } else if (this._loadProcess == 5) {
            Function.fillScreen(graphics, 0, 0, 320, 240, 0);
            graphics.setColor(16776368);
            Function.drawString(graphics, GameParameter.C_GAME_INFO[6], 160, 240 - Function.C_WORD_H * 2, 0x20 | 1);
            this.callEnterGame();
        }
    }

    private final void loadGameLogo() {
        GameInterface._image[0] = StreamReader.loadPng("/res/logo.bin", 0);
        GameInterface._image[2] = StreamReader.loadPng("/res/logo.bin", 2);
    }

    private void loadGlobalData() {
        this._mainLogic.loadGlobalData();
        this.loadBkImageByte();
        this.initialize();
    }

    private void loadBkImageByte() {
    }

    private final void initialize() {
        this._menuItem = 0;
        this._state = 14;
    }

    public void initGameHelp() {
        this._text = StreamReader.readTextFile("/res/string.bin", 0, _info);
        this._next = 0;
    }

    private final void gameHelp(Graphics graphics) {
        int n;
        int n2;
        Function.drawBK(graphics, false, false, false, "", "");
        Function.drawTitle(graphics, 0, GameParameter.TITLE_HELP);
        if (_info[0] > _info[1]) {
            n2 = this._next / _info[1] + 1;
            n = 1 + _info[0] / _info[1];
            StringBuffer stringBuffer = new StringBuffer().append(n2).append("/").append(n);
            graphics.setClip(0, 0, 320, 240);
            graphics.setColor(0);
            Function.drawString(graphics, stringBuffer.toString(), 160, 240 - Function.C_WORD_H, 0x20 | 1);
        }
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        n2 = Function.drawHelpAboutString(graphics, this._text, this._next, _info[1], 160, _info[3], _info[4], 1 | 0x10) ? 1 : 0;
        n = this._mainLogic.getCurKey();
        if (n == 5) {
            if (n2 == 0) {
                this._next += _info[1];
            }
            this._mainLogic.resetCurKey();
        } else if (n == 3) {
            if (this._next > 0) {
                this._next -= _info[1];
            }
            this._mainLogic.resetCurKey();
        }
        if (this._mainLogic.isPressCancelKey()) {
            this._state = this._preState;
            this._mainLogic._state = this._mainLogic._preState;
            this._mainLogic.resetCurKey();
        }
        Function.drawSoftItem(graphics, 61);
    }

    public void initGameAbout() {
        this._text = StreamReader.readTextFile("/res/string.bin", 1, _info);
        this._next = 0;
    }

    private final void gameAbout(Graphics graphics) {
        int n;
        int n2;
        Function.drawBK(graphics, false, false, false, "", "");
        Function.drawTitle(graphics, 0, GameParameter.TITLE_ABOUT);
        if (_info[0] > _info[1]) {
            n2 = this._next / _info[1] + 1;
            n = 1 + _info[0] / _info[1];
            StringBuffer stringBuffer = new StringBuffer().append(n2).append("/").append(n);
            graphics.setClip(0, 0, 320, 240);
            graphics.setColor(0);
            Function.drawString(graphics, stringBuffer.toString(), 160, 240 - Function.C_WORD_H, 0x20 | 1);
        }
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        n2 = Function.drawHelpAboutString(graphics, this._text, this._next, _info[1], 160, _info[3], _info[4], 1 | 0x10) ? 1 : 0;
        n = this._mainLogic.getCurKey();
        if (n == 5) {
            if (n2 == 0) {
                this._next += _info[1];
            }
            this._mainLogic.resetCurKey();
        } else if (n == 3) {
            if (this._next > 0) {
                this._next -= _info[1];
            }
            this._mainLogic.resetCurKey();
        }
        if (this._mainLogic.isPressCancelKey()) {
            this._state = this._preState;
            this._mainLogic._state = this._mainLogic._preState;
            this._mainLogic.resetCurKey();
        }
        Function.drawSoftItem(graphics, 61);
    }

    private final void resetExecuteProcess() {
        this._executeProcess = 0;
    }

    private void gameLoadGlobal(Graphics graphics) {
        this.loadGlobalData();
    }

    private void gameLoading(Graphics graphics) {
        int n = 70;
        int n2 = 240 - n;
        Function.fillScreen(graphics, 0, n2, 320, n, 0);
        this._mainLogic.loadLevelData00(graphics);
        this.drawProcess0(graphics);
    }

    private final void drawProcess(Graphics graphics) {
        int n = 10;
        int n2 = 205;
        this._executeProcess = Math.min(300, this._executeProcess + 300);
        graphics.setColor(16776368);
        graphics.drawLine(n + 1, n2 + 1, n + 1 + this._executeProcess, n2 + 1);
        graphics.drawLine(n + 1, n2 + 3, n + 1 + this._executeProcess, n2 + 3);
        graphics.setColor(13452288);
        graphics.drawLine(n + 1, n2 + 2, n + 1 + this._executeProcess, n2 + 2);
    }

    private final void drawProcess0(Graphics graphics) {
        this._mainLogic.drawLoadProcess(graphics);
    }

    private final void drawInfoBk(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
    }

    private final void changeToLogo() {
        this._state = 15;
        this.initLogoParam();
    }

    private void initLogoParam() {
        this._logoProcess = -2;
        this._ticks = 0;
        this.initRoLeParam();
        GameInterface._logoImages[2] = StreamReader.loadPng("/res/g1.png");
        GameInterface._logoImages[3] = StreamReader.loadPng("/res/g2.png");
        Function.changeSoundState(0, -1);
    }

    private void initPoem() {
        this._messageBox = MessageBox.getInstance(this);
        this._messageBox.initPoemsStyle(Function.poemIds);
    }

    private void initRoLeParam() {
        Animation.load(105, 2);
    }

    private final void gameLogoKey(Graphics graphics) {
        int n = this._mainLogic.getCurKey();
        switch (n) {
            case 131072: {
                if (_logoImages[3] == null) {
                    GameInterface._logoImages[3] = StreamReader.loadPng("/res/g2.png");
                }
                this._logoProcess = 7;
                this._openAlpha = false;
                this._curBk = 3;
                this._mainLogic.resetCurKey();
                this._bkY = 25;
                this._bkX = 320 - _logoImages[3].getWidth() >> 1;
                this.disEffectActor();
                this.disPoems();
            }
        }
    }

    private final void drawPoems(Graphics graphics) {
        if (this._messageBox != null) {
            this._messageBox.draw(graphics);
        }
    }

    private final void disPoems() {
        if (this._messageBox != null) {
            this._messageBox.dispose();
            this._messageBox = null;
        }
    }

    private final void gameLogoProcess(Graphics graphics) {
        this.drawBK(graphics);
        switch (this._logoProcess) {
            case -2: {
                if (--this._ticks >= 0) break;
                this._logoProcess = -1;
                this._curBk = 2;
                this._ticks = 20;
                this._openAlpha = true;
                Function.initAlphaArray(0, this._ticks * 5);
                break;
            }
            case -1: {
                if (--this._ticks < 0) {
                    this.addBird(0, false);
                    this._openAlpha = false;
                    this._ticks = 30;
                    this._logoProcess = 0;
                    break;
                }
                Function.initAlphaArray(0, this._ticks * 5);
                break;
            }
            case 0: {
                if (--this._ticks < 0) {
                    this.initPoem();
                    this.addBird(1, false);
                    this._ticks = 75;
                    this._logoProcess = 1;
                    break;
                }
                if (this._bkX >= 0 || this._bkY >= 0) break;
                ++this._bkX;
                ++this._bkY;
                break;
            }
            case 1: {
                if (--this._ticks < 0) {
                    this.addBird(2, true);
                    this._logoProcess = 2;
                    this._ticks = 20;
                    break;
                }
                if (this._bkX >= 0 || this._bkY >= 0) break;
                ++this._bkX;
                ++this._bkY;
                break;
            }
            case 2: {
                if (--this._ticks >= 0) break;
                this._logoProcess = 3;
                this.addBird(3, true);
                this._ticks = 30;
                break;
            }
            case 3: {
                if (--this._ticks >= 0) break;
                this._logoProcess = 4;
                this._openAlpha = true;
                this._ticks = 50;
                break;
            }
            case 4: {
                if (--this._ticks < 0) {
                    this._logoProcess = 5;
                    this._ticks = 2;
                    break;
                }
                if (this._ticks == 20) {
                    this.disPoems();
                }
                Function.initAlphaArray(0xFFFFFF, 100 - this._ticks * 2);
                break;
            }
            case 5: {
                if (--this._ticks < 0) {
                    this._bkY = 25;
                    this._bkX = 320 - _logoImages[3].getWidth() >> 1;
                    this._curBk = 3;
                    this._logoProcess = 6;
                    this._ticks = 20;
                    break;
                }
                Function.initAlphaArray(0, 100 - this._ticks * 15);
                break;
            }
            case 6: {
                if (--this._ticks < 0) {
                    this._logoProcess = 7;
                    this._openAlpha = false;
                    break;
                }
                Function.initAlphaArray(0, this._ticks * 5);
                break;
            }
            case 7: {
                GameInterface._logoImages[2] = null;
                this._state = 2;
            }
        }
    }

    private final void addBird(int n, boolean bl) {
        Animation.load(126, 2);
        switch (n) {
            case 0: {
                this.addEffectActor(126, 245760, 276480, -13312, 174080, 0, bl);
                break;
            }
            case 1: {
                this.addEffectActor(126, 307200, 256000, -13312, 143360, 0, bl);
                break;
            }
            case 2: {
                this.addEffectActor(126, 0, 122880, 245760, 138240, 0, bl);
                break;
            }
            case 3: {
                this.addEffectActor(126, -51200, 122880, 225280, 148480, 0, bl);
            }
        }
    }

    private final void gamePressKey(Graphics graphics) {
    }

    private final void drawBK(Graphics graphics) {
        if (this._curBk == 0) {
            Function.fillScreen(graphics, 0, 0, 320, 240, 0);
            return;
        }
        if (this._curBk == 3) {
            Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        }
        graphics.setClip(0, 0, 320, 240);
        graphics.drawImage(_logoImages[this._curBk], this._bkX, this._bkY, 0x10 | 4);
        if (this._effectActor[0] != null && this._effectActor[0].getAniInx() == 126) {
            if (this._openAlpha) {
                Function.drawAlpha(graphics, 0, 320, 0, 0, 320, 240, true);
            }
            this.paintEffectActor(graphics, 0);
        } else {
            this.paintEffectActor(graphics, 0);
            if (this._openAlpha) {
                Function.drawAlpha(graphics, 0, 320, 0, 0, 320, 240, true);
            }
        }
        this.updateEffectActor();
        if (this._state == 15) {
            this.gameLogoKey(graphics);
        }
        this.drawPoems(graphics);
    }

    public void addEffectActor(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n6 & 0xFFFF;
        int n8 = 0;
        while (n8 < this._effectActor.length) {
            if (this._effectActor[n8] == null) {
                Animation animation = Animation.getAnimation(n);
                this._effectActor[n8] = Actor.createActor(n, animation);
                this._effectActor[n8].init(n2, n3, n6);
                if (n == 126) {
                    this._effectActor[n8]._vx = (n4 - n2) / 70;
                    this._effectActor[n8]._vy = (n5 - n3) / 70;
                    this._effectActor[n8]._loopAction = true;
                    this._effectActor[n8].openZoomDraw();
                    this._effectActor[n8]._zoomNum = -40;
                    if (bl) {
                        this._effectActor[n8]._zoomNum = -110;
                        this._effectActor[n8].changeAction(Integer.MIN_VALUE);
                    }
                } else {
                    this._effectActor[n8]._vx = (n4 - n2) / 25 * 2;
                    this._effectActor[n8]._vy = (n5 - n3) / 25 * 2;
                    this._effectActor[n8]._avx = -this._effectActor[n8]._vx / 25;
                    this._effectActor[n8]._avy = -this._effectActor[n8]._vy / 25;
                    if (n6 != 1 && n6 != 8) {
                        this._effectActor[n8]._loopAction = true;
                    }
                }
                this._effectActorCount[n8] = 0;
                break;
            }
            ++n8;
        }
    }

    private void disEffectActor() {
        int n = 0;
        while (n < this._effectActor.length) {
            if (this._effectActor[n] != null) {
                this._effectActor[n] = null;
            }
            ++n;
        }
    }

    private void paintEffectActor(Graphics graphics, int n) {
        int n2 = 0;
        while (n2 < this._effectActor.length) {
            if (this._effectActor[n2] != null) {
                this._effectActor[n2].draw(graphics, 0, 0, n);
            }
            ++n2;
        }
    }

    public boolean isEffectActorEmpty() {
        int n = 0;
        while (n < this._effectActor.length) {
            if (this._effectActor[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void updateEffectActor() {
        int n = 0;
        while (n < this._effectActor.length) {
            if (this._effectActor[n] != null) {
                --this._effectActor[n]._zoomNum;
                int n2 = 70;
                if (this._effectActorCount[n] < n2) {
                    this._effectActor[n].step();
                    int n3 = n;
                    this._effectActorCount[n3] = this._effectActorCount[n3] + 1;
                } else if (this._effectActorCount[n] == n2) {
                    this._effectActor[n] = null;
                }
            }
            ++n;
        }
    }

    private void gameExit(Graphics graphics) {
        String string;
        String string2;
        this.drawDefaultBackground(graphics);
        graphics.setColor(16442677);
        graphics.drawRect(4, 4, 312, 232);
        graphics.setColor(14219722);
        graphics.drawRect(5, 5, 310, 230);
        Function.draw3DString(graphics, GameParameter.ISGAMEOVER, 160, 120, 0x10 | 1, 11878689, 0xFFFFFF);
        int n = 232;
        int n2 = 0;
        int n3 = 16771377;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = GameParameter.C_GAME_INFO[3];
            string = GameParameter.C_GAME_INFO[4];
        } else {
            string2 = GameParameter.C_GAME_INFO[4];
            string = GameParameter.C_GAME_INFO[3];
        }
        Function.draw3DString(graphics, string2, 10, n, 4 | 0x20, n2, n3);
        Function.draw3DString(graphics, string, 310, n, 8 | 0x20, n2, n3);
        boolean bl = false;
        if (this._mainLogic.isPressConfirmKey()) {
            this._mainLogic.exitGame();
            bl = true;
        } else if (this._mainLogic.isPressCancelKey()) {
            if (this._state == 26) {
                this._mainLogic._state = 3;
            } else {
                this.changeToMenu();
            }
            bl = true;
        }
        if (bl) {
            this._mainLogic.setShowTouch();
            this._mainLogic.resetCurKey();
        }
    }

    private void gameQQ(Graphics graphics) {
        String string;
        String string2;
        this.drawDefaultBackground(graphics);
        graphics.setColor(16442677);
        graphics.drawRect(4, 4, 312, 232);
        graphics.setColor(14219722);
        graphics.drawRect(5, 5, 310, 230);
        Function.draw3DString(graphics, "\u662f\u5426\u8fde\u63a5\u5230", 160, 100, 0x10 | 1, 11878689, 0xFFFFFF);
        Function.draw3DString(graphics, "QQ\u6e38\u620f\u4e2d\u5fc3", 160, 120, 0x10 | 1, 11878689, 0xFFFFFF);
        int n = 232;
        int n2 = 0;
        int n3 = 16771377;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = GameParameter.C_GAME_INFO[3];
            string = GameParameter.C_GAME_INFO[4];
        } else {
            string2 = GameParameter.C_GAME_INFO[4];
            string = GameParameter.C_GAME_INFO[3];
        }
        Function.draw3DString(graphics, string2, 10, n, 4 | 0x20, n2, n3);
        Function.draw3DString(graphics, string, 310, n, 8 | 0x20, n2, n3);
        boolean bl = false;
        if (this._mainLogic.isPressConfirmKey()) {
            this._mainLogic._smsui.platQQGame();
            bl = true;
        } else if (this._mainLogic.isPressCancelKey()) {
            this.changeToMenu();
            bl = true;
        }
        if (bl) {
            this._mainLogic.setShowTouch();
            this._mainLogic.resetCurKey();
        }
    }

    private final void gameWin(Graphics graphics) {
        this.drawDefaultBackground(graphics);
        graphics.setColor(11878689);
        graphics.drawRect(4, 4, 312, 232);
        graphics.setColor(16759411);
        graphics.drawRect(5, 5, 310, 230);
        Function.draw3DString(graphics, GameParameter.C_GAME_INFO[7], 160, 160, 0x10 | 1, 11878689, 0xFFFFFF);
        int n = 232;
        int n2 = 11878689;
        int n3 = 0xFFFFFF;
        if (this._mainLogic.getConfirmPos() == 0) {
            String string = GameParameter.FANHUI;
            Function.draw3DString(graphics, string, 310, n, 8 | 0x20, n2, n3);
        } else {
            String string = GameParameter.FANHUI;
            Function.draw3DString(graphics, string, 10, n, 4 | 0x20, n2, n3);
        }
        if (this._mainLogic.isPressCancelKey()) {
            this.changeState(2);
        }
    }

    public void initGameOverParameter() {
        Function.initAlphaArray(11936256, 50);
        Function.drawAlpha(GameMainLogic.getGraphics(), 0, 0, 320, 240);
        this._overStrLX = 128;
        this._overStrLY = (240 - this._mainLogic._hight * GameParameter._overStrR.length) / 2;
        this._overStrRX = 192;
        this._overStrRY = Function.C_WORD_H * 2;
        this._strIndex = 0;
        this._maxIndex = (GameParameter._overStrR.length + GameParameter._overStrL.length) * 5;
    }

    private final void gameOver(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        int n = 0;
        while (n < GameParameter._overStrL.length) {
            if (this._strIndex > (n + GameParameter._overStrR.length) * 3) {
                Function.draw3DString(graphics, GameParameter._overStrL[n], this._overStrLX, this._overStrLY + n * (this._mainLogic._hight + 1), 0x10 | 4, 16018209, 16771415);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < GameParameter._overStrR.length) {
            if (this._strIndex > n2 * 3) {
                Function.draw3DString(graphics, GameParameter._overStrR[n2], this._overStrRX, this._overStrRY + n2 * (this._mainLogic._hight + 1), 0x10 | 8, 16018209, 16771415);
            }
            ++n2;
        }
        ++this._strIndex;
        if (this._strIndex > this._maxIndex + 10) {
            this._strIndex = this._maxIndex + 10;
            this.changeToMenu();
        }
    }

    private void gamePassLevel(Graphics graphics) {
        this.startupLoadLevel();
    }

    private void gamePlaySoundSel(Graphics graphics) {
        this.drawDefaultBackground(graphics);
        graphics.setClip(0, 0, 320, 240);
        if (this._mainLogic.isPressCancelKey()) {
            this._state = 2;
            this._mainLogic.resetCurKey();
        }
    }

    private void gamePlaySoundTip(Graphics graphics) {
        String string;
        String string2;
        this.drawDefaultBackground(graphics);
        graphics.setColor(11878689);
        graphics.drawRect(4, 4, 312, 232);
        graphics.setColor(16759411);
        graphics.drawRect(5, 5, 310, 230);
        Function.draw3DString(graphics, GameParameter.C_GAME_INFO[0], 160, 120, 0x10 | 1, 11878689, 0xFFFFFF);
        int n = 232;
        int n2 = 11878689;
        int n3 = 0xFFFFFF;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = GameParameter.C_GAME_INFO[3];
            string = GameParameter.C_GAME_INFO[4];
        } else {
            string2 = GameParameter.C_GAME_INFO[4];
            string = GameParameter.C_GAME_INFO[3];
        }
        Function.draw3DString(graphics, string2, 10, n, 4 | 0x20, n2, n3);
        Function.draw3DString(graphics, string, 310, n, 8 | 0x20, n2, n3);
        boolean bl = false;
        if (this._mainLogic.isPressConfirmKey()) {
            Function.startupSound(true);
            bl = true;
        } else if (this._mainLogic.isPressCancelKey()) {
            Function.startupSound(false);
            bl = true;
        }
        if (bl) {
            this._mainLogic.setShowTouch();
            this._mainLogic.resetCurKey();
            this.changeToLogo();
        }
    }

    private final void gameConfirmClearRecord(Graphics graphics) {
        String string;
        String string2;
        this.drawDefaultBackground(graphics);
        graphics.setColor(11878689);
        graphics.drawRect(4, 4, 312, 232);
        graphics.setColor(16759411);
        graphics.drawRect(5, 5, 310, 230);
        Function.draw3DString(graphics, GameParameter.C_GAME_INFO[5], 160, 160, 0x10 | 1, 11878689, 0xFFFFFF);
        int n = 232;
        int n2 = 11878689;
        int n3 = 0xFFFFFF;
        if (this._mainLogic.getConfirmPos() == 0) {
            string2 = GameParameter.C_GAME_INFO[3];
            string = GameParameter.C_GAME_INFO[4];
        } else {
            string2 = GameParameter.C_GAME_INFO[4];
            string = GameParameter.C_GAME_INFO[3];
        }
        Function.draw3DString(graphics, string2, 10, n, 4 | 0x20, n2, n3);
        Function.draw3DString(graphics, string, 310, n, 8 | 0x20, n2, n3);
        if (this._mainLogic.isPressConfirmKey()) {
            this.changeState(25);
            this.initGameLoad();
        } else if (this._mainLogic.isPressCancelKey()) {
            this.startNewGame();
        }
    }

    public void startupLoadGlobal() {
        this._state = 1;
        this.resetExecuteProcess();
    }

    public void startupLoadLevel() {
        this._state = 4;
        this._mainLogic.initLoadLevelUi();
        this.resetExecuteProcess();
    }

    public void callEnterGame() {
        this.startupLoadGlobal();
    }

    public void drawDefaultBackground(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
    }

    public final void changeState(int n) {
        switch (n) {
            case 8: {
                this.initGameOverParameter();
                this._state = n;
                break;
            }
            case 21: {
                this._state = n;
                break;
            }
            default: {
                this._state = n;
            }
        }
    }

    private void initGamePara() {
        this._state = 20;
        _openPramInfo = true;
        _closePartInfo = false;
        this._infoX = 10;
        this._infoY = (240 - _paraInfo.length * Function.C_WORD_H) / (_paraInfo.length + 1);
        this._infoItem = 0;
        _paraValue = new int[_paraInfo.length];
        int n = 0;
        while (n < _paraInfo.length) {
            GameInterface._paraValue[n] = 0;
            ++n;
        }
        this._valueIndex = 1;
    }

    public static boolean needSetGamePara() {
        return _openPramInfo;
    }

    private void gameItemSelect(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        int n = 0;
        while (n < _paraInfo.length) {
            if (this._infoItem == n) {
                Function.draw3DString(graphics, _paraInfo[n], this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 4, 11878689, 0xFFFFFF);
                Function.draw3DString(graphics, String.valueOf(_paraValue[n]), 320 - this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 8, 11878689, 0xFFFFFF);
            } else {
                Function.draw3DString(graphics, _paraInfo[n], this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 4, 0, 0xFFFFFF);
                Function.draw3DString(graphics, String.valueOf(_paraValue[n]), 320 - this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 8, 0, 0xFFFFFF);
            }
            ++n;
        }
        Function.draw3DString(graphics, "\u4e0b\u4e00\u9879", 2, 238, 0x20 | 4, 11878689, 0xFFFFFF);
        Function.draw3DString(graphics, "\u7ee7\u7eed", 318, 238, 0x20 | 8, 11878689, 0xFFFFFF);
        int n2 = this._mainLogic.getCurKey();
        switch (n2) {
            case 65536: {
                if (++this._infoItem > _paraInfo.length - 1) {
                    this._infoItem = 0;
                }
                this._valueIndex = 1;
                this._mainLogic.resetCurKey();
                break;
            }
            case 131072: {
                int n3 = 0;
                while (n3 < _paraValue.length) {
                    if (_paraValue[n3] != 0) break;
                    ++n3;
                }
                if (n3 >= _paraValue.length) {
                    _openPramInfo = false;
                    _closePartInfo = true;
                }
                this.startNewGame();
                this._mainLogic.resetCurKey();
                break;
            }
            default: {
                this.gameParaSet(this.getNumberOfKey(n2));
                this._mainLogic.resetCurKey();
            }
        }
    }

    private void gameParaSet(int n) {
        if (n < 0) {
            return;
        }
        switch (this._valueIndex) {
            case 0: {
                GameInterface._paraValue[this._infoItem] = n + _paraValue[this._infoItem] * 10;
                break;
            }
            case 1: {
                GameInterface._paraValue[this._infoItem] = n;
            }
        }
        this._valueIndex = this._valueIndex == 0 ? 1 : 0;
    }

    private int getNumberOfKey(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 48: {
                return 0;
            }
        }
        return -1;
    }

    public void initCityParameter(int n) {
        this._cityIndex = n;
        this._curCityPos = GameParameter.city_name[this._cityIndex];
        if (_isFirstTime[this._cityIndex]) {
            this.resetAllcityEffect();
        }
        this._mainLogic._loadWordProcess = 0;
        this._curCityMenuIndex = 0;
        this._curCityFrameIndex = 0;
        this._cityMenuYOffset = 100;
        switch (n) {
            case 2: {
                this._panelIndex = 0;
                break;
            }
            default: {
                this._panelIndex = -1;
            }
        }
        this._city = GameInterface.loadXpngImage("/res/city.bin", 0, this._panelIndex);
        Function.initAlphaArray(3550053, 64);
        this.updateCityMenu();
        if (_isFirstTime[n]) {
            this.cityProcess = 0;
            GameInterface._isFirstTime[n] = false;
            switch (this._cityIndex) {
                case 1: {
                    this._cityX = -160;
                    break;
                }
                default: {
                    this._cityX = 0;
                    break;
                }
            }
        } else {
            this.cityProcess = 1;
            switch (this._cityIndex) {
                case 1: {
                    this._cityX = 0;
                    break;
                }
                default: {
                    this._cityX = -160;
                }
            }
        }
    }

    public void updateCityMenu() {
        block0 : switch (this._curCityFrameIndex) {
            case 0: {
                switch (this._cityIndex) {
                    case 0: {
                        this._curCityMenu = GameParameter.city_first_frame1;
                        break;
                    }
                    case 1: {
                        this._curCityMenu = GameParameter.city_first_frame2;
                        break;
                    }
                    case 2: {
                        this._curCityMenu = GameParameter.city_first_frame3;
                    }
                }
                this._curCityPos = GameParameter.city_name[this._cityIndex];
                break;
            }
            case 1: {
                switch (this._cityIndex) {
                    case 0: {
                        this._curCityMenu = GameParameter.yuhang_second_frame[this._curCityMenuIndex];
                        this._curCityData = GameParameter.yuhang_second_position[this._curCityMenuIndex];
                        this._curCityPos = GameParameter.city_first_frame1[this._curCityMenuIndex];
                        break block0;
                    }
                    case 1: {
                        this._curCityMenu = GameParameter.yuzhou_second_frame[this._curCityMenuIndex];
                        this._curCityData = GameParameter.yuzhou_second_position[this._curCityMenuIndex];
                        this._curCityPos = GameParameter.city_first_frame2[this._curCityMenuIndex];
                        break block0;
                    }
                    case 2: {
                        this._curCityMenu = GameParameter.fengdu_second_frame[this._curCityMenuIndex];
                        this._curCityData = GameParameter.fengdu_second_position[this._curCityMenuIndex];
                        this._curCityPos = GameParameter.city_first_frame3[this._curCityMenuIndex];
                    }
                }
            }
        }
    }

    public void updateCitySceMenu() {
        switch (this._cityIndex) {
            case 0: {
                this._curCityMenu = GameParameter.yuhang_second_frame[this._curCityMenuIndex];
                this._curCityData = GameParameter.yuhang_second_position[this._curCityMenuIndex];
                this._curCityPos = GameParameter.city_first_frame1[this._curCityMenuIndex];
                break;
            }
            case 1: {
                this._curCityMenu = GameParameter.yuzhou_second_frame[this._curCityMenuIndex];
                this._curCityData = GameParameter.yuzhou_second_position[this._curCityMenuIndex];
                this._curCityPos = GameParameter.city_first_frame2[this._curCityMenuIndex];
                break;
            }
            case 2: {
                this._curCityMenu = GameParameter.fengdu_second_frame[this._curCityMenuIndex];
                this._curCityData = GameParameter.fengdu_second_position[this._curCityMenuIndex];
                this._curCityPos = GameParameter.city_first_frame3[this._curCityMenuIndex];
            }
        }
    }

    private void cityInterface(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 320, 240, 0);
        graphics.drawImage(this._city, this._cityX, 240 - this._city.getHeight() >> 1, 4 | 0x10);
        if (this._cityIndex != 2) {
            this.cityEffect(graphics);
            this.cityEffectBoat(graphics);
            this.cityEffectBird(graphics);
        } else {
            if (this._ff == null) {
                this._ff = FireFly.getFireFly(this._city.getWidth(), 130, this._cityX, 110);
            }
            this._ff.paint(graphics);
            this._ff.update(this._cityX, 110);
        }
        block0 : switch (this.cityProcess) {
            case 0: {
                switch (this._cityIndex) {
                    case 1: {
                        if (this._cityX >= 0) {
                            this._cityX = 0;
                            this.cityProcess = 1;
                            break block0;
                        }
                        this._cityX += 6;
                        return;
                    }
                }
                this._cityX -= 6;
                if (this._cityX <= -160) {
                    this._cityX = -160;
                    this.cityProcess = 1;
                }
                return;
            }
            case 1: {
                if (this._cityMenuYOffset <= 0) {
                    this._cityMenuYOffset = 0;
                    this.speak(10, GameParameter.ROLENAME_LINXI + GameParameter.ROLESPEAK, 2, 0);
                    this.cityProcess = 2;
                    break;
                }
                this._cityMenuYOffset -= 5;
                break;
            }
            case 2: {
                if (this._messageBox != null) {
                    this._messageBox.draw(graphics);
                }
                this.keysponder();
            }
        }
        graphics.setClip(0, 0, 320, 240);
        this.drawCityMenu(graphics);
    }

    private void drawCityMenu(Graphics graphics) {
        SptSet sptSet = SptSet.load(125, 2);
        int n = 160;
        int n2 = 2 - this._cityMenuYOffset;
        int n3 = 150;
        int n4 = sptSet.getSptHeight(4) * 2 + sptSet.getSptHeight(5) * 2 - 10;
        int n5 = n2 + n4;
        Function.drawAlpha(graphics, n, n2, n3, n4);
        graphics.setClip(0, 0, 320, 240);
        int n6 = 12;
        int n7 = 6;
        graphics.setColor(1254966);
        graphics.drawLine(n + n6, n5 + 3, n + n3 - n6, n5 + 3);
        graphics.setColor(11067135);
        graphics.drawLine(n + n6, n5 + 2, n + n3 - n6, n5 + 2);
        graphics.setColor(4356570);
        graphics.drawLine(n + n6, n5 + 1, n + n3 - n6, n5 + 1);
        graphics.setColor(1254966);
        graphics.drawLine(n + n6, n5, n + n3 - n6, n5);
        graphics.setColor(11067135);
        graphics.drawLine(n + n6, n5 - 1, n + n3 - n6, n5 - 1);
        graphics.setColor(1254966);
        graphics.drawLine(n + n6, n5 - 2, n + n3 - n6, n5 - 2);
        sptSet.draw(graphics, sptSet.getSptWidth(4) + n, n2 - n7, -2147483644);
        sptSet.draw(graphics, sptSet.getSptWidth(4) + n, n2 + sptSet.getSptHeight(4) - n7, -2147483643);
        sptSet.draw(graphics, sptSet.getSptWidth(4) + n, n2 + sptSet.getSptHeight(4) + sptSet.getSptHeight(5) - n7, -2147483643);
        sptSet.draw(graphics, sptSet.getSptWidth(4) + n, n2 + sptSet.getSptHeight(4) * 2 - n7 + sptSet.getSptHeight(5) * 2, -1073741820);
        sptSet.draw(graphics, n3 + n - sptSet.getSptWidth(4), n2 - n7, 4);
        sptSet.draw(graphics, n3 + n - sptSet.getSptWidth(4), n2 - n7 + sptSet.getSptHeight(4), 5);
        sptSet.draw(graphics, n3 + n - sptSet.getSptWidth(4), n2 - n7 + sptSet.getSptHeight(4) + sptSet.getSptHeight(5), 5);
        sptSet.draw(graphics, n3 + n - sptSet.getSptWidth(4), n2 + sptSet.getSptHeight(4) * 2 + sptSet.getSptHeight(5) * 2 - n7, 0x40000004);
        graphics.setColor(11067135);
        graphics.drawLine(n + n6, n2 - 2, n + n3 - n6, n2 - 2);
        int n8 = 0;
        while (n8 < this._curCityMenu.length) {
            if (this._curCityMenuIndex == n8) {
                Function.draw3DString(graphics, this._curCityMenu[n8], 235, 35 - this._cityMenuYOffset + Function.C_WORD_H * n8, 1 | 0x10, 16740864, 0xFDFDFD);
            } else {
                graphics.setClip(0, 0, 320, 240);
                graphics.setColor(0xFDFDFD);
                Function.drawString(graphics, this._curCityMenu[n8], 235, 35 - this._cityMenuYOffset + Function.C_WORD_H * n8, 1 | 0x10);
            }
            ++n8;
        }
        graphics.setColor(0xFDFDFD);
        Function.drawString(graphics, this._curCityPos, 235, 5 - this._cityMenuYOffset, 1 | 0x10);
        graphics.setColor(11067135);
        graphics.drawLine(n + n6 + 3, 5 - this._cityMenuYOffset + Function.C_WORD_H, n + n3 - n6 - 6, 5 - this._cityMenuYOffset + Function.C_WORD_H);
    }

    public void speak(int n, String string, int n2, int n3) {
        int n4 = n / 10;
        int n5 = n % 10;
        int n6 = string.indexOf("\uff1a");
        String string2 = string.substring(0, n6);
        String string3 = string.substring(n6 + 1);
        GameRule gameRule = GameRule.getInstance();
        this._messageBox = MessageBox.getInstance(this);
        this._messageBox.initDialogStyle(gameRule.getHeadSptInx(n4), string2, string3, n5, n2);
        this._messageBox.setsheltKeys(true);
    }

    public void keysponder() {
        int n = this._mainLogic.getCurKey();
        this._mainLogic.resetCurKey();
        switch (n) {
            case 4: {
                switch (this._curCityFrameIndex) {
                    case 0: {
                        this.updateCitySceMenu();
                        this._curCityFrameIndex = 1;
                        this._curCityMenuIndex = 0;
                        break;
                    }
                    case 1: {
                        if (this._curCityMenuIndex >= this._curCityData.length) {
                            this._curCityFrameIndex = 0;
                            this._curCityMenuIndex = 0;
                            this.updateCityMenu();
                            break;
                        }
                        this._mainLogic.changeToWorldScene();
                        GameMainLogic.getScene().passLevel(this._curCityData[this._curCityMenuIndex][0], this._curCityData[this._curCityMenuIndex][1], this._curCityData[this._curCityMenuIndex][2]);
                        this._city = null;
                        this._messageBox = null;
                    }
                }
                break;
            }
            case 1: {
                --this._curCityMenuIndex;
                if (this._curCityMenuIndex >= 0) break;
                this._curCityMenuIndex = this._curCityMenu.length - 1;
                break;
            }
            case 7: {
                ++this._curCityMenuIndex;
                if (this._curCityMenuIndex < this._curCityMenu.length) break;
                this._curCityMenuIndex = 0;
                break;
            }
            case 131072: {
                if (this._curCityFrameIndex != 1) break;
                this._curCityFrameIndex = 0;
                this._curCityMenuIndex = 0;
                this.updateCityMenu();
            }
        }
    }

    public static Image loadXpngImage(String string, int n, int n2) {
        Image image;
        InputStream inputStream = StreamReader.openDataFile(string, n);
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        try {
            int n5;
            boolean bl;
            boolean bl2 = bl = StreamReader.readByte(inputStream) > 0;
            if (bl) {
                StreamReader.readByte(inputStream);
            }
            if ((n5 = StreamReader.readByte(inputStream)) > 0) {
                n3 = StreamReader.readInt(inputStream);
                n4 = StreamReader.readInt(inputStream);
                if (n2 >= 0) {
                    byArray = new byte[n4];
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (n2 == n6) {
                        inputStream.read(byArray);
                    } else {
                        inputStream.skip(n4);
                    }
                    ++n6;
                }
            }
            int n7 = StreamReader.readInt(inputStream);
            byte[] byArray2 = new byte[n7];
            inputStream.read(byArray2);
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray2, n3, n4);
                byArray = null;
            }
            image = Image.createImage((byte[])byArray2, (int)0, (int)n7);
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return image;
    }

    public void finishHandle(int n) {
        this._messageBox = null;
    }

    public void initGameLoad() {
        this._loadState = 0;
        this.initRmsPage();
        this._title = new String[]{GameParameter.TITLES[0]};
    }

    public void initGameSave() {
        this._loadState = 1;
        this.initRmsPage();
        this._title = new String[]{GameParameter.TITLES[1]};
    }

    private void gameLoadUI(Graphics graphics) {
        Function.drawBK(graphics, false, false, false, "", "");
        Function.drawTitle(graphics, 0, this._title);
        this.paintLines(graphics);
        this.paintRmsPageInfo(graphics);
        Function.drawSoftItem(graphics, 21);
    }

    public void updateForLoadUI() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        if (gameMainLogic.isPressConfirmKey()) {
            switch (this._loadState) {
                case 0: {
                    this.confirmForLoad();
                    break;
                }
                case 1: {
                    this.confirmForSave();
                }
            }
            gameMainLogic.resetCurKey();
            return;
        }
        if (gameMainLogic.isPressCancelKey()) {
            if (this._menu == null) {
                this.exitHandle();
            } else {
                this._menu.notifyHandlerForCancel();
            }
            gameMainLogic.resetCurKey();
            return;
        }
        int n = gameMainLogic.getCurKey();
        gameMainLogic.resetCurKey();
        switch (n) {
            case 1: {
                switch (this._rmsPageState) {
                    case 0: {
                        --this._curRmsIndex;
                        if (this._curRmsIndex >= 0) break;
                        this._curRmsIndex = 1;
                        break;
                    }
                    case 1: {
                        --this._menu._itemIndex;
                        if (this._menu._itemIndex >= 1) break;
                        this._menu._itemIndex = this._menu._itemNum - 1;
                    }
                }
                break;
            }
            case 7: {
                switch (this._rmsPageState) {
                    case 0: {
                        ++this._curRmsIndex;
                        if (this._curRmsIndex <= 1) break;
                        this._curRmsIndex = 0;
                        break;
                    }
                    case 1: {
                        ++this._menu._itemIndex;
                        if (this._menu._itemIndex <= this._menu._itemNum - 1) break;
                        this._menu._itemIndex = 1;
                    }
                }
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void confirmForLoad() {
        switch (this._rmsPageState) {
            case 0: {
                if (!this._existRms[this._curRmsIndex]) break;
                String[] stringArray = new String[]{GameParameter.ISDUDANG, GameParameter.YES, GameParameter.NO};
                this._menu = Menu.getInstance(this);
                this._menu.initUserdefinedStyle(stringArray, false);
                this._menu._itemIndex = 1;
                this._rmsPageState = 1;
                break;
            }
            case 1: {
                this._menu.notifyHandlerForResult(this._menu._itemIndex);
            }
        }
    }

    private void confirmForSave() {
        switch (this._rmsPageState) {
            case 0: {
                String[] stringArray = new String[]{this._existRms[this._curRmsIndex] ? GameParameter.ISFUGAI : GameParameter.ISSAVE, GameParameter.YES, GameParameter.NO};
                this._menu = Menu.getInstance(this);
                this._menu.initUserdefinedStyle(stringArray, false);
                this._menu._itemIndex = 1;
                this._rmsPageState = 1;
                break;
            }
            case 1: {
                this._menu.notifyHandlerForResult(this._menu._itemIndex);
            }
        }
    }

    private void exitHandle() {
        if (this._loadState == 0) {
            this.changeState(2);
        } else {
            this._mainLogic.changeToWorldScene();
            Function.changeSoundState(3, -1);
        }
    }

    private void paintRmsPageInfo(Graphics graphics) {
        int n = this._drawStartX + 5;
        int n2 = this._drawStartY + this._drawH / 2 - Function.C_WORD_SPACE_Y / 2;
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        int n3 = 0;
        while (n3 < 2) {
            if (this._curRmsIndex == n3) {
                Function.draw3DString(graphics, GameParameter.TITLES[1] + (n3 + 1), n, n2 + n3 * this._drawH, 0x10 | 4, 16740864, 0xFFFFFF);
            } else {
                graphics.setColor(0);
                Function.drawString(graphics, GameParameter.TITLES[1] + (n3 + 1), n, n2 + n3 * this._drawH, 0x10 | 4);
            }
            if (!this._existRms[n3]) {
                graphics.setClip(0, 0, 320, 240);
                graphics.setColor(0);
                Function.drawString(graphics, GameParameter.WUCUNDANG, 160, n2 + n3 * this._drawH, 1 | 0x10);
                switch (this._rmsPageState) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this._menu.draw(graphics);
                    }
                }
            } else {
                Function.drawTime(graphics, this._rmsPageTimeX, this._rmsPageTimeY + n3 * this._drawH, this._rmsGameTimeHour[n3], this._rmsGameTimeMinut[n3], 32, Function.NUMBER);
                int n4 = 0;
                while (n4 < this._roles.length) {
                    if (this._roles[n3][n4]) {
                        this._roleActors[n3][n4].draw(graphics, 0, 0, 0);
                        this._roleActors[n3][n4].step();
                    }
                    ++n4;
                }
                switch (this._rmsPageState) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this._menu.draw(graphics);
                    }
                }
            }
            ++n3;
        }
    }

    private void paintLines(Graphics graphics) {
        int n = 3;
        graphics.setColor(11878689);
        graphics.drawLine(n, this._drawStartY + this._drawH, 320 - n, this._drawStartY + this._drawH);
        graphics.setColor(16759411);
        graphics.drawLine(n, this._drawStartY + this._drawH - 1, 320 - n, this._drawStartY + this._drawH - 1);
        graphics.setColor(16776092);
        graphics.drawLine(n, this._drawStartY + this._drawH - 2, 320 - n, this._drawStartY + this._drawH - 2);
        graphics.setColor(11878689);
        graphics.drawLine(n, this._drawStartY + this._drawH * 2, 320 - n, this._drawStartY + this._drawH * 2);
        graphics.setColor(16759411);
        graphics.drawLine(n, this._drawStartY + this._drawH * 2 + 1, 320 - n, this._drawStartY + this._drawH * 2 + 1);
        graphics.setColor(16776092);
        graphics.drawLine(n, this._drawStartY + this._drawH * 2 + 2, 320 - n, this._drawStartY + this._drawH * 2 + 2);
    }

    private void formatRmsPage() {
        this._teamData = RoleTeamData.getInstance();
        this._rolesAni = new Animation[2][2];
        this._roleActors = new Actor[2][2];
        this._existRms = new boolean[2];
        this._roles = new boolean[2][];
        this._drawStartX = 32;
        this._drawStartY = 32;
        int n = 240 - this._drawStartY;
        this._drawH = n / 3;
        this._rmsPageTimeX = 320 - this._drawStartX - 5;
        this._rmsPageTimeY = this._drawStartY + this._drawH - Function.C_WORD_SPACE_Y;
        this._roleStartY = this._drawStartY + this._drawH - 15;
        this._roleStartX = this._drawStartX + 25 + Function.C_WORD_W * 2;
        this._roleSpace = (320 - this._drawStartX - this._roleStartX) / 4;
    }

    private void initRmsPage() {
        int n = 0;
        while (n < 2) {
            if (!Function.isExistRecord(n)) {
                this._existRms[n] = false;
            } else {
                this._existRms[n] = true;
                Function.loadRmsUIProperty(n);
                this._rmsGameTimeHour[n] = Function._rmsGameTimeHour;
                this._rmsGameTimeMinut[n] = Function._rmsGameTimeMinut;
                this._roles[n] = Function._rmsBattleFlag;
                int n2 = this._roles.length;
                this._roleActors[n] = new Actor[n2];
                int n3 = 0;
                while (n3 < n2) {
                    this._rolesAni[n][n3] = Animation.getAnimation(n3);
                    if (this._rolesAni[n][n3] == null) {
                        this._rolesAni[n][n3] = Animation.load(n3, 2);
                    }
                    this._roleActors[n][n3] = new Actor(n, this._rolesAni[n][n3]);
                    ++n3;
                }
                int n4 = this._roleStartX;
                int n5 = 0;
                while (n5 < this._roles.length) {
                    if (this._roles[n][n5]) {
                        this._roleActors[n][n5].init(n4 << 10, this._roleStartY + n * this._drawH << 10, -2147483640);
                        this._roleActors[n][n5]._loopAction = true;
                        n4 += this._roleSpace;
                    }
                    ++n5;
                }
                if (this._roleActors[n][1] != null && Function._curScenario > 50) {
                    this._roleActors[n][1]._palNo = 1;
                }
            }
            ++n;
        }
    }

    public void cancelHandle() {
        this._menu = null;
        this._rmsPageState = 0;
    }

    public void resultHandle(int n) {
        this._menu = null;
        block0 : switch (this._loadState) {
            case 1: {
                switch (n) {
                    case 1: {
                        Function.saveGame(this._curRmsIndex);
                        if (!ThingInterface._isUseSaveThing) break;
                        RoleTeamData.getInstance().decreaseThing(47, 1);
                        ThingInterface._isUseSaveThing = false;
                        break;
                    }
                }
                this.initRmsPage();
                break;
            }
            case 0: {
                switch (n) {
                    case 1: {
                        Function.loadGame(this._curRmsIndex);
                        this.startupLoadLevel();
                        break block0;
                    }
                }
            }
        }
        this._rmsPageState = 0;
    }

    public void shortcutKeyHandle(int n) {
    }

    public static void resetIsFirstTime() {
        int n = 0;
        while (n < _isFirstTime.length) {
            GameInterface._isFirstTime[n] = true;
            ++n;
        }
    }

    private void cityEffect(Graphics graphics) {
        int n = this._cityX + 385;
        int n2 = (240 - this._city.getHeight()) / 2 + 130;
        Animation animation = Animation.load(106, 2);
        int n3 = 3;
        short s = animation.getActFrmNum(n3);
        animation.draw(graphics, n, n2, n3, this._curFram1, 0);
        ++this._curFram1;
        if (this._curFram1 == s) {
            this._curFram1 = 0;
        }
        ++this._time1;
        int n4 = 50;
        if (Math.abs(this._time1 * this._v2) >= n4) {
            this._flipX = this._flipX == 0 ? Integer.MIN_VALUE : 0;
            this._tempDx2 += this._v2 * this._time1;
            this._v2 = -this._v2;
            this._time1 = 0;
        }
        int n5 = n + 55 + this._time1 * this._v2 + this._tempDx2;
        int n6 = n2 + 20;
        n3 = 2;
        s = animation.getActFrmNum(n3);
        animation.draw(graphics, n5, n6, n3 | this._flipX, this._curFram2, 0);
        ++this._curFram2;
        if (this._curFram2 == s) {
            this._curFram2 = 0;
        }
        ++this._time3;
        n4 = 240;
        if (Math.abs(this._time3 * this._v3) >= n4) {
            this._flipX3 = this._flipX3 == 0 ? Integer.MIN_VALUE : 0;
            this._tempDx3 += this._v3 * this._time3;
            this._v3 = -this._v3;
            this._time3 = 0;
        }
        int n7 = n - 55 + this._time3 * this._v3 + this._tempDx3;
        int n8 = n2 + 30;
        n3 = 1;
        s = animation.getActFrmNum(n3);
        animation.draw(graphics, n7, n8, n3 | this._flipX3, this._curFram3, 0);
        ++this._curFram3;
        if (this._curFram3 == s) {
            this._curFram3 = 0;
        }
        int n9 = n - 38;
        int n10 = n2 - 65;
        n3 = 5;
        s = animation.getActFrmNum(n3);
        animation.draw(graphics, n9, n10, n3, 0, 0);
        ++this._time5;
        n4 = 240;
        if (Math.abs(this._time5 * this._v5) >= n4) {
            this._flipX5 = this._flipX5 == 0 ? Integer.MIN_VALUE : 0;
            this._tempDx5 += this._v5 * this._time5;
            this._v5 = -this._v5;
            this._time5 = 0;
        }
        int n11 = this._cityX + 100 + this._time5 * this._v5 + this._tempDx5;
        int n12 = n2 + 37;
        n3 = 5;
        s = animation.getActFrmNum(n3);
        animation.draw(graphics, n11, n12, n3 | this._flipX5, this._curFram5, 0);
        ++this._curFram5;
        if (this._curFram5 == s) {
            this._curFram5 = 0;
        }
        int n13 = this._cityX + 65;
        int n14 = n2 + 60;
        n3 = 4;
        s = animation.getActFrmNum(n3);
        animation.draw(graphics, n13, n14, n3 | Integer.MIN_VALUE, 0, 0);
        int n15 = n13 + 10;
        int n16 = n14;
        n3 = 3;
        s = animation.getActFrmNum(n3);
        animation.draw(graphics, n15, n16, n3, this._curFram7, 0);
        ++this._curFram7;
        if (this._curFram7 == s) {
            this._curFram7 = 0;
        }
    }

    private void cityEffectBird(Graphics graphics) {
        graphics.setClip(0, (240 - this._city.getHeight()) / 2, 320, this._city.getHeight());
        Animation animation = Animation.load(103, 2);
        short s = animation.getActFrmNum(0);
        if (this._birdY1 > (240 - this._city.getHeight()) / 2) {
            if (++this._timeBird > 2) {
                ++this._zoomX1;
                if (this._zoomX1 >= 30) {
                    this._zoomX1 = 30;
                }
            } else {
                this._birdX1 -= 5;
                this._birdY1 -= 2;
            }
            animation.drawReduceEasy(graphics, this._cityX + this._birdX1, this._birdY1, 0, this._curFramBird, 0, this._zoomX1);
            if (++this._curFramBird > s - 1) {
                this._curFramBird = 0;
            }
        }
        if (this._birdY2 > (240 - this._city.getHeight()) / 2) {
            if (this._timeBird > 2) {
                ++this._zoomX2;
                this._timeBird = 0;
                if (this._zoomX2 >= 30) {
                    this._zoomX2 = 30;
                }
            } else {
                this._birdX2 -= 5;
                this._birdY2 -= 2;
            }
            animation.drawReduceEasy(graphics, this._cityX + this._birdX2, this._birdY2, 0, this._curFramBird, 0, this._zoomX2);
            if (++this._curFramBird2 > s - 1) {
                this._curFramBird2 = 0;
            }
        }
        if (this.cityProcess == 2) {
            if (++this._timeBird1 > 2) {
                ++this._zoomX3;
                this._timeBird1 = 0;
                if (this._zoomX3 >= 30) {
                    this._zoomX3 = 30;
                }
            } else {
                this._birdX3 += 6;
                this._birdY3 -= 2;
            }
            if (++this._timeBird11 > 300) {
                this.resetBird3();
                this._timeBird11 = 0;
            }
            animation.drawReduceEasy(graphics, this._birdX3, this._birdY3, Integer.MIN_VALUE, this._curFramBird3, 0, this._zoomX3);
            if (++this._curFramBird3 > s - 1) {
                this._curFramBird3 = 0;
            }
        }
    }

    private void cityEffectBoat(Graphics graphics) {
        Animation animation = Animation.load(104, 2);
        switch (this._boatStat) {
            case 0: {
                ++this._timeBoat;
                break;
            }
            case 1: {
                if (++this._timeBoat1 <= 100) break;
                this._boatStat = 0;
                this._timeBoat1 = 0;
            }
        }
        int n = 160;
        if (Math.abs(this._timeBoat * this._boatVx) >= n) {
            this._tempDxBoat += this._boatVx * this._timeBoat;
            this._tempDyBoat += this._boatVy * this._timeBoat;
            this._boatVx = -this._boatVx;
            this._boatVy = -this._boatVy;
            this._timeBoat = 0;
            this._boatStat = 1;
        }
        int n2 = this._cityX + 40 + this._timeBoat * this._boatVx + this._tempDxBoat;
        int n3 = 140 + this._timeBoat * this._boatVy + this._tempDyBoat;
        int n4 = 0;
        short s = animation.getActFrmNum(n4);
        animation.draw(graphics, n2, n3, n4, this._curFramBoat, 0);
        ++this._curFramBoat;
        if (this._curFramBoat == s) {
            this._curFramBoat = 0;
        }
    }

    private void resetBird3() {
        this._birdX3 = 0;
        this._birdY3 = 120;
        this._zoomX3 = 0;
    }

    private void resetAllcityEffect() {
        this._curFramBird = 0;
        this._curFramBird2 = 3;
        this._curFramBird3 = 0;
        this._curFram1 = 0;
        this._curFram2 = 0;
        this._curFram3 = 0;
        this._curFram5 = 0;
        this._curFram7 = 0;
        this._curFramBoat = 0;
        this._time1 = 0;
        this._time5 = 0;
        this._timeBoat = 0;
        this._timeBoat1 = 0;
        this._v2 = -1;
        this._v3 = -1;
        this._v5 = 1;
        this._flipX = 0;
        this._flipX3 = Integer.MIN_VALUE;
        this._flipX5 = 0;
        this._tempDx2 = 0;
        this._tempDx3 = 0;
        this._tempDx5 = 0;
        this._tempDxBoat = 0;
        this._tempDyBoat = 0;
        this._time3 = 0;
        this._timeBird = 0;
        this._timeBird1 = 0;
        this._timeBird11 = 0;
        this._zoomX1 = -1;
        this._zoomX2 = 5;
        this._zoomX3 = 0;
        this._timeVx = 0;
        this._birdX1 = 640;
        this._birdY1 = 120;
        this._birdX2 = 660;
        this._birdY2 = 140;
        this._birdX3 = 0;
        this._birdY3 = 120;
        this._boatVx = -1;
        this._boatVy = -1;
        this._boatStat = 0;
    }
}

