/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.DataEnemy;
import com.sinaflying.db.DataEquip;
import com.sinaflying.db.GameDB;
import com.sinaflying.engine.Animation;
import com.sinaflying.engine.SptSet;
import com.sinaflying.game.BattleScene;
import com.sinaflying.game.Fighter;
import com.sinaflying.game.GameRule;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

public class EnemyFighter
extends Fighter {
    private static final int BEHAVE_NONE = -1;
    private static final int BEHAVE_ATTACK = 0;
    private static final int BEHAVE_ATTACK_MIN_HP = 2;
    private static final int BEHAVE_SKILL = 3;
    private static final int BEHAVE_SKILL_MIN_HP = 4;
    private static final int BEHAVE_USE_THING_FOR_LIGHT_HARM = 5;
    private static final int BEHAVE_USE_SKILL_FOR_LIGHT_HARM = 6;
    private static final int BEHAVE_ATTACK_DOUBLE_INJURE_FOR_HARD_HARM = 7;
    private static final int BEHAVE_SKILL_DOUBLE_INJURE_FOR_HARD_HARM = 8;
    private static final int BEHAVE_ESCAPE_FOR_EXTREMITY = 100;
    private int[] _behave = new int[3];
    private int _behaveNum;
    private static final int SPECIAL_HP_RATE_BASE_VALUE = 100;
    private static final int LIGHT_HARM_HP_RATE = 30;
    private static final int HARD_HARM_HP_RATE = 20;
    private static final int EXTREMITY_HP_RATE = 10;
    private int _lightHarmHP;
    private int _hardHarmHP;
    private int _extremityHP;
    private int _curBehaveInx;
    public DataEnemy _enemyData;
    private int[] _validBehave;
    private int[] _validBehaveRate;

    protected void command() {
        if (this.isValidAcionInfo()) {
            this.finishCommand();
            return;
        }
        this.settingCommand();
    }

    private final void settingCommand() {
        if (this.isRooted()) {
            return;
        }
        this.confirmBehave();
        this.confirmAction();
        this.confirmTarget();
        this.finishCommand();
    }

    protected void startUpCommand() {
    }

    private final void initSpecialHPValue() {
        this._lightHarmHP = this._maxHp * 30 / 100;
        this._hardHarmHP = this._maxHp * 20 / 100;
        this._extremityHP = this._maxHp * 10 / 100;
    }

    private final boolean isValidBehave(int n) {
        switch (n) {
            case -1: {
                return false;
            }
            case 0: {
                return true;
            }
        }
        return true;
    }

    private final boolean isLightHarm() {
        return this._currentHp <= this._lightHarmHP;
    }

    private final boolean isHardHarm() {
        return this._currentHp <= this._hardHarmHP;
    }

    private final boolean isExtremity() {
        return this._currentHp <= this._maxHp * 20 / 100;
    }

    private final void confirmBehave() {
        if (this.isRooted()) {
            return;
        }
        this.updateValidBehave();
    }

    private final void updateValidBehave() {
        while (this._curBehaveInx < this._validBehave.length - 1) {
            if (!this.isValidBehave(this._validBehave[++this._curBehaveInx])) continue;
            return;
        }
        this._curBehaveInx = -1;
    }

    public final void increaceRate() {
        this._bangRate = 40;
    }

    public final void resetRate() {
        this._bangRate = this._enemyData.getInterForce();
        this._attackInjure = this._enemyData.getAttackForce();
    }

    private final void selectBehave() {
    }

    private final void confirmAction() {
        if (this.isRooted()) {
            return;
        }
        if (!this.isBossStonger()) {
            this.resetRate();
        }
        int n = this.Escape() ? 100 : (this._curBehaveInx == -1 || !this.canUseSkill() ? 0 : (Function.Random(100, true) < this._validBehaveRate[this._curBehaveInx] * 10 ? this._validBehave[this._curBehaveInx] : 0));
        switch (n) {
            case 0: {
                this.setAttackInfo();
                break;
            }
            case 100: {
                this.selectEscapeHandle();
                break;
            }
            default: {
                this.setUseSkillInfo(n, 0);
            }
        }
    }

    protected boolean isDoubleAttack() {
        return this._behave[0] == 7;
    }

    private final void selectSkillHandle() {
        this.setUseSkillInfo(this._enemyData.getSkillIndex(), this._enemyData.getLevel());
    }

    private final void selectThingHandle() {
        int n = 0;
        while (n < 3) {
            if (this._validBehave[n] == 5) {
                this._validBehave[n] = -1;
            }
            ++n;
        }
        int[] nArray = this._enemyData.getThing();
        int n2 = nArray[0];
        this.setUseThingInfo(n2);
    }

    private void selectEscapeHandle() {
        this.setEscapeInfo();
    }

    private final void confirmTarget() {
        if (this.isEscapeAction()) {
            return;
        }
        if (this.isAllTargetAction()) {
            this.clearTarget();
            this.resetCurrentTarget();
            return;
        }
        if (this.isFriendSingleTarget()) {
            this.setTargetForFriendSingle();
            return;
        }
        this.setTargetForRivalSingle();
    }

    private final void setTargetForFriendSingle() {
        this._tempContainer[0] = this;
        this._tempContainerMemberNum = 1;
        this.groupingByEveryOne();
        this._curTargetGroup = 0;
    }

    private final void setMaxHPTargetForRivalSingle() {
        this.updateAllRival();
        this.groupingByEveryOne();
        this.updateTargetGroupInfo();
        this.selectMaxHpTarget();
    }

    private final void selectMaxHpTarget() {
        this._curTargetGroup = 0;
        int n = this._target[this._curTargetGroup][0].getCurrentHP();
        int n2 = 1;
        while (n2 < this._targetGroupNum) {
            int n3 = this._target[n2][0].getCurrentHP();
            if (n3 > n) {
                n = n3;
                this._curTargetGroup = n2;
            }
            ++n2;
        }
    }

    private final void selectMinHpTarget() {
        this._curTargetGroup = 0;
        int n = this._target[this._curTargetGroup][0].getCurrentHP();
        int n2 = 1;
        while (n2 < this._targetGroupNum) {
            int n3 = this._target[n2][0].getCurrentHP();
            if (n3 < n) {
                n = n3;
                this._curTargetGroup = n2;
            }
            ++n2;
        }
    }

    private final void setRandomTargetForRivalSingle() {
        this.clearTarget();
        this.resetCurrentTarget();
    }

    private final void setTargetForRivalSingle() {
        this.setRandomTargetForRivalSingle();
    }

    private final boolean isFriendSingleTarget() {
        return this._actionInfo[1] == 1;
    }

    private final boolean isAllTargetAction() {
        return this._actionInfo[1] == 4 || this._actionInfo[1] == 2;
    }

    protected boolean isExtremityDeath() {
        return false;
    }

    public boolean isMomentSkillUsed() {
        return false;
    }

    protected boolean isBossStonger() {
        return this.isBoss() && this.isExtremity();
    }

    public boolean isBoss() {
        switch (this._enemyData.getAnimationIndex()) {
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                return true;
            }
        }
        return false;
    }

    private final boolean isEscapeAction() {
        return this._actionInfo[0] == 4;
    }

    protected final void updateAllRival() {
        this._tempContainerMemberNum = this._scene.getRoleFighterForEffectByRival(this._tempContainer);
    }

    protected final void updateAllFriend() {
        this._tempContainerMemberNum = this._scene.getEnemyFighterForEffectByFriend(this._tempContainer);
    }

    protected boolean canDraw() {
        return !this.isEscape();
    }

    protected void clearState() {
        this._actionInfo[0] = 5;
    }

    protected int getExperience() {
        if (this.isDeath()) {
            return this._enemyData.getExperience();
        }
        return 0;
    }

    protected boolean isEffectedHarmState() {
        if (this.isBoss()) {
            return GameRule.getInstance().isEffectedHarmStateForBoss();
        }
        return GameRule.getInstance().isEffectedHarmStateForDefault();
    }

    public void changeToEscapeMove() {
        this._vx = -this.getEscapePosX() / 3;
        this._vy = -this.getEscapePosY() / 3;
        this._timer = 3;
    }

    private final boolean isGainThing() {
        return Function.Random(10, true) > 5;
    }

    protected int[] getThing() {
        if (!this.isDeath()) {
            return null;
        }
        GameDB gameDB = GameDB.getGameDataBase();
        int[] nArray = this._enemyData.getThing();
        if (nArray == null) {
            return null;
        }
        int n = 0;
        while (n < nArray.length) {
            DataEquip dataEquip;
            if (nArray[n] > 0 && (dataEquip = gameDB.getEquipData(nArray[n])) == null) {
                int n2 = -1;
            }
            ++n;
        }
        return nArray;
    }

    protected int getMoney() {
        if (this.isDeath()) {
            return this._enemyData.getMony();
        }
        return 0;
    }

    protected int getPilferThing() {
        int[] nArray = this._enemyData.getPilferThing();
        int[] nArray2 = this._enemyData.getPilferPercent();
        if (this.pilferIndex > nArray2.length - 1) {
            return -1;
        }
        if (Function.Random(100, true) > nArray2[this.pilferIndex]) {
            return -1;
        }
        if (this.pilferSucce) {
            return -1;
        }
        ++this.pilferIndex;
        this.pilferSucce = true;
        return nArray[0];
    }

    protected boolean canObtainExperience() {
        return false;
    }

    protected String[][] battleFinishHandler(int n) {
        return null;
    }

    protected final void finishEffectBoutHandle(int n) {
        switch (n) {
            case 4: {
                this._interForcse = this._enemyData.getInterForce();
                break;
            }
            case 3: {
                this._defence = this._enemyData.getDefence();
                break;
            }
            case 5: {
                this._attackInjure = this._enemyData.getAttackForce();
            }
        }
    }

    public void escapeFailHandle() {
        this.changeToWait();
    }

    protected int getAttackedPosX() {
        return this._x + 25600;
    }

    protected int getAttackedPosY() {
        return this._y + 12800;
    }

    protected int getBackPosX() {
        return this._x;
    }

    protected int getBackPosY() {
        return this._y;
    }

    protected int getForePosX() {
        return this._x;
    }

    protected int getForePosY() {
        return this._y;
    }

    protected int getEscapePosX() {
        return this._x + 10240;
    }

    protected int getEscapePosY() {
        return this._y;
    }

    protected int getDefencePosX() {
        return this._x - 25600;
    }

    protected int getDefencePosY() {
        return this._y - 25600;
    }

    protected int getUseSkillPosX() {
        return this._x - (this._anim.getCollideRight(this.getActionInx(8)) << 10);
    }

    protected int getUseSkillPosY() {
        return this._y + (this._anim.getCollideTop(this.getActionInx(8)) << 10);
    }

    protected int getEffectBySkillPosX() {
        return this._x;
    }

    protected int getEffectBySkillPosY() {
        return this._y + (this._anim.getVisibleTop() >> 1 << 10);
    }

    protected void paintState(Graphics graphics, int n, int n2) {
        int n3 = SptSet.load(125, 1).getSptWidth(2) * 3 / 2;
        if (!this.canUseSkill()) {
            this.paintState(graphics, 3, n, n2);
            n += n3;
        }
        if (this.isRooted()) {
            this.paintState(graphics, 2, n, n2);
            n += n3;
        }
    }

    protected void paintProperty(Graphics graphics, int n, int n2) {
        if (this._enemyData.getPropertyInx() != 0) {
            // empty if block
        }
    }

    private final void paintHP(Graphics graphics, int n, int n2) {
    }

    protected void escapeHandle() {
        this._vx = 0;
        this._vy = 0;
        this._scene.setLoseEnemyFlag();
    }

    public boolean isEscapeSucess() {
        return true;
    }

    public boolean Escape() {
        return this.isExtremity() && Function.Random(100, true) < this._enemyData.getEscapeRate();
    }

    protected boolean canEffectByFriend() {
        return true;
    }

    protected void deathHandle() {
        this._scene.setLoseEnemyFlag();
    }

    protected void drawForDeath(Graphics graphics, int n, int n2) {
    }

    protected void drawCommandInfo(Graphics graphics) {
    }

    protected void drawVictoryInfo(Graphics graphics) {
    }

    protected String getFighterName() {
        return this._enemyData.getName();
    }

    public void init(int n) {
        int n2;
        GameRule gameRule = GameRule.getInstance();
        this._enemyData = gameRule.getEnemyDataByIndexInOrder(n);
        this._validBehave = new int[this._enemyData.getBehaveTrend().length];
        System.arraycopy(this._enemyData.getBehaveTrend(), 0, this._validBehave, 0, this._validBehave.length);
        this._validBehaveRate = this._enemyData.getBehavePercent();
        this._type = n2 = this._enemyData.getAnimationIndex();
        this._anim = Animation.load(n2, 2);
        this._maxHp = this._enemyData.getHp();
        this._attackInjure = this._enemyData.getAttackForce();
        this._skillInjure = this._enemyData.getSkillInjure();
        this._defence = this._enemyData.getDefence();
        this._bangRate = gameRule.getBangRate(1);
        this._hitRate = gameRule.getHitRate(1);
        this._missRate = gameRule.getMissRate(1);
        this._parryRate = gameRule.getParryRate(1);
        this._property = this._enemyData.getPropertyInx();
        this._currentHp = this._maxHp;
        this.initSpecialHPValue();
        this._curBehaveInx = -1;
        this._interForcse = this._enemyData.getInterForce();
        int[] nArray = gameRule.getEnemyOrderInfo(n, this._scene._Bbk);
        switch (this._type) {
            case 69: 
            case 70: {
                nArray[0] = 126;
                nArray[1] = 120;
                break;
            }
            case 71: {
                nArray[0] = 126;
                nArray[1] = 96;
            }
        }
        this.initData(nArray);
        this.resetSpeed();
        this._palNo = this._enemyData.getPalNoIndex();
        this._drawWeapon = false;
    }

    public final void dispose() {
        this._enemyData = null;
        this._anim = null;
    }

    protected int getCurrentLevel() {
        return 0;
    }

    boolean canParry(int n) {
        return false;
    }

    boolean isBangAttacked() {
        return false;
    }

    protected int getFighterProperty() {
        return this._property;
    }

    public void setEffect() {
        this._scene.addEffectActor(107, this.getForePosX(), this.getForePosY(), this.getForePosX(), this.getForePosY(), 5);
    }

    public void changeToHurt() {
        this._state = 4;
        this._timer = 4;
        this._vx = -2048;
        if (this.isBossStonger()) {
            this.increaceRate();
        }
    }

    public void changeToActionReady() {
        this._actionInfo[2] = 1;
    }

    public EnemyFighter(BattleScene battleScene) {
        super(battleScene);
    }

    protected boolean isDrawBK() {
        return true;
    }

    protected boolean isClear() {
        return false;
    }
}

