/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.GameDB;
import com.sinaflying.engine.Animation;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.NPCActor;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.UnitData;

public class Chest
extends NPCActor {
    private int _state;
    private static final int C_STATE_VALID = 0;
    private static final int C_STATE_INVALID = 1;
    private static final int C_ACTION_CLOSE = 0;
    private static final int C_ACTION_OPEN = 1;
    private int _goodsKindId;
    private int _goodsIndex;
    private static final int C_SCENE_PARTITION_NUM = 1000;

    public Chest(int n, Animation animation) {
        super(n, animation);
    }

    public boolean init(UnitData unitData) {
        super.init(unitData);
        return true;
    }

    private final void validCheck() {
        int n;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        if (roleTeamData.isValid(String.valueOf(n = this._scene._id * 1000 + this._id))) {
            this._state = 0;
        } else {
            this._state = 1;
            this.changeAction(1);
        }
    }

    public void ai() {
        switch (this._action) {
            case 0: {
                break;
            }
        }
        if (this._scene._messageBox == null) {
            this.scriptHandle();
        }
    }

    protected boolean scriptHandle() {
        switch (this._action) {
            case 0: {
                if (!this.isMatchTriggerCondition()) break;
                if (this._isFlip) {
                    this.changeAction(-2147483647);
                    break;
                }
                this.changeAction(1);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                if (!this.isMatchTriggerCondition()) break;
                if (this._isFlip) {
                    this.changeAction(-2147483644);
                } else {
                    this.changeAction(4);
                }
                if (!this.checkHaveSpace()) {
                    return false;
                }
                if (this._scene.getGameLogic().checkInfoExist(this._scene._id, this._id)) {
                    return false;
                }
                UnitData unitData = this._scene.getUnitData(this._id);
                byte[] byArray = unitData.getParameter();
                if (byArray != null) {
                    this._goodsKindId = byArray[0];
                    this._goodsIndex = byArray[1];
                }
                this.getGoods(this._goodsKindId, this._goodsIndex);
                this.triggerScript();
                this.recordEasyInfo();
                break;
            }
            case 1: {
                if (!this.checkHaveSpace()) {
                    return false;
                }
                if (this._scene.getGameLogic().checkInfoExist(this._scene._id, this._id)) {
                    return false;
                }
                UnitData unitData = this._scene.getUnitData(this._id);
                byte[] byArray = unitData.getParameter();
                if (byArray != null) {
                    this._goodsKindId = byArray[0];
                    this._goodsIndex = byArray[1];
                }
                this.getGoods(this._goodsKindId, this._goodsIndex);
                this.triggerScript();
                this.recordEasyInfo();
            }
        }
        return false;
    }

    protected boolean checkHaveKey() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n = 0;
        switch (this._palNo) {
            case 0: {
                n = roleTeamData.getHoldThingNum(102) + roleTeamData.getHoldThingNum(104);
                break;
            }
            case 1: {
                n = roleTeamData.getHoldThingNum(103) + roleTeamData.getHoldThingNum(105);
                break;
            }
        }
        return n > 0;
    }

    protected void useKey() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        switch (this._palNo) {
            case 0: {
                if (roleTeamData.getHoldThingNum(102) != 0) {
                    roleTeamData.decreaseThing(102, 1);
                    break;
                }
                roleTeamData.decreaseThing(104, 1);
                break;
            }
            case 1: {
                if (roleTeamData.getHoldThingNum(103) != 0) {
                    roleTeamData.decreaseThing(103, 1);
                    break;
                }
                roleTeamData.decreaseThing(105, 1);
            }
        }
    }

    protected boolean checkHaveSpace() {
        return true;
    }

    protected void getGoods(int n, int n2) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        GameDB gameDB = GameDB.getGameDataBase();
        switch (n) {
            case 5: {
                roleTeamData.increaseEquip(n2, 1);
                this._scene.setInfo(GameParameter.C_BATTLE_INFO[2] + gameDB.getEquipData(n2).getName());
                break;
            }
            case 2: {
                roleTeamData.increaseThing(n2, 1);
                this._scene.setInfo(GameParameter.C_BATTLE_INFO[2] + gameDB.getThingData(n2).getName());
                break;
            }
            case 7: {
                roleTeamData.increaseMissionThing(n2);
                this._scene.setInfo(GameParameter.C_BATTLE_INFO[2] + gameDB.getDataMissionThing(n2).getMissionThingAccount());
                break;
            }
            case 3: {
                roleTeamData.increaseMaterial(n2, 1);
                this._scene.setInfo(GameParameter.C_BATTLE_INFO[2] + gameDB.getMaterialData(n2).getName());
                break;
            }
            case 8: {
                roleTeamData.increaseComposeScroll(n2);
                this._scene.setInfo(GameParameter.C_BATTLE_INFO[2] + gameDB.getDataComposeScroll(n2).getName());
                break;
            }
            case 9: {
                roleTeamData.increaseMoney(n2 * 100);
                this._scene.setInfo(GameParameter.C_BATTLE_INFO[2] + n2 * 100 + GameParameter.C_BATTLE_INFO[9]);
            }
        }
    }
}

