/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.DataCompose;
import com.sinaflying.db.DataMaterial;
import com.sinaflying.db.DataThing;
import com.sinaflying.db.GameDB;
import com.sinaflying.engine.Animation;
import com.sinaflying.engine.TiledBackground;
import com.sinaflying.game.Actor;
import com.sinaflying.game.BattlePanel;
import com.sinaflying.game.EnemyFighter;
import com.sinaflying.game.Fighter;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.NewEffectHandle;
import com.sinaflying.game.RoleFighter;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.game.ScriptDriver;
import com.sinaflying.game.ScriptUnit;
import com.sinaflying.game.UnitData;
import com.sinaflying.game.WorldScene;
import com.sinaflying.gameUtil.MessageBox;
import com.sinaflying.gameUtil.MessageBoxHandler;
import com.sinaflying.script.BattleExecutor;
import com.sinaflying.script.Script;
import com.sinaflying.util.Function;
import com.sinaflying.util.StreamReader;
import javax.microedition.lcdui.Graphics;

public class BattleScene
extends Scene
implements MessageBoxHandler {
    int \u7a7a1 = 0;
    String \u7a7a2 = null;
    protected int _state;
    public static final int STATE_COMMAND = 0;
    public static final int STATE_ACTION = 1;
    private static final int STATE_VICTORY_HANDLE = 2;
    private static final int STATE_LOSE_HANDLE = 3;
    private static final int STATE_BOUT_FINISH = 4;
    private static final int STATE_ESCAPE_SUCCESS = 6;
    private static final int STATE_SCRIPT = 7;
    private static final int STATE_BOUT_FINISH_IDEL = 8;
    private static final int STATE_SHOW_CLOSE = 9;
    private static final int STATE_SHOW_OPEN = 10;
    private static final int STATE_FINISH_ACTION = 11;
    private static final int STATE_SHOW_VICTORY = 12;
    private static final int STATE_SHOW_LOSE = 13;
    private static final int STATE_ESCAPE_FAIL = 14;
    private int _battleStartSound = 2;
    private int _battleEndSound;
    private boolean _onceDrawBK;
    public boolean _roleEscapeFail;
    public int _Bbk;
    public int _Bfk;
    public boolean _BisEscape;
    public boolean _escapeFail;
    private boolean _isPaintSkill;
    public static MessageBox _messageBox;
    public int _shakeTime;
    public int _shakeRange;
    public int _cameraOffset;
    private boolean _sortFlag;
    private boolean _isFinishCommand;
    private static final int NONE_FIGHTER_SETTING_COMMAND = -1;
    private static final int NONE_PREVIOUS_ROLE_SETTING_COMMAND = -1;
    private static final int NONE_FIGHTER_ACTION = -1;
    private int _fighterChangeFlag;
    private static final int FIGHTER_FLAG_NONE = 0;
    private static final int FIGHTER_FLAG_LOSE_ROLE = 1;
    private static final int FIGHTER_FLAG_LOSE_ENEMY = 2;
    private int _experience;
    private int _experienceForEach;
    private int _obtainMoney;
    private static final int C_MAX_VICTORY_INFO_NUM = 20;
    private String[] _victoryInfo = new String[20];
    private String[] _victoryOtherInfo = new String[20];
    private int _victoryRowNum;
    String[][] _info;
    private int infoIndex;
    private static final int C_MAX_OBTAIN_THINGS_NUM = 20;
    private int[] _obtainThings = new int[20];
    private int _breakPoint;
    protected Actor[] _effectActor;
    private int effectIndex;
    private int _changeEffectInx;
    private boolean _isFinishClose;
    private static final int C_CHANGE_EFFECT_SHUTTER_VERTICAL = 0;
    private static final int C_SHUTTER_VERTICAL_DISTANCE = 32;
    private static final int C_SHUTTER_VERTICAL_FINISH_W = 16;
    private static final int C_SHUTTER_VERTICAL_SPEED = 1;
    private int _shutterVerticalProcess;
    private static NewEffectHandle _effectHandler;
    public boolean _isFullEffectOpen;
    public int _effectAni;
    public int _effectAct;
    public int _effectY;
    private GameMainLogic _mainLogic;
    private BattlePanel _infoPanel;
    private RoleFighter[] _roleFighter;
    public EnemyFighter[] _enemyFighter;
    public Fighter[] _fighter;
    private int _fighterNum;
    public int _curFighterIndex;
    private Fighter[] _fighterPainter;
    private Actor[] effectPaintActor;
    private static BattleScene _instance;
    private boolean _startOverFlag;
    private int _idelTimer;
    private static final int C_IDEL_TIME = 3;
    private static final int C_FINISH_ACTION_IDLE_TIME = 6;
    public BattleExecutor _executor;
    public ScriptUnit[] _scriptUnit;
    public int _scriptIndex;
    private int _result;

    public void openOnceDrawBK() {
        this._onceDrawBK = true;
    }

    public void roalResetLife() {
        this._mainLogic._state = 2;
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getBattleInfo();
        int n = blArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (blArray[n3]) {
                this._roleFighter[n2].resetLife();
                ++n2;
            }
            ++n3;
        }
        this._roleEscapeFail = false;
        this._state = 8;
    }

    public final void paint(Graphics graphics) {
        switch (this._state) {
            case 0: {
                this.paintCommon(graphics);
                this.paintFighterCommandInfo(graphics);
                this.updateForCommand();
                break;
            }
            case 1: {
                this.paintCommon(graphics);
                this.paintFighterActionInfo(graphics);
                this.updateForAcion();
                this.updateEffectHandler();
                break;
            }
            case 4: {
                this.paintCommon(graphics);
                this.updateForBoutFinish();
                break;
            }
            case 3: {
                this.paintCommon(graphics);
                this.updateForLose();
                RoleFighter.setEchoLastAction(false);
                break;
            }
            case 2: {
                this.paintCommon(graphics);
                this.updateForVictory();
                RoleFighter.setEchoLastAction(false);
                break;
            }
            case 6: {
                this.paintCommon(graphics);
                this.updateForEscapeSuccess();
                RoleFighter.setEchoLastAction(false);
                break;
            }
            case 7: {
                this.paintCommon(graphics);
                this.updateScript();
                break;
            }
            case 8: {
                this.paintCommon(graphics);
                this.updateForIdle();
                break;
            }
            case 11: {
                this.paintCommon(graphics);
                this.updateForFinishAction();
                RoleFighter.setEchoLastAction(false);
                break;
            }
            case 9: {
                this.paintForClose(graphics);
                if (!this._isFinishClose) break;
                this.initialize(this._Bbk, this._Bfk, this._BisEscape);
                break;
            }
            case 10: {
                this.paintForOpen(graphics);
                break;
            }
            case 12: {
                this.paintCommon(graphics);
                this.updateForShowVictory();
                break;
            }
            case 13: {
                this.paintCommon(graphics);
                this.paintForShowLose(graphics);
                this.updateForLose();
                break;
            }
            case 14: {
                this.paintCommon(graphics);
                this.updateForEscapeSuccess();
                RoleFighter.setEchoLastAction(false);
            }
        }
    }

    private final void paintCommon(Graphics graphics) {
        this.updateCameraOffset();
        this._bk.setPositionInMap(0, 0);
        this.paintBK(graphics);
        this.paintSkillEffect(graphics);
        this.paintEffectHandlerOnLand(graphics);
        this.paintFighter(graphics);
        this.paintEffectHandler(graphics);
        this.paintMessage(graphics);
        this.updateEffectActor();
        this.disEffectActor();
        this.paintEffectActor(graphics, 0);
        this.paintInfoPanel(graphics);
    }

    public void openSkillEffect() {
        this._isPaintSkill = true;
    }

    public void closeSkillEffect() {
        this._isPaintSkill = false;
    }

    public void paintSkillEffect(Graphics graphics) {
        if (this._isPaintSkill) {
            Function.initAlphaArray(0, 75);
            Function.drawAlpha(graphics, 0, 320, 0, 0, 320, 240, true);
        }
    }

    private final void paintInfoPanel(Graphics graphics) {
        if (!this.canDrawPanel()) {
            return;
        }
        if (_messageBox == null) {
            this._infoPanel.draw(graphics);
        }
    }

    public boolean canDrawPanel() {
        switch (this._state) {
            case 7: 
            case 10: {
                return false;
            }
        }
        return !this._isPaintSkill;
    }

    public void speak(int n, String string, int n2, int n3) {
        int n4 = n / 10;
        int n5 = n % 10;
        int n6 = string.indexOf("\uff1a");
        String string2 = string.substring(0, n6);
        String string3 = string.substring(n6 + 1);
        GameRule gameRule = GameRule.getInstance();
        this.setDialogInfo(gameRule.getHeadSptInx(n4), string2, string3, n5, n2);
    }

    public void changeToEscapeFail() {
        this._roleEscapeFail = true;
        this._state = 14;
        this.showMessage(GameParameter.ESCAPE_FAIL);
    }

    private final void changeToShowVictory() {
        this._idelTimer = 10;
        this._state = 12;
    }

    private final void updateForShowVictory() {
        this.updateFighterStep();
        if (this.isIdleTimeOut()) {
            this.changeToVictoryHandle();
        }
    }

    private final void changeToShowLose() {
        this._state = 13;
    }

    private final void paintForShowLose(Graphics graphics) {
        this.changeToLoseHandle();
    }

    private final void showMessage(String string) {
        this.setInfo(string);
    }

    private final void showMessage(String[] stringArray, int n, boolean bl) {
        _messageBox = MessageBox.getInstance(this);
        _messageBox.initVictoryStyle(stringArray, n);
    }

    private final void showMessage(String[] stringArray, int n) {
        _messageBox = MessageBox.getInstance(this);
        _messageBox.initLevelUpInfoStyle(stringArray);
    }

    private final void paintMessage(Graphics graphics) {
        if (_messageBox != null) {
            _messageBox.draw(graphics);
        }
    }

    public void finishHandle(int n) {
        _messageBox = null;
        this._result = n;
        switch (this._state) {
            case 7: {
                break;
            }
            case 2: {
                this.battleFinishHandle();
                break;
            }
            case 6: {
                this.battleFinishHandle();
                break;
            }
            case 14: {
                this._state = 0;
            }
        }
    }

    public void escapeFailHandle() {
    }

    public final void startUpShake(int n, int n2) {
        if (this._shakeTime > 0) {
            return;
        }
        this._shakeTime = n;
        this._shakeRange = n2;
        int n3 = 0;
        while (n3 < this._fighterPainter.length) {
            if (this._fighterPainter[n3] != null) {
                this._fighterPainter[n3].startUpShake(n, n2);
            }
            ++n3;
        }
    }

    public void clearShake() {
        this._shakeTime = 0;
        this._cameraOffset = 0;
        int n = 0;
        while (n < this._fighterPainter.length) {
            if (this._fighterPainter[n] == null) {
                return;
            }
            this._fighterPainter[n].clearShake();
            ++n;
        }
    }

    private final boolean isFinishShake() {
        return this._shakeTime <= 0;
    }

    public void updateCameraOffset() {
        this._cameraOffset = this._shakeTime > 0 ? ((--this._shakeTime & 1) == 0 ? this._shakeRange : -this._shakeRange) : 0;
        int n = 0;
        while (n < this._fighterPainter.length) {
            if (this._fighterPainter[n] == null) {
                return;
            }
            this._fighterPainter[n].updateShake();
            ++n;
        }
    }

    private final void paintBK(Graphics graphics) {
        this._bk.drawToGraphics(graphics, this._cameraOffset);
    }

    private final void paintFighter(Graphics graphics) {
        if (this.needSort()) {
            this.sortForPaint();
        }
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighterPainter;
        int n2 = 0;
        while (n2 < n) {
            if (fighterArray[n2].canDraw()) {
                graphics.setClip(0, 0, 320, 240);
                if (fighterArray[n2]._anim.getSptset() != null) {
                    fighterArray[n2].draw(graphics, fighterArray[n2].getCameraOffset());
                }
            }
            ++n2;
        }
    }

    private final void sortForPaint() {
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighterPainter;
        int n2 = 1;
        while (n2 < n) {
            Fighter fighter = fighterArray[n2];
            int n3 = fighter.getPaintPrior();
            int n4 = n2;
            while (n4 > 0 && fighterArray[n4 - 1].getPaintPrior() > n3) {
                fighterArray[n4] = fighterArray[n4 - 1];
                --n4;
            }
            fighterArray[n4] = fighter;
            ++n2;
        }
        this.clearSortFlag();
    }

    public final void setSortFlag() {
        this._sortFlag = true;
    }

    private final void clearSortFlag() {
        this._sortFlag = false;
    }

    private final boolean needSort() {
        return this._sortFlag;
    }

    private final void paintFighterActionInfo(Graphics graphics) {
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighterPainter;
        int n2 = 0;
        while (n2 < n) {
            fighterArray[n2].drawActionInfo(graphics);
            ++n2;
        }
    }

    private final void paintFighterCommandInfo(Graphics graphics) {
        this._fighter[this._curFighterIndex].drawCommandInfo(graphics);
    }

    private final void changeToCommandState() {
        this._state = 0;
        this._curFighterIndex = -1;
        this.startUpNextFighterCommand();
        this._escapeFail = false;
    }

    private final void updateForCommand() {
        this.updateFighterStep();
        this.updateFighterCommand();
        this.checkCommandState();
    }

    private final void setCommandFinishFlag() {
        this._isFinishCommand = true;
    }

    private final void clearCommandFinishFlag() {
        this._isFinishCommand = false;
    }

    private final void checkCommandState() {
        if (this._isFinishCommand) {
            this.clearCommandFinishFlag();
            this.startUpNextFighterCommand();
        }
    }

    public final void notifySettingCommandFinish() {
        this.setCommandFinishFlag();
    }

    private final void updateFighterCommand() {
        this._fighter[this._curFighterIndex].command();
    }

    private final void startUpNextFighterCommand() {
        this._curFighterIndex = this.getNextFighterPosIndexForSettingCommand();
        if (this._curFighterIndex == -1) {
            this.changeToActionState();
        } else {
            this.startCurFighterCommand();
        }
    }

    private final int getNextFighterPosIndexForSettingCommand() {
        int n = this._curFighterIndex;
        do {
            if (++n < this._fighterNum) continue;
            return -1;
        } while (!this._fighter[n].canCommand());
        return n;
    }

    private final void startCurFighterCommand() {
        this._fighter[this._curFighterIndex].startUpCommand();
    }

    private final void updateFighterStep() {
        if (this._fighter == null) {
            return;
        }
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighter;
        int n2 = 0;
        while (n2 < n) {
            if (fighterArray[n2] != null) {
                fighterArray[n2].step();
            }
            ++n2;
        }
    }

    private final int getPreviousRolePosIndexForSettingCommand() {
        int n = this._curFighterIndex;
        Fighter[] fighterArray = this._fighter;
        do {
            if (--n >= 0) continue;
            return -1;
        } while (!(fighterArray[n] instanceof RoleFighter) || !fighterArray[n].canCommand());
        return n;
    }

    private final void startUpPreviousRoleCommand() {
        int n = this.getPreviousRolePosIndexForSettingCommand();
        this._curFighterIndex = n == -1 ? this._curFighterIndex : n;
        this.startCurFighterCommand();
    }

    public final void cancelSettingCommandHandle() {
        this.startUpPreviousRoleCommand();
    }

    private final void changeToActionState() {
        this._state = 1;
        this._curFighterIndex = -1;
        this.startUpNextFighterAction();
    }

    private final void updateForAcion() {
        this.updateFighterStep();
        this.updateFighterAI();
        this.checkActionState();
    }

    private final void checkActionState() {
        if (this.isFinishActionBout()) {
            if (this.isFinishEffectHandler()) {
                this.closeSkillEffect();
            }
            if (this._state != 0 && !this.isProduceBattleResult()) {
                this.changeToFinishAction();
            }
        }
    }

    private final boolean isFinishActionBout() {
        return this.isFinishShake() && this.isFinishShowInfo() && this.isEffectHandlerFinish() && this.isAllFighterFinishAction() && this.isAllFighterFinishEffect();
    }

    private final boolean isFinishEffectHandler() {
        return this.isEffectHandlerFinish();
    }

    private final boolean isAllFighterFinishAction() {
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighter;
        int n2 = 0;
        while (n2 < n) {
            if (!fighterArray[n2].isFinishAction()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final boolean isAllFighterFinishEffect() {
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighter;
        int n2 = 0;
        while (n2 < n) {
            if (!fighterArray[n2].checkEffectShowInfo()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final void startUpNextFighterAction() {
        this._curFighterIndex = this.getNextFighterPosIndexForAction();
        if (this._curFighterIndex == -1) {
            this.changeToBoutFinishState();
        } else {
            this.startCurFighterAction();
        }
    }

    private final int getNextFighterPosIndexForAction() {
        int n = this._curFighterIndex;
        do {
            if (++n < this._fighterNum) continue;
            return -1;
        } while (!this._fighter[n].canAction());
        return n;
    }

    private final void startCurFighterAction() {
        this._fighter[this._curFighterIndex].startUpAction();
    }

    private final void updateFighterAI() {
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighter;
        int n2 = 0;
        while (n2 < n) {
            fighterArray[n2].action();
            ++n2;
        }
    }

    private final void changeToBoutFinishState() {
        this._state = 4;
        this._roleEscapeFail = false;
        this.clearAllFighterState();
        this.updateFighterBoutFinishHandle();
    }

    private final void updateForBoutFinish() {
        this.updateFighterStep();
        this.updateFighterAI();
        if (this.isAllFighterFinishAction()) {
            this.changeToIdelState();
        }
    }

    private final void clearAllFighterState() {
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighter;
        int n2 = 0;
        while (n2 < n) {
            if (!fighterArray[n2].isDeath()) {
                fighterArray[n2].clearState();
            }
            ++n2;
        }
    }

    private final void updateFighterBoutFinishHandle() {
        int n = this._fighterNum;
        Fighter[] fighterArray = this._fighter;
        int n2 = 0;
        while (n2 < n) {
            if (fighterArray[n2].canBoutFinishHandle()) {
                fighterArray[n2].boutFinishHandle();
            }
            ++n2;
        }
    }

    public final void setLoseRoleFlag() {
        this._fighterChangeFlag = 1;
    }

    public final void setLoseEnemyFlag() {
        this._fighterChangeFlag = 2;
    }

    public final void clearFighterFlag() {
        this._fighterChangeFlag = 0;
    }

    private final boolean isProduceBattleResult() {
        switch (this._fighterChangeFlag) {
            case 1: {
                this.clearFighterFlag();
                return this.isProduceResuleByLoseRole();
            }
            case 2: {
                this.clearFighterFlag();
                return this.isProduceResuleByLoseEnemy();
            }
        }
        return this._state == 6;
    }

    private final boolean isProduceResuleByLoseRole() {
        if (!this.haveLiveRole()) {
            this.changeToShowLose();
            return true;
        }
        return false;
    }

    private final boolean isProduceResuleByLoseEnemy() {
        if (!this.haveLiveEnemy()) {
            this.changeToShowVictory();
            return true;
        }
        return false;
    }

    private final boolean haveLiveRole() {
        int n = 0;
        while (n < this._fighterNum) {
            if (this._fighter[n] instanceof RoleFighter && this._fighter[n].isExist()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean haveLiveEnemy() {
        int n = 0;
        while (n < this._fighterNum) {
            if (this._fighter[n] instanceof EnemyFighter && this._fighter[n].isExist() && this._fighter[n]._anim.getId() != 123) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final void changeToEscapeSuccess() {
        this._state = 6;
        this._curFighterIndex = -1;
        this._experienceForEach = 0;
        this.showMessage(GameParameter.C_BATTLE_INFO[0]);
    }

    private final void gameContinue() {
        this.dispose();
        this._mainLogic.changeToWorldScene();
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        scriptDriver.changeExecutor(GameMainLogic.getScene()._executor);
        if (WorldScene.getWorldInstance() != null) {
            WorldScene.getWorldInstance().changeToShowClose();
        }
        Function.changeSoundState(3, -1);
    }

    private final void gameOver() {
        this.dispose();
        this._mainLogic.changeToInterface(8);
    }

    private final void updateForEscapeSuccess() {
        this.updateFighterStep();
    }

    private final void changeToLoseHandle() {
        this._state = 3;
        this._curFighterIndex = -1;
        this._experienceForEach = 0;
        if (this._startOverFlag) {
            int n = 0;
            while (n < this._fighter.length) {
                if (this._fighter[n] != null && this._fighter[n]._type <= 2) {
                    this._fighter[n].changeToWait();
                    this._fighter[n].battleFinishHandler(0);
                    break;
                }
                ++n;
            }
            this.gameContinue();
        } else {
            GameMainLogic.getInstance()._smsui.smsBuy(6, 320, 240, "", 1);
        }
    }

    private final void updateForLose() {
        this.updateFighterStep();
    }

    private final void changeToVictoryHandle() {
        this._state = 2;
        this._curFighterIndex = -1;
        this.disposeVictoryInfo();
        this.calculateExperience();
        this.calculateExperienceForEach();
        this.obtainThings();
        this.obtainMoney();
        this.updateVictoryInfo();
        this.showMessage(this._victoryInfo, this._victoryRowNum, true);
        Function.changeSoundState(8, 1);
    }

    private void disposeVictoryInfo() {
        int n = 0;
        while (n < this._victoryInfo.length) {
            this._victoryInfo[n] = null;
            ++n;
        }
    }

    private final void obtainMoney() {
        this._obtainMoney = 0;
        int n = 0;
        while (n < this._fighterNum) {
            this._obtainMoney += this._fighter[n].getMoney();
            ++n;
        }
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        roleTeamData.increaseMoney(this._obtainMoney);
    }

    private final void obtainThings() {
        int n = 0;
        while (n < 20) {
            this._obtainThings[n] = -1;
            ++n;
        }
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int n2 = 0;
        int[] nArray = new int[]{-1, -1};
        if (Function.Random(3, true) > 1) {
            nArray[0] = Function.Random(this._fighterNum, true);
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] >= 0 && !this._fighter[nArray[n3]].isEscape()) {
                int[] nArray2 = this._fighter[nArray[n3]].getThing();
                if (nArray2 != null) {
                    int n4 = Function.Random(nArray2.length, true);
                    if (nArray2[n4] != -1 && nArray2[n4] != 0) {
                        this._obtainThings[n2++] = nArray2[n4];
                        if (Function.isThingInx(nArray2[n4])) {
                            roleTeamData.increaseThing(nArray2[n4]);
                        } else if (Function.isMaterialInx(nArray2[n4])) {
                            roleTeamData.increaseMaterial(nArray2[n4]);
                        } else {
                            roleTeamData.increaseComposeScroll(nArray2[n4]);
                        }
                    }
                } else {
                    nArray[n3] = Function.Random(this._fighterNum, true);
                    --n3;
                }
            }
            ++n3;
        }
    }

    private final void updateVictoryInfo() {
        int n = 0;
        StringBuffer stringBuffer = Function.getInfoBuffer();
        stringBuffer.append(GameParameter.C_BATTLE_INFO[6]);
        this._victoryInfo[n++] = stringBuffer.toString();
        stringBuffer = Function.getInfoBuffer();
        stringBuffer.append(GameParameter.C_BATTLE_INFO[8]);
        stringBuffer.append(this._experience);
        this._victoryInfo[n++] = stringBuffer.toString();
        stringBuffer = Function.getInfoBuffer();
        stringBuffer.append(GameParameter.C_BATTLE_INFO[7]);
        stringBuffer.append(this._obtainMoney);
        stringBuffer.append(GameParameter.C_BATTLE_INFO[9]);
        this._victoryInfo[n++] = stringBuffer.toString();
        GameDB gameDB = GameDB.getGameDataBase();
        this._victoryRowNum = n;
        int n2 = 0;
        while (n2 < 20) {
            stringBuffer = Function.getInfoBuffer();
            if (this._obtainThings[n2] != -1) {
                Object object;
                if (Function.isThingInx(this._obtainThings[n2])) {
                    object = gameDB.getThingData(this._obtainThings[n2]);
                    stringBuffer.append(object != null ? ((DataThing)object).getName() : "");
                } else if (Function.isMaterialInx(this._obtainThings[n2])) {
                    object = gameDB.getMaterialData(this._obtainThings[n2]);
                    stringBuffer.append(object != null ? ((DataMaterial)object).getName() : "");
                } else {
                    object = gameDB.getDataComposeScroll(this._obtainThings[n2]);
                    stringBuffer.append(object != null ? ((DataCompose)object).getName() : "");
                }
                this._victoryInfo[n++] = stringBuffer.toString();
            }
            ++n2;
        }
    }

    private final void calculateExperience() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._fighterNum) {
            n += this._fighter[n2].getExperience();
            ++n2;
        }
        this._experience = n;
    }

    private final void calculateExperienceForEach() {
        int n = this.getObtainExperienceFighter();
        this._experienceForEach = this._experience / n;
    }

    private final int getObtainExperienceFighter() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._fighterNum) {
            if (this._fighter[n2].canObtainExperience()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private final void battleFinishHandle() {
        boolean bl = this.battleHandleForEachFighter();
        if (bl) {
            this.gameContinue();
        }
    }

    private final boolean battleHandleForEachFighter() {
        while (true) {
            if (this._info == null) {
                ++this._curFighterIndex;
                if (this._curFighterIndex >= this._fighterNum) {
                    return true;
                }
                this._info = this._fighter[this._curFighterIndex].battleFinishHandler(this._experienceForEach);
                continue;
            }
            if (this.infoIndex < this._info.length) {
                this.showMessage(this._info[this.infoIndex], this._info[this.infoIndex].length);
                ++this.infoIndex;
                return false;
            }
            this.infoIndex = 0;
            this._info = null;
        }
    }

    private final void updateForVictory() {
        this.updateFighterStep();
    }

    public final int getRoleFighterForEffectByFriend(Fighter[] fighterArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._fighterNum) {
            if (this._fighter[n2] instanceof RoleFighter && this._fighter[n2].canEffectByFriend()) {
                fighterArray[n++] = this._fighter[n2];
            }
            ++n2;
        }
        return n;
    }

    public final int getRoleFighterForEffectByRival(Fighter[] fighterArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._fighterNum) {
            if (this._fighter[n2] instanceof RoleFighter && this._fighter[n2].canEffectByRival()) {
                fighterArray[n++] = this._fighter[n2];
            }
            ++n2;
        }
        return n;
    }

    public final int getEnemyFighterForEffectByFriend(Fighter[] fighterArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._fighterNum) {
            if (this._fighter[n2] instanceof EnemyFighter && this._fighter[n2].canEffectByFriend()) {
                fighterArray[n++] = this._fighter[n2];
            }
            ++n2;
        }
        return n;
    }

    public final int getEnemyFighterForEffectByRival(Fighter[] fighterArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._fighterNum) {
            if (this._fighter[n2] instanceof EnemyFighter && this._fighter[n2].canEffectByRival()) {
                fighterArray[n++] = this._fighter[n2];
            }
            ++n2;
        }
        return n;
    }

    public final void getRandomFighter(Fighter[] fighterArray, Fighter fighter) {
        int n = 0;
        int n2 = 0;
        while (n2 < this._fighterNum) {
            if (this._fighter[n2].isExist() && this._fighter[n2] != fighter) {
                fighterArray[n++] = this._fighter[n2];
            }
            ++n2;
        }
        fighterArray[0] = fighterArray[Function.Random(n, true)];
    }

    public void addEffectActor(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n6 & 0xFFFF;
        int n8 = 0;
        while (n8 < this._effectActor.length) {
            if (this._effectActor[n8] == null) {
                Animation animation = Animation.getAnimation(n);
                this._effectActor[n8] = Actor.createActor(n, animation);
                this._effectActor[n8].init(n2, n3, n6);
                this._effectActor[n8]._vx = (n4 - n2) / animation.getActFrmNum(n7);
                this._effectActor[n8]._vy = (n5 - n3) / animation.getActFrmNum(n7);
                break;
            }
            ++n8;
        }
    }

    private void disEffectActor() {
        int n = 0;
        while (n < this._effectActor.length) {
            if (this._effectActor[n] != null && this._effectActor[n]._actionEnd) {
                this._effectActor[n] = null;
            }
            ++n;
        }
    }

    private void paintEffectActor(Graphics graphics, int n) {
        int n2 = 0;
        while (n2 < this._effectActor.length) {
            if (this._effectActor[n2] != null) {
                this._effectActor[n2].draw(graphics, 0, 0, n);
            }
            ++n2;
        }
    }

    public boolean isEffectActorEmpty() {
        int n = 0;
        while (n < this._effectActor.length) {
            if (this._effectActor[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void updateEffectActor() {
        int n = 0;
        while (n < this._effectActor.length) {
            if (this._effectActor[n] != null) {
                this._effectActor[n].step();
            }
            ++n;
        }
    }

    public final void startup(int n, int n2, boolean bl) {
        this.changeToShowClose();
        this._Bbk = n;
        this._Bfk = n2;
        this._BisEscape = bl;
        RoleFighter.resetChooseInx();
    }

    private final void changeToShowClose() {
        this._state = 9;
        this._isFinishClose = false;
        this._changeEffectInx = 0;
        switch (this._changeEffectInx) {
            case 0: {
                this.initForShutterVertical();
            }
        }
    }

    private final boolean isFinishClose() {
        return this._isFinishClose;
    }

    private final void paintForClose(Graphics graphics) {
        switch (this._changeEffectInx) {
            case 0: {
                this.paintForCloseShutterVertical(graphics);
            }
        }
    }

    private final void paintForOpen(Graphics graphics) {
        this.paintCommon(graphics);
        switch (this._changeEffectInx) {
            case 0: {
                this.paintForOpenShutterVertical(graphics);
            }
        }
    }

    private final void paintShutterVertical(Graphics graphics) {
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0);
        int n = 16;
        while (n <= 336) {
            graphics.fillRect(n - this._shutterVerticalProcess, 0, this._shutterVerticalProcess << 1, 240);
            n += 32;
        }
    }

    private final void initForShutterVertical() {
        this._shutterVerticalProcess = 0;
    }

    private final void paintForCloseShutterVertical(Graphics graphics) {
        ++this._shutterVerticalProcess;
        if (this._shutterVerticalProcess > 16) {
            this._shutterVerticalProcess = 16;
            this._isFinishClose = true;
        }
        this.paintShutterVertical(graphics);
    }

    private final void paintForOpenShutterVertical(Graphics graphics) {
        --this._shutterVerticalProcess;
        if (this._shutterVerticalProcess < 0) {
            this._shutterVerticalProcess = 0;
            this.startupBattle();
        }
        this.paintShutterVertical(graphics);
    }

    private final void initialize(int n, int n2, boolean bl) {
        this.initBackGround(n, n2);
        this.initSceneData();
        this.initRoleFighter(bl);
        this.initEnemyFighter();
        this.copyToPaintFighter();
        this.sortForAction();
        this.reset();
        this.clearShake();
        this.changeToOpen();
        System.gc();
    }

    private final void changeToOpen() {
        this._state = 10;
    }

    private final void startupBattle() {
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        scriptDriver.changeExecutor(this._executor);
        if (scriptDriver.isExecuting()) {
            if (scriptDriver.getScenarioExec().getCurExecInx() == 0) {
                this.changeToScriptState();
            } else {
                this.changeToIdelState();
            }
        } else if (this.changeScript()) {
            this.changeToScriptState();
        } else {
            this.changeToIdelState();
        }
        this.clearKey();
        Function.changeSoundState(this._battleStartSound, -1);
    }

    public final int getBattleSoundIndex() {
        return this._battleStartSound;
    }

    public void reset() {
        this._bk.init();
        _effectHandler.setWanJianEffect(false);
        _effectHandler.setXieJianEffect(false);
    }

    private final void clearKey() {
        this._mainLogic.resetCurKey();
    }

    private final void sortForAction() {
        int n = 1;
        while (n < this._fighterNum) {
            Fighter fighter = this._fighter[n];
            int n2 = n;
            while (n2 > 0 && this._fighter[n2 - 1].getActionPrior() < fighter.getActionPrior()) {
                this._fighter[n2] = this._fighter[n2 - 1];
                --n2;
            }
            this._fighter[n2] = fighter;
            ++n;
        }
    }

    private final void initSceneData() {
        this.clearFighterFlag();
        this.clearCommandFinishFlag();
        this.setSortFlag();
        this._fighterNum = 0;
        this._roleEscapeFail = false;
    }

    private final void initRoleFighter(boolean bl) {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        boolean[] blArray = roleTeamData.getBattleInfo();
        int n = blArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (blArray[n3]) {
                this._roleFighter[n2].init(n3, n2, bl);
                this._roleFighter[n2].setIndexInOrder(this._fighterNum);
                this._fighter[this._fighterNum++] = this._roleFighter[n2];
                this._infoPanel.addRole(this._roleFighter[n2]);
                ++n2;
            }
            ++n3;
        }
    }

    private final void initEnemyFighter() {
        GameRule gameRule = GameRule.getInstance();
        this._battleStartSound = 6;
        int n = 0;
        int n2 = gameRule.getEnemyBattleMemberNum();
        int n3 = 0;
        while (n3 < n2) {
            this._enemyFighter[n3].init(n3);
            this._enemyFighter[n3].setIndexInOrder(this._fighterNum);
            this._fighter[this._fighterNum++] = this._enemyFighter[n3];
            this._infoPanel.addEnemy(this._enemyFighter[n++]);
            if (this._enemyFighter[n3].isBoss()) {
                this._battleStartSound = 7;
            }
            ++n3;
        }
    }

    private final void copyToPaintFighter() {
        System.arraycopy(this._fighter, 0, this._fighterPainter, 0, this._fighterNum);
    }

    public void dispose() {
        int n;
        int n2 = 0;
        while (n2 < 3) {
            this._roleFighter[n2].dispose();
            ++n2;
        }
        int n3 = 0;
        while (n3 < 3) {
            this._enemyFighter[n3].dispose();
            ++n3;
        }
        this._infoPanel.dispose();
        int n4 = 0;
        while (n4 < this._fighter.length) {
            this._fighter[n4] = null;
            ++n4;
        }
        if (this._scriptUnit != null) {
            n = 0;
            while (n < this._scriptUnit.length) {
                this._scriptUnit[n] = null;
                ++n;
            }
        }
        n = 0;
        while (n < this._effectActor.length) {
            this._effectActor[n] = null;
            ++n;
        }
        int n5 = 0;
        while (n5 < this._fighterPainter.length) {
            this._fighterPainter[n5] = null;
            ++n5;
        }
        this._bk.disActorInBK();
        int n6 = 0;
        while (n6 < this._actorPool.length) {
            if (this._actorPool[n6] != null) {
                int n7 = 0;
                while (n7 < this._actorPool[n6].length) {
                    this._actorPool[n6][n7] = null;
                    ++n7;
                }
                this._actorPool[n6] = null;
            }
            ++n6;
        }
        if (_messageBox != null) {
            _messageBox = null;
        }
        System.gc();
    }

    public final void sceneDispose() {
        this._bk.disActorInBK();
    }

    public final void clear() {
        if (this._bk != null) {
            this._bk.dispose();
            this._bk = null;
        }
    }

    public final GameMainLogic getMainLogic() {
        return this._mainLogic;
    }

    public final NewEffectHandle getEffectHandle() {
        return _effectHandler;
    }

    private final boolean isEffectHandlerFinish() {
        return !_effectHandler.isActioning();
    }

    private final void updateEffectHandler() {
        _effectHandler.update();
    }

    public void addFullScreenEffect() {
        if (!this._isFullEffectOpen) {
            return;
        }
        this.addFullScreenEffects(this._effectAni, this._effectAct);
    }

    public void addFullScreenEffects(int n, int n2) {
        int n3 = 0;
        int n4 = this._effectY << 10;
        int n5 = 5;
        int n6 = 10;
        int n7 = 320 / (n5 + 1) << 10;
        int n8 = 240 / (n5 * 3) << 10;
        switch (n) {
            case 111: {
                n5 = 5;
                if (n2 == 5) {
                    n6 = 13;
                    n3 += n7;
                    n4 = this._effectY << 10;
                    break;
                }
                n4 = this._effectY - 40 << 10;
                break;
            }
            case 112: {
                if (n2 == 7) {
                    n5 = 4;
                    n6 = 30;
                    n3 -= n7;
                    n4 = this._effectY - 24 << 10;
                    break;
                }
                if (n2 != 5) break;
                n5 = 3;
                n4 = this._effectY << 10;
                n6 = 20;
                break;
            }
            case 55: {
                n4 = this._effectY - 40 << 10;
                n3 += n7;
                n5 = 5;
                n6 = 15;
            }
        }
        int n9 = 0;
        int n10 = n4;
        int n11 = 0;
        while (n11 < n5) {
            n9 = n3;
            int n12 = 0;
            while (n12 < n5) {
                n9 += n7;
                if (Function.Random(n6, true) == 0) {
                    this.addEffectActor(n, n9, n10, n9, n10, n2);
                }
                ++n12;
            }
            n10 += n8;
            ++n11;
        }
    }

    private final void paintEffectHandler(Graphics graphics) {
        _effectHandler.draw(graphics);
    }

    private final void paintEffectHandlerOnLand(Graphics graphics) {
        _effectHandler.paintForTraceWanJianEffect(graphics);
    }

    public static final BattleScene getBattleInstance() {
        if (_instance == null) {
            _instance = BattleScene.produceBattleScene();
        }
        return _instance;
    }

    private final void initBackGround(int n, int n2) {
        this._startOverFlag = n2 == 1;
        this._infoPanel = BattlePanel.getInstance();
        if (this._bk != null) {
            if (this._bk.isEqual(n, n2)) {
                this._bk.init();
                return;
            }
            this._bk.dispose();
            this._bk = null;
        }
        this.produceBattleSceneInfo(n);
    }

    private static BattleScene produceBattleScene() {
        BattleScene battleScene = new BattleScene();
        battleScene._mainLogic = GameMainLogic.getInstance();
        battleScene._executor = new BattleExecutor(GameMainLogic.getGraphics(), battleScene);
        battleScene._roleFighter = new RoleFighter[3];
        int n = 0;
        while (n < 3) {
            battleScene._roleFighter[n] = new RoleFighter(battleScene);
            ++n;
        }
        battleScene._enemyFighter = new EnemyFighter[3];
        int n2 = 0;
        while (n2 < 3) {
            battleScene._enemyFighter[n2] = new EnemyFighter(battleScene);
            ++n2;
        }
        battleScene._fighter = new Fighter[6];
        battleScene._fighterPainter = new Fighter[6];
        battleScene._effectActor = new Actor[20];
        battleScene.sortForAction();
        return battleScene;
    }

    private BattleScene() {
    }

    public void loadBattleBK() {
    }

    private int getIndex(int n) {
        switch (n) {
            case 3: 
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    private final void changeToIdelState() {
        this._state = 8;
        this._idelTimer = 3;
    }

    private final boolean isIdleTimeOut() {
        return --this._idelTimer <= 0;
    }

    private final void updateForIdle() {
        this.updateFighterStep();
        if (this.isIdleTimeOut()) {
            if (this.changeScript()) {
                this.changeToScriptState();
            } else if (this._state != 0) {
                this.changeToCommandState();
            }
        }
    }

    private final void changeToFinishAction() {
        this._state = 11;
        this._idelTimer = 6;
    }

    private final void updateForFinishAction() {
        this.updateFighterStep();
        if (this.isIdleTimeOut()) {
            this.continueActionState();
        }
    }

    private final void continueActionState() {
        this._state = 1;
        this.startUpNextFighterAction();
    }

    public void miaoSha() {
        this._mainLogic._state = 2;
        this.changeToShowVictory();
        GameDB.loadDataSecond();
        int n = 0;
        while (n < GameRule.getInstance().getEnemyBattleMemberNum()) {
            this._enemyFighter[n].changeStateToDeath();
            ++n;
        }
        RoleFighter.clearMenu();
    }

    public int getCurBossHp() {
        int n = 0;
        while (n < GameRule.getInstance().getEnemyBattleMemberNum()) {
            int n2 = this._enemyFighter[n]._anim.getId();
            switch (n2) {
                case 30: 
                case 32: 
                case 33: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 60: {
                    return this._enemyFighter[n]._currentHp;
                }
            }
            ++n;
        }
        return -1;
    }

    public int getMaxBossHp() {
        int n = 0;
        while (n < this._enemyFighter.length) {
            if (this._enemyFighter[n]._anim != null) {
                int n2 = this._enemyFighter[n]._anim.getId();
                switch (n2) {
                    case 30: 
                    case 32: 
                    case 33: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 60: {
                        return this._enemyFighter[n]._maxHp;
                    }
                }
            }
            ++n;
        }
        return -1;
    }

    public void initScriptParam(int n) {
        this._scriptIndex = n;
    }

    public boolean checkScriptCondition() {
        return this._scriptUnit[this._scriptIndex].isSuccessInBattle(this.getCurBossHp(), this.getMaxBossHp());
    }

    public void triggerScript() {
        Script[] scriptArray = this._scriptUnit[this._scriptIndex].getScript();
        if (scriptArray != null) {
            ScriptDriver scriptDriver = ScriptDriver.getInstance();
            scriptDriver.addScript(scriptArray, this._executor);
        }
    }

    public boolean changeScript() {
        if (this._scriptUnit == null || this._scriptUnit.length == 0) {
            this._scriptIndex = 0;
            return false;
        }
        if (!this.checkScriptCondition()) {
            return false;
        }
        this.triggerScript();
        if (this._scriptIndex < this._scriptUnit.length - 1) {
            ++this._scriptIndex;
        } else {
            if (this._scriptIndex == this._scriptUnit.length - 1) {
                this._scriptUnit = null;
                return true;
            }
            return false;
        }
        return true;
    }

    public final void setInfo(String string) {
        _messageBox = MessageBox.getInstance(this);
        _messageBox.initSingleScrollStyle(string, 10);
    }

    public final void setDialogInfo(int n, String string, String string2, int n2, int n3) {
        _messageBox = MessageBox.getInstance(this);
        _messageBox.initDialogStyle(n, string, string2, n2, n3);
    }

    public final int getResult() {
        return this._result;
    }

    public final void question(String string, String string2, String string3) {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        gameMainLogic.resetCurKey();
        _messageBox = MessageBox.getInstance(this);
        String[] stringArray = new String[]{string, string2, string3};
        _messageBox.initQuestionStyle(stringArray);
    }

    public final boolean isFinishShowInfo() {
        return _messageBox == null;
    }

    public final Fighter getFighterByComplex(int n) {
        int n2 = 0;
        while (n2 < this._fighterNum) {
            if (this._fighter[n2]._type == n) {
                return this._fighter[n2];
            }
            ++n2;
        }
        return null;
    }

    public Fighter getFighterByIndexInOrder(int n) {
        return this._fighter[n];
    }

    private final void changeToScriptState() {
        this._state = 7;
    }

    public void updateScript() {
        this.updateFighterStep();
        ScriptDriver scriptDriver = ScriptDriver.getInstance();
        scriptDriver.exec();
        if (!scriptDriver.isExecuting()) {
            this.changeToCommandState();
            this.openOnceDrawBK();
        }
    }

    private void produceBattleSceneInfo(int n) {
        int n2 = n / 10;
        int n3 = n % 10;
        Scene._is = StreamReader.openDataFile("/res/scene" + n2 + ".bin", n3);
        this._id = n;
        try {
            this._sectorWidth = StreamReader.readShort(Scene._is);
            this._sectorHeight = StreamReader.readShort(Scene._is);
            String string = StreamReader.readString(Scene._is);
            int n4 = Scene._is.read();
            byte by = StreamReader.readByte(Scene._is);
            this._Bbk = StreamReader.readByte(Scene._is) + 40;
            this.produceBattleMap();
            this.produceSector();
            this.produceUnit();
            this.produceActor();
            this.startUpCamera();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void startUpCamera() {
        int n = this._camx >> 10;
        int n2 = this._camy >> 10;
        int n3 = n2 / this._sectorHeight * (this._bk.getMapWidth() / this._sectorWidth) + n / this._sectorWidth;
        int n4 = 0;
        while (this._sectorActorId[n3] != null && n4 < this._sectorActorId[n3].length) {
            this.fetchActorFromPool(-1, this._sectorActorId[n3][n4]);
            ++n4;
        }
        this._curSector = n3;
    }

    private void produceBattleMap() {
        this._bk = new TiledBackground(320, 240);
        this._bk.setFlipMapFlag(false);
        this._bk.setBattleFlag(true);
        this._bk.load(this._Bbk);
        int n = this._bk.getMapWidth();
        int n2 = this._bk.getMapHeight();
        this._bk.setPositionInMap(n - 320 >> 1, n2 - 240);
    }

    public Actor fetchActorFromPool(int n, int n2) {
        Actor actor = null;
        UnitData unitData = null;
        Actor[][] actorArray = this._actorPool;
        if (n < 0) {
            unitData = this.getUnitData(n2);
            if (unitData == null) {
                return null;
            }
            n = unitData.getPicId();
        }
        int n3 = actorArray[n].length;
        int n4 = 0;
        while (n4 < n3) {
            actor = actorArray[n][n4];
            if (!actor._active) break;
            ++n4;
        }
        if (n4 < n3 && n2 >= 0) {
            actor.init(unitData);
            actor._id = n2;
            actor._active = true;
            if (this.checkActorCondition(n)) {
                this._bk.addActorInfo(actor);
            }
            return actor;
        }
        return null;
    }

    static {
        _effectHandler = new NewEffectHandle();
    }
}

