/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.GameDB;
import com.sinaflying.engine.Animation;
import com.sinaflying.game.GameInterface;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.NPCActor;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.util.Function;
import java.util.Vector;

public class BattleGhost
extends NPCActor {
    public static final int ACTION_RANGE = 51200;
    public static final int VELOCITY = 3072;
    private static final int CHASE_RANGE = 48;
    private int _maxl;
    private int _maxr;
    private int _maxt;
    private int _maxb;
    private int[] _meberInx;
    private int _bkId;

    public BattleGhost(int n, Animation animation) {
        super(n, animation);
    }

    public void init(int n, int n2, int n3) {
        super.init(n, n2, n3);
    }

    public void ai() {
        if (RoleTeamData.getInstance()._stopGhost > 0) {
            this._vx = 0;
            this._vy = 0;
            return;
        }
        this.updateVx();
        this.updateVy();
        this.chaseRoleActor();
        this.checkRange();
        this.updateTriggerBattle();
    }

    public void step() {
        this.nextFrame();
        this.resetDxDy();
        this.checkLeftWall();
        this.checkBottomWall();
        this.checkRightWall();
        this.checkUpWall();
        this._x += this._dx;
        this._y += this._dy;
    }

    public void resetDxDy() {
        this._dx = this._vx;
        this._dy = this._vy;
    }

    public void updateTriggerBattle() {
        if (!this._scene.getMainActor()._enableAI || this._scene._messageBox != null) {
            return;
        }
        if (!this.isCollideMain()) {
            return;
        }
        if (GameInterface._paraValue[0] != 0) {
            return;
        }
        this._scene.getMainActor().changeToWait();
        int n = Function.Random(100, true);
        int n2 = n <= 20 ? 3 : (n > 20 && n < 70 ? 2 : 1);
        int n3 = GameParameter.getBkId(this._scene._id);
        this._scene.springBattle(this.getEnemyMember(n2), n3, n3);
        GameMainLogic.getBattleScene()._scriptUnit = this._data.getScriptUnit();
        GameMainLogic.getBattleScene().initScriptParam(this._data.getCurScriptDataIndex());
        this.disActive();
    }

    public int[] getEnemyMember(int n) {
        this._meberInx = new int[n];
        GameDB gameDB = GameDB.getGameDataBase();
        Vector vector = gameDB.getEnemyInxsByScene(this._scene._id);
        if (vector.isEmpty()) {
            System.out.println(" scene.id:  " + this._scene._id + "  enemyInx: isEmpty");
            return null;
        }
        int[] nArray = new int[vector.size()];
        Object[] objectArray = new Object[nArray.length];
        vector.copyInto(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length) {
            nArray[n2] = (Integer)objectArray[n2];
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < nArray.length) {
            int n5 = (Integer)vector.elementAt(n3++);
            nArray[n4++] = n5;
        }
        if (n4 <= 0) {
            System.out.println(" scene.id:  " + this._scene._id + "  validCount: isEmpty");
            return null;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        int n6 = 0;
        while (n6 < n) {
            this._meberInx[n6] = nArray2[Function.Random(nArray2.length, true)];
            ++n6;
        }
        return this._meberInx;
    }

    public void checkRange() {
        if (this._x < this._ox - 51200) {
            this._x = this._ox - 51200;
            this._vx = 3072;
        } else if (this._x > this._ox + 51200) {
            this._x = this._ox + 51200;
            this._vx = -3072;
        }
        if (this._y < this._oy - 51200) {
            this._y = this._oy - 51200;
            this._vy = 3072;
        } else if (this._y > this._oy + 51200) {
            this._y = this._oy + 51200;
            this._vy = -3072;
        }
    }

    public void updateVx() {
        if (this._vx == 0) {
            this._vx = 3072;
        }
        if (Function.Random(100, true) > 88) {
            this._vx = -this._vx;
        }
    }

    public void updateVy() {
        if (this._vy == 0) {
            this._vy = 3072;
        }
        if (Function.Random(100, true) > 95) {
            this._vy = -this._vy;
        }
    }

    private void chaseRoleActor() {
        if (this.isChaseRange()) {
            this.checkChaseRange();
        }
    }

    private boolean isChaseRange() {
        int n = this._ox - 51200;
        int n2 = this._ox + 51200;
        int n3 = this._oy - 51200;
        int n4 = this._oy + 51200;
        int n5 = this._scene.getMainActor()._x;
        int n6 = this._scene.getMainActor()._y;
        return n5 <= n2 && n5 >= n && n6 <= n4 && n6 >= n3;
    }

    public void checkChaseRange() {
        RoleActor roleActor = this._scene.getMainActor();
        if (this._x < roleActor._x) {
            this._vx = 3072;
        } else if (this._x > roleActor._x) {
            this._vx = -3072;
        }
        if (this._y < roleActor._y) {
            this._vy = 3072;
        } else if (this._y > roleActor._y) {
            this._vy = -3072;
        }
    }
}

