/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.engine.TiledBackground;
import com.sinaflying.game.BattleGhost;
import com.sinaflying.game.Chest;
import com.sinaflying.game.Decorate;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.Human;
import com.sinaflying.game.RoleActor;
import com.sinaflying.game.Scene;
import com.sinaflying.game.UnitData;
import com.sinaflying.gameUtil.Searcher;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

public class Actor {
    private static final int C_TYPE_MAIN_ACTOR_MAN = 0;
    private static final int C_TYPE_MAIN_ACTOR_WOMAN = 1;
    private static final int C_TYPE_EFFECT1 = 101;
    private static final int C_TYPE_EFFECT2 = 102;
    private static final int C_TYPE_EFFECT3 = 105;
    private static final int C_TYPE_EFFECT4 = 107;
    private static final int C_TYPE_FIGURE = 124;
    private static final int C_TYPE_DEAD_MAN1 = 22;
    private static final int C_TYPE_DEAD_MAN2 = 31;
    public static final int C_BOX_COLLISON = 0;
    public static final int C_BOX_ATTACK = 1;
    public boolean _active;
    public boolean _visible;
    protected int _type;
    protected int _flicker;
    protected int _actionNum;
    public int _curAction;
    public int _action;
    protected int _flipFlag;
    protected boolean _isFlip;
    protected boolean _enableAI;
    protected boolean _validFlag;
    public boolean _loopAction;
    protected int _curFrame;
    protected boolean _actionEnd;
    protected short _actFrmNum;
    protected int _l;
    protected int _r;
    protected int _t;
    protected int _b;
    protected int _vl;
    protected int _vr;
    protected int _vt;
    protected int _vb;
    protected int _al;
    protected int _ar;
    protected int _at;
    protected int _ab;
    public int _id;
    public int _x;
    public int _y;
    public int _vx;
    public int _vy;
    public int _avx;
    public int _avy;
    public int _palNo;
    public int _trace;
    public int _dx;
    public int _dy;
    public int _ox;
    public int _oy;
    public int _loopNumber;
    protected Animation _anim;
    protected int _zoomNum;
    protected GameMainLogic _mainLogic;
    protected Scene _scene;
    protected TiledBackground _bk;
    private int _paramScenario = 0;
    private int _ticks;
    private boolean _zoomDraw;
    public static final int MAX_NUMBER = 10;
    public static final int CONTORT_APPEAR = 1;
    public static final int CONTORT_DISPAPPEAR = 2;
    private int _current;
    private int _sum;
    private int _contortStyle;
    private boolean _openContort;
    private boolean _contortEnd;
    static int isFly = 0;
    private boolean arriveDesFlagForMove;
    protected int _miny;
    protected int _maxy;
    protected int _svy;
    protected int _time;
    protected static final int C_FACE_TO_LEFT = 0;
    protected static final int C_FACE_TO_RIGHT = 1;
    protected static final int C_FACE_TO_BACK = 2;
    protected static final int C_FACE_TO_FRONT = 3;
    protected static final int C_ACT_RIGHT_WAIT = 1;
    protected static final int C_ACT_RIGHT_WALK = 6;
    protected static final int C_ACT_LEFT_WAIT = -2147483647;
    protected static final int C_ACT_LEFT_WALK = -2147483642;
    protected static final int C_ACT_FRONT_WAIT = 0;
    protected static final int C_ACT_FRONT_WALK = 5;
    protected static final int C_ACT_BACK_WAIT = 2;
    protected static final int C_ACT_BACK_WALK = 7;
    protected static final int C_ACT_RIGHT_UP_WAIT = 4;
    protected static final int C_ACT_RIGHT_UP_WALK = 9;
    protected static final int C_ACT_RIGHT_DOWN_WAIT = 3;
    protected static final int C_ACT_RIGHT_DOWN_WALK = 8;
    protected static final int C_ACT_LEFT_UP_WAIT = -2147483644;
    protected static final int C_ACT_LEFT_UP_WALK = -2147483639;
    protected static final int C_ACT_LEFT_DOWN_WAIT = -2147483645;
    protected static final int C_ACT_LEFT_DOWN_WALK = -2147483640;
    public static final int C_ACTOR_WALK_SPEED = 7;
    private static final int C_RIGHT_WALK_VX = 7168;
    private static final int C_RIGHT_WALK_VY = 0;
    private static final int C_LEFT_WALK_VX = -7168;
    private static final int C_LEFT_WALK_VY = 0;
    private static final int C_FRONT_WALK_VX = 0;
    private static final int C_FRONT_WALK_VY = 7168;
    private static final int C_BACK_WALK_VX = 0;
    private static final int C_BACK_WALK_VY = -7168;
    private static final int C_RIGHTUP_WALK_VX = Function.cos(30) * 7 / 1024 << 10;
    private static final int C_RIGHTUP_WALK_VY = -(Function.sin(30) * 7 / 1024) << 10;
    private static final int C_LEFTUP_WALK_VX = -(Function.cos(30) * 7 / 1024) << 10;
    private static final int C_LEFTUP_WALK_VY = -(Function.sin(30) * 7 / 1024) << 10;
    private static final int C_RIGHTDOWN_WALK_VX = Function.cos(30) * 7 / 1024 << 10;
    private static final int C_RIGHTDOWN_WALK_VY = Function.sin(30) * 7 / 1024 << 10;
    private static final int C_LEFTDOWN_WALK_VX = -(Function.cos(30) * 7 / 1024) << 10;
    private static final int C_LEFTDOWN_WALK_VY = Function.sin(30) * 7 / 1024 << 10;
    protected static final int C_DIPMOVE_NULL = 0;
    protected static final int C_DIPMOVE_LEFTUP = 1;
    protected static final int C_DIPMOVE_LEFTDOWN = 2;
    protected static final int C_DIPMOVE_RIGHTUP = 3;
    protected static final int C_DIPMOVE_RIGHTDOWN = 4;
    private int _dipMoveFlag;
    private int _autoPathOffsetX;
    private int _autoPathOffsetY;
    private byte[][] path;
    private int pathIndex;
    private boolean arriveDesFlag;
    private int destinationX;
    private int destinationY;
    private static final int C_NONE_EXPRESSION = -1;
    private int _expressionAction;
    private int _expressionFrame;
    private int _expressionMaxFrame;
    private static final int C_EXPRESSION_X_OFFSET = 0;
    private static final int C_EXPRESSION_y_OFFSET = -50;
    private int _expressionTimer;
    int[] _result = new int[1];
    public static final int AREASIGN_TOP = 1;
    public static final int AREASIGN_BOTTOM = 2;
    public static final int AREASIGN_LEFT = 3;
    public static final int AREASIGN_RIGHT = 4;
    public boolean collided315angle;

    public Actor(int n, Animation animation) {
        this._type = n;
        this._anim = animation;
        this._actionNum = animation.getActionNum();
        this._active = false;
    }

    public Animation getAni() {
        return this._anim;
    }

    public int getAniInx() {
        return this._type;
    }

    public int getCurFrame() {
        return this._curFrame;
    }

    public static final Actor createActor(int n, Animation animation) {
        switch (n) {
            case 0: 
            case 1: {
                return new RoleActor(n, animation);
            }
            case 98: 
            case 99: {
                return new BattleGhost(n, animation);
            }
            case 118: {
                return new Chest(n, animation);
            }
        }
        if (Actor.isHuman(n)) {
            return new Human(n, animation);
        }
        return new Decorate(n, animation);
    }

    private static final boolean isHuman(int n) {
        switch (n) {
            case 10: 
            case 100: {
                return true;
            }
        }
        return false;
    }

    public boolean init(UnitData unitData) {
        this.resetData();
        this._x = unitData.getPosX() << 10;
        this._y = unitData.getPosY() << 10;
        this._ox = this._x;
        this._oy = this._y;
        this._palNo = 0;
        int n = unitData.getActionIndex();
        if (unitData.isFlipX()) {
            n |= Integer.MIN_VALUE;
        }
        if (unitData.isFlipY()) {
            n |= 0x40000000;
        }
        this._validFlag = unitData.isValidActor();
        this.changeAction(n);
        if (unitData.getParameter() != null) {
            this._palNo = unitData.getParameter()[5];
            this._paramScenario = unitData.getParameter()[2];
        } else {
            this._paramScenario = 0;
        }
        return true;
    }

    public int getParamScenario() {
        return this._paramScenario - 1;
    }

    public void resetData() {
        this._enableAI = true;
        this._validFlag = true;
        this._vy = 0;
        this._vx = 0;
        this._flicker = 0;
        this._loopAction = true;
        this._expressionAction = -1;
    }

    public void init(int n, int n2, int n3) {
        this._x = n;
        this._y = n2;
        this._ox = n;
        this._oy = n2;
        this.changeAction(n3);
    }

    public void init(UnitData unitData, int n, int n2) {
        this.init(unitData);
        this._x += n << 10;
        this._y += n2 << 10;
        this._ox = this._x;
        this._oy = this._y;
    }

    public void initloop(int n) {
        this._loopNumber = n;
    }

    public void enableAI(boolean bl) {
        this._enableAI = bl;
        this.changeToWait();
    }

    public Actor activate(Scene scene, int n) {
        this._id = n;
        this._active = true;
        this._scene = scene;
        this._mainLogic = scene.getGameLogic();
        this._bk = scene.getBackground();
        return this;
    }

    public final void setValidFlag(boolean bl) {
        this._validFlag = bl;
        this._scene.setInstsInvalid();
    }

    public void disActive() {
        this._scene.disActiveInst(this._id);
    }

    public void disLife() {
        this._scene.disLifeInst(this._id);
    }

    public void changeAction(int n) {
        this._curAction = n;
        n &= 0xFFFF;
        if ((this._curAction & Integer.MIN_VALUE) == 0) {
            this._l = this._anim.getCollideLeft(n);
            this._r = this._anim.getCollideRight(n);
            this._vl = this._anim.getVisibleLeft();
            this._vr = this._anim.getVisibleRight();
        } else {
            this._l = -this._anim.getCollideRight(n);
            this._r = -this._anim.getCollideLeft(n);
            this._vl = -this._anim.getVisibleRight();
            this._vr = -this._anim.getVisibleLeft();
        }
        if ((this._curAction & 0x40000000) == 0) {
            this._t = this._anim.getCollideTop(n);
            this._b = this._anim.getCollideBottom(n);
            this._vt = this._anim.getVisibleTop();
            this._vb = this._anim.getVisibleBottom();
        } else {
            this._t = -this._anim.getCollideBottom(n);
            this._b = -this._anim.getCollideTop(n);
            this._vt = -this._anim.getVisibleBottom();
            this._vb = -this._anim.getVisibleTop();
        }
        this._actFrmNum = this._anim.getActFrmNum(n);
        this._curFrame = 0;
        this._action = n;
        this._actionEnd = false;
        this._flipFlag = this._curAction & 0xF0000000;
        this._isFlip = (this._curAction & 0xF0000000) != 0;
    }

    public final void nextFrame() {
        ++this._curFrame;
        if (this._curFrame == this._actFrmNum - 1) {
            this._actionEnd = true;
        }
        if (this._curFrame >= this._actFrmNum) {
            this._curFrame = this._loopAction ? 0 : --this._curFrame;
            if (--this._loopNumber > 0) {
                this._curFrame = 0;
                this._actionEnd = false;
            }
            this._actionEnd = false;
        }
    }

    public final boolean isActionEnd() {
        return this._actionEnd;
    }

    public void step() {
        if (this.isExecuteStep()) {
            this.nextFrame();
            this._vx += this._avx;
            this._vy += this._avy;
            this._x += this._vx;
            this._y += this._vy;
        }
    }

    public void ai() {
        switch (this._type) {
            case 95: 
            case 102: 
            case 105: 
            case 107: 
            case 123: {
                int n = this._curAction;
                if ((n &= 0xFFFF) == 3 || n == 2) {
                    return;
                }
                if (!this._actionEnd) break;
                this.disLife();
                break;
            }
            case 101: {
                if (this._actionEnd) {
                    if (this._curAction != 4 && this._curAction != 5) {
                        this.disLife();
                    } else {
                        this.changeAction(5);
                        this._ticks = 5 + Function.Random(20, true);
                    }
                }
                if (this._curAction != 5 || --this._ticks != 0) break;
                this.changeAction(4);
                this._x = this._ox + (Function.Random(9, true) << 10) * this._bk._bktw;
                this._y = this._oy - (Function.Random(9, true) << 10) * this._bk._bkth;
            }
        }
    }

    public final boolean isValid() {
        return this._validFlag;
    }

    public final boolean isExecuteAI() {
        return !this.hasAutoPassAI() && this._enableAI;
    }

    public final boolean isExecuteStep() {
        return !this.hasAutoPassStep() && !this.hasAutoMoveStep();
    }

    public boolean drawEffectEnd() {
        return !this._contortEnd && !this._openContort;
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this._visible = false;
        if (this._flicker == 0 || --this._flicker > 0 && (this._flicker & 1) != 0) {
            int n4 = (this._x >> 10) - n + n3;
            int n5 = (this._y >> 10) - n2 + n3;
            if (n4 + this._vr < 0 || n4 + this._vl > 320) {
                return;
            }
            if (n5 + this._vb < 0 || n5 + this._vt > 240) {
                return;
            }
            this._visible = true;
            try {
                if (this._openContort) {
                    this.drawEffectProcess(graphics, n4, n5, this._curAction, this._curFrame, this._palNo, -this._vl + this._vr, -this._vt + this._vb);
                } else if (this._zoomDraw) {
                    this._anim.drawZoomEasy(graphics, n4, n5, this._curAction, this._curFrame, this._palNo, this._zoomNum);
                } else {
                    this._anim.draw(graphics, n4, n5, this._curAction, this._curFrame, this._palNo);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.drawExpression(graphics, n4, n5);
            this.drawShelter(graphics);
        }
    }

    public void drawClip(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this._visible = false;
        if (this._flicker == 0 || --this._flicker > 0 && (this._flicker & 1) != 0) {
            int n9 = (this._x >> 10) - n + n3;
            int n10 = (this._y >> 10) - n2 + n4;
            if (n9 + this._vr < 0 || n9 + this._vl > 320) {
                return;
            }
            if (n10 + this._vb < 0 || n10 + this._vt > 240) {
                return;
            }
            this._visible = true;
            this._anim.drawClip(graphics, n9, n10, this._curAction, this._curFrame, this._palNo, n5, n6, n7, n8);
        }
    }

    public void openZoomDraw() {
        this._zoomDraw = true;
    }

    public void closeZoomDraw() {
        this._zoomDraw = false;
    }

    public void initContortPara(int n) {
        this._contortStyle = n;
        this._openContort = true;
        this._contortEnd = false;
        switch (n) {
            case 1: {
                this._current = 0;
                break;
            }
            case 2: {
                this._current = 10;
            }
        }
        this._sum = 10;
    }

    public void drawEffectProcess(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (this._contortStyle) {
            case 1: {
                if (this._current < 10) {
                    ++this._current;
                    this.drawEffect(graphics, this._current, this._sum, 0, this._anim, n3, n4, n5, n, n2, n6, n7, 5);
                    break;
                }
                this._contortEnd = true;
                break;
            }
            case 2: {
                if (this._current > 0) {
                    --this._current;
                    this.drawEffect(graphics, this._current, this._sum, 0, this._anim, n3, n4, n5, n, n2, n6, n7, 5);
                    break;
                }
                this._contortEnd = true;
                this._scene.disActiveInst(this._id);
            }
        }
        if (this._contortEnd) {
            this._contortEnd = false;
            this._openContort = false;
        }
    }

    public void drawEffect(Graphics graphics, int n, int n2, int n3, Animation animation, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int n12;
        int n13;
        if (n3 == 0) {
            n13 = n9;
            n12 = n10;
        } else {
            n12 = n10;
            n13 = n9;
        }
        int n14 = n13 / 2;
        int n15 = n12 / 1;
        int n16 = n13 * n / n2;
        int n17 = n13 * (n2 - n) / (n2 * 4);
        int n18 = 360 * n / n2;
        int n19 = 360 * n11 / n15;
        int n20 = 0;
        while (n20 < n15) {
            int n21 = n17 * Function.cos(n18) >> 10;
            if (n3 == 0) {
                animation.drawClip(graphics, n7 + n21, n8, n4, n5, n6, n7 + this._vl + n14 - n16 / 2 + n21, n8 + this._vt + n20 * 1, n16, 1);
            } else {
                animation.drawClip(graphics, n7, n8 + n21, n4, n5, n6, n7 + this._vl + n20 * 1, n8 + this._vt + n14 - n16 / 2 + n21, 1, n16);
            }
            n18 += n19;
            ++n20;
        }
    }

    private final void drawCollideBox(Graphics graphics, int n, int n2) {
        int n3 = this._r - this._l;
        int n4 = this._b - this._t;
        graphics.setClip(0, 0, 320, 240);
        graphics.setColor(0xFF0000);
        graphics.drawRect(n += this._l, n2 += this._t, n3, n4);
    }

    private final void drawShelter(Graphics graphics) {
        TiledBackground tiledBackground = this._bk;
        if (this._bk == null) {
            return;
        }
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        int n3 = tiledBackground.conversionTileIndexLeft(n + -18);
        int n4 = tiledBackground.conversionTileIndexRight(n + 12);
        int n5 = tiledBackground.conversionTileIndexTop(n2 + -50);
        int n6 = tiledBackground.conversionTileIndexBottom(n2 + 4);
        int n7 = n5;
        while (n7 <= n6) {
            int n8 = n3;
            while (n8 <= n4) {
                if (this.isShelterTile(n6, n8, n7)) {
                    tiledBackground.drawShelterTile(graphics, n8, n7);
                }
                ++n8;
            }
            ++n7;
        }
    }

    private final boolean isShelterTile(int n, int n2, int n3) {
        TiledBackground tiledBackground = this._bk;
        while (tiledBackground.isShelterPhy(n2, n3)) {
            if (n3++ < n) continue;
            return true;
        }
        return false;
    }

    public final boolean isVisible() {
        return this._visible;
    }

    public boolean collide(int n, int n2, int n3, int n4) {
        if (this._l == this._r || this._t == this._b || n == n3 || n2 == n4) {
            return false;
        }
        int n5 = (this._x >> 10) + this._l;
        int n6 = (this._x >> 10) + this._r;
        int n7 = (this._y >> 10) + this._t;
        int n8 = (this._y >> 10) + this._b;
        return n6 > n && n5 < n3 && n8 > n2 && n7 < n4;
    }

    public final boolean collide(UnitData unitData) {
        short[] sArray = unitData.getArea();
        short s = sArray[0];
        short s2 = sArray[1];
        short s3 = sArray[2];
        short s4 = sArray[3];
        return this.collide(s, s3, s2, s4);
    }

    protected final void collideHandle(Actor actor) {
        switch (this._curAction) {
            case -2147483647: 
            case -2147483642: 
            case 1: 
            case 6: {
                if (this._x < actor._x) {
                    int n = actor._x + (actor._l << 10);
                    this._x = n - (this._r << 10);
                } else {
                    int n = actor._x + (actor._r << 10);
                    this._x = n - (this._l << 10);
                }
                this._vx = 0;
                break;
            }
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                if (this._y < actor._y) {
                    int n = actor._y + (actor._t << 10);
                    this._y = n - (this._b << 10);
                } else {
                    int n = actor._y + (actor._b << 10);
                    this._y = n - (this._t << 10);
                }
                this._vy = 0;
                break;
            }
            case -2147483640: 
            case -2147483639: 
            case 8: 
            case 9: {
                this._x -= this._vx;
                this._y -= this._vy;
                this._vx = 0;
                this._vy = 0;
            }
        }
    }

    public boolean collide(Actor actor) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        n = this._l;
        n2 = this._r;
        n3 = this._t;
        n4 = this._b;
        if (n == n2 || n3 == n4) {
            return false;
        }
        return actor.collide(n += this._x >> 10, n3 += this._y >> 10, n2 += this._x >> 10, n4 += this._y >> 10);
    }

    public int getXDirLocation(int n) {
        return this._x - (n >> 1);
    }

    public int getYDirLocation(int n) {
        return this._y - (n >> 1);
    }

    public void paintInfo(Graphics graphics) {
    }

    protected final void setSkin(int n) {
        int n2 = this._anim.getSkinNum();
        this._palNo = n < n2 ? n : n2 - 1;
    }

    public final int getCol() {
        return (this._x >> 10) / this._bk._bktw;
    }

    public final int getRow() {
        return (this._y >> 10) / this._bk._bkth;
    }

    public final int getPosX() {
        return this._x;
    }

    public int getEffectPosY() {
        return this._anim.getVisibleBottom() - this._anim.getVisibleTop() + 10 << 10;
    }

    public final int getPosY() {
        return this._y;
    }

    public final int getPosXX() {
        return this._x >> 10;
    }

    public final int getPosYY() {
        return this._y >> 10;
    }

    public final void setPosByCoordinate(int n, int n2) {
        this._x = n;
        this._y = n2;
    }

    private void changeToFly(int n) {
        switch (n) {
            case 6: {
                this._vx = 10240;
                this._vy = 0;
                this.changeAction(1);
                break;
            }
            case -2147483642: {
                this._vx = -10240;
                this._vy = 0;
                this.changeAction(-2147483647);
                break;
            }
            case 5: {
                this._vx = 0;
                this._vy = 10240;
                this.changeAction(0);
                break;
            }
            case 7: {
                this._vx = 0;
                this._vy = -10240;
                this.changeAction(2);
            }
        }
    }

    protected void changeToWalk(int n) {
        if (GameMainLogic.isFly && isFly == 1) {
            this.changeToFly(n);
        } else {
            if (this.path != null) {
                switch (n) {
                    case 6: {
                        this._vx = 7168;
                        this._vy = 0;
                        break;
                    }
                    case -2147483642: {
                        this._vx = -7168;
                        this._vy = 0;
                        break;
                    }
                    case 5: {
                        this._vx = 0;
                        this._vy = 7168;
                        break;
                    }
                    case 7: {
                        this._vx = 0;
                        this._vy = -7168;
                        break;
                    }
                    case 9: {
                        this._vx = C_RIGHTUP_WALK_VX;
                        this._vy = C_RIGHTUP_WALK_VY;
                        break;
                    }
                    case 8: {
                        this._vx = C_RIGHTDOWN_WALK_VX;
                        this._vy = C_RIGHTDOWN_WALK_VY;
                        break;
                    }
                    case -2147483639: {
                        this._vx = C_LEFTUP_WALK_VX;
                        this._vy = C_LEFTUP_WALK_VY;
                        break;
                    }
                    case -2147483640: {
                        this._vx = C_LEFTDOWN_WALK_VX;
                        this._vy = C_LEFTDOWN_WALK_VY;
                    }
                }
                switch (this._type) {
                    case 10: {
                        n = 3;
                    }
                }
            } else {
                switch (n) {
                    case 6: {
                        this._vx = 7168;
                        this._vy = 0;
                        break;
                    }
                    case -2147483642: {
                        this._vx = -7168;
                        this._vy = 0;
                        break;
                    }
                    case 5: {
                        this._vx = 0;
                        this._vy = 7168;
                        break;
                    }
                    case 7: {
                        this._vx = 0;
                        this._vy = -7168;
                        break;
                    }
                    case 9: {
                        this._vx = C_RIGHTUP_WALK_VX;
                        this._vy = C_RIGHTUP_WALK_VY;
                        break;
                    }
                    case 8: {
                        this._vx = C_RIGHTDOWN_WALK_VX;
                        this._vy = C_RIGHTDOWN_WALK_VY;
                        break;
                    }
                    case -2147483639: {
                        this._vx = C_LEFTUP_WALK_VX;
                        this._vy = C_LEFTUP_WALK_VY;
                        break;
                    }
                    case -2147483640: {
                        this._vx = C_LEFTDOWN_WALK_VX;
                        this._vy = C_LEFTDOWN_WALK_VY;
                    }
                }
            }
            if (this.collided315angle && (this._scene.getID() == 24 ? this.changeToWalkOf45angle(n) : this.changeToWalkOf315angle(n))) {
                return;
            }
            if (this._curAction == n) {
                return;
            }
            this.changeAction(n);
        }
    }

    public final void stop() {
        this.changeToWait();
    }

    protected void changeToWait() {
        this._vy = 0;
        this._vx = 0;
        switch (this._curAction) {
            case 6: {
                this.changeAction(1);
                break;
            }
            case -2147483642: {
                this.changeAction(-2147483647);
                break;
            }
            case 5: {
                this.changeAction(0);
                break;
            }
            case 7: {
                this.changeAction(2);
                break;
            }
            case 9: {
                this.changeAction(4);
                break;
            }
            case -2147483639: {
                this.changeAction(-2147483644);
                break;
            }
            case 8: {
                this.changeAction(3);
                break;
            }
            case -2147483640: {
                this.changeAction(-2147483645);
            }
        }
    }

    public boolean hasAutoMoveStep() {
        if (this._trace == 1) {
            this.nextFrame();
            this._vx += this._avx;
            this._vy += this._avy;
            this._x += this._vx;
            this._y += this._vy;
            this.updateForMoveTo();
            return true;
        }
        return false;
    }

    public void moveTo(int n, int n2, int n3) {
        this.arriveDesFlagForMove = false;
        this._trace = 1;
        this.destinationX = (n << 10) * this._bk._bktw;
        this.destinationY = (n2 << 10) * this._bk._bkth;
        this._vy = (this.destinationY - this._y) / n3;
        this._vx = (this.destinationX - this._x) / n3;
    }

    private void updateForMoveTo() {
        if (this.checkPassDestination()) {
            this._vx = 0;
            this._vy = 0;
        }
    }

    public void startToShake(int n, int n2, int n3) {
        this._time = n3;
        this._vy = this._svy = n << 10;
        this._maxy = this._y + (n2 << 10) / 4;
        this._miny = this._y - (n2 << 10) / 4;
    }

    protected void updateForShake() {
        this._scene.updateCameraOffset();
    }

    protected void stopShake() {
        this._vy = 0;
        this._y = (this._miny + this._maxy) / 2;
    }

    public void BlinkToPosition(int n, int n2, int n3) {
        this._x = (n << 10) * this._bk._bktw;
        this._y = (n2 << 10) * this._bk._bkth;
        this.changeAction(n3);
    }

    public void setPosByTile(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        this._x = n3 << 10;
        this._y = n4 << 10;
    }

    protected boolean checkFaceToFace(Actor actor) {
        int n = actor._x;
        int n2 = actor._y;
        switch (this._curAction) {
            case 1: 
            case 6: {
                return this._x < n;
            }
            case -2147483647: 
            case -2147483642: {
                return this._x > n;
            }
            case 0: 
            case 5: {
                return this._y < n2;
            }
            case 2: 
            case 7: {
                return this._y > n2;
            }
        }
        return false;
    }

    protected final int getFaceDirection() {
        switch (this._curAction) {
            case 1: 
            case 6: {
                return 1;
            }
            case -2147483647: 
            case -2147483642: {
                return 0;
            }
            case 0: 
            case 5: {
                return 3;
            }
        }
        return 2;
    }

    protected void setDipMoveFlag(int n) {
        this._dipMoveFlag = n;
    }

    private final boolean hasAutoPathOffset() {
        return this._autoPathOffsetX != 0 || this._autoPathOffsetY != 0;
    }

    private boolean hasAutoPassStep() {
        if (this.path != null) {
            this.nextFrame();
            this._x += this._vx;
            this._y += this._vy;
            this.checkPassDestination();
            return true;
        }
        return false;
    }

    private boolean hasAutoPassAI() {
        if (this.path == null) {
            return false;
        }
        if (this.arriveDesFlag) {
            if (this.hasAutoPathOffset()) {
                this.nextOffset();
            } else {
                this.nextDestination();
            }
            this.startNextDestination();
        }
        return true;
    }

    private final void nextOffset() {
        if (this._autoPathOffsetX != 0) {
            this.destinationX = this._x + this._autoPathOffsetX;
            this.destinationY = this._y;
            this._autoPathOffsetX = 0;
        } else if (this._autoPathOffsetY != 0) {
            this.destinationX = this._x;
            this.destinationY = this._y + this._autoPathOffsetY;
            this._autoPathOffsetY = 0;
        }
    }

    public final boolean isFinishWalk() {
        return this.path == null;
    }

    public final void walkTo(int n, int n2) {
        Searcher searcher = Searcher.getInstance();
        TiledBackground tiledBackground = this._bk;
        int n3 = (this._x >> 10) / tiledBackground._bktw;
        int n4 = (this._y >> 10) / tiledBackground._bkth;
        this.path = searcher.getPath(n3, n4, n, n2, tiledBackground);
        this.calculateOffset();
        this.destinationX = this._x;
        this.destinationY = this._y;
        this.arriveDesFlag = true;
        this.pathIndex = 1;
    }

    private final void calculateOffset() {
        if (this.path.length < 2) {
            return;
        }
        TiledBackground tiledBackground = this._bk;
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        int n3 = this.path[0][0] * tiledBackground._bktw + (tiledBackground._bktw >> 1);
        int n4 = this.path[0][1] * tiledBackground._bkth + (tiledBackground._bkth >> 1);
        int n5 = this.path[1][0] * tiledBackground._bktw + (tiledBackground._bktw >> 1);
        int n6 = this.path[1][1] * tiledBackground._bkth + (tiledBackground._bkth >> 1);
        int n7 = Math.min(n3, n5);
        int n8 = Math.max(n3, n5);
        this._autoPathOffsetX = n < n7 ? n7 - n : (n8 < n ? n8 - n : 0);
        int n9 = Math.min(n4, n6);
        int n10 = Math.max(n4, n6);
        this._autoPathOffsetY = n2 < n9 ? n9 - n2 : (n10 < n2 ? n10 - n2 : 0);
        this._autoPathOffsetX <<= 10;
        this._autoPathOffsetY <<= 10;
    }

    public final void drawEffect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Animation animation = Animation.getAnimation(n3);
        int n6 = 0;
        while (n6 < n5) {
            int n7 = 0;
            while (n7 < animation.getActFrmNum(n3)) {
                animation.draw(graphics, n, n2, n3, n7, n4);
                ++n7;
            }
            ++n6;
        }
        animation.dispose();
    }

    public boolean getArriveDesFlagForMove() {
        return this.arriveDesFlagForMove;
    }

    private final void nextDestination() {
        if (this.pathIndex >= this.path.length) {
            this.changeToWait();
            this.path = null;
            return;
        }
        TiledBackground tiledBackground = this._bk;
        this.destinationX = this.path[this.pathIndex][0] * tiledBackground._bktw + (tiledBackground._bktw >> 1) << 10;
        this.destinationY = this.path[this.pathIndex][1] * tiledBackground._bkth + (tiledBackground._bkth >> 1) << 10;
        ++this.pathIndex;
    }

    private final void startNextDestination() {
        this.arriveDesFlag = false;
        if (this._x > this.destinationX) {
            if (this._y > this.destinationY) {
                this.changeToWalk(-2147483639);
            } else if (this._y < this.destinationY) {
                this.changeToWalk(-2147483640);
            } else {
                this.changeToWalk(-2147483642);
            }
        } else if (this._x < this.destinationX) {
            if (this._y > this.destinationY) {
                this.changeToWalk(9);
            } else if (this._y < this.destinationY) {
                this.changeToWalk(8);
            } else {
                this.changeToWalk(6);
            }
        } else if (this._y > this.destinationY) {
            this.changeToWalk(7);
        } else if (this._y < this.destinationY) {
            this.changeToWalk(5);
        } else {
            this.changeToWait();
        }
    }

    private final boolean checkPassDestination() {
        if (this._vx > 0 ? this._x < this.destinationX : (this._vx < 0 ? this._x > this.destinationX : (this._vy > 0 ? this._y < this.destinationY : this._vy < 0 && this._y > this.destinationY))) {
            return false;
        }
        this._x = this.destinationX;
        this._y = this.destinationY;
        this._trace = 0;
        this.arriveDesFlag = true;
        this.arriveDesFlagForMove = true;
        return true;
    }

    public final void showExpression(int n, int n2) {
        this._expressionAction = n;
        this._expressionTimer = n2;
        this._expressionMaxFrame = Animation.getAnimation(93).getActFrmNum(this._expressionAction);
    }

    private final void drawExpression(Graphics graphics, int n, int n2) {
        if (this._expressionAction == -1) {
            return;
        }
        if (--this._expressionTimer < 0) {
            this._expressionAction = -1;
        } else {
            if (this._expressionFrame >= this._expressionMaxFrame) {
                this._expressionFrame = 0;
            }
            Animation.getAnimation(93).draw(graphics, n + 0, n2 + -50, this._expressionAction, this._expressionFrame, 0);
            ++this._expressionFrame;
        }
    }

    protected Actor() {
    }

    public boolean checkLeftWall() {
        int n;
        int n2;
        if (this._dx >= 0) {
            return false;
        }
        if (this.collided315angle) {
            n2 = -8;
            n = 8;
        } else {
            n2 = this._l;
            n = this._r;
        }
        TiledBackground tiledBackground = this._bk;
        int n3 = tiledBackground._phytw;
        int n4 = tiledBackground._phyth;
        int n5 = tiledBackground.conversionTileIndexLeft((this._x >> 10) + n2) * n3;
        int n6 = tiledBackground.conversionTileIndexLeft((this._x + this._dx >> 10) + n2) * n3;
        int n7 = tiledBackground.conversionTileIndexTop((this._y >> 10) + this._t) * n4;
        int n8 = tiledBackground.conversionTileIndexBottom((this._y >> 10) + this._b) * n4;
        int n9 = n7;
        while (n9 <= n8) {
            if (this.checkLineSolid(n5, n9, n6, n9, -n3, 0, this._result)) {
                this._vx = 0;
                this._dx = (this._result[0] + n3 << 10) - (this._x + (this._l - 1 << 10));
                return true;
            }
            n9 += n4;
        }
        int n10 = n7;
        while (n10 <= n8) {
            int n11 = -1;
            if (n10 == n7) {
                n11 = (this._y + this._dy >> 10) + this._t - n10;
                n11 = n11 > 8 ? 2 : 1;
            } else if (n10 == n8) {
                n11 = n10 - ((this._y + this._dy >> 10) + this._b);
                n11 = n11 > 8 ? 1 : 2;
            }
            if (this.checkLineSolidForHalf(n5, n10, n6, n10, -n3, 0, this._result, n11, 0)) {
                this._vx = 0;
                this._dx = (this._result[0] + n3 << 10) - (this._x + (this._l - 1 << 10));
                return true;
            }
            n10 += n4;
        }
        return false;
    }

    public boolean checkRightWall() {
        int n;
        int n2;
        if (this.collided315angle) {
            n2 = -8;
            n = 8;
        } else {
            n2 = this._l;
            n = this._r;
        }
        if (this._dx <= 0) {
            return false;
        }
        TiledBackground tiledBackground = this._bk;
        int n3 = tiledBackground._phytw;
        int n4 = tiledBackground._phyth;
        int n5 = tiledBackground.conversionTileIndexRight((this._x >> 10) + n) * n3;
        int n6 = tiledBackground.conversionTileIndexRight((this._x + this._dx >> 10) + n) * n3;
        int n7 = tiledBackground.conversionTileIndexTop((this._y >> 10) + this._t) * n4;
        int n8 = tiledBackground.conversionTileIndexBottom((this._y >> 10) + this._b) * n4;
        int n9 = n7;
        while (n9 <= n8) {
            if (this.checkLineSolid(n5, n9, n6, n9, n3, 0, this._result)) {
                this._vx = 0;
                this._dx = (this._result[0] << 10) - (this._x + (this._r + 1 << 10));
                return true;
            }
            n9 += n4;
        }
        int n10 = n7;
        while (n10 <= n8) {
            int n11 = -1;
            if (n10 == n7) {
                n11 = (this._y + this._dy >> 10) + this._t - n10;
                n11 = n11 > 8 ? 2 : 1;
            } else if (n10 == n8) {
                n11 = n10 - ((this._y + this._dy >> 10) + this._b);
                n11 = n11 > 8 ? 1 : 2;
            }
            if (this.checkLineSolidForHalf(n5, n10, n6, n10, n3, 0, this._result, n11, 0)) {
                this._vx = 0;
                this._dx = (this._result[0] << 10) - (this._x + (this._r + 1 << 10));
                return true;
            }
            n10 += n4;
        }
        return false;
    }

    public boolean checkUpWall() {
        int n;
        int n2;
        if (this.collided315angle) {
            n2 = -8;
            n = 8;
        } else {
            n2 = this._l;
            n = this._r;
        }
        if (this._dy >= 0) {
            return false;
        }
        TiledBackground tiledBackground = this._bk;
        int n3 = tiledBackground._phytw;
        int n4 = tiledBackground._phyth;
        int n5 = tiledBackground.conversionTileIndexLeft((this._x >> 10) + n2) * n3;
        int n6 = tiledBackground.conversionTileIndexRight((this._x >> 10) + n) * n3;
        int n7 = tiledBackground.conversionTileIndexTop((this._y >> 10) + this._t) * n4;
        int n8 = tiledBackground.conversionTileIndexTop((this._y + this._dy >> 10) + this._t) * n4;
        int n9 = n5;
        while (n9 <= n6) {
            if (this.checkLineSolid(n9, n7, n9, n8, 0, -n4, this._result)) {
                this._vy = 0;
                this._dy = (this._result[0] + n4 << 10) - (this._y + (this._t - 1 << 10));
                return true;
            }
            n9 += n3;
        }
        int n10 = n5;
        while (n10 <= n6) {
            int n11 = -1;
            if (n10 == n5) {
                n11 = (this._x + this._dx >> 10) + n2 - n10;
                n11 = n11 > 8 ? 4 : 3;
            } else if (n10 == n6) {
                n11 = n10 - ((this._x + this._dx >> 10) + n);
                n11 = n11 > 8 ? 3 : 4;
            }
            if (this.checkLineSolidForHalf(n10, n7, n10, n8, 0, -n4, this._result, n11, 0)) {
                this._vy = 0;
                this._dy = (this._result[0] + n4 << 10) - (this._y + (this._t - 1 << 10));
                return true;
            }
            n10 += n3;
        }
        return false;
    }

    public boolean checkBottomWall() {
        int n;
        int n2;
        if (this.collided315angle) {
            n2 = -8;
            n = 8;
        } else {
            n2 = this._l;
            n = this._r;
        }
        if (this._dy <= 0) {
            return false;
        }
        TiledBackground tiledBackground = this._bk;
        int n3 = tiledBackground._phytw;
        int n4 = tiledBackground._phyth;
        int n5 = tiledBackground.conversionTileIndexLeft((this._x >> 10) + n2) * n3;
        int n6 = tiledBackground.conversionTileIndexRight((this._x >> 10) + n) * n3;
        int n7 = tiledBackground.conversionTileIndexBottom((this._y >> 10) + this._b) * n4;
        int n8 = tiledBackground.conversionTileIndexBottom((this._y + this._dy >> 10) + this._b) * n4;
        int n9 = n5;
        while (n9 <= n6) {
            if (this.checkLineSolid(n9, n7, n9, n8, 0, n4, this._result)) {
                this._vy = 0;
                this._dy = (this._result[0] << 10) - (this._y + (this._b + 1 << 10));
                return true;
            }
            n9 += n3;
        }
        int n10 = n5;
        while (n10 <= n6) {
            int n11 = -1;
            if (n10 == n5) {
                n11 = (this._x + this._dx >> 10) + n2 - n10;
                n11 = n11 > 8 ? 4 : 3;
            } else if (n10 == n6) {
                n11 = n10 - ((this._x + this._dx >> 10) + n);
                n11 = n11 > 8 ? 3 : 4;
            }
            if (this.checkLineSolidForHalf(n10, n7, n10, n8, 0, n4, this._result, n11, 0)) {
                this._vy = 0;
                this._dy = (this._result[0] << 10) - (this._y + (this._b + 1 << 10));
                return true;
            }
            n10 += n3;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkLineSolid(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int[] var7_7) {
        block9: {
            block8: {
                var8_8 = this._bk;
                var10_9 = var1_1;
                var11_10 = var2_2;
                if (var5_5 == 0) break block8;
                if (var5_5 >= 0) ** GOTO lbl19
                while (var10_9 >= var3_3) {
                    var9_11 = var8_8.getPhyBlock(var10_9, var2_2);
                    if (this.issolid(var9_11)) {
                        var7_7[0] = var10_9;
                        return true;
                    }
                    var10_9 += var5_5;
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    var9_12 = var8_8.getPhyBlock(var10_9, var2_2);
                    if (this.issolid(var9_12)) {
                        var7_7[0] = var10_9;
                        return true;
                    }
                    var10_9 += var5_5;
lbl19:
                    // 2 sources

                    ** while (var10_9 <= var3_3)
                }
lbl20:
                // 1 sources

                break block9;
            }
            if (var6_6 >= 0) ** GOTO lbl36
            while (var11_10 >= var4_4) {
                var9_13 = var8_8.getPhyBlock(var1_1, var11_10);
                if (this.issolid(var9_13)) {
                    var7_7[0] = var11_10;
                    return true;
                }
                var11_10 += var6_6;
            }
            break block9;
lbl-1000:
            // 1 sources

            {
                var9_14 = var8_8.getPhyBlock(var1_1, var11_10);
                if (this.issolid(var9_14)) {
                    var7_7[0] = var11_10;
                    return true;
                }
                var11_10 += var6_6;
lbl36:
                // 2 sources

                ** while (var11_10 <= var4_4)
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean checkLineSolidForHalf(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int[] var7_7, int var8_8, int var9_9) {
        block21: {
            block20: {
                var10_10 = this._bk;
                var12_11 = var1_1;
                var13_12 = var2_2;
                if (var5_5 == 0) break block20;
                if (var5_5 >= 0) ** GOTO lbl37
                while (var12_11 >= var3_3) {
                    var11_13 = var10_10.getPhyBlock(var12_11, var2_2);
                    if (this.isBottomNullSolid(var11_13) && var8_8 != 2) {
                        var7_7[0] = var12_11;
                        return true;
                    }
                    if (this.isTopNullSolid(var11_13) && var8_8 != 1) {
                        var7_7[0] = var12_11;
                        return true;
                    }
                    if (this.isLeftNullSolid(var11_13)) {
                        var7_7[0] = var12_11;
                        return true;
                    }
                    if (this.isRightNullSolid(var11_13)) {
                        var7_7[0] = var12_11 - 8;
                        return true;
                    }
                    var12_11 += var5_5;
                }
                break block21;
lbl-1000:
                // 1 sources

                {
                    var11_14 = var10_10.getPhyBlock(var12_11, var2_2);
                    if (this.isBottomNullSolid(var11_14) && var8_8 != 2) {
                        var7_7[0] = var12_11;
                        return true;
                    }
                    if (this.isTopNullSolid(var11_14) && var8_8 != 1) {
                        var7_7[0] = var12_11;
                        return true;
                    }
                    if (this.isLeftNullSolid(var11_14)) {
                        var7_7[0] = var12_11 - 8;
                        return true;
                    }
                    if (this.isRightNullSolid(var11_14)) {
                        var7_7[0] = var12_11;
                        return true;
                    }
                    var12_11 += var5_5;
lbl37:
                    // 2 sources

                    ** while (var12_11 <= var3_3)
                }
lbl38:
                // 1 sources

                break block21;
            }
            if (var6_6 >= 0) ** GOTO lbl72
            while (var13_12 >= var4_4) {
                var11_15 = var10_10.getPhyBlock(var1_1, var13_12);
                if (this.isBottomNullSolid(var11_15)) {
                    var7_7[0] = var13_12 - 8;
                    return true;
                }
                if (this.isTopNullSolid(var11_15)) {
                    var7_7[0] = var13_12;
                    return true;
                }
                if (this.isLeftNullSolid(var11_15) && var9_9 != 3) {
                    var7_7[0] = var13_12;
                    return true;
                }
                if (this.isRightNullSolid(var11_15) && var9_9 != 4) {
                    var7_7[0] = var13_12;
                    return true;
                }
                var13_12 += var6_6;
            }
            break block21;
lbl-1000:
            // 1 sources

            {
                var11_16 = var10_10.getPhyBlock(var1_1, var13_12);
                if (this.isBottomNullSolid(var11_16)) {
                    var7_7[0] = var13_12;
                    return true;
                }
                if (this.isTopNullSolid(var11_16)) {
                    var7_7[0] = var13_12 - 8;
                    return true;
                }
                if (this.isLeftNullSolid(var11_16) && var9_9 != 3) {
                    var7_7[0] = var13_12;
                    return true;
                }
                if (this.isRightNullSolid(var11_16) && var9_9 != 4) {
                    var7_7[0] = var13_12;
                    return true;
                }
                var13_12 += var6_6;
lbl72:
                // 2 sources

                ** while (var13_12 <= var4_4)
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean issolid(int n) {
        if (GameMainLogic.isFly) {
            if (n == 1) return true;
            if (n == 30) return true;
            if (n == 3) return true;
            if (n == 5) return true;
            if (n == 9) return true;
            if (n == 10) return true;
            if (n == 12) return true;
            if (n != 11) return false;
            return true;
        }
        if (n == 1) return true;
        if (n == 30) return true;
        if (n == 3) return true;
        if (n != 5) return false;
        return true;
    }

    public boolean isBottomNullSolid(int n) {
        if (GameMainLogic.isFly) {
            return false;
        }
        return n == 9;
    }

    public boolean isTopNullSolid(int n) {
        if (GameMainLogic.isFly) {
            return false;
        }
        return n == 10;
    }

    public boolean isLeftNullSolid(int n) {
        if (GameMainLogic.isFly) {
            return false;
        }
        return n == 12;
    }

    public boolean isRightNullSolid(int n) {
        if (GameMainLogic.isFly) {
            return false;
        }
        return n == 11;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean is315AngleSolid(int n) {
        if (n == 8) return true;
        if (n != 7) return false;
        return true;
    }

    public final void checkIsAnglePhy() {
        TiledBackground tiledBackground = this._bk;
        int n = tiledBackground._phytw;
        int n2 = tiledBackground._phyth;
        int n3 = ((this._x >> 10) + this._l) / n * n;
        int n4 = ((this._x >> 10) + this._r) / n * n;
        int n5 = ((this._y >> 10) + this._t) / n2 * n2;
        int n6 = ((this._y >> 10) + this._b) / n2 * n2;
        int n7 = n3;
        while (n7 <= n4) {
            int n8 = n5;
            while (n8 <= n6) {
                int n9 = this._bk.getPhyBlock(n7, n8);
                if (this.judgeSolidType(n9)) {
                    return;
                }
                n8 += 16;
            }
            n7 += 16;
        }
    }

    private boolean isCollidedAngleSolid() {
        return this.collided315angle;
    }

    public void initAngleSolidParam() {
        this.collided315angle = false;
    }

    public boolean judgeSolidType(int n) {
        if (this.is315AngleSolid(n)) {
            this.collided315angle = true;
            return true;
        }
        return false;
    }

    private boolean changeToWalkOf315angle(int n) {
        switch (n) {
            case 8: {
                this._vx = 7 * Function.sin(45) / 1024 << 10;
                this._vy = 7 * Function.sin(45) / 1024 << 10;
                if (this._curAction != 8) {
                    this.changeAction(8);
                }
                return true;
            }
            case -2147483639: {
                this._vx = -(7 * Function.sin(45) / 1024 << 10);
                this._vy = -(7 * Function.sin(45) / 1024 << 10);
                if (this._curAction != -2147483639) {
                    this.changeAction(-2147483639);
                }
                return true;
            }
        }
        return false;
    }

    private boolean changeToWalkOf45angle(int n) {
        switch (n) {
            case 9: {
                this._vx = 7 * Function.sin(45) / 1024 << 10;
                this._vy = -7 * Function.sin(45) / 1024 << 10;
                if (this._curAction != 9) {
                    this.changeAction(9);
                }
                return true;
            }
            case -2147483640: {
                this._vx = -(7 * Function.sin(45) / 1024 << 10);
                this._vy = 7 * Function.sin(45) / 1024 << 10;
                if (this._curAction != -2147483640) {
                    this.changeAction(-2147483640);
                }
                return true;
            }
        }
        return false;
    }

    public int getPriority() {
        switch (this._type) {
            case 124: {
                return 0;
            }
            case 22: 
            case 31: {
                return 1;
            }
            case 101: 
            case 102: 
            case 105: 
            case 107: {
                return 3;
            }
            case 0: {
                if (GameMainLogic.isFly) {
                    return 3;
                }
                return 2;
            }
        }
        return 2;
    }

    public void recordEasyInfo() {
        this._scene.getGameLogic().recordSceneDataInfo(this._id, 1);
    }

    public boolean isHaveShadow() {
        if (this._anim.getId() == 10 && this._action != 4 || this._anim.getId() == 11 && (this._action == 0 || this._action == 3 || this._action == 4)) {
            return true;
        }
        if (this._anim.getId() == 23 && this._action != 6) {
            return true;
        }
        int n = 12;
        while (n < 22) {
            if (this._anim.getId() == 12) {
                return this._action == 0;
            }
            if (this._anim.getId() == n && this._action == 1) {
                return true;
            }
            ++n;
        }
        return this._anim.getId() == 24 && this._action == 0;
    }

    public static boolean isNeedRecord(int n) {
        return n == 1 || n == 57 || n == 59 || n == 66 || n == 67 || n == 69 || n == 70 || n == 71;
    }
}

