/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.engine;

import com.sinaflying.engine.SptSetImage;
import com.sinaflying.util.StreamReader;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public abstract class SptSet {
    public static final int C_TILEID_BIT = 4095;
    public static final int C_FLIP_FLAGS = 49152;
    public static final int C_XFLIP_FLAG = 32768;
    public static final int C_YFLIP_FLAG = 16384;
    public static final int C_ROTATE_FLAGS = 12288;
    public static final int C_ROTATE_90 = 4096;
    public static final int C_ROTATE_180 = 8192;
    public static final int C_ROTATE_270 = 12288;
    public static final int C_FLIP_X = Integer.MIN_VALUE;
    public static final int C_FLIP_Y = 0x40000000;
    public static final int C_TYPE_SPRITE_IMAGE = 2;
    public static final int C_TYPE_SPRITE_PIXEL = 4;
    protected int _paletteNum;
    protected int _imgw;
    protected int _imgh;
    protected short _sptNum;
    protected short[] _x;
    protected short[] _y;
    protected short[] _w;
    protected short[] _h;
    protected static int _axf;
    protected static int _sxf;
    protected static int _ayf;
    protected static int _syf;
    protected static SptSet[] _sets;
    protected static int[] _loaded;
    private static final int C_ANCHOR_MASK_X = 13;
    private static final int C_ANCHOR_MASK_Y = 50;

    protected SptSet() {
    }

    public final int getSptWidth(int n) {
        return this._w[n];
    }

    public final int getSptHeight(int n) {
        return this._h[n];
    }

    public final int getPaletteNum() {
        return this._paletteNum;
    }

    private final int adjusePosX(int n, int n2, int n3) {
        switch (n3 &= 0xD) {
            case 4: {
                break;
            }
            case 8: {
                n -= n2;
                break;
            }
            case 1: {
                n -= n2 >> 1;
            }
        }
        return n;
    }

    private final int adjusePosY(int n, int n2, int n3) {
        switch (n3 &= 0x32) {
            case 16: {
                break;
            }
            case 32: {
                n -= n2;
                break;
            }
            case 2: {
                n -= n2 >> 1;
            }
        }
        return n;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this.adjusePosX(n, this._w[n3 & 0xFFFF], n4);
        n2 = this.adjusePosY(n2, this._h[n3 & 0xFFFF], n4);
        this.draw(graphics, n, n2, n3, 0, 0, false);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.draw(graphics, n, n2, n3, 0, 0, false);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.draw(graphics, n, n2, n3, n4, n5, false);
    }

    public void drawClipPart(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n = this.adjusePosX(n, this._w[n3 & 0xFFFF], n4);
        n2 = this.adjusePosY(n2, this._h[n3 & 0xFFFF], n4);
        this.drawClipPart(graphics, n, n2, n3, 0, 0, n5, n6, n7, n8);
    }

    public void drawZoomByZoomEasy(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.drawZoomByzoomeasy(graphics, n, n2, n3, n4, n5);
    }

    public void drawShadow(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawShadowImage(graphics, n, n2, n3);
    }

    public static final void setLoad(int n, int n2) {
        if (_loaded[n] != 1) {
            SptSet._loaded[n] = n2;
        }
    }

    public static final void resetLoadState() {
        int n = 0;
        while (n < _loaded.length) {
            if (_loaded[n] != 1) {
                SptSet._loaded[n] = 0;
            }
            ++n;
        }
    }

    public static final void disposeLocal() {
        int n = 0;
        while (n < _loaded.length) {
            if (_loaded[n] == 0 && _sets[n] != null) {
                _sets[n].dispose();
                SptSet._sets[n] = null;
            }
            ++n;
        }
    }

    public static final SptSet getSpt(int n) {
        return _sets[n];
    }

    public static SptSet load(int n, int n2) {
        if (n < 0) {
            n += 256;
        }
        if (_sets[n] != null) {
            SptSet.setLoad(n, n2);
            return _sets[n];
        }
        try {
            int n3 = n / 10;
            int n4 = n % 10;
            InputStream inputStream = StreamReader.openDataFile("/res/singlespt" + n3 + ".bin", n4);
            byte by = StreamReader.readByte(inputStream);
            SptSet._sets[n] = SptSetImage.load(inputStream, n);
            SptSet._loaded[n] = n2;
            return _sets[n];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public abstract void draw(Graphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    public abstract void drawClipPart(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract void drawZoom(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawZoomByzoom(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawZoomByzoomeasy(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawReduceByReduceeasy(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void drawShadowImage(Graphics var1, int var2, int var3, int var4, int var5);

    public abstract void drawShadowImage(Graphics var1, int var2, int var3, int var4);

    public abstract void dispose();

    static {
        _sets = new SptSet[310];
        _loaded = new int[310];
    }
}

