/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.sina.wap;

import feeLibs.common.CallBack;
import feeLibs.common.FeeListener;
import feeLibs.common.Utils;
import feeLibs.sina.wap.CommInfo;
import feeLibs.sina.wap.Communicator;
import javax.microedition.midlet.MIDlet;

public class SinaWapFeeManager
implements CallBack {
    private static String HOMEURL = "http://3g.sina.com.cn/game/wapfee/get_pay_url.php?";
    private Communicator m_comm;
    private CommInfo m_commInfo;
    private String m_payURL;
    private String m_lastURL;
    private MIDlet m_midlet;
    private FeeListener m_listener;
    private int m_status;
    private String m_url;
    private static final int REQUEST_SEND_PAGE = 0;
    private static final int REQUEST_GET_PAYURL = 1;
    private static final int REQUEST_MOBILE_TURNTO = 2;
    private static final int REQUEST_MOBILE_CONFIRM = 3;
    private static final int REQUEST_SINA_CONFIRM = 4;
    private static final int STATUS_IDLE = 5;

    public static void openWAPFee(MIDlet main, int type, FeeListener listener) {
        String gameId = Utils.getJarPropertyValue(main, "GameID");
        String channelId = Utils.getJarPropertyValue(main, "ChannelID");
        SinaWapFeeManager wap = new SinaWapFeeManager(main, gameId, channelId, type, listener);
    }

    private SinaWapFeeManager(MIDlet main, String gameid, String fromid, int type, FeeListener listener) {
        this.m_midlet = main;
        this.m_listener = listener;
        StringBuffer url = new StringBuffer();
        url.append(HOMEURL);
        url.append("id=");
        url.append(gameid);
        url.append("&from=");
        url.append(fromid);
        url.append("&fee=");
        url.append(2);
        url.append("&type=");
        url.append(type);
        url.append("&v=");
        url.append(1);
        this.m_url = HOMEURL;
        this.openComm();
    }

    private void openComm() {
        this.m_status = 0;
        this.m_comm = new Communicator();
        this.m_commInfo = new CommInfo(this.m_url, "", this, 0);
        this.m_comm.addRequest(this.m_commInfo, true);
    }

    private void closeComm() {
        this.m_comm.abort();
        this.m_comm = null;
    }

    public void callBack(Object obj) {
        try {
            if (obj instanceof byte[]) {
                this.m_listener.receivedContent(this.m_status, new String((byte[])obj));
                this.handleData((byte[])obj);
            } else {
                this.m_listener.receivedContent(this.m_status, obj.toString());
                this.handleException(obj);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleData(byte[] data) {
        switch (this.m_status) {
            case 0: {
                this.requestSendPage();
                break;
            }
            case 1: {
                this.requestPayurl(data);
                break;
            }
            case 2: 
            case 3: {
                this.requestMoblieConfirm(data);
                break;
            }
            case 4: {
                this.requestSinaConfirm(data);
                break;
            }
            case 5: {
                this.closeComm();
            }
        }
    }

    private void requestSendPage() {
        this.m_commInfo = new CommInfo(this.m_url, "", this, 0);
        this.m_comm.addRequest(this.m_commInfo, true);
        this.m_status = 1;
    }

    private void requestPayurl(byte[] data) {
        String content = new String(data);
        int pos = content.indexOf("\n");
        if (pos != -1) {
            String flag = content.substring(0, pos).trim();
            String url = content.substring(pos + 1).trim();
            if (flag.equals("PAYURL")) {
                this.m_payURL = url;
                this.m_commInfo = new CommInfo(this.m_payURL, "", this, 0);
                this.m_comm.addRequest(this.m_commInfo, true);
                this.m_status = 2;
            } else if (flag.equals("EXPIRED")) {
                try {
                    this.m_midlet.platformRequest(url);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.m_midlet.notifyDestroyed();
            }
        }
    }

    private void requestMoblieConfirm(byte[] data) {
        String content = new String(data).trim();
        String url = this.find(this.m_commInfo.getHeaders() + "\n", "ocation:", "\n").trim();
        if (url == null || url.equals("")) {
            url = this.find(content, "href=\"", "\"");
        }
        if (url == null || url.equals("")) {
            url = this.find(content, "ontimer=\"", "\"");
        }
        if (url != null && !url.equals("")) {
            url = this.remove(url, "amp;");
            url = "http://" + this.remove(url, "http://");
            if (content.indexOf("value=") != -1) {
                String name = this.find(content, "name=\"", "\"");
                String value = this.find(content, "value=\"", "\"");
                this.m_commInfo = new CommInfo(url, name + "=" + value, this, 1);
                this.m_commInfo.addHeader("Referer", this.m_lastURL);
                this.m_comm.addRequest(this.m_commInfo, true);
                this.m_status = 4;
            } else {
                this.m_commInfo = new CommInfo(url, "", this, 0);
                this.m_comm.addRequest(this.m_commInfo, true);
                this.m_status = 3;
            }
            this.m_lastURL = url;
        }
    }

    private void requestSinaConfirm(byte[] data) {
        String content = new String(data).trim();
        if (content.indexOf("Empty url!") != -1) {
            this.notifySuccess();
        }
        this.m_status = 5;
    }

    private void handleException(Object object) {
        this.notifyFailed();
    }

    private void notifySuccess() {
        this.closeComm();
        if (this.m_listener != null) {
            this.m_listener.feeSuccessed(0, "");
        }
        this.m_listener = null;
        this.m_status = 5;
    }

    private void notifyFailed() {
        this.closeComm();
        if (this.m_listener != null) {
            this.m_listener.feeFailed(-1, null);
        }
        this.m_listener = null;
    }

    private String find(String str, String lsem, String rsem) {
        String seg = "";
        int lp = -1;
        int rp = -1;
        lp = str.indexOf(lsem);
        if (lp != -1 && (rp = str.indexOf(rsem, lp + lsem.length())) != -1) {
            seg = str.substring(lp + lsem.length(), rp);
        }
        return seg;
    }

    private String remove(String url, String spec) {
        StringBuffer sb = new StringBuffer();
        int pos = url.indexOf(spec);
        int start = 0;
        while (pos != -1) {
            sb.append(url.substring(start, pos));
            start = pos + spec.length();
            pos = url.indexOf(spec, start);
        }
        sb.append(url.substring(start));
        return sb.toString();
    }
}

