/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.sina.leveldownload;

import feeLibs.common.CallBack;
import feeLibs.common.FeeListener;
import feeLibs.common.Utils;
import feeLibs.sina.leveldownload.CommInfo;
import feeLibs.sina.leveldownload.Communicator;
import feeLibs.sina.leveldownload.ValidateForm;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class SinaLevelDownloadFeeManager
extends Canvas
implements CallBack {
    private static final int GET_INFO_ERR = -1;
    private static final int GET_DD_ERR = -2;
    private static final int GET_IMAGE_ERR = -3;
    private static final int GET_CONTENT_ERR = -4;
    private static final int GET_NOTIFY_ERR = -5;
    private static final int VAL_CODE_ERR = -6;
    private static final int INVALID_URI = -7;
    private static final int INVALID_NOTIFY_URI = -8;
    private static final int EXCEPTION_UNKNOWN = -9;
    private static final int IDLE = 0;
    private static final int REQUEST_BEGIN = 1;
    private static final int REQUEST_SOURCE_LIST = 2;
    private static final int REQUEST_FILE_INFO = 3;
    private static final int REQUEST_IMAGE = 4;
    private static final int REQUEST_DD_FILE = 5;
    private static final int REQUEST_CONTENT = 6;
    private static final int REQUEST_RET_STATUS = 7;
    private Communicator _comm = null;
    private CommInfo _commInfo = null;
    private String _downurl;
    private String _objectURI;
    private String _installNotifyURI;
    private FeeListener _listener;
    private int _status = 0;
    private String _userAgent;
    private ValidateForm _form;
    private String _errmsg;
    private String _cururl;
    private String _content;
    MIDlet _main;

    public static void openLevelDownloadFee(MIDlet main, FeeListener listener, int cp, int id, int type) {
        SinaLevelDownloadFeeManager down = new SinaLevelDownloadFeeManager(main);
        down.requestDownload(listener, cp, id, type);
    }

    private SinaLevelDownloadFeeManager(MIDlet main) {
        this._main = main;
        this._form = new ValidateForm(this);
        this._userAgent = Utils.getJarPropertyValue(this._main, "UserAgent");
        this.setFullScreenMode(true);
    }

    private void requestDownload(FeeListener listener, int cp, int id, int type) {
        this._errmsg = null;
        this._cururl = null;
        this._content = null;
        if (this._comm != null) {
            this.closeComm();
        }
        this._listener = listener;
        this._status = 1;
        StringBuffer url = new StringBuffer("http://3g.sina.com.cn/game/package/require.php");
        url.append("?cp=");
        url.append(cp);
        url.append("&id=");
        url.append(id);
        url.append("&from=60000");
        url.append("&type=");
        url.append(type);
        url.append("&v=1");
        this.submitRequest(url.toString(), false);
    }

    public void requestDDFile(String code) {
        this.downloadDDFile(code);
    }

    public void paint(Graphics g) {
        try {
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(0);
            int x = 2;
            int y = 2;
            switch (this._status) {
                case 1: {
                    g.drawString("getting push page...", x, y, 4 | 0x10);
                    break;
                }
                case 2: {
                    g.drawString("getting source list...", x, y, 4 | 0x10);
                    break;
                }
                case 3: {
                    g.drawString("getting file info...", x, y, 4 | 0x10);
                    break;
                }
                case 4: {
                    g.drawString("getting image...", x, y, 4 | 0x10);
                    break;
                }
                case 5: {
                    g.drawString("getting DD file...", x, y, 4 | 0x10);
                    break;
                }
                case 6: {
                    g.drawString("getting content...", x, y, 4 | 0x10);
                    break;
                }
                case 7: {
                    g.drawString("getting push page...", x, y, 4 | 0x10);
                    break;
                }
                default: {
                    g.drawString("error or exception...", x, y, 4 | 0x10);
                }
            }
            if (this._errmsg != null) {
                g.drawString(this._errmsg, x, 18, 4 | 0x10);
            }
            if (this._cururl != null) {
                this.printString(g, this._cururl, 34);
            }
            if (this._content != null) {
                this.printString(g, this._content, 82);
            }
        }
        catch (Exception e) {
            this._status = 0;
        }
    }

    private void printString(Graphics g, String str, int y) {
        try {
            int length = str.length();
            int line = 28;
            int x = 2;
            int i = 0;
            while (i < length) {
                int end = i + line > length ? length : i + line;
                String sub = str.substring(i, end);
                g.drawString(sub, x, y, 4 | 0x10);
                i += line;
                y += 16;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void callBack(Object o) {
        try {
            if (o instanceof byte[]) {
                if (!this.treatRedirect()) {
                    this.handleData((byte[])o);
                }
            } else {
                this.handleException(o);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.repaint();
    }

    private boolean treatRedirect() {
        String location = this.find(this._commInfo.getHeaders() + "\n", "ocation:", "\n").trim();
        if (location == null || location.equals("")) {
            return false;
        }
        this.submitRequest(location, true);
        return true;
    }

    private void handleData(byte[] data) {
        String content = null;
        try {
            content = new String(data, "UTF-8").trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._listener.receivedContent(this._status, content);
        this._content = content;
        switch (this._status) {
            case 1: {
                this.submitRequest(this._commInfo.getUrl(), false);
                this._status = 2;
                break;
            }
            case 2: {
                this.dealSourceList(content);
                break;
            }
            case 3: {
                this.dealInfo(content);
                break;
            }
            case 4: {
                this.dealImage(data);
                break;
            }
            case 5: {
                this.dealDD(content);
                break;
            }
            case 6: {
                this.dealContent(data);
                break;
            }
            case 7: {
                this.downloadSuccess(data);
            }
        }
    }

    private void handleException(Object o) {
        this._errmsg = o.toString();
        this.downloadFailed(-9);
    }

    private void openComm() {
        this._comm = new Communicator();
    }

    private void closeComm() {
        if (this._comm != null) {
            this._comm.abort();
            this._comm = null;
        }
    }

    private void submitRequest(String url, boolean head) {
        if (this._comm == null) {
            this.openComm();
        }
        this._cururl = url;
        this._content = null;
        this._commInfo = new CommInfo(url, this, 0);
        if (head) {
            this._commInfo.addHead("user-agent", this._userAgent);
            this._commInfo.addHead("accept", "application/vnd.oma.dd+xml, */*");
        }
        this._comm.addRequest(this._commInfo);
        System.out.println(this._commInfo.getUrl());
        this.repaint();
    }

    private void downloadSuccess(byte[] data) {
        this._status = 0;
        this.closeComm();
        if (this._listener != null) {
            this._listener.feeSuccessed(0, "");
        }
        this._listener = null;
    }

    private void downloadFailed(int err) {
        this.closeComm();
        if (this._listener != null) {
            this._listener.feeFailed(err, null);
        }
        this._listener = null;
    }

    private void downloadValidateImage(String imgurl) {
        this._status = 4;
        this.submitRequest(imgurl, true);
    }

    private void downloadDDFile(String valstr) {
        this._downurl = this._downurl.indexOf(63) != -1 ? this._downurl + "&validator=" + valstr : this._downurl + "?validator=" + valstr;
        this._status = 5;
        this.submitRequest(this._downurl, true);
    }

    private void downloadDDFileWithoutValCode() {
        this._status = 5;
        this.submitRequest(this._downurl, true);
    }

    private void downloadContent() {
        this._status = 6;
        this.submitRequest(this._objectURI, true);
    }

    private void downloadedNotify() {
        this._status = 7;
        this._commInfo = new CommInfo(this._installNotifyURI, this, 1);
        this._commInfo.addParameter("900 Success", "");
        this._commInfo.addHead("user-agent", this._userAgent);
        this._commInfo.addHead("accept", "application/vnd.oma.dd+xml, */*");
        this._comm.addRequest(this._commInfo);
    }

    private void dealSourceList(String content) {
        try {
            String url = null;
            int start = 0;
            int crpos = -1;
            int tabpos = -1;
            while ((tabpos = content.indexOf("\t", start)) != -1) {
                String name = content.substring(start, tabpos);
                crpos = content.indexOf("\n", tabpos);
                if (crpos != -1) {
                    url = content.substring(tabpos + 1, crpos);
                    start = crpos + 1;
                    continue;
                }
                url = content.substring(tabpos + 1);
                break;
            }
            if (url == null) {
                throw new Exception();
            }
            this._status = 3;
            this.submitRequest(url, true);
        }
        catch (Exception e) {
            this.downloadFailed(0);
        }
    }

    private void dealInfo(String content) {
        String title = this.find(content, "<title>", "</title>");
        String res = this.find(content, "<result>", "</result>");
        String imgurl = this.find(content, "<imgurl>", "</imgurl>");
        this._downurl = this.find(content, "<downloadurl>", "</downloadurl>");
        if (imgurl != null && !imgurl.equals("")) {
            this.downloadValidateImage(imgurl);
        } else if (res != null && res.trim().equals("6000") && this._downurl != null) {
            this.downloadDDFileWithoutValCode();
            this._errmsg = "imgurl is empty";
        } else {
            this.downloadFailed(-1);
        }
    }

    private void dealImage(byte[] data) {
        if (data != null && data.length > 0) {
            this._form.setImage(Image.createImage((byte[])data, (int)0, (int)data.length));
        } else {
            this.downloadFailed(-3);
            this._errmsg = "image data error!";
        }
    }

    private void dealDD(String content) {
        this._objectURI = this.find(content, "<objectURI>", "</objectURI>");
        this._installNotifyURI = this.find(content, "<installNotifyURI>", "</installNotifyURI>");
        String name = this.find(content, "<name>", "</name>");
        String size = this.find(content, "<size>", "</size>");
        String description = this.find(content, "<description>", "</description>");
        if (this._objectURI == null || this._objectURI.equals("")) {
            this.downloadFailed(-7);
        } else {
            this.downloadContent();
        }
    }

    private void dealContent(byte[] data) {
        if (this._installNotifyURI == null || this._installNotifyURI.equals("")) {
            this.downloadFailed(-8);
        } else {
            this.downloadedNotify();
        }
    }

    private String find(String str, String lsem, String rsem) {
        String seg = "";
        int lp = str.indexOf(lsem);
        int rp = -1;
        if (lp != -1 && (rp = str.indexOf(rsem, lp + lsem.length())) != -1) {
            seg = str.substring(lp + lsem.length(), rp);
        }
        return seg;
    }
}

