/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.common.ui;

import feeLibs.common.ui.FeeInfoUIListener;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class FeeInfoUI {
    protected static final int FEE_INIT = 0;
    protected static final int FEE_QUERY = 1;
    protected static final int FEE_SEND = 2;
    protected static final int FEE_SUCCESSED = 3;
    protected static final int FEE_FAILED = 4;
    protected int _status;
    protected int _cx;
    protected int _cy;
    protected int _cw;
    protected int _ch;
    protected int _tx;
    protected int _ty;
    protected String _queryText;
    protected String _sendText;
    protected String _successedText;
    protected String _failedText;
    protected String _queryLBuText;
    protected String _queryRBuText;
    protected String _successedLBuText;
    protected String _successedRBuText;
    protected String _failedLBuText;
    protected String _failedRBuText;
    protected int _cur;
    protected int _lines;
    protected int _gfh;
    protected int _buttonTextColor;
    protected int _displayTextColor;
    protected int _backgroundColor;
    protected int _scrollbarColor;
    protected FeeInfoUIListener _listener;
    protected Vector _strs = new Vector(30, 1);
    protected Font _font;

    public FeeInfoUI(FeeInfoUIListener listener, Font font) {
        this._listener = listener;
        this._font = font;
        this._status = 0;
        this.setDefaultPalette();
    }

    public void reset() {
        this.initUI();
    }

    public void requestDisplaySuccessFace(String info) {
        StringBuffer buff = new StringBuffer(this._successedText);
        if (info != null && info.length() > 0) {
            buff.append(info);
        }
        this.calcuLayout(buff.toString());
        this._listener.clearKeyStatus();
        this._status = 3;
    }

    public void requestDisplayFailFace(String info) {
        StringBuffer buff = new StringBuffer(this._failedText);
        if (info != null && info.length() > 0) {
            buff.append(info);
        }
        this.calcuLayout(buff.toString());
        this._listener.clearKeyStatus();
        this._status = 4;
    }

    public void setUIRect(int cx, int cy, int cw, int ch, int tx, int ty) {
        this._cx = cx;
        this._cy = cy;
        this._cw = cw;
        this._ch = ch;
        this._tx = tx;
        this._ty = ty;
    }

    public void setUIText(String queryText, String sendText, String successedText, String failedText) {
        this._queryText = queryText;
        this._sendText = sendText;
        this._successedText = successedText;
        this._failedText = failedText;
    }

    public void SetButtonText(String queryLBuText, String queryRBuText, String successedLBuText, String successedRBuText, String failedLBuText, String failedRBuText) {
        this._queryLBuText = queryLBuText;
        this._queryRBuText = queryRBuText;
        this._successedLBuText = successedLBuText;
        this._successedRBuText = successedRBuText;
        this._failedLBuText = failedLBuText;
        this._failedRBuText = failedRBuText;
    }

    public void setPalette(int buttonTextColor, int displayTextColor, int backgroundColor, int scrollbarColor) {
        this._buttonTextColor = buttonTextColor;
        this._displayTextColor = displayTextColor;
        this._backgroundColor = backgroundColor;
        this._scrollbarColor = scrollbarColor;
    }

    public void paint(Graphics g) {
        try {
            this.drawBackground(g);
            switch (this._status) {
                case 0: {
                    this.initUI();
                    break;
                }
                case 1: {
                    this.query(g);
                    break;
                }
                case 2: {
                    this.send(g);
                    break;
                }
                case 3: {
                    this.successed(g);
                    break;
                }
                case 4: {
                    this.failed(g);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initUI() {
        this.calcuLayout(this._queryText);
        this._listener.clearKeyStatus();
        this._status = 1;
    }

    protected void query(Graphics g) {
        this.drawVectorString(g);
        if (this.isLastPage()) {
            this.drawButton(g, this._queryLBuText, this._queryRBuText);
        } else {
            this.drawButton(g, "", this._queryRBuText);
        }
        int keyStatus = this._listener.getKeyStatus();
        switch (keyStatus) {
            case 0: {
                if (!this.isLastPage()) break;
                this._listener.pressedYesButton();
                this._status = 2;
                break;
            }
            case 1: {
                this._listener.pressedNoButton();
                this._status = 4;
                this._listener.clearKeyStatus();
                break;
            }
            case 2: {
                this.pressedUpButton();
                break;
            }
            case 3: {
                this.pressedDownButton();
            }
        }
    }

    protected void send(Graphics g) {
        g.setColor(this._displayTextColor);
        g.drawString(this._sendText, this._cx + this._cw / 3, this._cy + this._ch / 2, 17);
    }

    protected void successed(Graphics g) {
        this.drawVectorString(g);
        this.drawButton(g, this._successedLBuText, this._successedRBuText);
        int keyStatus = this._listener.getKeyStatus();
        switch (keyStatus) {
            case 0: {
                this._listener.pressedContinueButton(true);
                break;
            }
            case 2: {
                this.pressedUpButton();
                break;
            }
            case 3: {
                this.pressedDownButton();
            }
        }
    }

    protected void failed(Graphics g) {
        this.drawVectorString(g);
        this.drawButton(g, this._failedLBuText, this._failedRBuText);
        int keyStatus = this._listener.getKeyStatus();
        switch (keyStatus) {
            case 0: {
                this._listener.pressedContinueButton(false);
                break;
            }
            case 2: {
                this.pressedUpButton();
                break;
            }
            case 3: {
                this.pressedDownButton();
            }
        }
    }

    protected void calcuLayout(String text) {
        int idx;
        this._strs.removeAllElements();
        this._cur = 0;
        this._lines = 0;
        this._gfh = this._font.getHeight() + 1;
        int width = this._cw - this._tx * 2 - 6;
        int height = this._ch - this._ty * 2 - this._gfh - 3;
        this._lines = height / this._gfh;
        this._ty += height % this._gfh / 2;
        int len = text.length();
        int last = 0;
        for (idx = 1; idx < len; ++idx) {
            int r = this._font.substringWidth(text, last, idx - last);
            if (r <= width) continue;
            this._strs.addElement(text.substring(last, idx - 1));
            last = idx - 1;
        }
        if (idx > last) {
            this._strs.addElement(text.substring(last));
        }
        if (this._lines > this._strs.size()) {
            this._lines = this._strs.size();
        }
    }

    protected void pressedUpButton() {
        if (this._cur > 0) {
            --this._cur;
        }
        this._listener.clearKeyStatus();
    }

    protected void pressedDownButton() {
        if (this._cur < this._strs.size() - this._lines) {
            ++this._cur;
        }
        this._listener.clearKeyStatus();
    }

    protected void drawVectorString(Graphics g) {
        g.setColor(this._displayTextColor);
        for (int j = 0; j < this._lines; ++j) {
            g.drawString((String)this._strs.elementAt(this._cur + j), this._cx + this._tx, this._cy + this._ty + j * this._gfh, 20);
        }
        if (this._lines < this._strs.size()) {
            g.setColor(this._scrollbarColor);
            g.drawLine(this._cx + this._cw - 3, this._cy + 3, this._cx + this._cw - 3, this._cy + this._ch - this._gfh - 5);
            g.fillRect(this._cx + this._cw - 5, this._cy + 3 + this._cur * (this._ch - this._gfh - 8) / (this._strs.size() - this._lines), 4, 2);
        }
    }

    protected boolean isLastPage() {
        return this._cur + this._lines >= this._strs.size();
    }

    protected void drawButton(Graphics g, String left, String right) {
        g.setColor(this._buttonTextColor);
        if (left != null) {
            g.drawString(left, this._cx + 1, this._cy + this._ch - 1, 36);
        }
        if (right != null) {
            g.drawString(right, this._cx + this._cw - 1, this._cy + this._ch - 1, 40);
        }
    }

    protected void drawBackground(Graphics g) {
        g.setColor(this._backgroundColor);
        g.setClip(this._cx, this._cy, this._cw, this._ch);
        g.fillRect(this._cx, this._cy, this._cw, this._ch);
    }

    protected void setDefaultPalette() {
        this._gfh = Font.getDefaultFont().getHeight();
        this._buttonTextColor = 13546266;
        this._displayTextColor = 0xE5FFFF;
        this._backgroundColor = 25269;
        this._scrollbarColor = 0xFFFF00;
        this._queryLBuText = "\u786e\u5b9a";
        this._queryRBuText = "\u8fd4\u56de";
        this._successedLBuText = "\u7ee7\u7eed";
        this._successedRBuText = null;
        this._failedLBuText = "\u7ee7\u7eed";
        this._failedRBuText = null;
    }
}

