/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.common.ui;

import feeLibs.cmgp.point.CMPointFeeListener;
import feeLibs.cmgp.point.CMPointFeeManager;
import feeLibs.common.ui.CMGPPointUIListener;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class CMGPPointUI
implements CMPointFeeListener {
    protected static final int POINT_ZOOE_INIT = 0;
    protected static final int POINT_ZOOE_MENU = 1;
    protected static final int POINT_ZOOE_CHARGE_INPUT = 2;
    protected static final int POINT_ZOOE_CHARGE_RESULT = 3;
    protected static final int POINT_ZOOE_QUERY_RESULT = 4;
    protected static final int POINT_ZOOE_DETAIL_QUERY_MENU = 5;
    protected static final int POINT_ZOOE_DETAIL_QUERY_DATE = 6;
    protected static final int POINT_ZOOE_DETAIL_QUERY_RESULT = 7;
    protected static final int POINT_ZOOE_HELP = 8;
    protected static final int POINT_ZOOE_BOUGHT_RESULT = 9;
    protected static final int POINT_ZOOE_CONNECTION = 10;
    protected static final int POINT_ZOOE_DETAIL_INPUT_DATE = 11;
    protected int _ticks;
    protected int _status;
    protected int _prestatus;
    protected int _nextstatus;
    protected boolean _detailQueryCharge;
    protected int _cx;
    protected int _cy;
    protected int _cw;
    protected int _ch;
    protected int _tx;
    protected int _ty;
    protected int _buttonTextColor;
    protected int _displayTextColor;
    protected int _backgroundColor;
    protected int _textboxColor;
    protected int _arrowColor;
    protected int _menuItemSelectColor;
    protected int _menuItemColor;
    protected CMGPPointUIListener _listener;
    protected Vector _strs1 = new Vector(30, 1);
    protected Vector _strs2 = new Vector(30, 1);
    protected Vector _menus = new Vector(10, 1);
    protected Font _font;
    protected int _menuCurItem;
    protected int _menuStartLine;
    protected int _menuPageLines;
    protected int _menuCx;
    protected int _menuCy;
    protected int _menuCw;
    protected int _menuCh;
    protected int _menuFontIh;
    protected static final int MENU_TRIANGLE_WH = 5;
    protected static final int DEFAULT_FONT_IH = 2;
    protected int _chargeInputPoint;
    protected String _consumeCode;
    protected String _consumeThingName;
    protected int _consumeNum;
    protected int _consumePoint;
    protected int _multiLineCx;
    protected int _multiLineCy;
    protected int _multiLineCw;
    protected int _multiLineCh;
    protected int _multiLineTopYPos;
    protected int _multiLineRollH;
    protected int _multiLineTop;
    protected int _multiLineBottom;
    protected int _detailQueryRangeId;
    protected int _detailQueryTypeId;
    protected int _detailQueryTop;
    protected int _textboxcx;
    protected int _texttboxdir;
    protected int _curPoint;
    protected int _inputDateSelIndex;
    protected int _inputDateYear;
    protected int _inputDateMonth;
    protected static final String[] MENU_STR = new String[]{"\u5e10\u6237\u5145\u503c", "\u67e5\u8be2\u4f59\u989d", "\u660e\u7ec6\u67e5\u8be2", "\u70b9\u6570\u5e2e\u52a9", "\u7ee7\u7eed\u5145\u503c", "\u70b9\u6570\u4e13\u533a", "\u70b9\u6570\u5145\u503c\u8bb0\u5f55", "\u70b9\u6570\u6d88\u8d39\u8bb0\u5f55", "[ \u67e5\u8be2 ]", "\u786e\u5b9a", "\u8fd4\u56de", "[ \u4e0b\u4e00\u9875 ]", "\u8fd4\u56de\u70b9\u6570\u4e13\u533a", "\u8fd4\u56de\u6e38\u620f", "[\u786e\u5b9a]"};
    protected static final String[] TIP_STR = new String[]{"\u8bf7\u8f93\u5165\u201c1-100\u5143\u201d\u4efb\u610f\u6574\u6570\u91d1\u989d", "[\u63d0\u793a\uff1a1\u5143\u94b1\u53ef\u5145\u503c100\u70b9\u70b9\u6570\uff0c\u6bcf\u6708\u5145\u503c\u4e0a\u9650\u4e3a10000\u70b9]", "\u8fde\u63a5\u4e2d\uff0c\u8bf7\u7b49\u5f85\u3002", "\u67e5\u8be2\u65f6\u95f4\uff1a", "\u67e5\u8be2\u7c7b\u578b\uff1a", "\u70b9\u6570\u5145\u503c\u5386\u53f2\u8bb0\u5f55\uff1a", "\u70b9\u6570\u6d88\u8d39\u5386\u53f2\u8bb0\u5f55\uff1a", "\u5bf9\u4e0d\u8d77\uff0c\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u8fde\u63a5\u6216\u8054\u7cfb\u5ba2\u670d\uff01", "\u8bf7\u9009\u62e9\u67e5\u8be2\u5e74\u6708\uff1a"};
    protected static final String[] DETAIL_RANGE = new String[]{"\u5f53\u5929", "\u6307\u5b9a\u6708", "\u6700\u8fd110\u5929"};
    protected static final String[] DETAIL_RANGE_ID = new String[]{"1", "2", "3"};
    protected static final String[][] DETAIL_TYPE = new String[][]{{"\u67e5\u8be2\u6240\u6709\u5145\u503c\u8bb0\u5f55"}, {"\u67e5\u8be2\u5f53\u524d\u6e38\u620f\u7684\u6d88\u8d39", "\u67e5\u8be2\u6240\u6709\u6e38\u620f\u7684\u6d88\u8d39"}};
    protected static final String[][] DETAIL_TYPE_ID = new String[][]{{"7"}, {"13", "3"}};
    protected static final String STR_HELP1 = "\u6e38\u620f\u70b9\u6570\uff1a\u6e38\u620f\u70b9\u6570\u662f\u79fb\u52a8\u68a6\u7f51\u6e38\u620f\u9891\u9053\u7684\u4e3a\u7528\u6237\u63d0\u4f9b\u7684\u4e00\u79cd\u6e38\u620f\u652f\u4ed8\u65b9\u5f0f\uff0c\u7528\u6237\u53ef\u4ee5\u4f7f\u7528\u8d26\u6237\u4e2d\u7684\u70b9\u6570\u6765\u8d2d\u4e70\u6e38\u620f\u6216\u6d88\u8d39\u6e38\u620f\u9053\u5177\u3002";
    protected static final String STR_HELP2 = "\u70b9\u6570\u5145\u503c\uff1a\u6bcf\u4e2a\u7528\u6237\u5728\u79fb\u52a8\u68a6\u7f51\u6e38\u620f\u9891\u9053\u90fd\u6709\u81ea\u5df1\u7684\u8d26\u6237\uff0c\u7528\u6237\u53ef\u4ee5\u901a\u8fc7\u8bdd\u8d39\u8d2d\u4e70\u70b9\u6570\u7684\u65b9\u5f0f\u7ed9\u81ea\u5df1\u7684\u8d26\u6237\u5145\u503c\uff0c1\u5143\u8bdd\u8d39\u53ef\u8d2d\u4e70100\u70b9\u70b9\u6570\uff0c\u6bcf\u6708\u6700\u591a\u53ef\u4ee5\u8d2d\u4e70100\u5143\u537310000\u70b9\u70b9\u6570\u3002";
    protected static final String STR_HELP3 = "\u70b9\u6570\u8d26\u6237\uff1a\u6bcf\u4e2a\u7528\u6237\u7684\u624b\u673a\u53f7\u7801\u5728\u79fb\u52a8\u68a6\u7f51\u6e38\u620f\u9891\u9053\u90fd\u6709\u4e00\u4e2a\u56fa\u5b9a\u7684\u70b9\u6570\u8d26\u6237\uff0c\u7528\u6237\u53ef\u4ee5\u4f7f\u7528\u8d26\u6237\u5185\u7684\u70b9\u6570\u8d2d\u4e70\u6e38\u620f\u548c\u5728\u4e0d\u540c\u7684\u6e38\u620f\u4e2d\u8d2d\u4e70\u9053\u5177\uff0c\u70b9\u6570\u8d26\u6237\u5e76\u4e0d\u662f\u7528\u6237\u5728\u67d0\u6b3e\u6e38\u620f\u4e2d\u7684\u6e38\u620f\u8d26\u6237\u3002";
    protected static CMPointFeeManager _pointManager;

    public CMGPPointUI(MIDlet midlet, CMGPPointUIListener listener, Font font) {
        this._listener = listener;
        this._font = font;
        this._status = 0;
        this.setDefaultPalette();
        if (_pointManager == null) {
            _pointManager = new CMPointFeeManager(midlet, this);
        }
    }

    public void reset() {
        this.pointInit();
    }

    public void setUIRect(int cx, int cy, int cw, int ch, int tx, int ty) {
        this._cx = cx;
        this._cy = cy;
        this._cw = cw;
        this._ch = ch;
        this._tx = tx;
        this._ty = ty;
    }

    public void setPalette(int buttonTextColor, int displayTextColor, int backgroundColor, int textboxColor, int arrowColor, int menuItemSelectColor, int menuItemColor) {
        this._buttonTextColor = buttonTextColor;
        this._displayTextColor = displayTextColor;
        this._backgroundColor = backgroundColor;
        this._textboxColor = textboxColor;
        this._arrowColor = arrowColor;
        this._menuItemSelectColor = menuItemSelectColor;
        this._menuItemColor = menuItemColor;
    }

    public void openBuyThings(String consumeCode, int consumePoint, String consumeThingName, int consumeNum) {
        this._consumeCode = consumeCode;
        this._consumePoint = consumePoint;
        this._consumeThingName = consumeThingName;
        this._consumeNum = consumeNum;
        this.switchStatus(10, -1);
        _pointManager.openBuyComm(consumeCode);
    }

    public void paint(Graphics g) {
        ++this._ticks;
        switch (this._status) {
            case 0: {
                this.pointInit();
                break;
            }
            case 1: {
                this.pointZooeMenu(g);
                break;
            }
            case 2: {
                this.pointZooeChargeInput(g);
                break;
            }
            case 3: {
                this.pointZooeChargeResult(g);
                break;
            }
            case 4: {
                this.pointZooeQueryResult(g);
                break;
            }
            case 5: {
                this.pointZooeDetailQueryMenu(g);
                break;
            }
            case 6: {
                this.pointZooeDetailQueryType(g);
                break;
            }
            case 11: {
                this.drawPointZooeDetailInputDate(g);
                break;
            }
            case 7: {
                this.pointZooeDetailQueryResult(g);
                break;
            }
            case 8: {
                this.pointZooeHelp(g);
                break;
            }
            case 9: {
                this.pointZooeBoughtResult(g);
                break;
            }
            case 10: {
                this.pointZooeConnection(g);
            }
        }
    }

    protected void pointInit() {
        this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
        this._listener.clearKeyStatus();
        this._status = 1;
    }

    protected void initPointZooeMenu(int cx, int cy, int cw, int ch) {
        this._menus.removeAllElements();
        this._menus.addElement(MENU_STR[0]);
        this._menus.addElement(MENU_STR[1]);
        this._menus.addElement(MENU_STR[2]);
        this._menus.addElement(MENU_STR[3]);
        this.initMenuList(cx, cy, cw, ch - this.fontHeight(), 2);
    }

    protected void pointZooeMenu(Graphics g) {
        this.drawBackground(g);
        this.drawMenuList(g, this._menus, this._menuCx, this._menuCy, this._menuFontIh, this._menuCurItem, this._menuStartLine, this._menuPageLines);
        this.drawButton(g, null, MENU_STR[10]);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 0: {
                switch (this._menuCurItem) {
                    case 0: {
                        this.initPointZooeChargeInput();
                        this.switchStatus(2, -1);
                        break;
                    }
                    case 1: {
                        this.switchStatus(10, -1);
                        _pointManager.openQueryComm();
                        break;
                    }
                    case 2: {
                        this.switchStatus(10, 5);
                        _pointManager.openQueryComm();
                        break;
                    }
                    case 3: {
                        this.initPointZooeHelp();
                        this.switchStatus(8, -1);
                    }
                }
                break;
            }
            case 1: {
                this._listener.backToGame();
                this._listener.clearKeyStatus();
                break;
            }
            case 2: {
                if (this._menuCurItem > 0) {
                    --this._menuCurItem;
                }
                if (this._menuCurItem < this._menuStartLine) {
                    --this._menuStartLine;
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._menuCurItem < this._menus.size() - 1) {
                    ++this._menuCurItem;
                }
                if (this._menuCurItem >= this._menuStartLine + this._menuPageLines) {
                    ++this._menuStartLine;
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeChargeInput() {
        this.splitString(TIP_STR[0], this._cw - this._tx * 2, this._strs1, true);
        this.splitString(TIP_STR[1], this._cw - this._tx * 2, this._strs2, true);
        int height = this._strs1.size() * (this.fontHeight() + 2);
        height += this._strs2.size() * (this.fontHeight() + 2);
        height += this.fontHeight() + 12;
        height += this.fontHeight() + 10;
        this._multiLineCx = this._cx + this._tx;
        this._multiLineCy = this._cy + this._ty + 10;
        this._multiLineCw = this._cw - this._tx * 2;
        this._multiLineCh = this._ch - this._ty * 2 - this.fontHeight() - 20;
        this._multiLineTopYPos = this._multiLineCy;
        this._multiLineRollH = this.fontHeight();
        this._multiLineTop = this._multiLineCy - height + this._multiLineCh;
        this._multiLineBottom = this._multiLineCy;
        this._chargeInputPoint = 0;
    }

    protected void pointZooeChargeInput(Graphics g) {
        this.drawBackground(g);
        this.drawButton(g, null, MENU_STR[10]);
        if (this._multiLineTopYPos < this._multiLineBottom) {
            this.drawTriangle(g, 0, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy - 10);
        }
        if (this._multiLineTopYPos > this._multiLineTop) {
            this.drawTriangle(g, 1, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy + this._multiLineCh + 5);
        }
        g.setClip(this._multiLineCx, this._multiLineCy, this._multiLineCw, this._multiLineCh);
        int top = this.drawMutiLinesString(g, this._strs1, this._multiLineCx, this._multiLineTopYPos, 2);
        top = this.drawTextBox(g, this._multiLineCx + this._multiLineCw / 2, top + 4, 80, this.fontHeight() + 4, String.valueOf(this._chargeInputPoint));
        g.setColor(this._buttonTextColor);
        g.drawString(MENU_STR[14], this._multiLineCx + this._multiLineCw / 2, top + 4, 1 | 0x10);
        top = top + 4 + this.fontHeight() + 10;
        top = this.drawMutiLinesString(g, this._strs2, this._multiLineCx, top, 2);
        int numeric = this._listener.getNumericKey();
        if (numeric >= 0) {
            if (this._chargeInputPoint < 100) {
                this._chargeInputPoint *= 10;
                this._chargeInputPoint += numeric;
                if (this._chargeInputPoint > 100) {
                    this._chargeInputPoint = 100;
                }
            } else {
                this._chargeInputPoint = 0;
            }
            this._listener.clearKeyStatus();
        } else {
            int key = this._listener.getKeyStatus();
            switch (key) {
                case 0: {
                    this.switchStatus(10, -1);
                    _pointManager.openChargeComm(this._chargeInputPoint);
                    break;
                }
                case 1: {
                    this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                    this.switchStatus(1, -1);
                    break;
                }
                case 2: {
                    if (this._multiLineTopYPos < this._multiLineBottom) {
                        this._multiLineTopYPos += this._multiLineRollH;
                        if (this._multiLineTopYPos > this._multiLineBottom) {
                            this._multiLineTopYPos = this._multiLineBottom;
                        }
                    }
                    this._listener.clearKeyStatus();
                    break;
                }
                case 3: {
                    if (this._multiLineTopYPos > this._multiLineTop) {
                        this._multiLineTopYPos -= this._multiLineRollH;
                        if (this._multiLineTopYPos < this._multiLineTop) {
                            this._multiLineTopYPos = this._multiLineTop;
                        }
                    }
                    this._listener.clearKeyStatus();
                    break;
                }
                case 5: {
                    this._chargeInputPoint = 0;
                }
            }
        }
    }

    protected void initPointZooeChargeResult(boolean chargeSuccessed, int curPoint, String info) {
        StringBuffer buffer = new StringBuffer();
        if (chargeSuccessed) {
            buffer.append("\u606d\u559c\u60a8\uff0c\u5145\u503c");
            buffer.append(this._chargeInputPoint);
            buffer.append("\u5143\u6210\u529f\uff0c\u60a8\u5df2\u83b7\u5f97");
            buffer.append(this._chargeInputPoint * 100);
            buffer.append("\u70b9\u70b9\u6570\uff01\u60a8\u76ee\u524d\u7684\u70b9\u6570\u4f59\u989d\u4e3a");
            buffer.append(curPoint);
            buffer.append("\u70b9\uff01");
        } else {
            buffer.append(TIP_STR[7]);
            buffer.append(info);
        }
        this.splitString(buffer.toString(), this._cw - this._tx * 2, this._strs1, true);
        int height = this._strs1.size() * (this.fontHeight() + 2);
        int maxHeight = this._ch - this._ty * 2 - this.fontHeight();
        int ch = maxHeight - (height += this.fontHeight());
        if ((ch - 20) / (this.fontHeight() + 2) == 0) {
            maxHeight = this._ch - this._ty * 2 - this.fontHeight();
            ch = maxHeight - (height -= this.fontHeight());
        }
        this._menus.removeAllElements();
        this._menus.addElement(MENU_STR[4]);
        this._menus.addElement(MENU_STR[1]);
        this._menus.addElement(MENU_STR[2]);
        this._menus.addElement(MENU_STR[5]);
        this.initMenuList(this._cx, this._cy + this._ty + height, this._cw, ch, 2);
    }

    protected void pointZooeChargeResult(Graphics g) {
        this.drawBackground(g);
        this.drawButton(g, null, MENU_STR[10]);
        this.drawMutiLinesString(g, this._strs1, this._cx + this._tx, this._cy + this._ty, 2);
        this.drawMenuList(g, this._menus, this._menuCx, this._menuCy, this._menuFontIh, this._menuCurItem, this._menuStartLine, this._menuPageLines);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 0: {
                switch (this._menuCurItem) {
                    case 0: {
                        this.initPointZooeChargeInput();
                        this.switchStatus(2, -1);
                        break;
                    }
                    case 1: {
                        this.switchStatus(10, -1);
                        _pointManager.openQueryComm();
                        break;
                    }
                    case 2: {
                        this.switchStatus(10, 5);
                        _pointManager.openQueryComm();
                        break;
                    }
                    case 3: {
                        this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                        this.switchStatus(1, -1);
                    }
                }
                break;
            }
            case 1: {
                this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                this.switchStatus(1, -1);
                break;
            }
            case 2: {
                if (this._menuCurItem > 0) {
                    --this._menuCurItem;
                }
                if (this._menuCurItem < this._menuStartLine) {
                    --this._menuStartLine;
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._menuCurItem < this._menus.size() - 1) {
                    ++this._menuCurItem;
                }
                if (this._menuCurItem >= this._menuStartLine + this._menuPageLines) {
                    ++this._menuStartLine;
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeQueryResult(boolean querySuccessed, int curPoint, String info) {
        StringBuffer buffer = new StringBuffer();
        if (querySuccessed) {
            buffer.append("\u60a8\u5f53\u524d\u7684\u70b9\u6570\u4f59\u989d\u4e3a");
            buffer.append(curPoint);
            buffer.append("\u70b9\uff01");
        } else {
            buffer.append(TIP_STR[7]);
            buffer.append(info);
        }
        this.splitString(buffer.toString(), this._cw - this._tx * 2, this._strs1, true);
        int height = this._strs1.size() * (this.fontHeight() + 2);
        int maxHeight = this._ch - this._ty * 2 - this.fontHeight();
        int ch = maxHeight - (height += this.fontHeight());
        this._menus.removeAllElements();
        this._menus.addElement(MENU_STR[0]);
        this._menus.addElement(MENU_STR[2]);
        this._menus.addElement(MENU_STR[5]);
        this.initMenuList(this._cx, this._cy + this._ty + height, this._cw, ch, 2);
    }

    protected void pointZooeQueryResult(Graphics g) {
        this.drawBackground(g);
        this.drawButton(g, null, MENU_STR[10]);
        this.drawMutiLinesString(g, this._strs1, this._cx + this._tx, this._cy + this._ty, 2);
        this.drawMenuList(g, this._menus, this._menuCx, this._menuCy, this._menuFontIh, this._menuCurItem, this._menuStartLine, this._menuPageLines);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 0: {
                switch (this._menuCurItem) {
                    case 0: {
                        this.initPointZooeChargeInput();
                        this.switchStatus(2, -1);
                        break;
                    }
                    case 1: {
                        this.switchStatus(10, 5);
                        _pointManager.openQueryComm();
                        break;
                    }
                    case 2: {
                        this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                        this.switchStatus(1, -1);
                    }
                }
                break;
            }
            case 1: {
                this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                this.switchStatus(1, -1);
                break;
            }
            case 2: {
                if (this._menuCurItem > 0) {
                    --this._menuCurItem;
                }
                if (this._menuCurItem < this._menuStartLine) {
                    --this._menuStartLine;
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._menuCurItem < this._menus.size() - 1) {
                    ++this._menuCurItem;
                }
                if (this._menuCurItem >= this._menuStartLine + this._menuPageLines) {
                    ++this._menuStartLine;
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeDetailQueryMenu(boolean querySuccessed, int curPoint, String info) {
        this._curPoint = curPoint;
        StringBuffer buffer = new StringBuffer();
        if (querySuccessed) {
            buffer.append("\u60a8\u5f53\u524d\u7684\u70b9\u6570\u4f59\u989d\u4e3a");
            buffer.append(curPoint);
            buffer.append("\u70b9\uff01");
        } else {
            buffer.append(TIP_STR[7]);
            buffer.append(info);
        }
        this.splitString(buffer.toString(), this._cw - this._tx * 2, this._strs1, true);
        int height = this._strs1.size() * (this.fontHeight() + 2);
        int maxHeight = this._ch - this._ty * 2 - this.fontHeight();
        int ch = maxHeight - (height += this.fontHeight());
        this._menus.removeAllElements();
        this._menus.addElement(MENU_STR[6]);
        this._menus.addElement(MENU_STR[7]);
        this.initMenuList(this._cx, this._cy + this._ty + height, this._cw, ch, 2);
    }

    protected void pointZooeDetailQueryMenu(Graphics g) {
        this.drawBackground(g);
        this.drawButton(g, null, MENU_STR[10]);
        this.drawMutiLinesString(g, this._strs1, this._cx + this._tx, this._cy + this._ty, 2);
        this.drawMenuList(g, this._menus, this._menuCx, this._menuCy, this._menuFontIh, this._menuCurItem, this._menuStartLine, this._menuPageLines);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 0: {
                switch (this._menuCurItem) {
                    case 0: {
                        this._detailQueryCharge = true;
                        this.initPointZooeDetailQueryType();
                        this.switchStatus(6, -1);
                        break;
                    }
                    case 1: {
                        this._detailQueryCharge = false;
                        this.initPointZooeDetailQueryType();
                        this.switchStatus(6, -1);
                    }
                }
                this._detailQueryRangeId = 0;
                this._detailQueryTypeId = 0;
                this._detailQueryTop = 0;
                break;
            }
            case 1: {
                this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                this.switchStatus(1, -1);
                break;
            }
            case 2: {
                if (this._menuCurItem > 0) {
                    --this._menuCurItem;
                }
                if (this._menuCurItem < this._menuStartLine) {
                    --this._menuStartLine;
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._menuCurItem < this._menus.size() - 1) {
                    ++this._menuCurItem;
                }
                if (this._menuCurItem >= this._menuStartLine + this._menuPageLines) {
                    ++this._menuStartLine;
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeDetailQueryType() {
        StringBuffer buffer = new StringBuffer();
        if (this._detailQueryCharge) {
            buffer.append(TIP_STR[5]);
        } else {
            buffer.append(TIP_STR[6]);
        }
        this.splitString(buffer.toString(), this._cw - this._tx * 2, this._strs1, true);
        int height = this._strs1.size() * (this.fontHeight() + 2);
        height += this.fontHeight();
        height += this.fontHeight() * 4;
        height += this.fontHeight() * 2;
        this._multiLineCx = this._cx + this._tx;
        this._multiLineCy = this._cy + this._ty + 10;
        this._multiLineCw = this._cw - this._tx * 2;
        this._multiLineCh = this._ch - this._ty * 2 - this.fontHeight() - 20;
        this._multiLineTopYPos = this._multiLineCy;
        this._multiLineRollH = this.fontHeight();
        this._multiLineTop = this._multiLineCy - height + this._multiLineCh;
        this._multiLineBottom = this._multiLineCy;
    }

    protected void pointZooeDetailQueryType(Graphics g) {
        int minLeftBound;
        this.drawBackground(g);
        this.drawButton(g, null, MENU_STR[10]);
        if (this._multiLineTopYPos < this._multiLineBottom) {
            this.drawTriangle(g, 0, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy - 10);
        }
        if (this._multiLineTopYPos > this._multiLineTop) {
            this.drawTriangle(g, 1, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy + this._multiLineCh + 5);
        }
        g.setClip(this._multiLineCx, this._multiLineCy, this._multiLineCw, this._multiLineCh);
        int top = this.drawMutiLinesString(g, this._strs1, this._multiLineCx, this._multiLineTopYPos, 2);
        boolean canMoveLeft1 = this.canMoveLeftItem(0);
        boolean canMoveRight1 = this.canMoveRightItem(0);
        boolean canMoveLeft2 = this.canMoveLeftItem(1);
        boolean canMoveRight2 = this.canMoveRightItem(1);
        if (this._detailQueryCharge) {
            minLeftBound = this.calcuDrawDateBoxLeftBound(this._multiLineCx, this._multiLineCw, TIP_STR[4], DETAIL_TYPE[0]);
            top = this.drawDateBox(g, this._multiLineCx, this._multiLineCw, top + this.fontHeight() * 3 / 2, TIP_STR[3], DETAIL_RANGE, this._detailQueryRangeId, this._detailQueryTop == 0, canMoveLeft1, canMoveRight1, minLeftBound);
            top = this.drawDateBox(g, this._multiLineCx, this._multiLineCw, top + this.fontHeight(), TIP_STR[4], DETAIL_TYPE[0], this._detailQueryTypeId, this._detailQueryTop == 1, canMoveLeft2, canMoveRight2, minLeftBound);
        } else {
            minLeftBound = this.calcuDrawDateBoxLeftBound(this._multiLineCx, this._multiLineCw, TIP_STR[4], DETAIL_TYPE[0]);
            top = this.drawDateBox(g, this._multiLineCx, this._multiLineCw, top + this.fontHeight() * 3 / 2, TIP_STR[3], DETAIL_RANGE, this._detailQueryRangeId, this._detailQueryTop == 0, canMoveLeft1, canMoveRight1, minLeftBound);
            top = this.drawDateBox(g, this._multiLineCx, this._multiLineCw, top + this.fontHeight(), TIP_STR[4], DETAIL_TYPE[1], this._detailQueryTypeId, this._detailQueryTop == 1, canMoveLeft2, canMoveRight2, minLeftBound);
        }
        g.setClip(this._multiLineCx, this._multiLineCy, this._multiLineCw, this._multiLineCh);
        g.setColor(this._buttonTextColor);
        g.drawString(MENU_STR[8], this._multiLineCx + this._multiLineCw / 2, top + this.fontHeight(), 1 | 0x10);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 0: {
                int range = Integer.parseInt(DETAIL_RANGE_ID[this._detailQueryRangeId]);
                if (range == 2) {
                    this.initPointZooeDetailInputDate();
                    this.switchStatus(11, -1);
                    break;
                }
                this.switchStatus(10, -1);
                if (this._detailQueryCharge) {
                    _pointManager.openDetailChargeComm(DETAIL_RANGE_ID[this._detailQueryRangeId], DETAIL_TYPE_ID[0][this._detailQueryTypeId], this.getSystemYYYYMM());
                    break;
                }
                _pointManager.openDetailConsumeComm(DETAIL_RANGE_ID[this._detailQueryRangeId], DETAIL_TYPE_ID[1][this._detailQueryTypeId], this.getSystemYYYYMM());
                break;
            }
            case 1: {
                this.initPointZooeDetailQueryMenu(true, this._curPoint, null);
                this.switchStatus(5, -1);
                break;
            }
            case 2: {
                if (this._multiLineTopYPos < this._multiLineBottom) {
                    this._multiLineTopYPos += this._multiLineRollH;
                    if (this._multiLineTopYPos > this._multiLineBottom) {
                        this._multiLineTopYPos = this._multiLineBottom;
                    }
                }
                --this._detailQueryTop;
                if (this._detailQueryTop < 0) {
                    this._detailQueryTop = 0;
                } else {
                    this._ticks = 0;
                    this._textboxcx = 0;
                    this._texttboxdir = 1;
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._multiLineTopYPos > this._multiLineTop) {
                    this._multiLineTopYPos -= this._multiLineRollH;
                    if (this._multiLineTopYPos < this._multiLineTop) {
                        this._multiLineTopYPos = this._multiLineTop;
                    }
                }
                ++this._detailQueryTop;
                if (this._detailQueryTop > 1) {
                    this._detailQueryTop = 1;
                } else {
                    this._ticks = 0;
                    this._textboxcx = 0;
                    this._texttboxdir = 1;
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 4: {
                if (this._detailQueryTop == 0) {
                    --this._detailQueryRangeId;
                    if (this._detailQueryRangeId < 0) {
                        this._detailQueryRangeId = 0;
                    } else {
                        this._textboxcx = 0;
                        this._texttboxdir = 1;
                    }
                } else {
                    boolean id;
                    --this._detailQueryTypeId;
                    boolean bl = id = !this._detailQueryCharge;
                    if (this._detailQueryTypeId < 0) {
                        this._detailQueryTypeId = 0;
                    } else {
                        this._textboxcx = 0;
                        this._texttboxdir = 1;
                    }
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 5: {
                if (this._detailQueryTop == 0) {
                    ++this._detailQueryRangeId;
                    if (this._detailQueryRangeId >= DETAIL_RANGE.length) {
                        this._detailQueryRangeId = DETAIL_RANGE.length - 1;
                    } else {
                        this._textboxcx = 0;
                        this._texttboxdir = 1;
                    }
                } else {
                    int id;
                    ++this._detailQueryTypeId;
                    int n = id = this._detailQueryCharge ? 0 : 1;
                    if (this._detailQueryTypeId >= DETAIL_TYPE[id].length) {
                        this._detailQueryTypeId = DETAIL_TYPE[id].length - 1;
                    } else {
                        this._textboxcx = 0;
                        this._texttboxdir = 1;
                    }
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeDetailInputDate() {
        this.splitString(TIP_STR[8], this._cw - this._tx * 2, this._strs1, true);
        int height = this._strs1.size() * (this.fontHeight() + 2);
        this._multiLineCx = this._cx + this._tx;
        this._multiLineCy = this._cy + this._ty + 10;
        this._multiLineCw = this._cw - this._tx * 2;
        this._multiLineCh = this._ch - this._ty * 2 - this.fontHeight() - 20;
        this._multiLineTopYPos = this._multiLineCy;
        this._multiLineRollH = this.fontHeight();
        this._multiLineTop = this._multiLineCy - height + this._multiLineCh;
        this._multiLineBottom = this._multiLineCy;
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        this._inputDateSelIndex = 0;
        this._inputDateYear = year;
        this._inputDateMonth = month;
    }

    protected void drawPointZooeDetailInputDate(Graphics g) {
        this.drawBackground(g);
        this.drawButton(g, MENU_STR[9], MENU_STR[10]);
        g.setClip(this._multiLineCx, this._multiLineCy, this._multiLineCw, this._multiLineCh);
        this.drawMutiLinesString(g, this._strs1, this._multiLineCx, this._multiLineTopYPos, 2);
        this.drawInputDate(g, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy + this._multiLineCh / 2, this._inputDateYear, this._inputDateMonth, this._inputDateSelIndex);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 0: {
                this.switchStatus(10, -1);
                if (this._detailQueryCharge) {
                    _pointManager.openDetailChargeComm(DETAIL_RANGE_ID[this._detailQueryRangeId], DETAIL_TYPE_ID[0][this._detailQueryTypeId], this.calcuYYYYMM(this._inputDateYear, this._inputDateMonth));
                    break;
                }
                _pointManager.openDetailConsumeComm(DETAIL_RANGE_ID[this._detailQueryRangeId], DETAIL_TYPE_ID[1][this._detailQueryTypeId], this.calcuYYYYMM(this._inputDateYear, this._inputDateMonth));
                break;
            }
            case 1: {
                this.switchStatus(6, -1);
                this.initPointZooeDetailQueryType();
                this._listener.clearKeyStatus();
                break;
            }
            case 4: 
            case 5: {
                ++this._inputDateSelIndex;
                this._inputDateSelIndex %= 2;
                this._listener.clearKeyStatus();
                break;
            }
            case 2: {
                if (this._inputDateSelIndex == 0) {
                    --this._inputDateYear;
                } else {
                    --this._inputDateMonth;
                    if (this._inputDateMonth < 1) {
                        --this._inputDateYear;
                        this._inputDateMonth = 12;
                    }
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._inputDateSelIndex == 0) {
                    ++this._inputDateYear;
                } else {
                    ++this._inputDateMonth;
                    if (this._inputDateMonth > 12) {
                        ++this._inputDateYear;
                        this._inputDateMonth = 1;
                    }
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeDetailQueryResult(boolean successed, Vector list, String info) {
        if (this._detailQueryCharge) {
            this.splitString(TIP_STR[5], this._cw - this._tx * 2, this._strs1, true);
        } else {
            this.splitString(TIP_STR[6], this._cw - this._tx * 2, this._strs1, true);
        }
        this._strs1.addElement("");
        if (successed) {
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                this.splitString((String)list.elementAt(j), this._cw - this._tx * 2, this._strs1, false);
            }
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append(TIP_STR[7]);
            buffer.append(info);
            this.splitString(buffer.toString(), this._cw - this._tx * 2, this._strs1, false);
        }
        int height = this._strs1.size() * (this.fontHeight() + 2);
        this._multiLineCx = this._cx + this._tx;
        this._multiLineCy = this._cy + this._ty + 10;
        this._multiLineCw = this._cw - this._tx * 2;
        this._multiLineCh = this._ch - this._ty * 2 - this.fontHeight() - 20;
        this._multiLineTopYPos = this._multiLineCy;
        this._multiLineRollH = this.fontHeight();
        this._multiLineTop = this._multiLineCy - height + this._multiLineCh;
        this._multiLineBottom = this._multiLineCy;
    }

    protected void pointZooeDetailQueryResult(Graphics g) {
        this.drawBackground(g);
        this.drawButton(g, null, MENU_STR[10]);
        if (this._multiLineTopYPos < this._multiLineBottom) {
            this.drawTriangle(g, 0, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy - 10);
        }
        if (this._multiLineTopYPos > this._multiLineTop) {
            this.drawTriangle(g, 1, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy + this._multiLineCh + 5);
        }
        g.setClip(this._multiLineCx, this._multiLineCy, this._multiLineCw, this._multiLineCh);
        this.drawMutiLinesString(g, this._strs1, this._multiLineCx, this._multiLineTopYPos, 2);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 1: {
                this.initPointZooeDetailQueryMenu(true, this._curPoint, null);
                this.switchStatus(5, -1);
                break;
            }
            case 2: {
                if (this._multiLineTopYPos < this._multiLineBottom) {
                    this._multiLineTopYPos += this._multiLineRollH;
                    if (this._multiLineTopYPos > this._multiLineBottom) {
                        this._multiLineTopYPos = this._multiLineBottom;
                    }
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._multiLineTopYPos > this._multiLineTop) {
                    this._multiLineTopYPos -= this._multiLineRollH;
                    if (this._multiLineTopYPos < this._multiLineTop) {
                        this._multiLineTopYPos = this._multiLineTop;
                    }
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeHelp() {
        this.splitString(STR_HELP1, this._cw - this._tx * 2, this._strs1, true);
        this._strs1.addElement("");
        this.splitString(STR_HELP2, this._cw - this._tx * 2, this._strs1, false);
        this._strs1.addElement("");
        this.splitString(STR_HELP3, this._cw - this._tx * 2, this._strs1, false);
        int h = this._strs1.size() * (this.fontHeight() + 2);
        int height = h + this.fontHeight();
        this._multiLineCx = this._cx + this._tx;
        this._multiLineCy = this._cy + this._ty + 10;
        this._multiLineCw = this._cw - this._tx * 2;
        this._multiLineCh = this._ch - this._ty * 2 - this.fontHeight() - 20;
        this._multiLineTopYPos = this._multiLineCy;
        this._multiLineRollH = this.fontHeight();
        this._multiLineTop = this._multiLineCy - height + this._multiLineCh;
        this._multiLineBottom = this._multiLineCy;
        this._chargeInputPoint = 0;
    }

    protected void pointZooeHelp(Graphics g) {
        this.drawBackground(g);
        this.drawButton(g, null, MENU_STR[10]);
        if (this._multiLineTopYPos < this._multiLineBottom) {
            this.drawTriangle(g, 0, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy - 10);
        }
        if (this._multiLineTopYPos > this._multiLineTop) {
            this.drawTriangle(g, 1, this._multiLineCx + this._multiLineCw / 2, this._multiLineCy + this._multiLineCh + 5);
        }
        g.setClip(this._multiLineCx, this._multiLineCy, this._multiLineCw, this._multiLineCh);
        this.drawMutiLinesString(g, this._strs1, this._multiLineCx, this._multiLineTopYPos, 2);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 1: {
                this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                this.switchStatus(1, -1);
                break;
            }
            case 2: {
                if (this._multiLineTopYPos < this._multiLineBottom) {
                    this._multiLineTopYPos += this._multiLineRollH;
                    if (this._multiLineTopYPos > this._multiLineBottom) {
                        this._multiLineTopYPos = this._multiLineBottom;
                    }
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._multiLineTopYPos > this._multiLineTop) {
                    this._multiLineTopYPos -= this._multiLineRollH;
                    if (this._multiLineTopYPos < this._multiLineTop) {
                        this._multiLineTopYPos = this._multiLineTop;
                    }
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void initPointZooeBoughtResult(boolean boughtSuccessed, int curPoint, String info) {
        StringBuffer buffer = new StringBuffer();
        if (boughtSuccessed) {
            buffer.append("\u606d\u559c\u60a8\uff01\u60a8\u5df2\u6210\u529f\u8d2d\u4e70");
            buffer.append(this._consumeThingName);
            buffer.append("\u9053\u5177");
            buffer.append(this._consumeNum);
            buffer.append("\u4e2a\uff0c\u60a8\u6d88\u8d39\u4e86");
            buffer.append(this._consumePoint);
            buffer.append("\u70b9\u70b9\u6570\uff0c\u60a8\u5f53\u524d\u7684\u70b9\u6570\u4f59\u989d\u4e3a");
            buffer.append(curPoint);
            buffer.append("\u70b9\uff01");
        } else {
            buffer.append(TIP_STR[7]);
            buffer.append(info);
        }
        this.splitString(buffer.toString(), this._cw - this._tx * 2, this._strs1, true);
        int height = this._strs1.size() * (this.fontHeight() + 2);
        int maxHeight = this._ch - this._ty * 2 - this.fontHeight();
        int ch = maxHeight - (height += this.fontHeight());
        this._menus.removeAllElements();
        this._menus.addElement(MENU_STR[12]);
        this._menus.addElement(MENU_STR[13]);
        this.initMenuList(this._cx, this._cy + this._ty + height, this._cw, ch, 2);
    }

    protected void pointZooeBoughtResult(Graphics g) {
        this.drawBackground(g);
        this.drawMutiLinesString(g, this._strs1, this._cx + this._tx, this._cy + this._ty, 2);
        this.drawMenuList(g, this._menus, this._menuCx, this._menuCy, this._menuFontIh, this._menuCurItem, this._menuStartLine, this._menuPageLines);
        int key = this._listener.getKeyStatus();
        switch (key) {
            case 0: {
                switch (this._menuCurItem) {
                    case 0: {
                        this.initPointZooeMenu(this._cx, this._cy, this._cw, this._ch);
                        this.switchStatus(1, -1);
                        break;
                    }
                    case 1: {
                        this._listener.backToGame();
                        this._listener.clearKeyStatus();
                    }
                }
                break;
            }
            case 2: {
                if (this._menuCurItem > 0) {
                    --this._menuCurItem;
                }
                if (this._menuCurItem < this._menuStartLine) {
                    --this._menuStartLine;
                }
                this._listener.clearKeyStatus();
                break;
            }
            case 3: {
                if (this._menuCurItem < this._menus.size() - 1) {
                    ++this._menuCurItem;
                }
                if (this._menuCurItem >= this._menuStartLine + this._menuPageLines) {
                    ++this._menuStartLine;
                }
                this._listener.clearKeyStatus();
            }
        }
    }

    protected void pointZooeConnection(Graphics g) {
        this.drawBackground(g);
        g.setColor(this._displayTextColor);
        g.drawString(TIP_STR[2], this._cx + this._cw / 2, this._cy + this._ch / 2, 1 | 0x20);
    }

    protected void switchStatus(int status, int nextstatus) {
        if (this._status != 10) {
            this._prestatus = this._status;
        }
        this._status = status;
        this._nextstatus = nextstatus;
        this._listener.clearKeyStatus();
    }

    protected void drawBackground(Graphics g) {
        g.setColor(this._backgroundColor);
        g.setClip(this._cx, this._cy, this._cw, this._ch);
        g.fillRect(this._cx, this._cy, this._cw, this._ch);
    }

    protected void initMenuList(int cx, int cy, int cw, int ch, int ih) {
        this._menuCurItem = 0;
        this._menuStartLine = 0;
        this._menuCx = cx + cw / 2;
        int lines = (ch - 20) / (this.fontHeight() + ih);
        if (lines > this._menus.size()) {
            lines = this._menus.size();
        }
        this._menuCy = cy + ch / 2 - lines * (this.fontHeight() + ih) / 2;
        this._menuCw = cw;
        this._menuCh = lines * (this.fontHeight() + ih);
        this._menuPageLines = lines;
        this._menuFontIh = ih;
    }

    protected void drawMenuList(Graphics g, Vector menus, int centx, int y, int ih, int curItem, int startLine, int pageLines) {
        for (int j = 0; j < pageLines; ++j) {
            g.setColor(j + startLine == curItem ? this._menuItemSelectColor : this._menuItemColor);
            g.drawString((String)menus.elementAt(startLine + j), centx, y + (this.fontHeight() + ih) * j, 1 | 0x10);
        }
        if (this.canMoveUpMenuItem()) {
            this.drawTriangle(g, 0, centx, y - 10);
        }
        if (this.canMoveDownMenuItem()) {
            this.drawTriangle(g, 1, centx, y + (this.fontHeight() + ih) * pageLines + 5);
        }
    }

    protected void drawButton(Graphics g, String left, String right) {
        g.setColor(this._buttonTextColor);
        if (left != null) {
            g.drawString(left, this._cx + 2, this._cy + this._ch - 2, 4 | 0x20);
        }
        if (right != null) {
            g.drawString(right, this._cx + this._cw - 2, this._cy + this._ch - 2, 8 | 0x20);
        }
    }

    protected void drawTriangle(Graphics g, int shape, int x, int y) {
        g.setColor(this._arrowColor);
        switch (shape) {
            case 0: {
                for (int j = 0; j < 5; ++j) {
                    g.drawLine(x - j, y + j, x + j, y + j);
                }
                break;
            }
            case 1: {
                for (int j = 0; j < 5; ++j) {
                    g.drawLine(x - (4 - j), y + j, x + (4 - j), y + j);
                }
                break;
            }
            case 2: {
                for (int j = 0; j < 5; ++j) {
                    g.drawLine(x + j, y - j, x + j, y + j);
                }
                break;
            }
            case 3: {
                for (int j = 0; j < 5; ++j) {
                    g.drawLine(x + j, y - (4 - j), x + j, y + (4 - j));
                }
                break;
            }
        }
    }

    protected int drawMutiLinesString(Graphics g, Vector vec, int cx, int cy, int ih) {
        int lines = vec.size();
        g.setColor(this._displayTextColor);
        for (int j = 0; j < lines; ++j) {
            g.drawString((String)vec.elementAt(j), cx, cy + (this.fontHeight() + ih) * j, 4 | 0x10);
        }
        return cy + (this.fontHeight() + ih) * lines;
    }

    protected int drawTextBox(Graphics g, int centx, int y, int w, int h, String str) {
        g.setColor(this._textboxColor);
        g.drawRect(centx - w / 2, y, w, h);
        g.setColor(this._menuItemColor);
        g.drawString(str, centx + w / 2 - 2, y + h / 2 - this.fontHeight() / 2, 8 | 0x10);
        g.setColor(this._textboxColor);
        if (this._ticks % 8 > 3) {
            int r = centx + w / 2 - 2;
            int l = r - this.stringWidth(str);
            int t = y + h / 2 + this.fontHeight() / 2;
            g.drawLine(l, t, r, t);
        }
        return y + h;
    }

    protected void drawInputDate(Graphics g, int centx, int y, int inputDateYear, int inputDateMonth, int inputDateCurSel) {
        String strYear = String.valueOf(inputDateYear);
        StringBuffer buffer = new StringBuffer();
        if (inputDateMonth <= 9) {
            buffer.append(0);
        }
        buffer.append(inputDateMonth);
        String strMonth = buffer.toString();
        int yearw = this.stringWidth(strYear);
        int monthw = this.stringWidth(strMonth);
        int f = this.stringWidth("\u5e74");
        g.setColor(this._displayTextColor);
        g.drawString(strYear, centx - yearw - f, y, 4 | 0x10);
        g.setColor(this._textboxColor);
        g.drawString("\u5e74", centx - f, y, 4 | 0x10);
        g.setColor(this._displayTextColor);
        g.drawString(strMonth, centx, y, 4 | 0x10);
        g.setColor(this._textboxColor);
        g.drawString("\u6708", centx + monthw, y, 4 | 0x10);
        if (this._ticks % 8 > 3) {
            g.setColor(this._displayTextColor);
            if (inputDateCurSel == 0) {
                g.drawLine(centx - yearw - f, y + this.fontHeight() + 2, centx - f, y + this.fontHeight() + 2);
            } else {
                g.drawLine(centx, y + this.fontHeight() + 2, centx + monthw, y + this.fontHeight() + 2);
            }
        }
    }

    protected int calcuDrawDateBoxLeftBound(int cx, int cw, String label, String[] itemStr) {
        int wal = 0;
        int war = 0;
        int w1 = this.stringWidth(label);
        for (int j = 0; j < itemStr.length; ++j) {
            wal = this.stringWidth(itemStr[j]);
            if (wal <= war) continue;
            war = wal;
        }
        int w2 = war;
        int w = w1 + w2 + 15;
        if (w > cw) {
            w2 = cw - w1 - 15;
        }
        w = w1 + w2 + 15;
        int cx1 = cx + (cw - w) / 2;
        return cx1;
    }

    protected int drawDateBox(Graphics g, int cx, int cw, int y, String label, String[] itemStr, int sel, boolean underLine, boolean left, boolean right, int minLeftBound) {
        int wal = 0;
        int war = 0;
        g.setClip(this._multiLineCx, this._multiLineCy, this._multiLineCw, this._multiLineCh);
        int w1 = this.stringWidth(label);
        for (int j = 0; j < itemStr.length; ++j) {
            wal = this.stringWidth(itemStr[j]);
            if (wal <= war) continue;
            war = wal;
        }
        int w2 = war + 2;
        int w = w1 + w2 + 15;
        if (w > cw) {
            w2 = cw - w1 - 15;
        }
        w = w1 + w2 + 15;
        int cx1 = cx + (cw - w) / 2;
        int cx2 = cx1 + w1 + 7;
        if (cx1 > minLeftBound) {
            int c = cx1 - minLeftBound;
            cx1 -= c;
            cx2 -= c;
        }
        int ih = this.fontHeight() + 2;
        g.drawString(label, cx1, y, 4 | 0x10);
        if (!underLine || this._ticks % 8 < 4) {
            g.setColor(this._textboxColor);
            g.drawRect(cx2, y, w2, ih);
        }
        if (left) {
            this.drawTriangle(g, 2, cx2 - 7, y + ih / 2 - 2 + 2);
        }
        if (right) {
            this.drawTriangle(g, 3, cx2 + w2 + 2 + 1, y + ih / 2 - 2 + 2);
        }
        g.setColor(this._displayTextColor);
        int wh = this.stringWidth(itemStr[sel]);
        if (wh > w2) {
            int clx = g.getClipX();
            int cly = g.getClipY();
            int clw = g.getClipWidth();
            int clh = g.getClipHeight();
            int rlx = cx2 + 2;
            int rly = y;
            int rlw = w2 - 4;
            int rlh = ih;
            if (rlx < clx) {
                rlx = clx;
            }
            if (rlx > clx + clw) {
                rlx = clx + clw;
            }
            if (rly < cly) {
                rly = cly;
            }
            if (rly > cly + clh) {
                rly = cly + clh;
            }
            if (rlx + rlw > clx + clw) {
                rlw = clx + clw - rlx;
            }
            if (rly + rlh > cly + clh) {
                rlh = cly + clh - rly;
            }
            g.setClip(rlx, rly, rlw, rlh);
            g.drawString(itemStr[sel], cx2 + 1 - this._textboxcx, y + ih / 2 - this.fontHeight() / 2 + 1, 4 | 0x10);
            if (underLine) {
                if (this._texttboxdir == 1) {
                    if (this._textboxcx > wh - w2) {
                        this._texttboxdir = 0;
                    } else {
                        ++this._textboxcx;
                    }
                } else if (this._textboxcx < 0) {
                    this._texttboxdir = 1;
                } else {
                    --this._textboxcx;
                }
            }
        } else {
            g.drawString(itemStr[sel], cx2 + w2 - 1, y + ih / 2 - this.fontHeight() / 2 + 1, 8 | 0x10);
        }
        return y + ih;
    }

    private boolean canMoveDownMenuItem() {
        return this._menuStartLine + this._menuPageLines < this._menus.size();
    }

    private boolean canMoveUpMenuItem() {
        return this._menuStartLine > 0;
    }

    private boolean canMoveLeftItem(int top) {
        if (top == 0) {
            return this._detailQueryRangeId > 0;
        }
        return this._detailQueryTypeId > 0;
    }

    private boolean canMoveRightItem(int top) {
        if (top == 0) {
            return this._detailQueryRangeId < DETAIL_RANGE.length - 1;
        }
        int id = this._detailQueryCharge ? 0 : 1;
        return this._detailQueryTypeId < DETAIL_TYPE[id].length - 1;
    }

    private void splitString(String text, int width, Vector vec, boolean emptyList) {
        int idx;
        if (emptyList) {
            vec.removeAllElements();
        }
        int len = text.length();
        int last = 0;
        for (idx = 1; idx < len; ++idx) {
            int r = this.stringWidth(text.substring(last, idx));
            if (r <= width) continue;
            vec.addElement(text.substring(last, idx - 1));
            last = idx - 1;
        }
        if (idx > last) {
            vec.addElement(text.substring(last));
        }
    }

    protected void setDefaultPalette() {
        this._buttonTextColor = 13546266;
        this._displayTextColor = 0xE5FFFF;
        this._backgroundColor = 25269;
        this._textboxColor = 51199;
        this._arrowColor = 0xFFFF00;
        this._menuItemSelectColor = 15911168;
        this._menuItemColor = 0xFFFFB3;
    }

    protected int fontHeight() {
        return this._font.getHeight();
    }

    protected int stringWidth(String sub) {
        return this._font.stringWidth(sub);
    }

    private String calcuYYYYMM(int year, int month) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(year);
        if (month <= 9) {
            buffer.append(0);
        }
        buffer.append(month);
        return buffer.toString();
    }

    private String getSystemYYYYMM() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        StringBuffer buffer = new StringBuffer();
        buffer.append(year);
        if (month + 1 <= 9) {
            buffer.append(0);
        }
        buffer.append(month + 1);
        return buffer.toString();
    }

    public void pointFeeChargeSuccessed(int pointNumber) {
        this.initPointZooeChargeResult(true, pointNumber, null);
        this.switchStatus(3, -1);
    }

    public void pointFeeChargeFailed(int status, String info) {
        this.initPointZooeChargeResult(false, -1, info);
        this.switchStatus(3, -1);
    }

    public void pointFeeQuerySuccessed(int pointNumber) {
        if (this._nextstatus == -1) {
            this.initPointZooeQueryResult(true, pointNumber, null);
            this.switchStatus(4, -1);
        } else if (this._nextstatus == 5) {
            this.initPointZooeDetailQueryMenu(true, pointNumber, null);
            this.switchStatus(5, -1);
        }
    }

    public void pointFeeQueryFailed(int status, String info) {
        if (this._nextstatus == -1) {
            this.initPointZooeQueryResult(false, -1, info);
            this.switchStatus(4, -1);
        } else if (this._nextstatus == 5) {
            this.initPointZooeDetailQueryMenu(false, -1, info);
            this.switchStatus(5, -1);
        }
    }

    public void pointFeeBuySuccessed(int pointNumber) {
        this._listener.boughtThingSuccessed();
        this.initPointZooeBoughtResult(true, pointNumber, null);
        this.switchStatus(9, -1);
    }

    public void pointFeeBuyFailed(int status, String info) {
        this._listener.boughtThingFailed();
        this.initPointZooeBoughtResult(false, -1, info);
        this.switchStatus(9, -1);
    }

    public void pointFeeQueryDetailChargeSuccessed(Vector list) {
        this.initPointZooeDetailQueryResult(true, list, null);
        this.switchStatus(7, -1);
    }

    public void pointFeeQueryDetailChargeFailed(int status, String info) {
        this.initPointZooeDetailQueryResult(false, null, info);
        this.switchStatus(7, -1);
    }

    public void pointFeeQueryDetailConsumeSuccessed(Vector list) {
        this.initPointZooeDetailQueryResult(true, list, null);
        this.switchStatus(7, -1);
    }

    public void pointFeeQueryDetailConsumeFailed(int status, String info) {
        this.initPointZooeDetailQueryResult(false, null, info);
        this.switchStatus(7, -1);
    }

    public void pointFeeReceiveContent(int status, String info) {
        System.out.println("status: " + status + " info: " + info);
    }
}

