/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.cmgp.point;

import feeLibs.cmgp.point.CMPointFeeListener;
import feeLibs.cmgp.point.CommInfo;
import feeLibs.cmgp.point.Communicator;
import feeLibs.cmgp.point.PointStatusCode;
import feeLibs.common.CallBack;
import feeLibs.common.Utils;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;

public class CMPointFeeManager
implements CallBack {
    public static final boolean _IS_TEST = false;
    private static final String HOMEURL = "http://gmp.i139.cn/bizcontrol/LoginOnlineGame?";
    private static final String CHARGEURL = "http://221.179.217.101:80/bizcontrol/ChargeUp.php";
    private static final String QUERYURL = "http://221.179.217.101:80/bizcontrol/QueryBalance.php";
    private static final String BUYURL = "http://221.179.217.101:80/bizcontrol/BuyGameTool.php";
    private static final String DETAIL_CONSUME_URL = "http://221.179.217.101:80/bizcontrol/QueryConsumeRecord.php";
    private static final String XMLAHEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static final int COMMON_LOGIN = 1;
    protected static final int COMMON_CHARGE = 2;
    protected static final int COMMON_QUERY = 3;
    protected static final int COMMON_BUY = 4;
    protected static final int COMMON_DETAIL_CHARGE = 5;
    protected static final int COMMON_DETAIL_CONSUME = 6;
    private int m_status;
    private int m_curCommon;
    private boolean m_bloginSuccessed;
    private int record_charge;
    private String m_point;
    private String charge;
    private String sender;
    private String userIdType;
    private String channelId4;
    private String channelId8;
    private String cpId;
    private String cpServiceId;
    private String consumeCode;
    private CMPointFeeListener m_listener;
    private Communicator m_comm = null;
    private CommInfo m_commInfo = null;
    private String m_userId = "";
    private String m_key = "";
    private String m_url;
    private String m_body;
    private String m_queryRange = "";
    private String m_queryType = "";
    private String m_queryDate = "";
    static CMPointFeeManager _INSTANCE;

    public static CMPointFeeManager openPointFeeManager(MIDlet main, CMPointFeeListener listener) {
        if (_INSTANCE == null) {
            _INSTANCE = new CMPointFeeManager(main, listener);
        }
        return _INSTANCE;
    }

    public CMPointFeeManager(MIDlet _main, CMPointFeeListener listener) {
        String _sender = Utils.getJarPropertyValue(_main, "Sender");
        String _userIdType = Utils.getJarPropertyValue(_main, "UserIdType");
        String _cpId = Utils.getJarPropertyValue(_main, "CpID");
        String _cpServiceId = Utils.getJarPropertyValue(_main, "CpServiceID");
        String _channelId8 = Utils.getJarPropertyValue(_main, "ChannelID8");
        String _channelId4 = Utils.getJarPropertyValue(_main, "ChannelID4");
        this.m_listener = listener;
        this.sender = _sender;
        this.userIdType = _userIdType;
        this.cpId = _cpId;
        this.cpServiceId = _cpServiceId;
        this.channelId4 = _channelId4;
        this.channelId8 = _channelId8;
        StringBuffer url = new StringBuffer();
        url.append(HOMEURL);
        url.append("sender=");
        url.append("202");
        url.append("&cpId=");
        url.append(this.cpId);
        url.append("&cpServiceId=");
        url.append(this.cpServiceId);
        url.append("&fid=");
        url.append(this.channelId4);
        this.m_url = url.toString();
    }

    protected void openLoginComm() {
        this.m_comm = new Communicator();
        this.m_commInfo = new CommInfo(this.m_url, "", this, 0);
        this.m_comm.addRequest(this.m_commInfo);
        this.m_curCommon = 1;
    }

    public void openChargeComm(int _charge) {
        if (!this.m_bloginSuccessed) {
            this.openLoginComm();
            this.m_status = 2;
            this.record_charge = _charge;
            return;
        }
        this.charge = _charge <= 9 ? "40012000" + _charge + "000" : "4001200" + _charge + "000";
        this.createNewCommen(2);
        this.m_status = 2;
    }

    public void openQueryComm() {
        if (!this.m_bloginSuccessed) {
            this.openLoginComm();
            this.m_status = 3;
            return;
        }
        this.createNewCommen(3);
        this.m_status = 3;
    }

    public void openBuyComm(String _consumeCode) {
        this.consumeCode = _consumeCode;
        if (!this.m_bloginSuccessed) {
            this.openLoginComm();
            this.m_status = 4;
            return;
        }
        this.createNewCommen(4);
        this.m_status = 4;
    }

    public void openDetailChargeComm(String queryRange, String queryType, String queryDate) {
        this.m_queryRange = queryRange;
        this.m_queryType = queryType;
        this.m_queryDate = queryDate;
        if (!this.m_bloginSuccessed) {
            this.openLoginComm();
            this.m_status = 5;
            return;
        }
        this.createNewCommen(5);
        this.m_status = 5;
    }

    public void openDetailConsumeComm(String queryRange, String queryType, String queryDate) {
        this.m_queryRange = queryRange;
        this.m_queryType = queryType;
        this.m_queryDate = queryDate;
        if (!this.m_bloginSuccessed) {
            this.openLoginComm();
            this.m_status = 6;
            return;
        }
        this.createNewCommen(6);
        this.m_status = 6;
    }

    private String getCurTime() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        StringBuffer buffer = new StringBuffer();
        buffer.append(year);
        if (month + 1 <= 9) {
            buffer.append(0);
        }
        buffer.append(month + 1);
        if (day <= 9) {
            buffer.append(0);
        }
        buffer.append(day);
        if (hour <= 9) {
            buffer.append(0);
        }
        buffer.append(hour);
        if (minute <= 9) {
            buffer.append(0);
        }
        buffer.append(minute);
        if (second <= 9) {
            buffer.append(0);
        }
        buffer.append(second);
        return buffer.toString();
    }

    private void createNewCommen(int common) {
        this.m_comm = new Communicator();
        StringBuffer url = new StringBuffer();
        switch (common) {
            case 2: {
                url.append(CHARGEURL);
                url.append("?key=");
                url.append(this.m_key);
                url.append("&userid=");
                url.append(this.m_userId);
                this.m_url = url.toString();
                this.m_body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<request>\n<msgType>ChargeUpReq</msgType>\n<sender>" + this.sender + "</sender>\n" + "<userIdType>" + this.userIdType + "</userIdType>\n" + "<userLabel>" + this.m_userId + "</userLabel>\n" + "<channelId>" + this.channelId8 + "</channelId>\n" + "<cpId>701001</cpId>\n" + "<cpServiceId>" + this.charge + "</cpServiceId>\n" + "</request>";
                this.m_curCommon = 2;
                break;
            }
            case 3: {
                url.append(QUERYURL);
                url.append("?key=");
                url.append(this.m_key);
                url.append("&userid=");
                url.append(this.m_userId);
                this.m_url = url.toString();
                this.m_body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<request>\n<msgType>QueryBalanceReq</msgType>\n<sender>" + this.sender + "</sender>\n" + "<userIdType>" + this.userIdType + "</userIdType>\n" + "<userLabel>" + this.m_userId + "</userLabel>\n" + "<channelId>" + this.channelId8 + "</channelId>\n" + "</request>";
                this.m_curCommon = 3;
                break;
            }
            case 4: {
                url.append(BUYURL);
                url.append("?key=");
                url.append(this.m_key);
                url.append("&userid=");
                url.append(this.m_userId);
                this.m_url = url.toString();
                this.m_body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<request>\n<msgType>BuyGameToolReq</msgType>\n<sender>" + this.sender + "</sender>\n" + "<userId>" + this.m_userId + "</userId>\n" + "<fid>" + this.channelId4 + "</fid>\n" + "<cpId>" + this.cpId + "</cpId>\n" + "<cpServiceId>" + this.cpServiceId + "</cpServiceId>\n" + "<consumeCode>" + this.consumeCode + "</consumeCode>\n" + "</request>";
                this.m_curCommon = 4;
                break;
            }
            case 5: {
                url.append(DETAIL_CONSUME_URL);
                url.append("?key=");
                url.append(this.m_key);
                url.append("&userid=");
                url.append(this.m_userId);
                this.m_url = url.toString();
                this.m_body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<request>\n<msgType>QueryConsumeRecordReq</msgType>\n<queryRange>" + this.m_queryRange + "</queryRange>\n" + "<queryType>" + this.m_queryType + "</queryType>\n" + "<sender>" + this.sender + "</sender>\n" + "<channelId></channelId>\n" + "<userIdType>" + this.userIdType + "</userIdType>\n" + "<userLabel>" + this.m_userId + "</userLabel>\n" + "<queryMonth>" + this.m_queryDate + "</queryMonth>\n" + "<payType>3</payType>\n" + "<cpServiceId>" + this.cpServiceId + "</cpServiceId>\n" + "<packageId></packageId>\n" + "<cpId></cpId>\n" + "</request>";
                this.m_curCommon = 5;
                break;
            }
            case 6: {
                url.append(DETAIL_CONSUME_URL);
                url.append("?key=");
                url.append(this.m_key);
                url.append("&userid=");
                url.append(this.m_userId);
                this.m_url = url.toString();
                this.m_body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<request>\n<msgType>QueryConsumeRecordReq</msgType>\n<queryRange>" + this.m_queryRange + "</queryRange>\n" + "<queryType>" + this.m_queryType + "</queryType>\n" + "<sender>" + this.sender + "</sender>\n" + "<channelId></channelId>\n" + "<userIdType>" + this.userIdType + "</userIdType>\n" + "<userLabel>" + this.m_userId + "</userLabel>\n" + "<queryMonth>" + this.m_queryDate + "</queryMonth>\n" + "<payType>3</payType>\n" + "<cpServiceId>" + this.cpServiceId + "</cpServiceId>\n" + "<packageId></packageId>\n" + "<cpId></cpId>\n" + "</request>";
                this.m_curCommon = 6;
            }
        }
        this.m_commInfo = new CommInfo(this.m_url, this.m_body, this, 1);
        this.m_listener.pointFeeReceiveContent(0, this.m_url + this.m_body);
        this.m_comm.addRequest(this.m_commInfo);
    }

    private void closeComm() {
        if (this.m_comm != null) {
            this.m_comm.abort();
            this.m_comm = null;
        }
    }

    public void callBack(Object obj) {
        try {
            if (obj instanceof byte[]) {
                this.m_listener.pointFeeReceiveContent(this.m_status, new String((byte[])obj, "UTF-8"));
                this.handleData((byte[])obj);
            } else {
                this.m_listener.pointFeeReceiveContent(this.m_status, obj.toString());
                this.handleException(obj);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleData(byte[] data) {
        String xmlText = "";
        try {
            xmlText = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        int h1 = -1;
        int h11 = 0;
        int h2 = -1;
        int h22 = 0;
        if (this.m_curCommon == 1) {
            int pos = xmlText.indexOf("userId=");
            int pos1 = xmlText.indexOf("\r", pos);
            this.m_userId = xmlText.substring(pos + 7, pos1).trim();
            pos = xmlText.indexOf("key=");
            pos1 = xmlText.indexOf("\r", pos);
            this.m_key = xmlText.substring(pos + 4, pos1).trim();
            h1 = xmlText.indexOf("hRet=");
            h11 = xmlText.indexOf("\r", h1);
            h2 = xmlText.indexOf("status=");
            h22 = xmlText.indexOf("\r", h2);
        } else {
            h1 = xmlText.indexOf("<hRet>");
            h11 = xmlText.indexOf("</hRet>", h1);
            h2 = xmlText.indexOf("<status>");
            h22 = xmlText.indexOf("</status>", h2);
        }
        if (this.m_curCommon == 3) {
            int h3 = xmlText.indexOf("<point>");
            int h33 = xmlText.indexOf("</point>", h3);
            this.m_point = xmlText.substring(h3 + 7, h33).trim();
            int h4 = this.m_point.indexOf(".");
            if (h4 > 0) {
                this.m_point = this.m_point.substring(0, h4);
            }
        }
        if (h1 >= 0 && h2 >= 0) {
            String hRet = "";
            String status = "";
            if (this.m_curCommon == 1) {
                hRet = xmlText.substring(h1 + 5, h11).trim();
                status = xmlText.substring(h2 + 7, h22).trim();
            } else {
                hRet = xmlText.substring(h1 + 6, h11).trim();
                status = xmlText.substring(h2 + 8, h22).trim();
            }
            int iRet = Integer.parseInt(hRet);
            int iStatus = Integer.parseInt(status);
            String backRet = PointStatusCode.getStatusCodeInfo(iRet, iStatus);
            if (iRet == 0) {
                this.success(xmlText);
            } else if (iRet == 1) {
                this.failed(iStatus, backRet);
            } else {
                this.failed(-1, "\u8054\u7f51\u8fd4\u56de\u53c2\u6570\u4e0d\u6b63\u786e");
            }
        } else {
            this.failed(-1, "\u8054\u7f51\u8fd4\u56de\u53c2\u6570\u4e0d\u6b63\u786e");
        }
    }

    private void handleException(Object object) {
        this.failed(-2, "\u8054\u7f51\u5931\u8d25\uff0c\u7f51\u7edc\u51fa\u73b0\u5f02\u5e38!");
    }

    private void loginSuccessedCommon() {
        switch (this.m_status) {
            case 3: {
                this.openQueryComm();
                break;
            }
            case 2: {
                this.openChargeComm(this.record_charge);
                break;
            }
            case 4: {
                this.openBuyComm(this.consumeCode);
                break;
            }
            case 5: {
                this.openDetailChargeComm(this.m_queryRange, this.m_queryType, this.m_queryDate);
                break;
            }
            case 6: {
                this.openDetailConsumeComm(this.m_queryRange, this.m_queryType, this.m_queryDate);
            }
        }
    }

    private void success(String xml) {
        switch (this.m_curCommon) {
            case 1: {
                this.closeComm();
                this.m_bloginSuccessed = true;
                this.loginSuccessedCommon();
                break;
            }
            case 2: 
            case 4: {
                this.closeComm();
                this.createNewCommen(3);
                break;
            }
            case 3: {
                this.closeComm();
                if (this.m_listener == null) break;
                int p = Integer.parseInt(this.m_point);
                switch (this.m_status) {
                    case 2: {
                        this.m_listener.pointFeeChargeSuccessed(p);
                        break;
                    }
                    case 4: {
                        this.m_listener.pointFeeBuySuccessed(p);
                        break;
                    }
                    case 3: {
                        this.m_listener.pointFeeQuerySuccessed(p);
                    }
                }
                break;
            }
            case 5: {
                this.closeComm();
                Vector list1 = this.parseXmlChargeList(xml);
                this.m_listener.pointFeeQueryDetailChargeSuccessed(list1);
                break;
            }
            case 6: {
                this.closeComm();
                Vector list2 = this.parseXmlConsumeList(xml);
                this.m_listener.pointFeeQueryDetailConsumeSuccessed(list2);
            }
        }
    }

    private Vector parseXmlChargeList(String xml) {
        Vector<String> elements = new Vector<String>(40, 1);
        String chargeList = this.find(xml, "<recordSchema>", "</recordSchema>", 0);
        if (chargeList.length() > 0) {
            String consumerSchema;
            int inx = 0;
            while ((consumerSchema = this.find(xml, "<recordSchema>", "</recordSchema>", inx)).length() > 0) {
                String date = this.find(consumerSchema, "<date>", "</date>", 0);
                String price = this.find(consumerSchema, "<cpServiceName>", "</cpServiceName>", 0);
                String channel = this.find(consumerSchema, "<channelName>", "</channelName>", 0);
                StringBuffer buff = new StringBuffer();
                buff.append(inx + 1);
                buff.append("\u3001");
                buff.append(date);
                buff.append("\uff0c");
                buff.append(channel);
                buff.append("\uff0c");
                buff.append(price);
                buff.append("\u3002");
                elements.addElement(buff.toString());
                ++inx;
            }
        } else {
            elements.addElement("\u65e0\u5145\u503c\u5386\u53f2\u8bb0\u5f55\u3002");
        }
        return elements;
    }

    private Vector parseXmlConsumeList(String xml) {
        Vector<String> elements = new Vector<String>(40, 1);
        String chargeList = this.find(xml, "<recordSchema>", "</recordSchema>", 0);
        if (chargeList.length() > 0) {
            String consumerSchema;
            int inx = 0;
            while ((consumerSchema = this.find(xml, "<recordSchema>", "</recordSchema>", inx)).length() > 0) {
                String date = this.find(consumerSchema, "<date>", "</date>", 0);
                String price = this.find(consumerSchema, "<cpServiceName>", "</cpServiceName>", 0);
                String point = this.find(consumerSchema, "<payValue>", "</payValue>", 0);
                StringBuffer buff = new StringBuffer();
                buff.append(inx + 1);
                buff.append("\u3001");
                buff.append(date);
                buff.append("\uff0c");
                buff.append(price);
                buff.append("\uff0c");
                buff.append("\u6d88\u8d39");
                buff.append(point);
                buff.append("\u70b9\u3002");
                elements.addElement(buff.toString());
                ++inx;
            }
        } else {
            elements.addElement("\u65e0\u6d88\u8d39\u5386\u53f2\u8bb0\u5f55\u3002");
        }
        return elements;
    }

    private void failed(int status, String info) {
        this.closeComm();
        StringBuffer result = new StringBuffer(" \u72b6\u6001:");
        result.append(info);
        switch (this.m_status) {
            case 2: {
                this.m_listener.pointFeeChargeFailed(status, result.toString());
                break;
            }
            case 3: {
                this.m_listener.pointFeeQueryFailed(status, result.toString());
                break;
            }
            case 4: {
                this.m_listener.pointFeeBuyFailed(status, result.toString());
                break;
            }
            case 5: {
                this.m_listener.pointFeeQueryDetailChargeFailed(status, result.toString());
                break;
            }
            case 6: {
                this.m_listener.pointFeeQueryDetailConsumeFailed(status, result.toString());
            }
        }
    }

    public void closeListener() {
        if (this.m_listener != null) {
            this.m_listener = null;
        }
    }

    private String find(String str, String lsem, String rsem, int from) {
        String seg = "";
        int start = 0;
        while (true) {
            int lp = str.indexOf(lsem, start);
            int rp = -1;
            if (lp == -1 || (rp = str.indexOf(rsem, lp + lsem.length())) == -1) break;
            if (--from < 0) {
                seg = str.substring(lp + lsem.length(), rp);
                break;
            }
            start = rp + rsem.length();
        }
        return seg;
    }
}

