/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.cmgp.once;

import feeLibs.cmgp.once.CommInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class Communicator
implements Runnable {
    private boolean m_abort = false;
    private Vector m_requests = new Vector(5, 1);

    public Communicator() {
        new Thread(this).start();
    }

    public static String utf16beDecode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        for (int j = 1; j < data.length; j += 2) {
            sb.append((char)((data[i] & 0xFF) << 8 | data[j] & 0xFF));
            i += 2;
        }
        return sb.toString();
    }

    public synchronized void abort() {
        this.m_abort = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.m_abort) {
            CommInfo commInfo;
            Communicator communicator = this;
            synchronized (communicator) {
                while (this.m_requests.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.m_abort) {
                    break;
                }
                commInfo = (CommInfo)this.m_requests.elementAt(0);
                this.m_requests.removeElementAt(0);
            }
            try {
                this.openRequest(commInfo);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void addRequest(CommInfo commInfo, boolean addHeader) {
        if (addHeader) {
            commInfo.addHeader("accept", "application/vnd.wap.wmlscriptc, text/vnd.wap.wml, application/vnd.wap.xhtml+xml, application/xhtml+xml, text/html, multipart/mixed, */*, text/x-vcard, text/x-vcalendar, image/gif, image/vnd.wap.wbmp");
            commInfo.addHeader("accept-encoding", "gzip, deflate");
            commInfo.addHeader("accept-charset", "ISO-8859-1, US-ASCII, UTF-8; Q=0.8, ISO-10646-UCS-2; Q=0.6");
            commInfo.addHeader("accept-language", "zh-CN");
        }
        this.m_requests.addElement(commInfo);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openRequest(CommInfo commInfo) throws IOException {
        HttpConnection http = null;
        OutputStream os = null;
        InputStream is = null;
        String url = commInfo.getUrl();
        String method = commInfo.getMethod();
        Hashtable head = commInfo.getHead();
        String onlineHost = null;
        int start = -1;
        int end = -1;
        start = url.indexOf("//");
        if (start != -1) {
            end = url.indexOf(47, start += 2);
            if (end != -1) {
                onlineHost = url.substring(start, end);
                url = "http://10.0.0.172:80" + url.substring(end);
            } else {
                onlineHost = url.substring(start);
                url = "http://10.0.0.172:80";
            }
        }
        try {
            int i;
            if (method.equals("GET")) {
                if (commInfo.getPara().length() > 0) {
                    url = url + '?' + commInfo.getPara();
                }
                http = (HttpConnection)Connector.open((String)url);
                if (onlineHost != null) {
                    http.setRequestProperty("X-Online-Host", onlineHost);
                }
                http.setRequestMethod(method);
                Enumeration enu = head.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    String value = (String)head.get(key);
                    http.setRequestProperty(key, value);
                }
            } else if (method.equals("POST")) {
                String strPara = commInfo.getPara();
                int len = strPara.length();
                http = (HttpConnection)Connector.open((String)url);
                if (onlineHost != null) {
                    http.setRequestProperty("X-Online-Host", onlineHost);
                }
                http.setRequestMethod(method);
                Enumeration enu = head.keys();
                while (enu.hasMoreElements()) {
                    String key = (String)enu.nextElement();
                    String value = (String)head.get(key);
                    http.setRequestProperty(key, value);
                }
                http.setRequestProperty("Content-Length", Integer.toString(len));
                os = http.openOutputStream();
                for (i = 0; i < len; ++i) {
                    os.write(strPara.charAt(i));
                }
            } else {
                return;
            }
            is = http.openInputStream();
            byte[] data = null;
            String key = null;
            String heads = "";
            i = 0;
            while ((key = http.getHeaderFieldKey(i++)) != null) {
                heads = heads + key + ":" + http.getHeaderField(key) + "\n";
            }
            commInfo.setHeaders(heads);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                int ch = 0;
                int count = 0;
                while ((ch = is.read()) != -1) {
                    if (count++ >= 5000) continue;
                    dos.writeByte((byte)ch);
                }
                data = baos.toByteArray();
            }
            catch (IOException e) {
                data = null;
                commInfo.callBack(e);
            }
            finally {
                try {
                    if (dos != null) {
                        dos.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException e) {}
            }
            if (!this.m_abort) {
                commInfo.callBack(data);
            }
        }
        catch (Exception e) {
            commInfo.callBack(e);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            if (http != null) {
                http.close();
            }
        }
    }
}

