/*
 * Decompiled with CFR 0.152.
 */
package feeLibs.cmgp.once;

import feeLibs.cmgp.once.CommInfo;
import feeLibs.cmgp.once.Communicator;
import feeLibs.cmgp.once.OnceStatusCode;
import feeLibs.common.CallBack;
import feeLibs.common.FeeListener;
import feeLibs.common.Utils;
import javax.microedition.midlet.MIDlet;

public class CMOnceFeeManager
implements CallBack {
    private static final String HOMEURL = "http://gmp.i139.cn/bizcontrol/OrderSingleGame?";
    private static final int REQUEST_SEND_PAGE = 0;
    private static final int STATUS_IDLE = 1;
    private Communicator m_comm;
    private CommInfo m_commInfo;
    private FeeListener m_listener;
    private int m_status;
    private String m_url;

    public static void openCMPFFee(MIDlet main, FeeListener listener) {
        String cpId = "C00045";
        String cpServiceId = Utils.getJarPropertyValue(main, "CpServiceID");
        String packageId = Utils.getJarPropertyValue(main, "PackageID");
        String channelId = Utils.getJarPropertyValue(main, "ChannelID");
        CMOnceFeeManager cmpf = new CMOnceFeeManager(main, cpId, cpServiceId, packageId, channelId, listener);
        cmpf.openComm();
    }

    private CMOnceFeeManager(MIDlet main, String cpid, String cpServiceId, String packageId, String channelId, FeeListener listener) {
        this.m_listener = listener;
        StringBuffer url = new StringBuffer();
        url.append(HOMEURL);
        url.append("sender=");
        url.append("202");
        url.append("&cpId=");
        url.append(cpid);
        url.append("&cpServiceId=");
        url.append(cpServiceId);
        if (packageId != null && packageId.length() > 0) {
            url.append("&packageId=");
            url.append(packageId);
        }
        url.append("&channelId=");
        url.append(channelId);
        this.m_url = url.toString();
        System.out.println(this.m_url);
    }

    private void openComm() {
        this.m_status = 0;
        this.m_comm = new Communicator();
        this.m_commInfo = new CommInfo(this.m_url, "", this, 1);
        this.m_comm.addRequest(this.m_commInfo, true);
    }

    private void closeComm() {
        if (this.m_comm != null) {
            this.m_comm.abort();
            this.m_comm = null;
        }
    }

    public void callBack(Object obj) {
        try {
            if (obj instanceof byte[]) {
                this.m_listener.receivedContent(this.m_status, new String((byte[])obj));
                this.handleData((byte[])obj);
            } else {
                this.m_listener.receivedContent(this.m_status, obj.toString());
                this.handleException(obj);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleData(byte[] data) {
        String ret = new String(data);
        int h1 = ret.indexOf("hRet=", 0);
        int h2 = ret.indexOf("status=", 0);
        if (h1 >= 0 && h2 >= 0) {
            String hRet = ret.substring(h1 + 5, h1 + 6);
            String status = ret.substring(h2 + 7, h2 + 11);
            int iRet = Integer.parseInt(hRet);
            int iStatus = Integer.parseInt(status);
            ret = OnceStatusCode.getStatusCodeInfo(iRet, iStatus);
            if (iRet == 0) {
                if (iStatus == 1300) {
                    this.success(1, ret);
                } else {
                    this.success(0, ret);
                }
            } else if (iRet == 1) {
                this.failed(ret);
            } else {
                this.failed("\u8054\u7f51\u8fd4\u56de\u53c2\u6570\u4e0d\u6b63\u786e");
            }
        } else {
            this.failed("\u8054\u7f51\u8fd4\u56de\u53c2\u6570\u4e0d\u6b63\u786e");
        }
    }

    private void handleException(Object object) {
        this.failed("\u8054\u7f51\u5931\u8d25\uff0c\u7f51\u7edc\u51fa\u73b0\u5f02\u5e38!");
    }

    private void success(int id, String info) {
        this.closeComm();
        if (this.m_listener != null) {
            StringBuffer result = new StringBuffer(" \u72b6\u6001:");
            result.append(info);
            this.m_listener.feeSuccessed(id, result.toString());
            this.m_listener = null;
        }
        this.m_status = 1;
    }

    private void failed(String info) {
        this.closeComm();
        if (this.m_listener != null) {
            StringBuffer result = new StringBuffer(" \u72b6\u6001:");
            result.append(info);
            this.m_listener.feeFailed(-1, result.toString());
            this.m_listener = null;
        }
    }
}

