/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.other;

import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.gameUtil.Menu;
import com.sinaflying.gameUtil.MenuHandler;
import com.sinaflying.other.GameInfo;
import com.sinaflying.other.UIHandler;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

public class MissionInterface
implements UIHandler,
MenuHandler {
    private GameInfo _gameInfo;
    private GameMainLogic _mainLogic;
    private static final int MISSON_PAGE = 0;
    private static final int OPTION_PAGE = 1;
    private static final int PAGE_BROWSE = 0;
    private static final int PAGE_HANDLE = 1;
    private static final String[] TITLES = new String[]{"\u4efb\u52a1"};
    private int _pageIndex;
    private int _pageMaxNum;
    private boolean _soundOn = false;
    Menu _menu;
    private boolean _isSubMenu = false;
    private boolean _isTrue = false;
    private int _descriptionX;
    private int _descriptionY;
    private int _descriptionH;
    private int _curItemIndexInPage;
    RoleTeamData _teamData;
    private int _rmsPageState;
    private int _soundButtonX;
    private int _soundButtonOffsetX;
    private int _soundVolume;
    private static final int MAX_SOUND = 80;
    private int _startX;
    private int _startY;
    private int _missonIndex;
    private String[] _missonContent;
    private static final int[] _scenarioValue = new int[]{3, 4, 7, 8, 9, 15, 16, 17, 18, 25, 26, 27, 30, 35, 36, 40, 42, 43, 50, 51, 52, 53, 54, 55, 60, 61, 62, 63, 64, 65, 66, 70, 71, 72, 73, 74, 75, 80, 81, 82, 83, 84, 85};
    private int _drawStartX;
    private int _drawStartY;
    private int _space;
    private int _drawH;

    public MissionInterface(GameInfo gameInfo) {
        this._gameInfo = gameInfo;
        this._mainLogic = GameMainLogic.getInstance();
        this.format();
    }

    public void draw(Graphics graphics, int n, int n2) {
        switch (this._pageIndex) {
            case 0: {
                Function.drawBK(graphics, false, false, false, "", "");
                Function.drawRollStrings(graphics, this._missonContent[0], 20, 50, Function.C_WORD_SPACE_Y, Function.C_WORD_SPACE_Y + 5, Function.C_WORD_W, 0);
                Function.drawRollColorStrings(graphics, this._missonContent[1], 20, 50 + Function.C_WORD_SPACE_Y + 5, Function.C_WORD_SPACE_Y, 240 - Function.C_WORD_SPACE_Y * 2 + 5, Function.C_WORD_W, 0);
            }
        }
        Function.drawTitle(graphics, this._pageIndex, TITLES);
        Function.drawSoftItem(graphics, 7);
    }

    private void initMissonPage() {
        this._teamData = RoleTeamData.getInstance();
        int[] nArray = this._teamData.getScenario();
        if (this._missonIndex != nArray[0]) {
            this._missonIndex = nArray[0];
            this._missonContent = this.getCurrentMission(this._missonIndex);
        }
    }

    private final String[] getCurrentMission(int n) {
        int n2 = 0;
        while (n2 < _scenarioValue.length) {
            if (n == _scenarioValue[n2]) {
                return GameParameter.MISSON0[n2];
            }
            ++n2;
        }
        String[] stringArray = new String[]{GameParameter.KONG, GameParameter.KONG};
        return stringArray;
    }

    private void formatRmsPage() {
        this._drawStartX = 32;
        this._space = 12;
        this._drawStartY = 45;
        this._drawH = 60 - this._space;
    }

    private void initRmsPage() {
    }

    public void update() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        if (gameMainLogic.isPressConfirmKey()) {
            gameMainLogic.resetCurKey();
            return;
        }
        if (gameMainLogic.isPressCancelKey()) {
            this.exitHandle();
            gameMainLogic.resetCurKey();
            return;
        }
    }

    private void initPageInfo() {
        this._drawStartX = 32;
        this._space = 12;
        this._drawStartY = 40;
        this._drawH = 60 - this._space;
    }

    private final void exitHandle() {
        GameMainLogic gameMainLogic = GameMainLogic.getInstance();
        this._gameInfo.changeInterface(5);
        gameMainLogic._state = 3;
    }

    public void reset() {
        this._pageIndex = 0;
        this._soundVolume = Function.getSoundValue();
        this._soundButtonOffsetX = Function.PANEL.getSptWidth(41) * this._soundVolume / 80;
        this.initPageInfo();
        this.initRmsPage();
        this.initMissonPage();
    }

    private void format() {
        this._pageIndex = 0;
        this._descriptionX = 32;
        this._descriptionY = 240 - Function.PANEL.getSptHeight(2) - 20 + 13;
        this._descriptionH = 240 - this._descriptionY - 5;
        this.formatRmsPage();
        this._teamData = RoleTeamData.getInstance();
        this._pageMaxNum = TITLES.length;
        this._soundButtonX = 160 - Function.PANEL.getSptWidth(41) / 2;
        this._missonContent = new String[]{GameParameter.KONG, GameParameter.KONG};
        this.initPageInfo();
    }

    public void cancelHandle() {
        this._menu = null;
        this._rmsPageState = 0;
    }

    public void resultHandle(int n) {
        this._menu = null;
        switch (this._pageIndex) {
            default: 
        }
        this._rmsPageState = 0;
    }

    public void shortcutKeyHandle(int n) {
    }
}

