/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.ScriptUnit;
import com.sinaflying.script.Script;
import com.sinaflying.util.StreamReader;
import java.io.InputStream;

public class UnitData {
    private boolean _isValidFlag;
    private int _id;
    private int _x;
    private int _y;
    private int _picId;
    private static final int C_VALID_CHECK_NUM = 3;
    private boolean[] _checkFlag;
    private byte[] _checkValue;
    private static final int C_CHECK_KIND_GREATER = 0;
    private static final int C_CHECK_KIND_EQUAL = 1;
    private static final int C_CHECK_KIND_LESS = 2;
    private byte[] _actorData;
    private static final int ACTOR_DATA_NUM = 5;
    private static final int ACTOR_INIT_ACTION_INDEX_DATA_POS = 0;
    private static final int ACTOR_THROUGH_FLAG_DATA_POS = 1;
    private static final int ACTOR_GLOBAL_DATA_POS = 2;
    private static final int ACTOR_X_FLIP_DATA_POS = 3;
    private static final int ACTOR_Y_FLIP_DATA_POS = 4;
    private short[] _captorData;
    private static final int CAPTOR_DATA_NUM = 4;
    public static final int CAPTOR_LEFT_DATA_POS = 0;
    public static final int CAPTOR_RIGHT_DATA_POS = 1;
    public static final int CAPTOR_TOP_DATA_POS = 2;
    public static final int CAPTOR_BOTTOM_DATA_POS = 3;
    private int _eventSpringKind;
    private static final int MAX_UNIT_PARAMETER_NUM = 6;
    private byte[] _parameter;
    private ScriptUnit[] _scriptData;
    private ScriptUnit _curScriptData;
    private int _curScriptDataIndex;
    private boolean _updateFlag;

    public final boolean isValid() {
        return this._isValidFlag;
    }

    public final boolean isInvalid() {
        return !this._isValidFlag;
    }

    public final void setInvalid() {
        this._isValidFlag = false;
    }

    public final void setValid() {
        this._isValidFlag = true;
    }

    public final boolean isValidActor() {
        RoleTeamData roleTeamData = RoleTeamData.getInstance();
        int[] nArray = roleTeamData.getScenario();
        int n = 0;
        while (n < 3) {
            if (this._checkFlag[n] && !this.isSuccessCheck(nArray[0], this._checkValue[n], n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final boolean isSuccessCheck(int n, int n2, int n3) {
        switch (n3) {
            case 0: {
                return n > n2;
            }
            case 1: {
                return n == n2;
            }
            case 2: {
                return n < n2;
            }
        }
        return false;
    }

    public final short[] getArea() {
        return this._captorData;
    }

    private final void calculateCaptorArea() {
        this._captorData[0] = (short)(this._captorData[0] + this._x);
        this._captorData[1] = (short)(this._captorData[1] + this._x);
        this._captorData[2] = (short)(this._captorData[2] + this._y);
        this._captorData[3] = (short)(this._captorData[3] + this._y);
    }

    public final int GetTriggerKind() {
        return this._eventSpringKind;
    }

    public final byte[] getParameter() {
        return this._parameter;
    }

    public final void setUpdateFlag() {
        this._updateFlag = true;
    }

    private final void updateScript() {
        if (this._updateFlag) {
            this._updateFlag = false;
            this._curScriptData = null;
            byte by = -1;
            int n = this._scriptData.length;
            int n2 = 0;
            while (n2 < n) {
                if (this._scriptData[n2].getPrior() > by && this._scriptData[n2].isSuccess()) {
                    by = this._scriptData[n2].getPrior();
                    this._curScriptData = this._scriptData[n2];
                }
                ++n2;
            }
        }
    }

    public ScriptUnit[] getScriptUnit() {
        if (this._scriptData == null || this._scriptData.length == 0) {
            return null;
        }
        return this._scriptData;
    }

    public final int getTipInfo() {
        this.updateScript();
        return this._curScriptData == null ? -1 : (int)this._curScriptData.getFlag();
    }

    public final Script[] getScript() {
        this.updateScript();
        return this._curScriptData == null ? null : this._curScriptData.getScript();
    }

    public final int getCurScriptDataIndex() {
        return this._curScriptDataIndex;
    }

    public final int getId() {
        return this._id;
    }

    public final int getPosX() {
        return this._x;
    }

    public final int getPosY() {
        return this._y;
    }

    public final int getActionIndex() {
        return this._actorData[0];
    }

    public final boolean isFlipX() {
        return this._actorData[3] == 1;
    }

    public final boolean isFlipY() {
        return this._actorData[4] == 1;
    }

    public final int getPicId() {
        return this._picId;
    }

    public static final UnitData produceUnitData(InputStream inputStream) {
        try {
            int n;
            UnitData unitData = new UnitData();
            unitData._id = StreamReader.readInt(inputStream);
            unitData._x = StreamReader.readShort(inputStream);
            unitData._y = StreamReader.readShort(inputStream);
            unitData._picId = StreamReader.readShort(inputStream);
            if (unitData._picId >= 0) {
                unitData._actorData = new byte[5];
                inputStream.read(unitData._actorData);
                unitData._checkFlag = new boolean[3];
                unitData._checkValue = new byte[3];
                n = 0;
                while (n < 3) {
                    unitData._checkFlag[n] = StreamReader.readBoolean(inputStream);
                    if (unitData._checkFlag[n]) {
                        unitData._checkValue[n] = StreamReader.readByte(inputStream);
                    }
                    ++n;
                }
            } else {
                unitData._captorData = new short[4];
                n = 0;
                while (n < 4) {
                    unitData._captorData[n] = StreamReader.readShort(inputStream);
                    ++n;
                }
                unitData.calculateCaptorArea();
            }
            unitData._eventSpringKind = StreamReader.readByte(inputStream);
            if (StreamReader.readBoolean(inputStream)) {
                unitData._parameter = new byte[6];
                inputStream.read(unitData._parameter);
            }
            n = StreamReader.readByte(inputStream);
            unitData._scriptData = new ScriptUnit[n];
            int n2 = 0;
            while (n2 < n) {
                unitData._scriptData[n2] = ScriptUnit.produceScriptUnit(inputStream);
                ++n2;
            }
            unitData.setUpdateFlag();
            return unitData;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private UnitData() {
    }
}

