/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.engine.Animation;
import com.sinaflying.game.BattleScene;
import com.sinaflying.game.Fighter;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameRule;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

public class NewEffectHandle {
    private int _state;
    private static final int C_STATE_TRACE = 0;
    private static final int C_STATE_END = 1;
    public static final int C_EFFECT_INFO_SIZE = 14;
    public static final int C_EFFECT_INFO_ELEMENT = 0;
    public static final int C_EFFECT_INFO_ELEMENT_ACTION = 1;
    public static final int C_EFFECT_INFO_END = 2;
    public static final int C_EFFECT_INFO_END_ACTION = 3;
    public static final int C_EFFECT_INFO_TRACE = 4;
    public static final int C_EFFECT_INFO_NUM = 5;
    public static final int C_EFFECT_INFO_START_X = 6;
    public static final int C_EFFECT_INFO_START_Y = 7;
    public static final int C_EFFECT_INFO_END_X = 8;
    public static final int C_EFFECT_INFO_END_Y = 9;
    public static final int C_EFFECT_CAMERA = 10;
    public static final int C_EFFECT_INFO_START_X_OFFSET = 11;
    public static final int C_EFFECT_INFO_START_Y_OFFSET = 12;
    public static final int C_EFFECT_INFO_PANEL = 13;
    private static final int C_MAX_ELEMENT_NUM = 300;
    private int[] _info;
    private int[] _effectInfo;
    private Fighter _user;
    private Fighter[] _target;
    public static final int C_CAMERA_EFFECT_NONE = 0;
    public static final int C_CAMERA_SHAKE = 1;
    public static final int C_FIGHTER_SHAKE = 2;
    public static final int C_TRACE_NONE = 0;
    public static final int C_TRACE_IN_PLACE = 1;
    public static final int C_TRACE_POINT_TO_POINT = 2;
    public static final int C_TRACE_IN_BETTER = 3;
    public static final int C_TRACE_FILL_SCREEN = 4;
    public static final int C_TRACE_CIR = 5;
    public static final int C_TRACE_WANJIAN = 101;
    public static final int C_TRACE_TIANJIAN = 102;
    public static final int C_TRACE_JIANSHEN = 103;
    public static final int C_TRACE_THROW_UP = 104;
    public static final int C_TRACE_WANG = 105;
    public static final int C_TRACE_SHADOW = 106;
    public static final int C_TRACE_NAN = 107;
    public static final int C_TRACE_ELECT = 108;
    public static final int C_TRACE_WIND = 109;
    public static final int C_TRACE_FIRE = 110;
    public static final int C_TRACE_ICE = 111;
    public static final int C_TRACE_SOIL = 112;
    public static final int C_TRACE_THROW_UP_SCREEN = 113;
    public static final int C_TRACE_MONEY = 114;
    public static final int C_TRACE_HAND = 115;
    public static final int C_TRACE_HEAD = 116;
    public static final int C_TRACE_ICE_POINT = 117;
    public static final int C_TARCE_ICE_POINT_MID = 118;
    public static final int C_TARCE_ICE_POINT_MAX = 119;
    public static final int C_TRACE_ICE_POINT_MM = 120;
    public static final int C_TRACE_WANJIANXING = 121;
    public static final int C_TRACE_MAX_MONEY = 122;
    public static final int C_TRACE_JIU_TIAN = 123;
    public static final int C_TRACE_XUANYANZHAN = 124;
    public static final int C_TRACE_YIHEZHAN = 125;
    public static final int C_TRACE_MIFENG = 126;
    public static final int C_TRACE_MAX_SOIL = 127;
    private int[][] _particleInfo = new int[300][14];
    private static final int C_DROP_INFO_SIZE = 14;
    private int[][] _dropInfo = new int[300][14];
    private static final int C_DROP_INFO_VALID = 0;
    private static final int C_DROP_INFO_STAY_TIME = 1;
    private static final int C_DROP_INFO_X = 2;
    private static final int C_DROP_INFO_Y = 3;
    private static final int C_DROP_INFO_DST_Y = 4;
    private static final int C_DROP_INFO_VX = 5;
    private static final int C_DROP_INFO_AX = 6;
    private static final int C_DROP_INFO_VY = 7;
    private static final int C_DROP_INFO_AY = 8;
    private static final int C_DROP_INFO_FRAME = 9;
    private static final int C_DROP_INFO_MAX_FRAME = 10;
    private static final int C_DROP_INFO_BASIC_NUMBER = 11;
    private static final int C_DROP_INFO_ANI = 12;
    private static final int C_DROP_INFO_ACTION = 13;
    private int _dropInfoValidNum;
    private int _dropValidNum;
    private int _dropValidInx;
    private static final int C_DROP_START_VY = 20480;
    private static final int C_DROP_AY = 6144;
    private static final int C_DROP_SPACE_TIME_FOR_HEAD = 3;
    private static final int C_DROP_START_Y = -16384;
    private static final int C_SHAKE_TIME = 6;
    private static final int C_SHAKE_RANGE = 1;
    private boolean _active;
    private static final int C_END_INFO_SIZE = 5;
    private static final int C_END_COMPLEX_INDEX = 0;
    private static final int C_END_ACTION_INDEX = 1;
    private static final int C_END_FRAME = 2;
    private static final int C_END_POS_X = 3;
    private static final int C_END_POS_Y = 4;
    private int[][] _endEffectInfo = new int[300][5];
    private boolean _endValidFlag;
    private static int[][] WAN_JIAN_POSITION = new int[][]{{2, 104}, {10, 97}, {18, 113}, {18, 56}, {27, 72}, {27, 72}, {27, 72}, {26, 72}, {35, 78}, {35, 103}, {42, 48}, {35, 103}, {50, 80}, {58, 67}, {59, 96}, {66, 133}, {74, 65}, {82, 52}, {83, 80}, {98, 48}, {99, 89}, {90, 120}, {114, 80}};
    private static final int WAN_JIAN_X_OFFSET = 50;
    private static final int WAN_JIAN_Y_OFFSET = 10;
    private static final int XIE_JIAN_X_OFFSET = 130;
    private static final int XIE_JIAN_Y_OFFSET = 50;
    private boolean openWanJianEffect;
    private boolean openXieJianEffect;
    private boolean[] _effectSign = new boolean[3];
    private int[] _effectMaxNumber = new int[3];
    public static final int EFFECT_PART_SIZE = 3;
    public static final int FIRST_EFFECT_PART = 0;
    public static final int MIDDLE_EFFECT_PART = 1;
    public static final int LAST_EFFECT_PART = 2;
    public static final int MAX_MEMBER_NUMBER = 100;
    private int _effectCounter;
    private int _effectState;
    private int[][][] _particleInfom = new int[3][100][14];
    public static final int[] LIGHT_POINT = new int[]{32, 33, 34};
    private int[] arrayNumber = new int[]{0, 180, 0, 90, 180, 270, 0, 60, 120, 180, 240, 300};
    private int[] arrayAngle = new int[]{30, 30, 20, 20, 20, 20, 10, 10, 10, 10, 10, 10};
    private int[] arraySpace = new int[]{20, 20, 50, 50, 50, 50, 80, 80, 80, 80, 80, 80};
    private int[] arrayWindNumber = new int[]{0, 90, 180, 270};
    private int[] arrayWindAngle = new int[]{20, 20, 20, 20};
    private int[] arrayWindSpace = new int[]{60, 60, 60, 60};
    private static final int[] SNOW_INDEX = new int[]{9, 10, 11, 12};
    private static final int[] SNOW_FLOWER_INDEX = new int[]{1, 6, 9, 10, 11, 12};
    private int _soilNumber;
    public static final int[] WANJIAN = new int[]{3, 11};

    public final void update() {
        if (!this._active) {
            return;
        }
        if (this._state == 1) {
            return;
        }
        switch (this._info[4]) {
            case 0: {
                this.updateForTraceNone();
                break;
            }
            case 1: 
            case 3: {
                this.undateTraceStay();
                break;
            }
            case 4: {
                this.updateAllScreenTraceStay();
                break;
            }
            case 2: {
                break;
            }
            case 101: {
                this.updateForTraceWanJian();
                break;
            }
            case 102: {
                this.updateForTraceTianJian();
                break;
            }
            case 103: {
                this.updateForTraceJianShen();
                break;
            }
            case 104: {
                this.updateTraceThrowUp();
                break;
            }
            case 105: {
                this.undateTraceStar();
                break;
            }
            case 106: {
                this.updateTraceShadow();
                break;
            }
            case 107: {
                this.updateTraceNan();
                break;
            }
            case 108: {
                this.updateTraceElect();
                break;
            }
            case 109: {
                this.updateTraceWind();
                break;
            }
            case 112: {
                this.updateTraceSoil();
                break;
            }
            case 110: {
                this.updateTraceFire();
                break;
            }
            case 5: {
                this.updateTraceCir();
                break;
            }
            case 113: {
                this.updateTraceThrowUpScreen();
                break;
            }
            case 114: {
                this.updateTraceMoney();
                break;
            }
            case 115: {
                this.updateTraceHand();
                break;
            }
            case 116: {
                this.updateTraceHead();
                break;
            }
            case 117: {
                this.updateTraceIce();
                break;
            }
            case 118: {
                this.updateTraceIceMid();
                break;
            }
            case 119: {
                this.updateTraceMaxIce();
                break;
            }
            case 120: {
                this.updateTraceMaxIce();
                break;
            }
            case 121: {
                this.updateTraceWanJian();
                break;
            }
            case 122: {
                this.updateTraceMaxMoney();
                break;
            }
            case 123: {
                this.updateTraceJiuTian();
                break;
            }
            case 124: {
                this.updateTraceXuanYanZhan();
                break;
            }
            case 126: {
                this.updateTraceMiFeng();
                break;
            }
            case 127: {
                this.updateTraceMaxSoil();
            }
        }
    }

    public final void draw(Graphics graphics) {
        if (!this._active) {
            return;
        }
        if (this._state == 1) {
            this.finishHandle();
            return;
        }
        switch (this._info[4]) {
            case 0: {
                this.paintForTraceNone(graphics);
                break;
            }
            case 1: 
            case 3: {
                this.paintTraceStay(graphics);
                break;
            }
            case 4: {
                this.paintAllScreenTraceStay(graphics);
                break;
            }
            case 2: {
                break;
            }
            case 101: {
                this.paintForTraceWanJian(graphics);
                break;
            }
            case 102: {
                this.paintForTraceTianJian(graphics);
                break;
            }
            case 103: {
                this.paintForTraceJianShen(graphics);
                break;
            }
            case 104: {
                this.paintTraceThrowUp(graphics);
                break;
            }
            case 105: {
                this.paintTraceStar(graphics);
                break;
            }
            case 106: {
                this.paintTraceShadow(graphics);
                break;
            }
            case 107: {
                this.paintTraceNan(graphics);
                break;
            }
            case 108: {
                this.paintTraceElect(graphics);
                break;
            }
            case 109: {
                this.paintTraceWind(graphics);
                break;
            }
            case 112: {
                this.paintTraceSoil(graphics);
                break;
            }
            case 110: {
                this.paintTraceFire(graphics);
                break;
            }
            case 5: {
                this.paintTraceCir(graphics);
                break;
            }
            case 113: {
                this.paintTraceThrowUpScreen(graphics);
                break;
            }
            case 114: {
                this.paintTraceMoney(graphics);
                break;
            }
            case 115: {
                this.paintTraceHand(graphics);
                break;
            }
            case 116: {
                this.paintTraceHead(graphics);
                break;
            }
            case 117: {
                this.paintTraceIce(graphics);
                break;
            }
            case 118: {
                this.paintTraceIceMid(graphics);
                break;
            }
            case 119: {
                this.paintTraceMaxIce(graphics);
                break;
            }
            case 120: {
                this.paintTraceMMIce(graphics);
                break;
            }
            case 121: {
                this.paintTraceWanJian(graphics);
                break;
            }
            case 122: {
                this.paintTraceMaxMoney(graphics);
                break;
            }
            case 123: {
                this.paintTraceJiuTian(graphics);
                break;
            }
            case 124: {
                this.paintTraceXuanYanZhan(graphics);
                break;
            }
            case 126: {
                this.paintTraceMiFeng(graphics);
                break;
            }
            case 127: {
                this.paintTraceMaxSoil(graphics);
            }
        }
    }

    public final void init(int[] nArray, int[] nArray2, Fighter fighter, Fighter[] fighterArray) {
        this.resetEffectData();
        this._state = 0;
        this.startupEndInfo();
        this._info = nArray;
        this._effectInfo = nArray2;
        this._user = fighter;
        this._target = fighterArray;
        this._active = true;
        nArray[5] = Math.min(nArray[5], 300);
        this.cameraHandle(this._info[10]);
        this.initForTrace(this._info[4]);
    }

    private final void cameraHandle(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.shakeCamera();
            }
        }
    }

    private final void shakeCamera() {
        BattleScene battleScene = GameMainLogic.getBattleScene();
        battleScene.startUpShake(6, 1);
    }

    private final void initForTrace(int n) {
        switch (n) {
            case 0: {
                this.initForTraceNone();
                break;
            }
            case 1: {
                this.initTraceStay();
                break;
            }
            case 3: {
                this.initTraceEffcetBetter();
                break;
            }
            case 4: {
                this.initAllScreenTraceStay();
                break;
            }
            case 2: {
                break;
            }
            case 101: {
                this.initForTraceWanJian();
                break;
            }
            case 102: {
                this.initForTraceTianJian();
                break;
            }
            case 103: {
                this.initForTraceJianShen();
                break;
            }
            case 104: {
                this.initTraceThrowUp();
                break;
            }
            case 105: {
                this.initTraceToStar();
                break;
            }
            case 106: {
                this.initTraceShadow();
                break;
            }
            case 107: {
                this.initTraceNan();
                break;
            }
            case 108: {
                this.initTraceElect();
                break;
            }
            case 109: {
                this.initTraceWind();
                break;
            }
            case 112: {
                this.initTraceSoil();
                break;
            }
            case 110: {
                this.initTraceFire();
                break;
            }
            case 5: {
                this.initTraceCir();
                break;
            }
            case 113: {
                this.initTraceThrowUpScreen();
                break;
            }
            case 114: {
                this.initTraceMoney();
                break;
            }
            case 115: {
                this.initTraceHand();
                break;
            }
            case 116: {
                this.initTraceHead();
                break;
            }
            case 117: {
                this.initTraceIce();
                break;
            }
            case 118: {
                this.initTraceIceMid();
                break;
            }
            case 119: {
                this.initTraceMaxIce();
                break;
            }
            case 120: {
                this.initTraceMaxIce();
                break;
            }
            case 121: {
                this.initTraceWanJian();
                break;
            }
            case 122: {
                this.initTraceMaxMoney();
                break;
            }
            case 123: {
                this.initTraceJiuTian();
                break;
            }
            case 124: {
                this.initTraceXuanYanZhan();
                break;
            }
            case 126: {
                this.initTraceMiFeng();
                break;
            }
            case 127: {
                this.initTraceSoilNumber();
                this.initTraceMaxSoil();
            }
        }
    }

    public final boolean isActioning() {
        return this._active;
    }

    private void finishTraceForParticle() {
        this.finishHandle();
    }

    private final void finishTraceForDrop() {
        if (this._info[2] == -1) {
            this.finishHandle();
        } else {
            this._state = 1;
        }
    }

    private final void effectHandle() {
        int n = this._target.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._target[n2] != null) {
                this._target[n2].effect(this._effectInfo);
            }
            ++n2;
        }
        if (this._user != null) {
            this._user.moveToOriginPos();
            this._user.changeToWait();
            this._user.resetDrawSkillName();
        }
    }

    private final void finishHandle() {
        this._info = null;
        this._effectInfo = null;
        this._user = null;
        this._target = null;
        this._active = false;
    }

    private final void startupEndInfo() {
        this._endValidFlag = false;
        int n = this._endEffectInfo.length;
        int n2 = 0;
        while (n2 < n) {
            this._endEffectInfo[n2][0] = -1;
            ++n2;
        }
    }

    private final int[] getEmptyEndInfo() {
        int n = this._endEffectInfo.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._endEffectInfo[n2][0] == -1) {
                this.setEndInvalid();
                return this._endEffectInfo[n2];
            }
            ++n2;
        }
        return null;
    }

    private final void setEndInvalid() {
        this._endValidFlag = false;
    }

    private final void sortEffectInfo() {
        if (this._endValidFlag) {
            return;
        }
        this._endValidFlag = true;
        int n = this._endEffectInfo.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            int n4 = n2 + 1;
            while (n4 < n) {
                if (this._endEffectInfo[n4][4] < this._endEffectInfo[n3][4]) {
                    n3 = n4;
                }
                ++n4;
            }
            this.swapEndInfo(n2, n3);
            ++n2;
        }
    }

    private final void swapEndInfo(int n, int n2) {
        if (n == n2) {
            return;
        }
        int[] nArray = this._endEffectInfo[n];
        this._endEffectInfo[n] = this._endEffectInfo[n2];
        this._endEffectInfo[n2] = nArray;
    }

    private final int paintEndEffect(Graphics graphics) {
        this.sortEffectInfo();
        int n = 0;
        int[][] nArray = this._endEffectInfo;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3][0] != -1) {
                ++n;
                Animation animation = Animation.getAnimation(nArray[n3][0]);
                animation.draw(graphics, nArray[n3][3], nArray[n3][4], nArray[n3][1], nArray[n3][2], 0);
                int[] nArray2 = nArray[n3];
                nArray2[2] = nArray2[2] + 1;
                if (nArray2[2] >= animation.getActFrmNum(nArray[n3][1])) {
                    nArray[n3][0] = -1;
                }
            }
            ++n3;
        }
        return n;
    }

    public void resetEffectData() {
        int n;
        int n2 = 0;
        while (n2 < 300) {
            n = 0;
            while (n < 14) {
                this._particleInfo[n2][n] = 0;
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n < 300) {
            int n3 = 0;
            while (n3 < 14) {
                this._dropInfo[n][n3] = 0;
                ++n3;
            }
            ++n;
        }
        this._dropValidInx = 0;
    }

    private final void updateForTraceNone() {
        this.effectHandle();
        this.finishHandle();
    }

    private final void paintForTraceNone(Graphics graphics) {
    }

    private final void initForTraceNone() {
    }

    private void initTraceStay() {
        this._info[5] = 0;
        this._info[5] = this._target.length;
        this._dropValidInx = 0;
        this._info[0] = this._effectInfo[7];
        this._info[1] = this._effectInfo[8];
        int n = 0;
        while (n < this._info[5]) {
            if (this._target[n] != null) {
                this._particleInfo[n][0] = 1;
                this._particleInfo[n][2] = this._target[n].getPosX() + (this._effectInfo[19] << 10);
                this._particleInfo[n][3] = this._target[n].getPosY() + (this._effectInfo[20] << 10);
                this._particleInfo[n][9] = -1;
                this._particleInfo[n][10] = Animation.getAnimation(this._info[0]).getActFrmNum(this._info[1]);
                ++this._dropValidInx;
            }
            ++n;
        }
    }

    private void undateTraceStay() {
        int[][] nArray = this._particleInfo;
        int n = 0;
        while (n < this._dropValidInx) {
            if (nArray[n][0] == 1) {
                int[] nArray2 = nArray[n];
                nArray2[9] = nArray2[9] + 1;
                if (nArray2[9] >= this._particleInfo[n][10]) {
                    nArray[n][0] = 0;
                    if (this._info[1] == 14) {
                        this.shakeCamera();
                    }
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            if (nArray[0][0] == 0) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else if (nArray[0][0] == 0) {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceStay(Graphics graphics) {
        int n = 0;
        while (n < this._dropValidInx) {
            if (this._particleInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._info[0]);
                int n2 = this._particleInfo[n][2] >> 10;
                int n3 = this._particleInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._info[1], this._particleInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceEffcetBetter() {
        boolean bl;
        GameRule gameRule = GameRule.getInstance();
        this._info[5] = 0;
        if (this._user._anim.getId() > 3) {
            bl = true;
            this._info[5] = 2;
        } else {
            bl = false;
            this._info[5] = 3;
        }
        this._dropValidInx = 0;
        this._info[0] = this._effectInfo[7];
        this._info[1] = this._effectInfo[8];
        int n = 0;
        while (n < this._info[5]) {
            this._particleInfo[n][0] = 1;
            this._particleInfo[n][2] = gameRule.getOrderInfoByInx(bl, n, 0)[0] + this._effectInfo[19] << 10;
            this._particleInfo[n][3] = gameRule.getOrderInfoByInx(bl, n, 0)[1] + this._effectInfo[20] << 10;
            this._particleInfo[n][9] = -1;
            this._particleInfo[n][10] = Animation.getAnimation(this._info[0]).getActFrmNum(this._info[1]);
            ++this._dropValidInx;
            ++n;
        }
    }

    private void initAllScreenTraceStay() {
        this._info[5] = 15;
        this._dropValidInx = 0;
        this._info[0] = this._effectInfo[7];
        this._info[1] = this._effectInfo[8];
        if (this._user._x > 215040) {
            this._info[6] = 100;
            this._info[7] = 120;
        } else {
            this._info[6] = 240;
            this._info[7] = 180;
        }
    }

    private void updateAllScreenTraceStay() {
        if (this._dropValidInx != -1 && this._dropValidInx < this._info[5]) {
            this._particleInfo[this._dropValidInx][0] = 1;
            int n = 10 * Function.Random(4, false);
            int n2 = (n << 10) * Function.cos(150) / 1024;
            int n3 = (n << 10) * Function.sin(150) / 1024;
            n = 10 * Function.Random(7, false);
            this._particleInfo[this._dropValidInx][2] = -(n2 += (n << 10) * Function.cos(60) / 1024) + (this._info[6] + this._effectInfo[19] << 10);
            this._particleInfo[this._dropValidInx][3] = (n3 += (n << 10) * Function.sin(60) / 1024) + (this._info[7] + this._effectInfo[20] << 10);
            this._particleInfo[this._dropValidInx][9] = -1;
            this._particleInfo[this._dropValidInx][10] = Animation.getAnimation(this._info[0]).getActFrmNum(this._info[1]);
            ++this._dropValidInx;
        }
        int[][] nArray = this._particleInfo;
        int n = 0;
        while (n < this._dropValidInx) {
            if (nArray[n][0] == 1) {
                int[] nArray2 = nArray[n];
                nArray2[9] = nArray2[9] + 1;
                if (nArray2[9] >= this._particleInfo[n][10]) {
                    nArray[n][0] = 0;
                    if (this._info[1] == 15) {
                        this.shakeCamera();
                    }
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n4 = 0;
            while (n4 < this._info[5]) {
                if (nArray[n4][0] != 0) break;
                ++n4;
            }
            if (n4 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else if (nArray[0][0] == 0) {
            this.finishTraceForParticle();
        }
    }

    private void paintAllScreenTraceStay(Graphics graphics) {
        int n = 0;
        while (n < this._dropValidInx) {
            if (this._particleInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._info[0]);
                int n2 = this._particleInfo[n][2] >> 10;
                int n3 = this._particleInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._info[1], this._particleInfo[n][9], 0);
            }
            ++n;
        }
    }

    public void setWanJianEffect(boolean bl) {
        this.openWanJianEffect = bl;
    }

    public void setXieJianEffect(boolean bl) {
        this.openXieJianEffect = bl;
    }

    private void initForTraceWanJian() {
        this._info[5] = WAN_JIAN_POSITION.length;
        this._dropValidInx = 0;
        this._info[0] = 107;
        this._info[1] = 8;
        this._particleInfo[0][0] = 1;
        this._particleInfo[0][2] = this._user._x + 10240;
        this._particleInfo[0][3] = this._user._y;
        this._particleInfo[0][9] = 4;
        this._particleInfo[0][10] = 7;
        this._particleInfo[0][7] = -51200;
    }

    private void updateForTraceWanJian() {
        int[][] nArray = this._particleInfo;
        if (nArray[0][0] == 1) {
            if (nArray[0][3] < 0) {
                nArray[0][0] = 0;
                int n = 1;
                while (n < WAN_JIAN_POSITION.length + 1) {
                    this._particleInfo[n][0] = 1;
                    if (this._user._x > 163840) {
                        this._particleInfo[n][2] = WAN_JIAN_POSITION[n - 1][0] + 50 << 10;
                        this._particleInfo[n][3] = -Function.Random(24, true) * 15 - 160 + WAN_JIAN_POSITION[n - 1][1] + 10 << 10;
                    } else {
                        this._particleInfo[n][2] = WAN_JIAN_POSITION[n - 1][0] + 50 + 130 << 10;
                        this._particleInfo[n][3] = -Function.Random(24, true) * 15 - 160 + WAN_JIAN_POSITION[n - 1][1] + 10 + 50 << 10;
                    }
                    this._particleInfo[n][9] = 8;
                    this._particleInfo[n][10] = 10;
                    this._particleInfo[n][7] = 30720;
                    ++this._dropValidInx;
                    ++n;
                }
                return;
            }
            int[] nArray2 = nArray[0];
            nArray2[3] = nArray2[3] + nArray[0][7];
            if (this._particleInfo[0][9] <= this._particleInfo[0][10]) {
                this._particleInfo[0][9] = this._particleInfo[0][10];
            }
            return;
        }
        int n = 1;
        while (n < WAN_JIAN_POSITION.length + 1) {
            if (nArray[n][0] == 1) {
                if (this._user._x > 163840) {
                    if (nArray[n][3] < WAN_JIAN_POSITION[n - 1][1] + 10 << 10) {
                        int[] nArray3 = nArray[n];
                        nArray3[3] = nArray3[3] + nArray[n][7];
                    }
                    if (nArray[n][3] >= WAN_JIAN_POSITION[n - 1][1] + 10 << 10) {
                        nArray[n][3] = WAN_JIAN_POSITION[n - 1][1] + 10 << 10;
                        int[] nArray4 = nArray[n];
                        nArray4[9] = nArray4[9] + 1;
                        if (nArray[n][9] >= nArray[n][10]) {
                            nArray[n][9] = nArray[n][10];
                            nArray[n][0] = 0;
                        }
                    }
                } else {
                    if (nArray[n][3] < WAN_JIAN_POSITION[n - 1][1] + 10 + 130 << 10) {
                        int[] nArray5 = nArray[n];
                        nArray5[3] = nArray5[3] + nArray[n][7];
                    }
                    if (nArray[n][3] >= WAN_JIAN_POSITION[n - 1][1] + 10 + 50 << 10) {
                        nArray[n][3] = WAN_JIAN_POSITION[n - 1][1] + 10 + 50 << 10;
                        int[] nArray6 = nArray[n];
                        nArray6[9] = nArray6[9] + 1;
                        if (nArray[n][9] >= nArray[n][10]) {
                            nArray[n][9] = nArray[n][10];
                            nArray[n][0] = 0;
                        }
                    }
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < WAN_JIAN_POSITION.length + 1) {
                if (nArray[n2][0] != 0) break;
                ++n2;
            }
            if (n2 >= WAN_JIAN_POSITION.length + 1) {
                this._dropValidInx = -1;
                this.effectHandle();
                if (this._user._x > 163840) {
                    this.setWanJianEffect(true);
                } else {
                    this.setXieJianEffect(true);
                }
            }
        } else if (nArray[WAN_JIAN_POSITION.length - 1][0] == 0) {
            this.finishTraceForParticle();
        }
    }

    private void paintForTraceWanJian(Graphics graphics) {
        if (this._particleInfo[0][0] == 1) {
            Animation animation = Animation.getAnimation(this._info[0]);
            int n = this._particleInfo[0][2] >> 10;
            int n2 = this._particleInfo[0][3] >> 10;
            animation.draw(graphics, n, n2, this._particleInfo[0][9], 0, 0);
            return;
        }
        int n = 1;
        while (n < WAN_JIAN_POSITION.length + 1) {
            if (this._dropValidInx != -1) {
                Animation animation = Animation.getAnimation(this._info[0]);
                int n3 = this._particleInfo[n][2] >> 10;
                int n4 = this._particleInfo[n][3] >> 10;
                animation.draw(graphics, n3, n4, this._particleInfo[n][9], 0, 0);
            }
            ++n;
        }
    }

    public void paintForTraceWanJianEffect(Graphics graphics) {
        int n;
        int n2;
        Animation animation;
        int n3;
        if (this.openWanJianEffect) {
            n3 = 0;
            while (n3 < WAN_JIAN_POSITION.length) {
                animation = Animation.getAnimation(107);
                n2 = WAN_JIAN_POSITION[n3][0] + 50;
                n = WAN_JIAN_POSITION[n3][1] + 10;
                animation.draw(graphics, n2, n, 10, 0, 0);
                ++n3;
            }
        }
        if (this.openXieJianEffect) {
            n3 = 0;
            while (n3 < WAN_JIAN_POSITION.length) {
                animation = Animation.getAnimation(107);
                n2 = WAN_JIAN_POSITION[n3][0] + 50 + 130;
                n = WAN_JIAN_POSITION[n3][1] + 10 + 50;
                animation.draw(graphics, n2, n, 10, 0, 0);
                ++n3;
            }
        }
    }

    private void resetEffectState() {
        int n = 0;
        while (n < this._effectSign.length) {
            this._effectSign[n] = false;
            ++n;
        }
        this._effectCounter = 0;
        this._dropValidInx = 0;
        int n2 = 0;
        while (n2 < this._particleInfom.length) {
            int n3 = 0;
            while (n3 < this._particleInfom[n2].length) {
                int n4 = 0;
                while (n4 < this._particleInfom[n2][n4].length) {
                    this._particleInfom[n2][n3][n4] = 0;
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void initForTraceTianJian() {
        int n;
        int n2;
        this.resetEffectState();
        if (this._user._x > 163840) {
            this._info[6] = 240;
            this._info[7] = 150;
        } else {
            this._info[6] = 80;
            this._info[7] = 60;
        }
        this._info[0] = 107;
        this._info[1] = 3;
        this._effectMaxNumber[0] = 10;
        int n3 = 0;
        while (n3 < this._effectMaxNumber[0]) {
            int n4 = n3 % 2 > 0 ? 60 : 210;
            n2 = (30 * (n3 / 2 + 1) << 10) * Function.cos(n4) / 1024;
            n = (30 * (n3 / 2 + 1) << 10) * Function.sin(n4) / 1024;
            this._particleInfom[0][n3][0] = 1;
            this._particleInfom[0][n3][2] = n2 + (this._info[6] << 10);
            this._particleInfom[0][n3][3] = -n + (this._info[7] << 10);
            this._particleInfom[0][n3][1] = 4 * (n3 / 2 + 1);
            this._particleInfom[0][n3][5] = -n2 / this._particleInfom[0][n3][1];
            this._particleInfom[0][n3][7] = n / this._particleInfom[0][n3][1];
            this._particleInfom[0][n3][9] = 0;
            ++n3;
        }
        this._effectMaxNumber[1] = 1;
        int n5 = 0;
        while (n5 < this._effectMaxNumber[1]) {
            this._particleInfom[1][n5][0] = 1;
            this._particleInfom[1][n5][2] = this._info[6] << 10;
            this._particleInfom[1][n5][3] = this._info[7] << 10;
            this._particleInfom[1][n5][5] = 0;
            this._particleInfom[1][n5][7] = 0;
            this._particleInfom[1][n5][9] = 0;
            ++n5;
        }
        this._effectMaxNumber[2] = 1;
        int n6 = 0;
        while (n6 < this._effectMaxNumber[2]) {
            n2 = 245760 * Function.cos(150) / 1024;
            n = 245760 * Function.sin(150) / 1024;
            this._particleInfom[2][n6][0] = 1;
            this._particleInfom[2][n6][1] = 5;
            this._particleInfom[2][n6][2] = this._info[6] << 10;
            this._particleInfom[2][n6][3] = this._info[7] << 10;
            if (this._user._x > 163840) {
                this._particleInfom[2][n6][5] = n2 / this._particleInfom[2][n6][1];
                this._particleInfom[2][n6][7] = -n / this._particleInfom[2][n6][1];
            } else {
                this._particleInfom[2][n6][5] = -n2 / this._particleInfom[2][n6][1];
                this._particleInfom[2][n6][7] = n / this._particleInfom[2][n6][1];
            }
            this._particleInfom[2][n6][9] = 0;
            ++n6;
        }
        this._effectSign[0] = true;
    }

    private void updateForTraceTianJian() {
        int n;
        if (this._effectSign[0]) {
            n = 0;
            while (n < this._effectMaxNumber[0]) {
                if (this._particleInfom[0][n][0] == 1) {
                    int[] nArray = this._particleInfom[0][n];
                    nArray[1] = nArray[1] - 1;
                    if (nArray[1] > 0) {
                        int[] nArray2 = this._particleInfom[0][n];
                        nArray2[2] = nArray2[2] + this._particleInfom[0][n][5];
                        int[] nArray3 = this._particleInfom[0][n];
                        nArray3[3] = nArray3[3] + this._particleInfom[0][n][7];
                    } else {
                        this._particleInfom[0][n][0] = 0;
                        if (n == 0) {
                            this._effectSign[1] = true;
                        }
                        if (n == this._effectMaxNumber[0] - 1) {
                            this._effectSign[1] = false;
                            this._effectSign[2] = true;
                        }
                    }
                }
                ++n;
            }
            n = 0;
            while (n < this._effectMaxNumber[0]) {
                if (this._particleInfom[0][n][0] > 0) break;
                ++n;
            }
            if (n >= this._effectMaxNumber[0]) {
                this._effectSign[0] = false;
            }
        }
        if (this._effectSign[2]) {
            n = 0;
            while (n < this._effectMaxNumber[2]) {
                if (this._particleInfom[2][n][0] == 1) {
                    int[] nArray = this._particleInfom[2][n];
                    nArray[1] = nArray[1] - 1;
                    if (nArray[1] > 0) {
                        int[] nArray4 = this._particleInfom[2][n];
                        nArray4[2] = nArray4[2] + this._particleInfom[2][n][5];
                        int[] nArray5 = this._particleInfom[2][n];
                        nArray5[3] = nArray5[3] + this._particleInfom[2][n][7];
                    } else {
                        this._particleInfom[2][n][0] = 0;
                    }
                }
                ++n;
            }
            if (this._dropValidInx != -1) {
                n = 0;
                while (n < this._effectMaxNumber[2]) {
                    if (this._particleInfom[2][n][0] != 0) break;
                    ++n;
                }
                if (n >= this._effectMaxNumber[2]) {
                    this._dropValidInx = -1;
                    this.effectHandle();
                }
            } else {
                this.finishTraceForParticle();
            }
        }
    }

    private void paintForTraceTianJian(Graphics graphics) {
        int n = 0;
        while (n < this._particleInfom.length) {
            if (this._effectSign[n]) {
                int n2 = 0;
                while (n2 < this._effectMaxNumber[n]) {
                    if (this._particleInfom[n][n2][0] > 0) {
                        Animation animation = Animation.getAnimation(this._info[0]);
                        int n3 = this._particleInfom[n][n2][2] >> 10;
                        int n4 = this._particleInfom[n][n2][3] >> 10;
                        if (this._user._x > 163840) {
                            animation.draw(graphics, n3, n4, this._info[1], this._particleInfom[n][n2][9], 0);
                        } else {
                            animation.draw(graphics, n3, n4, this._info[1] | Integer.MIN_VALUE | 0x40000000, this._particleInfom[n][n2][9], 0);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void initForTraceJianShen() {
        this.resetEffectState();
        if (this._user._x > 163840) {
            this._info[6] = 213;
            this._info[7] = 150;
        } else {
            this._info[6] = 80;
            this._info[7] = 80;
        }
        this._info[0] = 107;
        this._info[1] = 13;
        this._effectMaxNumber[0] = 100;
        int n = 0;
        while (n < this._effectMaxNumber[0]) {
            this._particleInfom[0][n][0] = 0;
            this._particleInfom[0][n][2] = this._info[6] + Function.Random(60, false) << 10;
            this._particleInfom[0][n][3] = this._info[7] + Function.Random(30, false) << 10;
            this._particleInfom[0][n][1] = 25;
            this._particleInfom[0][n][5] = 0;
            this._particleInfom[0][n][7] = 0;
            this._particleInfom[0][n][13] = 13;
            this._particleInfom[0][n][10] = Animation.getAnimation(this._info[0]).getActFrmNum(this._particleInfom[0][n][13]);
            this._particleInfom[0][n][9] = Function.Random(this._particleInfom[0][n][10], true);
            ++n;
        }
        this._effectSign[0] = true;
    }

    private void updateForTraceJianShen() {
        int n = 0;
        while (n < this._effectMaxNumber[0]) {
            if (n - this._effectCounter < this._effectMaxNumber[0] / 10) {
                this._particleInfom[0][n][0] = 1;
            }
            if (this._particleInfom[0][n][0] == 1) {
                int[] nArray = this._particleInfom[0][n];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    if (this._particleInfom[0][n][1] == 3) {
                        if (this._user._x > 163840) {
                            this._particleInfom[0][n][5] = 245760 * Function.cos(150) / 1024 / 3;
                            this._particleInfom[0][n][7] = -(245760 * Function.sin(150) / 1024) / 3;
                        } else {
                            this._particleInfom[0][n][5] = -(245760 * Function.cos(150) / 1024) / 3;
                            this._particleInfom[0][n][7] = 245760 * Function.sin(150) / 1024 / 3;
                        }
                    }
                    int[] nArray2 = this._particleInfom[0][n];
                    nArray2[2] = nArray2[2] + this._particleInfom[0][n][5];
                    int[] nArray3 = this._particleInfom[0][n];
                    nArray3[3] = nArray3[3] + this._particleInfom[0][n][7];
                    int[] nArray4 = this._particleInfom[0][n];
                    nArray4[9] = nArray4[9] + 1;
                    if (nArray4[9] >= this._particleInfom[0][n][10]) {
                        this._particleInfom[0][n][9] = 0;
                    }
                } else {
                    this._particleInfom[0][n][0] = 0;
                }
            }
            ++n;
        }
        if (this._effectCounter < this._effectMaxNumber[0]) {
            this._effectCounter += this._effectMaxNumber[0] / 10;
        }
        if (this._dropValidInx != -1) {
            n = 0;
            while (n < this._effectMaxNumber[0]) {
                if (this._particleInfom[0][n][0] != 0) break;
                ++n;
            }
            if (n >= this._effectMaxNumber[0]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintForTraceJianShen(Graphics graphics) {
        int n = 0;
        while (n < this._particleInfom.length) {
            if (this._effectSign[n]) {
                int n2 = 0;
                while (n2 < this._effectMaxNumber[n]) {
                    if (this._particleInfom[n][n2][0] > 0) {
                        Animation animation = Animation.getAnimation(this._info[0]);
                        int n3 = this._particleInfom[n][n2][2] >> 10;
                        int n4 = this._particleInfom[n][n2][3] >> 10;
                        if (this._user._x > 163840) {
                            animation.draw(graphics, n3, n4, this._particleInfom[n][n2][13], this._particleInfom[n][n2][9], 0);
                        } else {
                            animation.draw(graphics, n3, n4, this._particleInfom[n][n2][13] | Integer.MIN_VALUE | 0x40000000, this._particleInfom[n][n2][9], 0);
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void initTraceThrowUp() {
        this._info[5] = 0;
        int n = 0;
        while (n < this._target.length) {
            if (this._target[n] != null) {
                this._info[5] = this._info[5] + 60;
            }
            ++n;
        }
        this._dropValidInx = 0;
        this._info[0] = this._effectInfo[7];
        this._info[1] = this._effectInfo[8];
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n2 = 0;
        while (n2 < this._info[5]) {
            this._dropInfo[n2][0] = 1;
            this._dropInfo[n2][1] = 0;
            this._dropInfo[n2][2] = this._target[n2 / 60]._x + (Function.Random(12, false) << 10);
            this._dropInfo[n2][3] = this._target[n2 / 60]._y - 61440;
            this._dropInfo[n2][4] = 0;
            this._dropInfo[n2][7] = -(Function.Random(6, true) << 10);
            this._dropInfo[n2][8] = 1024;
            this._dropInfo[n2][9] = 0;
            this._dropInfo[n2][11] = Function.Random(15, true);
            ++this._dropInfoValidNum;
            ++n2;
        }
        this._info[5] = 0;
    }

    private void updateTraceThrowUp() {
        int n = 0;
        while (n < this._dropInfoValidNum) {
            if (this._dropInfo[n][0] == 1) {
                int[] nArray = this._dropInfo[n];
                nArray[11] = nArray[11] - 1;
                if (nArray[11] <= 0) {
                    this._dropInfo[n][0] = 0;
                }
                int[] nArray2 = this._dropInfo[n];
                nArray2[7] = nArray2[7] + this._dropInfo[n][8];
                int[] nArray3 = this._dropInfo[n];
                nArray3[2] = nArray3[2] + this._dropInfo[n][5];
                int[] nArray4 = this._dropInfo[n];
                nArray4[3] = nArray4[3] + this._dropInfo[n][7];
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._dropInfoValidNum) {
                if (this._dropInfo[n2][0] != 0) break;
                ++n2;
            }
            if (n2 >= this._dropInfoValidNum) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else if (this._dropInfo[0][0] == 0) {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceThrowUp(Graphics graphics) {
        int n = 0;
        while (n < this._dropInfoValidNum) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._info[0]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, LIGHT_POINT[Function.Random(LIGHT_POINT.length, true)], this._dropInfo[n][9], this._info[13]);
            }
            ++n;
        }
    }

    private void initTraceToStar() {
        this._info[5] = 100;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][2] = 66 + 10 * Function.Random(10, false) << 10;
            this._dropInfo[n][3] = 120 + 10 * Function.Random(5, false) << 10;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            ++n;
        }
    }

    private void undateTraceStar() {
        int n = 245760 * Function.sin(45) / 1024;
        this._dropInfoValidNum += 5;
        if (this._dropInfoValidNum > this._info[5]) {
            this._dropInfoValidNum = this._info[5];
        }
        int n2 = this._dropValidNum;
        while (n2 < this._dropInfoValidNum) {
            if (this._dropInfo[n2][0] != 1) {
                this._dropInfo[n2][0] = 1;
                this._dropInfo[n2][1] = 5;
                int[] nArray = this._dropInfo[n2];
                nArray[2] = nArray[2] + n;
                int[] nArray2 = this._dropInfo[n2];
                nArray2[3] = nArray2[3] - n;
                this._dropInfo[n2][5] = -n / this._dropInfo[n2][1];
                this._dropInfo[n2][7] = n / this._dropInfo[n2][1];
                this._dropInfo[n2][9] = 0;
                this._dropInfo[n2][10] = Animation.getAnimation(this._dropInfo[n2][12]).getActFrmNum(this._dropInfo[n2][13]);
            }
            ++n2;
        }
        int n3 = this._dropValidNum;
        while (n3 < this._dropInfoValidNum) {
            if (this._dropInfo[n3][0] == 1) {
                int[] nArray = this._dropInfo[n3];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    int[] nArray3 = this._dropInfo[n3];
                    nArray3[2] = nArray3[2] + this._dropInfo[n3][5];
                    int[] nArray4 = this._dropInfo[n3];
                    nArray4[3] = nArray4[3] + this._dropInfo[n3][7];
                    int[] nArray5 = this._dropInfo[n3];
                    nArray5[9] = nArray5[9] + 1;
                    if (this._dropInfo[n3][9] >= this._dropInfo[n3][10]) {
                        this._dropInfo[n3][9] = 0;
                    }
                } else if (this._dropInfo[n3][13] != 2) {
                    this._dropInfo[n3][5] = 0;
                    this._dropInfo[n3][7] = 0;
                    this._dropInfo[n3][13] = 2;
                    this._dropInfo[n3][9] = 0;
                    this._dropInfo[n3][1] = Animation.getAnimation(this._dropInfo[n3][12]).getActFrmNum(this._dropInfo[n3][13]);
                    this._dropInfo[n3][10] = Animation.getAnimation(this._dropInfo[n3][12]).getActFrmNum(this._dropInfo[n3][13]);
                } else {
                    this._dropInfo[n3][0] = 0;
                    ++this._dropValidNum;
                }
            }
            ++n3;
        }
        if (this._dropValidInx != -1) {
            int n4 = 0;
            while (n4 < this._info[5]) {
                if (this._dropInfo[n4][0] != 0) break;
                ++n4;
            }
            if (n4 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceStar(Graphics graphics) {
        int n = 0;
        while (n < this._dropInfoValidNum) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], this._info[13]);
            }
            ++n;
        }
    }

    private void initTraceShadow() {
        this.resetEffectState();
        this._info[5] = 9;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][2] = 146 + 12 * n << 10;
            this._dropInfo[n][3] = 165 - 8 * n << 10;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            this._dropInfo[n][9] = 0;
            this._dropInfo[n][10] = Animation.getAnimation(this._dropInfo[n][12]).getActFrmNum(this._dropInfo[n][13]);
            ++n;
        }
        this._effectSign[0] = true;
    }

    private void updateTraceShadow() {
        int n;
        if (this._effectSign[0]) {
            if (++this._dropInfoValidNum > this._info[5]) {
                this._dropInfoValidNum = this._info[5];
            }
            if (this._dropInfo[this._dropInfoValidNum - 1][0] == 1) {
                this._effectSign[0] = false;
                this._effectSign[1] = true;
                this._dropInfoValidNum = 0;
            }
            n = 0;
            while (n < this._dropInfoValidNum) {
                if (this._dropInfo[n][0] != 1) {
                    this._dropInfo[n][0] = 1;
                }
                ++n;
            }
        }
        if (this._effectSign[1]) {
            if (++this._dropInfoValidNum > this._info[5]) {
                this._dropInfoValidNum = this._info[5];
            }
            if (this._dropInfo[this._dropInfoValidNum - 1][9] == this._dropInfo[this._dropInfoValidNum - 1][10] - 1) {
                this._effectSign[1] = false;
                this._effectSign[2] = true;
            }
            n = 0;
            while (n < this._dropInfoValidNum) {
                int[] nArray = this._dropInfo[n];
                nArray[9] = nArray[9] + 1;
                if (nArray[9] >= this._dropInfo[n][10]) {
                    this._dropInfo[n][9] = this._dropInfo[n][10] - 1;
                }
                ++n;
            }
        }
        if (this._effectSign[2]) {
            if (this._dropValidInx != -1) {
                this._dropValidInx = -1;
                this.effectHandle();
            } else {
                this.finishTraceForParticle();
            }
        }
    }

    private void paintTraceShadow(Graphics graphics) {
        int n = this._info[5];
        while (n >= 0) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            --n;
        }
    }

    private void initTraceNan() {
        this._info[5] = 6;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        int n = 122880 * Function.cos(150) / 1024;
        int n2 = 122880 * Function.sin(150) / 1024;
        int n3 = 0;
        while (n3 < this._info[5]) {
            this._dropInfo[n3][0] = 1;
            this._dropInfo[n3][2] = 245760;
            this._dropInfo[n3][3] = 150 - 40 * n3 << 10;
            this._dropInfo[n3][1] = 20;
            this._dropInfo[n3][5] = n / this._dropInfo[n3][1];
            this._dropInfo[n3][7] = -n2 / this._dropInfo[n3][1];
            this._dropInfo[n3][12] = this._effectInfo[7];
            this._dropInfo[n3][13] = this._effectInfo[8];
            this._dropInfo[n3][9] = 0;
            this._dropInfo[n3][10] = Animation.getAnimation(this._dropInfo[n3][12]).getActFrmNum(this._dropInfo[n3][13]);
            ++n3;
        }
    }

    private void updateTraceNan() {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] != 0) {
                int[] nArray = this._dropInfo[n];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[9] = nArray2[9] + 1;
                    if (nArray2[9] >= this._dropInfo[n][10]) {
                        this._dropInfo[n][9] = 0;
                    }
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[2] = nArray3[2] + this._dropInfo[n][5];
                    int[] nArray4 = this._dropInfo[n];
                    nArray4[3] = nArray4[3] + this._dropInfo[n][7];
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._info[5]) {
                if (this._dropInfo[n2][0] != 0) break;
                ++n2;
            }
            if (n2 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceNan(Graphics graphics) {
        int n = this._info[5];
        while (n >= 0) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            --n;
        }
    }

    private void initTraceElect() {
        int n;
        int n2;
        this._info[5] = 12;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        int n3 = 81920 * Function.cos(150) / 1024;
        int n4 = 81920 * Function.sin(150) / 1024;
        if (this._user._x > 163840) {
            n2 = 200;
            n = 60;
        } else {
            n2 = 160;
            n = 10;
        }
        this._dropInfo[this._info[5]][0] = 1;
        this._dropInfo[this._info[5]][12] = this._effectInfo[7];
        this._dropInfo[this._info[5]][13] = this._effectInfo[8];
        this._dropInfo[this._info[5]][1] = 50;
        if (this._user._x > 163840) {
            this._dropInfo[this._info[5]][2] = n2 << 10;
            this._dropInfo[this._info[5]][3] = n << 10;
            this._dropInfo[this._info[5]][5] = n3 / this._dropInfo[this._info[5]][1];
            this._dropInfo[this._info[5]][7] = -n4 / this._dropInfo[this._info[5]][1];
        } else {
            this._dropInfo[this._info[5]][2] = n2 << 10;
            this._dropInfo[this._info[5]][3] = n << 10;
            this._dropInfo[this._info[5]][5] = -n3 / this._dropInfo[this._info[5]][1];
            this._dropInfo[this._info[5]][7] = n4 / this._dropInfo[this._info[5]][1];
        }
        this._dropInfo[this._info[5]][9] = 0;
        this._dropInfo[this._info[5]][10] = Animation.getAnimation(this._dropInfo[this._info[5]][12]).getActFrmNum(this._dropInfo[this._info[5]][13]);
        int n5 = 0;
        while (n5 < this._info[5]) {
            this._dropInfo[n5][11] = this.arrayNumber[n5];
            this._dropInfo[n5][0] = 1;
            this._dropInfo[n5][2] = this._dropInfo[this._info[5]][2] + (this.arraySpace[n5] << 10) * Function.cos(this._dropInfo[n5][11]) / 1024;
            this._dropInfo[n5][3] = this._dropInfo[this._info[5]][3] + (this.arraySpace[n5] << 10) * -Function.sin(this._dropInfo[n5][11]) / 1024;
            this._dropInfo[n5][1] = 50;
            this._dropInfo[n5][12] = this._effectInfo[7];
            this._dropInfo[n5][13] = this._effectInfo[8];
            this._dropInfo[n5][9] = 0;
            this._dropInfo[n5][10] = Animation.getAnimation(this._dropInfo[n5][12]).getActFrmNum(this._dropInfo[n5][13]);
            ++n5;
        }
    }

    private void updateTraceElect() {
        int n = this._info[5];
        while (n >= 0) {
            if (this._dropInfo[n][0] != 0) {
                int[] nArray = this._dropInfo[n];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[9] = nArray2[9] + 1;
                    if (nArray2[9] >= this._dropInfo[n][10]) {
                        this._dropInfo[n][9] = 0;
                    }
                    if (n == this._info[5]) {
                        int[] nArray3 = this._dropInfo[n];
                        nArray3[2] = nArray3[2] + this._dropInfo[n][5];
                        int[] nArray4 = this._dropInfo[n];
                        nArray4[3] = nArray4[3] + this._dropInfo[n][7];
                    } else {
                        int[] nArray5 = this._dropInfo[n];
                        nArray5[11] = nArray5[11] - this.arrayAngle[n];
                        if (this._dropInfo[n][11] <= 0) {
                            int[] nArray6 = this._dropInfo[n];
                            nArray6[11] = nArray6[11] + 360;
                        }
                        this._dropInfo[n][2] = this._dropInfo[this._info[5]][2] + (this.arraySpace[n] << 10) * Function.cos(this._dropInfo[n][11]) / 1024;
                        this._dropInfo[n][3] = this._dropInfo[this._info[5]][3] + (this.arraySpace[n] << 10) * -Function.sin(this._dropInfo[n][11]) / 1024;
                    }
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            --n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._info[5]) {
                if (this._dropInfo[n2][0] != 0) break;
                ++n2;
            }
            if (n2 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceElect(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceWind() {
        this._info[5] = 24;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        int n = 81920 * Function.cos(150) / 1024;
        int n2 = 81920 * Function.sin(150) / 1024;
        this._dropInfo[this._info[5]][0] = 1;
        this._dropInfo[this._info[5]][12] = this._effectInfo[7];
        this._dropInfo[this._info[5]][13] = this._effectInfo[8];
        this._dropInfo[this._info[5]][2] = 245760;
        this._dropInfo[this._info[5]][3] = 153600;
        this._dropInfo[this._info[5]][1] = 40;
        this._dropInfo[this._info[5]][5] = n / this._dropInfo[this._info[5]][1];
        this._dropInfo[this._info[5]][7] = -n2 / this._dropInfo[this._info[5]][1];
        this._dropInfo[this._info[5]][9] = 0;
        this._dropInfo[this._info[5]][10] = Animation.getAnimation(this._dropInfo[this._info[5]][12]).getActFrmNum(this._dropInfo[this._info[5]][13]);
        int n3 = 0;
        while (n3 < this._info[5]) {
            this._dropInfo[n3][11] = this.arrayWindNumber[n3 / 6];
            this._dropInfo[n3][0] = 1;
            this._dropInfo[n3][2] = this._dropInfo[this._info[5]][2] + (this.arrayWindSpace[n3 / 6] << 10) * Function.cos(this._dropInfo[n3][11]) / 1024;
            this._dropInfo[n3][3] = this._dropInfo[this._info[5]][3] - (40 * (n3 % 6) << 10) + (this.arrayWindSpace[n3 / 6] << 10) * -Function.sin(this._dropInfo[n3][11]) / 1024;
            this._dropInfo[n3][1] = 40;
            this._dropInfo[n3][12] = this._effectInfo[7];
            this._dropInfo[n3][13] = this._effectInfo[8];
            this._dropInfo[n3][9] = 0;
            this._dropInfo[n3][10] = Animation.getAnimation(this._dropInfo[n3][12]).getActFrmNum(this._dropInfo[n3][13]);
            ++n3;
        }
    }

    private void updateTraceWind() {
        int n = this._info[5];
        while (n >= 0) {
            if (this._dropInfo[n][0] != 0) {
                int[] nArray = this._dropInfo[n];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[9] = nArray2[9] + 1;
                    if (nArray2[9] >= this._dropInfo[n][10]) {
                        this._dropInfo[n][9] = 0;
                    }
                    if (n == this._info[5]) {
                        int[] nArray3 = this._dropInfo[n];
                        nArray3[2] = nArray3[2] + this._dropInfo[n][5];
                        int[] nArray4 = this._dropInfo[n];
                        nArray4[3] = nArray4[3] + this._dropInfo[n][7];
                    } else {
                        int[] nArray5 = this._dropInfo[n];
                        nArray5[11] = nArray5[11] + this.arrayWindAngle[n / 6];
                        if (this._dropInfo[n][11] >= 360) {
                            int[] nArray6 = this._dropInfo[n];
                            nArray6[11] = nArray6[11] - 360;
                        }
                        this._dropInfo[n][2] = this._dropInfo[this._info[5]][2] + (this.arrayWindSpace[n / 6] << 10) * Function.cos(this._dropInfo[n][11]) / 1024;
                        this._dropInfo[n][3] = this._dropInfo[this._info[5]][3] - (40 * (n % 6) << 10) + (this.arrayWindSpace[n / 6] << 10) * -Function.sin(this._dropInfo[n][11]) / 1024;
                    }
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            --n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._info[5]) {
                if (this._dropInfo[n2][0] != 0) break;
                ++n2;
            }
            if (n2 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceWind(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceFire() {
        this._info[5] = 100;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            if (this._user._x > 163840) {
                this._dropInfo[n][2] = (4 + Function.Random(6, false)) * 21 << 10;
                this._dropInfo[n][3] = (9 + Function.Random(3, false)) * 12 << 10;
            } else {
                this._dropInfo[n][2] = (11 + Function.Random(6, false)) * 21 << 10;
                this._dropInfo[n][3] = (14 + Function.Random(3, false)) * 12 << 10;
            }
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            this._dropInfo[n][10] = Animation.getAnimation(this._dropInfo[n][12]).getActFrmNum(this._dropInfo[n][13]);
            this._dropInfo[n][9] = Function.Random(this._dropInfo[n][10], true);
            ++n;
        }
    }

    private void updateTraceFire() {
        this._dropValidNum += 6;
        if (this._dropValidNum >= this._info[5]) {
            this._dropValidNum = this._info[5];
        }
        int n = 0;
        while (n < this._dropValidNum) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                nArray[9] = nArray[9] + 1;
                if (nArray[9] >= this._dropInfo[n][10]) {
                    this._dropInfo[n][0] = 0;
                }
            } else if (this._dropInfo[n][9] < this._dropInfo[n][10]) {
                this._dropInfo[n][0] = 1;
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._info[5]) {
                if (this._dropInfo[n2][0] != 0) break;
                ++n2;
            }
            if (n2 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceFire(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceIce() {
        this._info[5] = 0;
        int n = 0;
        while (n < this._target.length) {
            if (this._target[n] != null) {
                this._info[5] = this._info[5] + 60;
            }
            ++n;
        }
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n2 = 0;
        while (n2 < this._info[5]) {
            this._dropInfo[n2][0] = 1;
            this._dropInfo[n2][2] = this._target[n2 / 60].getPosX() + (Function.Random(20, false) << 10);
            this._dropInfo[n2][3] = this._target[n2 / 60].getPosY() - (Function.Random(50, true) << 10);
            this._dropInfo[n2][5] = 0;
            this._dropInfo[n2][7] = n2 % 2 > 0 ? 3072 : -3072;
            this._dropInfo[n2][12] = this._effectInfo[7];
            this._dropInfo[n2][13] = this._effectInfo[8];
            this._dropInfo[n2][1] = 10;
            ++n2;
        }
    }

    private void updateTraceIce() {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[3] = nArray2[3] + this._dropInfo[n][7];
                    if (n % 2 > 0) {
                        if (this._dropInfo[n][3] > this._target[n / 60].getPosY()) {
                            int[] nArray3 = this._dropInfo[n];
                            nArray3[3] = nArray3[3] - 51200;
                        }
                    } else if (this._dropInfo[n][3] < this._target[n / 60].getPosY() - 51200) {
                        int[] nArray4 = this._dropInfo[n];
                        nArray4[3] = nArray4[3] + 51200;
                    }
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceIce(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceIceMid() {
        boolean bl;
        GameRule gameRule = GameRule.getInstance();
        this._info[5] = 0;
        if (this._user._anim.getId() > 3) {
            bl = true;
            this._info[5] = 120;
        } else {
            bl = false;
            this._info[5] = 180;
        }
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 1;
            this._dropInfo[n][2] = gameRule.getOrderInfoByInx(bl, n / 60, 0)[0] + Function.Random(20, false) << 10;
            this._dropInfo[n][3] = gameRule.getOrderInfoByInx(bl, n / 60, 0)[1] - Function.Random(50, true) << 10;
            this._dropInfo[n][5] = 0;
            this._dropInfo[n][7] = n % 2 > 0 ? 3072 : -3072;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            this._dropInfo[n][1] = 10;
            ++n;
        }
    }

    private void updateTraceIceMid() {
        GameRule gameRule = GameRule.getInstance();
        boolean bl = this._user._anim.getId() > 3;
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[3] = nArray2[3] + this._dropInfo[n][7];
                    if (n % 2 > 0) {
                        if (this._dropInfo[n][3] > gameRule.getOrderInfoByInx(bl, n / 60, 0)[1] << 10) {
                            int[] nArray3 = this._dropInfo[n];
                            nArray3[3] = nArray3[3] - 51200;
                        }
                    } else if (this._dropInfo[n][3] < gameRule.getOrderInfoByInx(bl, n / 60, 0)[1] - 50 << 10) {
                        int[] nArray4 = this._dropInfo[n];
                        nArray4[3] = nArray4[3] + 51200;
                    }
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceIceMid(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceMaxIce() {
        this._info[5] = 300;
        this._dropValidNum = 0;
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][1] = 10;
            if (this._user._x < 163840) {
                this._dropInfo[n][2] = 0;
                this._dropInfo[n][3] = Function.Random(80, true) << 10;
                this._dropInfo[n][5] = -8192 * Function.cos(150) / 1024;
                this._dropInfo[n][7] = 8192 * Function.sin(150) / 1024;
            } else {
                this._dropInfo[n][2] = 327680;
                this._dropInfo[n][3] = 240 - Function.Random(80, true) << 10;
                this._dropInfo[n][5] = 8192 * Function.cos(150) / 1024;
                this._dropInfo[n][7] = -8192 * Function.sin(150) / 1024;
            }
            this._dropInfo[n][12] = this._effectInfo[7];
            ++n;
        }
    }

    private void updateTraceMaxIce() {
        this._dropValidNum += 8;
        if (this._dropValidNum > this._info[5]) {
            this._dropValidNum = this._info[5];
        }
        int n = 0;
        while (n < this._dropValidNum) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[2] = nArray2[2] + this._dropInfo[n][5] * Function.Random(SNOW_FLOWER_INDEX.length, true);
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[3] = nArray3[3] + this._dropInfo[n][7] * Function.Random(SNOW_FLOWER_INDEX.length, true);
                } else {
                    this._dropInfo[n][0] = 0;
                }
            } else if (this._dropInfo[n][1] > 0) {
                this._dropInfo[n][0] = 1;
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceMaxIce(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, SNOW_INDEX[Function.Random(SNOW_INDEX.length, true)], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void paintTraceMMIce(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, SNOW_FLOWER_INDEX[Function.Random(SNOW_FLOWER_INDEX.length, true)], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceSoilNumber() {
        this._soilNumber = 3;
    }

    private void initTraceMaxSoil() {
        boolean bl;
        GameRule gameRule = GameRule.getInstance();
        this._info[5] = 0;
        if (this._user._anim.getId() > 3) {
            bl = true;
            this._info[5] = 3;
        } else {
            bl = false;
            this._info[5] = 3;
        }
        this._dropValidInx = 0;
        this._info[0] = this._effectInfo[7];
        this._info[1] = this._effectInfo[8];
        int n = 0;
        while (n < this._info[5]) {
            this._particleInfo[n][0] = 1;
            this._particleInfo[n][2] = gameRule.getOrderInfoByInx(bl, n, 3)[0] + this._effectInfo[19] << 10;
            this._particleInfo[n][3] = gameRule.getOrderInfoByInx(bl, n, 3)[1] + this._effectInfo[20] << 10;
            this._particleInfo[n][9] = 0;
            this._particleInfo[n][10] = Animation.getAnimation(this._info[0]).getActFrmNum(this._info[1]);
            ++this._dropValidInx;
            ++n;
        }
    }

    private void updateTraceMaxSoil() {
        int[][] nArray = this._particleInfo;
        int n = 0;
        while (n < this._dropValidInx) {
            if (nArray[n][0] == 1) {
                int[] nArray2 = nArray[n];
                nArray2[9] = nArray2[9] + 1;
                if (nArray2[9] >= this._particleInfo[n][10]) {
                    nArray[n][0] = 0;
                    if (this._info[1] == 14) {
                        this.shakeCamera();
                    }
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            if (nArray[0][0] == 0) {
                if (--this._soilNumber <= 0) {
                    this._dropValidInx = -1;
                    this.effectHandle();
                } else {
                    this.initTraceMaxSoil();
                }
            }
        } else if (nArray[0][0] == 0) {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceMaxSoil(Graphics graphics) {
        int n = 0;
        while (n < this._dropValidInx) {
            if (this._particleInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._info[0]);
                int n2 = this._particleInfo[n][2] >> 10;
                int n3 = this._particleInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._info[1], this._particleInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceSoil() {
        this._info[5] = 60;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][2] = 66 + 10 * Function.Random(10, false) << 10;
            this._dropInfo[n][3] = 120 + 10 * Function.Random(5, false) << 10;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            ++n;
        }
    }

    private void updateTraceSoil() {
        int n = 245760 * Function.sin(45) / 1024;
        this._dropInfoValidNum += 3;
        if (this._dropInfoValidNum > this._info[5]) {
            this._dropInfoValidNum = this._info[5];
        }
        int n2 = this._dropValidNum;
        while (n2 < this._dropInfoValidNum) {
            if (this._dropInfo[n2][0] != 1) {
                this._dropInfo[n2][0] = 1;
                this._dropInfo[n2][1] = 5;
                int[] nArray = this._dropInfo[n2];
                nArray[3] = nArray[3] - n;
                this._dropInfo[n2][7] = n / this._dropInfo[n2][1];
                this._dropInfo[n2][9] = 0;
                this._dropInfo[n2][10] = Animation.getAnimation(this._dropInfo[n2][12]).getActFrmNum(this._dropInfo[n2][13]);
            }
            ++n2;
        }
        int n3 = this._dropValidNum;
        while (n3 < this._dropInfoValidNum) {
            if (this._dropInfo[n3][0] == 1) {
                int[] nArray = this._dropInfo[n3];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    int[] nArray2 = this._dropInfo[n3];
                    nArray2[3] = nArray2[3] + this._dropInfo[n3][7];
                    int[] nArray3 = this._dropInfo[n3];
                    nArray3[9] = nArray3[9] + 1;
                    if (this._dropInfo[n3][9] >= this._dropInfo[n3][10]) {
                        this._dropInfo[n3][9] = 0;
                    }
                } else if (this._dropInfo[n3][13] != 4) {
                    this._dropInfo[n3][7] = 0;
                    this._dropInfo[n3][13] = 4;
                    this._dropInfo[n3][9] = 0;
                    this._dropInfo[n3][1] = Animation.getAnimation(this._dropInfo[n3][12]).getActFrmNum(this._dropInfo[n3][13]);
                    this._dropInfo[n3][10] = Animation.getAnimation(this._dropInfo[n3][12]).getActFrmNum(this._dropInfo[n3][13]);
                } else {
                    this._dropInfo[n3][0] = 0;
                    ++this._dropValidNum;
                }
            }
            ++n3;
        }
        if (this._dropValidInx != -1) {
            int n4 = 0;
            while (n4 < this._info[5]) {
                if (this._dropInfo[n4][0] != 0) break;
                ++n4;
            }
            if (n4 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceSoil(Graphics graphics) {
        int n = 0;
        while (n < this._dropInfoValidNum) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], this._info[13]);
            }
            ++n;
        }
    }

    private void initTraceCir() {
        this._info[5] = 36;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 1;
            this._dropInfo[n][11] = n * 10;
            this._dropInfo[n][6] = 30;
            this._dropInfo[n][2] = this._target[0]._x + this._effectInfo[19] + (this._dropInfo[n][6] << 10) * Function.cos(this._dropInfo[n][11]) / 1024;
            this._dropInfo[n][3] = this._target[0]._y + this._effectInfo[20] - (this._dropInfo[n][6] << 10) * Function.sin(this._dropInfo[n][11]) / 1024;
            this._dropInfo[n][1] = 10;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            this._dropInfo[n][9] = 0;
            ++n;
        }
    }

    private void updateTraceCir() {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[11] = nArray2[11] + 6;
                    if (this._dropInfo[n][11] >= 360) {
                        int[] nArray3 = this._dropInfo[n];
                        nArray3[11] = nArray3[11] - 360;
                    }
                    if (this._dropInfo[n][6] == 30) {
                        this._dropInfo[n][8] = 2;
                    }
                    if (this._dropInfo[n][6] == 40) {
                        this._dropInfo[n][8] = -2;
                    }
                    int[] nArray4 = this._dropInfo[n];
                    nArray4[6] = nArray4[6] + this._dropInfo[n][8];
                    this._dropInfo[n][2] = this._target[0]._x + this._effectInfo[19] + (this._dropInfo[n][6] << 10) * Function.cos(this._dropInfo[n][11]) / 1024;
                    this._dropInfo[n][3] = this._target[0]._y + this._effectInfo[20] - (this._dropInfo[n][6] << 10) * Function.sin(this._dropInfo[n][11]) / 1024;
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceCir(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], this._info[13]);
            }
            ++n;
        }
    }

    private void initTraceThrowUpScreen() {
        this._info[5] = 100;
        this._dropInfoValidNum = 0;
        this._dropValidInx = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][2] = 252 + Function.Random(50, false) << 10;
            this._dropInfo[n][3] = 120 + Function.Random(10, false) << 10;
            this._dropInfo[n][7] = 5 + Function.Random(5, true) << 10;
            this._dropInfo[n][1] = (286720 - this._dropInfo[n][3]) / this._dropInfo[n][7];
            this._dropInfo[n][9] = 0;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = LIGHT_POINT[Function.Random(LIGHT_POINT.length, true)];
            ++n;
        }
    }

    private void updateTraceThrowUpScreen() {
        this._dropInfoValidNum += 8;
        if (this._dropInfoValidNum > this._info[5]) {
            this._dropInfoValidNum = this._info[5];
        }
        int n = 0;
        while (n < this._dropInfoValidNum) {
            if (this._dropInfo[n][0] == 1) {
                int[] nArray = this._dropInfo[n];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[3] = nArray2[3] + this._dropInfo[n][7];
                } else {
                    this._dropInfo[n][0] = 0;
                }
            } else if (this._dropInfo[n][1] > 0) {
                this._dropInfo[n][0] = 1;
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._dropInfoValidNum) {
                if (this._dropInfo[n2][0] == 0) break;
                ++n2;
            }
            if (n2 < this._dropInfoValidNum) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceThrowUpScreen(Graphics graphics) {
        int n = 0;
        while (n < this._dropInfoValidNum) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], this._info[13]);
            }
            ++n;
        }
    }

    private void initTraceMoney() {
        this._info[5] = 1;
        this._dropInfoValidNum = 0;
        this._dropValidInx = 0;
        this._info[6] = 240;
        this._info[7] = 200;
        int n = 0;
        while (n < this._info[5]) {
            int n2 = 245760 * Function.cos(150) / 1024;
            int n3 = 245760 * Function.sin(150) / 1024;
            this._dropInfo[n][0] = 1;
            this._dropInfo[n][1] = 6;
            this._dropInfo[n][2] = this._info[6] << 10;
            this._dropInfo[n][3] = this._info[7] << 10;
            this._dropInfo[n][5] = n2 / this._dropInfo[n][1];
            this._dropInfo[n][7] = -n3 / this._dropInfo[n][1];
            this._dropInfo[n][9] = 0;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            ++n;
        }
    }

    private void updateTraceMoney() {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                int[] nArray = this._dropInfo[n];
                nArray[1] = nArray[1] - 1;
                if (nArray[1] > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[2] = nArray2[2] + this._dropInfo[n][5];
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[3] = nArray3[3] + this._dropInfo[n][7];
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._info[5]) {
                if (this._dropInfo[n2][0] != 0) break;
                ++n2;
            }
            if (n2 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceMoney(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceHand() {
        this._info[5] = 20;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            if (this._user._x > 163840) {
                this._dropInfo[n][2] = 84 + Function.Random(4, false) * 20 << 10;
                this._dropInfo[n][3] = 108 + Function.Random(3, false) * 20 << 10;
            } else {
                this._dropInfo[n][2] = 231 + Function.Random(4, false) * 20 << 10;
                this._dropInfo[n][3] = 168 + Function.Random(3, false) * 20 << 10;
            }
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            this._dropInfo[n][10] = Animation.getAnimation(this._dropInfo[n][12]).getActFrmNum(this._dropInfo[n][13]);
            this._dropInfo[n][9] = 0;
            ++n;
        }
    }

    private void updateTraceHand() {
        this._dropValidNum += 3;
        if (this._dropValidNum >= this._info[5]) {
            this._dropValidNum = this._info[5];
        }
        int n = 0;
        while (n < this._dropValidNum) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                nArray[9] = nArray[9] + 1;
                if (nArray[9] >= this._dropInfo[n][10]) {
                    this._dropInfo[n][9] = this._dropInfo[n][10] - 1;
                }
            } else if (this._dropInfo[n][9] < this._dropInfo[n][10]) {
                this._dropInfo[n][0] = 1;
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n2 = 0;
            while (n2 < this._info[5]) {
                if (this._dropInfo[n2][9] < this._dropInfo[n2][10] - 1) break;
                ++n2;
            }
            if (n2 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceHand(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    private void initTraceHead() {
        this.resetEffectState();
        this._info[5] = 9;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][1] = 6;
            this._dropInfo[n][2] = 105 + Function.Random(3, false) * 15 << 10;
            this._dropInfo[n][3] = 96 + Function.Random(3, false) * 15 << 10;
            this._dropInfo[n][7] = -2048;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            this._dropInfo[n][9] = 0;
            ++n;
        }
        this._effectSign[0] = true;
    }

    private void updateTraceHead() {
        int n;
        int n2;
        int n3 = 245760 * Function.cos(150) / 1024;
        int n4 = 245760 * Function.sin(150) / 1024;
        if (this._effectSign[0]) {
            if (++this._dropValidNum >= this._info[5]) {
                this._dropValidNum = this._info[5];
            }
            n2 = 0;
            while (n2 < this._dropValidNum) {
                if (this._dropInfo[n2][0] > 0) {
                    int[] nArray = this._dropInfo[n2];
                    nArray[1] = nArray[1] - 1;
                    if (nArray[1] > 0) {
                        int[] nArray2 = this._dropInfo[n2];
                        nArray2[3] = nArray2[3] + this._dropInfo[n2][7];
                    }
                } else if (this._dropInfo[n2][1] > 0) {
                    this._dropInfo[n2][0] = 1;
                }
                ++n2;
            }
            if (this._dropInfo[this._info[5] - 1][1] <= 0) {
                this._effectSign[0] = false;
                this._effectSign[1] = true;
                n = 0;
                while (n < this._dropValidNum) {
                    this._dropInfo[n][1] = 10;
                    this._dropInfo[n][5] = -n3 / this._dropInfo[n][1];
                    this._dropInfo[n][7] = n4 / this._dropInfo[n][1];
                    ++n;
                }
                this._dropValidNum = 0;
            }
        }
        if (this._effectSign[1]) {
            if (++this._dropValidNum >= this._info[5]) {
                this._dropValidNum = this._info[5];
            }
            n2 = 0;
            while (n2 < this._dropValidNum) {
                if (this._dropInfo[n2][0] > 0) {
                    int[] nArray = this._dropInfo[n2];
                    nArray[1] = nArray[1] - 1;
                    if (nArray[1] <= 0) {
                        this._dropInfo[n2][0] = 0;
                    } else {
                        this._dropInfo[n2][13] = 3;
                        int[] nArray3 = this._dropInfo[n2];
                        nArray3[2] = nArray3[2] + this._dropInfo[n2][5];
                        int[] nArray4 = this._dropInfo[n2];
                        nArray4[3] = nArray4[3] + this._dropInfo[n2][7];
                    }
                }
                ++n2;
            }
            if (this._dropValidInx != -1) {
                n = 0;
                while (n < this._info[5]) {
                    if (this._dropInfo[n][1] > 0) break;
                    ++n;
                }
                if (n >= this._info[5]) {
                    this._dropValidInx = -1;
                    this.effectHandle();
                }
            } else {
                this.finishTraceForParticle();
            }
        }
    }

    private void paintTraceHead(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    public void initTraceWanJian() {
        this._info[5] = 100;
        this._dropValidNum = 0;
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][1] = 10;
            this._dropInfo[n][2] = 320 + Function.Random(20, false) << 10;
            this._dropInfo[n][3] = 240 - Function.Random(120, true) << 10;
            this._dropInfo[n][5] = ((n % 20 == 0 ? 50 : 120) << 10) * Function.cos(150) / 1024;
            this._dropInfo[n][7] = -((n % 20 == 0 ? 50 : 120) << 10) * Function.sin(150) / 1024;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = n % 20 == 0 ? WANJIAN[0] : WANJIAN[1];
            ++n;
        }
    }

    public void updateTraceWanJian() {
        this._dropValidNum += 5;
        if (this._dropValidNum > this._info[5]) {
            this._dropValidNum = this._info[5];
        }
        int n = 0;
        while (n < this._dropValidNum) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[2] = nArray2[2] + this._dropInfo[n][5];
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[3] = nArray3[3] + this._dropInfo[n][7];
                } else {
                    this._dropInfo[n][0] = 0;
                }
            } else if (this._dropInfo[n][1] > 0) {
                this._dropInfo[n][0] = 1;
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    public void paintTraceWanJian(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    public void initTraceMaxMoney() {
        this._info[5] = 100;
        this._dropValidNum = 0;
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][1] = 10;
            this._dropInfo[n][2] = 320 + Function.Random(20, false) << 10;
            this._dropInfo[n][3] = 240 - Function.Random(120, true) << 10;
            this._dropInfo[n][5] = 122880 * Function.cos(150) / 1024;
            this._dropInfo[n][7] = -122880 * Function.sin(150) / 1024;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            ++n;
        }
    }

    public void updateTraceMaxMoney() {
        this._dropValidNum += 5;
        if (this._dropValidNum > this._info[5]) {
            this._dropValidNum = this._info[5];
        }
        int n = 0;
        while (n < this._dropValidNum) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[2] = nArray2[2] + this._dropInfo[n][5];
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[3] = nArray3[3] + this._dropInfo[n][7];
                } else {
                    this._dropInfo[n][0] = 0;
                }
            } else if (this._dropInfo[n][1] > 0) {
                this._dropInfo[n][0] = 1;
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    public void paintTraceMaxMoney(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }

    public void initTraceJiuTian() {
        this.resetEffectState();
        this._info[5] = 9;
        this._dropValidInx = 0;
        this._dropValidNum = 0;
        this._dropInfoValidNum = 0;
        Function.resetRandom();
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][2] = 146 + (n + 1) / 2 * (n % 2 > 0 ? -12 : 12) << 10;
            this._dropInfo[n][3] = 140 + (n + 1) / 2 * (n % 2 > 0 ? 8 : -8) << 10;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            this._dropInfo[n][9] = 0;
            this._dropInfo[n][10] = Animation.getAnimation(this._dropInfo[n][12]).getActFrmNum(this._dropInfo[n][13]);
            ++n;
        }
        this._effectSign[0] = true;
    }

    public void updateTraceJiuTian() {
        int n;
        if (this._effectSign[0]) {
            if (++this._dropInfoValidNum > this._info[5]) {
                this._dropInfoValidNum = this._info[5];
            }
            if (this._dropInfo[this._dropInfoValidNum - 1][0] == 1 && this._dropInfo[this._dropInfoValidNum - 1][1] <= 0) {
                n = 0;
                while (n < this._info[5]) {
                    this._dropInfo[n][2] = 210 + (n + 1) / 2 * (n % 2 > 0 ? -12 : 12) << 10;
                    this._dropInfo[n][3] = -40 + (n + 1) / 2 * (n % 2 > 0 ? 8 : -8) << 10;
                    this._dropInfo[n][7] = 30720;
                    this._dropInfo[n][1] = 8;
                    this._dropInfo[n][13] = 0;
                    ++n;
                }
                this._effectSign[0] = false;
                this._effectSign[1] = true;
                this._dropInfoValidNum = 0;
            }
            n = 0;
            while (n < this._dropInfoValidNum) {
                if (this._dropInfo[n][0] != 1) {
                    this._dropInfo[n][0] = 1;
                    this._dropInfo[n][7] = -30720;
                    this._dropInfo[n][1] = 10;
                } else if (this._dropInfo[n][1] > 0) {
                    int[] nArray = this._dropInfo[n];
                    nArray[1] = nArray[1] - 1;
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[3] = nArray2[3] + this._dropInfo[n][7];
                }
                ++n;
            }
        }
        if (this._effectSign[1]) {
            if (++this._dropInfoValidNum > this._info[5]) {
                this._dropInfoValidNum = this._info[5];
            }
            if (this._dropInfo[this._dropInfoValidNum - 1][13] == 7 && this._dropInfo[this._dropInfoValidNum - 1][9] == this._dropInfo[this._dropInfoValidNum - 1][10] - 1) {
                this._effectSign[1] = false;
                this._effectSign[2] = true;
            }
            n = 0;
            while (n < this._dropInfoValidNum) {
                if (this._dropInfo[n][1] > 0) {
                    int[] nArray = this._dropInfo[n];
                    nArray[1] = nArray[1] - 1;
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[3] = nArray3[3] + this._dropInfo[n][7];
                    int[] nArray4 = this._dropInfo[n];
                    nArray4[9] = nArray4[9] + 1;
                    if (nArray4[9] >= this._dropInfo[n][10]) {
                        this._dropInfo[n][9] = this._dropInfo[n][10] - 1;
                    }
                } else if (this._dropInfo[n][13] != 7) {
                    this._dropInfo[n][13] = 7;
                    this._dropInfo[n][9] = 0;
                    this._dropInfo[n][7] = 0;
                    this._dropInfo[n][1] = Animation.getAnimation(this._dropInfo[n][12]).getActFrmNum(this._dropInfo[n][13]);
                    this._dropInfo[n][10] = Animation.getAnimation(this._dropInfo[n][12]).getActFrmNum(this._dropInfo[n][13]);
                } else {
                    this._dropInfo[n][7] = 0;
                }
                ++n;
            }
        }
        if (this._effectSign[2]) {
            if (this._dropValidInx != -1) {
                this._dropValidInx = -1;
                this.effectHandle();
            } else {
                this.finishTraceForParticle();
            }
        }
    }

    public void paintTraceJiuTian(Graphics graphics) {
        int n = this._info[5];
        while (n >= 0) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], this._info[13]);
            }
            --n;
        }
    }

    private void initTraceXuanYanZhan() {
        this._info[5] = 1;
        int n = 245760 * Function.cos(150) / 1024;
        int n2 = 245760 * Function.sin(150) / 1024;
        int n3 = 0;
        while (n3 < this._info[5]) {
            this._dropInfo[n3][0] = 1;
            this._dropInfo[n3][2] = -26624;
            this._dropInfo[n3][3] = 68608;
            this._dropInfo[n3][1] = 6;
            this._dropInfo[n3][5] = -n / this._dropInfo[n3][1];
            this._dropInfo[n3][7] = n2 / this._dropInfo[n3][1];
            this._dropInfo[n3][12] = this._effectInfo[7];
            this._dropInfo[n3][13] = this._effectInfo[8];
            this._dropInfo[n3][9] = 0;
            ++n3;
        }
    }

    private void updateTraceXuanYanZhan() {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[2] = nArray2[2] + this._dropInfo[n][5];
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[3] = nArray3[3] + this._dropInfo[n][7];
                } else {
                    this._dropInfo[n][0] = 0;
                }
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceXuanYanZhan(Graphics graphics) {
        int n = this._info[5];
        while (n >= 0) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], this._info[13]);
            }
            --n;
        }
    }

    private void initTraceMiFeng() {
        this._info[5] = 100;
        this._dropValidNum = 0;
        int n = 0;
        while (n < this._info[5]) {
            this._dropInfo[n][0] = 0;
            this._dropInfo[n][1] = 10;
            this._dropInfo[n][2] = 320 + Function.Random(20, false) << 10;
            this._dropInfo[n][3] = 120 - Function.Random(80, false) << 10;
            this._dropInfo[n][5] = -40960;
            this._dropInfo[n][12] = this._effectInfo[7];
            this._dropInfo[n][13] = this._effectInfo[8];
            ++n;
        }
    }

    private void updateTraceMiFeng() {
        this._dropValidNum += 5;
        if (this._dropValidNum > this._info[5]) {
            this._dropValidNum = this._info[5];
        }
        int n = 0;
        while (n < this._dropValidNum) {
            if (this._dropInfo[n][0] > 0) {
                int[] nArray = this._dropInfo[n];
                int n2 = nArray[1];
                nArray[1] = n2 - 1;
                if (n2 > 0) {
                    int[] nArray2 = this._dropInfo[n];
                    nArray2[2] = nArray2[2] + this._dropInfo[n][5];
                    int[] nArray3 = this._dropInfo[n];
                    nArray3[3] = nArray3[3] + this._dropInfo[n][7];
                } else {
                    this._dropInfo[n][0] = 0;
                }
            } else if (this._dropInfo[n][1] > 0) {
                this._dropInfo[n][0] = 1;
            }
            ++n;
        }
        if (this._dropValidInx != -1) {
            int n3 = 0;
            while (n3 < this._info[5]) {
                if (this._dropInfo[n3][0] != 0) break;
                ++n3;
            }
            if (n3 >= this._info[5]) {
                this._dropValidInx = -1;
                this.effectHandle();
            }
        } else {
            this.finishTraceForParticle();
        }
    }

    private void paintTraceMiFeng(Graphics graphics) {
        int n = 0;
        while (n < this._info[5]) {
            if (this._dropInfo[n][0] == 1) {
                Animation animation = Animation.getAnimation(this._dropInfo[n][12]);
                int n2 = this._dropInfo[n][2] >> 10;
                int n3 = this._dropInfo[n][3] >> 10;
                animation.draw(graphics, n2, n3, this._dropInfo[n][13], this._dropInfo[n][9], 0);
            }
            ++n;
        }
    }
}

