/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.DataEnemy;
import com.sinaflying.db.GameDB;
import com.sinaflying.engine.MazeBk;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.MazeScene;
import com.sinaflying.util.Function;
import java.util.Hashtable;

public class GameRule {
    private static GameRule _instance;
    private static final int[] C_STRENGTH_TO_HP_RATE;
    private static final int[] C_STRENGTH_TO_ATTACK_RATE;
    private static final int[] C_INTELLIGENCE_TO_SP_RATE;
    private static final int[] C_INTELLIGENCE_TO_SP_ATTACK_RATE;
    private static final int[] C_INTELFORCE_TO_DEFENCE_RATE;
    private static final int[] C_HIT_RATE;
    private static final int[] C_INTELFORCE_TO_BANG_RATE;
    private static final int[] C_INTELFORCE_TO_PARRY_RATE;
    private static final int[] C_INTELFORCE_TO_MISSATTACK_RATE;
    public static final int RATE_ROLE = 0;
    public static final int RATE_ENEMY = 1;
    public static final int RATE_BOSS = 2;
    private static final int C_EFFECTED_HARM_DEFAULT_RATE = 90;
    private static final int C_EFFECTED_HARM_BOSS_RATE = 1;
    public static final int MAX_FIGHTER_NUM_FOR_EACH = 3;
    public static final int MAX_FIGHTER_NUM = 6;
    private static final int C_POSITION_FLAG_RIGHT = 1;
    private static final int C_POSITION_FLAG_MIDDLE = 2;
    private static final int C_POSITION_FLAG_LEFT = 0;
    private static final int C_ORDER_INFO_NUM = 3;
    public static final int C_ORDER_INFO_POS_X = 0;
    public static final int C_ORDER_INFO_POS_Y = 1;
    public static final int C_ORDER_INFO_FALG = 2;
    public static final int C_POSITION_SPACE_Y = 12;
    public static final int C_POSITION_SPACE_X = 21;
    private int[] _orderInfo = new int[3];
    public static final int C_ATTACKED_Y_OFFSET = 25600;
    public static final int C_ATTACKED_X_OFFSET = 25600;
    public static final int C_ESCAPE_X_OFFSET = 10240;
    public static final int C_FORE_X_OFFSET = 40960;
    private int _enemyBattleMemberNum;
    private int[] _enemyIndexInOrder = new int[3];
    public static final int ANIMATION_ACTION_WAIT = 0;
    public static final int ANIMATION_ACTION_HURT = 1;
    public static final int ANIMATION_ACTION_DEATH = 2;
    public static final int ANIMATION_ACTION_EXTRMITY_DEATH = 3;
    public static final int ANIMATION_ACTION_DEFENCE = 4;
    public static final int ANIMATION_ACTION_USE_SKILL = 5;
    public static final int ANIMATION_ACTION_READY = 6;
    public static final int ANIMATION_ACTION_MOVE = 7;
    public static final int ANIMATION_ACTION_ACTIONING = 8;
    public static final int ANIMATION_ACTION_END = 9;
    public static final int ANIMATION_ACTION_MISS = 10;
    public static final int ANIMATION_ACTION_STEAL = 11;
    public static final int[][] ACTION_INX;
    private static int[][] C_HEAD_INDEX;
    private static int[][] C_BODY_INDEX;
    public static Hashtable _mazeScene;
    public static Hashtable _mazeBk;

    public static final GameRule getInstance() {
        if (_instance == null) {
            _instance = new GameRule();
        }
        return _instance;
    }

    private GameRule() {
    }

    public final int getHPBaseStrength(int n, int n2) {
        return n2 * C_STRENGTH_TO_HP_RATE[n];
    }

    public final int getAttackInjureBaseStrength(int n, int n2) {
        return n2 * C_STRENGTH_TO_ATTACK_RATE[n] / 10;
    }

    public final int getSPBaseIntelligence(int n, int n2) {
        return n2 * C_INTELLIGENCE_TO_SP_RATE[n];
    }

    public final int getSPAttackBaseIntelligence(int n, int n2) {
        return C_INTELLIGENCE_TO_SP_ATTACK_RATE[n] * n2 / 100;
    }

    public final int getDefenceBaseIntelforce(int n, int n2) {
        return n2 * C_INTELFORCE_TO_DEFENCE_RATE[n] / 10;
    }

    public final int getHitRate(int n) {
        return C_HIT_RATE[n];
    }

    public final int getMissRate(int n) {
        return 100 - C_HIT_RATE[n];
    }

    public final int getBangRate(int n) {
        return C_INTELFORCE_TO_BANG_RATE[n];
    }

    public final int getParryRate(int n) {
        return C_INTELFORCE_TO_PARRY_RATE[n];
    }

    public final int getMissAttackRate(int n) {
        return C_INTELFORCE_TO_MISSATTACK_RATE[n];
    }

    public final boolean canMiss(int n, boolean bl) {
        return Function.Random(100, true) > n;
    }

    public final boolean canParry(int n, boolean bl) {
        return Function.Random(100, true) < n;
    }

    public final boolean isEffectedHarmStateForDefault() {
        return Function.Random(100, true) < 90;
    }

    public final boolean isEffectedHarmStateForBoss() {
        return Function.Random(100, true) < 1;
    }

    public final boolean isBang(int n, boolean bl) {
        return Function.Random(100, true) < n;
    }

    public final boolean isStealSuccess(int n) {
        return Function.Random(100, true) < n;
    }

    public final boolean canEscape(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (GameRule.isBoss(nArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final boolean isBoss(int n) {
        return n > 65 && n < 73;
    }

    public final int adjustForBang(int n) {
        return n * 150 / 100;
    }

    public final int[] getRoleOrderInfo(int n, int n2) {
        System.arraycopy(this.getOrderInfoByInx(true, n, n2), 0, this._orderInfo, 0, this._orderInfo.length);
        return this._orderInfo;
    }

    public final int[] getOrderInfoByInx(boolean bl, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        n3 = bl ? 252 : 84;
        int n5 = n4 = bl ? 168 : 108;
        int[][] nArray = bl ? (n2 == 3 ? this.getEffectInfo(n3, n4) : this.getRoleInxInfo(n3, n4)) : this.getEnemyInxInfo(n3, n4);
        return nArray[n];
    }

    public int[][] getEnemyInxInfo(int n, int n2) {
        int[][] nArrayArray = new int[][]{{n, n2, 2}, {n + 84, n2 - 12, 1}, {n - 21, n2 + 36, 0}};
        return nArrayArray;
    }

    public int[][] getRoleInxInfo(int n, int n2) {
        int[][] nArrayArray = new int[][]{{n - 21, n2 + 24, 0}, {n + 42, n2, 1}};
        return nArrayArray;
    }

    public int[][] getEffectInfo(int n, int n2) {
        int[][] nArrayArray = new int[][]{{273, 192, 2}, {294, 156, 1}, {231, 204, 0}};
        return nArrayArray;
    }

    public final int[] getEnemyOrderInfo(int n, int n2) {
        System.arraycopy(this.getOrderInfoByInx(false, n, n2), 0, this._orderInfo, 0, this._orderInfo.length);
        return this._orderInfo;
    }

    public final int getEnemyBattleMemberNum() {
        return this._enemyBattleMemberNum;
    }

    public final DataEnemy getEnemyDataByIndexInOrder(int n) {
        int n2 = this._enemyIndexInOrder[n];
        GameDB gameDB = GameDB.getGameDataBase();
        DataEnemy dataEnemy = gameDB.getEnemyData(n2);
        return dataEnemy;
    }

    public final void setEnemyBattleTeam(int[] nArray) {
        int n = nArray.length;
        this._enemyBattleMemberNum = 0;
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != -1) {
                this._enemyIndexInOrder[this._enemyBattleMemberNum++] = nArray[n2];
            }
            ++n2;
        }
    }

    public static final int getInx(int n) {
        if (n > 1) {
            if (GameRule.isBoss(n)) {
                return 5;
            }
            if (GameRule.canUseSkillAction(n)) {
                return 3;
            }
            if (GameRule.canJump(n)) {
                return 4;
            }
            return 2;
        }
        return n;
    }

    public static final boolean canMove(int n) {
        switch (n) {
            case 1: 
            case 66: {
                return false;
            }
        }
        return true;
    }

    public static final boolean canJump(int n) {
        switch (n) {
            case 51: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    public static final boolean canUseSkillAction(int n) {
        switch (n) {
            case 57: {
                return true;
            }
        }
        return false;
    }

    public final int getHeadSptInx(int n) {
        int n2 = C_HEAD_INDEX.length;
        int n3 = 0;
        while (n3 < n2) {
            if (C_HEAD_INDEX[n3][0] == n) {
                return C_HEAD_INDEX[n3][1];
            }
            ++n3;
        }
        return -1;
    }

    public final int getBodySptInx(int n) {
        int n2 = C_BODY_INDEX.length;
        int n3 = 0;
        while (n3 < n2) {
            if (C_BODY_INDEX[n3][0] == n) {
                return C_BODY_INDEX[n3][1];
            }
            ++n3;
        }
        return -1;
    }

    public static final MazeScene getMazeScene(int n) {
        return (MazeScene)_mazeScene.get(new Integer(n));
    }

    public static final Object getMScene(int n) {
        return _mazeScene.get(new Integer(n));
    }

    public static final MazeBk getMazeBk(int n) {
        return (MazeBk)_mazeBk.get(new Integer(n));
    }

    public static Hashtable getMs() {
        return _mazeScene;
    }

    public static void removeMs(int n) {
        _mazeScene.remove(new Integer(n));
    }

    public static void removeMk(int n) {
        _mazeBk.remove(new Integer(n));
    }

    public static Hashtable getMk() {
        return _mazeBk;
    }

    public static boolean produceMazeScene(GameMainLogic gameMainLogic, int n) {
        return MazeScene.produceMazeScene(gameMainLogic, n);
    }

    static {
        C_STRENGTH_TO_HP_RATE = new int[]{12, 8};
        C_STRENGTH_TO_ATTACK_RATE = new int[]{23, 18};
        C_INTELLIGENCE_TO_SP_RATE = new int[]{9, 10};
        C_INTELLIGENCE_TO_SP_ATTACK_RATE = new int[]{120, 150};
        C_INTELFORCE_TO_DEFENCE_RATE = new int[]{25, 20};
        C_HIT_RATE = new int[]{95, 80, 90};
        C_INTELFORCE_TO_BANG_RATE = new int[]{5, 3, 5};
        C_INTELFORCE_TO_PARRY_RATE = new int[]{3, 0, 0};
        C_INTELFORCE_TO_MISSATTACK_RATE = new int[]{2, 0, 0};
        ACTION_INX = new int[][]{{10, 17, 19, 18, 16, 13, 10, 11, 12, 10, 15, 22}, {10, 13, 15, 14, 12, 17, 10, 10, 11, 10, 16, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0}, {1, 1, 0, 1, 1, 3, 1, 1, 2, 1, 1, 1}};
        C_HEAD_INDEX = new int[][]{{1, 150}, {2, 151}, {3, 152}, {4, 153}, {5, 154}, {6, 155}, {7, 156}, {8, 157}, {9, 158}, {10, 159}};
        C_BODY_INDEX = new int[][]{{1, 150}, {2, 151}, {3, 152}, {4, 153}, {5, 154}, {6, 155}, {7, 156}, {8, 157}, {9, 158}, {10, 159}};
        _mazeScene = new Hashtable();
        _mazeBk = new Hashtable();
    }
}

