/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.db.DataSkill;
import com.sinaflying.db.DataThing;
import com.sinaflying.db.GameDB;
import com.sinaflying.engine.Animation;
import com.sinaflying.engine.SptSet;
import com.sinaflying.game.BattleScene;
import com.sinaflying.game.GameParameter;
import com.sinaflying.game.GameRule;
import com.sinaflying.game.NewEffectHandle;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.gameUtil.MessageBox;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

public abstract class Fighter {
    private static final String[] C_FIGHTER_INFO = new String[]{"\u5c01", "\u5b9a", "", "\u66b4"};
    public static final int[] C_FIGHTER_SHOW_INFO = new int[]{33, 34, 35};
    private String _actionShowInfo;
    private int _curSkillIndex;
    private String _curSkillName;
    private boolean _isdrawSkillName = false;
    protected int _state;
    public static final int STATE_AWAIT = 0;
    public static final int STATE_ACTIONING = 2;
    public static final int STATE_ACTION_END = 4;
    public static final int STATE_EFFECTING = 4;
    public static final int STATE_DEATH = 5;
    public static final int STATE_ESCAPE = 6;
    public static final int STATE_DEFENCE = 7;
    public static final int STATE_ACTION_ATTACK = 0;
    public static final int STATE_ACTION_READY = 1;
    public static final int STATE_ACTION_MOVE = 2;
    public static final int STATE_ACTION_WAIT = 3;
    protected static final int MAX_TARGET_GROUP_NUM = 3;
    protected static final int MAX_MEMBER_NUM_FOR_GROUP = 3;
    protected Fighter[][] _target = new Fighter[3][3];
    protected int _targetGroupNum;
    protected int _curTargetGroup;
    protected Fighter[] _tempContainer = new Fighter[6];
    protected int _tempContainerMemberNum;
    public static final int MAX_ACTION_INFO_NUM = 22;
    private static int[] _storeActionInfo = new int[22];
    protected int[] _actionInfo = new int[22];
    public static final int TARGET_KIND_RIVAL_SINGLE = 3;
    public static final int TARGET_KIND_RIVAL_ALL = 4;
    public static final int TARGET_KIND_FRIEND_SINGLE = 1;
    public static final int TARGET_KIND_FRIEND_ALL = 2;
    public static final int ACTION_KIND_ATTACK = 0;
    public static final int ACTION_KIND_SKILL = 1;
    public static final int ACTION_KIND_DEFENCE = 2;
    public static final int ACTION_KIND_THING = 3;
    public static final int ACTION_KIND_ESCAPE = 4;
    public static final int ACTION_KIND_FINISH = 5;
    public static final int ACTION_KIND_STEAL = 6;
    public static final int INFO_POS_ACTION_KIND = 0;
    public static final int INFO_POS_TARGET_KIND = 1;
    public static final int INFO_POS_ACTION_STATE = 2;
    public static final int INFO_POS_ACTION_READY = 3;
    public static final int INFO_POS_ACTION_MOVE = 4;
    public static final int INFO_POS_ACTION_ACTIONING = 5;
    public static final int INFO_POS_ACTION_END = 6;
    public static final int INFO_POS_TARGET_EFFECT = 7;
    public static final int INFO_POS_TARGET_EFFECT_ACTION = 8;
    public static final int INFO_POS_ATTACK_RATE = 9;
    public static final int INFO_POS_PARRY_RATE = 10;
    public static final int INFO_POS_ATTACK_INJURE = 11;
    public static final int INFO_POS_SKILL_INDEX = 12;
    public static final int INFO_POS_SKILL_FIGHTER_INJURE = 13;
    public static final int INFO_POS_SKILL_LEVEL = 14;
    public static final int INFO_POS_SKILL_TRACE = 15;
    public static final int INFO_POS_THING_INDEX = 16;
    public static final int INFO_POS_IS_PRODUCE_BANG = 17;
    public static final int INFO_POS_FIGHTER_POSITION = 18;
    public static final int INFO_POS_EFFECT_X_OFFSET = 19;
    public static final int INFO_POS_EFFECT_Y_OFFSET = 20;
    protected int[] _effectInfo = new int[14];
    protected int _timer;
    public static final int C_KEEP_TIME_FOR_THING = 6;
    public static final int C_KEEP_TIME_FOR_ESCAPE = 6;
    public static final int C_KEEP_TIME_FOR_DEFENCE_HURT = 0;
    public static final int C_KEEP_TIME_FOR_HURT = 4;
    public static final int C_KEEP_TIME_FOR_PARRY = 8;
    public static final int C_HURT_X_SPEED = 2048;
    public boolean _missAttack;
    public Fighter _missTarget;
    public int[] _missAttackInfo = new int[22];
    public final int TRACE_MOVE;
    public final int TRACE_TARGET_TOP;
    public final int TRACE_SCREEN;
    public final int TRACE_MOVE_ANI;
    public final int TRACE_MOVE_ENLARGE;
    public final int TRACE_PLAY_ANI;
    public final int TRACE_MOVE_ROLE;
    private static final int C_MAX_SELF_EFFECT_NUM = 1;
    private static final int C_EFFECT_INFO_SIZE = 3;
    private static final int C_EFFECT_INDEX = 0;
    private static final int C_EFFECT_ACTION_INDEX = 1;
    private static final int C_EFFECT_FRAME = 2;
    private int[][] _selfEffectInfo = new int[1][3];
    private static final int C_NONE_EFFECTED = -1;
    protected Animation _anim;
    public int _type;
    protected int _curFrame;
    protected short _actFrmNum;
    protected int _curAction;
    protected int _action;
    protected int _palNo;
    protected int _changeBodyInx;
    private static final int C_SHOW_ACTION_INFO_SPACE_L = 16;
    private static final int C_SHOW_ACTION_INFO_SPACE_R = 16;
    private static final int C_SHOW_ACTION_INFO_SPACE_T = 10;
    private static final int C_SHOW_ACTION_INFO_SPACE_B = 9;
    private int _validEffectFrame;
    protected int _maxHp;
    protected int _currentHp;
    protected int _maxMp;
    protected int _currentMp;
    protected int _maxSp;
    protected int _currentSp;
    public int _cameraOffset;
    public int _shakeTime;
    public int _shakeRange;
    protected int _interForcse;
    protected int _attackInjure;
    protected int _skillInjure;
    protected int _defence;
    protected int _parryRate;
    protected int _hitRate;
    protected int _missRate;
    protected int _missAttackRate;
    protected int _property;
    protected int _bangRate;
    protected int _order;
    protected int _position;
    public boolean _isSelected;
    private int _indexInOrder;
    public static final int C_STORE_EFFECT_NUM = 14;
    public static final int C_VALID_EFFECT_DEFENCE = 0;
    public static final int C_VALID_EFFECT_FORBIDE_SKILL = 1;
    public static final int C_VALID_EFFECT_FORBIDE_ACTION = 2;
    public static final int C_VALID_EFFECT_INCREACE_DEFENCE = 3;
    public static final int C_VALID_EFFECT_INCREACE_INTERNALFORCE = 4;
    public static final int C_VALID_EFFECT_INCREACE_ATTACKFORCE = 5;
    public static final int C_VALID_EFFECT_DECREACE_DEFENCE = 6;
    public static final int C_VALID_EFFECT_DECREACE_INTERNALFORCE = 7;
    public static final int C_VALID_EFFECT_DECREACE_ATTACKFORCE = 8;
    public static final int C_VALID_EFFECT_RELIFE_ROLE = 9;
    public static final int C_VALID_EFFECT_RESTORE_HMS = 10;
    public static final int C_VALID_EFFECT_DECREACE_HMS = 11;
    public static final int C_VALID_EFFECT_THIEF = 12;
    public static final int C_VALID_EFFECT_RECORD = 13;
    protected int[] _validEffectBoutTime;
    private int[] _validEffectBoutValue;
    private boolean _isDefence;
    public static final int C_SHOW_INFO_TIME = 0;
    public static final int C_SHOW_INFO_KIND = 1;
    public static final int C_SHOW_INFO_KIND_MISS = 0;
    public static final int C_SHOW_INFO_KIND_PARRY = 1;
    public static final int C_SHOW_INFO_KIND_MISSATTACK = 2;
    public static final int C_SHOW_INFO_NUMBER_VALUE = 3;
    public static final int C_SHOW_INFO_KIND_BANG = 4;
    public static final int C_SHOW_INFO_KIND_N_NUMBER = 5;
    public static final int C_SHOW_INFO_KIND_P_NUMBER = 6;
    public static final int C_SHOW_KIND_MP_NUMBER = 7;
    public static final int C_SHOW_KIND_SP_NUMBER = 8;
    public static final int C_SHOW_INFO_MISS_SIZE = 6;
    public static final int C_SHOW_INFO_NUMBER_SIZE = 5;
    public static final int C_SHOW_INFO_KING_HP = 0;
    public static final int C_SHOW_INFO_KING_MP = 1;
    public static final int C_SHOW_INFO_KING_SP = 2;
    public static final int MAX_SHOW_TIME = 5;
    private static final int SHOW_POS_START_VY = -5;
    private static final int SHOW_POS_ACCELERATE = 2;
    private static final int[] SHOW_POSITION_INDEX = new int[5];
    private int _effectShowNumber;
    private static final int MAX_EFFECT_SHOW_INFO_NUM = 6;
    protected int[][] _effectShowInfo = new int[6][];
    protected int _showInfoEmptyPosIndex;
    protected BattleScene _scene;
    protected int _originX;
    protected int _originY;
    protected int _x;
    protected int _y;
    protected int _vx;
    protected int _vy;
    private static final int SELECT_POSITION_Y_OFFSET = -5;
    public static final int POSTION_Y_OFFSET = -20;
    public boolean pilferSucce;
    public int pilferIndex;
    public Animation _weapon;
    public boolean _drawWeapon;
    public int _weaponX;
    public int _weaponY;
    public int _weaponVX;
    public int _weaponVY;
    public int _weaponAction;
    public int _weaponFrame;
    public int _weaponMaxFrame;
    public int _weaponPalNo;
    boolean _isclear;

    protected void finishCommand() {
        this._scene.notifySettingCommandFinish();
    }

    public final int getActionInx(int n) {
        return GameRule.ACTION_INX[GameRule.getInx(this._type)][n];
    }

    protected final void setEscapeInfo() {
        this._actionInfo[0] = 4;
        this._timer = 4;
    }

    protected final void setDefenceInfo() {
        this._state = 4;
        this._actionInfo[0] = 2;
        this.appendValidEffectInfo(0, 0, 1);
    }

    protected final void setAttackInfo() {
        this._actionShowInfo = C_FIGHTER_INFO[0];
        this._actionInfo[0] = 0;
        this._actionInfo[1] = 3;
        this._actionInfo[9] = this.getHitRate();
        this._actionInfo[11] = -this._attackInjure;
        this._actionInfo[18] = this._position;
        int n = this._bangRate;
        this._actionInfo[17] = this.isProduceBangAttack(n) ? 1 : 0;
        this._actionInfo[3] = this.getActionInx(6);
        this._actionInfo[4] = this.getActionInx(7);
        this._actionInfo[5] = this.getActionInx(8);
        this._actionInfo[6] = this.getActionInx(9);
    }

    protected final void setMissAttackInfo() {
        this._missAttackInfo[0] = 0;
        this._missAttackInfo[1] = 3;
        this._missAttackInfo[9] = this.getHitRate();
        this._missAttackInfo[11] = -this._attackInjure;
        this._missAttackInfo[18] = this._position;
        int n = this._bangRate;
        this._missAttackInfo[17] = this.isProduceBangAttack(n) ? 1 : 0;
        this._missAttackInfo[3] = this.getActionInx(6);
        this._missAttackInfo[4] = this.getActionInx(7);
        this._missAttackInfo[5] = this.getActionInx(8);
        this._missAttackInfo[6] = this.getActionInx(9);
        this._missTarget = this._scene._fighter[this._scene._curFighterIndex];
        this._missAttack = true;
    }

    private final int getParryRate() {
        return this._parryRate;
    }

    private final int getHitRate() {
        return this._hitRate;
    }

    public void resetDrawSkillName() {
        this._curSkillName = null;
        this._isdrawSkillName = false;
    }

    public void drawSkillName(Graphics graphics) {
        if (this._curSkillName != null && this._isdrawSkillName) {
            Function.draw3DString(graphics, this._curSkillName, 160, 5, 0x10 | 1, 0, 0xFFFFFF);
        }
    }

    protected final void setUseSkillInfo(int n, int n2) {
        GameDB gameDB = GameDB.getGameDataBase();
        this._curSkillIndex = n;
        DataSkill dataSkill = gameDB.getSkillData(n);
        if (dataSkill == null) {
            System.out.println();
            return;
        }
        int n3 = dataSkill.getTarget();
        this._actionInfo[0] = 1;
        this._actionInfo[1] = n3;
        this._actionInfo[12] = n;
        this._actionInfo[13] = this._skillInjure * dataSkill.getEffectValue() / 100;
        this._actionInfo[14] = this.getCurrentLevel();
        this._curSkillName = dataSkill.getName();
    }

    protected final void setUseThingInfo(int n) {
        GameDB gameDB = GameDB.getGameDataBase();
        DataThing dataThing = gameDB.getThingData(n);
        int n2 = dataThing.getTarget();
        this._actionShowInfo = dataThing.getName();
        this._actionInfo[0] = 3;
        this._actionInfo[1] = n2;
        this._actionInfo[16] = n;
    }

    protected final void crazyHandle() {
        if (this.isValidAcionInfo()) {
            return;
        }
        this.setAttackInfo();
        this.clearTarget();
        this._scene.getRandomFighter(this._tempContainer, this);
        this._curTargetGroup = 0;
        this._target[this._curTargetGroup][0] = this._tempContainer[0];
    }

    private final int getComplexInx() {
        return this._type;
    }

    public final int getBodySptInx() {
        GameRule gameRule = GameRule.getInstance();
        return gameRule.getBodySptInx(this.getComplexInx());
    }

    protected final void resetCurrentTarget() {
        this._curTargetGroup = 0;
    }

    protected final void clearTarget() {
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                this._target[n][n2] = null;
                ++n2;
            }
            ++n;
        }
    }

    public void clearSelected() {
        this._isSelected = false;
    }

    private final void storeTargetForPosition(Fighter fighter) {
        Fighter[][] fighterArray = this._target;
        int n = fighter.getPosition();
        int n2 = 0;
        while (fighterArray[n2][0] != null && fighterArray[n2][0].getPosition() == n) {
            ++n2;
        }
        int n3 = 0;
        while (fighterArray[n2][n3] != null) {
            ++n3;
        }
        fighterArray[n2][n3] = fighter;
    }

    private final void storeFighterForEveryOne(Fighter fighter) {
        Fighter[][] fighterArray = this._target;
        int n = 0;
        while (fighterArray[n][0] != null) {
            ++n;
        }
        fighterArray[n][0] = fighter;
    }

    protected final void groupingByEveryOne() {
        this.clearTarget();
        int n = 0;
        while (n < this._tempContainerMemberNum) {
            this.storeFighterForEveryOne(this._tempContainer[n]);
            ++n;
        }
    }

    protected final void groupingByPosition() {
        this.clearTarget();
        int n = 0;
        while (n < this._tempContainerMemberNum) {
            this.storeTargetForPosition(this._tempContainer[n]);
            ++n;
        }
    }

    protected final void updateTargetGroupInfo() {
        int n = 0;
        int n2 = 0;
        while (n2 < 3) {
            if (this._target[n2][0] == null) break;
            ++n;
            ++n2;
        }
        this._targetGroupNum = n;
    }

    protected final boolean checkValidTargetGroupByRival() {
        boolean bl = false;
        Fighter[] fighterArray = this._target[this._curTargetGroup];
        int n = 0;
        while (n < 3) {
            if (fighterArray[n] == null) break;
            if (fighterArray[n].canEffectByRival()) {
                bl = true;
            } else {
                fighterArray[n] = null;
            }
            ++n;
        }
        return bl;
    }

    protected final boolean checkValidTargetGroupByFriend() {
        boolean bl = false;
        Fighter[] fighterArray = this._target[this._curTargetGroup];
        int n = 0;
        while (n < 3) {
            if (fighterArray[n] == null) break;
            if (fighterArray[n].canEffectByFriend()) {
                bl = true;
            } else {
                fighterArray[n] = null;
            }
            ++n;
        }
        return bl;
    }

    public final void action() {
        switch (this._state) {
            case 2: {
                this.actioningHandle();
                break;
            }
            case 4: {
                this.effectingHandle();
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public final void startUpAction() {
        this.updateActionInfo();
        this.changeToActioning();
    }

    public final boolean isTimeOut() {
        return --this._timer <= 0;
    }

    public boolean isEffectOut() {
        return this._scene.isEffectActorEmpty();
    }

    public final void moveToActionPos() {
        switch (this._actionInfo[0]) {
            case 2: {
                this._x = this.getDefencePosX();
                this._y = this.getDefencePosY();
                break;
            }
            case 4: {
                this._x = this.getEscapePosX();
                this._y = this.getEscapePosY();
            }
        }
    }

    public final void moveToOriginPos() {
        this._x = this._originX;
        this._y = this._originY;
        this._vx = 0;
        this._vy = 0;
    }

    public final void updateActionInfo() {
        switch (this._actionInfo[0]) {
            case 0: {
                this.adjustEffectTarget();
                break;
            }
            case 1: {
                this.adjustEffectTarget();
                break;
            }
            case 3: {
                this.adjustEffectTarget();
                break;
            }
        }
    }

    public final void adjustEffectTarget() {
        switch (this._actionInfo[1]) {
            case 3: {
                this.adjustTargetForRivalSingle();
                break;
            }
            case 1: {
                this.adjustTargetForFriendSingle();
                break;
            }
            case 4: {
                this.adjustTargetForRivalAll();
                break;
            }
            case 2: {
                this.adjustTargetForFriendAll();
            }
        }
    }

    public final void adjustEffectMomentTarget() {
    }

    public final void setEffectInfoForAttack() {
        this._effectInfo[4] = 0;
        this._effectInfo[10] = 0;
    }

    public final void setEffectInfoForSkill() {
        this._effectInfo[4] = 0;
        this._effectInfo[10] = 0;
    }

    public final Fighter getCurrentTarget() {
        Fighter[] fighterArray = this._target[this._curTargetGroup];
        int n = fighterArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (fighterArray[n2] != null) {
                return fighterArray[n2];
            }
            ++n2;
        }
        return null;
    }

    public final void setEffectInfoForThing() {
        this._effectInfo[4] = 0;
        this._effectInfo[10] = 0;
    }

    public final void adjustTargetForFriendAll() {
        this.updateAllFriend();
        this.groupingByPosition();
        this.updateTargetGroupInfo();
        this.randomTargetGroup();
    }

    public final void adjustTargetForRivalAll() {
        this.updateAllRival();
        this.groupingByPosition();
        this.updateTargetGroupInfo();
        this.randomTargetGroup();
    }

    public final void adjustTargetForFriendSingle() {
        if (this.checkValidTargetGroupByFriend()) {
            return;
        }
        this.updateAllFriend();
        this.groupingByEveryOne();
        this.updateTargetGroupInfo();
        this.randomTargetGroup();
    }

    public final void adjustTargetForRivalSingle() {
        if (this.checkValidTargetGroupByRival()) {
            return;
        }
        this.updateAllRival();
        this.groupingByEveryOne();
        this.updateTargetGroupInfo();
        this.randomTargetGroup();
    }

    public final void randomTargetGroup() {
        this._curTargetGroup = Function.Random(this._targetGroupNum, true);
    }

    public void changeToDefence() {
        this.changeAction(this.getActionInx(4));
    }

    public void changeToMiss() {
        this.changeAction(this.getActionInx(10));
    }

    public abstract void changeToActionReady();

    public boolean isBoss() {
        return false;
    }

    public void changeToActionMove() {
        Fighter fighter = this._missAttack ? this._missTarget : this._target[this._curTargetGroup][0];
        this._timer = this._anim.getId() == 0 ? this._anim.getActFrmNum(this.getActionInx(7)) + 3 : 1;
        if (GameRule.canMove(this._type)) {
            this._vx = (fighter.getAttackedPosX() - this.getPosX()) / this._timer;
            this._vy = (fighter.getAttackedPosY() - this.getPosY()) / this._timer;
        }
        this.changeAction(this.getActionInx(7));
        this._actionInfo[2] = 2;
    }

    public void changeToActionEnd() {
        this._actionInfo[2] = 4;
        this._timer = 0;
        this.changeAction(this.getActionInx(9));
    }

    public void changeToUseSkill() {
        this.changeAction(this.getActionInx(5));
        this._timer = this._anim.getActFrmNum(this.getActionInx(5));
    }

    public void changeToUseThing() {
        this.changeAction(this.getActionInx(5));
        this._timer = this._anim.getActFrmNum(this.getActionInx(5));
    }

    protected void changeToActionAttack() {
        this._actionInfo[2] = 0;
        this._timer = this._anim.getActFrmNum(this.getActionInx(8));
        switch (this._type) {
            case 1: {
                if (this._anim.getId() == 1 && Function.getCurScenario() > 50) {
                    this.initWeapon(94, 0, 0);
                    break;
                }
                this.initWeapon(94, 0, 1);
                break;
            }
            case 66: {
                this.initWeapon(66, 4, 0);
            }
        }
        this.initWeaponSpeed((this._target[this._curTargetGroup][0].getAttackedPosX() - this.getPosX()) / this._timer, (this._target[this._curTargetGroup][0].getAttackedPosY() - this.getPosY()) / this._timer);
        int n = this.getActionInx(8);
        this.changeAction(n);
    }

    public boolean isProduceMiss() {
        return false;
    }

    protected void changeToActioning() {
        if (this._anim.getId() == 123) {
            return;
        }
        this._state = 2;
        if (this._missAttack) {
            this.changeToActionReady();
        } else {
            switch (this._actionInfo[0]) {
                case 0: {
                    this.changeToActionReady();
                    return;
                }
                case 1: {
                    if (this.isDarkSkill()) {
                        this._timer = 10;
                        this._actionInfo[2] = 3;
                        break;
                    }
                    this.changeToSkillReady();
                    break;
                }
                case 3: {
                    this.changeToUseThing();
                    break;
                }
                case 4: {
                    this.changeToEscapeMove();
                    break;
                }
                case 2: {
                    this.changeToDefence();
                    break;
                }
            }
        }
    }

    public boolean isDarkSkill() {
        switch (this._actionInfo[12]) {
            case 3: 
            case 4: 
            case 14: 
            case 21: 
            case 27: 
            case 28: 
            case 41: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 80: 
            case 81: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                return true;
            }
        }
        return false;
    }

    public abstract void changeToEscapeMove();

    private final void actioningHandle() {
        if (this.isTimeOut()) {
            this.actionHandle();
            if (!(this.isEscape() || this.isActioning() || this.isDeath())) {
                this.changeToWait();
            }
        }
    }

    private final void actionHandle() {
        if (this._missAttack) {
            this.actionHandleForAttack();
        } else {
            switch (this._actionInfo[0]) {
                case 1: {
                    this.actionHandleForSkill();
                    break;
                }
                case 0: {
                    this.actionHandleForAttack();
                    break;
                }
                case 3: {
                    this._curSkillIndex = this.actionhandleForThing(this._actionInfo[16]);
                    this.actionHandleForEffect();
                    this.changeToWait();
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.actionHandleForEscape();
                }
            }
            if (!(this.isActioning() || this.isDefence() || this.isDeath())) {
                this._actionInfo[0] = 5;
            }
            if (this._scene._escapeFail && this._anim.getId() == 1) {
                this.changeToWait();
            }
        }
    }

    public void changeToSkillReady() {
        int n = this._actionInfo[12];
        if (this.isDarkSkill()) {
            this._scene.openSkillEffect();
        }
        switch (n) {
            case 11: {
                break;
            }
            default: {
                this._timer = 1;
                if (this._anim.getId() < 3) {
                    this._vx = -10240;
                    this._vy = -10240;
                    break;
                }
                this._vx = 10240;
                this._vy = 10240;
            }
        }
        this._actionInfo[2] = 1;
        GameDB gameDB = GameDB.getGameDataBase();
        DataSkill dataSkill = gameDB.getSkillData(n);
        if (this._currentMp >= dataSkill.getExpendMP()) {
            this._currentMp -= dataSkill.getExpendMP();
        }
        if (this._currentSp >= dataSkill.getExpendSP()) {
            this._currentSp -= dataSkill.getExpendSP();
        }
        if (RoleTeamData.getInstance().getMoney() >= dataSkill.getExpendMoney()) {
            RoleTeamData.getInstance().decreaseMoney(dataSkill.getExpendMoney());
        }
    }

    protected void changeToSkillMove() {
        this._vx = 0;
        this._vy = 0;
        this._actionInfo[2] = 2;
        Fighter fighter = this._target[this._curTargetGroup][0];
        int n = this._actionInfo[12];
        switch (n) {
            case 11: {
                this._timer = 5;
                this._vx = (fighter.getAttackedPosX() - this.getPosX()) / this._timer;
                this._vy = (fighter.getAttackedPosY() - this.getPosY()) / this._timer;
                this.changeAction(this.getActionInx(11));
                break;
            }
            default: {
                this.changeAction(this.getActionInx(5));
            }
        }
    }

    protected void changeToSkillAttack() {
        this._actionInfo[2] = 0;
    }

    public boolean isEnemySideEffect() {
        int n = this._actionInfo[1];
        return n == 2 && this._anim.getId() > 3 || n == 4 && this._anim.getId() <= 3;
    }

    public void addFullScreenEffects(boolean bl, int n, int n2) {
        GameRule gameRule = GameRule.getInstance();
        this._scene._isFullEffectOpen = true;
        this._scene._effectY = bl ? gameRule.getEnemyOrderInfo(0, this._scene._bk._bkId)[0] : gameRule.getRoleOrderInfo(0, this._scene._bk._bkId)[0];
        this._scene._effectAni = n;
        this._scene._effectAct = n2;
    }

    protected void changeToSkillEnd() {
        if (this.isDarkSkill()) {
            this._timer = 10;
        }
        this._actionInfo[2] = 4;
        switch (this._actionInfo[15]) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this._scene._isFullEffectOpen = false;
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 7: {
                this._timer = 0;
            }
        }
    }

    protected void actionHandleForSkill() {
        switch (this._actionInfo[2]) {
            case 3: {
                this.changeToSkillReady();
                this._isdrawSkillName = true;
                break;
            }
            case 1: {
                this.changeToSkillMove();
                this._isdrawSkillName = true;
                break;
            }
            case 0: {
                this.actionHandleForEffect();
                this.changeToSkillEnd();
                break;
            }
            case 2: {
                this.changeToSkillAttack();
                break;
            }
        }
    }

    private final void actionHandleForAttack() {
        switch (this._actionInfo[2]) {
            case 1: {
                this.changeToActionMove();
                break;
            }
            case 0: {
                if (this._missAttack) {
                    this._missTarget.effectForAttack(this._missAttackInfo);
                    this.moveToOriginPos();
                } else {
                    this._curSkillIndex = -1;
                    this.actionHandleForEffect();
                }
                this.changeToActionEnd();
                break;
            }
            case 2: {
                this.stopMove();
                this.changeToActionAttack();
                break;
            }
            case 4: {
                if (this._missAttack) {
                    this._missAttack = false;
                }
                this.closeWeapon();
                this.changeToWait();
            }
        }
    }

    protected void stopMove() {
        this._vx = 0;
        this._vy = 0;
    }

    protected final int actionhandleForThing(int n) {
        if (n >= 1 && n <= 16) {
            return 8;
        }
        if (n >= 17 && n <= 20) {
            return 14;
        }
        switch (n) {
            case 21: {
                return 5;
            }
            case 22: {
                return 25;
            }
            case 23: {
                return 19;
            }
            case 24: {
                return 16;
            }
            case 25: {
                return 22;
            }
            case 26: {
                return 6;
            }
            case 27: {
                return 17;
            }
            case 28: {
                return 26;
            }
            case 29: {
                return 23;
            }
            case 30: {
                return 20;
            }
            case 31: {
                return 99;
            }
            case 34: {
                return 15;
            }
            case 35: {
                return 9;
            }
            case 38: {
                return 10;
            }
            case 44: 
            case 45: 
            case 46: {
                return 8;
            }
        }
        return -1;
    }

    protected final void actionHandleForEffect() {
        if (this._curSkillIndex < 0) {
            this._effectInfo[4] = 0;
            this._effectInfo[10] = 0;
        }
        this._actionInfo[15] = 0;
        this._effectInfo[10] = 0;
        switch (this._curSkillIndex) {
            case 11: {
                RoleTeamData roleTeamData = RoleTeamData.getInstance();
                GameDB gameDB = GameDB.getGameDataBase();
                StringBuffer stringBuffer = Function.getInfoBuffer();
                int n = this._target[this._curTargetGroup][0].getPilferThing();
                BattleScene._messageBox = MessageBox.getInstance(this._scene);
                if (n > 0) {
                    stringBuffer.append(GameParameter.C_BATTLE_INFO[2]);
                    if (n > 0 && n < 48) {
                        roleTeamData.increaseThing(n);
                        stringBuffer.append(gameDB.getThingData(n).getName());
                    } else if (n > 49 && n < 70) {
                        roleTeamData.increaseMaterial(n);
                        stringBuffer.append(gameDB.getMaterialData(n).getName());
                    } else if (n > 69 && n < 104) {
                        roleTeamData.increaseComposeScroll(n);
                        stringBuffer.append(gameDB.getDataComposeScroll(n).getName());
                    }
                    BattleScene._messageBox.initSingleScrollStyle(stringBuffer.toString(), 10);
                } else {
                    stringBuffer.append(GameParameter.C_BATTLE_INFO[10]);
                    BattleScene._messageBox.initSingleScrollStyle(stringBuffer.toString(), 10);
                }
                this._effectInfo[4] = 0;
                break;
            }
            case 1: {
                this._actionInfo[7] = 107;
                this._actionInfo[8] = 12;
                this._actionInfo[19] = 76;
                this._actionInfo[20] = -90;
                this._effectInfo[4] = 1;
                break;
            }
            case 2: 
            case 66: {
                this._effectInfo[4] = 101;
                break;
            }
            case 3: 
            case 67: {
                this._actionInfo[7] = 107;
                this._actionInfo[8] = 3;
                this._effectInfo[4] = 102;
                break;
            }
            case 4: 
            case 68: {
                this._effectInfo[4] = 103;
                break;
            }
            case 5: 
            case 42: {
                this._actionInfo[7] = 101;
                this._actionInfo[8] = 3;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -100;
                this._effectInfo[4] = 1;
                break;
            }
            case 6: 
            case 43: {
                this._actionInfo[7] = 101;
                this._actionInfo[8] = 3;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -100;
                this._effectInfo[4] = 3;
                break;
            }
            case 7: 
            case 44: {
                this._actionInfo[7] = 101;
                this._actionInfo[8] = 3;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -100;
                this._effectInfo[4] = 4;
                break;
            }
            case 16: 
            case 30: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 1;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = 0;
                this._effectInfo[4] = 1;
                break;
            }
            case 17: 
            case 31: 
            case 73: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 1;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = 0;
                this._effectInfo[4] = 3;
                break;
            }
            case 18: 
            case 32: 
            case 74: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 1;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = 0;
                this._effectInfo[4] = 4;
                break;
            }
            case 19: 
            case 33: {
                this._actionInfo[7] = 101;
                this._actionInfo[8] = 0;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -70;
                this._effectInfo[4] = 1;
                break;
            }
            case 20: 
            case 34: 
            case 75: {
                this._actionInfo[7] = 101;
                this._actionInfo[8] = 0;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -70;
                this._effectInfo[4] = 3;
                break;
            }
            case 21: 
            case 35: 
            case 65: 
            case 76: {
                this._actionInfo[7] = 101;
                this._actionInfo[8] = 0;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -70;
                this._effectInfo[4] = 4;
                break;
            }
            case 25: 
            case 39: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 34;
                this._effectInfo[4] = 117;
                break;
            }
            case 26: 
            case 40: 
            case 79: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 34;
                this._effectInfo[4] = 118;
                break;
            }
            case 27: 
            case 41: 
            case 80: {
                this._actionInfo[7] = 105;
                this._effectInfo[4] = 119;
                break;
            }
            case 22: 
            case 36: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 14;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -100;
                this._effectInfo[4] = 1;
                break;
            }
            case 23: 
            case 37: 
            case 77: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 14;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -100;
                this._effectInfo[4] = 3;
                break;
            }
            case 24: 
            case 38: 
            case 78: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 14;
                this._actionInfo[19] = 0;
                this._actionInfo[20] = -100;
                this._effectInfo[4] = 127;
                break;
            }
            case 8: 
            case 12: 
            case 69: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 35;
                this._effectInfo[4] = 104;
                this._effectInfo[13] = 0;
                break;
            }
            case 13: 
            case 70: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 35;
                this._effectInfo[4] = 104;
                this._effectInfo[13] = 2;
                break;
            }
            case 14: 
            case 71: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 35;
                this._effectInfo[4] = 113;
                this._effectInfo[13] = 2;
                break;
            }
            case 28: 
            case 81: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 43;
                this._effectInfo[4] = 114;
                break;
            }
            case 29: 
            case 82: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 42;
                this._effectInfo[4] = 114;
                break;
            }
            case 9: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 34;
                this._actionInfo[19] = 5120;
                this._actionInfo[20] = -25600;
                this._effectInfo[4] = 5;
                this._effectInfo[13] = 1;
                break;
            }
            case 10: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 34;
                this._actionInfo[19] = 5120;
                this._actionInfo[20] = -25600;
                this._effectInfo[4] = 5;
                this._effectInfo[13] = 0;
                break;
            }
            case 15: 
            case 72: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 34;
                this._actionInfo[19] = 5120;
                this._actionInfo[20] = -25600;
                this._effectInfo[4] = 5;
                this._effectInfo[13] = 2;
                break;
            }
            case 47: {
                this._actionInfo[7] = 107;
                this._effectInfo[4] = 121;
                break;
            }
            case 48: {
                this._actionInfo[7] = 90;
                this._actionInfo[8] = 0;
                this._effectInfo[4] = 105;
                this._effectInfo[13] = 1;
                break;
            }
            case 49: {
                this._actionInfo[7] = 92;
                this._actionInfo[8] = 6;
                this._effectInfo[4] = 106;
                break;
            }
            case 50: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 42;
                this._effectInfo[4] = 122;
                break;
            }
            case 51: {
                this._actionInfo[7] = 90;
                this._actionInfo[8] = 0;
                this._effectInfo[4] = 105;
                this._effectInfo[13] = 0;
                break;
            }
            case 52: 
            case 85: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 6;
                this._effectInfo[4] = 112;
                break;
            }
            case 53: 
            case 64: 
            case 86: {
                this._actionInfo[7] = 101;
                this._actionInfo[8] = 7;
                this._effectInfo[4] = 108;
                break;
            }
            case 54: 
            case 87: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 1;
                this._effectInfo[4] = 109;
                break;
            }
            case 55: 
            case 88: {
                this._actionInfo[7] = 105;
                this._effectInfo[4] = 120;
                break;
            }
            case 56: 
            case 62: 
            case 89: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 0;
                this._effectInfo[4] = 110;
                break;
            }
            case 60: 
            case 83: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 40;
                this._effectInfo[4] = 115;
                break;
            }
            case 61: 
            case 84: {
                this._actionInfo[7] = 102;
                this._actionInfo[8] = 2;
                this._effectInfo[4] = 116;
                break;
            }
            case 57: {
                this._actionInfo[7] = 92;
                this._actionInfo[8] = 4;
                this._effectInfo[4] = 123;
                this._effectInfo[13] = 1;
                break;
            }
            case 63: {
                this._actionInfo[7] = 92;
                this._actionInfo[8] = 4;
                this._effectInfo[4] = 123;
                this._effectInfo[13] = 0;
                break;
            }
            case 58: {
                this._actionInfo[7] = 92;
                this._actionInfo[8] = 8;
                this._effectInfo[4] = 124;
                this._effectInfo[13] = 1;
                break;
            }
            case 59: {
                this._actionInfo[7] = 66;
                this._actionInfo[8] = 7;
                this._effectInfo[4] = 124;
                break;
            }
            case 99: {
                this._actionInfo[7] = 105;
                this._actionInfo[8] = 0;
                this._effectInfo[4] = 126;
                break;
            }
            default: {
                this._effectInfo[4] = 0;
            }
        }
        NewEffectHandle newEffectHandle = this._scene.getEffectHandle();
        System.arraycopy(this._actionInfo, 0, _storeActionInfo, 0, this._actionInfo.length);
        newEffectHandle.init(this._effectInfo, _storeActionInfo, this, this._target[this._curTargetGroup]);
    }

    private final void actionHandleForEscape() {
        if (this.isEscapeSucess()) {
            this.changeToEscape();
            this.escapeHandle();
        } else {
            this.escapeFailHandle();
        }
    }

    protected void resetSpeed() {
        this._vx = 0;
        this._vy = 0;
    }

    public abstract boolean isEscapeSucess();

    private final void actionHandleForDefence() {
    }

    private final void changeToEscape() {
        this._state = 6;
    }

    private final void changeToParry() {
        this._state = 4;
        this._timer = 8;
        this.changeAction(this.getActionInx(4));
    }

    protected void changeToWait() {
        this._state = 0;
        if (this.isDefence()) {
            this.changeAction(this.getActionInx(4));
            return;
        }
        if (this.isExtremityDeath()) {
            this.changeAction(this.getActionInx(3));
            return;
        }
        this.changeAction(this.getActionInx(0));
    }

    protected abstract boolean isExtremityDeath();

    private final void effectingHandle() {
        if (this.isTimeOut()) {
            if (this._missAttack) {
                this.startUpAction();
                int[] nArray = new int[6];
                nArray[1] = 2;
                this.appendEffectShowInfo(nArray);
            } else {
                this.changeToWait();
                this.moveToOriginPos();
            }
        }
    }

    public final int getActionPrior() {
        return this._interForcse;
    }

    public final boolean isFinishAction() {
        if (!this.isExist()) {
            return true;
        }
        if (this.isDefence()) {
            return true;
        }
        return this.isAwait();
    }

    private final boolean isAwait() {
        return this._state == 0;
    }

    private final void clearSelfEffectInfo() {
        int n = 0;
        while (n < 1) {
            this._selfEffectInfo[n][0] = -1;
            ++n;
        }
    }

    public final void effect(int[] nArray) {
        int n = nArray[0];
        switch (n) {
            case 0: {
                this.effectForAttack(nArray);
                break;
            }
            case 1: {
                this.effectForSkill(nArray);
                break;
            }
            case 3: {
                this.effectForThing(nArray);
            }
        }
    }

    private final void changeActionByEffect(int n) {
        if (n >= 0) {
            this.changeToWait();
            return;
        }
        if (this._currentHp <= 0) {
            if (this._anim.getId() < 3) {
                this.changeToDeath();
            } else {
                this._timer = 4;
                this._vx = -2048;
            }
        } else {
            this.changeToHurt();
        }
    }

    private final void effectForAttack(int[] nArray) {
        int n = nArray[9];
        int n2 = this.getParryRate();
        int n3 = nArray[11];
        GameRule gameRule = GameRule.getInstance();
        if (nArray[17] == 0) {
            if (gameRule.canMiss(n, false)) {
                this.produceMissInfo();
                return;
            }
            if (this.canParry(n2)) {
                this.produceParryInfo();
                return;
            }
        } else {
            nArray[17] = 0;
            n3 = gameRule.adjustForBang(n3);
        }
        n3 += this._defence;
        n3 = Math.min(0, n3);
        if (this.isDefence()) {
            this.addjustForDefence(false, n3);
            return;
        }
        if (n3 < 0) {
            this.judgeAddSp();
        }
        this.produceNumberInfo(0, 0, n3);
        this.changeHP(n3);
        this.changeActionByEffect(n3);
    }

    public void judgeAddSp() {
        this._scene._fighter[this._scene._curFighterIndex].changeSP(10);
        this.changeSP(5);
    }

    public void addjustForDefence(boolean bl, int n) {
        if ((n /= 2) < 0) {
            this.judgeAddSp();
        }
        this.changeHP(n);
        this.ChangeToHurtForDefence();
        this.produceNumberInfo(0, 0, n);
        this.changeActionByEffect(n);
    }

    public void ChangeToHurtForDefence() {
        this._state = 4;
        this._timer = 0;
    }

    public abstract void setEffect();

    private final boolean isProduceBangAttack(int n) {
        GameRule gameRule = GameRule.getInstance();
        return gameRule.isBang(n, false);
    }

    public void produceMissInfo() {
        this._state = 4;
        this._timer = 0;
        int[] nArray = new int[6];
        nArray[1] = 0;
        this.appendEffectShowInfo(nArray);
    }

    private final void produceParryInfo() {
        this.changeToParry();
        int[] nArray = new int[6];
        nArray[1] = 1;
        this.appendEffectShowInfo(nArray);
    }

    private final void produceNumberInfo(int n, int n2, int n3) {
        int[] nArray = new int[5];
        nArray[0] = n2;
        nArray[3] = n3;
        switch (n) {
            case 0: {
                nArray[1] = n3 <= 0 ? 5 : 6;
                break;
            }
            case 1: {
                nArray[1] = 7;
                break;
            }
            case 2: {
                nArray[1] = 8;
            }
        }
        this.appendEffectShowInfo(nArray);
    }

    public final void produceBangNumberInfo(int n, int n2) {
        int[] nArray = new int[5];
        nArray[1] = 4;
        nArray[0] = 0;
        nArray[3] = n2;
        this.appendEffectShowInfo(nArray);
    }

    private final void effectForSkill(int[] nArray) {
        GameDB gameDB = GameDB.getGameDataBase();
        int n = nArray[12];
        DataSkill dataSkill = gameDB.getSkillData(n);
        int n2 = dataSkill.getEffectKind();
        int n3 = dataSkill.getEffectValue() + nArray[13];
        if (this.isDeath()) {
            return;
        }
        if (this.hasValidEffectState(n2)) {
            this.appendValidEffectInfo(n2, dataSkill.getEffectValue(), dataSkill.getEffectBout());
            return;
        }
        if (this.hasNegativeEffectState(n2)) {
            this.appendNegativeEffectInfo(n2, dataSkill.getHitRate(), dataSkill.getEffectValue(), dataSkill.getEffectBout());
            return;
        }
        if (this.isRestoreHMS(n2)) {
            this.effectHandleForHP(n2, 100, n3);
            return;
        }
        if (this.isDecreaceHMS(n2)) {
            n3 = this.getPropertyInjureRate(dataSkill.getProperty(), this.getFighterProperty(), n3);
            int n4 = -n3;
            this.produceNumberInfo(0, 0, n4);
            this.changeHP(n4);
            this.changeActionByEffect(n4);
        }
    }

    public boolean isRestoreHMS(int n) {
        switch (n) {
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isDecreaceHMS(int n) {
        switch (n) {
            case 11: {
                return true;
            }
        }
        return false;
    }

    public boolean hasValidEffectState(int n) {
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean hasNegativeEffectState(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean hasRelifeEffsetState(int n) {
        switch (n) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void effectHandleForHP(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 <= 10) {
            n3 = this._maxHp * n3 / 10;
        }
        switch (n) {
            case 9: 
            case 10: {
                if (this._currentHp + n3 > this._maxHp) {
                    n3 = this._maxHp - this._currentHp;
                }
                this.changeHP(n3);
                this.produceNumberInfo(0, 0, n3);
                this.changeToWait();
                break;
            }
            case 11: {
                if (Function.Random(100, true) > n2) {
                    return;
                }
                this.changeHP(n3);
                this.produceNumberInfo(0, 0, n3);
            }
        }
    }

    public void effectHandleForMP(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 <= 10) {
            n2 = this._maxMp * n2 / 10;
        }
        switch (n) {
            case 10: {
                if (this._currentMp + n2 > this._maxMp) {
                    n2 = this._maxMp - this._currentMp;
                }
                this.changeMP(n2);
                this.produceNumberInfo(1, 0, n2);
            }
        }
    }

    public void effectHandleForSP(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n2 <= 10) {
            n2 = this._maxSp * n2 / 10;
        }
        switch (n) {
            case 10: {
                if (this._currentSp + n2 > this._maxSp) {
                    n2 = this._maxSp - this._currentSp;
                }
                this.changeSP(n2);
                this.produceNumberInfo(2, 0, n2);
            }
        }
    }

    private final boolean isRestrain(int n, int n2) {
        int n3 = n - n2;
        return n3 == 1 || n3 == -1;
    }

    private final int getPropertyInjureRate(int n, int n2, int n3) {
        int n4;
        if (n == 0 || n2 == 0) {
            return n3;
        }
        int n5 = n - n2;
        switch (n5) {
            case -1: 
            case 4: {
                n4 = 15;
                break;
            }
            case 0: {
                n4 = 0;
                break;
            }
            default: {
                n4 = 10;
            }
        }
        return n3 * n4 / 10;
    }

    private final void reLifeHandle() {
        this.clearValidEffect();
        this.resetData();
        this.changeToWait();
    }

    private final void effectForThing(int[] nArray) {
        GameDB gameDB = GameDB.getGameDataBase();
        int n = nArray[16];
        DataThing dataThing = gameDB.getThingData(n);
        int n2 = dataThing.getUsageEffect();
        int n3 = dataThing.getInjure();
        int n4 = dataThing.getEffectHP();
        int n5 = dataThing.getEffectMP();
        int n6 = dataThing.getEffectSP();
        if (this.hasRelifeEffsetState(n2)) {
            if (!this.isDeath()) {
                return;
            }
            this.effectHandleForHP(n2, 100, n4);
            this.effectHandleForMP(n2, n5);
            this.effectHandleForSP(n2, n6);
            this.reLifeHandle();
            return;
        }
        if (this.isDeath()) {
            return;
        }
        if (this.hasValidEffectState(n2)) {
            this.appendValidEffectInfo(n2, n3, dataThing.getAffectBout());
            return;
        }
        if (this.hasNegativeEffectState(n2)) {
            this.appendNegativeEffectInfo(n2, dataThing.getHitRate(), n3, dataThing.getAffectBout());
            return;
        }
        if (this.isRestoreHMS(n2)) {
            this.effectHandleForHP(n2, 100, n4);
            this.effectHandleForMP(n2, n5);
            this.effectHandleForSP(n2, n6);
            this.changeActionByEffect(n4);
            return;
        }
        if (this.isDecreaceHMS(n2)) {
            n4 = this.getPropertyInjureRate(dataThing.getProperty(), this.getFighterProperty(), n3);
            int n7 = -n4;
            this.produceNumberInfo(0, 0, n7);
            this.changeHP(n7);
            this.changeActionByEffect(n7);
        }
    }

    private final void changeValidEffectInfo(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] > 0 && this.isEffectedHarmState()) {
                this.appendValidEffectInfo(n3, n2, nArray[n3]);
            } else if (nArray[n3] < 0) {
                this.clearValidEffectInfo(n3);
            }
            ++n3;
        }
    }

    public void changeStateToDeath() {
        this.changeToDeath();
    }

    private final void changeToDeath() {
        this._state = 5;
        this._currentHp = 0;
        this._currentSp = 0;
        this.changeAction(this.getActionInx(2));
        this.deathHandle();
    }

    private final void changeToDeathEffect() {
        this._anim = Animation.getAnimation(123);
        this.changeAction(0);
    }

    public abstract void changeToHurt();

    protected final boolean isHurt() {
        return this._state == 4;
    }

    public final boolean isEscape() {
        return this._state == 6;
    }

    public final boolean isDeath() {
        return this._state == 5;
    }

    public final boolean isExist() {
        return !this.isDeath() && !this.isEscape();
    }

    public final boolean canAction() {
        return this.isExist() && !this.isRooted() && this.isValidAcionInfo();
    }

    public boolean canUseSkill() {
        return this._validEffectBoutTime[1] <= 0;
    }

    protected final boolean isValidAcionInfo() {
        return this._actionInfo[0] != 5;
    }

    public final boolean isRooted() {
        return this._validEffectBoutTime[2] > 0;
    }

    public final boolean isMingState() {
        return this._validEffectBoutTime[5] > 0;
    }

    public boolean isIncreaseDefence() {
        return this._validEffectBoutTime[3] > 0;
    }

    public final boolean isDefence() {
        return this._validEffectBoutTime[0] > 0;
    }

    abstract boolean isBangAttacked();

    public final boolean canCommand() {
        return this.isExist() && !this.isRooted();
    }

    public final boolean canBoutFinishHandle() {
        return this.isExist();
    }

    public final boolean canEffectByRival() {
        return this.isExist() && this._anim.getId() != 123;
    }

    protected final void changeAnimation(int n) {
        if (this._anim == null) {
            return;
        }
        this._curAction = n;
        this._curFrame = 0;
        this._actFrmNum = this._anim.getActFrmNum(n &= 0xFFFF);
        this._action = n;
    }

    public final void nextFrame() {
        this._x += this._vx;
        this._y += this._vy;
        ++this._curFrame;
        if (this.isActionEnd()) {
            this._curFrame = 0;
        }
    }

    public final boolean isActionEnd() {
        return this._curFrame >= this._actFrmNum;
    }

    public final void step() {
        this.nextFrame();
    }

    public void draw(Graphics graphics, int n) {
        int n2 = (this._x >> 10) + n;
        int n3 = (this._y >> 10) + n;
        if (this.isDeath()) {
            this.drawForDeath(graphics, n2, n3);
        } else {
            this.drawForNormal(graphics, n2, n3);
        }
        this.drawWeapon(graphics);
        this.drawEffectShowInfo(graphics);
    }

    public boolean isFinishShake() {
        return this._shakeTime <= 0;
    }

    protected abstract void drawForDeath(Graphics var1, int var2, int var3);

    private final void drawForNormal(Graphics graphics, int n, int n2) {
        if (this._anim == null) {
            return;
        }
        if (this._anim.getId() == 1 && Function.getCurScenario() > 50) {
            this._anim.draw(graphics, n, n2, this._curAction, this._curFrame, 1);
        } else if (this._anim.getId() == 123) {
            if (this._state != 5 && this._state != 2) {
                this._anim.draw(graphics, n, n2, this._curAction, this._curFrame, 0);
            }
            if (this._curFrame == this._anim.getActFrmNum(0) - 1) {
                this.changeToDeath();
            }
        } else {
            this._anim.draw(graphics, n, n2, this._curAction, this._curFrame, this._palNo);
        }
        this.drawValidEffectInfo(graphics);
    }

    public final int getPaintPrior() {
        return this.getPosY();
    }

    public final void drawActionInfo(Graphics graphics) {
        if (this.isActioning()) {
            // empty if block
        }
    }

    public final boolean isActioning() {
        return this._state == 2;
    }

    private final void drawActionKindInfo(Graphics graphics) {
        if (this._actionShowInfo == null) {
            return;
        }
        int n = graphics.getFont().stringWidth(this._actionShowInfo);
        int n2 = Function.C_WORD_H;
        int n3 = n + 16 + 16;
        int n4 = n2 + 10 + 9;
        int n5 = 320 - n3 >> 1;
        int n6 = 0;
        graphics.setColor(0xFDFDFD);
        Function.drawString(graphics, this._actionShowInfo, n5 + 16, n6 + 10, 4 | 0x10);
    }

    private final void drawValidEffectInfo(Graphics graphics) {
        this.drawSkillName(graphics);
    }

    private final int getValidEffectNum() {
        int n = 0;
        int[] nArray = this._validEffectBoutTime;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (nArray[n3] > 0) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public final int getMaxHp() {
        return this._maxHp;
    }

    protected void changeHP(int n) {
        this._currentHp = n >= 0 ? (this._currentHp += n) : (this._currentHp += n + n * Function.Random(11, false) / 100);
        this._currentHp = Math.max(0, this._currentHp);
        this._currentHp = Math.min(this._maxHp, this._currentHp);
    }

    public final int getCurrentHP() {
        return this._currentHp;
    }

    public final int getCurrentMP() {
        return this._currentMp;
    }

    public final int getMaxMP() {
        return this._maxMp;
    }

    private void changeMP(int n) {
        this._currentMp += n;
        this._currentMp = Math.max(0, this._currentMp);
        this._currentMp = Math.min(this._maxMp, this._currentMp);
    }

    public final int getCurrentSP() {
        return this._currentSp;
    }

    public final int getMaxSP() {
        return this._maxSp;
    }

    private void changeSP(int n) {
        this._currentSp += n;
        this._currentSp = Math.max(0, this._currentSp);
        this._currentSp = Math.min(this._maxSp, this._currentSp);
    }

    public int getCameraOffset() {
        return this._cameraOffset;
    }

    public void startUpShake(int n, int n2) {
        this._shakeTime = n;
        this._shakeRange = n2;
    }

    public void updateShake() {
        if (this._shakeTime >= 0) {
            this._cameraOffset = (--this._shakeTime & 1) == 0 ? this._shakeRange : -this._shakeRange;
        } else {
            this._cameraOffset = 0;
            this._shakeRange = 0;
        }
    }

    public final void clearShake() {
        this._shakeTime = 0;
        this._cameraOffset = 0;
    }

    protected final int getPosition() {
        return this._position;
    }

    public final void setIndexInOrder(int n) {
        this._indexInOrder = n;
    }

    protected final void initData(int[] nArray) {
        this._originX = nArray[0] << 10;
        this._originY = nArray[1] << 10;
        this._x = this._originX;
        this._y = this._originY;
        this._position = nArray[2];
        this._state = 0;
        this.changeAction(this.getActionInx(0));
        this.resetValidEffectInfo();
        this.resetEffectShowInfo();
        this._actionInfo[0] = 5;
        this.clearSelfEffectInfo();
        this.resetPilferIndex();
    }

    protected final void resetData() {
        this._state = 0;
        this.changeAction(this.getActionInx(0));
        this.resetValidEffectInfo();
        this.resetEffectShowInfo();
        this._actionInfo[0] = 5;
        this.clearSelfEffectInfo();
        this.resetPilferIndex();
    }

    private final void clearValidEffect() {
        int n = 0;
        while (n < 14) {
            this._validEffectBoutTime[n] = 0;
            ++n;
        }
    }

    private final void appendValidEffectInfo(int n, int n2, int n3) {
        switch (n) {
            case 4: {
                this._interForcse = this._interForcse * (n2 + 10) / 10;
                break;
            }
            case 3: {
                this._defence = this._defence * (n2 + 10) / 10;
                break;
            }
            case 5: {
                this._attackInjure = this._attackInjure * (n2 + 10) / 10;
                break;
            }
            case 0: {
                break;
            }
            default: {
                return;
            }
        }
        this._validEffectBoutTime[n] = n3;
    }

    private final void appendNegativeEffectInfo(int n, int n2, int n3, int n4) {
        if (Function.Random(100, true) > n2) {
            return;
        }
        switch (n) {
            case 6: {
                this._interForcse = this._interForcse * (10 - n3) / 10;
                break;
            }
            case 7: {
                this._defence = this._defence * (10 - n3) / 10;
                break;
            }
            case 8: {
                this._attackInjure = this._attackInjure * (10 - n3) / 10;
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        this._validEffectBoutTime[n] = n4;
    }

    public void effectHandleForHP(int n) {
        this._currentHp += n;
        this._currentHp = Math.max(this._currentHp, this._maxHp);
    }

    private final void clearDefenceHandle() {
        this.changeToWait();
    }

    private final void clearValidEffectInfo(int n) {
        switch (n) {
            case 0: {
                this.clearDefenceHandle();
            }
        }
        this._validEffectBoutTime[n] = 0;
    }

    private final void resetValidEffectInfo() {
        int n = 0;
        while (n < 14) {
            this._validEffectBoutTime[n] = 0;
            ++n;
        }
    }

    public final void boutFinishHandle() {
        this.updateValidEffectInfo();
    }

    private final void updateValidEffectInfo() {
        int n = 0;
        while (n < 14) {
            if (this._validEffectBoutTime[n] > 0) {
                this.validEffectHandle(n);
            }
            ++n;
        }
        this.decrementEffectBoutTime();
    }

    private final void decrementEffectBoutTime() {
        int n = 0;
        while (n < 14) {
            if (this._validEffectBoutTime[n] > 0) {
                int n2 = n;
                this._validEffectBoutTime[n2] = this._validEffectBoutTime[n2] - 1;
                if (this._validEffectBoutTime[n2] == 0) {
                    this.finishEffectBoutHandle(n);
                }
            }
            ++n;
        }
    }

    protected abstract void finishEffectBoutHandle(int var1);

    public final int getDefence() {
        boolean bl = this._isDefence;
        this._isDefence = false;
        return bl ? 30 : 100;
    }

    private final void validEffectHandle(int n) {
    }

    private static final void calculateShowPositionIndex() {
        int n = 0;
        int n2 = -5;
        int n3 = 0;
        while (n3 < 5) {
            Fighter.SHOW_POSITION_INDEX[n3] = n += n2;
            ++n3;
        }
    }

    protected final void appendEffectShowInfo(int[] nArray) {
        this._effectShowInfo[this._showInfoEmptyPosIndex] = nArray;
        if (++this._showInfoEmptyPosIndex >= 6) {
            this._showInfoEmptyPosIndex = 0;
        }
    }

    protected final void resetEffectShowNumber() {
        this._effectShowNumber = 0;
    }

    private final void resetEffectShowInfo() {
        int n = 0;
        while (n < 6) {
            this._effectShowInfo[n] = null;
            ++n;
        }
        this._showInfoEmptyPosIndex = 0;
    }

    public final boolean checkEffectShowInfo() {
        int n = 0;
        while (n < 6) {
            if (this._effectShowInfo[n] != null) break;
            ++n;
        }
        return n >= 6;
    }

    private final void drawEffectShowInfo(Graphics graphics) {
        this.resetEffectShowNumber();
        int n = this._showInfoEmptyPosIndex;
        do {
            this.drawEffectInfoHandle(graphics, n);
            if (++n < 6) continue;
            n = 0;
        } while (n != this._showInfoEmptyPosIndex);
    }

    private final void drawEffectInfoHandle(Graphics graphics, int n) {
        int[][] nArray = this._effectShowInfo;
        if (nArray[n] == null) {
            return;
        }
        if (nArray[n][0] < 0) {
            int[] nArray2 = nArray[n];
            nArray2[0] = nArray2[0] + 1;
            return;
        }
        this.drawInfo(graphics, nArray[n]);
        ++this._effectShowNumber;
        int[] nArray3 = nArray[n];
        nArray3[0] = nArray3[0] + 1;
        if (nArray3[0] >= 5) {
            if (nArray[n] != null && this._currentHp <= 0) {
                if (this._anim.getId() > 3) {
                    this.changeToDeathEffect();
                }
                this.deathHandle();
            }
            nArray[n] = null;
        }
    }

    private final void drawInfo(Graphics graphics, int[] nArray) {
        int n = this.getEffectShowInfoPosX(nArray[3]);
        int n2 = this.getEffectShowInfoPosY(nArray[0]) - this._effectShowNumber * 14;
        switch (nArray[1]) {
            case 4: 
            case 5: {
                Function.paintStateNumber(graphics, n, n2, nArray[3], 0, 1);
                break;
            }
            case 6: {
                Function.paintStateNumber(graphics, n, n2, nArray[3], 0, 2);
                break;
            }
            case 7: {
                Function.paintStateNumber(graphics, n, n2, nArray[3], 0, 0);
                break;
            }
            case 8: {
                Function.paintStateNumber(graphics, n, n2, nArray[3], 10, 0);
                break;
            }
            case 0: {
                Function.paintStateString(graphics, n, n2, 0);
                break;
            }
            case 1: {
                Function.paintStateString(graphics, n, n2, 1);
                break;
            }
        }
    }

    private final int getEffectShowInfoPosX(int n) {
        int n2 = 0;
        n = n > 0 ? n : -n;
        while (n > 0) {
            n /= Function.UNIT_NUMBER;
            ++n2;
        }
        return (this._x >> 10) + Function.BATTLE_NUMBER_W * n2 / 2;
    }

    private final int getEffectShowInfoPosY(int n) {
        return this.getSelPostionY() + SHOW_POSITION_INDEX[n];
    }

    public final int getBlowupValue(int n) {
        if (n >= 5 - 2) {
            return n;
        }
        return n << 1;
    }

    protected abstract void paintState(Graphics var1, int var2, int var3);

    protected void paintState(Graphics graphics, int n, int n2, int n3) {
        SptSet sptSet = SptSet.load(125, 1);
        sptSet.draw(graphics, n2, n3, n, 0x20 | 2);
    }

    public final int getSelPostionX() {
        return this._x >> 10;
    }

    public final int getSelPostionY() {
        switch (this._type) {
            case 0: {
                return (this._y >> 10) + this._anim.getVisibleTop() / 3 * 2 + -20;
            }
            case 67: {
                return (this._y >> 10) + this._anim.getVisibleTop() + 20;
            }
        }
        return (this._y >> 10) + this._anim.getVisibleTop() + 5;
    }

    public final int getPosX() {
        return this._x;
    }

    public final int getPosY() {
        return this._y;
    }

    public Fighter(BattleScene battleScene) {
        this.TRACE_MOVE = 1;
        this.TRACE_TARGET_TOP = 2;
        this.TRACE_SCREEN = 3;
        this.TRACE_MOVE_ANI = 4;
        this.TRACE_MOVE_ENLARGE = 5;
        this.TRACE_PLAY_ANI = 6;
        this.TRACE_MOVE_ROLE = 7;
        this._scene = battleScene;
        this._validEffectBoutTime = new int[14];
        this._validEffectBoutValue = new int[14];
    }

    protected abstract int getAttackedPosX();

    protected abstract int getAttackedPosY();

    protected abstract int getBackPosX();

    protected abstract int getBackPosY();

    protected abstract int getEscapePosX();

    protected abstract int getEscapePosY();

    protected abstract int getDefencePosY();

    protected abstract int getDefencePosX();

    protected abstract int getForePosX();

    protected abstract int getForePosY();

    protected abstract int getUseSkillPosX();

    protected abstract int getUseSkillPosY();

    protected abstract int getEffectBySkillPosX();

    protected abstract int getEffectBySkillPosY();

    protected abstract boolean isEffectedHarmState();

    protected abstract void updateAllFriend();

    protected abstract void updateAllRival();

    protected abstract void escapeHandle();

    public void escapeFailHandle() {
        this.moveToOriginPos();
        this._scene.changeToEscapeFail();
        this.finishCommand();
        this.changeToWait();
        this._scene._escapeFail = true;
    }

    protected abstract String getFighterName();

    public void changeAction(int n) {
        this.changeAnimation(n);
    }

    protected abstract void deathHandle();

    protected abstract void command();

    protected abstract void startUpCommand();

    protected abstract void drawCommandInfo(Graphics var1);

    protected abstract void drawVictoryInfo(Graphics var1);

    protected abstract boolean canDraw();

    protected abstract boolean canEffectByFriend();

    protected abstract int getFighterProperty();

    protected abstract int getExperience();

    protected abstract int getMoney();

    protected abstract int[] getThing();

    protected abstract int getPilferThing();

    protected abstract boolean canObtainExperience();

    abstract boolean canParry(int var1);

    protected abstract String[][] battleFinishHandler(int var1);

    protected abstract void clearState();

    protected abstract boolean isDrawBK();

    protected abstract int getCurrentLevel();

    private void resetPilferIndex() {
        this.pilferIndex = 0;
        this.pilferSucce = false;
    }

    public void initWeapon(int n, int n2, int n3) {
        this._weapon = Animation.getAnimation(n);
        this._weaponAction = n2;
        this._weaponFrame = 0;
        this._weaponMaxFrame = this._weapon.getActFrmNum(this._weaponAction);
        this._drawWeapon = false;
        this._weaponPalNo = n3;
        this.openWeapon();
    }

    public void initWeaponSpeed(int n, int n2) {
        this._weaponVX = n;
        this._weaponVY = n2;
    }

    public void openWeapon() {
        this._weaponX = this._x;
        this._weaponY = this._y - 20480;
        this._drawWeapon = true;
    }

    public void closeWeapon() {
        this._weaponX = this._x;
        this._weaponY = this._y;
        this._weaponVX = 0;
        this._weaponVY = 0;
        this._drawWeapon = false;
    }

    public void weaponStop() {
        this._weaponX += this._weaponVX;
        this._weaponY += this._weaponVY;
        ++this._weaponFrame;
        if (this._weaponFrame >= this._weaponMaxFrame) {
            this._weaponFrame = 0;
        }
    }

    public void drawWeapon(Graphics graphics) {
        if (this._drawWeapon) {
            this.weaponStop();
            this._weapon.draw(graphics, this._weaponX >> 10, this._weaponY >> 10, this._weaponAction, this._weaponFrame, this._weaponPalNo);
        }
    }

    protected abstract boolean isClear();

    static {
        Fighter.calculateShowPositionIndex();
    }
}

