/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.game.BattleScene;
import com.sinaflying.game.EnemyFighter;
import com.sinaflying.game.Fighter;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.RoleFighter;
import com.sinaflying.util.Function;
import javax.microedition.lcdui.Graphics;

class BattlePanel {
    private RoleFighter[] _role = new RoleFighter[3];
    private EnemyFighter[] _enemy = new EnemyFighter[3];
    private RoleFighter _curRole;
    private Fighter _fighter;
    private int _roleNum;
    private int _enemyNum;
    private int[][] _showInfo = new int[3][2];
    private static final int C_SHOW_INFO_HP = 0;
    private static final int C_SHOW_INFO_MP = 1;
    private int _headStartX;
    private int _headY;
    private int _space;
    private int _pipeHpY;
    private int _hpNumberY;
    private int _pipeMpY;
    private int _mpNumberY;
    private int _pipeStartX;
    private int _pipeW;
    private int _frameX;
    private int _frameH;
    private int _frameY;
    private int _levelNumStartX;
    private int _levelNumStartY;
    private int _levelStartY;
    public boolean[] _curTargetIndex = new boolean[3];
    private static final int C_SHOW_CHANGE_INTERVAL = 99;
    public static final int C_COMMAND_FLAG_INTERVAL = 3;
    public static final int C_COMMAND_FLAG_OFFSET = 2;
    private static final int[] C_DISABLE_NUMBER_PANEL_RULE = new int[]{39, 40};
    private static final int[][] C_DISABLE_NUMBER_PANEL = new int[][]{{80, 170}, {160, 170}};
    private static final int[][] C_DISABLE_NUMBER_POSITION = new int[][]{{77, 34}, {72, 43}, {66, 53}};
    private static final int[][] C_DISABLE_VALUE_POSITION = new int[][]{{42, 39}, {38, 48}, {34, 58}};
    private static final int INDEX_PANEL_SPT_ID_OFFSET = -4;
    GameMainLogic _mainLogic;
    private static BattlePanel _instance;
    BattleScene _scene;
    private static final int[] INDEX_PANEL_SPT_ID;
    private static final int[][] INDEX_PANEL_POSITION;

    public final void draw(Graphics graphics) {
        this.updateShowInfo();
        int n = this._headStartX;
        int n2 = this._pipeStartX;
        int n3 = this._frameX;
        int n4 = 0;
        while (n4 < this._roleNum) {
            this.drawRoleInfo(graphics, n4, n3, n2);
            n3 += this._space;
            n2 += this._space;
            ++n4;
        }
        int n5 = 0;
        while (n5 < INDEX_PANEL_SPT_ID.length) {
            if (this._curRole != null) {
                if (this._curRole.chooseInx() == n5) {
                    Function.PANEL.draw(graphics, INDEX_PANEL_POSITION[n5][0], INDEX_PANEL_POSITION[n5][1], INDEX_PANEL_SPT_ID[n5] + -4);
                } else {
                    Function.PANEL.draw(graphics, INDEX_PANEL_POSITION[n5][0], INDEX_PANEL_POSITION[n5][1], INDEX_PANEL_SPT_ID[n5]);
                }
            }
            ++n5;
        }
        boolean bl = true;
        int n6 = 0;
        while (n6 < this._enemyNum) {
            if (this._enemy[n6].isBoss()) {
                bl = false;
                break;
            }
            ++n6;
        }
        if (!bl) {
            return;
        }
        int n7 = 0;
        while (n7 < this._enemyNum) {
            this.drawEnemyInfo(graphics, n7);
            ++n7;
        }
    }

    private final void updateShowInfo() {
        int n = 0;
        while (n < this._roleNum) {
            RoleFighter roleFighter = this._role[n];
            int n2 = roleFighter.getCurrentHP();
            if (this._showInfo[n][0] < n2) {
                int[] nArray = this._showInfo[n];
                nArray[0] = nArray[0] + 99;
                this._showInfo[n][0] = Math.min(this._showInfo[n][0], n2);
            } else if (n2 < this._showInfo[n][0]) {
                int[] nArray = this._showInfo[n];
                nArray[0] = nArray[0] - 99;
                this._showInfo[n][0] = Math.max(this._showInfo[n][0], n2);
            }
            int n3 = roleFighter.getCurrentMP();
            if (this._showInfo[n][1] < n3) {
                int[] nArray = this._showInfo[n];
                nArray[1] = nArray[1] + 99;
                this._showInfo[n][1] = Math.min(this._showInfo[n][1], n3);
            } else if (n3 < this._showInfo[n][1]) {
                int[] nArray = this._showInfo[n];
                nArray[1] = nArray[1] - 99;
                this._showInfo[n][1] = Math.max(this._showInfo[n][1], n3);
            }
            ++n;
        }
        if (this._scene._curFighterIndex >= 0 && this._scene._fighter[this._scene._curFighterIndex] != null) {
            this._fighter = this._scene._fighter[this._scene._curFighterIndex];
            if (this._fighter._anim.getId() == 0 || this._fighter._anim.getId() == 1) {
                this._curRole = (RoleFighter)this._fighter;
            }
        }
    }

    private final void drawRoleInfo(Graphics graphics, int n, int n2, int n3) {
        Function.PANEL.draw(graphics, C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_NUMBER_PANEL[n][1], C_DISABLE_NUMBER_PANEL_RULE[n]);
        Function.PANEL.draw(graphics, C_DISABLE_NUMBER_PANEL[n][0] + Function.PANEL.getSptWidth(C_DISABLE_NUMBER_PANEL_RULE[n]), C_DISABLE_NUMBER_PANEL[n][1] + 17, 38);
        if (n == 1 && Function.getCurScenario() > 50) {
            Function.PANEL.draw(graphics, C_DISABLE_NUMBER_PANEL[n][0] + 7, C_DISABLE_NUMBER_PANEL[n][1] + 21, 46);
        }
        Function.paintNumber(graphics, C_DISABLE_NUMBER_POSITION[0][0] + C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_NUMBER_POSITION[0][1] + C_DISABLE_NUMBER_PANEL[n][1], this._role[n].getCurrentHP(), this._role[n].getMaxHp());
        Function.paintNumber(graphics, C_DISABLE_NUMBER_POSITION[1][0] + C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_NUMBER_POSITION[1][1] + C_DISABLE_NUMBER_PANEL[n][1], this._role[n].getCurrentMP(), this._role[n].getMaxMP());
        Function.paintNumber(graphics, C_DISABLE_NUMBER_POSITION[2][0] + C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_NUMBER_POSITION[2][1] + C_DISABLE_NUMBER_PANEL[n][1], this._role[n].getCurrentSP(), this._role[n].getMaxSP());
        graphics.setClip(0, 0, 320, 240);
        Function.paintColorLine(graphics, C_DISABLE_VALUE_POSITION[0][0] + C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_VALUE_POSITION[0][1] + C_DISABLE_NUMBER_PANEL[n][1], this._role[n].getCurrentHP(), this._role[n].getMaxHp(), 1);
        Function.paintColorLine(graphics, C_DISABLE_VALUE_POSITION[1][0] + C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_VALUE_POSITION[1][1] + C_DISABLE_NUMBER_PANEL[n][1], this._role[n].getCurrentMP(), this._role[n].getMaxMP(), 2);
        Function.paintColorLine(graphics, C_DISABLE_VALUE_POSITION[2][0] + C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_VALUE_POSITION[2][1] + C_DISABLE_NUMBER_PANEL[n][1], this._role[n].getCurrentSP(), this._role[n].getMaxSP(), 3);
        this._role[n].paintState(graphics, C_DISABLE_NUMBER_PANEL[n][0], C_DISABLE_NUMBER_PANEL[n][1]);
    }

    private final void calculatePosition() {
        int n = 0;
        while (n < 3) {
            this._curTargetIndex[n] = false;
            ++n;
        }
        this._mainLogic = GameMainLogic.getInstance();
    }

    public void drawEnemyInfo(Graphics graphics, int n) {
    }

    public final void addRole(RoleFighter roleFighter) {
        this._showInfo[this._roleNum][0] = roleFighter.getCurrentHP();
        this._showInfo[this._roleNum][1] = roleFighter.getCurrentMP();
        this._role[this._roleNum++] = roleFighter;
    }

    public final void addEnemy(EnemyFighter enemyFighter) {
        this._enemy[this._enemyNum++] = enemyFighter;
    }

    public final void dispose() {
        int n = this._role.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._role[n2] != null) {
                this._role[n2].dispose();
            }
            ++n2;
        }
        n = this._enemy.length;
        int n3 = 0;
        while (n3 < n) {
            if (this._enemy[n3] != null) {
                this._enemy[n3].dispose();
            }
            ++n3;
        }
        this._roleNum = 0;
        this._enemyNum = 0;
    }

    public final void disposeNum() {
        this._roleNum = 0;
        this._enemyNum = 0;
    }

    public static final BattlePanel getInstance() {
        if (_instance == null) {
            _instance = new BattlePanel();
        }
        return _instance;
    }

    private BattlePanel() {
        this.calculatePosition();
        this._role = new RoleFighter[3];
        this._enemy = new EnemyFighter[3];
        this._scene = BattleScene.getBattleInstance();
    }

    public static void getCurTargetIndex() {
    }

    private final void paintForPanelStyle(Graphics graphics) {
    }

    static {
        INDEX_PANEL_SPT_ID = new int[]{21, 19, 20, 22};
        INDEX_PANEL_POSITION = new int[][]{{25, 160}, {0, 180}, {25, 200}, {50, 180}};
    }
}

