/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.engine;

import com.sinaflying.game.Actor;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.util.Function;
import com.sinaflying.util.StreamReader;
import java.io.InputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TiledBackground {
    public int _cw;
    public int _ch;
    public static int _mapx;
    public static int _mapy;
    private byte[][] _axPhys;
    private byte[][] _forePhys;
    public int _phytw;
    public int _phyth;
    public int _bkw;
    public int _bkh;
    public int _bktw;
    public int _bkth;
    private Image _bkTileSet;
    private Image _bkShareTileSet;
    public int _bkTileCntInX;
    private byte[] _bkTile;
    public int _fbkw;
    public int _fbkh;
    private int _fbktw;
    private int _fbkth;
    private byte[] _fbkTile;
    public static int IMAGE_MAX_NUMBER;
    public short[][] _bkTiles;
    public short[] _imageComId;
    public static int _imageIndex;
    public static Hashtable _image;
    public int[] _imageId = new int[IMAGE_MAX_NUMBER];
    Image paintPic;
    public int _synTicks;
    public int _mapW;
    public int _mapH;
    public int _curMapLayers;
    private int _phyMapLayer;
    private boolean _needFlipMap;
    private boolean _repeatMap;
    int _xoff;
    int _yoff;
    int _ratio;
    int _layers;
    public static final int C_PHY_EMPTY = 0;
    public static final int C_PHY_SOLID = 1;
    public static final int C_PHY_BORDER = 30;
    public static final int C_PHY_SOLID_COLOR = 65280;
    public static final int C_SHELTER_PHY_2 = 2;
    public static final int C_SHELTER_PHY_3 = 3;
    public static final int C_SHELTER_PHY_4 = 4;
    public static final int C_SHELTER_PHY_5 = 5;
    public static final int C_SHELTER_PHY_6 = 6;
    public static final int C_SHELTER_PHY_STAIR = 7;
    public static final int C_PHY_STAIR = 8;
    public static final int C_PHY_HALF_BOTTOM = 9;
    public static final int C_PHY_HALF_TOP = 10;
    public static final int C_PHY_HALF_RIGHT = 11;
    public static final int C_PHY_HALF_LEFT = 12;
    private static int _prevMapX0;
    private static int _prevMapY0;
    private static int _prevMapX1;
    private static int _prevMapY1;
    private static Image _backImg;
    private static Graphics _gb;
    public static final byte C_EMPTY_LINE = 0;
    public static final byte C_NORMAL_LINE = 1;
    public static final byte C_RLE_LINE = 2;
    public int _bkId;
    public static final int PAL_INDEX_HAIDI = 0;
    public static final int PAL_INDEX_SHANDONG = 1;
    Hashtable _actorIdBk;
    Hashtable _actorInBK;

    public TiledBackground(int n, int n2) {
        this._cw = n;
        this._ch = n2;
        this.initActorInBk();
        this._needFlipMap = true;
        if (_image == null) {
            _image = new Hashtable();
        }
    }

    public void setPositionInMap(int n, int n2) {
        _mapx = n;
        _mapy = n2;
        this.countTicks();
    }

    public void init() {
        _prevMapX0 = -1;
        _prevMapY0 = -1;
    }

    public int getMapWidth() {
        return this._mapW;
    }

    public int getMapHeight() {
        return this._mapH;
    }

    public void drawToGraphics(Graphics graphics) {
        this.fastDraw(graphics, _mapx, _mapy, this._cw, this._ch);
    }

    public void drawToGraphics(Graphics graphics, int n) {
        this.fastDraw(graphics, _mapx + n, _mapy + n, this._cw, this._ch);
    }

    public int getPhyBlock(int n, int n2) {
        if (this._axPhys == null) {
            return 0;
        }
        if (n < 0 || n2 < 0 || n >= this.getMapWidth() || n2 >= this.getMapHeight()) {
            return 30;
        }
        n /= this._phytw;
        byte[][] byArray = this._axPhys;
        if ((n2 /= this._phyth) >= byArray.length) {
            return 0;
        }
        if (byArray[n2][0] == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 2;
        do {
            n3 += byArray[n2][n4 + 1];
            if (byArray[n2][n4 + 1] < 0) {
                n3 += 256;
            }
            n4 += 2;
        } while (n3 < n + 1);
        return byArray[n2][n4 -= 2];
    }

    private final int getPhyByTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this._bkw || n2 >= this._bkh) {
            return 30;
        }
        byte[][] byArray = this._axPhys;
        if (byArray[n2][0] == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 2;
        do {
            n3 += byArray[n2][n4 + 1];
            if (byArray[n2][n4 + 1] < 0) {
                n3 += 256;
            }
            n4 += 2;
        } while (n3 < n + 1);
        return byArray[n2][n4 -= 2];
    }

    public final boolean isPass(int n, int n2) {
        return this.getPhyByTile(n, n2) == 0 || this.getPhyByTile(n, n2) == 2 || this.getPhyByTile(n, n2) == 4 || this.getPhyByTile(n, n2) == 6 || this.getPhyByTile(n, n2) == -1;
    }

    protected int getForeTile(int n, int n2) {
        int n3 = this._fbkTile[n2 / this._fbkth * this._fbkw + n / this._fbktw];
        if (n3 < -1) {
            n3 += 256;
        }
        return n3;
    }

    protected int getBKTile(int n, int n2) {
        int n3 = this._bkTile[n2 / this._bkth * this._bkw + n / this._bktw];
        if (n3 < -1) {
            n3 += 256;
        }
        return n3;
    }

    protected int getMapTile(int n, int n2, int n3) {
        int n4 = this._bkTiles[n][n3 / this._bkth * this._bkw + n2 / this._bktw];
        if (n4 < -1) {
            n4 += 256;
        }
        if (n4 < -1) {
            n4 -= 256;
        }
        return n4;
    }

    private void setFastMode(int n, int n2) {
        if (_backImg == null) {
            int n3 = n % this._bktw == 0 ? n + this._bktw : n - n % this._bktw + (this._bktw << 1);
            int n4 = n2 % this._bkth == 0 ? this._ch + this._bkth : n2 - n2 % this._bkth + (this._bkth << 1);
            _backImg = Image.createImage((int)n3, (int)n4);
            _gb = _backImg.getGraphics();
        }
        this.init();
    }

    protected void mappedDraw(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = this._bktw;
        int n9 = this._bkth;
        int n10 = n2 % n6;
        int n11 = this._bkTileCntInX;
        int n12 = n2;
        while (n12 <= n4) {
            int n13 = n % n5;
            int n14 = n12 % this._mapH;
            int n15 = n;
            while (n15 <= n3) {
                int n16 = n15 % this._mapW;
                graphics.setClip(n13, n10, n8, n9);
                int n17 = 0;
                while (n17 < this._curMapLayers) {
                    if (n17 == 0) {
                        Function.fillScreen(graphics, n13, n10, n8, n9, 0);
                    }
                    if ((n7 = this.getMapTile(n17, n16, n14)) != -1) {
                        int n18 = 0;
                        n18 = this.getImageIndex(n7 >> 12);
                        this.paintPic = (Image)_image.get(new Integer(n18));
                        int n19 = n7 & 0xFFF;
                        if (n19 != 0) {
                            // empty if block
                        }
                        int n20 = n7 & 0xFF;
                        if (this.paintPic == null) {
                            System.out.println("\u7f3a\u5c11PNG\uff1a" + (n7 >> 12));
                        } else {
                            n11 = this.paintPic.getWidth() / n8;
                        }
                        this.drawImageFlip(graphics, this.paintPic, n20 % n11 * n8, n20 / n11 * n9, n8, n9, n13, n10, n19);
                    }
                    ++n17;
                }
                this.drawActorInBk(graphics, n16 / n8 + n14 / n9 * this._bkw, n13, n10, n8, n9);
                if ((n13 += n8) >= n5) {
                    n13 = 0;
                }
                n15 += n8;
            }
            if ((n10 += n9) >= n6) {
                n10 = 0;
            }
            n12 += n9;
        }
    }

    public void drawPhyInfo(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 1: {
                graphics.setClip(n, n2, n3, n4);
                graphics.setColor(65280);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }
    }

    public void drawImageFlip(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        if ((n7 & 0x100) != 0) {
            n8 = 2;
        }
        if ((n7 & 0x200) != 0) {
            n8 = 1;
        }
        if ((n7 & 0x100) != 0 && (n7 & 0x200) != 0) {
            n8 = 3;
        }
        if (image == null) {
            System.out.println("\u7a7a");
        } else if (n + n3 <= image.getWidth() && n2 + n4 <= image.getHeight()) {
            graphics.drawRegion(image, n, n2, n3, n4, n8, n5, n6, 4 | 0x10);
        }
    }

    public int getImageIndex(int n) {
        if ((n &= 0xF) >= 0 && n < this._imageComId.length) {
            return this._imageComId[n];
        }
        return -1;
    }

    private final void copyFromBackImage(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setClip(n5, n6, n3, n4);
        graphics.drawImage(_backImg, n5 - n, n6 - n2, 4 | 0x10);
    }

    protected void fastDraw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = _backImg.getWidth();
        int n6 = _backImg.getHeight();
        _gb.setClip(0, 0, _backImg.getWidth(), _backImg.getHeight());
        _gb.setColor(0xFFFFFF);
        int n7 = n - n % this._bktw;
        int n8 = n2 - n2 % this._bkth;
        int n9 = n + n5 - this._bktw - (n + n5 - this._bktw) % this._bktw;
        int n10 = n2 + n6 - this._bkth - (n2 + n6 - this._bkth) % this._bkth;
        if (_prevMapX0 < 0) {
            this.mappedDraw(_gb, n7, n8, n9, n10, n5, n6);
            _prevMapX0 = n7;
            _prevMapY0 = n8;
            _prevMapX1 = n9;
            _prevMapY1 = n10;
        } else {
            int n11;
            int n12;
            if (_prevMapX0 != n7) {
                if (_prevMapX0 < n7) {
                    n12 = _prevMapX1 + this._bktw;
                    n11 = n9;
                } else {
                    n12 = n7;
                    n11 = _prevMapX0 - this._bktw;
                }
                this.mappedDraw(_gb, n12, n8, n11, n10, n5, n6);
            }
            if (_prevMapY0 != n8) {
                if (_prevMapY0 < n8) {
                    n12 = _prevMapY1 + this._bkth;
                    n11 = n10;
                    int n13 = _prevMapY0;
                    int n14 = n8 - this._bkth;
                } else {
                    n12 = n8;
                    n11 = _prevMapY0 - this._bkth;
                    int n15 = n10 + this._bkth;
                    int n16 = _prevMapY1;
                }
                if (_prevMapX0 < n7) {
                    this.mappedDraw(_gb, n7, n12, _prevMapX1, n11, n5, n6);
                } else if (_prevMapX0 > n7) {
                    this.mappedDraw(_gb, _prevMapX0, n12, n9, n11, n5, n6);
                } else {
                    this.mappedDraw(_gb, n7, n12, n9, n11, n5, n6);
                }
                _prevMapY0 = n8;
                _prevMapY1 = n10;
            }
            _prevMapX0 = n7;
            _prevMapX1 = n9;
        }
        _gb.setClip(0, 0, _backImg.getWidth(), _backImg.getHeight());
        int n17 = n % n5;
        int n18 = n2 % n6;
        int n19 = (n + n3) % n5;
        int n20 = (n2 + n4) % n6;
        if (n19 > n17) {
            if (n20 > n18) {
                this.copyFromBackImage(graphics, n17, n18, n3, n4, 0, 0);
            } else {
                this.copyFromBackImage(graphics, n17, n18, n3, n4 - n20, 0, 0);
                this.copyFromBackImage(graphics, n17, 0, n3, n20, 0, n4 - n20);
            }
        } else if (n20 > n18) {
            this.copyFromBackImage(graphics, n17, n18, n3 - n19, n4, 0, 0);
            this.copyFromBackImage(graphics, 0, n18, n19, n4, n3 - n19, 0);
        } else {
            this.copyFromBackImage(graphics, n17, n18, n3 - n19, n4 - n20, 0, 0);
            this.copyFromBackImage(graphics, n17, 0, n3 - n19, n20, 0, n4 - n20);
            this.copyFromBackImage(graphics, 0, n18, n19, n4 - n20, n3 - n19, 0);
            this.copyFromBackImage(graphics, 0, 0, n19, n20, n3 - n19, n4 - n20);
        }
    }

    public void dispose() {
        int n;
        int n2;
        if (this._axPhys != null) {
            n2 = this._axPhys.length;
            n = 0;
            while (n < n2) {
                this._axPhys[n] = null;
                ++n;
            }
            this._axPhys = null;
        }
        if (this._forePhys != null) {
            n2 = this._forePhys.length;
            n = 0;
            while (n < n2) {
                this._forePhys[n] = null;
                ++n;
            }
            this._forePhys = null;
        }
        if (this._bkTiles != null) {
            n2 = this._bkTiles.length;
            n = 0;
            while (n < n2) {
                this._bkTiles[n] = null;
                ++n;
            }
            this._bkTiles = null;
        }
        this._bkShareTileSet = null;
        this._bkTile = null;
        this._bkTileSet = null;
        this._fbkTile = null;
        this.disActorInBK();
        System.gc();
    }

    public void drawShelterTile(Graphics graphics, int n, int n2) {
        this.isShelterPhy(n, n2);
        if (this.isDrawShelterTile(n, n2)) {
            this.drawShelterTileForFore(graphics, n, n2);
        }
    }

    private final void drawShelterTileForFore(Graphics graphics, int n, int n2) {
        int n3 = this._bktw;
        int n4 = this._bkth;
        int n5 = n * n3 - _mapx;
        int n6 = n2 * n4 - _mapy;
        if (n5 >= 320 || n5 + n3 <= 0 || n6 >= 240 || n6 + n4 <= 0) {
            return;
        }
        graphics.setClip(n5, n6, n3, n4);
        int n7 = this._phyMapLayer;
        while (n7 < this._curMapLayers) {
            int n8 = this.getMapTile(n7, n5 + _mapx, n6 + _mapy);
            if (n8 != -1) {
                int n9 = this.getImageIndex(n8 >> 12);
                this.paintPic = (Image)_image.get(new Integer(n9));
                int n10 = n8 & 0xFFF;
                if (n10 != 0) {
                    // empty if block
                }
                int n11 = n8 & 0xFF;
                int n12 = this.paintPic.getWidth() / n3;
                this.drawImageFlip(graphics, this.paintPic, n11 % n12 * n3, n11 / n12 * n4, n3, n4, n5, n6, n10);
            }
            ++n7;
        }
    }

    public boolean isShelterSolPhy(int n, int n2) {
        int n3 = this.getShelterInfo(n, n2);
        switch (n3) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isShelterPhy(int n, int n2) {
        int n3 = this.getShelterInfo(n, n2);
        switch (n3) {
            case 5: 
            case 6: {
                this._phyMapLayer = 0;
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                this._phyMapLayer = 1;
                return true;
            }
            case 30: {
                return true;
            }
        }
        return false;
    }

    public final boolean isDrawShelterTile(int n, int n2) {
        int n3 = this.getShelterInfo(n, n2);
        switch (n3) {
            case 4: {
                return false;
            }
        }
        return true;
    }

    public final int getShelterInfo(int n, int n2) {
        byte[][] byArray = this._axPhys;
        if (n < 0 || n >= this._bkw || n2 < 0 || n2 >= this._bkh) {
            return 30;
        }
        if (byArray[n2][0] == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 2;
        do {
            n3 += byArray[n2][n4 + 1];
            if (byArray[n2][n4 + 1] < 0) {
                n3 += 256;
            }
            n4 += 2;
        } while (n3 < n + 1);
        return byArray[n2][n4 -= 2];
    }

    public final int conversionTileIndexLeft(int n) {
        int n2 = n / this._bktw;
        return n < 0 ? n2 - 1 : n2;
    }

    public final int conversionTileIndexRight(int n) {
        return --n / this._bktw;
    }

    public final int conversionTileIndexTop(int n) {
        return n / this._bkth;
    }

    public final int conversionTileIndexBottom(int n) {
        return --n / this._bkth;
    }

    public final boolean isEqual(int n, int n2) {
        return this._bkId == n;
    }

    public void load(int n) {
        this._bkId = n;
        this.loadMapTile(n);
        this.setFastMode(this._cw, this._ch);
    }

    private final void loadMapTile(int n) {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            Image image;
            int n6 = n / 10;
            int n7 = n % 10;
            InputStream inputStream = StreamReader.openDataFile("/res/backtile" + n6 + ".bin", n7);
            byte by = StreamReader.readByte(inputStream);
            this._bkw = StreamReader.readShort(inputStream);
            this._bkh = StreamReader.readShort(inputStream);
            this._bktw = StreamReader.readByte(inputStream);
            this._bkth = StreamReader.readByte(inputStream);
            this._mapW = this._bktw * this._bkw;
            this._mapH = this._bkth * this._bkh;
            int n8 = StreamReader.readByte(inputStream);
            this._imageComId = new short[n8];
            int n9 = 0;
            while (n9 < n8) {
                this._imageComId[n9] = StreamReader.readShort(inputStream);
                ++n9;
            }
            if (!this._repeatMap) {
                image = _image.keys();
                while (image.hasMoreElements()) {
                    Integer n10 = (Integer)image.nextElement();
                    n5 = n10.byteValue();
                    n4 = 1;
                    n3 = 0;
                    while (n3 < this._imageComId.length) {
                        if (this._imageComId[n3] == n5) {
                            n4 = 0;
                            break;
                        }
                        ++n3;
                    }
                    if (n4 == 0) continue;
                    _image.remove(n10);
                }
            } else {
                this._repeatMap = false;
            }
            int n11 = 0;
            while (n11 < this._imageComId.length) {
                Object v = _image.get(new Integer(this._imageComId[n11]));
                if (v == null || this._imageComId[n11] == 8 || this._imageComId[n11] == 0) {
                    n3 = this._imageComId[n11] % 10;
                    n4 = this._imageComId[n11] / 10;
                    n2 = this.getSpeicalIndex(n, n3 + n4 * 10);
                    image = n2 < -1 ? StreamReader.loadPng("/res/backpng" + n4 + ".bin", n3) : TiledBackground.loadXpngImage("/res/backpng" + n4 + ".bin", n3, n2);
                    _image.put(new Integer(this._imageComId[n11]), image);
                }
                ++n11;
            }
            this._curMapLayers = StreamReader.readByte(inputStream);
            n5 = this._bkw * this._bkh;
            this._bkTiles = new short[this._curMapLayers][n5];
            n4 = 0;
            while (n4 < this._curMapLayers) {
                n3 = 0;
                while (n3 < n5) {
                    this._bkTiles[n4][n3] = StreamReader.readShort(inputStream);
                    ++n3;
                }
                n2 = StreamReader.readShort(inputStream);
                ++n4;
            }
            this._phytw = StreamReader.readByte(inputStream);
            this._phyth = StreamReader.readByte(inputStream);
            n3 = StreamReader.readShort(inputStream);
            n2 = StreamReader.readShort(inputStream);
            this._axPhys = new byte[n2][];
            int n12 = 0;
            while (n12 < n2) {
                byte by2 = StreamReader.readByte(inputStream);
                if (by2 == 0) {
                    this._axPhys[n12] = new byte[1];
                    this._axPhys[n12][0] = 0;
                } else if (by2 == 1) {
                    this._axPhys[n12] = new byte[1 + n3];
                    inputStream.read(this._axPhys[n12], 1, n3);
                    this._axPhys[n12][0] = 1;
                } else {
                    int n13 = StreamReader.readByte(inputStream);
                    if (n13 < 0) {
                        n13 += 256;
                    }
                    this._axPhys[n12] = new byte[n13 + 1 << 1];
                    inputStream.read(this._axPhys[n12], 2, n13 << 1);
                    this._axPhys[n12][0] = 2;
                }
                ++n12;
            }
            if (this._needFlipMap) {
                this._bkTiles = this.flipMapTile(this._bkTiles, this._bkw);
                this._axPhys = this.flipMapAxphys(this._axPhys);
            }
            inputStream.close();
            inputStream = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private short[][] flipMapTile(short[][] sArray, int n) {
        int n2;
        short[][] sArray2 = sArray;
        int n3 = 0;
        while (n3 < sArray2.length) {
            n2 = 0;
            while (n2 < sArray2[n3].length) {
                this.copyConverse(sArray2[n3], n2, n2 + n - 1);
                n2 += n;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < sArray2.length) {
            int n4 = 0;
            while (n4 < sArray2[n2].length) {
                short[] sArray3 = sArray2[n2];
                int n5 = n4++;
                sArray3[n5] = (short)(sArray3[n5] ^ 0x100);
            }
            ++n2;
        }
        return sArray2;
    }

    private short[][] flipMapFseq(short[][] sArray, int n) {
        int n2;
        short[][] sArrayArray = new short[sArray.length][];
        int n3 = 0;
        while (n3 < sArrayArray.length) {
            n2 = n3;
            while (n2 < n3 + n) {
                sArrayArray[n2] = sArray[n3 + n - 1 - (n2 - n3)];
                ++n2;
            }
            n3 += n;
        }
        n2 = 0;
        while (n2 < sArrayArray.length) {
            if (sArrayArray[n2] != null) {
                int n4 = 2;
                while (n4 < sArrayArray[n2].length) {
                    short[] sArray2 = sArrayArray[n2];
                    int n5 = n4++;
                    sArray2[n5] = (short)(sArray2[n5] ^ 0x100);
                }
            }
            ++n2;
        }
        return sArrayArray;
    }

    private byte[][] flipMapAxphys(byte[][] byArray) {
        byte[][] byArrayArray = new byte[byArray.length][];
        int n = 0;
        while (n < byArrayArray.length) {
            switch (byArray[n][0]) {
                case 0: {
                    byArrayArray[n] = byArray[n];
                    break;
                }
                case 1: {
                    this.copyConverse(byArray[n], 1, byArrayArray[n].length - 1);
                    byArrayArray[n] = byArray[n];
                    break;
                }
                case 2: {
                    byArrayArray[n] = new byte[byArray[n].length];
                    byArrayArray[n][0] = byArray[n][0];
                    int n2 = 2;
                    while (n2 < byArray[n].length) {
                        byArrayArray[n][n2] = byArray[n][byArray[n].length - 2 - n2 + 2];
                        byArrayArray[n][n2 + 1] = byArray[n][byArray[n].length - 1 - n2 + 2];
                        n2 += 2;
                    }
                    break;
                }
            }
            ++n;
        }
        return byArrayArray;
    }

    private void countTicks() {
        ++this._synTicks;
    }

    public static Image loadXpngImage(String string, int n, int n2) {
        Image image;
        InputStream inputStream = StreamReader.openDataFile(string, n);
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        try {
            int n5;
            boolean bl;
            boolean bl2 = bl = StreamReader.readByte(inputStream) > 0;
            if (bl) {
                StreamReader.readByte(inputStream);
            }
            if ((n5 = StreamReader.readByte(inputStream)) > 0) {
                n3 = StreamReader.readInt(inputStream);
                n4 = StreamReader.readInt(inputStream);
                if (n2 >= 0) {
                    byArray = new byte[n4];
                }
                int n6 = 0;
                while (n6 < n5) {
                    if (n2 == n6) {
                        inputStream.read(byArray);
                    } else {
                        inputStream.skip(n4);
                    }
                    ++n6;
                }
            }
            int n7 = StreamReader.readInt(inputStream);
            byte[] byArray2 = new byte[n7];
            inputStream.read(byArray2);
            if (byArray != null) {
                System.arraycopy(byArray, 0, byArray2, n3, n4);
                byArray = null;
            }
            image = Image.createImage((byte[])byArray2, (int)0, (int)n7);
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return image;
    }

    private void copyConverse(short[] sArray, int n, int n2) {
        int n3 = (n2 - n + 1 >> 1) + n;
        int n4 = n;
        while (n4 < n3) {
            int n5 = n4;
            sArray[n5] = (short)(sArray[n5] ^ sArray[n2 - (n4 - n)]);
            int n6 = n2 - (n4 - n);
            sArray[n6] = (short)(sArray[n6] ^ sArray[n4]);
            int n7 = n4;
            sArray[n7] = (short)(sArray[n7] ^ sArray[n2 - (n4 - n)]);
            ++n4;
        }
    }

    private void copyConverse(byte[] byArray, int n, int n2) {
        int n3 = (n2 - n + 1 >> 1) + n;
        int n4 = n;
        while (n4 < n3) {
            int n5 = n4;
            byArray[n5] = (byte)(byArray[n5] ^ byArray[n2 - (n4 - n)]);
            int n6 = n2 - (n4 - n);
            byArray[n6] = (byte)(byArray[n6] ^ byArray[n4]);
            int n7 = n4;
            byArray[n7] = (byte)(byArray[n7] ^ byArray[n2 - (n4 - n)]);
            ++n4;
        }
    }

    private int getSpeicalIndex(int n, int n2) {
        switch (n2) {
            case 0: {
                switch (n) {
                    case 18: 
                    case 19: 
                    case 43: {
                        return 0;
                    }
                    case 20: 
                    case 21: 
                    case 22: 
                    case 44: {
                        return 1;
                    }
                }
                break;
            }
            case 8: {
                switch (n) {
                    case 18: 
                    case 19: 
                    case 43: {
                        return 0;
                    }
                }
                break;
            }
            default: {
                return -2;
            }
        }
        return -1;
    }

    public void setFlipMapFlag(boolean bl) {
        this._needFlipMap = bl;
    }

    public void setBattleFlag(boolean bl) {
        this._repeatMap = bl;
    }

    private void initActorInBk() {
        this._actorIdBk = new Hashtable(400);
        this._actorInBK = new Hashtable(30);
    }

    public void addActorInfo(Actor actor) {
        if (actor == null) {
            return;
        }
        boolean bl = false;
        int n = ((actor._x >> 10) + actor.getAni().getCollideLeft(actor._action)) / this._bktw - 1;
        int n2 = ((actor._x >> 10) + actor.getAni().getCollideRight(actor._action)) / this._bktw;
        int n3 = ((actor._y >> 10) + actor.getAni().getCollideTop(actor._action)) / this._bkth;
        int n4 = ((actor._y >> 10) + actor.getAni().getCollideBottom(actor._action)) / this._bkth;
        int n5 = n;
        while (n5 <= n2) {
            if (n5 >= 0 && n5 < this._bkw) {
                int n6 = n3;
                while (n6 <= n4) {
                    if (n6 >= 0 && n6 < this._bkh) {
                        int n7 = n5 + n6 * this._bkw;
                        if (this._actorIdBk.get(new Integer(n7)) == null) {
                            this._actorIdBk.put(new Integer(n7), new Integer(actor._id));
                        } else {
                            Integer n8 = (Integer)this._actorIdBk.get(new Integer(n7));
                            this._actorIdBk.put(new Integer(n7), new Integer(actor._id * 10 + n8));
                        }
                        bl = true;
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        if (bl) {
            this._actorInBK.put(new Integer(actor._id), actor);
        }
    }

    public void disActorInBK() {
        if (this._actorIdBk != null) {
            this._actorIdBk.clear();
            this._actorIdBk = null;
        }
        if (this._actorInBK != null) {
            this._actorInBK.clear();
            this._actorInBK = null;
        }
    }

    public void drawActorInBk(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        Object v = this._actorIdBk.get(new Integer(n));
        if (v == null) {
            return;
        }
        Integer n6 = (Integer)v;
        int n7 = n6;
        int n8 = n7 % 10;
        while (n8 > 0) {
            if (n7 > 10) {
                // empty if block
            }
            if ((v = this._actorInBK.get(new Integer(n8))) == null) {
                return;
            }
            Actor actor = (Actor)v;
            int n9 = GameMainLogic.getInstance()._state;
            int n10 = GameMainLogic.getBattleScene()._camx >> 10;
            int n11 = GameMainLogic.getBattleScene()._camy >> 10;
            int n12 = 0;
            int n13 = 0;
            if (n10 / _backImg.getWidth() > 0) {
                n12 = -(_backImg.getWidth() * (n10 / _backImg.getWidth()));
            }
            if (n11 / _backImg.getHeight() > 0) {
                n13 = -(_backImg.getHeight() * (n11 / _backImg.getHeight()));
            }
            switch (n9) {
                case 2: {
                    actor.drawClip(graphics, 0, 0, n12, n13, n2, n3, n4, n5);
                    break;
                }
                case 1: {
                    actor.drawClip(graphics, 0, 0, n12, n13, n2, n3, n4, n5);
                }
            }
            n8 = (n7 /= 10) % 10;
        }
    }

    static {
        IMAGE_MAX_NUMBER = 9;
    }
}

