/*
 * Decompiled with CFR 0.152.
 */
package igs;

import igs.HelloMIDlet;
import igs.ThinkThread;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class BoardCanvas
extends Canvas
implements CommandListener {
    private Command gotoMainFormCommand;
    private Command passCommand;
    private Command doneCommand;
    private Command undoCommand;
    private Command resignCommand;
    byte[][] board;
    int stepIndex = 0;
    HelloMIDlet midlet;
    int gameName = 0;
    int side = 0;
    String blackName = "";
    int blackTime = 0;
    int blackStep = 0;
    String whiteName = "";
    int whiteTime = 0;
    int whiteStep = 0;
    String gameInfo = "";
    static final int[] dxs = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    static final int[] dys = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    public static int perBox = 6;
    static final int borderColor = 0x400000;
    static final int whiteColor = 0xFFFFFF;
    static final int blackColor = 0;
    static final int boardColor = 16361730;
    int cursorX = 0;
    int cursorY = 0;

    public void setSide(int n) {
        this.side = n;
    }

    public void clearBoard() {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 15; ++j) {
                this.board[i][j] = 0;
            }
        }
        this.stepIndex = 0;
    }

    public BoardCanvas(byte[][] byArray, HelloMIDlet helloMIDlet) {
        this.board = byArray;
        this.midlet = helloMIDlet;
        this.clearBoard();
    }

    public void checkWin(byte[][] byArray, int n, int n2) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            byte by = ThinkThread.computerSide;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < dxs.length; ++i) {
                int n3 = dxs[i];
                int n4 = dys[i];
                stringBuffer.delete(0, stringBuffer.length());
                int n5 = n - n3 * 6;
                int n6 = n2 - n4 * 6;
                int n7 = 0;
                while (n7 < 12) {
                    int n8 = 88;
                    if (n5 >= 0 && n5 < 15 && n6 >= 0 && n6 < 15) {
                        if (byArray[n5][n6] == 0) {
                            n8 = 46;
                        } else if (byArray[n5][n6] == by) {
                            n8 = 77;
                        } else if (byArray[n5][n6] == 3 - by) {
                            n8 = 87;
                        }
                    }
                    stringBuffer.append((char)n8);
                    ++n7;
                    n5 += n3;
                    n6 += n4;
                }
                String string = stringBuffer.toString();
                if (string.indexOf("MMMMM") >= 0) {
                    bl2 = true;
                    continue;
                }
                if (string.indexOf("WWWWW") < 0) continue;
                bl = true;
            }
            if (bl2) {
                this.midlet.alarm("\u7535\u8bdd\u8d62\u4e86", AlertType.INFO, 1000);
                this.clearBoard();
                this.side = ThinkThread.userSide;
            }
            if (bl) {
                this.midlet.alarm("\u4f60\u8d62\u4e86", AlertType.INFO, 1000);
                this.clearBoard();
                this.side = ThinkThread.userSide;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        graphics.setColor(0);
        graphics.fillRect(0, 0, graphics.getClipWidth(), graphics.getClipHeight());
        n3 = Math.min(graphics.getClipWidth() / 2 - this.cursorX * perBox, n3);
        n4 = Math.min(graphics.getClipHeight() / 2 - this.cursorY * perBox, n4);
        n3 = Math.max(n3, graphics.getClipWidth() - 16 * perBox);
        n4 = Math.max(n4, graphics.getClipHeight() - 16 * perBox);
        graphics.translate(n3, n4);
        int n5 = n3 + graphics.getClipX() / perBox;
        int n6 = n4 + graphics.getClipY() / perBox;
        int n7 = n5 + graphics.getClipWidth() / perBox + 1;
        int n8 = n6 + graphics.getClipHeight() / perBox + 1;
        n5 = 0;
        n6 = 0;
        n7 = 15;
        n8 = 15;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n7 > 15) {
            n7 = 15;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n8 > 15) {
            n8 = 15;
        }
        graphics.setColor(16361730);
        graphics.fillRect(0, 0, perBox * 16, perBox * 16);
        graphics.setColor(0);
        for (n2 = n5; n2 < n7; ++n2) {
            graphics.drawLine((n2 + 1) * perBox, perBox, (n2 + 1) * perBox, 15 * perBox);
        }
        for (n2 = n6; n2 < n8; ++n2) {
            graphics.drawLine(perBox, (n2 + 1) * perBox, 15 * perBox, (n2 + 1) * perBox);
        }
        for (n2 = n5; n2 < n7; ++n2) {
            block7: for (n = n6; n < n8; ++n) {
                switch (this.board[n2][n]) {
                    case 1: {
                        graphics.setColor(0xFFFFFF);
                        graphics.fillArc(n2 * perBox + (perBox + 1) / 2, n * perBox + (perBox + 1) / 2, perBox - 1, perBox - 1, 0, 360);
                        graphics.setColor(0x400000);
                        graphics.drawArc(n2 * perBox + (perBox + 1) / 2, n * perBox + (perBox + 1) / 2, perBox - 1, perBox - 1, 0, 360);
                        continue block7;
                    }
                    case 2: {
                        graphics.setColor(0);
                        graphics.fillArc(n2 * perBox + (perBox + 1) / 2, n * perBox + (perBox + 1) / 2, perBox - 1, perBox - 1, 0, 360);
                        graphics.setColor(0x400000);
                        graphics.drawArc(n2 * perBox + (perBox + 1) / 2, n * perBox + (perBox + 1) / 2, perBox - 1, perBox - 1, 0, 360);
                    }
                }
            }
        }
        n2 = this.cursorX;
        n = this.cursorY;
        graphics.setColor(255, 0, 0);
        graphics.drawRect(n2 * perBox + perBox / 2, n * perBox + perBox / 2, perBox, perBox);
        graphics.drawLine(n2 * perBox + perBox / 2, n * perBox + perBox / 2, n2 * perBox + perBox * 3 / 2, n * perBox + perBox * 3 / 2);
        graphics.drawLine(n2 * perBox + perBox * 3 / 2, n * perBox + perBox / 2, n2 * perBox + perBox / 2, n * perBox + perBox * 3 / 2);
        graphics.translate(-n3, -n4);
        graphics.setFont(Font.getFont((int)0, (int)1, (int)16));
        int n9 = 0;
        if (this.cursorX < 10) {
            n9 |= 8;
            n3 = graphics.getClipWidth();
        } else {
            n9 |= 4;
            n3 = 0;
        }
        if (this.cursorY < 10) {
            n9 |= 0x20;
            n4 = graphics.getClipHeight();
        } else {
            n9 |= 0x10;
            n4 = 0;
        }
        graphics.translate(n3, n4);
        graphics.setColor(0, 0, 0);
        graphics.drawString(this.gameInfo, 1, 0, n9);
        graphics.drawString(this.gameInfo, 0, 1, n9);
        graphics.drawString(this.gameInfo, -1, 0, n9);
        graphics.drawString(this.gameInfo, 0, -1, n9);
        graphics.setColor(255, 0, 0);
        graphics.drawString(this.gameInfo, 0, 0, n9);
    }

    protected void keyRepeated(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                this.keyPressed(n);
                break;
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        n3 = Math.min(this.getWidth() / 2 - this.cursorX * perBox, n3);
        n4 = Math.min(this.getHeight() / 2 - this.cursorY * perBox, n4);
        n3 = Math.max(n3, this.getWidth() - 16 * perBox);
        n4 = Math.max(n4, this.getHeight() - 16 * perBox);
        this.cursorX = (n - n3 + perBox / 2) / perBox;
        this.cursorY = (n2 - n4 + perBox / 2) / perBox;
        this.repaint();
        this.keyPressed(8);
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 1: 
            case 50: {
                if (this.cursorY <= 0) break;
                --this.cursorY;
                break;
            }
            case 6: 
            case 56: {
                if (this.cursorY >= 14) break;
                ++this.cursorY;
                break;
            }
            case 2: 
            case 52: {
                if (this.cursorX <= 0) break;
                --this.cursorX;
                break;
            }
            case 5: 
            case 54: {
                if (this.cursorX >= 14) break;
                ++this.cursorX;
                break;
            }
            case 8: {
                if (this.side != ThinkThread.userSide || this.board[this.cursorX][this.cursorY] != 0) break;
                this.board[this.cursorX][this.cursorY] = ThinkThread.userSide;
                this.side = ThinkThread.computerSide;
                this.repaint();
                this.checkWin(this.board, this.cursorX, this.cursorY);
                ThinkThread thinkThread = new ThinkThread(this.board, this);
                thinkThread.start();
            }
        }
        switch (n) {
            case 55: {
                --perBox;
                break;
            }
            case 57: {
                ++perBox;
                break;
            }
            case 49: {
                break;
            }
        }
        this.repaint();
    }
}

