/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameLogic {
    public static final int GAME_LOADING = 65;
    public static final int GAME_MAIN = 66;
    public static final int GAME_WIN = 67;
    public static final int GAME_OVER = 68;
    public static final int GAME_MENU = 70;
    public static final int GAME_READY = 71;
    public static final int RETURN_MENU = 72;
    public static final int TRAVEL_MAP = 73;
    public static final int GAME_HELP = 80;
    public static final int END_STAG = 7;
    private Framework framework;
    private int state;
    private int state_new;
    private int time_clock;
    private int load_counter;
    private int loading_done;
    private int travelmap_state;
    public Random random;
    public int gamemenu_index;
    public static final byte GAMEMENU_ITEM_COUNT = 4;
    public static final byte[] GAMEMENU_ITEM_STATE = new byte[]{66, 70, 80, 72};
    Image image_buffer;
    Image image_bg;
    Image image_hero;
    Image image_woman;
    Image image_man;
    Image image_pseudoitem;
    Image image_tree;
    Image image_sapling;
    Image image_rabbit;
    Image image_load;
    Image image_loadform;
    Image image_score;
    Image image_letter2;
    byte stage_no = 0;
    int map_pos_x;
    int map_pos_y;
    int hero_pos_x;
    int hero_pos_y;
    int keyMove;
    int temp0;
    int temp1;
    private byte[][] map_info = new byte[16][22];
    public static final byte[][] HERO_POS = new byte[][]{{20, 2}, {20, 2}, {2, 2}, {0, 2}, {4, 2}, {19, 2}, {4, 2}, {20, 2}};
    public static final byte[] MAP_UPGND_ID = new byte[]{0, 1, 2, 3, 4};
    public static final byte[] MAP_DOWNGND_ID = new byte[]{6, 7, 8, 9, 10};
    public static final byte[] MAP_LADDER_ID = new byte[]{5, 11, 17};
    public static final byte[] MAP_NULL_ID = new byte[]{16};
    public static final byte MAX_PSEUDOITEM_NUM = 30;
    public static final byte[] PSEUDOITEM_NUM = new byte[]{30, 26, 26, 26, 27, 27, 28, 28};
    public static final byte[][][] PSEUDOITEM_POS = new byte[][][]{new byte[][]{{1, 2, 4}, {4, 2, 6}, {5, 2, 9}, {7, 2, 10}, {17, 2, 9}, {19, 2, 10}, {17, 4, 1}, {1, 5, 0}, {7, 5, 13}, {10, 5, 3}, {12, 5, 10}, {17, 5, 11}, {4, 8, 10}, {15, 8, 5}, {16, 8, 12}, {17, 8, 9}, {19, 8, 10}, {4, 10, 1}, {14, 10, 2}, {2, 11, 3}, {6, 11, 10}, {16, 11, 9}, {16, 11, 10}, {19, 11, 13}, {2, 14, 10}, {6, 14, 10}, {7, 14, 7}, {10, 14, 8}, {13, 14, 9}, {20, 14, 9}}, new byte[][]{{19, 1, 2}, {1, 2, 3}, {3, 2, 9}, {5, 2, 11}, {7, 2, 6}, {9, 2, 13}, {0, 5, 0}, {8, 5, 10}, {9, 5, 3}, {19, 5, 10}, {7, 17, 1}, {5, 8, 12}, {6, 8, 3}, {17, 8, 11}, {1, 11, 9}, {3, 11, 10}, {18, 11, 4}, {20, 11, 5}, {3, 12, 2}, {1, 14, 9}, {5, 14, 3}, {10, 14, 7}, {13, 14, 8}, {15, 14, 10}, {16, 14, 9}, {19, 14, 12}}, new byte[][]{{0, 1, 2}, {2, 2, 3}, {4, 2, 9}, {6, 2, 10}, {7, 2, 6}, {14, 2, 4}, {2, 5, 10}, {4, 5, 9}, {6, 5, 12}, {14, 5, 13}, {15, 5, 10}, {20, 7, 1}, {5, 8, 4}, {18, 8, 9}, {20, 8, 11}, {0, 11, 0}, {6, 11, 9}, {9, 11, 13}, {10, 11, 10}, {16, 11, 10}, {17, 11, 5}, {20, 13, 1}, {5, 14, 10}, {7, 14, 3}, {16, 14, 9}, {18, 14, 10}}, new byte[][]{{0, 1, 2}, {2, 2, 6}, {11, 2, 3}, {13, 2, 10}, {20, 2, 13}, {2, 5, 9}, {4, 5, 10}, {11, 5, 12}, {13, 5, 9}, {8, 7, 1}, {6, 8, 10}, {8, 8, 11}, {10, 8, 4}, {12, 8, 10}, {21, 8, 12}, {20, 10, 1}, {4, 11, 5}, {5, 11, 9}, {8, 11, 13}, {13, 11, 10}, {20, 11, 11}, {5, 14, 3}, {0, 14, 9}, {7, 14, 10}, {15, 14, 7}, {18, 14, 8}}, new byte[][]{{4, 2, 10}, {5, 2, 6}, {6, 2, 9}, {8, 2, 13}, {12, 2, 3}, {0, 4, 1}, {20, 4, 2}, {2, 5, 9}, {15, 5, 9}, {20, 5, 11}, {0, 8, 0}, {5, 8, 3}, {7, 8, 9}, {13, 8, 10}, {16, 8, 12}, {17, 8, 4}, {6, 11, 13}, {7, 11, 10}, {16, 11, 5}, {17, 11, 3}, {19, 11, 12}, {20, 11, 10}, {6, 13, 2}, {0, 14, 4}, {8, 14, 7}, {11, 14, 8}, {20, 14, 9}}, new byte[][]{{20, 1, 1}, {3, 2, 3}, {5, 2, 10}, {6, 2, 6}, {7, 2, 9}, {9, 2, 13}, {11, 2, 10}, {19, 2, 10}, {1, 4, 2}, {3, 5, 9}, {17, 5, 12}, {18, 5, 9}, {16, 7, 2}, {4, 8, 4}, {18, 8, 4}, {2, 11, 10}, {3, 11, 12}, {4, 11, 11}, {15, 11, 3}, {17, 11, 13}, {18, 11, 5}, {11, 14, 3}, {7, 14, 10}, {9, 14, 7}, {12, 14, 8}, {19, 14, 10}, {20, 14, 9}}, new byte[][]{{0, 1, 2}, {1, 2, 11}, {2, 2, 3}, {4, 2, 10}, {5, 2, 6}, {14, 2, 10}, {16, 2, 9}, {7, 4, 1}, {20, 4, 2}, {5, 5, 9}, {7, 5, 11}, {14, 5, 4}, {19, 5, 10}, {9, 8, 3}, {11, 8, 10}, {16, 8, 10}, {17, 8, 12}, {18, 8, 9}, {6, 11, 10}, {7, 11, 13}, {15, 11, 5}, {16, 11, 4}, {19, 11, 0}, {0, 14, 7}, {3, 14, 8}, {4, 14, 10}, {1, 14, 10}, {13, 14, 9}}, new byte[][]{{5, 1, 2}, {0, 2, 3}, {3, 2, 6}, {4, 2, 10}, {6, 2, 11}, {15, 2, 12}, {16, 2, 9}, {18, 2, 4}, {20, 2, 10}, {16, 4, 1}, {4, 5, 10}, {5, 5, 9}, {8, 5, 12}, {18, 5, 3}, {3, 8, 9}, {5, 8, 10}, {16, 8, 10}, {17, 8, 13}, {20, 8, 4}, {7, 10, 1}, {6, 11, 13}, {5, 11, 9}, {17, 11, 5}, {0, 13, 2}, {6, 14, 10}, {9, 14, 7}, {12, 14, 8}, {13, 14, 10}}};
    public static final byte MAX_WOMAN_NUM = 3;
    public static final byte[] WOMAN_NUM = new byte[]{3, 3, 3, 3, 3, 3, 3, 3};
    public static final byte[][][] WOMAN_POS = new byte[][][]{new byte[][]{{5, 5}, {13, 8}, {1, 11}}, new byte[][]{{11, 2}, {3, 8}, {17, 11}}, new byte[][]{{1, 5}, {4, 8}, {15, 11}}, new byte[][]{{1, 5}, {3, 11}, {19, 5}}, new byte[][]{{16, 2}, {13, 8}, {12, 11}}, new byte[][]{{2, 2}, {7, 8}, {19, 11}}, new byte[][]{{15, 2}, {20, 8}, {10, 11}}, new byte[][]{{2, 2}, {2, 11}, {19, 11}}};
    public static final byte MAX_MAN_NUM = 2;
    public static final byte[] MAN_NUM = new byte[]{2, 2, 1, 1, 2, 2, 2, 2};
    public static final byte[][][] MAN_POS = new byte[][][]{new byte[][]{{4, 14}, {18, 14}}, new byte[][]{{2, 14}, {18, 14}}, new byte[][]{{4, 14}}, new byte[][]{{12, 14}}, new byte[][]{{2, 14}, {18, 14}}, new byte[][]{{4, 14}, {17, 14}}, new byte[][]{{8, 14}, {15, 14}}, new byte[][]{{2, 14}, {19, 14}}};
    public static final byte MAX_FRUIT_NUM = 8;
    public static final byte[] FRUIT_NUM = new byte[]{4, 5, 5, 6, 6, 6, 6, 8};
    public static final byte[][][] FRUIT_POS = new byte[][][]{new byte[][]{{7, 2, 0}, {6, 5, 1}, {16, 8, 2}, {6, 14, 4}}, new byte[][]{{6, 2, 4}, {11, 5, 0}, {1, 8, 7}, {16, 8, 6}, {7, 14, 1}}, new byte[][]{{3, 5, 0}, {11, 5, 2}, {16, 8, 1}, {8, 11, 3}, {11, 14, 5}}, new byte[][]{{4, 2, 7}, {13, 2, 2}, {19, 2, 6}, {1, 8, 1}, {20, 8, 3}, {2, 11, 0}}, new byte[][]{{14, 2, 3}, {5, 5, 5}, {14, 5, 0}, {3, 8, 4}, {5, 11, 7}, {16, 14, 1}}, new byte[][]{{12, 2, 0}, {7, 5, 5}, {14, 5, 4}, {2, 8, 7}, {13, 8, 2}, {14, 11, 6}}, new byte[][]{{7, 2, 4}, {16, 5, 7}, {6, 8, 1}, {4, 11, 2}, {13, 11, 5}, {4, 14, 6}}, new byte[][]{{9, 2, 0}, {2, 5, 1}, {13, 5, 4}, {2, 8, 2}, {9, 8, 3}, {13, 11, 7}, {5, 14, 6}, {16, 14, 5}}};
    public static final byte[][] SPRINGBED_POS = new byte[][]{{7, 14}, {10, 14}, new byte[0], {15, 14}, {8, 14}, {9, 14}, {0, 14}, {9, 14}};
    public Sound sound_player;
    public static byte[] sound_data = new byte[]{2, 74, 58, 64, 4, 0, -27, 26, -125, -112, 33, 4, -107, -127, 8, 21, -127, 72, 21, -127, 8, 25, -127, 8, 23, -127, 8, 23, -127, 88, 23, -127, 6, 16, -126, -118, 52, -108, 18, 114, 4, 32, 106, 4, 32, 102, 4, 32, 86, 4, 32, 94, 4, 32, -125, -112, 33, 4, -107, -127, 8, 21, -127, 72, 21, -127, 8, 25, -127, 8, 23, -127, 8, 23, -127, 88, 23, -127, 6, 16, -126, 14, 53, 36, -96, 82, 4, 32, 94, 4, 32, 85, -92, 24, 66, 5, 96, 66, 6, -96, 66, 6, -96, 102, 6, -96, 66, 10, 37, 2, 16, 73, -56, 16, -127, -56, 27, -127, -56, 16, -127, 88, 16, -127, -88, 16, -127, -88, 25, -127, -88, 16, -126, -119, 64, -124, 18, 113, 4, 24, 86, 4, 32, 101, -124, 32, 94, 5, 88, 65, -123, 80, 65, -123, 96, 66, 5, 96, 66, 5, 96, 66, 5, 96, 66, 5, 96, 0};
    CHero Object_Hero;
    CMan[] Object_Man;
    CWoman[] Object_Woman;
    CFruit[] Object_Fruit;
    CPseudoItem[] Object_PseudoItem;
    CSpringbed Object_Springbed;

    public GameLogic(Framework framework) {
        this.framework = framework;
        this.random = new Random();
        this.sound_init();
    }

    public void destroy() {
        this.random = null;
        this.sound_release();
    }

    public void init_game() {
        this.stage_no = 0;
        this.gamemenu_index = 0;
        this.state_new = 65;
    }

    private void release_game() {
        int n;
        this.Object_Hero = null;
        for (n = 0; n < MAN_NUM[this.stage_no]; ++n) {
            this.Object_Man[n] = null;
        }
        this.Object_Man = null;
        for (n = 0; n < WOMAN_NUM[this.stage_no]; ++n) {
            this.Object_Woman[n] = null;
        }
        this.Object_Woman = null;
        for (n = 0; n < FRUIT_NUM[this.stage_no]; ++n) {
            this.Object_Fruit[n] = null;
        }
        this.Object_Fruit = null;
        for (n = 0; n < PSEUDOITEM_NUM[this.stage_no]; ++n) {
            this.Object_PseudoItem[n] = null;
        }
        this.Object_PseudoItem = null;
        this.Object_Springbed = null;
        this.stage_no = 0;
        this.map_pos_x = 0;
        this.map_pos_y = 0;
        this.hero_pos_x = 0;
        this.hero_pos_y = 0;
        this.image_buffer = null;
        this.image_bg = null;
        this.image_hero = null;
        this.image_woman = null;
        this.image_man = null;
        this.image_pseudoitem = null;
        this.image_tree = null;
        this.image_sapling = null;
        this.image_rabbit = null;
        this.image_score = null;
        this.image_load = null;
        this.image_loadform = null;
        this.image_letter2 = null;
        this.sound_stop();
    }

    public void running_gamelogic() {
        if (this.state != this.state_new) {
            switch (this.state) {
                case 65: {
                    this.release_loading();
                    break;
                }
                case 71: {
                    break;
                }
                case 73: {
                    break;
                }
                case 66: {
                    if (this.state_new != 72) break;
                    this.release_game();
                    break;
                }
                case 67: {
                    this.release_win();
                    break;
                }
                case 68: {
                    this.release_gameover();
                    break;
                }
                case 70: {
                    this.release_gamemenu();
                    if (this.state_new != 72) break;
                    this.release_game();
                    break;
                }
            }
            switch (this.state_new) {
                case 65: {
                    this.init_loading();
                    break;
                }
                case 73: {
                    this.init_travelmap();
                    break;
                }
                case 71: {
                    this.init_gameready();
                    break;
                }
                case 66: {
                    break;
                }
                case 70: {
                    this.init_gamemenu();
                    break;
                }
                case 68: {
                    this.init_gameover();
                    break;
                }
                case 67: {
                    this.init_win();
                    break;
                }
                case 72: {
                    break;
                }
                case 80: {
                    this.framework.help_row = 0;
                }
            }
            this.state = this.state_new;
            return;
        }
        switch (this.state) {
            case 65: {
                this.running_loading();
                break;
            }
            case 73: {
                this.running_travelmap();
                break;
            }
            case 71: {
                this.running_gameready();
                break;
            }
            case 66: {
                this.running_main();
                break;
            }
            case 70: {
                this.running_gamemenu();
                break;
            }
            case 67: {
                this.running_win();
                break;
            }
            case 68: {
                this.running_gameover();
                break;
            }
            case 72: {
                this.framework.state_new = (byte)4;
            }
        }
    }

    public void draw_gamelogic(Graphics graphics) {
        switch (this.state) {
            case 65: {
                this.draw_loading(graphics);
                break;
            }
            case 73: {
                this.draw_travelmap(graphics);
                break;
            }
            case 71: {
                this.draw_gameready(graphics);
                break;
            }
            case 66: {
                this.draw_main(graphics);
                break;
            }
            case 70: {
                this.draw_gamemenu(graphics);
                break;
            }
            case 68: {
                this.draw_gameover(graphics);
                break;
            }
            case 67: {
                this.draw_win(graphics);
                break;
            }
            case 80: {
                this.framework.draw_help(graphics);
            }
        }
    }

    public void stage_init(byte by) {
        int n;
        this.hero_pos_x = HERO_POS[by][0] * 16;
        this.hero_pos_y = HERO_POS[by][1] * 16;
        this.Object_Hero = new CHero();
        this.Object_Hero.InitHero(this.stage_no);
        this.Object_Man = new CMan[MAN_NUM[this.stage_no]];
        for (n = 0; n < MAN_NUM[this.stage_no]; ++n) {
            this.Object_Man[n] = new CMan();
            this.Object_Man[n].InitMan(MAN_POS[this.stage_no][n][0], MAN_POS[this.stage_no][n][1]);
        }
        this.Object_Woman = new CWoman[WOMAN_NUM[this.stage_no]];
        for (n = 0; n < WOMAN_NUM[this.stage_no]; ++n) {
            this.Object_Woman[n] = new CWoman();
            this.Object_Woman[n].InitWoman(WOMAN_POS[this.stage_no][n][0], WOMAN_POS[this.stage_no][n][1]);
        }
        this.Object_Fruit = new CFruit[FRUIT_NUM[this.stage_no]];
        for (n = 0; n < FRUIT_NUM[this.stage_no]; ++n) {
            this.Object_Fruit[n] = new CFruit();
            this.Object_Fruit[n].InitFruit(FRUIT_POS[this.stage_no][n][0], FRUIT_POS[this.stage_no][n][1], FRUIT_POS[this.stage_no][n][2]);
        }
        this.Object_PseudoItem = new CPseudoItem[PSEUDOITEM_NUM[this.stage_no]];
        for (n = 0; n < PSEUDOITEM_NUM[this.stage_no]; ++n) {
            this.Object_PseudoItem[n] = new CPseudoItem();
            this.Object_PseudoItem[n].InitPseudoItem(PSEUDOITEM_POS[this.stage_no][n][0], PSEUDOITEM_POS[this.stage_no][n][1], PSEUDOITEM_POS[this.stage_no][n][2]);
        }
        if (this.stage_no != 2) {
            this.Object_Springbed = new CSpringbed();
            this.Object_Springbed.InitSpringbed(SPRINGBED_POS[this.stage_no][0], SPRINGBED_POS[this.stage_no][1]);
        }
    }

    public void release_stage(byte by) {
        int n;
        this.Object_Hero = null;
        for (n = 0; n < MAN_NUM[this.stage_no]; ++n) {
            this.Object_Man[n] = null;
        }
        this.Object_Man = null;
        for (n = 0; n < WOMAN_NUM[this.stage_no]; ++n) {
            this.Object_Woman[n] = null;
        }
        this.Object_Woman = null;
        for (n = 0; n < FRUIT_NUM[this.stage_no]; ++n) {
            this.Object_Fruit[n] = null;
        }
        this.Object_Fruit = null;
        for (n = 0; n < PSEUDOITEM_NUM[this.stage_no]; ++n) {
            this.Object_PseudoItem[n] = null;
        }
        this.Object_PseudoItem = null;
        if (this.stage_no != 2) {
            this.Object_Springbed = null;
        }
        this.sound_stop();
    }

    private void init_loading() {
        this.time_clock = 0;
        this.load_counter = 0;
        this.loading_done = 0;
        try {
            this.image_load = Image.createImage((String)"/LOAD.PNG");
            this.image_loadform = Image.createImage((String)"/LOADFORM.PNG");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void release_loading() {
        this.image_load = null;
        this.image_loadform = null;
    }

    private void running_loading() {
        try {
            switch (this.load_counter) {
                case 0: {
                    this.stage_init(this.stage_no);
                    break;
                }
                case 1: {
                    if (this.image_man != null) break;
                    this.image_man = Image.createImage((String)"/MAN.PNG");
                    break;
                }
                case 2: {
                    if (this.image_bg == null) {
                        this.image_bg = Image.createImage((String)"/BG.PNG");
                    }
                    if (this.image_hero != null) break;
                    this.image_hero = Image.createImage((String)"/HERO.PNG");
                    break;
                }
                case 3: {
                    if (this.image_pseudoitem != null) break;
                    this.image_pseudoitem = Image.createImage((String)"/PSEUDOITEM.PNG");
                    break;
                }
                case 4: {
                    if (this.image_woman == null) {
                        this.image_woman = Image.createImage((String)"/WOMAN.PNG");
                    }
                    if (this.image_tree != null) break;
                    this.image_tree = Image.createImage((String)"/TREE.PNG");
                    break;
                }
                case 5: {
                    if (this.image_sapling != null) break;
                    this.image_sapling = Image.createImage((String)"/SAPLING.PNG");
                    break;
                }
                case 6: {
                    if (this.image_rabbit == null) {
                        this.image_rabbit = Image.createImage((String)"/RABBIT.PNG");
                    }
                    if (this.image_score != null) break;
                    this.image_score = Image.createImage((String)"/SCORE.PNG");
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    String string = "/" + this.stage_no + ".H2O";
                    InputStream inputStream = this.getClass().getResourceAsStream(string);
                    for (int i = 0; i < 16; ++i) {
                        inputStream.read(this.map_info[i], 0, 22);
                    }
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    this.state_new = 73;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.loading_done == 0) {
            ++this.load_counter;
        }
        ++this.time_clock;
    }

    private void draw_loading(Graphics graphics) {
        int n;
        graphics.setClip(0, 0, 128, 128);
        graphics.setColor(34816);
        graphics.fillRect(0, 0, 128, 128);
        int n2 = 8;
        int n3 = 64;
        graphics.setColor(0);
        graphics.drawString("\u8f7d\u5165\u4e2d", n2, n3, 20);
        graphics.drawString("\u8bf7\u7a0d\u7b49", n2 + 32 + 16 + 15, n3, 20);
        graphics.setClip(20, 96, 4, 16);
        graphics.drawImage(this.image_load, 20, 96, 20);
        for (n = 0; n < 10; ++n) {
            n2 = 24 + n * 8;
            n3 = 96;
            graphics.setClip(n2, n3, 8, 16);
            graphics.drawImage(this.image_load, n2 - 4, n3, 20);
        }
        n2 = 104;
        n3 = 96;
        graphics.setClip(n2, n3, 4, 16);
        graphics.drawImage(this.image_load, n2 - 12, n3, 20);
        for (n = 0; n < this.load_counter; ++n) {
            n2 = n >= 9 ? 96 : 24 + n * 8;
            n3 = 99;
            graphics.setClip(n2, n3, 8, 10);
            graphics.drawImage(this.image_loadform, n2, n3, 20);
        }
    }

    public void init_gameready() {
        this.time_clock = 0;
    }

    public void running_gameready() {
        ++this.time_clock;
    }

    public void draw_gameready(Graphics graphics) {
        this.draw_main(graphics);
        if (this.time_clock % 8 < 6) {
            int n = 19;
            int n2 = 64;
            graphics.setClip(0, 0, 128, 128);
            graphics.setColor(0);
            graphics.drawString("\u51c6\u5907", n, n2, 20);
            graphics.setColor(0);
            graphics.drawString("\u7b2c", n + 32 + 15, n2, 20);
            graphics.setColor(0);
            graphics.drawString(this.stage_no + 1 + "", n + 32 + 15 + 16, n2, 20);
            graphics.setColor(0);
            graphics.drawString("\u5173", n + 32 + 15 + 16 + 10, n2, 20);
        }
    }

    public void init_travelmap() {
        this.travelmap_state = 1;
        this.time_clock = 0;
        this.map_pos_x = 0;
        this.map_pos_y = 0;
    }

    public void running_travelmap() {
        switch (this.travelmap_state) {
            case 1: {
                this.map_pos_x += 2;
                if (this.map_pos_x < 224) break;
                this.map_pos_x = 224;
                this.travelmap_state = 2;
                break;
            }
            case 2: {
                this.map_pos_y += 2;
                if (this.map_pos_y < 128) break;
                this.map_pos_y = 128;
                this.travelmap_state = 3;
                break;
            }
            case 3: {
                this.map_pos_x -= 2;
                if (this.map_pos_x > 0) break;
                this.map_pos_x = 0;
                this.travelmap_state = 4;
                break;
            }
            case 4: {
                this.map_pos_y -= 2;
                if (this.map_pos_y > 0) break;
                this.map_pos_y = 0;
                this.Object_Hero.Ls_Move_Area();
                this.temp0 = this.map_pos_x;
                this.temp1 = this.map_pos_y;
                this.map_pos_x = 0;
                this.map_pos_y = 0;
                this.travelmap_state = 5;
                break;
            }
            case 5: {
                this.map_pos_x += 2;
                if (this.map_pos_x < this.temp0) break;
                this.map_pos_x = this.temp0;
                this.travelmap_state = 6;
                break;
            }
            case 6: {
                this.map_pos_y += 2;
                if (this.map_pos_y < this.temp1) break;
                this.map_pos_y = this.temp1;
                this.state_new = 71;
            }
        }
    }

    public void draw_travelmap(Graphics graphics) {
        this.draw_main(graphics);
        graphics.setClip(0, 0, 128, 128);
        graphics.setColor(0xFFFF00);
        graphics.drawString("\u6309\u5de6\u8f6f\u952e\u5f00\u59cb", 64, 64, 17);
    }

    private void running_main() {
        int n;
        int n2;
        int n3;
        this.sound_update();
        if (this.Object_Hero.hero_lives == 0) {
            this.state_new = 68;
        }
        if (this.Object_Hero.hero_fruits == FRUIT_NUM[this.stage_no]) {
            this.state_new = 67;
        }
        this.Object_Hero.Hero_Update();
        for (n3 = 0; n3 < WOMAN_NUM[this.stage_no]; ++n3) {
            n2 = this.Object_Woman[n3].woman_map_pos_x - this.map_pos_x;
            n = this.Object_Woman[n3].woman_map_pos_y - this.map_pos_y + 8 * this.Object_Woman[n3].woman_tiaoz;
            if (n2 + 16 < 0 || n2 > 128 || n + 16 < 0 || n > 128) continue;
            this.Object_Woman[n3].Woman_Update();
        }
        for (n3 = 0; n3 < FRUIT_NUM[this.stage_no]; ++n3) {
            n2 = this.Object_Fruit[n3].fruit_map_pos_x - this.map_pos_x;
            n = this.Object_Fruit[n3].fruit_map_pos_y - this.map_pos_y + 8 * this.Object_Fruit[n3].cfruit_tiaoz;
            if (n2 + 16 < 0 || n2 > 128 || n + 16 < 0 || n > 128) continue;
            this.Object_Fruit[n3].Fruit_Update();
        }
        for (n3 = 0; n3 < MAN_NUM[this.stage_no]; ++n3) {
            n2 = this.Object_Man[n3].man_map_pos_x - this.map_pos_x;
            n = this.Object_Man[n3].man_map_pos_y - this.map_pos_y + 8 * this.Object_Man[n3].man_tiaoz;
            if (n2 + 16 < 0 || n2 > 128 || n + 18 < 0 || n > 128) continue;
            this.Object_Man[n3].Man_Update();
        }
        if (this.stage_no != 2) {
            n2 = this.Object_Springbed.SpringBed_MapPosX - this.map_pos_x + 16;
            n = this.Object_Springbed.SpringBed_MapPosY - this.map_pos_y;
            if (n2 + 32 >= 0 && n2 <= 128 && n + 16 >= 0 && n <= 128) {
                this.Object_Springbed.Springbed_Update();
            }
        }
    }

    private void draw_main(Graphics graphics) {
        int n;
        graphics.setColor(11859964);
        graphics.fillRect(0, 0, 128, 128);
        int n2 = this.map_pos_x - this.map_pos_x / 16 * 16;
        int n3 = this.map_pos_y - this.map_pos_y / 16 * 16;
        int n4 = 9;
        int n5 = 0;
        while (n4 > 0) {
            int n6 = 9;
            int n7 = 0;
            while (n6 > 0) {
                if (n7 + this.map_pos_x / 16 < 22 && n5 + this.map_pos_y / 16 < 16) {
                    int n8 = this.map_info[n5 + this.map_pos_y / 16][n7 + this.map_pos_x / 16] % 6;
                    int n9 = this.map_info[n5 + this.map_pos_y / 16][n7 + this.map_pos_x / 16] / 6;
                    if (n8 != 4 || n9 != 2) {
                        graphics.setClip(n7 * 16 - n2, n5 * 16 - n3, 16, 16);
                        graphics.drawImage(this.image_bg, n7 * 16 - n2 - n8 * 16, n5 * 16 - n3 - n9 * 16, 20);
                    }
                }
                --n6;
                ++n7;
            }
            --n4;
            ++n5;
        }
        if (this.stage_no != 2) {
            this.Object_Springbed.Draw_Springbed(graphics);
        }
        for (n = 0; n < PSEUDOITEM_NUM[this.stage_no]; ++n) {
            this.Object_PseudoItem[n].Draw_PseudoItem(graphics);
        }
        for (n = 0; n < FRUIT_NUM[this.stage_no]; ++n) {
            this.Object_Fruit[n].Draw_Fruit(graphics);
        }
        for (n = 0; n < WOMAN_NUM[this.stage_no]; ++n) {
            this.Object_Woman[n].Draw_Woman(graphics);
        }
        for (n = 0; n < MAN_NUM[this.stage_no]; ++n) {
            this.Object_Man[n].Draw_Man(graphics);
        }
        this.Object_Hero.Draw(graphics);
        int n10 = 6;
        for (n = 0; n < this.Object_Hero.hero_lives; ++n) {
            graphics.setClip(n10, 6, 16, 12);
            graphics.drawImage(this.image_bg, n10 - 8, -26, 20);
            n10 += 16;
        }
        n10 = 64;
        graphics.setClip(n10, 2, 16, 16);
        graphics.drawImage(this.framework.image_fruit, n10, 0, 20);
        graphics.setClip(n10 += 22, 4, 12, 12);
        graphics.drawImage(this.image_score, n10 - this.Object_Hero.hero_fruits * 12, 4, 20);
        graphics.setClip(n10 += 12, 4, 12, 12);
        graphics.drawImage(this.image_score, n10 - 120, 4, 20);
        graphics.setClip(n10 += 12, 4, 12, 12);
        graphics.drawImage(this.image_score, n10 - FRUIT_NUM[this.stage_no] * 12, 4, 20);
        if (this.framework.bPause) {
            graphics.setClip(0, 0, 128, 128);
            graphics.setColor(0);
            graphics.drawString("\u6682\u505c", 48, 56, 17);
        }
    }

    public void init_gamemenu() {
        this.gamemenu_index = 0;
        try {
            this.framework.image_menuarw = Image.createImage((String)"/MENU_ARW.PNG");
        }
        catch (Exception exception) {
            System.out.println("************");
        }
    }

    public void release_gamemenu() {
        this.framework.image_menuarw = null;
    }

    public void running_gamemenu() {
        ++this.framework.menu_counter;
    }

    public void draw_gamemenu(Graphics graphics) {
        this.draw_main(graphics);
        graphics.setClip(0, 0, 128, 128);
        graphics.setColor(0);
        graphics.drawString("\u56de\u5230\u6e38\u620f", 64, 30, 17);
        String string = "\u97f3\u4e50 ";
        string = this.framework.sound_enable == 1 ? string + " \u5f00" : string + " \u5173";
        graphics.drawString(string, 64, 46, 17);
        graphics.drawString("\u5e2e\u52a9", 64, 62, 17);
        graphics.drawString("\u56de\u5230\u83dc\u5355", 64, 78, 17);
        int n = 14;
        int n2 = 30 + this.gamemenu_index * 16;
        graphics.setClip(n, n2, 16, 32);
        if (this.framework.menu_counter % 8 < 4) {
            graphics.drawImage(this.framework.image_menuarw, n - 16, n2 - 0, 20);
        } else {
            graphics.drawImage(this.framework.image_menuarw, n - 0, n2 - 0, 20);
        }
    }

    private void init_gameover() {
        this.time_clock = 0;
    }

    private void release_gameover() {
        this.release_stage(this.stage_no);
        this.map_pos_x = 0;
        this.map_pos_y = 0;
        this.hero_pos_x = 0;
        this.hero_pos_y = 0;
        this.image_buffer = null;
        this.image_bg = null;
        this.image_hero = null;
        this.image_woman = null;
        this.image_man = null;
        this.image_pseudoitem = null;
        this.image_tree = null;
        this.image_sapling = null;
        this.image_rabbit = null;
        this.image_score = null;
        this.image_load = null;
        this.image_loadform = null;
        this.image_letter2 = null;
    }

    private void running_gameover() {
        ++this.time_clock;
        if (this.time_clock == 24) {
            this.state_new = 72;
        }
    }

    private void draw_gameover(Graphics graphics) {
        this.draw_main(graphics);
        if (this.time_clock % 8 < 6) {
            int n = 32;
            int n2 = 64;
            graphics.setClip(0, 0, 128, 128);
            graphics.setColor(0);
            graphics.drawString("\u6e38\u620f\u7ed3\u675f", n, n, 17);
        }
    }

    private void init_win() {
        this.time_clock = 0;
        if (this.stage_no == 7) {
            this.image_buffer = null;
            this.image_bg = null;
            this.image_hero = null;
            this.image_woman = null;
            this.image_man = null;
            this.image_pseudoitem = null;
            this.image_tree = null;
            this.image_sapling = null;
            this.image_rabbit = null;
            this.image_score = null;
            this.image_load = null;
            this.image_loadform = null;
            try {
                this.image_letter2 = Image.createImage((String)"/LETTER2.PNG");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void release_win() {
        if (this.stage_no == 7) {
            this.release_stage(this.stage_no);
            this.stage_no = 0;
            this.image_letter2 = null;
        }
        if (this.stage_no < 7) {
            this.release_stage(this.stage_no);
            this.stage_no = (byte)(this.stage_no + 1);
        }
        this.map_pos_x = 0;
        this.map_pos_y = 0;
        this.hero_pos_x = 0;
        this.hero_pos_y = 0;
        this.image_buffer = null;
        this.image_bg = null;
        this.image_hero = null;
        this.image_woman = null;
        this.image_man = null;
        this.image_pseudoitem = null;
        this.image_tree = null;
        this.image_sapling = null;
        this.image_rabbit = null;
        this.image_score = null;
        this.image_load = null;
        this.image_loadform = null;
        this.image_letter2 = null;
    }

    private void running_win() {
        ++this.time_clock;
        if (this.stage_no < 7 && this.time_clock == 30) {
            this.state_new = 65;
        }
    }

    private void draw_win(Graphics graphics) {
        if (this.stage_no == 7) {
            graphics.setClip(0, 0, 128, 128);
            graphics.setColor(34816);
            graphics.fillRect(0, 0, 128, 128);
            int n = 19;
            if (this.time_clock <= 218) {
                int n2 = 128 - this.time_clock;
                graphics.setClip(n, n2, 31, 15);
                graphics.drawImage(this.image_letter2, n - 0, n2 - 0, 20);
                graphics.setClip(n + 31 + 10, n2, 33, 15);
                graphics.drawImage(this.image_letter2, n + 31 + 10 - 31, n2, 20);
                graphics.setClip(n, n2 += 25, 31, 15);
                graphics.drawImage(this.image_letter2, n - 64, n2 - 0, 20);
                graphics.setClip(n + 31 + 10, n2, 49, 15);
                graphics.drawImage(this.image_letter2, n + 31 + 10 - 95, n2, 20);
                graphics.setClip(n, n2 += 25, 33, 15);
                graphics.drawImage(this.image_letter2, n - 144, n2 - 0, 20);
                graphics.setClip(n + 33 + 10, n2, 33, 15);
                graphics.drawImage(this.image_letter2, n + 33 + 10 - 177, n2, 20);
                graphics.setClip(n, n2 += 25, 34, 15);
                graphics.drawImage(this.image_letter2, n - 210, n2 - 0, 20);
                graphics.setClip(n + 34 + 10, n2, 49, 15);
                graphics.drawImage(this.image_letter2, n + 34 + 10 - 244, n2, 20);
            } else {
                this.state_new = 72;
                this.image_letter2 = null;
            }
        } else {
            this.draw_main(graphics);
            if (this.time_clock % 8 < 6) {
                int n = 33;
                int n3 = 56;
                graphics.setClip(0, 0, 128, 128);
                graphics.setColor(0);
                graphics.drawString("\u8fc7  \u5173", n, n, 20);
            }
        }
    }

    public void keyPressed(int n) {
        if (this.state == 65) {
            return;
        }
        if (this.state == 70) {
            switch (n) {
                case -1: {
                    --this.gamemenu_index;
                    if (this.gamemenu_index >= 0) break;
                    this.gamemenu_index = 3;
                    break;
                }
                case -2: {
                    ++this.gamemenu_index;
                    if (this.gamemenu_index != 4) break;
                    this.gamemenu_index = 0;
                    break;
                }
                case -6: 
                case -5: {
                    if (this.gamemenu_index == 1) {
                        if (this.framework.sound_enable == 1) {
                            this.framework.sound_enable = 0;
                            try {
                                this.sound_player.stop();
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        if (this.framework.sound_enable != 0) break;
                        this.framework.sound_enable = 1;
                        break;
                    }
                    this.state_new = GAMEMENU_ITEM_STATE[this.gamemenu_index];
                    break;
                }
            }
            return;
        }
        if (this.state == 80) {
            switch (n) {
                case -1: {
                    if (this.framework.help_row <= 0) break;
                    this.framework.help_row = (byte)(this.framework.help_row - 1);
                    break;
                }
                case -2: {
                    if (this.framework.help_row >= 31) break;
                    this.framework.help_row = (byte)(this.framework.help_row + 1);
                    break;
                }
                case -7: {
                    this.state_new = 70;
                }
            }
            return;
        }
        if (this.state == 67) {
            this.state_new = this.stage_no == 7 ? 72 : 65;
        } else if (this.state == 73) {
            if (n == -6) {
                this.state_new = 71;
            }
        } else if (this.state == 71) {
            if (n == -6) {
                this.state_new = 66;
            }
        } else if (this.state == 67) {
            if (n == -6) {
                this.state_new = this.stage_no == 7 ? 72 : 65;
            }
        } else if (this.state == 68) {
            if (n == -6) {
                this.state_new = 72;
            }
        } else {
            switch (n) {
                case -1: 
                case 50: {
                    this.keyMove |= 1;
                    break;
                }
                case -2: 
                case 56: {
                    this.keyMove |= 0x10;
                    break;
                }
                case -3: 
                case 52: {
                    this.keyMove |= 0x100;
                    break;
                }
                case -4: 
                case 54: {
                    this.keyMove |= 0x1000;
                    break;
                }
                case -5: {
                    switch (this.state_new) {
                        case 73: {
                            this.state_new = 71;
                            break;
                        }
                        case 71: {
                            this.state_new = 66;
                            break;
                        }
                        case 67: {
                            if (this.stage_no == 7) {
                                this.state_new = 72;
                                break;
                            }
                            this.state_new = 65;
                            break;
                        }
                        case 68: {
                            this.state_new = 72;
                        }
                    }
                    break;
                }
                case -6: {
                    if (this.framework.bPause) break;
                    this.state_new = 70;
                    break;
                }
                case -7: {
                    if (this.state_new == 70) break;
                    if (this.framework.bPause) {
                        this.framework.bPause = false;
                        this.sound_update();
                        this.state_new = 66;
                        break;
                    }
                    this.framework.bPause = true;
                    this.sound_stop();
                }
            }
        }
    }

    public void keyRelease(int n) {
        if (this.state == 65) {
            return;
        }
        switch (n) {
            case -1: 
            case 50: {
                this.keyMove &= 0xFFFE;
                break;
            }
            case -2: 
            case 56: {
                this.keyMove &= 0xFFEF;
                break;
            }
            case -3: 
            case 52: {
                this.keyMove &= 0xFEFF;
                break;
            }
            case -4: 
            case 54: {
                this.keyMove &= 0xEFFF;
            }
        }
    }

    public void sound_init() {
        try {
            this.sound_player = new Sound(sound_data, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sound_release() {
        this.sound_player = null;
    }

    public void sound_update() {
        if (this.sound_player.getState() != 0 && this.framework.sound_enable == 1) {
            try {
                this.sound_player.play(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sound_stop() {
        if (this.framework.sound_enable == 1) {
            try {
                this.sound_player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class CSpringbed {
        int SpringBed_MapPosX;
        int SpringBed_MapPosY;
        byte SpringBed_State = 0;
        byte anim_no = 0;

        public void InitSpringbed(byte by, byte by2) {
            this.SpringBed_MapPosX = by * 16;
            this.SpringBed_MapPosY = by2 * 16;
            this.SpringBed_State = 0;
        }

        public void Springbed_Update() {
            if (GameLogic.this.hero_pos_x >= this.SpringBed_MapPosX + 16 && GameLogic.this.hero_pos_x <= this.SpringBed_MapPosX + 16 + 32) {
                if (GameLogic.this.Object_Hero.hero_state == 5) {
                    if (GameLogic.this.hero_pos_y + 17 >= this.SpringBed_MapPosY - 1 && GameLogic.this.hero_pos_y + 17 <= this.SpringBed_MapPosY + 3) {
                        this.SpringBed_State = 1;
                    } else if (GameLogic.this.hero_pos_y + 17 <= this.SpringBed_MapPosY + 6 && GameLogic.this.hero_pos_y + 17 > this.SpringBed_MapPosY) {
                        this.SpringBed_State = (byte)2;
                    } else if (GameLogic.this.hero_pos_y + 17 <= this.SpringBed_MapPosY + 16 && GameLogic.this.hero_pos_y + 17 >= this.SpringBed_MapPosY + 6) {
                        GameLogic.this.Object_Hero.hero_state = (byte)6;
                    }
                } else if (GameLogic.this.Object_Hero.hero_state == 6) {
                    this.SpringBed_State = GameLogic.this.hero_pos_y + 17 > this.SpringBed_MapPosY && GameLogic.this.hero_pos_y + 17 <= this.SpringBed_MapPosY + 6 ? (byte)3 : (GameLogic.this.hero_pos_y + 17 >= this.SpringBed_MapPosY + 6 && GameLogic.this.hero_pos_y + 17 <= this.SpringBed_MapPosY ? (byte)4 : (byte)0);
                }
            }
            for (int i = 0; i < GameLogic.this.Object_Woman.length; ++i) {
                if (GameLogic.this.Object_Woman[i].woman_map_pos_x < this.SpringBed_MapPosX + 16 || GameLogic.this.Object_Woman[i].woman_map_pos_x > this.SpringBed_MapPosX + 16 + 32) continue;
                if (GameLogic.this.Object_Woman[i].woman_State == 5) {
                    if (GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 >= this.SpringBed_MapPosY - 4 && GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 < this.SpringBed_MapPosY) {
                        this.SpringBed_State = 1;
                    } else if (GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 <= this.SpringBed_MapPosY + 6 && GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 >= this.SpringBed_MapPosY) {
                        this.SpringBed_State = (byte)2;
                    } else if (GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 <= this.SpringBed_MapPosY + 16 && GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 >= this.SpringBed_MapPosY + 4) {
                        GameLogic.this.Object_Woman[i].woman_State = (byte)4;
                    }
                }
                if (GameLogic.this.Object_Woman[i].woman_State != 4) continue;
                this.SpringBed_State = GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 > this.SpringBed_MapPosY && GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 <= this.SpringBed_MapPosY + 6 ? (byte)3 : (GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 >= this.SpringBed_MapPosY - 4 && GameLogic.this.Object_Woman[i].woman_map_pos_y + 16 <= this.SpringBed_MapPosY ? (byte)4 : (byte)0);
            }
            if (this.SpringBed_State == 0) {
                this.anim_no = (byte)(this.anim_no + 1);
                if (this.anim_no > 19) {
                    this.anim_no = 0;
                }
            }
        }

        public void Draw_Springbed(Graphics graphics) {
            int n = this.SpringBed_MapPosX - GameLogic.this.map_pos_x + 16;
            int n2 = this.SpringBed_MapPosY - GameLogic.this.map_pos_y;
            if (n + 32 < 0 || n > 128 || n2 + 16 < 0 || n2 > 128) {
                return;
            }
            switch (this.SpringBed_State) {
                case 0: {
                    graphics.setClip(n, n2, 32, 16);
                    graphics.drawImage(GameLogic.this.image_rabbit, n - 32 * (this.anim_no / 5), n2, 20);
                    break;
                }
                case 1: {
                    graphics.setClip(n, n2, 32, 16);
                    graphics.drawImage(GameLogic.this.image_rabbit, n - 0, n2 - 16, 20);
                    break;
                }
                case 2: {
                    graphics.setClip(n, n2, 32, 16);
                    graphics.drawImage(GameLogic.this.image_rabbit, n - 32, n2 - 16, 20);
                    break;
                }
                case 3: {
                    graphics.setClip(n, n2, 32, 16);
                    graphics.drawImage(GameLogic.this.image_rabbit, n - 64, n2 - 16, 20);
                    break;
                }
                case 4: {
                    graphics.setClip(n, n2, 32, 16);
                    graphics.drawImage(GameLogic.this.image_rabbit, n - 96, n2 - 16, 20);
                }
            }
        }
    }

    class CFruit {
        int fruit_map_pos_x;
        int fruit_map_pos_y;
        byte fruit_type;
        byte fruit_state = 0;
        byte jump_way;
        byte anim = 0;
        byte step_no = 0;
        byte cfruit_tiaoz = 1;

        public void InitFruit(byte by, byte by2, byte by3) {
            this.fruit_map_pos_x = by * 16;
            this.fruit_map_pos_y = by2 * 16;
            this.fruit_type = by3;
            this.fruit_state = 0;
        }

        public void Fruit_State() {
            if (this.fruit_state == 0 && this.fruit_state != 1 && GameLogic.this.hero_pos_x >= this.fruit_map_pos_x - 8 && GameLogic.this.hero_pos_x <= this.fruit_map_pos_x + 8 && GameLogic.this.hero_pos_y == this.fruit_map_pos_y) {
                if (GameLogic.this.hero_pos_x >= this.fruit_map_pos_x - 8 && GameLogic.this.hero_pos_x <= this.fruit_map_pos_x) {
                    this.jump_way = 1;
                } else if (GameLogic.this.hero_pos_x <= this.fruit_map_pos_x + 8 && GameLogic.this.hero_pos_x >= this.fruit_map_pos_x) {
                    this.jump_way = 0;
                }
                this.fruit_state = 1;
                GameLogic.this.Object_Hero.hero_fruits = (byte)(GameLogic.this.Object_Hero.hero_fruits + 1);
            }
        }

        public void Fruit_Update() {
            this.Fruit_State();
            if (this.fruit_state == 0) {
                this.anim = (byte)(this.anim + 1);
                if (this.anim > 9) {
                    this.anim = 0;
                }
            } else if (this.fruit_state == 1) {
                this.step_no = (byte)(this.step_no + 1);
                if (this.jump_way == 1) {
                    if (this.step_no < 8) {
                        ++this.fruit_map_pos_x;
                        this.fruit_map_pos_y -= 2;
                    } else if (this.step_no >= 8) {
                        this.fruit_map_pos_y += 4;
                    }
                } else if (this.jump_way == 0) {
                    if (this.step_no < 8) {
                        --this.fruit_map_pos_x;
                        this.fruit_map_pos_y -= 2;
                    } else if (this.step_no >= 8) {
                        this.fruit_map_pos_y += 8;
                    }
                }
                if (this.step_no > 10) {
                    this.step_no = 0;
                    this.fruit_state = (byte)2;
                }
            } else if (this.fruit_state == 2) {
                // empty if block
            }
        }

        public void Draw_Fruit(Graphics graphics) {
            this.cfruit_tiaoz = 1;
            if (this.fruit_map_pos_y == 224) {
                this.cfruit_tiaoz = 0;
            }
            int n = this.fruit_map_pos_x - GameLogic.this.map_pos_x;
            int n2 = this.fruit_map_pos_y - GameLogic.this.map_pos_y + 8 * this.cfruit_tiaoz;
            if (n + 16 < 0 || n > 128 || n2 + 16 < 0 || n2 > 128) {
                return;
            }
            if (this.fruit_state == 0) {
                switch (this.fruit_type) {
                    case 0: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 16 * (this.anim / 5), n2, 20);
                        break;
                    }
                    case 1: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 64 - 16 * (this.anim / 5), n2, 20);
                        break;
                    }
                    case 2: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 96 - 16 * (this.anim / 5), n2, 20);
                        break;
                    }
                    case 3: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 16 * (this.anim / 5), n2 - 16, 20);
                        break;
                    }
                    case 4: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 32 - 16 * (this.anim / 5), n2, 20);
                        break;
                    }
                    case 5: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 64 - 16 * (this.anim / 5), n2 - 16, 20);
                        break;
                    }
                    case 6: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 96 - 16 * (this.anim / 5), n2 - 16, 20);
                        break;
                    }
                    case 7: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 32 - 16 * (this.anim / 5), n2 - 16, 20);
                    }
                }
            } else if (this.fruit_state == 1) {
                switch (this.fruit_type) {
                    case 0: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n, n2 - 32, 20);
                        break;
                    }
                    case 1: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 32, n2 - 32, 20);
                        break;
                    }
                    case 2: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 48, n2 - 32, 20);
                        break;
                    }
                    case 4: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 16, n2 - 32, 20);
                        break;
                    }
                    case 3: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 64, n2 - 32, 20);
                        break;
                    }
                    case 5: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 96, n2 - 32, 20);
                        break;
                    }
                    case 6: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 112, n2 - 32, 20);
                        break;
                    }
                    case 7: {
                        graphics.setClip(n, n2, 16, 16);
                        graphics.drawImage(((GameLogic)GameLogic.this).framework.image_fruit, n - 80, n2 - 32, 20);
                    }
                }
            } else if (this.fruit_state == 2) {
                // empty if block
            }
        }
    }

    class CPseudoItem {
        int PseudoItem_Map_Pos_X;
        int PseudoItem_Map_Pos_Y;
        byte pi_type;
        byte pi_anim_no = 0;
        byte PseudoItem_tiaoz = 1;

        public void InitPseudoItem(byte by, byte by2, byte by3) {
            this.PseudoItem_Map_Pos_X = by * 16;
            this.PseudoItem_Map_Pos_Y = by2 * 16;
            this.pi_type = by3;
        }

        public void Draw_PseudoItem(Graphics graphics) {
            this.PseudoItem_tiaoz = 1;
            if (this.PseudoItem_Map_Pos_Y == 224) {
                this.PseudoItem_tiaoz = 0;
            }
            int n = this.PseudoItem_Map_Pos_X - GameLogic.this.map_pos_x;
            int n2 = this.PseudoItem_Map_Pos_Y - GameLogic.this.map_pos_y + 8 * this.PseudoItem_tiaoz;
            if (this.pi_type == 0 ? n + 48 < 0 || n > 128 || n2 + 64 < 0 || n2 > 128 : (this.pi_type == 1 || this.pi_type == 2 ? n + 32 < 0 || n > 128 || n2 + 32 < 0 || n2 > 128 : (this.pi_type == 3 || this.pi_type == 4 ? n + 32 < 0 || n > 128 || n2 + 13 < 0 || n2 > 128 : (this.pi_type == 9 ? n + 32 < 0 || n > 128 || n2 + 13 < 0 || n2 > 128 : n + 16 < 0 || n > 128 || n2 + 13 < 0 || n2 > 128)))) {
                return;
            }
            switch (this.pi_type) {
                case 0: {
                    graphics.setClip(n, n2, 48, 64);
                    graphics.drawImage(GameLogic.this.image_tree, n, n2, 20);
                    break;
                }
                case 2: {
                    graphics.setClip(n, n2, 32, 32);
                    graphics.drawImage(GameLogic.this.image_sapling, n, n2, 20);
                    break;
                }
                case 1: {
                    graphics.setClip(n, n2, 32, 32);
                    graphics.drawImage(GameLogic.this.image_sapling, n - 32, n2, 20);
                    break;
                }
                case 3: {
                    graphics.setClip(n, n2 + 4, 32, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 0, n2 + 4, 20);
                    break;
                }
                case 4: {
                    graphics.setClip(n, n2 + 4, 32, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 32, n2 + 4, 20);
                    break;
                }
                case 6: {
                    graphics.setClip(n, n2 + 4, 16, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 64, n2 + 4, 20);
                    break;
                }
                case 5: {
                    graphics.setClip(n, n2 + 4, 16, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 80, n2 + 4, 20);
                    break;
                }
                case 7: {
                    graphics.setClip(n, n2 + 4, 16, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 96, n2 + 4, 20);
                    break;
                }
                case 8: {
                    graphics.setClip(n, n2 + 4, 16, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 112, n2 + 4, 20);
                    break;
                }
                case 9: {
                    graphics.setClip(n, n2 + 4, 32, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 128, n2 + 4, 20);
                    break;
                }
                case 10: {
                    graphics.setClip(n, n2 + 4, 16, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 160, n2 + 4, 20);
                    break;
                }
                case 11: {
                    this.pi_anim_no = (byte)(this.pi_anim_no + 1);
                    if (this.pi_anim_no >= 40) {
                        this.pi_anim_no = 0;
                    }
                    graphics.setClip(n, n2, 16, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 16 * (11 + this.pi_anim_no / 10), n2, 20);
                    break;
                }
                case 12: {
                    graphics.setClip(n, n2 + 4, 15, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 240, n2 + 4, 20);
                    break;
                }
                case 13: {
                    graphics.setClip(n, n2 + 4, 10, 13);
                    graphics.drawImage(GameLogic.this.image_pseudoitem, n - 255, n2 + 4, 20);
                }
            }
        }
    }

    class CMan {
        int man_map_pos_x;
        int man_map_pos_y;
        byte man_state = 0;
        byte step_no = 0;
        byte anim = 0;
        byte anim1 = 0;
        byte wait_time = 0;
        byte man_tiaoz = 1;

        public void InitMan(byte by, byte by2) {
            this.man_map_pos_x = by * 16;
            this.man_map_pos_y = by2 * 16;
            this.man_state = 0;
        }

        public void Man_State() {
            if (this.man_map_pos_y == 224) {
                this.man_tiaoz = 0;
            }
            if (this.man_map_pos_x < 0) {
                this.man_map_pos_x = 0;
                this.man_state = (byte)3;
            } else if (this.man_map_pos_x > 336) {
                this.man_map_pos_x = 336;
                this.man_state = (byte)2;
            }
            if (GameLogic.this.stage_no != 2) {
                if (this.man_map_pos_x + 16 > GameLogic.this.Object_Springbed.SpringBed_MapPosX && this.man_map_pos_x + 16 <= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 8) {
                    this.man_map_pos_x = this.man_map_pos_x / 16 * 16;
                    this.man_state = (byte)2;
                } else if (this.man_map_pos_x >= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 64 - 8 && this.man_map_pos_x < GameLogic.this.Object_Springbed.SpringBed_MapPosX + 64) {
                    this.man_map_pos_x = (this.man_map_pos_x / 16 + 1) * 16;
                    this.man_state = (byte)3;
                }
            }
            for (int i = 0; i < GameLogic.this.Object_Woman.length; ++i) {
                if (GameLogic.this.Object_Woman[i].woman_map_pos_y != this.man_map_pos_y) continue;
                if (GameLogic.this.Object_Woman[i].woman_State == 0 && this.man_state == 1 && GameLogic.this.Object_Woman[i].woman_map_pos_x + 16 >= this.man_map_pos_x - 2 && GameLogic.this.Object_Woman[i].woman_map_pos_x + 16 <= this.man_map_pos_x + 2) {
                    GameLogic.this.Object_Woman[i].woman_State = 1;
                    this.man_state = 0;
                    continue;
                }
                if (GameLogic.this.Object_Woman[i].woman_State == 1 && this.man_state == 0 && GameLogic.this.Object_Woman[i].woman_map_pos_x - 16 >= this.man_map_pos_x - 2 && GameLogic.this.Object_Woman[i].woman_map_pos_x - 16 <= this.man_map_pos_x + 2) {
                    GameLogic.this.Object_Woman[i].woman_State = 0;
                    this.man_state = 1;
                    continue;
                }
                if (GameLogic.this.Object_Woman[i].woman_State == 1 && this.man_state == 1 && GameLogic.this.Object_Woman[i].woman_map_pos_x + 16 >= this.man_map_pos_x - 2 && GameLogic.this.Object_Woman[i].woman_map_pos_x + 16 <= this.man_map_pos_x + 2) {
                    GameLogic.this.Object_Woman[i].woman_State = 1;
                    this.man_state = 0;
                    continue;
                }
                if (GameLogic.this.Object_Woman[i].woman_State == 0 && this.man_state == 0 && GameLogic.this.Object_Woman[i].woman_map_pos_x - 16 >= this.man_map_pos_x - 2 && GameLogic.this.Object_Woman[i].woman_map_pos_x - 16 <= this.man_map_pos_x + 2) {
                    GameLogic.this.Object_Woman[i].woman_State = 0;
                    this.man_state = 1;
                    continue;
                }
                if (GameLogic.this.Object_Woman[i].woman_map_pos_x - 16 >= this.man_map_pos_x + 6 && GameLogic.this.Object_Woman[i].woman_map_pos_x - 16 <= this.man_map_pos_x) {
                    GameLogic.this.Object_Woman[i].woman_State = 0;
                    this.man_state = 1;
                    continue;
                }
                if (GameLogic.this.Object_Woman[i].woman_map_pos_x + 16 < this.man_map_pos_x || GameLogic.this.Object_Woman[i].woman_map_pos_x + 16 > this.man_map_pos_x + 6) continue;
                GameLogic.this.Object_Woman[i].woman_State = 1;
                this.man_state = 0;
            }
        }

        public void Man_Hero_Hit() {
            if (GameLogic.this.hero_pos_x >= this.man_map_pos_x - 8 && GameLogic.this.hero_pos_x <= this.man_map_pos_x + 8 && GameLogic.this.hero_pos_y >= this.man_map_pos_y - 18 && GameLogic.this.hero_pos_y <= this.man_map_pos_y && GameLogic.this.Object_Hero.hero_state != 9) {
                GameLogic.this.Object_Hero.hero_state = (byte)9;
                GameLogic.this.Object_Hero.hero_lives = (byte)(GameLogic.this.Object_Hero.hero_lives - 1);
                GameLogic.this.hero_pos_x = HERO_POS[GameLogic.this.stage_no][0] * 16;
                GameLogic.this.hero_pos_y = HERO_POS[GameLogic.this.stage_no][1] * 16;
            }
        }

        public void Man_Update() {
            this.Man_State();
            this.Man_Hero_Hit();
            switch (this.man_state) {
                case 0: {
                    this.step_no = (byte)(this.step_no + 1);
                    this.anim = (byte)(this.anim + 1);
                    if (this.anim > 3) {
                        this.anim = 0;
                    }
                    this.man_map_pos_x += 6;
                    break;
                }
                case 2: {
                    this.step_no = 0;
                    this.wait_time = (byte)(this.wait_time + 1);
                    this.anim1 = (byte)(this.anim1 + 1);
                    if (this.anim1 > 20) {
                        this.anim1 = 0;
                    }
                    if (this.wait_time <= 20) break;
                    this.wait_time = 0;
                    this.man_state = 1;
                    break;
                }
                case 1: {
                    this.step_no = (byte)(this.step_no + 1);
                    this.anim = (byte)(this.anim + 1);
                    if (this.anim > 3) {
                        this.anim = 0;
                    }
                    this.man_map_pos_x -= 6;
                    break;
                }
                case 3: {
                    this.step_no = 0;
                    this.wait_time = (byte)(this.wait_time + 1);
                    this.anim1 = (byte)(this.anim1 + 1);
                    if (this.anim1 > 20) {
                        this.anim1 = 0;
                    }
                    if (this.wait_time <= 20) break;
                    this.wait_time = 0;
                    this.man_state = 0;
                }
            }
        }

        public void Draw_Man(Graphics graphics) {
            int n = this.man_map_pos_x - GameLogic.this.map_pos_x;
            int n2 = this.man_map_pos_y - GameLogic.this.map_pos_y + 8 * this.man_tiaoz;
            if (n + 16 < 0 || n > 128 || n2 + 18 < 0 || n2 > 128) {
                return;
            }
            switch (this.man_state) {
                case 0: {
                    graphics.setClip(n, n2, 16, 18);
                    graphics.drawImage(GameLogic.this.image_man, n - 16 * this.anim, n2 - 18, 20);
                    break;
                }
                case 2: {
                    if (this.anim1 <= 5 && this.anim1 >= 0 || this.anim1 <= 15 && this.anim1 >= 10) {
                        graphics.setClip(n, n2, 16, 18);
                        graphics.drawImage(GameLogic.this.image_man, n - 64, n2, 20);
                        break;
                    }
                    graphics.setClip(n, n2, 16, 18);
                    graphics.drawImage(GameLogic.this.image_man, n - 64, n2 - 18, 20);
                    break;
                }
                case 1: {
                    graphics.setClip(n, n2, 16, 18);
                    graphics.drawImage(GameLogic.this.image_man, n - 16 * this.anim, n2, 20);
                    break;
                }
                case 3: {
                    if (this.anim1 <= 5 && this.anim1 >= 0 || this.anim1 <= 15 && this.anim1 >= 10) {
                        graphics.setClip(n, n2, 16, 18);
                        graphics.drawImage(GameLogic.this.image_man, n - 64, n2, 20);
                        break;
                    }
                    graphics.setClip(n, n2, 16, 18);
                    graphics.drawImage(GameLogic.this.image_man, n - 64, n2 - 18, 20);
                }
            }
        }
    }

    class CWoman {
        int woman_map_pos_x;
        int woman_map_pos_y;
        byte woman_State = 0;
        int map_x;
        int map_y;
        byte woman_step_no = 0;
        byte step_no1 = 0;
        byte step_no2 = 0;
        byte step_no3 = 0;
        byte anim = 0;
        byte anim1 = 0;
        byte anim2 = 0;
        byte wait_time = 0;
        byte wait_time1 = 0;
        int woman_way;
        int woman_way1;
        int woman_way3;
        int woman_way2;
        byte woman_usd1 = 0;
        byte woman_usd2 = 0;
        byte woman_usd3 = 0;
        byte woman_dsd = 0;
        byte woman_dsd1 = 0;
        byte woman_dsd2 = 0;
        byte woman_tz = 0;
        byte woman_tz2 = 0;
        byte woman_tiaoz = 1;

        public void InitWoman(byte by, byte by2) {
            this.woman_map_pos_x = by * 16;
            this.woman_map_pos_y = by2 * 16;
            this.woman_State = 0;
        }

        public void Woman_State() {
            this.map_x = this.woman_map_pos_x / 16;
            this.map_y = this.woman_map_pos_y / 16;
            this.woman_usd1 = 0;
            this.woman_usd2 = 0;
            this.woman_dsd = 0;
            this.woman_dsd1 = 0;
            this.woman_dsd2 = 0;
            this.woman_usd3 = 0;
            this.woman_tz = 0;
            this.woman_tz2 = 0;
            this.woman_tiaoz = 1;
            if (this.woman_map_pos_y == 224) {
                this.woman_tiaoz = 0;
            }
            if (this.woman_map_pos_y < 224 && this.woman_map_pos_y > 16 && this.woman_map_pos_x > 16 && this.woman_map_pos_x < 336) {
                int n;
                for (n = 0; n < MAP_UPGND_ID.length; ++n) {
                    if (GameLogic.this.map_info[this.map_y + 1][this.map_x] == MAP_UPGND_ID[n]) {
                        this.woman_usd1 = 1;
                    }
                    if (GameLogic.this.map_info[this.map_y + 1][this.map_x + 1] == MAP_UPGND_ID[n]) {
                        this.woman_usd2 = 1;
                    }
                    if (GameLogic.this.map_info[this.map_y + 1][this.map_x - 1] == MAP_UPGND_ID[n]) {
                        this.woman_usd3 = 1;
                    }
                    if (GameLogic.this.map_info[this.map_y + 2][this.map_x] == MAP_DOWNGND_ID[n]) {
                        this.woman_dsd2 = 1;
                    }
                    if (GameLogic.this.map_info[this.map_y][this.map_x] == MAP_DOWNGND_ID[n]) {
                        this.woman_dsd = 1;
                    }
                    if (GameLogic.this.map_info[this.map_y][this.map_x + 1] != MAP_DOWNGND_ID[n]) continue;
                    this.woman_dsd1 = 1;
                }
                if (this.woman_map_pos_y < 256 && this.woman_map_pos_y > 0 && this.woman_map_pos_x >= 0 && this.woman_map_pos_x < 352) {
                    for (n = 0; n < MAP_LADDER_ID.length; ++n) {
                        if (GameLogic.this.map_info[this.map_y][this.map_x] == MAP_LADDER_ID[n]) {
                            this.woman_tz = 1;
                        }
                        if (this.woman_map_pos_y >= 224 || GameLogic.this.map_info[this.map_y + 2][this.map_x] != MAP_LADDER_ID[n]) continue;
                        this.woman_tz2 = 1;
                    }
                }
                if (this.woman_map_pos_y < 224 && this.woman_map_pos_y > 0 && this.woman_map_pos_x >= 0 && this.woman_map_pos_x < 352) {
                    for (n = 0; n < MAP_UPGND_ID.length; ++n) {
                        if (GameLogic.this.map_info[this.map_y + 1][this.map_x] != MAP_UPGND_ID[n]) continue;
                        this.woman_usd1 = 1;
                    }
                }
                if ((this.woman_State == 1 || this.woman_State == 0) && this.woman_map_pos_x < 336 && this.woman_map_pos_y < 224 && this.woman_map_pos_x > 16 && this.woman_map_pos_y > 16) {
                    if (this.woman_map_pos_x == this.map_x * 16) {
                        if (this.woman_usd1 == 0 && this.woman_tz == 0) {
                            this.woman_State = (byte)5;
                        }
                    } else if (this.woman_usd1 == 0 && this.woman_usd2 == 0) {
                        this.woman_State = (byte)5;
                    }
                }
                if (this.woman_map_pos_x > 336) {
                    this.woman_map_pos_x = 336;
                    if (this.woman_State == 0) {
                        this.woman_State = (byte)7;
                    } else if (this.woman_State == 2) {
                        this.woman_State = (byte)5;
                    }
                } else if (this.woman_map_pos_x < 0) {
                    this.woman_map_pos_x = 0;
                    if (this.woman_State == 1) {
                        this.woman_State = (byte)6;
                    } else if (this.woman_State == 3) {
                        this.woman_State = (byte)5;
                    }
                }
                if (this.woman_map_pos_y > 224) {
                    this.woman_map_pos_y = 224;
                    this.woman_State = (byte)8;
                } else if (this.woman_map_pos_y <= 0) {
                    this.woman_map_pos_y = 0;
                    this.woman_State = (byte)5;
                }
                if (this.woman_map_pos_y < 224 && this.woman_map_pos_x < 336 && this.woman_map_pos_x > 16 && this.woman_map_pos_y > 16) {
                    if (this.woman_usd2 == 1 && GameLogic.this.map_info[this.map_y + 1][this.map_x] == MAP_NULL_ID[0] && (this.woman_State == 0 || this.woman_State == 2)) {
                        this.woman_map_pos_y = this.map_y * 16;
                    } else if (this.woman_usd3 == 1 && GameLogic.this.map_info[this.map_y + 1][this.map_x] == MAP_NULL_ID[0] && (this.woman_State == 1 || this.woman_State == 3)) {
                        this.woman_map_pos_y = this.map_y * 16;
                    }
                    if (this.woman_State == 5 || this.woman_State == 10 && this.woman_tz2 == 0) {
                        if (this.woman_map_pos_x - this.map_x * 16 == 0) {
                            if (this.woman_usd1 == 1) {
                                this.woman_map_pos_y = this.map_y * 16;
                                this.woman_State = (byte)8;
                            }
                        } else if (this.woman_usd1 == 1 || this.woman_usd2 == 1) {
                            this.woman_map_pos_y = this.map_y * 16;
                            this.woman_State = (byte)8;
                        }
                    }
                    if (this.woman_usd1 == 1 && GameLogic.this.map_info[this.map_y + 1][this.map_x + 1] == MAP_NULL_ID[0] && this.woman_State == 0) {
                        this.woman_State = (byte)2;
                    } else if (GameLogic.this.map_info[this.map_y + 1][this.map_x] == MAP_NULL_ID[0] && this.woman_usd2 == 1 && this.woman_State == 1) {
                        this.woman_State = (byte)3;
                    }
                    if (this.woman_map_pos_x - this.map_x * 16 == 0) {
                        if (this.woman_dsd == 1 && this.woman_State == 4) {
                            this.woman_State = (byte)5;
                        }
                    } else {
                        if (this.woman_dsd == 1 && this.woman_dsd1 == 1 && this.woman_State == 4) {
                            this.woman_State = (byte)5;
                        }
                        if (GameLogic.this.map_info[this.map_y][this.map_x] == MAP_NULL_ID[0] && this.woman_dsd1 == 1 && this.woman_State == 4) {
                            this.woman_State = (byte)5;
                        }
                        if (this.woman_dsd == 1 && GameLogic.this.map_info[this.map_y][this.map_x + 1] == MAP_NULL_ID[0] && this.woman_State == 4) {
                            this.woman_State = (byte)5;
                        }
                    }
                }
            }
            if (this.woman_State == 9 && this.woman_usd1 == 1) {
                this.woman_map_pos_y = this.map_y * 16;
                this.woman_State = (byte)8;
            }
            if (this.woman_map_pos_y == 224 && this.woman_tz == 0 && this.woman_State == 9) {
                this.woman_State = (byte)8;
            } else if (this.woman_State == 10 && this.woman_tz == 1 && this.woman_dsd2 == 1) {
                this.woman_map_pos_y = this.map_y * 16;
                this.woman_State = (byte)8;
            }
        }

        public void Woman_Hero_Hit() {
            if (GameLogic.this.Object_Hero.hero_state != 9 && GameLogic.this.Object_Hero.hero_state != 6 && GameLogic.this.Object_Hero.hero_state != 5 && GameLogic.this.Object_Hero.hero_state != 3 && GameLogic.this.Object_Hero.hero_state != 4 && this.woman_State != 5 && this.woman_State != 4 && this.woman_State != 2 && this.woman_State != 3) {
                if (GameLogic.this.hero_pos_x >= this.woman_map_pos_x - 64 && GameLogic.this.hero_pos_x <= this.woman_map_pos_x + 64 && GameLogic.this.hero_pos_y >= this.woman_map_pos_y - 64 && GameLogic.this.hero_pos_y <= this.woman_map_pos_y + 64) {
                    if (GameLogic.this.hero_pos_y < this.woman_map_pos_y && this.woman_tz == 1) {
                        this.woman_map_pos_x = this.map_x * 16;
                        this.woman_State = (byte)9;
                    } else if (this.woman_tz2 == 1 && this.woman_State != 9 && GameLogic.this.hero_pos_y > this.woman_map_pos_y) {
                        this.woman_map_pos_x = this.map_x * 16;
                        this.woman_State = (byte)10;
                    } else if (GameLogic.this.hero_pos_x > this.woman_map_pos_x + 8 && this.woman_State != 9 && this.woman_State != 10) {
                        this.woman_State = 0;
                    } else if (GameLogic.this.hero_pos_x <= this.woman_map_pos_x - 8 && this.woman_State != 9 && this.woman_State != 10) {
                        this.woman_State = 1;
                    }
                    if (this.woman_map_pos_x - GameLogic.this.map_pos_x < 0 || this.woman_map_pos_x - GameLogic.this.map_pos_x > 128) {
                        this.woman_State = (byte)8;
                    }
                }
                if (GameLogic.this.hero_pos_x >= this.woman_map_pos_x - 8 && GameLogic.this.hero_pos_x <= this.woman_map_pos_x + 8 && GameLogic.this.hero_pos_y >= this.woman_map_pos_y - 4 && GameLogic.this.hero_pos_y <= this.woman_map_pos_y + 4 && GameLogic.this.Object_Hero.hero_state != 9) {
                    GameLogic.this.Object_Hero.hero_state = (byte)9;
                    GameLogic.this.Object_Hero.hero_lives = (byte)(GameLogic.this.Object_Hero.hero_lives - 1);
                    GameLogic.this.hero_pos_x = HERO_POS[GameLogic.this.stage_no][0] * 16;
                    GameLogic.this.hero_pos_y = HERO_POS[GameLogic.this.stage_no][1] * 16;
                }
            }
        }

        public void Woman_CSpringbed_Hit() {
            if (this.woman_map_pos_x + 16 >= GameLogic.this.Object_Springbed.SpringBed_MapPosX && this.woman_map_pos_x + 16 <= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 16 && this.woman_map_pos_y >= GameLogic.this.Object_Springbed.SpringBed_MapPosY && this.woman_map_pos_y <= GameLogic.this.Object_Springbed.SpringBed_MapPosY + 16 && this.woman_State == 0) {
                this.woman_State = (byte)2;
            } else if (this.woman_map_pos_x + 16 >= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 16 + 32 && this.woman_map_pos_x + 16 <= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 32 + 32 && this.woman_map_pos_y >= GameLogic.this.Object_Springbed.SpringBed_MapPosY && this.woman_map_pos_y <= GameLogic.this.Object_Springbed.SpringBed_MapPosY + 16 && this.woman_State == 1) {
                this.woman_State = (byte)3;
            }
        }

        public void Woman_Update() {
            this.Woman_State();
            if (GameLogic.this.stage_no != 2) {
                this.Woman_CSpringbed_Hit();
            }
            this.Woman_Hero_Hit();
            switch (this.woman_State) {
                case 0: {
                    this.woman_way2 = (GameLogic.this.random.nextInt() >>> 1) % 30;
                    this.step_no2 = (byte)(this.step_no2 + 1);
                    this.woman_map_pos_x += 4;
                    this.anim = (byte)(this.anim + 1);
                    if (this.anim > 3) {
                        this.anim = 0;
                    }
                    if (this.woman_tz == 1) {
                        if (this.woman_way2 % 15 == 1) {
                            this.woman_map_pos_x = this.woman_map_pos_x / 16 * 16;
                            this.woman_State = (byte)9;
                        }
                    } else if (this.woman_tz2 == 1 && this.woman_way2 % 15 == 1) {
                        this.woman_State = (byte)10;
                    }
                    if (this.step_no2 <= 16) break;
                    this.step_no2 = 1;
                    this.woman_State = (byte)8;
                    break;
                }
                case 7: {
                    this.wait_time = (byte)(this.wait_time + 1);
                    this.wait_time1 = (byte)(this.wait_time1 + 1);
                    if (this.wait_time1 > 19) {
                        this.wait_time1 = 0;
                    }
                    if (this.wait_time < 30) break;
                    this.wait_time = 0;
                    this.woman_State = 1;
                    break;
                }
                case 1: {
                    this.woman_way2 = (GameLogic.this.random.nextInt() >>> 1) % 30;
                    this.step_no3 = (byte)(this.step_no3 + 1);
                    this.woman_map_pos_x -= 4;
                    this.anim = (byte)(this.anim + 1);
                    if (this.anim > 3) {
                        this.anim = 0;
                    }
                    if (this.woman_tz == 1) {
                        if (this.woman_way2 % 15 == 1) {
                            this.woman_map_pos_x = this.woman_map_pos_x / 16 * 16;
                            this.woman_State = (byte)9;
                        }
                    } else if (this.woman_tz2 == 1 && this.woman_way2 % 15 == 1) {
                        this.woman_State = (byte)10;
                    }
                    if (this.step_no3 < 32) break;
                    this.step_no3 = 0;
                    this.woman_State = (byte)8;
                    break;
                }
                case 6: {
                    this.wait_time = (byte)(this.wait_time + 1);
                    this.wait_time1 = (byte)(this.wait_time1 + 1);
                    if (this.wait_time1 > 19) {
                        this.wait_time1 = 0;
                    }
                    if (this.wait_time < 30) break;
                    this.wait_time = 0;
                    this.woman_State = 0;
                    break;
                }
                case 8: {
                    this.wait_time = (byte)(this.wait_time + 1);
                    this.wait_time1 = (byte)(this.wait_time1 + 1);
                    this.woman_way = (GameLogic.this.random.nextInt() >>> 1) % 2;
                    if (this.wait_time1 > 19) {
                        this.wait_time1 = 0;
                    }
                    if (this.wait_time < 30) break;
                    this.wait_time = 0;
                    if (this.woman_way == 0) {
                        this.woman_State = 0;
                        break;
                    }
                    this.woman_State = 1;
                    break;
                }
                case 4: {
                    this.woman_way1 = (GameLogic.this.random.nextInt() >>> 1) % 3;
                    this.woman_way3 = (GameLogic.this.random.nextInt() >>> 1) % 3;
                    this.step_no1 = (byte)(this.step_no1 + 1);
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    this.woman_map_pos_y -= 8;
                    if (this.step_no1 != 6 && this.woman_step_no != 10) break;
                    this.step_no1 = 0;
                    if (this.woman_way1 == 1) {
                        this.woman_State = (byte)2;
                        break;
                    }
                    if (this.woman_way1 == 0) {
                        this.woman_State = (byte)3;
                        break;
                    }
                    if (this.woman_way3 == 1) {
                        this.woman_State = (byte)2;
                        break;
                    }
                    if (this.woman_way3 != 0) break;
                    this.woman_State = (byte)3;
                    break;
                }
                case 2: {
                    this.woman_step_no = (byte)(this.woman_step_no + 1);
                    this.woman_map_pos_x += 6;
                    this.woman_map_pos_y -= 2;
                    if (this.woman_step_no < 4) break;
                    this.woman_step_no = 0;
                    this.woman_State = (byte)5;
                    break;
                }
                case 3: {
                    this.woman_step_no = (byte)(this.woman_step_no + 1);
                    this.woman_map_pos_x -= 6;
                    this.woman_map_pos_y -= 2;
                    if (this.woman_step_no < 4) break;
                    this.woman_step_no = 0;
                    this.woman_State = (byte)5;
                    break;
                }
                case 5: {
                    this.step_no1 = 0;
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    this.woman_map_pos_y += 4;
                    break;
                }
                case 10: {
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    this.woman_map_pos_x = this.woman_map_pos_x / 16 * 16;
                    this.woman_map_pos_y += 4;
                    break;
                }
                case 9: {
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    this.woman_map_pos_x = this.woman_map_pos_x / 16 * 16;
                    this.woman_map_pos_y -= 4;
                }
            }
        }

        public void Draw_Woman(Graphics graphics) {
            int n = this.woman_map_pos_x - GameLogic.this.map_pos_x;
            int n2 = this.woman_map_pos_y - GameLogic.this.map_pos_y + 8 * this.woman_tiaoz;
            if (n + 16 < 0 || n > 128 || n2 + 16 < 0 || n2 > 128) {
                return;
            }
            switch (this.woman_State) {
                case 0: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 16 * this.anim, n2, 20);
                    break;
                }
                case 7: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 16 * (this.wait_time1 / 10), n2 - 16, 20);
                    break;
                }
                case 1: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 64 - 16 * this.anim, n2, 20);
                    break;
                }
                case 6: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 16 * (this.wait_time1 / 10), n2 - 16, 20);
                    break;
                }
                case 8: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 16 * (this.wait_time1 / 10), n2 - 16, 20);
                    break;
                }
                case 4: {
                    graphics.setClip(n, n2 - 8 * this.woman_tiaoz, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 96 - 16 * this.anim2, n2 - 16 - 8 * this.woman_tiaoz, 20);
                    break;
                }
                case 2: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 32, n2 - 16, 20);
                    break;
                }
                case 3: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 48, n2 - 16, 20);
                    break;
                }
                case 5: {
                    graphics.setClip(n, n2 - 8 * this.woman_tiaoz, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 96 - 16 * this.anim2, n2 - 16 - 8 * this.woman_tiaoz, 20);
                    break;
                }
                case 10: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 64 - 16 * this.anim2, n2 - 16, 20);
                    break;
                }
                case 9: {
                    graphics.setClip(n, n2, 16, 16);
                    graphics.drawImage(GameLogic.this.image_woman, n - 64 - 16 * this.anim2, n2 - 16, 20);
                }
            }
        }
    }

    class CHero {
        byte hero_state = 0;
        int ground_attribute_x;
        int ground_attribute_y;
        byte hero_lives;
        byte hero_fruits;
        byte step_no;
        byte step_no1;
        byte step_no2;
        byte anim;
        byte anim1;
        byte anim2;
        byte wait_time;
        byte condition_usd;
        byte condition_usd1;
        byte condition_usd2;
        byte condition_dsd;
        byte condition_dsd1;
        byte condition_dsd2;
        byte condition_usd3;
        byte condition_tz;
        byte condition_tz1;
        byte condition_tz2;
        byte condition_tz3;
        byte condition_tz4;
        byte hero_tiaoz = 1;

        public void InitHero(byte by) {
            this.hero_state = 0;
            this.hero_lives = (byte)3;
            this.hero_fruits = 0;
            this.step_no = 0;
            this.step_no1 = 0;
            this.step_no2 = 0;
            this.anim = 0;
            this.anim1 = 0;
            this.anim2 = 0;
            this.wait_time = 0;
            this.condition_usd = 0;
            this.condition_usd1 = 0;
            this.condition_usd2 = 0;
            this.condition_dsd = 0;
            this.condition_dsd1 = 0;
            this.condition_dsd2 = 0;
            this.condition_usd3 = 0;
            this.condition_tz = 0;
            this.condition_tz1 = 0;
            this.condition_tz2 = 0;
            this.condition_tz3 = 0;
            this.condition_tz4 = 0;
        }

        public void Hero_State() {
            block76: {
                int n;
                this.ground_attribute_x = GameLogic.this.hero_pos_x / 16;
                this.ground_attribute_y = GameLogic.this.hero_pos_y / 16;
                this.condition_usd1 = 0;
                this.condition_usd2 = 0;
                this.condition_usd3 = 0;
                this.condition_dsd = 0;
                this.condition_dsd1 = 0;
                this.condition_dsd2 = 0;
                this.condition_tz = 0;
                this.condition_usd = 0;
                this.condition_tz1 = 0;
                this.condition_tz2 = 0;
                this.condition_tz3 = 0;
                this.condition_tz4 = 0;
                this.hero_tiaoz = 1;
                if (GameLogic.this.hero_pos_y == 224) {
                    this.hero_tiaoz = 0;
                }
                if (GameLogic.this.hero_pos_y < 224 && GameLogic.this.hero_pos_y >= 0 && GameLogic.this.hero_pos_x >= 0 && GameLogic.this.hero_pos_x < 336) {
                    for (n = 0; n < MAP_UPGND_ID.length; ++n) {
                        try {
                            if (GameLogic.this.map_info[this.ground_attribute_y][this.ground_attribute_x] == MAP_UPGND_ID[n]) {
                                this.condition_usd = 1;
                            }
                            if (GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x] == MAP_UPGND_ID[n]) {
                                this.condition_usd1 = 1;
                            }
                            if (GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x + 1] == MAP_UPGND_ID[n]) {
                                this.condition_usd2 = 1;
                            }
                            if (GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x - 1] == MAP_UPGND_ID[n]) {
                                this.condition_usd3 = 1;
                            }
                            if (GameLogic.this.map_info[this.ground_attribute_y + 2][this.ground_attribute_x] == MAP_DOWNGND_ID[n]) {
                                this.condition_dsd2 = 1;
                            }
                            if (GameLogic.this.map_info[this.ground_attribute_y][this.ground_attribute_x] == MAP_DOWNGND_ID[n]) {
                                this.condition_dsd = 1;
                            }
                            if (GameLogic.this.map_info[this.ground_attribute_y][this.ground_attribute_x + 1] != MAP_DOWNGND_ID[n]) continue;
                            this.condition_dsd1 = 1;
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (GameLogic.this.hero_pos_y < 256 && GameLogic.this.hero_pos_y >= 0 && GameLogic.this.hero_pos_x >= 0 && GameLogic.this.hero_pos_x < 352) {
                    for (n = 0; n < MAP_LADDER_ID.length; ++n) {
                        if (GameLogic.this.map_info[this.ground_attribute_y][this.ground_attribute_x] == MAP_LADDER_ID[n]) {
                            this.condition_tz = 1;
                        }
                        if (GameLogic.this.hero_pos_y < 224 && GameLogic.this.map_info[this.ground_attribute_y + 2][this.ground_attribute_x] == MAP_LADDER_ID[n]) {
                            this.condition_tz2 = 1;
                        }
                        if (GameLogic.this.hero_pos_y < 224 && GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x] == MAP_LADDER_ID[n]) {
                            this.condition_tz1 = 1;
                        }
                        if (GameLogic.this.hero_pos_x < 320 && GameLogic.this.map_info[this.ground_attribute_y][this.ground_attribute_x + 1] == MAP_LADDER_ID[n]) {
                            this.condition_tz3 = 1;
                        }
                        if (GameLogic.this.hero_pos_x >= 320 || GameLogic.this.hero_pos_y >= 224 || GameLogic.this.map_info[this.ground_attribute_y + 2][this.ground_attribute_x + 1] != MAP_LADDER_ID[n]) continue;
                        this.condition_tz4 = 1;
                    }
                }
                if (GameLogic.this.hero_pos_x >= 336) {
                    GameLogic.this.hero_pos_x = 336;
                    if (GameLogic.this.keyMove == 4096) {
                        GameLogic.this.keyMove = 0;
                    }
                }
                if (GameLogic.this.hero_pos_x <= 0) {
                    if (GameLogic.this.keyMove == 256) {
                        GameLogic.this.keyMove = 0;
                    }
                    GameLogic.this.hero_pos_x = 0;
                }
                if (GameLogic.this.hero_pos_y <= 0) {
                    GameLogic.this.hero_pos_y = 0;
                    this.hero_state = (byte)5;
                }
                if (GameLogic.this.hero_pos_y >= 224) {
                    GameLogic.this.hero_pos_y = 224;
                    this.hero_state = 0;
                }
                if ((this.hero_state == 1 || this.hero_state == 2) && GameLogic.this.hero_pos_y < 224 && GameLogic.this.hero_pos_y > 0 && GameLogic.this.hero_pos_x > 0 && GameLogic.this.hero_pos_x < 336) {
                    if (GameLogic.this.hero_pos_x - this.ground_attribute_x * 16 == 0) {
                        try {
                            if (this.condition_usd1 == 0 && this.condition_tz == 0) {
                                this.hero_state = (byte)5;
                                break block76;
                            }
                            this.hero_state = 0;
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            this.hero_state = this.condition_usd1 == 0 && this.condition_usd2 == 0 ? (byte)5 : (byte)0;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.hero_state != 5 && this.hero_state != 6) {
                if (GameLogic.this.keyMove == 256 && this.hero_state == 0) {
                    this.hero_state = (byte)2;
                } else if (GameLogic.this.keyMove == 4096 && this.hero_state == 0) {
                    this.hero_state = 1;
                } else if (GameLogic.this.keyMove == 0 && this.hero_state != 3 && this.hero_state != 4 && this.hero_state != 7 && this.hero_state != 8 && this.hero_state != 9) {
                    this.hero_state = 0;
                }
            }
            if (GameLogic.this.keyMove == 1 && GameLogic.this.keyMove != 256 && GameLogic.this.keyMove != 16 && GameLogic.this.keyMove != 4096) {
                if (this.condition_tz == 1) {
                    GameLogic.this.hero_pos_x = this.ground_attribute_x * 16;
                    this.hero_state = (byte)7;
                } else if (this.condition_tz3 == 1) {
                    GameLogic.this.hero_pos_x = this.ground_attribute_x * 16 + 16;
                    this.hero_state = (byte)7;
                }
            } else if (GameLogic.this.keyMove == 0 && this.condition_tz == 1 && this.condition_dsd2 != 1) {
                this.hero_state = (byte)10;
            } else if (GameLogic.this.keyMove == 0 && this.condition_tz1 == 1 && this.condition_usd == 1 && this.condition_dsd2 != 1) {
                this.hero_state = (byte)10;
            }
            if (GameLogic.this.keyMove == 1 && this.condition_tz1 == 1 && this.condition_usd == 1) {
                this.hero_state = (byte)7;
            }
            if (this.hero_state == 7 && this.condition_usd1 == 1) {
                GameLogic.this.hero_pos_y = this.ground_attribute_y * 16;
                this.hero_state = 0;
            }
            if (GameLogic.this.keyMove == 16 && GameLogic.this.keyMove != 1 && GameLogic.this.keyMove != 256 && GameLogic.this.keyMove != 4096) {
                if (this.condition_tz2 == 1) {
                    GameLogic.this.hero_pos_x = this.ground_attribute_x * 16;
                    this.hero_state = (byte)8;
                } else if (this.condition_tz4 == 1) {
                    GameLogic.this.hero_pos_x = this.ground_attribute_x * 16 + 16;
                    this.hero_state = (byte)8;
                } else if (this.condition_tz1 == 1) {
                    this.hero_state = (byte)8;
                }
            } else if (GameLogic.this.keyMove == 0 && this.condition_tz == 1 && this.condition_dsd2 != 1) {
                this.hero_state = (byte)10;
            } else if (GameLogic.this.keyMove == 0 && this.condition_tz == 1 && this.condition_tz1 == 1 && this.condition_dsd2 != 1) {
                this.hero_state = (byte)10;
            }
            if (this.hero_state == 8 && this.condition_tz == 1 && this.condition_dsd2 == 1) {
                this.hero_state = 0;
            }
            if (GameLogic.this.hero_pos_y <= 224 && GameLogic.this.hero_pos_y >= 16 && GameLogic.this.hero_pos_x <= 320 && GameLogic.this.hero_pos_x >= 16) {
                if (this.condition_usd1 == 1 && GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x + 1] == MAP_NULL_ID[0] && GameLogic.this.keyMove == 4096) {
                    this.hero_state = (byte)3;
                }
                if (GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x] == MAP_NULL_ID[0] && this.condition_usd2 == 1 && GameLogic.this.keyMove == 256) {
                    this.hero_state = (byte)4;
                }
                if (GameLogic.this.keyMove == 4096 && this.hero_state == 6 && (this.step_no1 >= 4 && this.step_no1 <= 6 || this.step_no1 >= 10 && this.step_no1 <= 12 || this.step_no1 >= 16 && this.step_no1 <= 18 || this.step_no1 >= 22 && this.step_no1 <= 24)) {
                    this.hero_state = (byte)3;
                }
                if (GameLogic.this.keyMove == 256 && this.hero_state == 6 && (this.step_no1 >= 4 && this.step_no1 <= 6 || this.step_no1 >= 10 && this.step_no1 <= 12 || this.step_no1 >= 16 && this.step_no1 <= 18 || this.step_no1 >= 22 && this.step_no1 <= 24)) {
                    this.hero_state = (byte)4;
                }
                if (this.condition_usd2 == 1 && GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x] == MAP_NULL_ID[0] && GameLogic.this.keyMove == 4096 && this.hero_state != 5) {
                    GameLogic.this.hero_pos_y = this.ground_attribute_y * 16;
                }
                if (this.condition_usd3 == 1 && GameLogic.this.map_info[this.ground_attribute_y + 1][this.ground_attribute_x] == MAP_NULL_ID[0] && GameLogic.this.keyMove == 256 && this.hero_state != 5) {
                    GameLogic.this.hero_pos_y = this.ground_attribute_y * 16;
                }
                if (this.hero_state == 5) {
                    if (GameLogic.this.hero_pos_x - this.ground_attribute_x * 16 == 0) {
                        if (this.condition_usd1 == 1) {
                            this.hero_state = GameLogic.this.keyMove == 256 ? (byte)2 : (GameLogic.this.keyMove == 4096 ? (byte)1 : 0);
                        }
                    } else if (this.condition_usd1 == 1 || this.condition_usd2 == 1) {
                        this.hero_state = GameLogic.this.keyMove == 256 ? (byte)2 : (GameLogic.this.keyMove == 4096 ? (byte)1 : 0);
                    }
                }
                if (GameLogic.this.hero_pos_x - this.ground_attribute_x * 16 == 0) {
                    if (this.condition_dsd == 1 && this.hero_state == 6) {
                        this.hero_state = (byte)5;
                    }
                } else {
                    if (this.condition_dsd == 1 && this.condition_dsd1 == 1 && this.hero_state == 6) {
                        this.hero_state = (byte)5;
                    }
                    if (GameLogic.this.map_info[this.ground_attribute_y][this.ground_attribute_x] == MAP_NULL_ID[0] && this.condition_dsd1 == 1 && this.hero_state == 6) {
                        this.hero_state = (byte)5;
                    }
                    if (this.condition_dsd == 1 && GameLogic.this.map_info[this.ground_attribute_y][this.ground_attribute_x + 1] == MAP_NULL_ID[0] && this.hero_state == 6) {
                        this.hero_state = (byte)5;
                    }
                }
            }
        }

        public void Hero_Springbed_Hit() {
            if (GameLogic.this.hero_pos_x + 16 >= GameLogic.this.Object_Springbed.SpringBed_MapPosX && GameLogic.this.hero_pos_x + 16 <= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 16 && GameLogic.this.hero_pos_y >= GameLogic.this.Object_Springbed.SpringBed_MapPosY && GameLogic.this.hero_pos_y <= GameLogic.this.Object_Springbed.SpringBed_MapPosY + 17 && GameLogic.this.keyMove == 4096) {
                this.hero_state = (byte)3;
            }
            if (GameLogic.this.hero_pos_x + 16 >= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 16 + 32 && GameLogic.this.hero_pos_x + 16 <= GameLogic.this.Object_Springbed.SpringBed_MapPosX + 32 + 32 && GameLogic.this.hero_pos_y >= GameLogic.this.Object_Springbed.SpringBed_MapPosY && GameLogic.this.hero_pos_y <= GameLogic.this.Object_Springbed.SpringBed_MapPosY + 17 && GameLogic.this.keyMove == 256) {
                this.hero_state = (byte)4;
            }
        }

        public void Ls_Move_Area() {
            GameLogic.this.map_pos_y = GameLogic.this.hero_pos_y < 64 ? 0 : (GameLogic.this.hero_pos_y > 192 ? 128 : GameLogic.this.hero_pos_y - 64);
            GameLogic.this.map_pos_x = GameLogic.this.hero_pos_x < 64 ? 0 : (GameLogic.this.hero_pos_x > 288 ? 224 : GameLogic.this.hero_pos_x - 64);
        }

        public void Hero_Update() {
            this.Hero_State();
            this.Ls_Move_Area();
            if (GameLogic.this.stage_no != 2) {
                this.Hero_Springbed_Hit();
            }
            switch (this.hero_state) {
                case 2: {
                    GameLogic.this.hero_pos_x -= 6;
                    this.anim = (byte)(this.anim + 1);
                    if (this.anim > 3) {
                        this.anim = 0;
                    }
                    GameLogic.this.hero_pos_y = GameLogic.this.hero_pos_y / 16 * 16;
                    break;
                }
                case 1: {
                    GameLogic.this.hero_pos_x += 6;
                    this.anim = (byte)(this.anim + 1);
                    if (this.anim > 3) {
                        this.anim = 0;
                    }
                    GameLogic.this.hero_pos_y = GameLogic.this.hero_pos_y / 16 * 16;
                    break;
                }
                case 0: {
                    this.anim1 = (byte)(this.anim1 + 1);
                    if (this.anim1 > 39) {
                        this.anim1 = 0;
                    }
                    GameLogic.this.hero_pos_y = GameLogic.this.hero_pos_y / 16 * 16;
                    break;
                }
                case 6: {
                    this.step_no1 = (byte)(this.step_no1 + 1);
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    GameLogic.this.hero_pos_y -= 8;
                    break;
                }
                case 5: {
                    this.step_no1 = 0;
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    GameLogic.this.hero_pos_y += 4;
                    break;
                }
                case 9: {
                    this.wait_time = (byte)(this.wait_time + 1);
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    if (this.wait_time < 10) break;
                    this.wait_time = 0;
                    this.hero_state = 0;
                    break;
                }
                case 3: {
                    this.step_no = (byte)(this.step_no + 1);
                    GameLogic.this.hero_pos_x += 6;
                    GameLogic.this.hero_pos_y -= 2;
                    if (this.step_no <= 3) break;
                    this.step_no = 0;
                    this.hero_state = (byte)5;
                    break;
                }
                case 4: {
                    this.step_no = (byte)(this.step_no + 1);
                    GameLogic.this.hero_pos_x -= 6;
                    GameLogic.this.hero_pos_y -= 2;
                    if (this.step_no <= 3) break;
                    this.step_no = 0;
                    this.hero_state = (byte)5;
                    break;
                }
                case 7: {
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    GameLogic.this.hero_pos_y -= 6;
                    break;
                }
                case 8: {
                    this.anim2 = (byte)(this.anim2 + 1);
                    if (this.anim2 > 1) {
                        this.anim2 = 0;
                    }
                    GameLogic.this.hero_pos_y += 6;
                    break;
                }
            }
        }

        public void Draw(Graphics graphics) {
            int n = GameLogic.this.hero_pos_x - GameLogic.this.map_pos_x;
            int n2 = GameLogic.this.hero_pos_y - GameLogic.this.map_pos_y;
            if (n + 16 < 0 || n > 128 || n2 + 17 < 0 || n2 > 128) {
                return;
            }
            switch (this.hero_state) {
                case 2: {
                    graphics.setClip(n, n2 + 8 * this.hero_tiaoz, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 16 * this.anim, n2 + 8 * this.hero_tiaoz - 0, 20);
                    break;
                }
                case 1: {
                    graphics.setClip(n, n2 + 8 * this.hero_tiaoz, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 64 - 16 * this.anim, n2 + 8 * this.hero_tiaoz - 0, 20);
                    break;
                }
                case 0: {
                    graphics.setClip(n, n2 + 8 * this.hero_tiaoz, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 16 * (this.anim1 / 10), n2 - 17 + 8 * this.hero_tiaoz - 0, 20);
                    break;
                }
                case 6: {
                    graphics.setClip(n, n2, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 128 - 16 * this.anim2, n2 - 17, 20);
                    break;
                }
                case 5: {
                    graphics.setClip(n, n2, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 128 - 16 * this.anim2, n2 - 17, 20);
                    break;
                }
                case 9: {
                    graphics.setClip(n, n2 + 8, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 128 - this.anim2 * 16, n2 + 8, 20);
                    graphics.setClip(n + 6, n2 + 8 - 16, 4, 14);
                    graphics.drawImage(GameLogic.this.image_bg, n + 6 - 28, n2 + 8 - 16 - 32, 20);
                    break;
                }
                case 3: {
                    graphics.setClip(n, n2, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 80, n2 - 17, 20);
                    break;
                }
                case 4: {
                    graphics.setClip(n, n2, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 64, n2 - 17, 20);
                    break;
                }
                case 7: {
                    graphics.setClip(n, n2, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 96 - 16 * this.anim2, n2 - 17, 20);
                    break;
                }
                case 8: {
                    graphics.setClip(n, n2, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 96 - 16 * this.anim2, n2 - 17, 20);
                    break;
                }
                case 10: {
                    graphics.setClip(n, n2, 16, 17);
                    graphics.drawImage(GameLogic.this.image_hero, n - 96, n2 - 17, 20);
                }
            }
        }
    }
}

