/*
 * Decompiled with CFR 0.152.
 */
package igs;

import igs.BoardCanvas;
import igs.ThinkThread;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;

public class HelloMIDlet
extends MIDlet {
    public Display display = Display.getDisplay((MIDlet)this);
    volatile byte[][] board = new byte[19][];
    BoardCanvas boardCanvas;
    Image icon;
    OutputStream os;
    public boolean stopped = false;

    public void loadSettings() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"igsClient", (boolean)true);
            byte[] byArray = recordStore.getRecord(1);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            BoardCanvas.perBox = dataInputStream.readInt();
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public HelloMIDlet() {
        for (int i = 0; i < 19; ++i) {
            this.board[i] = new byte[19];
        }
        try {
            this.icon = Image.createImage((String)"/icons/Icon.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.boardCanvas = new BoardCanvas(this.board, this);
        this.boardCanvas.side = ThinkThread.userSide;
        this.loadSettings();
    }

    void alarm(String string, AlertType alertType) {
        this.alarm(string, alertType, 1000);
    }

    void alarm(String string, AlertType alertType, int n) {
        Alert alert = new Alert("\u6ce8\u610f");
        alert.setString(string);
        alert.setType(alertType);
        alert.setTimeout(n);
        alertType.playSound(this.display);
        this.display.setCurrent((Displayable)alert);
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playSound() {
        try {
            Manager.playTone((int)60, (int)50, (int)100);
        }
        catch (Exception exception) {
            AlertType.INFO.playSound(this.display);
        }
        try {
            Thread.currentThread();
            Thread.sleep(60L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startApp() {
        this.playSound();
        this.display.setCurrent((Displayable)this.boardCanvas);
    }

    public void saveSettings() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"igsClient", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(BoardCanvas.perBox);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pauseApp() {
        this.saveSettings();
    }

    public static int toInt(Object object) {
        String string = object.toString();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') continue;
            int n3 = c - 48;
            n2 = n2 * 10 + n3;
        }
        return n2;
    }

    public void destroyApp(boolean bl) {
        this.saveSettings();
    }
}

