/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends Canvas
implements CommandListener {
    protected Command pause;
    protected Command menu;
    private MonkeyMadness parent;
    private GameClock clock;
    private Timer timer;
    public boolean paused;
    private int gameSpeed;
    private int refreshRate;
    private int currentLevel;
    private int currentScore;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private int dir;
    private Random random;
    private int temp;
    private int counter;
    private static final int BLOCK_HEIGHT = 10;
    private static final int PLAYER_HEIGHT = 32;
    private static int OFFSCREEN_WIDTH;
    private static int OFFSCREEN_HEIGHT;
    private static int GROUND_HEIGHT;
    private static int SCREEN_WIDTH;
    private static int SCREEN_HEIGHT;
    private Image window;
    private Image door;
    private Image background;
    private Image soldier;
    private Image[] smoke = new Image[2];
    private Image[] damage = new Image[3];
    private Image[] legsForward = new Image[2];
    private Image[] legsMid = new Image[2];
    private Image[] legsBack = new Image[2];
    private Image[] frontArmNormal = new Image[2];
    private Image[] frontArmPunch = new Image[2];
    private Image[] backArmNormal = new Image[2];
    private Image[] legsJumping = new Image[2];
    private Image[] legsClimbing = new Image[2];
    private Image[] torso = new Image[2];
    private Image[] head = new Image[2];
    private Image[] buildingImage;
    private Image screenBuffer;
    private int screenXClip;
    private int screenYClip;
    private static final int BUILDING_NUMROWS = 0;
    private static final int BUILDING_NUMCOLS = 1;
    private static final int BUILDING_XPOS = 2;
    private static final int BUILDING_TYPE = 3;
    private int[] buildingYMod;
    private int[][] buildingData;
    private int[][][] buildingDamageData;
    private int numBuildings;
    private int currentBuilding;
    private int[] buildingColours = new int[]{12637070, 10011380, 13798991, 3946550, 0x6A6262, 9599601, 9806976, 8873280, 8232613};
    private static final int SOLDIER_BUILDINGNO = 0;
    private static final int SOLDIER_BUILDINGROW = 1;
    private static final int SOLDIER_BUILDINGCOL = 2;
    private static final int SOLDIER_STATUS = 3;
    private static final int SOLDIER_YMOD = 4;
    private static final int SOLDIER_POINTS = 5;
    private static final int STATUS_IDLE = 0;
    private static final int STATUS_ATTACKING = 1;
    private static final int STATUS_DEAD = 2;
    private int[][] soldierData;
    private static final int SHOT_XSTART = 0;
    private static final int SHOT_YSTART = 1;
    private static final int SHOT_XVECTOR = 2;
    private static final int SHOT_YVECTOR = 3;
    private static final int SHOT_TIMER = 4;
    private int[][] projectileData;
    private boolean playerMove;
    private boolean playerPunch;
    private boolean playerJump;
    private boolean playerGrab;
    private boolean playerClimb;
    private boolean goingToFall;
    private int playerStep;
    private int playerXPos;
    private int playerYPos;
    private int playerHealth;
    private int playerYSpeed;
    private int playerDirection;
    private int playerTimeSinceLastPunch;

    public GameCanvas(MonkeyMadness monkeyMadness) {
        this.parent = monkeyMadness;
        this.loadImages();
        this.random = new Random();
        SCREEN_WIDTH = this.getWidth();
        SCREEN_HEIGHT = this.getHeight();
        this.menu = new Command("Menu", 4, 1);
        this.pause = new Command("Pause", 3, 1);
        this.addCommand(this.menu);
        this.addCommand(this.pause);
        this.setCommandListener(this);
    }

    public void init() {
        this.init(15);
    }

    public void init(int n) {
        System.gc();
        this.currentLevel = 0;
        this.loadLevel(this.currentLevel++);
        this.currentScore = 0;
        this.playerHealth = 100;
        this.refreshRate = 1000 / n;
        this.gameSpeed = this.refreshRate / 25;
        if (this.gameSpeed == 0) {
            this.gameSpeed = 1;
        }
        this.clock = null;
        this.clock = new GameClock();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this.clock, this.refreshRate, (long)this.refreshRate);
    }

    private void loadImages() {
        try {
            this.background = Image.createImage((String)"/background.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        while (n < 2) {
            try {
                this.legsForward[n] = Image.createImage((String)("/legsForward" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.legsMid[n] = Image.createImage((String)("/legsMid" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.legsBack[n] = Image.createImage((String)("/legsBack" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.legsJumping[n] = Image.createImage((String)("/legsJumping" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.legsClimbing[n] = Image.createImage((String)("/legsClimbing" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.frontArmNormal[n] = Image.createImage((String)("/frontArm" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.frontArmPunch[n] = Image.createImage((String)("/frontArmPunch" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.backArmNormal[n] = Image.createImage((String)("/backArmNormal" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.torso[n] = Image.createImage((String)("/torso" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.head[n] = Image.createImage((String)("/headNormal" + n + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        try {
            this.damage[0] = Image.createImage((String)"/damage0.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.damage[1] = Image.createImage((String)"/damage1.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.damage[2] = Image.createImage((String)"/damage2.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.smoke[0] = Image.createImage((String)"/smoke0.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.smoke[1] = Image.createImage((String)"/smoke1.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.door = Image.createImage((String)"/door.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.window = Image.createImage((String)"/window.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.soldier = Image.createImage((String)"/soldier.png");
        }
        catch (Exception exception) {}
    }

    public void loadLevel(int n) {
        this.paused = true;
        try {
            int n2;
            this.random.setSeed(n);
            this.temp = n;
            if (this.temp > 4) {
                this.temp = 4;
            }
            OFFSCREEN_WIDTH = (this.temp + 1) * 10 + 160;
            OFFSCREEN_HEIGHT = 160;
            if (OFFSCREEN_WIDTH < SCREEN_WIDTH) {
                OFFSCREEN_WIDTH = SCREEN_WIDTH;
            }
            if (OFFSCREEN_HEIGHT < SCREEN_HEIGHT) {
                OFFSCREEN_HEIGHT = SCREEN_HEIGHT;
            }
            GROUND_HEIGHT = OFFSCREEN_HEIGHT - 10;
            if (this.temp <= 4) {
                this.screenBuffer = null;
                this.screenBuffer = Image.createImage((int)OFFSCREEN_WIDTH, (int)OFFSCREEN_HEIGHT);
            }
            this.playerXPos = 32;
            this.playerYPos = GROUND_HEIGHT - 32;
            this.playerDirection = 1;
            this.playerMove = false;
            this.playerPunch = false;
            this.playerJump = false;
            this.playerGrab = false;
            this.playerClimb = false;
            this.numBuildings = this.temp + 2;
            this.buildingData = null;
            this.buildingData = new int[this.numBuildings][4];
            this.buildingYMod = null;
            this.buildingYMod = new int[this.numBuildings];
            this.buildingImage = null;
            this.buildingImage = new Image[this.numBuildings];
            int n3 = this.numBuildings - 1;
            while (n3 >= 0) {
                this.temp = this.random.nextInt();
                if (this.temp < 0) {
                    this.temp = -this.temp;
                }
                this.buildingData[n3][0] = this.temp % 3 + 3;
                if (this.buildingData[n3][0] > 6) {
                    this.buildingData[n3][0] = 6;
                }
                this.buildingData[n3][1] = n / 2 + this.temp % 3 + 4;
                if (this.buildingData[n3][0] > 8) {
                    this.buildingData[n3][0] = 8;
                }
                this.temp = this.random.nextInt();
                if (this.temp < 0) {
                    this.temp = -this.temp;
                }
                this.buildingData[n3][2] = 10 + this.temp % (OFFSCREEN_WIDTH - (1 + this.buildingData[n3][0]) * 10);
                this.buildingData[n3][3] = n3 % this.buildingColours.length;
                this.buildingYMod[n3] = 0;
                this.buildingImage[n3] = Image.createImage((int)(10 * this.buildingData[n3][0]), (int)(10 * (this.buildingData[n3][1] - 1) + 3));
                --n3;
            }
            this.initBuildingDamageGrids();
            int n4 = this.numBuildings - 1;
            while (n4 >= 0) {
                this.drawBuilding(this.buildingImage[n4].getGraphics(), n4, 0, this.buildingImage[n4].getHeight());
                --n4;
            }
            this.projectileData = null;
            this.projectileData = new int[this.numBuildings * 2][5];
            int n5 = this.projectileData.length - 1;
            while (n5 >= 0) {
                n2 = 0;
                while (n2 < 5) {
                    this.projectileData[n5][n2] = 0;
                    ++n2;
                }
                --n5;
            }
            this.soldierData = null;
            this.soldierData = new int[this.numBuildings * 2][6];
            n2 = this.soldierData.length - 1;
            while (n2 >= 0) {
                this.initSoldier(n2);
                this.soldierData[n2][3] = 100 * n2 + 100;
                --n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Loading level " + this.currentLevel);
        }
        this.paused = false;
    }

    private void initSoldier(int n) {
        this.temp = this.random.nextInt();
        if (this.temp < 0) {
            this.temp = -this.temp;
        }
        this.soldierData[n][0] = this.temp % this.numBuildings;
        this.soldierData[n][1] = this.temp % this.buildingData[this.soldierData[n][0]][0];
        this.soldierData[n][2] = this.temp % (this.buildingData[this.soldierData[n][0]][1] - 2) + 1;
        this.soldierData[n][3] = this.temp % 4 * 50 * this.gameSpeed + 50 * this.gameSpeed;
        this.soldierData[n][4] = 0;
        this.soldierData[n][5] = 0;
        try {
            int n2 = this.soldierData.length - 1;
            while (n2 >= 0) {
                if (n2 != n && this.soldierCollision(n, this.soldierData[n2][0], this.soldierData[n2][1], this.soldierData[n2][2])) {
                    this.initSoldier(n);
                }
                --n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Initialising soldier " + n);
        }
    }

    private void initBuildingDamageGrids() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numBuildings) {
            if (this.buildingData[n3][0] > n2) {
                n2 = this.buildingData[n3][0] + 1;
            }
            if (this.buildingData[n3][1] > n) {
                n = this.buildingData[n3][1] + 1;
            }
            ++n3;
        }
        this.buildingDamageData = null;
        this.buildingDamageData = new int[this.numBuildings][n2][n];
        int n4 = 0;
        while (n4 < this.numBuildings) {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    this.buildingDamageData[n4][n5][n6] = 0;
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void updateEndGameCheck() {
        if (this.playerHealth <= 0) {
            this.playerHealth = 0;
            this.init();
        }
    }

    public void updateNewLevelCheck() {
        try {
            this.temp = 0;
            int n = 0;
            while (n < this.buildingYMod.length) {
                if (this.buildingYMod[n] >= this.buildingImage[n].getHeight()) {
                    ++this.temp;
                }
                ++n;
            }
            if (this.temp >= this.numBuildings) {
                this.loadLevel(this.currentLevel++);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Checking for end of level");
        }
    }

    public void updateSoldiers() {
        int n = this.soldierData.length - 1;
        while (n >= 0) {
            switch (this.soldierData[n][3]) {
                case 1: {
                    if (this.projectileData[n][4] <= 100 / this.gameSpeed) break;
                    this.soldierData[n][3] = 0;
                    break;
                }
                case 2: {
                    int[] nArray = this.soldierData[n];
                    nArray[4] = nArray[4] + this.gameSpeed / 2;
                    if (this.soldierData[n][4] <= 10 * this.gameSpeed) break;
                    this.initSoldier(n);
                    break;
                }
                case 0: {
                    this.temp = this.random.nextInt();
                    if (this.temp < 0) {
                        this.temp = -this.temp;
                    }
                    if (this.temp % (this.gameSpeed * 2) != 0 || !this.soldierReadyToAttack(n)) break;
                    this.soldierAttack(n);
                    this.soldierData[n][3] = 1;
                    break;
                }
                default: {
                    int[] nArray = this.soldierData[n];
                    nArray[3] = nArray[3] - this.gameSpeed;
                    if (nArray[3] >= 3) break;
                    this.soldierData[n][3] = 0;
                }
            }
            if (this.projectileData[n][4] > 1) {
                int[] nArray = this.projectileData[n];
                nArray[4] = nArray[4] + 1;
            }
            if (this.soldierAttackHitsPlayer(n)) {
                this.projectileData[n][0] = 0;
                this.projectileData[n][1] = 0;
                this.projectileData[n][2] = 0;
                this.projectileData[n][2] = 0;
                --this.playerHealth;
                this.updateEndGameCheck();
            }
            --n;
        }
    }

    public void updatePlayerAttacks() {
        int n = this.numBuildings - 1;
        while (n >= 0) {
            this.temp = (this.buildingData[n][0] + 2) * 10;
            if (this.buildingYMod[n] > 0 && this.buildingYMod[n] <= this.buildingImage[n].getHeight()) {
                int n2 = n;
                this.buildingYMod[n2] = this.buildingYMod[n2] + this.gameSpeed;
            }
            --n;
        }
        if (this.playerPunch) {
            if (this.playerTimeSinceLastPunch == 0) {
                this.buildingDamage(this.playerXPos + 19 * this.dir, this.playerYPos + 6, false);
            }
            if (++this.playerTimeSinceLastPunch >= 12 / this.gameSpeed) {
                this.playerPunch = false;
                this.playerTimeSinceLastPunch = 0;
            }
        }
    }

    private void buildingDamage(int n, int n2, boolean bl) {
        if (bl) {
            int n3 = 0;
            while (n3 < this.buildingData[this.currentBuilding][1]) {
                this.temp = GROUND_HEIGHT - n3 * 10 - 5;
                if (n2 >= this.temp - 10 && n2 < this.temp) {
                    int n4 = 0;
                    while (n4 < this.buildingData[this.currentBuilding][0]) {
                        this.temp = this.buildingData[this.currentBuilding][2] + n4 * 10;
                        if (n >= this.temp && n <= this.temp + 10) {
                            int[] nArray = this.buildingDamageData[this.currentBuilding][n4];
                            int n5 = n3;
                            nArray[n5] = nArray[n5] + 1;
                            int n6 = 0;
                            while (n6 < this.soldierData.length) {
                                if (this.soldierCollision(n6, this.currentBuilding, n4, n3) && this.soldierData[n6][3] < 2) {
                                    this.soldierDestroyed(n6, 5);
                                }
                                ++n6;
                            }
                            switch (this.buildingDamageData[this.currentBuilding][n4][n3]) {
                                case 3: 
                                case 6: 
                                case 9: 
                                case 12: {
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4 + 1][n3] < 2) {
                                            int[] nArray2 = this.buildingDamageData[this.currentBuilding][n4 + 1];
                                            int n7 = n3;
                                            nArray2[n7] = nArray2[n7] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4 - 1][n3] < 2) {
                                            int[] nArray3 = this.buildingDamageData[this.currentBuilding][n4 - 1];
                                            int n8 = n3;
                                            nArray3[n8] = nArray3[n8] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        int n9 = 0;
                                        while (n9 < this.soldierData.length) {
                                            if ((this.soldierCollision(n9, this.currentBuilding, n4 - 1, n3) || this.soldierCollision(n9, this.currentBuilding, n4 + 1, n3)) && this.soldierData[n9][3] < 2) {
                                                this.soldierDestroyed(n9, 2);
                                            }
                                            ++n9;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                                    break;
                                }
                                case 4: 
                                case 7: 
                                case 10: 
                                case 13: {
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4][n3 + 1] < 2) {
                                            int[] nArray4 = this.buildingDamageData[this.currentBuilding][n4];
                                            int n10 = n3 + 1;
                                            nArray4[n10] = nArray4[n10] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4][n3 - 1] < 2) {
                                            int[] nArray5 = this.buildingDamageData[this.currentBuilding][n4];
                                            int n11 = n3 - 1;
                                            nArray5[n11] = nArray5[n11] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        int n12 = 0;
                                        while (n12 < this.soldierData.length) {
                                            if ((this.soldierCollision(n12, this.currentBuilding, n4, n3 - 1) || this.soldierCollision(n12, this.currentBuilding, n4, n3 + 1)) && this.soldierData[n12][3] < 2) {
                                                this.soldierDestroyed(n12, 2);
                                            }
                                            ++n12;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                                    break;
                                }
                                case 5: 
                                case 8: 
                                case 11: 
                                case 14: {
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4 + 1][n3 + 1] < 1) {
                                            int[] nArray6 = this.buildingDamageData[this.currentBuilding][n4 + 1];
                                            int n13 = n3 + 1;
                                            nArray6[n13] = nArray6[n13] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4 - 1][n3 - 1] < 1) {
                                            int[] nArray7 = this.buildingDamageData[this.currentBuilding][n4 - 1];
                                            int n14 = n3 - 1;
                                            nArray7[n14] = nArray7[n14] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4 - 1][n3 + 1] < 1) {
                                            int[] nArray8 = this.buildingDamageData[this.currentBuilding][n4 - 1];
                                            int n15 = n3 + 1;
                                            nArray8[n15] = nArray8[n15] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        if (this.buildingDamageData[this.currentBuilding][n4 + 1][n3 - 1] < 1) {
                                            int[] nArray9 = this.buildingDamageData[this.currentBuilding][n4 + 1];
                                            int n16 = n3 - 1;
                                            nArray9[n16] = nArray9[n16] + 1;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                    try {
                                        int n17 = 0;
                                        while (n17 < this.soldierData.length) {
                                            if ((this.soldierCollision(n17, this.currentBuilding, n4 - 1, n3 - 1) || this.soldierCollision(n17, this.currentBuilding, n4 - 1, n3 + 1) || this.soldierCollision(n17, this.currentBuilding, n4 + 1, n3 + 1) || this.soldierCollision(n17, this.currentBuilding, n4 + 1, n3 - 1)) && this.soldierData[n17][3] < 2) {
                                                this.soldierDestroyed(n17, 1);
                                            }
                                            ++n17;
                                        }
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                                    break;
                                }
                            }
                            if (this.buildingDestroyed(this.currentBuilding)) {
                                int n18 = this.currentBuilding;
                                this.buildingYMod[n18] = this.buildingYMod[n18] + this.gameSpeed;
                                this.currentScore += this.buildingData[this.currentBuilding][0] * this.buildingData[this.currentBuilding][1];
                                int n19 = this.soldierData.length - 1;
                                while (n19 >= 0) {
                                    if (this.soldierData[n19][0] == this.currentBuilding) {
                                        this.initSoldier(n19);
                                    }
                                    --n19;
                                }
                            }
                            this.drawBuilding(this.buildingImage[this.currentBuilding].getGraphics(), this.currentBuilding, 0, this.buildingImage[this.currentBuilding].getHeight());
                            return;
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        } else {
            int n20 = this.numBuildings - 1;
            while (n20 >= 0) {
                if (this.buildingYMod[n20] == 0 && n >= this.buildingData[n20][2] - this.gameSpeed && n <= this.buildingData[n20][2] + this.gameSpeed + this.buildingData[n20][0] * 10) {
                    this.currentBuilding = n20;
                    this.buildingDamage(n, n2, true);
                    return;
                }
                --n20;
            }
        }
    }

    private boolean buildingDestroyed(int n) {
        this.temp = 0;
        int n2 = this.buildingData[n][0] - 1;
        while (n2 >= 0) {
            int n3 = this.buildingData[n][1] - 1;
            while (n3 >= 0) {
                this.temp += this.buildingDamageData[n][n2][n3];
                --n3;
            }
            --n2;
        }
        return this.temp > this.buildingData[n][0] * this.buildingData[n][1];
    }

    private boolean soldierAttackHitsPlayer(int n) {
        this.temp = this.projectileData[n][0] + this.projectileData[n][2] * this.projectileData[n][4] / 50;
        if (this.temp <= this.playerXPos + 10 && this.temp >= this.playerXPos - 10) {
            this.temp = this.projectileData[n][1] + this.projectileData[n][3] * this.projectileData[n][4] / 50;
            if (this.temp <= this.playerYPos + 10 + 10 && this.temp >= this.playerYPos) {
                return true;
            }
        }
        return false;
    }

    private boolean soldierCollision(int n, int n2, int n3, int n4) {
        return this.soldierData[n][0] == n2 && this.soldierData[n][1] == n3 && this.soldierData[n][2] == n4;
    }

    private boolean soldierReadyToAttack(int n) {
        if (!this.soldierVisible(n)) {
            return false;
        }
        if (this.buildingYMod[this.soldierData[n][0]] > 0) {
            this.initSoldier(n);
            return false;
        }
        return true;
    }

    private boolean soldierVisible(int n) {
        this.temp = this.soldierData[n][0];
        int n2 = 0;
        int n3 = 0;
        int n4 = this.numBuildings - 1;
        while (n4 > this.temp) {
            n2 = this.buildingData[this.temp][2] + 1 + this.soldierData[n][1] * 10;
            n3 = GROUND_HEIGHT + 1 - (this.soldierData[n][2] + 1) * 10;
            if (n2 >= this.buildingData[n4][2] && n2 <= this.buildingData[n4][2] + this.buildingData[n4][0] * 10 && this.buildingYMod[n4] == 0 && n3 >= OFFSCREEN_HEIGHT - 32 + 5 - 10 * this.buildingData[n4][1]) {
                return false;
            }
            --n4;
        }
        return true;
    }

    private void soldierDestroyed(int n, int n2) {
        this.soldierData[n][3] = 2;
        this.soldierData[n][5] = n2;
        this.currentScore += n2;
        if (n2 >= 5) {
            this.playerHealth += n2;
            if (this.playerHealth > 100) {
                this.playerHealth = 100;
            }
        }
    }

    private void soldierAttack(int n) {
        this.projectileData[n][0] = this.buildingData[this.soldierData[n][0]][2] + this.soldierData[n][1] * 10 + 5;
        this.projectileData[n][1] = GROUND_HEIGHT - (this.soldierData[n][2] * 10 + 5);
        this.projectileData[n][2] = (this.playerXPos - this.projectileData[n][0]) / this.gameSpeed;
        this.projectileData[n][3] = (this.playerYPos + 10 - this.projectileData[n][1]) / this.gameSpeed;
        this.temp = SquareRoot.squareRootOf(this.projectileData[n][2] * this.projectileData[n][2] + this.projectileData[n][3] * this.projectileData[n][3]);
        int[] nArray = this.projectileData[n];
        nArray[2] = nArray[2] * (50 * this.gameSpeed / this.temp);
        int[] nArray2 = this.projectileData[n];
        nArray2[3] = nArray2[3] * (50 * this.gameSpeed / this.temp);
        this.projectileData[n][4] = 2;
    }

    public void updatePlayerPosition() {
        int n;
        if (this.playerClimb) {
            if (this.buildingYMod[this.currentBuilding] > 0) {
                this.playerClimb = false;
                this.playerJump = true;
                this.playerYSpeed = this.gameSpeed * -3;
                this.playerDirection = this.playerDirection == 1 ? 0 : 1;
                return;
            }
            if (this.playerYSpeed < 0) {
                this.playerYPos -= this.gameSpeed;
                if (!this.playerBelowRoofLevel(this.currentBuilding)) {
                    this.playerYSpeed = 0;
                    this.playerClimb = false;
                    this.playerXPos = this.playerDirection == 0 ? (this.playerXPos -= this.gameSpeed / 2) : (this.playerXPos += this.gameSpeed / 2);
                    this.playerYPos = OFFSCREEN_HEIGHT - 32 - this.buildingData[this.currentBuilding][1] * 10;
                    return;
                }
            } else if (this.playerYSpeed > 0) {
                this.playerYPos += this.gameSpeed;
                if (this.playerYPos >= GROUND_HEIGHT - 32) {
                    this.playerYSpeed = 0;
                    this.playerClimb = false;
                    this.playerYPos = GROUND_HEIGHT - 32;
                    this.playerXPos = this.playerDirection == 0 ? (this.playerXPos -= this.gameSpeed * 2) : (this.playerXPos += this.gameSpeed);
                    return;
                }
                n = this.numBuildings - 1;
                while (n >= 0) {
                    if (n == this.currentBuilding || this.buildingYMod[n] > 0) {
                        return;
                    }
                    if (this.playerWithinBuildingBounds(n) && this.playerAtRoofLevel(n)) {
                        this.playerYPos = this.temp;
                        this.playerYSpeed = 0;
                        this.playerXPos = this.playerDirection == 0 ? (this.playerXPos -= this.gameSpeed * 2) : (this.playerXPos += this.gameSpeed);
                        this.playerJump = false;
                        this.playerClimb = false;
                        return;
                    }
                    --n;
                }
            }
        } else if (this.playerGrab) {
            n = this.numBuildings - 1;
            while (n >= 0) {
                if (this.playerBelowRoofLevel(n)) {
                    if (this.playerWithinGrabRange(n) && this.buildingYMod[n] == 0) {
                        this.currentBuilding = n;
                        this.playerXPos = this.temp;
                        this.playerYSpeed = 0;
                        this.playerJump = false;
                        this.playerClimb = true;
                        return;
                    }
                    if (this.playerWithinBuildingBounds(n) && this.buildingYMod[n] == 0) break;
                }
                --n;
            }
        }
        if (this.playerJump) {
            this.playerYPos += (this.playerYSpeed += this.gameSpeed / 2);
            if (this.playerDirection == 0) {
                this.playerXPos -= this.gameSpeed;
            }
            if (this.playerDirection == 1) {
                this.playerXPos += this.gameSpeed;
            }
            if (this.playerXPos > OFFSCREEN_WIDTH - this.gameSpeed) {
                this.playerXPos = OFFSCREEN_WIDTH - this.gameSpeed;
            }
            if (this.playerXPos < this.gameSpeed) {
                this.playerXPos = this.gameSpeed;
            }
            if (this.playerYSpeed > 0) {
                if (this.playerYPos >= GROUND_HEIGHT - 32) {
                    this.playerYPos = GROUND_HEIGHT - 32;
                    this.playerYSpeed = 0;
                    this.playerJump = false;
                    return;
                }
                n = this.numBuildings - 1;
                while (n >= 0) {
                    if (this.playerWithinBuildingBounds(n) && this.playerAtRoofLevel(n) && this.buildingYMod[n] == 0) {
                        this.playerYPos = this.temp;
                        this.playerYSpeed = 0;
                        this.playerJump = false;
                        return;
                    }
                    if (this.playerWithinBuildingBounds(n) && this.playerBelowRoofLevel(n) && this.buildingYMod[n] == 0) {
                        return;
                    }
                    --n;
                }
            }
        } else if (this.playerMove) {
            if (this.playerYSpeed == 0 && this.playerYPos != GROUND_HEIGHT - 32) {
                this.goingToFall = true;
                n = this.numBuildings - 1;
                while (n >= 0) {
                    if (this.buildingYMod[n] == 0 && this.playerAtRoofLevel(n) && this.playerWithinBuildingBounds(n)) {
                        if (this.playerDirection == 0) {
                            this.playerXPos -= this.gameSpeed;
                        }
                        if (this.playerDirection == 1) {
                            this.playerXPos += this.gameSpeed;
                        }
                        if (this.playerXPos > OFFSCREEN_WIDTH - this.gameSpeed) {
                            this.playerXPos = OFFSCREEN_WIDTH - this.gameSpeed;
                        }
                        if (this.playerXPos < this.gameSpeed) {
                            this.playerXPos = this.gameSpeed;
                        }
                        this.goingToFall = false;
                        return;
                    }
                    if (this.playerBelowRoofLevel(n) && this.playerWithinBuildingBounds(n) && this.buildingYMod[n] == 0) {
                        this.currentBuilding = n;
                        this.playerXPos = this.playerDirection == 0 ? this.buildingData[n][2] + this.gameSpeed + this.buildingData[n][0] * 10 : this.buildingData[n][2] - this.gameSpeed;
                        this.playerMove = false;
                        this.playerClimb = true;
                        return;
                    }
                    --n;
                }
                if (this.goingToFall) {
                    this.playerGrab = true;
                    this.playerJump = true;
                    this.playerYPos += (this.playerYSpeed += this.gameSpeed / 2);
                    return;
                }
            } else {
                if (this.playerDirection == 0) {
                    this.playerXPos -= this.gameSpeed;
                }
                if (this.playerDirection == 1) {
                    this.playerXPos += this.gameSpeed;
                }
                if (this.playerXPos > OFFSCREEN_WIDTH - this.gameSpeed) {
                    this.playerXPos = OFFSCREEN_WIDTH - this.gameSpeed;
                }
                if (this.playerXPos < this.gameSpeed) {
                    this.playerXPos = this.gameSpeed;
                }
            }
        }
    }

    private boolean playerWithinBuildingBounds(int n) {
        return this.playerXPos >= this.buildingData[n][2] - this.gameSpeed && this.playerXPos <= this.buildingData[n][2] + this.gameSpeed + this.buildingData[n][0] * 10;
    }

    private boolean playerWithinGrabRange(int n) {
        this.temp = this.playerDirection == 1 ? this.buildingData[n][2] - this.gameSpeed : this.buildingData[n][2] + this.buildingData[n][0] * 10 + this.gameSpeed;
        return this.playerXPos >= this.temp - this.gameSpeed && this.playerXPos < this.temp + this.gameSpeed;
    }

    private boolean playerAtRoofLevel(int n) {
        this.temp = OFFSCREEN_HEIGHT - 32 - this.buildingData[n][1] * 10;
        if (this.playerYPos >= this.temp - this.playerYSpeed * 2 && this.playerYPos <= this.temp + this.playerYSpeed * 2) {
            return true;
        }
        if (this.playerYPos == OFFSCREEN_HEIGHT - 32 - this.buildingData[n][1] * 10) {
            this.temp = OFFSCREEN_HEIGHT - 32 - this.buildingData[n][1] * 10;
            return true;
        }
        return false;
    }

    private boolean playerBelowRoofLevel(int n) {
        return this.playerYPos >= OFFSCREEN_HEIGHT - 32 + 5 - 10 * this.buildingData[n][1];
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.menu) {
            this.toggleMenu();
            return;
        }
        if (command == this.pause) {
            this.paused = !this.paused;
            return;
        }
    }

    public void toggleMenu() {
        this.paused = true;
        this.parent.showMenu();
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 8 && !this.playerPunch) {
            this.playerPunch = true;
            return;
        }
        if (this.playerClimb) {
            if (this.getGameAction(n) == 2 && this.playerDirection == 0 || this.getGameAction(n) == 5 && this.playerDirection == 1 || this.getGameAction(n) == 1) {
                this.playerYSpeed = -this.gameSpeed;
            } else if (this.getGameAction(n) == 6) {
                this.playerYSpeed = this.gameSpeed;
            } else if (this.playerDirection == 0 && this.getGameAction(n) == 5 || this.playerDirection == 1 && this.getGameAction(n) == 2) {
                this.playerClimb = false;
                this.playerGrab = true;
                this.playerJump = true;
                this.playerYSpeed = this.gameSpeed * -3;
                this.playerDirection = this.playerDirection == 1 ? 0 : 1;
            }
            return;
        }
        switch (this.getGameAction(n)) {
            case 1: {
                this.playerGrab = true;
                if (this.playerJump) break;
                this.playerJump = true;
                this.playerYSpeed = this.gameSpeed * -3;
                break;
            }
            case 2: {
                this.playerMove = true;
                this.playerDirection = 0;
                break;
            }
            case 5: {
                this.playerMove = true;
                this.playerDirection = 1;
                break;
            }
        }
    }

    protected void keyReleased(int n) {
        if (this.playerClimb) {
            if (this.getGameAction(n) == 1 || this.getGameAction(n) == 6) {
                this.playerYSpeed = 0;
            }
        } else {
            if (this.getGameAction(n) != 8) {
                this.playerGrab = false;
            }
            switch (this.getGameAction(n)) {
                case 2: {
                    if (this.playerDirection != 0) break;
                    this.playerMove = false;
                    break;
                }
                case 5: {
                    if (this.playerDirection != 1) break;
                    this.playerMove = false;
                }
            }
        }
    }

    protected void paint(Graphics graphics) {
        try {
            Graphics graphics2 = graphics;
            if (this.screenBuffer != null) {
                graphics = this.screenBuffer.getGraphics();
            }
            this.drawBackground(graphics);
            int n = 0;
            while (n < this.numBuildings) {
                this.drawBuildingImage(graphics, n);
                this.drawSoldiersOnBuilding(graphics, n);
                ++n;
            }
            this.drawForeground(graphics);
            this.drawPlayer(graphics, this.playerXPos, this.playerYPos);
            int n2 = 0;
            while (n2 < this.numBuildings * 2) {
                this.drawSoldierProjectile(graphics, n2);
                ++n2;
            }
            if (graphics != graphics2) {
                this.screenXClip = SCREEN_WIDTH / 2 - this.playerXPos;
                if (this.screenXClip > 0) {
                    this.screenXClip = 0;
                }
                if (this.screenXClip < SCREEN_WIDTH - OFFSCREEN_WIDTH) {
                    this.screenXClip = SCREEN_WIDTH - OFFSCREEN_WIDTH;
                }
                this.screenYClip = SCREEN_HEIGHT / 2 - this.playerYPos;
                if (this.screenYClip < SCREEN_HEIGHT - OFFSCREEN_HEIGHT) {
                    this.screenYClip = SCREEN_HEIGHT - OFFSCREEN_HEIGHT;
                }
                if (this.screenYClip > 0) {
                    this.screenYClip = 0;
                }
                graphics2.drawImage(this.screenBuffer, this.screenXClip, this.screenYClip, 20);
                this.drawStatus(graphics2);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Repainting the screen!");
        }
    }

    protected void drawPlayer(Graphics graphics, int n, int n2) {
        if (this.playerDirection == 1) {
            this.dir = 1;
        }
        if (this.playerDirection == 0) {
            this.dir = -1;
        }
        try {
            if (this.playerMove || this.playerGrab) {
                graphics.drawImage(this.backArmNormal[this.playerDirection], n + 5 * this.dir, n2 + 12 - this.playerStep * this.gameSpeed / 4 % 2, 17);
            }
            graphics.drawImage(this.torso[this.playerDirection], n, n2 + 10, 17);
            if (this.playerJump) {
                graphics.drawImage(this.legsJumping[this.playerDirection], n + 2 * this.dir, n2 + 15, 17);
            } else if (this.playerClimb) {
                if (this.playerStep * this.gameSpeed / 4 % 2 == 0) {
                    graphics.drawImage(this.legsJumping[this.playerDirection], n + 2 * this.dir, n2 + 15, 17);
                } else {
                    graphics.drawImage(this.legsClimbing[this.playerDirection], n + 2 * this.dir, n2 + 15, 17);
                }
            } else {
                switch (this.playerStep * this.gameSpeed / 4 % 3) {
                    case 0: {
                        graphics.drawImage(this.legsForward[this.playerDirection], n, n2 + 15, 17);
                        break;
                    }
                    case 1: {
                        graphics.drawImage(this.legsMid[this.playerDirection], n, n2 + 16, 17);
                        break;
                    }
                    case 2: {
                        graphics.drawImage(this.legsBack[this.playerDirection], n, n2 + 15, 17);
                        break;
                    }
                }
            }
            graphics.drawImage(this.head[this.playerDirection], n + 4 * this.dir, n2 - 1, 17);
            if (this.playerPunch) {
                graphics.drawImage(this.frontArmPunch[this.playerDirection], n + 8 * this.dir, n2 + 6, 17);
            } else {
                graphics.drawImage(this.frontArmNormal[this.playerDirection], n - 3 * this.dir, n2 + 4 + this.playerStep * this.gameSpeed / 4 % 2, 17);
            }
        }
        catch (Exception exception) {
            System.out.println("Error: drawing images - " + exception.toString());
        }
        if ((this.playerMove || this.playerClimb && this.playerYSpeed != 0) && !this.playerJump) {
            ++this.playerStep;
        }
    }

    protected void drawStatus(Graphics graphics) {
        String string = "L" + this.currentLevel + ": " + this.currentScore * 10 + "pts " + "Life:" + this.playerHealth + "%";
        graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
        graphics.setColor(0);
        graphics.fillRoundRect(-4, -4, graphics.getFont().stringWidth(string) + 8, graphics.getFont().getHeight() + 8, 4, 4);
        graphics.setColor(0x99CC99);
        graphics.drawString(string, 2, 2, 20);
    }

    protected void drawSoldier(Graphics graphics, int n, int n2) {
        int n3 = GROUND_HEIGHT + 1 - (this.soldierData[n][2] + 1) * 10;
        int n4 = this.buildingData[n2][2] + 1 + this.soldierData[n][1] * 10;
        if (this.soldierData[n][4] > 0) {
            graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
            if (this.soldierData[n][4] > this.gameSpeed * 8) {
                graphics.setColor(0x6699CC);
            } else if (this.soldierData[n][4] > this.gameSpeed * 4) {
                graphics.setColor(0x336699);
            } else {
                graphics.setColor(13158);
            }
            graphics.drawString(this.soldierData[n][5] + "0", n4 + 5, n3 - this.soldierData[n][4], 17);
        } else {
            try {
                graphics.drawImage(this.soldier, n4, n3, 20);
            }
            catch (Exception exception) {
                System.out.println("Error: Drawing a soldier image");
            }
            int n5 = (n4 += 3) > this.playerXPos ? -4 : (n4 == this.playerXPos ? 0 : 4);
            int n6 = n3 - 10 > this.playerYPos ? -4 : ((n3 += 4) - 10 == this.playerYPos ? 0 : 4);
            graphics.setColor(0x333333);
            graphics.drawLine(n4, n3, n4 + n5, n3 + n6);
            graphics.drawLine(n4, n3, n4 + n5, n3 + 1 + n6);
            graphics.drawLine(n4, n3, n4 + 1 + n5, n3 + n6);
            graphics.drawLine(n4, n3, n4 + 1 + n5, n3 + 1 + n6);
        }
    }

    protected void drawSoldierProjectile(Graphics graphics, int n) {
        if (this.projectileData[n][2] != 0 && this.projectileData[n][3] != 0) {
            int n2 = this.projectileData[n][0] + this.projectileData[n][2] * (this.projectileData[n][4] - 1) / 50;
            int n3 = this.projectileData[n][0] + this.projectileData[n][2] * this.projectileData[n][4] / 50;
            int n4 = this.projectileData[n][1] + this.projectileData[n][3] * (this.projectileData[n][4] - 1) / 50;
            int n5 = this.projectileData[n][1] + this.projectileData[n][3] * this.projectileData[n][4] / 50;
            graphics.setColor(0);
            graphics.drawLine(n2 + 1, n4, n3 + 1, n5);
            graphics.drawLine(n2, n4 + 1, n3, n5 + 1);
            graphics.drawLine(n2 + 1, n4 + 1, n3 + 1, n5 + 1);
            graphics.drawLine(n2 - 1, n4, n3 - 1, n5);
            graphics.drawLine(n2, n4 - 1, n3, n5 - 1);
            graphics.drawLine(n2 - 1, n4 - 1, n3 - 1, n5 - 1);
            graphics.setColor(0xFFCC99);
            graphics.drawLine(n2, n4, n3, n5);
        }
    }

    protected void drawSoldiersOnBuilding(Graphics graphics, int n) {
        if (this.buildingYMod[n] != 0) {
            return;
        }
        int n2 = this.soldierData.length - 1;
        while (n2 >= 0) {
            if (this.soldierData[n2][0] == n && this.soldierData[n2][3] < 10) {
                this.drawSoldier(graphics, n2, n);
            }
            --n2;
        }
    }

    protected void drawBuildingImage(Graphics graphics, int n) {
        graphics.drawImage(this.buildingImage[n], this.buildingData[n][2], GROUND_HEIGHT + this.buildingYMod[n] - this.buildingImage[n].getHeight(), 20);
        if (this.buildingYMod[n] > 0 && this.buildingYMod[n] <= this.buildingImage[n].getHeight()) {
            int n2 = 0;
            while (n2 < this.buildingData[n][0]) {
                graphics.drawImage(this.smoke[(this.counter / 2 + n2) % 2], this.buildingData[n][2] + n2 * 10, GROUND_HEIGHT - 10, 20);
                ++n2;
            }
        }
    }

    protected void drawBuilding(Graphics graphics, int n, int n2, int n3) {
        this.temp = 1 + (1 + this.buildingData[n][1]) * 10;
        if (this.buildingYMod[n] >= this.temp) {
            return;
        }
        graphics.setColor(this.buildingColours[this.buildingData[n][3]]);
        int n4 = 0;
        while (n4 < this.buildingData[n][0]) {
            int n5 = 0;
            while (n5 < this.buildingData[n][1]) {
                if (n5 < this.buildingData[n][1] - 1) {
                    graphics.fillRect(n2 + n4 * 10, n3 - (n5 + 1) * 10, 10, 10);
                } else {
                    graphics.fillRect(n2 + n4 * 10, n3 - (n5 + 1) * 10 + 1 + 6, 10, 3);
                }
                if (n5 > 0) {
                    if (n5 < this.buildingData[n][1] - 1) {
                        switch (this.buildingDamageData[n][n4][n5]) {
                            case 0: {
                                graphics.drawImage(this.window, 1 + n2 + n4 * 10, 1 + n3 - (n5 + 1) * 10, 20);
                                break;
                            }
                            case 1: {
                                graphics.drawImage(this.window, 1 + n2 + n4 * 10, 1 + n3 - (n5 + 1) * 10, 20);
                                graphics.drawImage(this.damage[0], 1 + n2 + n4 * 10, 1 + n3 - (n5 + 1) * 10, 20);
                                break;
                            }
                            case 2: {
                                graphics.drawImage(this.damage[1], 1 + n2 + n4 * 10, 1 + n3 - (n5 + 1) * 10, 20);
                                break;
                            }
                            default: {
                                graphics.drawImage(this.damage[2], n2 + n4 * 10, 1 + n3 - (n5 + 1) * 10, 20);
                                break;
                            }
                        }
                    }
                } else if (n4 == 1) {
                    graphics.drawImage(this.door, n2 + n4 * 10, 1 + n3 - (n5 + 1) * 10, 20);
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected void drawBackground(Graphics graphics) {
        graphics.setColor(0x99EEFF);
        graphics.fillRect(0, 0, OFFSCREEN_WIDTH, OFFSCREEN_HEIGHT / 2);
        graphics.setColor(13209);
        graphics.fillRect(0, OFFSCREEN_HEIGHT / 2, OFFSCREEN_WIDTH, OFFSCREEN_HEIGHT / 2);
        try {
            int n = 0;
            while (n <= OFFSCREEN_WIDTH) {
                graphics.drawImage(this.background, n, OFFSCREEN_WIDTH / 2, 6);
                n += this.background.getWidth();
            }
        }
        catch (Exception exception) {
            System.out.println("Error: Drawing the background image");
        }
    }

    protected void drawForeground(Graphics graphics) {
        graphics.setColor(0x999999);
        graphics.fillRect(0, GROUND_HEIGHT, OFFSCREEN_WIDTH, OFFSCREEN_HEIGHT - GROUND_HEIGHT);
    }

    class GameClock
    extends TimerTask {
        GameClock() {
        }

        public void run() {
            if (!GameCanvas.this.paused) {
                GameCanvas.this.counter++;
                GameCanvas.this.updatePlayerPosition();
                GameCanvas.this.updatePlayerAttacks();
                GameCanvas.this.updateSoldiers();
                GameCanvas.this.repaint();
                GameCanvas.this.updateNewLevelCheck();
            }
        }
    }
}

